/**
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(['./DvtToolkit', './DvtTimeAxis', './DvtOverview', './DvtTimeComponent'], function(dvt) {
  "use strict";
  // Internal use only.  All APIs and functionality are subject to change at any time.

!function(e){e.TimelineOverview=function(e,t,i){this.Init(e,t,i)},e.Obj.createSubclass(e.TimelineOverview,e.Overview),e.TimelineOverview.ENABLED_STATE="_",e.TimelineOverview.HOVER_STATE="_h",e.TimelineOverview.SELECTED_STATE="_s",e.TimelineOverview.ACTIVE_SELECTED_STATE="_as",e.TimelineOverview.BORDER_STYLE="bs",e.TimelineOverview.BORDER_COLOR="bc",e.TimelineOverview.BORDER_WIDTH="bw",e.TimelineOverview.DURATION_BORDER_STYLE="dbs",e.TimelineOverview.DURATION_BORDER_COLOR="dbc",e.TimelineOverview.DURATION_BORDER_WIDTH="dbw",e.TimelineOverview.BORDER_OFFSET="bof",e.TimelineOverview.BORDER_OPACITY="bo",e.TimelineOverview.GLOW_COLOR="gc",e.TimelineOverview.GLOW_OPACITY="go",e.TimelineOverview.FILL_COLOR="fc",e.TimelineOverview.newInstance=function(t,i,r){return new e.TimelineOverview(t,i,r)},e.TimelineOverview.prototype.Init=function(t,i,r){e.TimelineOverview.superclass.Init.call(this,t,i,r);var l=[e.ColorUtils.getPound(e.ColorUtils.getBrighter("#aadd77",.35)),"#aadd77",e.ColorUtils.getPound(e.ColorUtils.getDarker("#aadd77",.5))];e.OverviewUtils.supportsTouch()&&(l=["#aadd77"]),this._defColors=l,this._markerBorderFill=e.SolidFill.invisibleFill(),this._markerSize=12},e.Overview.prototype.initDefaults=function(){this.Defaults=new t},e.TimelineOverview.prototype.getParser=function(e){return new i(this)},e.TimelineOverview.prototype._applyParsedProperties=function(t){e.TimelineOverview.superclass._applyParsedProperties.call(this,t),this._selectionMode=t.selectionMode,this._markers=t.markers,this._seriesIds=t.seriesIds,this._defaultMarkerStyles=t.defaultMarkerStyles,this._borderStyles=l.getDefaultMarkerBorderStyles(this.Options),this._durationColors=e.CSSStyle.COLORS_ALTA,t.labelStyle&&(this._labelStyle=new e.CSSStyle(t.labelStyle));if("solid"==this.getStyle(e.TimelineOverview.ENABLED_STATE,e.TimelineOverview.BORDER_STYLE))var i=parseInt(this.getStyle(e.TimelineOverview.ENABLED_STATE,e.TimelineOverview.BORDER_OFFSET),10);else i=1;if("solid"==this.getStyle(e.TimelineOverview.ACTIVE_SELECTED_STATE,e.TimelineOverview.BORDER_STYLE))var r=parseInt(this.getStyle(e.TimelineOverview.ACTIVE_SELECTED_STATE,e.TimelineOverview.BORDER_OFFSET),10);else r=1;if("solid"==this.getStyle(e.TimelineOverview.SELECTED_STATE,e.TimelineOverview.BORDER_STYLE))var s=parseInt(this.getStyle(e.TimelineOverview.SELECTED_STATE,e.TimelineOverview.BORDER_OFFSET),10);else s=1;this.isItemSelectionEnabled()?this._markerSpacingOffset=Math.max(r,s,i,1)/2+1:this._markerSpacingOffset=1,this._defOpacity=this.isVertical()?0:.75,this._defAlphas=[this._defOpacity,this._defOpacity,this._defOpacity],this._radialFill=new e.LinearGradientFill(250,this._defColors,this._defAlphas),this._linearFill=new e.LinearGradientFill(180,this._defColors,this._defAlphas);var a=this.isVertical()?0:1;this._border=new e.Stroke("#aadd77",a)},e.TimelineOverview.prototype.getSeriesIds=function(){return null==this._seriesIds?null:this._seriesIds.split(" ")},e.TimelineOverview.prototype.isItemSelectionEnabled=function(){return"none"!=this._selectionMode},e.TimelineOverview.prototype.getDrawableById=function(t){for(var i=this.getNumChildren(),r=0;r<i;r++){var l=this.getChildAt(r);if(l&&l._node&&e.Obj.compareValues(this.getCtx(),t,l._node.getId()))return l}return null},e.TimelineOverview.prototype.getItemId=function(e){return e._node?e._node.getId():e.getId().substr(5)},e.TimelineOverview.prototype.getStyle=function(e,t){return this._borderStyles[e+t]},e.TimelineOverview.prototype.getX=function(e){return null!=e._node?e._node.getX():e.getMatrix().getTx()},e.TimelineOverview.prototype.getY=function(e){return null!=e._node?e._node.getY():e.getMatrix().getTy()},e.TimelineOverview.prototype.getScaleX=function(e){var t=e.getScaleX();return null==t&&(t=this.isVertical()?(this.Width-this.getTimeAxisWidth()-4)/2:1),t},e.TimelineOverview.prototype.getScaleY=function(e){var t=e.getScaleY();return null==t&&(t=1),t},e.TimelineOverview.prototype.renderData=function(t,i){if(e.TimelineOverview.superclass.renderData.call(this,t,i),null!=this._markers){if(this.isVertical())var r=this._yMin,l=this._yMax;else r=this._xMin,l=this._xMax;for(var s=this.calculateOptimalSize(r,l,t,i,this._markerSize),a=[],n=0;n<this._markers.length;n++){var o=this._markers[n];null==o._endTime?this.addMarker(o,s):a[a.length]=o}this.prepareDurations(a),this.addDurations(a,r,l),this._markerSize=s}},e.TimelineOverview.prototype.prepareDurations=function(e){this._maxDurationY=0;var t=null;null==this._durationColorMap&&(this._durationColorMap=new Object);for(var i=0;i<e.length;i++){var r=e[i],l=r.getId(),s=r.getSeriesId();s!=t&&(this._colorCount=0,t=s),r._durationLevel=this.calculateDurationY(r,e),null==r._durationFillColor&&(null==this._durationColorMap[l]?(this._durationColorMap[l]=this._colorCount,r._durationFillColor=this._durationColors[this._colorCount],this._colorCount++,this._colorCount==this._durationColors.length&&(this._colorCount=0)):r._durationFillColor=this._durationColors[this._durationColorMap[l]])}},e.TimelineOverview.prototype.getDurationColorMap=function(){return this._durationColorMap?this._durationColorMap:null},e.TimelineOverview.prototype.calculateOptimalSize=function(t,i,r,l,s){var a=new Object;a.max=1,a.arr=[];for(var n=this.isVertical()?l:r,o=0;o<this._markers.length;o++){var h=this._markers[o];if(null==h._endTime){if(this.calculateSize(h,t,i,n,s/2,a,l),a.max>l)break}else{var _=e.OverviewUtils.getDatePosition(t,i,h.getTime(),n);this.isHorizontalRTL()&&(_=n-_),h.setX(_)}}return a.max>l&&s>1?this.calculateOptimalSize(t,i,r,l,s-1):s},e.TimelineOverview.prototype.addMarker=function(t,i){var r="_mrk_"+t.getId(),l=t.getColor(),s=t.isGradient(),a=t.getOpacity();null==a&&0==(a=this._defOpacity)&&null!=l&&(a=1);var n=this.getScaleX(t),o=this.getScaleY(t),h=t.getShape();if(this.isVertical()){h=e.SimpleMarker.RECTANGLE;var _=2*n,d=2*o,c=t.getY()+_/2,v=t.getX()+d/2}else _=i*n,d=i*o,c=t.getX()+_/2,v=t.getY()+d/2;var u=new e.SimpleMarker(this.getCtx(),h,c,v,_,d,null,null,null,r);if(u._node=t,null==l&&a==this._defOpacity&&null==s)f=h==e.SimpleMarker.CIRCLE?this._radialFill:this._linearFill,m=this._border;else{var p=this._defColors;if(null!=l)if(e.OverviewUtils.supportsTouch())p=[l];else p=[e.ColorUtils.getBrighter(l,.5),l,e.ColorUtils.getDarker(l,.5)];var g=[a,a,a];if(null==s)if(h==e.SimpleMarker.CIRCLE)var f=new e.LinearGradientFill(250,p,g);else f=new e.LinearGradientFill(180,p,g);else f=new e.SolidFill(l,g[0]);var m=new e.Stroke(l,a)}u.setFill(f),u.setStroke(m),this.isItemSelectionEnabled()&&u.setSelectable(!0);var T=this.getNumChildren(),O=this.getChildAt(T-1);return T>this._lastChildIndex&&("tb"==O.getId()||"arr"==O.getId())?this.addChildAt(u,T-this._lastChildIndex):this.addChild(u),t.setDisplayable(u),this.applyState(u,e.TimelineOverview.ENABLED_STATE),!this.isVertical()&&h!=e.SimpleMarker.RECTANGLE&&h!=e.SimpleMarker.DIAMOND&&h!=e.SimpleMarker.TRIANGLE_UP&&h!=e.SimpleMarker.TRIANGLE_DOWN&&h!=e.SimpleMarker.PLUS||"false"==this._defaultMarkerStyles.pixelHinting||u.setPixelHinting(!0),u},e.TimelineOverview.prototype.addDurations=function(t,i,r){for(var l=this.getCtx(),s=this._maxDurationY;s>0;s--)for(var a=0;a<t.length;a++){var n=t[a];if(s==n._durationLevel){var o=e.OverviewUtils.getDatePosition(i,r,n.getTime(),this.isVertical()?this.Height:this.Width),h="_drn_"+n.getId(),_=9+5*n._durationLevel,d=e.OverviewUtils.getDatePosition(i,r,n.getEndTime(),this.isVertical()?this.Height:this.Width);if(this.isVertical())if(this.isRTL())var c=new e.Rect(l,0,o,_,d-o,h);else c=new e.Rect(l,this.Width-_,o,_,d-o,h);else c=this.isRTL()?new e.Rect(l,this.Width-d,this.Height-_-20,d-o,_,h):new e.Rect(l,o,this.Height-_-20,d-o,_,h);c.setFill(new e.SolidFill(n._durationFillColor));var v=new e.Stroke(this.getStyle(e.TimelineOverview.ENABLED_STATE,e.TimelineOverview.DURATION_BORDER_COLOR),1,1);c.setStroke(v),c.setPixelHinting(!0),c._node=n,this.addChild(c),n._durationBar=c,n._durationY=_-2}}this.removeChild(this._timeAxisTopBar),this.addChild(this._timeAxisTopBar)},e.TimelineOverview.prototype.calculateSize=function(t,i,r,l,s,a,n){var o=s*this.getScaleX(t)+this._markerSpacingOffset,h=s*this.getScaleY(t)+this._markerSpacingOffset,_=t.getTime(),d=e.OverviewUtils.getDatePosition(i,r,_,l);if(this.isHorizontalRTL()&&(d=l-d-2*o),this.isVertical()){var c=0;"solid"==this.getStyle(e.TimelineOverview.ENABLED_STATE,e.TimelineOverview.BORDER_STYLE)&&(c=parseInt(this.getStyle(e.TimelineOverview.ENABLED_STATE,e.TimelineOverview.BORDER_WIDTH),10)),v=this.isRTL()?c+4:this.Width-2*this.getScaleX(t)-c-4}else{var v=3;this.isOverviewAbove()&&(v+=this.getTimeAxisHeight());for(var u=0,p=[],g=0;g<a.arr.length;g++){var f=a.arr[g],m=f.getX(),T=this.getScaleX(f);Math.abs(d-m)<s*T+this._markerSpacingOffset+o&&p.push(f)}for(g=0;g<p.length;g++){var O=this.calculateY(p,t.getShape(),d,v,o,h,u,s,n);if(u=O.maxy,O.cy==v){v=O.cy;break}v=O.cy}}t.setX(d),t.setY(v),a.arr.push(t),u>a.max&&(a.max=u)},e.TimelineOverview.prototype.calculateY=function(t,i,r,l,s,a,n,o,h){for(var _=0;_<t.length;_++){var d=t[_],c=d.getX(),v=d.getY(),u=d.getShape(),p=this.getScaleX(d),g=this.getScaleY(d);if(i==e.SimpleMarker.CIRCLE&&u==e.SimpleMarker.CIRCLE&&s==a&&p==g)var f=Math.abs(r-c),m=o*p+this._markerSpacingOffset+s,T=Math.sqrt(m*m-f*f);else T=o*g+this._markerSpacingOffset+a;if(T>Math.abs(l-v)&&(l=v+T,n=Math.max(n,l+T),o>=1&&null!=h&&n>h))break}return{cy:l,maxy:n}},e.TimelineOverview.prototype.calculateDurationY=function(e,t){var i=t.length,r=e.getTime(),l=e._durationLevel;null==l&&(l=1);for(var s=0;s<i;s++){var a=t[s];if(a!=e){var n=a.getEndTime();if(null==n)continue;var o=a.getTime(),h=a._durationLevel;null==h&&(h=1),r>=o&&r<=n&&l==h&&(l=h+1,e._durationLevel=l,l=this.calculateDurationY(e,t))}}return l>this._maxDurationY&&(this._maxDurationY=l),l},e.TimelineOverview.prototype.HandleShapeMouseOver=function(t){var i=e.TimelineOverview.superclass.HandleShapeMouseOver.call(this,t);if(null!=i){if(null!=i._node){var r=i._node.getDescription();null!=r&&this.getCtx().getTooltipManager().showDatatip(t.pageX,t.pageY,r,"#000000")}if(this.isItemSelectionEnabled()){var l=!1;if(null!=this._selectedMarkers)for(var s=0;s<this._selectedMarkers.length;s++)if(i==this._selectedMarkers[s]){l=!0;break}if(!l){var a=this.getItemId(i),n=e.EventFactory.newTimelineOverviewEvent("highlight",a);this.dispatchEvent(n),this.highlightMarker(i)}}}},e.TimelineOverview.prototype.HandleShapeMouseOut=function(t){var i=e.TimelineOverview.superclass.HandleShapeMouseOut.call(this,t);if(null!=i&&!this.isMovable(i)){this.getCtx().getTooltipManager().hideTooltip();var r=!1;if(null!=this._selectedMarkers)for(var l=0;l<this._selectedMarkers.length;l++)if(i==this._selectedMarkers[l]){r=!0;break}if(!r){var s=this.getItemId(i),a=e.EventFactory.newTimelineOverviewEvent("unhighlight",s);this.dispatchEvent(a),this.unhighlightMarker(i)}}},e.TimelineOverview.prototype.HandleShapeClick=function(t,i,r){var l=e.TimelineOverview.superclass.HandleShapeClick.call(this,t,i,r);null!=l&&this.HandleMarkerClick(l,t.ctrlKey||t.shiftKey||e.Agent.isTouchDevice())},e.TimelineOverview.prototype.HandleMarkerClick=function(e,t){if(this.isItemSelectionEnabled()&&(this.selectItem(e,t),null!=e._node.getTime())){var i,r=this.getSlidingWindow();this.isVertical()?(i=this.getX(e)-r.getHeight()/2,this.animateSlidingWindow(null,i)):(i=this.getX(e)-r.getWidth()/2,this.animateSlidingWindow(i))}},e.TimelineOverview.prototype.highlightItem=function(e){var t=this.getDrawableById(e);null!=t&&this.highlightMarker(t)},e.TimelineOverview.prototype.unhighlightItem=function(e){var t=this.getDrawableById(e);null!=t&&this.unhighlightMarker(t)},e.TimelineOverview.prototype.highlightMarker=function(t){if(null!=this._selectedMarkers)for(var i=0;i<this._selectedMarkers.length;i++){if(t==this._selectedMarkers[i])return}this.applyState(t,e.TimelineOverview.HOVER_STATE)},e.TimelineOverview.prototype.unhighlightMarker=function(t){if(null!=this._selectedMarkers)for(var i=0;i<this._selectedMarkers.length;i++){if(t==this._selectedMarkers[i])return}this.applyState(t,e.TimelineOverview.ENABLED_STATE)},e.TimelineOverview.prototype.selSelectItem=function(e){var t=this.getDrawableById(e);null!=t&&this.addSelectedMarker(t)},e.TimelineOverview.prototype.selUnselectItem=function(e){var t=this.getDrawableById(e);null!=t&&this.removeSelectedMarker(t)},e.TimelineOverview.prototype.selectItem=function(t,i){var r=this.getItemId(t),l=e.EventFactory.newTimelineOverviewEvent("selection",r,i);this.dispatchEvent(l)},e.TimelineOverview.prototype.addSelectedMarker=function(t){null==this._selectedMarkers&&(this._selectedMarkers=[]);var i=null;this._selectedMarkers.length>0&&(i=this._selectedMarkers[this._selectedMarkers.length-1]),this._selectedMarkers.push(t),null!=i&&this.applyState(i,e.TimelineOverview.SELECTED_STATE),this.applyState(t,e.TimelineOverview.ACTIVE_SELECTED_STATE)},e.TimelineOverview.prototype.removeSelectedMarker=function(t){if(null!=this._selectedMarkers){for(var i=-1,r=0;r<this._selectedMarkers.length;r++){if(t==this._selectedMarkers[r]){i=r;break}}-1!=i&&(this.applyState(t,e.TimelineOverview.ENABLED_STATE),this._selectedMarkers.splice(i,1))}},e.TimelineOverview.prototype.removeAllSelectedMarkers=function(){if(null!=this._selectedMarkers){for(var t=0;t<this._selectedMarkers.length;t++){var i=this._selectedMarkers[t];this.applyState(i,e.TimelineOverview.ENABLED_STATE)}delete this._selectedMarkers,this._selectedMarkers=null}},e.TimelineOverview.prototype.applyState=function(t,i){if(t instanceof e.SimpleMarker){var r=!1,l=!1;if("solid"==this.getStyle(i,e.TimelineOverview.BORDER_STYLE)){r=!0;var s=this.getStyle(i,e.TimelineOverview.BORDER_COLOR);null==s&&(s="#000000");var a=this.getStyle(i,e.TimelineOverview.GLOW_COLOR);null!=a&&"none"!=a&&(l=!0)}var n=t._borderMarker,o=t._glowMarker;r||null==n?l||null==o||(this.removeChild(o),t._glowMarker=null):(this.removeChild(n),t._borderMarker=null,null!=o&&(this.removeChild(o),t._glowMarker=null));var h=t.getType();if(r){var _=parseInt(this.getStyle(i,e.TimelineOverview.BORDER_WIDTH),10),d=parseInt(this.getStyle(i,e.TimelineOverview.BORDER_OFFSET),10);if(null==n){if(h==e.SimpleMarker.CIRCLE)var c=(t.getDimensions().w+2*d)*t.getScaleX(),v=(t.getDimensions().h+2*d)*t.getScaleY(),u=this.getX(t)-d+c/2,p=this.getY(t)-d+v/2;else this.isVertical()?(c=(t.getDimensions().w+(_+1))*t.getScaleX(),v=(t.getDimensions().h+(_+1))*t.getScaleY(),u=this.getY(t)-(_+1)/2+c/2,p=this.getX(t)-(_+1)/2+v/2):(c=(t.getDimensions().w+2*d)*t.getScaleX(),v=(t.getDimensions().h+2*d)*t.getScaleY(),u=this.getX(t)-d+c/2,p=this.getY(t)-d+v/2);n=new e.SimpleMarker(this.getCtx(),h,u,p,c,v,null,null,null,t.getId()+"_border"),this.addChildAt(n,this.getChildIndex(t)),t._borderMarker=n,n.setFill(this._markerBorderFill)}var g=new e.Stroke(s,this.getStyle(i,e.TimelineOverview.BORDER_OPACITY),_);if(n.setStroke(g),!this.isVertical()&&h!=e.SimpleMarker.RECTANGLE&&h!=e.SimpleMarker.DIAMOND&&h!=e.SimpleMarker.TRIANGLE_UP&&h!=e.SimpleMarker.TRIANGLE_DOWN&&h!=e.SimpleMarker.PLUS||"false"==this._defaultMarkerStyles.pixelHinting||n.setPixelHinting(!0),l){if(null==o){var f=d-_;h==e.SimpleMarker.CIRCLE?(c=(t.getDimensions().w+2*f)*t.getScaleX(),v=(t.getDimensions().h+2*f)*t.getScaleY(),u=this.getX(t)-f+c/2,p=this.getY(t)-f+v/2):this.isVertical()?(c=(t.getDimensions().w+3)*t.getScaleX(),v=(t.getDimensions().h+3)*t.getScaleY(),u=this.getY(t)+c/2,p=this.getX(t)-1+v/2):(c=(t.getDimensions().w+2*f)*t.getScaleX(),v=(t.getDimensions().h+2*f)*t.getScaleY(),u=this.getX(t)-f+c/2,p=this.getY(t)-f+v/2),o=new e.SimpleMarker(this.getCtx(),h,u,p,c,v,null,null,null,t.getId()+"_glow"),this.addChildAt(o,this.getChildIndex(n)),t._glowMarker=o,o.setFill(this._markerBorderFill)}var m=new e.Stroke(a,this.getStyle(i,e.TimelineOverview.GLOW_OPACITY),4);o.setStroke(m),!this.isVertical()&&h!=e.SimpleMarker.RECTANGLE&&h!=e.SimpleMarker.DIAMOND&&h!=e.SimpleMarker.TRIANGLE_UP&&h!=e.SimpleMarker.TRIANGLE_DOWN&&h!=e.SimpleMarker.PLUS||"false"==this._defaultMarkerStyles.pixelHinting||o.setPixelHinting(!0)}}}else{var T=t.getId();T&&"_drn_"==T.substring(0,5)&&this.applyDurationState(t,i)}},e.TimelineOverview.prototype.applyDurationState=function(t,i){var r=this.getStyle(i,e.TimelineOverview.DURATION_BORDER_COLOR);null==r&&(r="#000000");var l=parseInt(this.getStyle(i,e.TimelineOverview.DURATION_BORDER_WIDTH),10);t.setStroke(new e.Stroke(r,1,l))},e.TimelineOverview.prototype.getAutomation=function(){return this._Automation||(this._Automation=new s(this)),this._Automation},e.TimelineOverview.prototype.getMarkers=function(){return this._markers};var t=function(){this.Init({alta:t.VERSION_1})};e.Obj.createSubclass(t,e.BaseComponentDefaults),t.VERSION_1={overviewPosition:"below",style:{borderTopStyle:"none",currentTimeIndicatorColor:"#c000d1",handleFillColor:"#ffffff",handleTextureColor:"#b3c6db",leftFilterPanelAlpha:.7,leftFilterPanelColor:"#ffffff",overviewBackgroundColor:"#e6ecf3",rightFilterPanelAlpha:.7,rightFilterPanelColor:"#ffffff",timeAxisBarColor:"#d9dfe3",timeAxisBarAlpha:0,timeIndicatorColor:"#bcc7d2",windowBackgroundAlpha:1,windowBackgroundColor:"#ffffff",windowBorderBottomColor:"#4f4f4f",windowBorderBottomStyle:"solid",windowBorderLeftColor:"#4f4f4f",windowBorderLeftStyle:"solid",windowBorderRightColor:"#4f4f4f",windowBorderRightStyle:"solid",windowBorderTopColor:"#4f4f4f",windowBorderTopStyle:"solid"},_fc:"#aadd77",_do:0,_bc:"#648baf",_bof:"0px",_bs:"solid",_bw:"1px",_dbc:"#648baf",_dbs:"solid",_dbw:"1px",_hbc:"#85bbe7",_hbs:"solid",_hbw:"2px",_hbof:"0px",_hgc:"#ebeced",_hgo:1,_hdbs:"solid",_hdbc:"#85bbe7",_hdbw:"2px",_sbs:"solid",_sbc:"#000000",_sbw:"2px",_sbof:"0px",_sbo:1,_sdbs:"solid",_sdbc:"#000000",_sdbw:"2px",_asbs:"solid",_asbc:"#000000",_asbw:"2px",_asbof:"0px",_asbo:1,_asgc:"#e4f0fa",_asgo:1,_asdbs:"solid",_asdbc:"#000000",_asdbw:"2px",_aoc:"off"};var i=function(e){this.Init(e)};e.Obj.createSubclass(i,e.OverviewParser),i.prototype.Init=function(e){this._view=e},i.prototype.parse=function(e){var t=this.ParseRootAttributes(e);return t.timeAxisInfo=this._parseTimeAxis(e.axisTicks),t.markers=this._parseDataNode(e.markers,t.defaultMarkerStyles),t.formattedTimeRanges=e.formattedTimeRanges,t},i.prototype.ParseRootAttributes=function(e){var t=i.superclass.ParseRootAttributes.call(this,e);t.currentTime=parseInt(e.ocd),t.orientation=e.orn,t.selectionMode=e.selmode,t.isRtl=e.rtl.toString(),t.seriesIds=e.sid,t.animationOnClick=e._aoc;var r=new Object;return r.shape=l.getDefaultMarkerShape(e),r.scaleX=l.getDefaultMarkerScaleX(e),r.scaleY=l.getDefaultMarkerScaleY(e),r.opacity=l.getDefaultMarkerOpacity(e),r.color=l.getDefaultMarkerFillColor(e),r.pixelHinting=l.getDefaultMarkerPixelHinting(e),t.defaultMarkerStyles=r,t.labelStyle=e._ls,t},i.prototype._parseDataNode=function(e,t){if(e){for(var i=new Array,l=0;l<e.length;l++){var s=this.ParseNodeAttributes(e[l],t),a=new r(this._view,s);i.push(a)}return i}return null},i.prototype.ParseNodeAttributes=function(e,t){var i=new Object,r="true"==e._sd;return i.id=e.tid,i.seriesId=e.sid,i.rowKey=e.rk,i.time=e.t,i.endTime=e.et,i.shape=e.s,r&&null==i.shape&&(i.shape=t.shape),i.desc=e.d,i.color=e.c,i.durationFillColor=e.dfc,r&&null==i.color&&(i.color=t.color),i.scaleX=e.sx,r&&null==i.scaleX&&(i.scaleX=t.scaleX),i.scaleY=e.sy,r&&null==i.scaleY&&(i.scaleY=t.scaleY),i.gradient=e.g,i.opacity=e.o,r&&null==i.opacity&&(i.opacity=t.opacity),i},i.prototype._parseTimeAxis=function(e){if(e){var t=new Object;return t.width=null,t.height=null,t.ticks=e,t}return null};var r=function(e,t){this.Init(e,t)};e.Obj.createSubclass(r,e.Obj),r.prototype.Init=function(t,i){this._view=t,this._rowKey=i.rowKey,this._id=i.id,this._seriesId=i.seriesId,this._time=parseInt(i.time),this._endTime=null==i.endTime?null:parseInt(i.endTime),this._shape=e.SimpleMarker.CIRCLE,"square"==i.shape?this._shape=e.SimpleMarker.RECTANGLE:"plus"==i.shape?this._shape=e.SimpleMarker.PLUS:"diamond"==i.shape?this._shape=e.SimpleMarker.DIAMOND:"triangleUp"==i.shape?this._shape=e.SimpleMarker.TRIANGLE_UP:"triangleDown"==i.shape&&(this._shape=e.SimpleMarker.TRIANGLE_DOWN),this._desc=i.desc,this._color=i.color,this._gradient=i.gradient,null!=i.opacity&&(this._opacity=parseFloat(i.opacity)),null!=i.scaleX&&(this._scaleX=parseFloat(i.scaleX)),null!=i.scaleY&&(this._scaleY=parseFloat(i.scaleY)),null!=i.durationFillColor&&(this._durationFillColor=i.durationFillColor)},r.prototype.getId=function(){return this._id},r.prototype.getSeriesId=function(){return this._seriesId},r.prototype.getRowKey=function(){return this._rowKey},r.prototype.getTime=function(){return this._time},r.prototype.getEndTime=function(){return this._endTime},r.prototype.getScaleX=function(){return this._scaleX},r.prototype.getScaleY=function(){return this._scaleY},r.prototype.getDescription=function(){return this._desc},r.prototype.getColor=function(){return this._color},r.prototype.isGradient=function(){return this._gradient},r.prototype.getShape=function(){return this._shape},r.prototype.getOpacity=function(){return this._opacity},r.prototype.getDisplayable=function(){return this._displayable},r.prototype.setDisplayable=function(e){this._displayable=e},r.prototype.getX=function(){return this._x},r.prototype.setX=function(e){this._x=e},r.prototype.getY=function(){return this._y},r.prototype.setY=function(e){this._y=e};var l=new Object;e.Obj.createSubclass(l,e.Obj),l.getDefaultMarkerShape=function(e){return e._ds},l.getDefaultMarkerScaleX=function(e){return e._dsx},l.getDefaultMarkerScaleY=function(e){return e._dsy},l.getDefaultMarkerOpacity=function(e){return e._do},l.getDefaultMarkerFillColor=function(e){return e._fc},l.getDefaultMarkerPixelHinting=function(e){return e._ph},l.getDefaultMarkerBorderStyles=function(e){var t=new Object;return t._bs=e._bs,t._bc=e._bc,t._bw=e._bw,t._bof=e._bof,t._bo=e._bo,t._gc=e._gc,t._go=e._go,t._dbs=e._dbs,t._dbc=e._dbc,t._dbw=e._dbw,t._hbs=e._hbs,t._hbc=e._hbc,t._hbw=e._hbw,t._hbof=e._hbof,t._hbo=e._hbo,t._hgc=e._hgc,t._hgo=e._hgo,t._hdbs=e._hdbs,t._hdbc=e._hdbc,t._hdbw=e._hdbw,t._sbs=e._sbs,t._sbc=e._sbc,t._sbw=e._sbw,t._sbof=e._sbof,t._sbo=e._sbo,t._sgc=e._sgc,t._sgo=e._sgo,t._sdbs=e._sdbs,t._sdbc=e._sdbc,t._sdbw=e._sdbw,t._asbs=e._asbs,t._asbc=e._asbc,t._asbw=e._asbw,t._asbof=e._asbof,t._asbo=e._asbo,t._asgc=e._asgc,t._asgo=e._asgo,t._asdbs=e._asdbs,t._asdbc=e._asdbc,t._asdbw=e._asdbw,t};var s=function(e){this._overview=e};e.Obj.createSubclass(s,e.Automation),s.NODE_ID_PREFIX="marker",s.WINDOW_ID="range_window",s.START_HANDLE_ID="range_start_handle",s.END_HANDLE_ID="range_end_handle",s.AUTOMATION_NO_EVENT=-1,s.AUTOMATION_MOUSE_CLICK=0,s.prototype.GetSubIdForDomElement=function(t){var i=t.getId();if(t instanceof e.SimpleMarker){var r=i.split(":");if(4!=r.length)return null;var l=this._overview.getSeriesIds();if(null!=l){var a=l.indexOf(r[1]);if(a>-1)return"marker["+a+"]["+r[2]+"]"}}else{if("window"==i)return s.WINDOW_ID;if("lh"==i||"lhb"==i||"lbgrh"==i)return s.START_HANDLE_ID;if("rh"==i||"rhb"==i||"rbgrh"==i)return s.END_HANDLE_ID;if("grpy"==i){var n=t.getParent().getChildBefore(t);return this.GetSubIdForDomElement(n)}}return null},s.prototype.getDomElementForSubId=function(e){var t=s._convertSubIdToArray(e);if(t&&3==t.length&&t[0]==s.NODE_ID_PREFIX){var i=this._overview.getSeriesIds();if(null!=i){var r=parseInt(t[1],10);if(r>-1&&r<i.length){var l=s._findMarker(this._overview.getMarkers(),i[r],t[2]);return l?l.getDisplayable().getElem():null}}}else{if(e==s.WINDOW_ID)return this._overview.getSlidingWindow().getElem();if(e==s.START_HANDLE_ID)return this._overview.getLeftHandle().getElem();if(e==s.END_HANDLE_ID)return this._overview.getRightHandle().getElem()}return null},s.prototype.click=function(e){this.processSubId(e,s.AUTOMATION_MOUSE_CLICK)},s.prototype.processSubId=function(e,t){if((void 0===t&&(t=s.AUTOMATION_NO_EVENT),null!=e)&&(t!=s.AUTOMATION_NO_EVENT&&t==s.AUTOMATION_MOUSE_CLICK)){var i=s._convertSubIdToArray(e);if(i&&3==i.length&&i[0]==s.NODE_ID_PREFIX){var r=s._findMarker(this._overview.getMarkers(),i[1],i[2]);r&&this._overview.HandleMarkerClick(r.getDisplayable(),!1)}}},s._convertSubIdToArray=function(e){for(var t=e.split("["),i=t.length,r=1;r<i;r++){var l=t[r],s=l.substr(0,l.length-1),a=parseFloat(s);s=isNaN(a)?s:a,t[r]=s}return t},s._findMarker=function(e,t,i){for(var r="tl1:"+t+":"+i+":",l=0;l<e.length;l++){var s=e[l],a=s.getId();if(null!=a&&0==a.indexOf(r))return s}return null}}(dvt);
!function(e){var t=new Object;t.supportsTouch=function(){return e.Agent.isTouchDevice()},e.Obj.createSubclass(t,e.Obj),t.getDatePosition=function(e,t,i,s){var r=(i-e)*s,n=t-e;return 0==r||0==n?0:r/n},t.getPositionDate=function(e,t,i,s){var r=i*(t-e);return 0==r||0==s?e:r/s+e};var i=function(e){this.Init(e)};e.Obj.createSubclass(i,e.TimeComponentKeyboardHandler),i.getNextNavigable=function(t,s,r){var n=t.getSeries(),a=t.getSeriesIndex(),o=e.Agent.isRightToLeft(n.getCtx()),l=n.isVertical(),_=r.length>1;if(!o&&e.KeyboardEvent.RIGHT_ARROW==s.keyCode||o&&e.KeyboardEvent.LEFT_ARROW==s.keyCode){if(!l)return i.getNextItem(t,r[a],!0);if(_&&1!=a)return i.getClosestItem(t,r[1])}else if(!o&&e.KeyboardEvent.LEFT_ARROW==s.keyCode||o&&e.KeyboardEvent.RIGHT_ARROW==s.keyCode){if(!l)return i.getNextItem(t,r[a],!1);if(_&&0!=a)return i.getClosestItem(t,r[0])}else if(e.KeyboardEvent.DOWN_ARROW==s.keyCode){if(l)return i.getNextItem(t,r[a],!0);if(_&&1!=a)return i.getClosestItem(t,r[1])}else if(e.KeyboardEvent.UP_ARROW==s.keyCode){if(l)return i.getNextItem(t,r[a],!1);if(_&&0!=a)return i.getClosestItem(t,r[0])}return null},i.getNextItem=function(e,t,i){var s=t.indexOf(e)+(i?1:-1);return s>=0&&s<t.length?t[s]:null},i.getClosestItem=function(e,t){if(t.length>0){for(var i=t[0],s=e.getLoc(),r=Math.abs(s-i.getLoc()),n=1;n<t.length;n++){var a=Math.abs(s-t[n].getLoc());a<r&&(r=a,i=t[n])}return i}return null};var s=function(e){s.superclass.constructor.call(this,e)};e.Obj.createSubclass(s,e.TimeComponentEventManager),s.prototype.addListeners=function(t){if(s.superclass.addListeners.call(this,t),!e.Agent.isTouchDevice()&&("ie"===e.Agent.browser||"edge"===e.Agent.browser)){var i=this.getCtx().getStage();i.addEvtListener("mouseenter",this.OnMouseEnter,!1,this),i.addEvtListener("mouseleave",this.OnMouseLeave,!1,this)}},s.prototype.RemoveListeners=function(t){if(s.superclass.RemoveListeners.call(this,t),!e.Agent.isTouchDevice()&&("ie"===e.Agent.browser||"edge"===e.Agent.browser)){var i=this.getCtx().getStage();i.removeEvtListener("mouseenter",this.OnMouseEnter,!1,this),i.removeEvtListener("mouseleave",this.OnMouseLeave,!1,this)}},s.prototype.PreOnMouseOver=function(t){this._mouseOutTimer&&this._mouseOutTimer.isRunning()&&this._mouseOutTimer.stop(),s.superclass.PreOnMouseOver.call(this,t),"ie"===e.Agent.browser||"edge"===e.Agent.browser||this.isMouseOver||(this.isMouseOver=!0)},s.prototype.OnMouseEnter=function(e){this._mouseOutTimer&&this._mouseOutTimer.isRunning()&&this._mouseOutTimer.stop(),this.isMouseOver||(this.isMouseOver=!0)},s.prototype.OnMouseLeave=function(t){this._mouseOutTimer||(this._mouseOutTimer=new e.Timer(this.getCtx(),10,this._onMouseOutTimerEnd,this,1)),this._mouseOutTimer.reset(),this._mouseOutTimer.start()},s.prototype.PreOnMouseOut=function(t){s.superclass.PreOnMouseOut.call(this,t),"ie"!==e.Agent.browser&&"edge"!==e.Agent.browser&&(this._mouseOutTimer||(this._mouseOutTimer=new e.Timer(this.getCtx(),10,this._onMouseOutTimerEnd,this,1)),this._mouseOutTimer.reset(),this._mouseOutTimer.start())},s.prototype._onMouseOutTimerEnd=function(){this.isMouseOver=!1},s.prototype.panBy=function(e,t){var i=this.getFocus();i&&(this._comp._dragPanSeries=i._series),s.superclass.panBy.call(this,e,t)},e.Timeline=function(e,t,i){this.Init(e,t,i)},e.Obj.createSubclass(e.Timeline,e.TimeComponent),e.Timeline.ORIENTATION_VERTICAL="vertical",e.Timeline.newInstance=function(t,i,s){return new e.Timeline(t,i,s)},e.Timeline.prototype.Init=function(t,r,a){e.Timeline.superclass.Init.call(this,t,r,a),this.Defaults=new n(t),this.EventManager=new s(this,t,r,a),this.EventManager.addListeners(this),e.Agent.isTouchDevice()?this._keyboardHandler=null:(this._keyboardHandler=new i(this.EventManager),this.EventManager.setKeyboardHandler(this._keyboardHandler))},e.Timeline.prototype.Parse=function(e){return this._parser=new a,this._parser.parse(e)},e.Timeline.prototype._applyParsedProperties=function(t){var i=this.Options.orientation;i&&i==e.Timeline.ORIENTATION_VERTICAL?this._isVertical=!0:this._isVertical=!1,this._hasOverview=t.hasOverview,this._viewStartTime=t.viewStart,this._viewEndTime=t.viewEnd,this._selectionMode=t.selectionMode,"single"==this._selectionMode?this.SelectionHandler=new e.SelectionHandler(this.getCtx(),e.SelectionHandler.TYPE_SINGLE):"multiple"==this._selectionMode?this.SelectionHandler=new e.SelectionHandler(this.getCtx(),e.SelectionHandler.TYPE_MULTIPLE):this.SelectionHandler=null,this.EventManager.setSelectionHandler(this.SelectionHandler),this._shortDesc=t.shortDesc,this._referenceObjects=t.referenceObjects,this._seriesScale=t.seriesScale,this._timeZoneOffsets=t.timeZoneOffsets,this._seriesScale?(this._seriesConverter=t.seriesConverter,this._seriesTimeAxis=new e.TimeAxis(this.getCtx(),null,null),this._seriesTimeAxis.setIsVertical(this._isVertical),this._seriesTimeAxis.setScale(this._seriesScale),this._seriesTimeAxis.setConverter(this._seriesConverter),this._seriesCustomFormatScales=t.seriesCustomFormatScales,this._dateFormatStrings=this._seriesTimeAxis.getDateFormatStrings(),this._isVertical?(this._seriesTimeAxis.setType("short",this._dateFormatStrings),this._seriesTimeAxis.setDefaultConverter(this._resources.converterVert)):(this._seriesTimeAxis.setType("long",this._dateFormatStrings),this._seriesTimeAxis.setDefaultConverter(this._resources.converter)),this._timeZoneOffsets&&this._seriesTimeAxis.setTimeZoneOffsets(this._timeZoneOffsets)):this._seriesTimeAxis=null,this._defaultInversions=[!1,!0],this._itemPosition=t.itemPosition,this._customTimeScales=t.customTimeScales,this._customFormatScales=t.customFormatScales,this._scale=t.scale,e.Timeline.superclass._applyParsedProperties.call(this,t)},e.Timeline.prototype.getTimeAxis=function(){return this._timeAxis},e.Timeline.prototype.getTimeAxisSize=function(){return this._timeAxis.getSize()},e.Timeline.prototype.getTimeAxisVisibleSize=function(e){return this._hasOverview||1!=e?this.getTimeAxisSize():this.getTimeAxisSize()-this._timeAxis.getBorderWidth()},e.Timeline.prototype.select=function(t){this.Options.selection=e.JsonUtils.clone(t),this.SelectionHandler&&this.applyInitialSelections()},e.Timeline.prototype._bundleTimeAxisOptions=function(e){this._timeAxisOptions={start:e.start,end:e.end,_resources:e._resources,shortDesc:e.shortDesc,_tzo:e._tzo,_ip:e._ip,_cts:this._customTimeScales,_cfs:this._customFormatScales,orientation:e.orientation};var t=this._timeAxisOptions._resources;if(t&&(t.borderTopVisible=!0,t.borderRightVisible=!0,t.borderBottomVisible=!0,t.borderLeftVisible=!0),e.styleDefaults&&e.styleDefaults.minorAxis){var i=e.styleDefaults.minorAxis;this._timeAxisOptions.backgroundColor=i.backgroundColor,this._timeAxisOptions.borderColor=i.borderColor,this._timeAxisOptions.separatorColor=i.separatorColor,this._timeAxisOptions.labelStyle=i.labelStyle}if(e.minorAxis){var s=e.minorAxis;this._timeAxisOptions.scale=s.scale,this._timeAxisOptions.converter=s.converter,this._timeAxisOptions.zoomOrder=s.zoomOrder,this._timeAxisOptions.style=s.style,s.svgStyle&&(this._timeAxisOptions.style=s.svgStyle)}},e.Timeline.prototype.render=function(t,i,s){if(t){this.SetOptions(t),this.StopAnimation(),this.Options&&(this._resources=this.Options._resources,null==this._resources&&(this._resources=[])),this.Width=i,this.Height=s;var r=this.Parse(this.Options);if(this._applyParsedProperties(r),this._fetchStartPos=0,this._isVertical?this._fetchEndPos=s:this._fetchEndPos=i,this.Options.styleDefaults&&(this._majorAxisStyleDefaults=this.Options.styleDefaults.majorAxis,this._seriesStyleDefaults=this.Options.styleDefaults.series),this._scale){this._bundleTimeAxisOptions(this.Options),this.applyAxisStyleValues(),this._timeAxis||(this._timeAxis=new e.TimeAxis(this.getCtx(),null,null)),this._isVertical?this._timeAxis.setBorderVisibility(!1,!0,!1,!0):this._timeAxis.setBorderVisibility(!0,!1,!0,!1),this._timeAxis.setCanvasSize(null);var n=this._timeAxis.getPreferredLength(this._timeAxisOptions,this._canvasLength);n&&this.setContentLength(n),this._timeAxis.hasValidOptions()&&this.prepareViewportLength()}this._populateSeries(),o.renderTimeline(this),this.UpdateAriaAttributes(),e.TimeAxis.supportsTouch()||this.getCtx().setKeyboardFocusArray([this]),this.Animation||this.RenderComplete()}else this._handleResize(i,s)},e.Timeline.prototype.hasValidSeriesItems=function(){for(var e=0;e<this._seriesOptions.length;e++){var t=this._seriesOptions[e];if(t.items)for(var i=0;i<t.items.length;i++){var s=t.items[i],r=new Date(s.start).getTime();if(!r)return!1;if(s.hasOwnProperty("end")){var n=new Date(s.end).getTime();if(!isNaN(n)&&n<r)return!1}}}return!0},e.Timeline.prototype.hasValidOptions=function(){var t=this._scale&&-1!=e.TimeAxis._VALID_SCALES.indexOf(this._scale),i=this._scale&&this._customTimeScales&&this._customTimeScales[this._scale],s=this._start&&this._end&&this._end>this._start,r=this._series&&this._series.length>0,n=!!r&&this.hasValidSeriesItems(),a=!this._seriesScale||-1!=e.TimeAxis._VALID_SCALES.indexOf(this._seriesScale),o=!this._seriesScale||this._customTimeScales&&this._customTimeScales[this._seriesScale],l=!this._viewStartTime||!this._viewEndTime||this._viewEndTime>this._viewStartTime,_=!this._viewStartTime||this._viewStartTime>=this._start&&this._viewStartTime<this._end,h=!this._viewEndTime||this._viewEndTime>this._start&&this._viewEndTime<=this._end;return(t||i)&&(a||o)&&s&&r&&n&&l&&_&&h},e.Timeline.prototype.GetComponentDescription=function(){return this._shortDesc?this._shortDesc:this.Options.translations.componentName},e.Timeline.prototype.applyStyleValues=function(){if(this._style=new e.CSSStyle(l.getTimelineStyle()),this.Options.styleDefaults){var t=this.Options.styleDefaults.borderColor;t&&this._style.parseInlineStyle("border-color:"+t+";")}if(this._hasOverview){this._overviewSize=this._isVertical?l.getOverviewWidth():l.getOverviewHeight();var i=this.Options.overview,s=i.svgStyle?i.svgStyle:i.style;if(s){var r=new e.CSSStyle(s),n=this._isVertical?r.getWidth():r.getHeight();null!=n&&(this._overviewSize=e.CSSStyle.toNumber(n))}}e.Timeline.superclass.applyStyleValues.call(this);var a=this._style.getBorderWidth(),o=2*a,_="border:"+o+"px;";this._style.parseInlineStyle(_),this.setStartXOffset(a),this.setStartYOffset(a),this.setBackgroundXOffset(0);var h=3*this.getScrollbarPadding();this.timeDirScrollbarStyles=this.getTimeDirScrollbarStyle(),this.contentDirScrollbarStyles=this.getContentDirScrollbarStyle(),this._backgroundWidth=this.Width,this._backgroundHeight=this.Height,this._isVertical?(this.isContentDirScrollbarOn()&&(this._backgroundHeight=this._backgroundHeight-e.CSSStyle.toNumber(this.contentDirScrollbarStyles.getHeight())-h),this._canvasLength=this._backgroundHeight-o,this._hasOverview?(this._canvasSize=this._backgroundWidth-this._overviewSize-o,this.isRTL()&&this.setStartXOffset(a+this._overviewSize)):(this.isTimeDirScrollbarOn()&&(this._backgroundWidth=this._backgroundWidth-e.CSSStyle.toNumber(this.timeDirScrollbarStyles.getWidth())-h),this._canvasSize=this._backgroundWidth-o,this.isRTL()&&(this.setBackgroundXOffset(this.Width-this._backgroundWidth),this.setStartXOffset(this.getStartXOffset()+this.getBackgroundXOffset())))):(this.isContentDirScrollbarOn()&&(this._backgroundWidth=this._backgroundWidth-e.CSSStyle.toNumber(this.contentDirScrollbarStyles.getWidth())-h),this._canvasLength=this._backgroundWidth-o,this.isRTL()&&(this.setBackgroundXOffset(this.Width-this._backgroundWidth),this.setStartXOffset(this.getStartXOffset()+this.getBackgroundXOffset())),this._hasOverview?this._canvasSize=this._backgroundHeight-this._overviewSize-o:(this.isTimeDirScrollbarOn()&&(this._backgroundHeight=this._backgroundHeight-e.CSSStyle.toNumber(this.timeDirScrollbarStyles.getHeight())-h),this._canvasSize=this._backgroundHeight-o))},e.Timeline.prototype.applyAxisStyleValues=function(){if(this._seriesStyleDefaults&&this._seriesStyleDefaults.backgroundColor){var t=this._seriesStyleDefaults.backgroundColor,i=e.ColorUtils.getRed(t),s=e.ColorUtils.getGreen(t),r=e.ColorUtils.getBlue(t);this._seriesBackgroundOverlayStyle="background-color:rgba("+i+","+s+","+r+",0.8);"}},e.Timeline.prototype._populateSeries=function(){var e=this.Options.series;if(e){var t=Math.min(e.length,2);if(this._seriesOptions=[],this._series){if(t!=this._series.length){for(var i=0;i<this._series.length;i++)this._timeZoomCanvas.removeChild(this._series[i]);this._series=[]}}else this._series=[];for(i=0;i<t;i++){var s=e[i];if(s.start=this._start,s.end=this._end,s.inverted=this._defaultInversions[i],s.orientation=this.Options.orientation,s.referenceObjects=this._referenceObjects,s.timeline=this,s.index=i,s.animationOnDisplay=this.Options.animationOnDisplay,s.animationOnDataChange=this.Options.animationOnDataChange,this.Options.majorAxis&&(s.scale=this.Options.majorAxis.scale,s.timeAxis=this._seriesTimeAxis,s._cfs=this._seriesCustomFormatScales),s.styleDefaults=this.Options.styleDefaults,this.Options.styleDefaults&&(s.seriesStyleDefaults=this._seriesStyleDefaults,s.axisStyleDefaults=this._majorAxisStyleDefaults),s._isRandomItemLayout="random"==this._itemPosition,s._cts=this.Options._cts,s._data=e[i],s.translations=this.Options.translations,this._seriesOptions.push(s),null==this._series[i]){var r=new _(this.getCtx(),this.HandleEvent,this);this._series.push(r)}}}else this._series=[]},e.Timeline.prototype.onAnimationEnd=function(){this.AnimationStopped||this.RenderComplete(),this.EventManager.addListeners(this),this.Animation=null,this.AnimationStopped=!1},e.Timeline.prototype._getOverviewObject=function(){var e=new Object;e.width=this._contentLength,e.selmode=this._selectionMode,e.rtl=this.isRTL(),e.sid="ts1";var t=l.getOverviewWindowBackgroundColor(this.Options);e._wbc=t,e._hfc=t;var i=l.getOverviewWindowBorderColor(this.Options);return e._wbtc=i,e._wbrc=i,e._wbbc=i,e._wblc=i,e._ls=l.getOverviewLabelStyle(this.Options).toString(),e._obc=l.getOverviewBackgroundColor(this.Options),e._ctic=l.getReferenceObjectColor(this.Options),this._referenceObjects&&this._referenceObjects.length>0&&this._referenceObjects[0]&&(e.ocd=this._referenceObjects[0].getTime()),this._isVertical?(e.orn="vertical",e.yMin=this._start,e.yMax=this._end,e.y1=this._viewStartTime,e.y2=this._viewEndTime):(e.orn="horizontal",e.xMin=this._start,e.xMax=this._end,e.x1=this._viewStartTime,e.x2=this._viewEndTime,e._ds="square",e._dsx="1.3d",e._dsy="0.9d"),this._resources.overviewHandleVert&&(e._vhbi=this._resources.overviewHandleVert,e._vhw=15,e._vhh=3),this._resources.overviewHandleHor&&(e._hbi=this._resources.overviewHandleHor,e._hw=3,e._hh=15),e.axisTicks=this._getOverviewAxisOptions(),e.markers=this._getOverviewMarkerOptions(),e},e.Timeline.prototype._getOverviewAxisOptions=function(){var t=[];if(this._seriesTimeAxis){var i,s;if(this._customTimeScales&&this._customTimeScales[this._seriesScale]){var r=this._customTimeScales[this._seriesScale];i=r.times,s=r.labels}else if(this._seriesCustomFormatScales&&this._seriesCustomFormatScales[this._seriesScale]){var n=this._seriesCustomFormatScales[this._seriesScale];i=n.times,s=n.labels}else{i=[],s=[];for(var a=this._start,o=this._end,l=this._isVertical?this.Height:this.Width,_=e.TimeAxis.getPositionDate(a,o,this._fetchStartPos,l),h=this._seriesTimeAxis.adjustDate(_),c=e.TimeAxis.getDatePosition(a,o,h,l);c<this._fetchEndPos;)s.push(this._seriesTimeAxis.formatDate(h)),i.push(h.getTime()),h=this._seriesTimeAxis.getNextDate(h.getTime()),c=e.TimeAxis.getDatePosition(a,o,h,l)}for(var g=0;g<s.length;g++){var u=new Object;u.time=i[g],u.label=s[g],t.push(u)}}return t},e.Timeline.prototype._getOverviewMarkerOptions=function(){if(this._series){for(var e=[],t=this._series.length,i=0;i<t;i++)for(var s=this._series[i]._items,r=0;r<s.length;r++){var n=s[r],a=new Object;a.rk=r,a.sid=i,a.tid=n.getId(),a.t=n.getStartTime(),a._sd=n.getMarkerSD(),this._isVertical||(n.getMarkerShape()&&(a.s=n.getMarkerShape()),n.getMarkerScaleX()&&(a.sx=n.getMarkerScaleX()),n.getMarkerScaleY()&&(a.sy=n.getMarkerScaleY())),n.getMarkerShortDesc()&&(a.d=n.getMarkerShortDesc()),n.getMarkerFillColor()&&(a.c=n.getMarkerFillColor()),n.getMarkerGradientFill()&&(a.g=n.getMarkerGradientFill()),n.getMarkerOpacity()&&(a.o=n.getMarkerOpacity());var o=n.getEndTime();if(o){a.et=o;var l=n.getDurationFillColor();l&&(a.dfc=l)}e.push(a)}return e}},e.Timeline.prototype.createViewportChangeEvent=function(){return e.EventFactory.newTimelineViewportChangeEvent(this._viewStartTime,this._viewEndTime,this._timeAxis.getScale())},e.Timeline.prototype.HandleTouchStart=function(e){1==e.touches.length&&(this._dragPanSeries=this._findSeries(e.target))},e.Timeline.prototype.HandleMouseWheel=function(t){if(e.Timeline.superclass.HandleMouseWheel.call(this,t),this.hasValidOptions()&&t.zoomWheelDelta){var i=this.getCtx().pageToStageCoords(t.pageX,t.pageY);if(this.getGraphicalAreaBounds().containsPoint(i.x,i.y)){var s=this.getContentLength()*t.zoomWheelDelta,r=t.zoomTime,n=t.zoomCompLoc;this.handleZoomWheel(s,r,n,!0)}}},e.Timeline.prototype.handleZoomWheel=function(t,i,s,r){t>this._timeAxis.getMaxContentLength()?(t=this._timeAxis.getMaxContentLength(),this.disableZoomButton(!0)):this.enableZoomButton(!0),this._canvasLength>t?(t=this._canvasLength,this.disableZoomButton(!1)):this.enableZoomButton(!1);var n=this.getContentLength()<=t;e.Timeline.superclass.handleZoomWheel.call(this,t,i,s,r);var a=this._timeAxis.getZoomLevelLengths();if(n)for(;this._timeAxis.getZoomLevelOrder()>0;){var l=a[this._timeAxis.getZoomLevelOrder()-1];if(!(this.getContentLength()>=l))break;this._timeAxis.setZoomLevelOrder(this._timeAxis.getZoomLevelOrder()-1),this._timeAxis.decreaseScale()}else for(;this._timeAxis.getZoomLevelOrder()<a.length-1;){l=a[this._timeAxis.getZoomLevelOrder()];if(!(this.getContentLength()<l))break;this._timeAxis.setZoomLevelOrder(this._timeAxis.getZoomLevelOrder()+1),this._timeAxis.increaseScale()}if(this._hasOverview&&(this._isVertical?this._overview.setViewportRange(null,null,this._viewStartTime,this._viewEndTime):this._overview.setViewportRange(this._viewStartTime,this._viewEndTime,null,null)),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),this.applyAxisStyleValues(),o._renderAxis(this,this._timeZoomCanvas),this.updateSeries(),this.isContentDirScrollbarOn())for(var _=0;_<this._series.length;_++)this.contentDirScrollbar[_].setViewportRange(0,this._seriesSize,0,Math.max(this._series[_]._maxOverflowValue,this._seriesSize));r&&this.dispatchEvent(this.createViewportChangeEvent())},e.Timeline.prototype.updateSeries=function(){if(this._series){var t=this._series.length,i=this.getTimeAxisVisibleSize(t);this._seriesSize=(this._canvasSize-i)/t;for(var s=0;s<t;s++){var r=this._series[s];r.setClipPath(null);var n=new e.ClipPath;if(this._isVertical){if(this.isRTL())var a=Math.abs(s-1);else a=s;if(this.isRTL()&&1==this._series.length){n.addRect(i,0,this._seriesSize,this.getContentLength());var o=new e.Matrix(1,0,0,1,i,0)}else n.addRect(a*(this._seriesSize+i),0,this._seriesSize,this.getContentLength()),o=new e.Matrix(1,0,0,1,a*(this._seriesSize+i),0);var l=this._seriesSize,_=this.getContentLength()}else n.addRect(0,s*(this._seriesSize+i),this.getContentLength(),this._seriesSize),o=new e.Matrix(1,0,0,1,0,s*(this._seriesSize+i)),l=this.getContentLength(),_=this._seriesSize;r.setClipPath(n),r.setMatrix(o),r.render(null,l,_)}}},e.Timeline.prototype._handleResize=function(e,t){if(this.Width=e,this.Height=t,this.applyStyleValues(),this._fetchStartPos=0,this._isVertical?this._fetchEndPos=t:this._fetchEndPos=e,this.prepareViewportLength(),o._renderBackground(this),this.hasValidOptions()){if(this.renderTimeZoomCanvas(this._canvas),this.applyAxisStyleValues(),this.updateSeries(),o._renderAxis(this,this._timeZoomCanvas),o._renderSeriesLabels(this),o._renderZoomControls(this),this._hasOverview&&(o._renderOverview(this),this.SelectionHandler)){var i=this.SelectionHandler.getSelectedIds();if(i&&0!=i.length)for(var s=0;s<i.length;s++)this._overview.selSelectItem(i[s])}(this.isTimeDirScrollbarOn()||this.isContentDirScrollbarOn())&&o._renderScrollbars(this)}else o._renderEmptyText(this);this.Animation||this.RenderComplete()},e.Timeline.prototype.HandleKeyDown=function(t){e.KeyboardEvent.RIGHT_ARROW!=t.keyCode&&e.KeyboardEvent.LEFT_ARROW!=t.keyCode&&e.KeyboardEvent.DOWN_ARROW!=t.keyCode&&e.KeyboardEvent.UP_ARROW!=t.keyCode||this.updateScrollForItemNavigation(this.EventManager.getFocus())},e.Timeline.prototype.HandleMouseDown=function(e){this._dragPanSeries=this._findSeries(e.target)},e.Timeline.prototype.endDragPan=function(){this._dragPanSeries=null,this.endPan()},e.Timeline.prototype.endPan=function(){this._triggerViewportChange&&(this._triggerViewportChange=!1,this.dispatchEvent(this.createViewportChangeEvent()))},e.Timeline.prototype.panBy=function(e,t){var i=this._series.length,s=this.getTimeAxisVisibleSize(i);if(this._isVertical){if(this._dragPanSeries){var r=this._dragPanSeries.getTranslateX()-e;if(this._series.length>1&&(!this.isRTL()&&this._dragPanSeries._isInverted||this.isRTL()&&!this._dragPanSeries._isInverted))var n=s+2*this._dragPanSeries.Width-this._dragPanSeries._maxOverflowValue,a=this._dragPanSeries.Width+s;else this.isRTL()&&!this._dragPanSeries._isInverted?(n=this._dragPanSeries.Width-this._dragPanSeries._maxOverflowValue+s,a=s):(n=0,a=this._dragPanSeries._maxOverflowValue-this._dragPanSeries.Width);if(r<n?r=n:r>a&&(r=a),this._dragPanSeries.setTranslateX(r),this.isContentDirScrollbarOn())if(this._series[0]==this._dragPanSeries)if(this.isRTL()){if(2==i)var o=this.getTimeAxisVisibleSize()+this._seriesSize-r;else o=this.getTimeAxisVisibleSize()-r;this.contentDirScrollbar[0].setViewportRange(o,o+this._seriesSize)}else this.contentDirScrollbar[0].setViewportRange(r,r+this._seriesSize);else this.isRTL()?this.contentDirScrollbar[1].setViewportRange(r,r+this._seriesSize):(o=this.getTimeAxisVisibleSize()+this._seriesSize-r,this.contentDirScrollbar[1].setViewportRange(o,o+this._seriesSize))}this.panZoomCanvasBy(t),this._hasOverview&&this._overview.setViewportRange(null,null,this._viewStartTime,this._viewEndTime),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime)}else if(this.panZoomCanvasBy(e),this._hasOverview&&this._overview.setViewportRange(this._viewStartTime,this._viewEndTime,null,null),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),this._dragPanSeries){var l=this._dragPanSeries.getTranslateY()-t;if(this._dragPanSeries._isInverted)var _=s+2*this._dragPanSeries.Height-this._dragPanSeries._maxOverflowValue,h=this._dragPanSeries.Height+s;else _=0,h=this._dragPanSeries._maxOverflowValue-this._dragPanSeries.Height;if(l<_?l=_:l>h&&(l=h),this._dragPanSeries.setTranslateY(l),this.isContentDirScrollbarOn())if(this._series[0]==this._dragPanSeries)this.contentDirScrollbar[0].setViewportRange(l,l+this._seriesSize);else{o=this.getTimeAxisVisibleSize()+this._seriesSize-l;this.contentDirScrollbar[1].setViewportRange(o,o+this._seriesSize)}}},e.Timeline.prototype.HandleEvent=function(t,i){var s=t.type;if("dvtSimpleScrollbar"==(s=t.type))t=this.processScrollbarEvent(t,i);else if("selection"==s)this.dispatchEvent(t);else if("overview"==s){if("rangeChanging"==(c=t.subtype)||"rangeChange"==c){var r=this._viewEndTime-this._viewStartTime;this._isVertical?(this._viewStartTime=t.newY1,this._viewEndTime=t.newY2):(this._viewStartTime=t.newX1,this._viewEndTime=t.newX2);var n=this._viewEndTime-this._viewStartTime;if(n>0){var a=this._canvasLength/n;this.setContentLength(a*(this._end-this._start)),this.setRelativeStartPos(a*(this._start-this._viewStartTime));var l=this._timeAxis.getZoomLevelLengths();if(r>n){for(var _=l[(h=l.length)-1];this.getContentLength()>=_&&h>0;)_=l[--h-1];h==l.length&&h--,this._timeAxis.setZoomLevelOrder(h),this._timeAxis.setScale(this._timeAxis.getZoomOrder()[h])}else{var h;for(_=l[h=0];this.getContentLength()<_&&h<l.length-1;)_=l[++h];this._timeAxis.setZoomLevelOrder(h),this._timeAxis.setScale(this._timeAxis.getZoomOrder()[h])}this.applyAxisStyleValues(),o._renderAxis(this,this._timeZoomCanvas),this.updateSeries(),this.applyTimeZoomCanvasPosition()}"rangeChange"==c&&this.dispatchEvent(this.createViewportChangeEvent())}if("scrollPos"==c||"scrollTime"==c){this._isVertical?(this._viewStartTime=t.newY1,this._viewEndTime=t.newY2):(this._viewStartTime=t.newX1,this._viewEndTime=t.newX2);a=this.getContentLength()/(this._end-this._start);this.setRelativeStartPos(a*(this._start-this._viewStartTime)),this.applyTimeZoomCanvasPosition(),this.dispatchEvent(this.createViewportChangeEvent())}}else if(s="timeline"){var c;if("selection"==(c=t.subtype))for(var g=t.itemId,u=t.isMultiSelect&&"multiple"==this._selectionMode,m=0;m<this._series.length;m++)for(var d=this._series[m],S=0;S<d._items.length;S++){var v=d._items[S];if(e.Obj.compareValues(this.getCtx(),v.getId(),g)){this.EventManager.setFocusObj(v),this.updateScrollForItemSelection(v),this.SelectionHandler._addToSelection(v,u)&&this.EventManager.fireSelectionEvent(v);break}}else if("highlight"==c){var f=t.itemId;for(m=0;m<this._series.length;m++)for(d=this._series[m],S=0;S<d._items.length;S++){v=d._items[S];if(e.Obj.compareValues(this.getCtx(),v.getId(),f)){v.showHoverEffect(!0);break}}}else if("unhighlight"==c)for(f=t.itemId,m=0;m<this._series.length;m++)for(d=this._series[m],S=0;S<d._items.length;S++){v=d._items[S];if(e.Obj.compareValues(this.getCtx(),v.getId(),f)){v.hideHoverEffect(!0);break}}}},e.Timeline.prototype.processScrollbarEvent=function(t,i){e.Timeline.superclass.processScrollbarEvent.call(this,t,i);var s=t.newMin;i==this.contentDirScrollbar[0]?this.isVertical()?2==this._series.length?this._series[0].setTranslateX(this.isRTL()?this.getTimeAxisVisibleSize()+this._seriesSize-s:s):this._series[0].setTranslateX(this.isRTL()?this.getTimeAxisVisibleSize()-s:s):this._series[0].setTranslateY(s):i==this.contentDirScrollbar[1]&&(this.isVertical()?this._series[1].setTranslateX(this.isRTL()?s:this.getTimeAxisVisibleSize()+this._seriesSize-s):this._series[1].setTranslateY(this.getTimeAxisVisibleSize()+this._seriesSize-s))},e.Timeline.prototype.updateScrollForItemSelection=function(e){var t=this._viewEndTime-this._viewStartTime;this._viewStartTime=e.getStartTime()-t/2,this._viewStartTime<this._start?this._viewStartTime=this._start:this._viewStartTime+t>this._end&&(this._viewStartTime=this._end-t),this._viewEndTime=this._viewStartTime+t;var i=this.getContentLength()/(this._end-this._start);this.setRelativeStartPos(i*(this._start-this._viewStartTime)),this.applyTimeZoomCanvasPosition(),this.dispatchEvent(this.createViewportChangeEvent())},e.Timeline.prototype.updateScrollForItemNavigation=function(e){var t=this._isVertical?e.getHeight():e.getWidth(),i=l.getItemHoverStrokeWidth(),s=e.getLoc()-(this._isVertical?t/2+i:l.getBubbleOffset()+i),r=this.getRelativeStartPos();this.isRTL()&&!this._isVertical&&(s-=i);var n=s+t+2*i,a=r-this._canvasLength;-s>r?r=-s:-n<a&&(r=-n+this._canvasLength);var o=this.getContentLength()/(this._end-this._start),_=this._viewEndTime-this._viewStartTime;this._viewStartTime=this._start-r/o,this._viewStartTime<this._start&&(this._viewStartTime=this._start,r=(this._start-this._viewStartTime)*o),this._viewEndTime=this._viewStartTime+_,this._viewEndTime>this._end&&(this._viewEndTime=this._end,this._viewStartTime=this._viewEndTime-_,r=(this._start-this._viewStartTime)*o),this.setRelativeStartPos(r),this.applyTimeZoomCanvasPosition(),this._hasOverview&&(this._isVertical?this._overview.setViewportRange(null,null,this._viewStartTime,this._viewEndTime):this._overview.setViewportRange(this._viewStartTime,this._viewEndTime,null,null)),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),this.dispatchEvent(this.createViewportChangeEvent())},e.Timeline.prototype.applyInitialSelections=function(){if(this.Options.selection)for(var e=[],t=0;t<this._series.length;t++)for(var i=this._series[t],s=0;s<i._items.length;s++)e.push(i._items[s]);this.SelectionHandler.processInitialSelections(this.Options.selection,e)},e.Timeline.prototype._findSeries=function(e){if(this.hasValidOptions()&&e&&e!=this){var t=e.getId();return e==this._series[0]||this._series.length>1&&e==this._series[1]?e:t&&"_s0"==t.substring(t.length-3,t.length)?this._series[0]:t&&"_s1"==t.substring(t.length-3,t.length)?this._series[1]:this._findSeries(e.getParent())}return null},e.Timeline.prototype._findDrawable=function(e){if(e){var t=e.getId();if(t&&"_duration_"==t.substring(0,10)&&e._node)return e;var i=e.getParent();if(i){if(t&&"zoom"==t.substring(0,4))return e;if(t&&"_bubble_"==t.substring(0,8)&&i._node)return i;var s=i.getParent();if(s){if(t&&"_bubble_"==t.substring(0,8)&&s._node)return s;if((t=s.getId())&&"_bubble_"==t.substring(0,8)&&s.getParent())return s.getParent()}}}return null},e.Timeline.prototype.getAutomation=function(){return this.Automation||(this.Automation=new r(this)),this.Automation},e.Timeline.prototype.clearComponent=function(){e.Timeline.superclass.clearComponent.call(this),this.clearOverview()},e.Timeline.prototype.clearOverview=function(){this._overviewCanvas&&(this.removeChild(this._overviewCanvas),this._overviewCanvas=null)},e.Timeline.prototype.isTimeDirScrollbarOn=function(){return!this._hasOverview},e.Timeline.prototype.isContentDirScrollbarOn=function(){return!0},e.Timeline.prototype.getBackgroundXOffset=function(){return this._backgroundX},e.Timeline.prototype.setBackgroundXOffset=function(e){this._backgroundX=e};var r=function(e){this._timeline=e};e.Obj.createSubclass(r,e.Automation),r.TIMELINE_ITEM_STRING="timelineItem",r.prototype.GetSubIdForDomElement=function(e){var t=this._timeline.EventManager.GetLogicalObject(e);if(t&&t instanceof g)for(var i=0;i<this._timeline._series.length;i++){var s=this._timeline._series[i]._items.indexOf(t);if(-1!=s)return r.TIMELINE_ITEM_STRING+"["+i+"]["+s+"]"}return null},r.prototype.getDomElementForSubId=function(t){if(t==e.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._timeline);if(t&&this._timeline.hasValidOptions()){var i=t.indexOf("[");if(i>0&&t.substring(0,i)===r.TIMELINE_ITEM_STRING){var s=t.indexOf("]");if(s>0){var n=parseInt(t.substring(i+1,s)),a=parseInt(t.substring(s+2,t.length-1)),o=this._timeline._series[n];if(o){var l=o._items[a];if(l)return l.getDisplayables()[0].getElem()}}}}return null};var n=function(e){this.Init({alta:n.VERSION_1},e)};e.Obj.createSubclass(n,e.BaseComponentDefaults),n.VERSION_1={animationOnDataChange:"none",animationOnDisplay:"none",orientation:"horizontal",overview:{rendered:"off"},selectionMode:"none",styleDefaults:{animationDuration:500,borderColor:"#d9dfe3",item:{backgroundColor:"#ffffff",borderColor:"#648baf",descriptionStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #084B8A; white-space: nowrap;"),hoverBorderColor:"#85bbe7",selectedBorderColor:"#000000",titleStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"font-weight: bold; color: #000000; white-space: nowrap;")},majorAxis:{labelStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_14+"font-weight: bold; color: #4f4f4f; white-space: nowrap;"),separatorColor:"#bcc7d2"},minorAxis:{backgroundColor:"#f9f9f9",borderColor:"#d9dfe3",labelStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #333333;"),separatorColor:"#bcc7d2"},overview:{backgroundColor:"#e6ecf3",labelStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"font-weight: bold; color: #4f4f4f;"),window:{backgroundColor:"#ffffff",borderColor:"#4f4f4f"}},referenceObject:{color:"#ff591f"},series:{backgroundColor:"#f9f9f9",colors:e.CSSStyle.COLORS_ALTA,emptyTextStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"font-weight: normal; color: #333333; white-space: nowrap;"),labelStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_13+"font-weight: bold; color: #252525; white-space: nowrap;")},_tooltipStyle:new e.CSSStyle("border-collapse: separate; border-spacing: 2px; overflow: hidden; display: block;"),tooltipLabelStyle:new e.CSSStyle("color: #666666; padding: 0px 2px; white-space: nowrap;"),tooltipValueStyle:new e.CSSStyle("color: #333333; padding: 0px 2px;")}};var a=function(){};e.Obj.createSubclass(a,e.Obj),a.prototype.parse=function(e){var t=new Object;t.start=new Date(e.start).getTime(),t.end=new Date(e.end).getTime(),e.viewportStart&&(t.viewStart=new Date(e.viewportStart).getTime()),e.viewportEnd&&(t.viewEnd=new Date(e.viewportEnd).getTime()),e.selectionMode?t.selectionMode=e.selectionMode:t.selectionMode="none",t.inlineStyle=e.style,e.svgStyle&&(t.inlineStyle=e.svgStyle);var i=e.minorAxis;if(i){var s=i.scale;t.scale=s,t.customFormatScales=i._cfs}var r=e.majorAxis;r&&(t.seriesScale=r.scale,t.seriesConverter=r.converter,t.seriesCustomFormatScales=r._cfs),t.shortDesc=e.shortDesc,t.orientation=e.orientation;var n=e.referenceObjects;if(n&&n.length>0){for(var a=[],o=0;o<n.length;o++)a.push(new Date(n[o].value));t.referenceObjects=a}var l=e.overview;return null!=l&&"on"==l.rendered?t.hasOverview=!0:t.hasOverview=!1,t.timeZoneOffsets=e._tzo,t.itemPosition=e._ip,t.customTimeScales=e._cts,t};var o=new Object;e.Obj.createSubclass(o,e.Obj),o.renderTimeline=function(t){if(o._renderBackground(t),o._renderScrollableCanvas(t),t.hasValidOptions()){t.renderTimeZoomCanvas(t._canvas);var i=t.getTimeZoomCanvas();if(o._renderSeries(t,i),o._renderSeriesLabels(t),o._renderAxis(t,i),t._hasOverview?o._renderOverview(t):t.clearOverview(),t._keyboardHandler)for(var s=0;s<t._series.length;s++){if((r=t._series[s])._items&&r._items.length>0){t.EventManager.setFocusObj(r._items[0]);break}}(t.isTimeDirScrollbarOn()||t.isContentDirScrollbarOn())&&o._renderScrollbars(t),o._renderZoomControls(t),t.SelectionHandler&&t.applyInitialSelections(),e.TimeAxis.supportsTouch()&&t._setAriaProperty("flowto",t._series[0].getId());for(s=0;s<t._series.length;s++){var r;(r=t._series[s]).triggerAnimations()}}else o._renderEmptyText(t)},o._renderBackground=function(t){t._background?(t._background.setClipPath(null),t._background.setWidth(t._backgroundWidth),t._background.setHeight(t._backgroundHeight)):t._background=new e.Rect(t.getCtx(),0,0,t._backgroundWidth,t._backgroundHeight,"bg");var i=t.getBackgroundXOffset();t._background.setTranslateX(i),t._background.setCSSStyle(t._style),t._background.setPixelHinting(!0);var s=new e.ClipPath;s.addRect(i,0,t._backgroundWidth,t._backgroundHeight),t._background.setClipPath(s),t._background.getParent()!=t&&t.addChild(t._background)},o._renderScrollableCanvas=function(t){t._canvas||(t._canvas=new e.Container(t.getCtx(),"canvas"),t.addChild(t._canvas))},o._renderSeries=function(t,i){var s=t.getTimeAxis();if(t._series){var r=t.getCtx(),n=e.Agent.isRightToLeft(r),a=t._series.length,o=t.getTimeAxisVisibleSize(a);t.isVertical()||a>1&&t._canvasSize%2!=o%2&&(s.setContentSize(s.getContentSize()+1),o=t.getTimeAxisVisibleSize(a)),t._seriesSize=(t._canvasSize-o)/a;for(var l=0;l<a;l++){var _=t._series[l];_.setClipPath(null);var h=new e.ClipPath;if(t.isVertical()){if(n)var c=Math.abs(l-1);else c=l;if(n&&1==t._series.length){h.addRect(o,0,t._seriesSize,t.getContentLength());var g=new e.Matrix(1,0,0,1,o,0)}else h.addRect(c*(t._seriesSize+o),0,t._seriesSize,t.getContentLength()),g=new e.Matrix(1,0,0,1,c*(t._seriesSize+o),0);var u=t._seriesSize,m=t.getContentLength()}else h.addRect(0,l*(t._seriesSize+o),t.getContentLength(),t._seriesSize),g=new e.Matrix(1,0,0,1,0,l*(t._seriesSize+o)),u=t.getContentLength(),m=t._seriesSize;_.setClipPath(h),_.setMatrix(g),_.getParent()!=i&&i.addChild(_),_.render(t._seriesOptions[l],u,m)}}},o._renderSeriesLabels=function(t){if(t._series){var i=t.getCtx(),s=e.Agent.isRightToLeft(i);if(t._seriesLabels)for(var r=0;r<t._seriesLabels.length;r++)t.removeChild(t._seriesLabels[r]);t._seriesLabels=[];var n=t._series.length,a=l.getSeriesLabelSpacing(),o=2*e.TransientButton._DEFAULT_RADIUS+6,_=2*a;for(r=0;r<n;r++){var h=t._series[r],c=h.getLabel();if(null!=c){var g=l.getSeriesLabelStyle(t.Options),u=new e.CSSStyle(l.getSeriesLabelBackgroundStyle());if(h._style){var m=h._style.getStyle(e.CSSStyle.BACKGROUND_COLOR);m&&u.setStyle(e.CSSStyle.BACKGROUND_COLOR,m)}var d=new e.OutputText(i,c,0,0,"sl_s"+r);d.setCSSStyle(g);var S=d.getDimensions();if(t.isVertical())var v=t._seriesSize;else v=t._canvasLength;var f=Math.min(S.w,v-(r-1)*-o-_),p=l.getSeriesLabelPadding(),T=new e.Rect(i,0,0,f+2*p,S.h+2*p,"slb_s"+r);if(T.setCSSStyle(u),T.setAlpha(l.getSeriesLabelBackgroundOpacity()),T.setCornerRadius(3),t.isVertical())b=s?Math.abs(r-1)*(t._canvasSize-f-_)+a+t._startX+(r-1)*o:r*(t._canvasSize-f-_)+a+t._startX+(r-1)*-o,O=t._startY+a;else{if(s)var b=t._canvasLength-f-a-(r-1)*-o;else b=t._startX+a+(r-1)*-o;var O=r*(t._canvasSize-S.h-_)+a+t._startY}var C=new e.Matrix(1,0,0,1,b,O);d.setMatrix(C),C=new e.Matrix(1,0,0,1,b-p,O-p),T.setMatrix(C),t.addChild(T),e.TextUtils.fitText(d,f,1/0,t),t._seriesLabels.push(T),t._seriesLabels.push(d)}if(h._isEmpty){var A=h.getEmptyText();if(null!=A){var E=new e.OutputText(i,A,0,0,"et_s"+r);E.setCSSStyle(l.getEmptyTextStyle(t.Options));S=E.getDimensions();if(t.isVertical())D=(t._canvasLength-S.h)/2+t._startY,y=s?Math.abs(r-1)*((n-1)*t._seriesSize+t.getTimeAxisVisibleSize(n))+(t._seriesSize-S.w)/2+t._startX:r*(t._seriesSize+t.getTimeAxisVisibleSize(n))+(t._seriesSize-S.w)/2+t._startX;else var y=(t._canvasLength-S.w)/2+t._startX,D=r*(t._seriesSize+t.getTimeAxisVisibleSize(n))+(t._seriesSize-S.h)/2+t._startY;C=new e.Matrix(1,0,0,1,y,D);E.setMatrix(C),t.addChild(E),t._seriesLabels.push(E)}}}}},o._renderAxis=function(t,i){var s=t.getCtx(),r=e.Agent.isRightToLeft(s),n=t.getTimeAxis(),a=t._series.length,l=t.getTimeAxisSize(),_=t.getTimeAxisVisibleSize(a),h=1==a?t._canvasSize-_:t._canvasSize/a-_/2;if(r&&t.isVertical()&&1==t._series.length&&(h=0),n.getParent()!==i&&i.addChild(n),t.isVertical()){var c=new e.Matrix(1,0,0,1,h,0);n.render(null,l,t.getContentLength())}else c=new e.Matrix(1,0,0,1,0,h),n.render(null,t.getContentLength(),l);n.setMatrix(c),o._renderSeriesTimeAxis(t,t._fetchStartPos,t._fetchEndPos,t.getTimeZoomCanvas(),t.getContentLength())},o._renderSeriesTimeAxis=function(t,i,s,r,n){var a=t.getCtx(),_=e.Agent.isRightToLeft(a);if(t._majorAxisLabels)for(var h=0;h<t._majorAxisLabels.length;h++)r.removeChild(t._majorAxisLabels[h]);if(t._majorAxisLabels=[],t._seriesScale){var c,g,u=t._start,m=t._end;if(t._customTimeScales&&t._customTimeScales[t._seriesScale]){var d=t._customTimeScales[t._seriesScale];c=d.times,g=d.labels}else if(t._seriesCustomFormatScales&&t._seriesCustomFormatScales[t._seriesScale]){var S=t._seriesCustomFormatScales[t._seriesScale];c=S.times,g=S.labels}else{c=[],g=[];var v=e.TimeAxis.getPositionDate(u,m,i,n),f=t._seriesTimeAxis.adjustDate(v),p=e.TimeAxis.getDatePosition(u,m,f,n);for(c.push(f.getTime());p<s;)g.push(t._seriesTimeAxis.formatDate(f)),f=t._seriesTimeAxis.getNextDate(f.getTime()),p=e.TimeAxis.getDatePosition(u,m,f,n),c.push(f.getTime())}var T=l.getSeriesAxisLabelStyle(t.Options),b=l.getSeriesAxisLabelPadding(),O=new e.CSSStyle(l.getSeriesAxisLabelBackgroundStyle());if(t._series[0]&&t._series[0]._style){var C=t._series[0]._style.getStyle(e.CSSStyle.BACKGROUND_COLOR);C&&O.setStyle(e.CSSStyle.BACKGROUND_COLOR,C)}var A=l.getSeriesAxisLabelBackgroundOpacity();for(h=0;h<g.length;h++){var E=g[h],y=c[h];p=e.TimeAxis.getDatePosition(u,m,y,n);var D=e.TimeAxis.getDatePosition(u,m,c[h+1],n)-p;if(_)w=t.isVertical()?o._addLabel(a,r,t._canvasSize-5,E,D,p+18,T,"o_label"+p+"_s0",!0,O,A,b,t._majorAxisLabels,_):o._addLabel(a,r,n-(p+5),E,D,t._seriesSize-2,T,"o_label"+p+"_s0",!0,O,A,b,t._majorAxisLabels,_);else if(t.isVertical())var w=o._addLabel(a,r,5,E,D,p+18,T,"o_label"+p+"_s0",!0,O,A,b,t._majorAxisLabels,_);else w=o._addLabel(a,r,p+5,E,D,t._seriesSize-2,T,"o_label"+p+"_s0",!0,O,A,b,t._majorAxisLabels,_);w.time=c[h]}}},o._renderOverview=function(t){var i=t.getCtx(),s=e.Agent.isRightToLeft(i);if(null==t._overviewCanvas){var r=!0;t._overviewCanvas=new e.Container(i,"oCanvas")}else t._overviewCanvas.removeChildren(),t._overviewCanvas.setClipPath(null);var n,a,o,l,_=t._style.getBorderWidth(),h=_/2;t.isVertical()?(n=t._overviewSize,a=t._backgroundHeight-_,l=h,o=s?h:t._backgroundWidth-t._overviewSize-h):(n=t._backgroundWidth-_,a=t._overviewSize,l=t._backgroundHeight-t._overviewSize-h,o=h+t.getBackgroundXOffset()),t._overviewCanvas.setTranslateX(o),t._overviewCanvas.setTranslateY(l);var c=new e.ClipPath;c.addRect(o,l,n,a),t._overviewCanvas.setClipPath(c),r&&t.addChild(t._overviewCanvas),t._overview=new e.TimelineOverview(i,t.HandleEvent,t),t._overviewCanvas.addChild(t._overview);var g=t._getOverviewObject();t._overview.render(g,n,a)},o._renderScrollbars=function(t){var i=t.getCtx(),s=t.getScrollbarPadding();if(null==t._scrollbarsCanvas?(t._scrollbarsCanvas=new e.Container(i,"sbCanvas"),t.addChild(t._scrollbarsCanvas)):(t._scrollbarsCanvas.removeChildren(),t.setTimeDirScrollbar(null),t.setContentDirScrollbar(null)),t.isTimeDirScrollbarOn()){if(t.isVertical()){if(e.Agent.isRightToLeft(t.getCtx()))var r=2*s+1;else r=t.Width-1.5*s;var n=t.getCanvasLength()}else r=t.getCanvasLength(),n=t.Height-1.5*s;var a=o._prerenderTimeDirScrollbar(t,t._scrollbarsCanvas,new e.Rectangle(0,0,r,n))}if(t.isContentDirScrollbarOn()){t.isVertical()?(r=t._seriesSize,n=t.Height-1.5*s):(r=e.Agent.isRightToLeft(t.getCtx())?2*s+1:t.Width-1.5*s,n=t._seriesSize);for(var l=t._series.length,_=[],h=0;h<l;h++)_[h]=o._prerenderContentDirScrollbar(t,t._scrollbarsCanvas,new e.Rectangle(0,0,r,n),h)}if(t.timeDirScrollbar){var c={};c.color=t.timeDirScrollbarStyles.getStyle(e.CSSStyle.COLOR),c.backgroundColor=t.timeDirScrollbarStyles.getStyle(e.CSSStyle.BACKGROUND_COLOR),c.min=t._start,c.max=t._end,t.isVertical()?(c.isReversed=!1,c.isHorizontal=!1,t.timeDirScrollbar.setTranslateY(t.getStartYOffset())):(c.isReversed=e.Agent.isRightToLeft(i),c.isHorizontal=!0,t.timeDirScrollbar.setTranslateX(t.getStartXOffset())),t.timeDirScrollbar.render(c,a.w,a.h),t.timeDirScrollbar.setViewportRange(t._viewStartTime,t._viewEndTime)}if(t.contentDirScrollbar)for(h=0;h<l;h++)(c={}).color=t.contentDirScrollbarStyles.getStyle(e.CSSStyle.COLOR),c.backgroundColor=t.contentDirScrollbarStyles.getStyle(e.CSSStyle.BACKGROUND_COLOR),c.isHorizontal=t.isVertical(),0==h?(c.min=0,c.max=Math.max(t._series[h]._maxOverflowValue,_[h].h),t.isVertical()?e.Agent.isRightToLeft(i)?(c.isReversed=!1,2==l?t.contentDirScrollbar[h].setTranslateX(t.getStartXOffset()+t._seriesSize+t.getTimeAxisVisibleSize(l)):t.contentDirScrollbar[h].setTranslateX(t.getStartXOffset()+t.getTimeAxisVisibleSize(l))):(c.isReversed=!0,t.contentDirScrollbar[h].setTranslateX(t.getStartXOffset())):(c.isReversed=!0,t.contentDirScrollbar[h].setTranslateY(t.getStartYOffset()))):(c.min=0,c.max=Math.max(t._series[h]._maxOverflowValue,_[h].h),t.isVertical()?e.Agent.isRightToLeft(i)?(c.isReversed=!0,t.contentDirScrollbar[h].setTranslateX(t.getStartXOffset())):(c.isReversed=!1,t.contentDirScrollbar[h].setTranslateX(t.getStartXOffset()+t._seriesSize+t.getTimeAxisVisibleSize(l))):(c.isReversed=!1,t.contentDirScrollbar[h].setTranslateY(t.getStartYOffset()+t._seriesSize+t.getTimeAxisVisibleSize(l)))),t.contentDirScrollbar[h].render(c,_[h].w,_[h].h),t.contentDirScrollbar[h].setViewportRange(0,t._seriesSize)},o._prerenderTimeDirScrollbar=function(t,i,s){if(t.setTimeDirScrollbar(new e.SimpleScrollbar(t.getCtx(),t.HandleEvent,t)),i.addChild(t.timeDirScrollbar),t.isVertical())var r="right",n=e.CSSStyle.toNumber(t.timeDirScrollbarStyles.getWidth()),a=s.h;else r="bottom",n=s.w,a=e.CSSStyle.toNumber(t.timeDirScrollbarStyles.getHeight());return e.LayoutUtils.position(s,r,t.timeDirScrollbar,n,a,0),new e.Dimension(n,a)},o._prerenderContentDirScrollbar=function(t,i,s,r){if(t.setContentDirScrollbar(new e.SimpleScrollbar(t.getCtx(),t.HandleEvent,t),r),i.addChild(t.contentDirScrollbar[r]),t.isVertical())var n="bottom",a=s.w,o=e.CSSStyle.toNumber(t.contentDirScrollbarStyles.getHeight());else n="right",a=e.CSSStyle.toNumber(t.contentDirScrollbarStyles.getWidth()),o=s.h;return e.LayoutUtils.position(s,n,t.contentDirScrollbar[r],a,o,0),new e.Dimension(a,o)},o._renderZoomControls=function(t){var i=t.getCtx(),s=t._resources,r=e.Agent.isRightToLeft(i),n={zoomInProps:{imageSize:16,cssUrl:s.zoomIn,cssUrlHover:s.zoomIn_h,cssUrlActive:s.zoomIn_a,cssUrlDisabled:s.zoomIn_d,enabledBackgroundColor:l.getZoomInButtonBackgroundColor(s),enabledBorderColor:l.getZoomInButtonBorderColor(s),hoverBackgroundColor:l.getZoomInButtonHoverBackgroundColor(s),hoverBorderColor:l.getZoomInButtonHoverBorderColor(s),activeBackgroundColor:l.getZoomInButtonActiveBackgroundColor(s),activeBorderColor:l.getZoomInButtonActiveBorderColor(s),disabledBackgroundColor:l.getZoomInButtonDisabledBackgroundColor(s),disabledBorderColor:l.getZoomInButtonDisabledBorderColor(s)},zoomOutProps:{imageSize:16,cssUrl:s.zoomOut,cssUrlHover:s.zoomOut_h,cssUrlActive:s.zoomOut_a,cssUrlDisabled:s.zoomOut_d,enabledBackgroundColor:l.getZoomOutButtonBackgroundColor(s),enabledBorderColor:l.getZoomOutButtonBorderColor(s),hoverBackgroundColor:l.getZoomOutButtonHoverBackgroundColor(s),hoverBorderColor:l.getZoomOutButtonHoverBorderColor(s),activeBackgroundColor:l.getZoomOutButtonActiveBackgroundColor(s),activeBorderColor:l.getZoomOutButtonActiveBorderColor(s),disabledBackgroundColor:l.getZoomOutButtonDisabledBackgroundColor(s),disabledBorderColor:l.getZoomOutButtonDisabledBorderColor(s)}},a=t.getStartXOffset()+l._DEFAULT_ZOOM_CONTROL_PADDING;r&&(t._isVertical&&t._hasOverview?a-=t._overviewSize:a-=t.getBackgroundXOffset(),a=t._backgroundWidth-a-l._DEFAULT_ZOOM_CONTROL_DIAMETER),n.zoomInProps.posX=a,n.zoomOutProps.posX=a;var o=t._startY+l._DEFAULT_ZOOM_CONTROL_PADDING;n.zoomInProps.posY=o,n.zoomOutProps.posY=o+l._DEFAULT_ZOOM_CONTROL_DIAMETER+l._DEFAULT_ZOOM_CONTROL_SPACING,t.renderZoomControls(n)},o._renderEmptyText=function(t){if(t.Options.series)var i=t.Options.translations.labelInvalidData;else i=t.Options.translations.labelNoData;t.clearComponent(),e.TextUtils.renderEmptyText(t._canvas,i,new e.Rectangle(0,0,t._backgroundWidth,t._backgroundHeight),t.EventManager,l.getEmptyTextStyle(t.Options))},o._addLabel=function(t,i,s,r,n,a,o,l,_,h,c,g,u,m){var d=new e.OutputText(t,r,s,0,l);null!=o&&d.setCSSStyle(o);var S=d.getDimensions();if(a-=S.h,d.setY(a),m&&d.setX(s-S.w),_){var v=Math.min(S.w+2*g,n);if(m)f=s-v+2*g;else var f=s;var p=new e.Rect(t,f-g,a-g,v,S.h+2*g,"ob_"+l);p.setCSSStyle(h),p.setCornerRadius(3),p.setAlpha(c),i.addChild(p),u&&u.push(p)}return e.TextUtils.fitText(d,n,1/0,i),u&&u.push(d),d};var l=new Object;e.Obj.createSubclass(l,e.Obj),l._DEFAULT_TIMELINE_STYLE="border:1px #d9dfe3;background-color:#f9f9f9;",l._DEFAULT_AXIS_STYLE="background-color:#f9f9f9;border:1px #d9dfe3;",l._DEFAULT_AXIS_SEPARATOR_STYLE="color:#bcc7d2;",l._DEFAULT_SERIES_STYLE="background-color:#f9f9f9;",l._DEFAULT_SERIES_LABEL_BACKGROUND_STYLE="background-color:#f9f9f9",l._DEFAULT_SERIES_LABEL_BACKGROUND_OPACITY=.8,l._DEFAULT_SERIES_LABEL_SPACING=20,l._DEFAULT_SERIES_LABEL_PADDING=2,l._DEFAULT_SERIES_AXIS_SEPARATOR_STYLE="color:#bcc7d2",l._DEFAULT_SERIES_AXIS_LABEL_BACKGROUND_STYLE="background-color:#f9f9f9",l._DEFAULT_SERIES_AXIS_LABEL_BACKGROUND_OPACITY=.8,l._DEFAULT_SERIES_AXIS_LABEL_PADDING=1,l._DEFAULT_OVERVIEW_WIDTH=60,l._DEFAULT_OVERVIEW_HEIGHT=100,l._DEFAULT_ITEM_ENABLED_STROKE_WIDTH=1,l._DEFAULT_ITEM_HOVER_STROKE_WIDTH=2,l._DEFAULT_ITEM_SELECTED_STROKE_WIDTH=2,l._DEFAULT_ITEM_INNER_FILL_COLOR="rgba(249,249,249,0)",l._DEFAULT_ITEM_ACTIVE_INNER_STROKE_COLOR="#e4f0fa",l._DEFAULT_ITEM_ENABLED_INNER_STROKE_COLOR="rgba(249,249,249,0)",l._DEFAULT_ITEM_INNER_STROKE_WIDTH=2,l._DEFAULT_BUBBLE_OFFSET=20,l._DEFAULT_BUBBLE_SPACING=15,l._DEFAULT_ITEM_CONTENT_SPACING=2,l._DEFAULT_DURATION_FEELER_OFFSET=10,l._DEFAULT_THUMBNAIL_WIDTH=32,l._DEFAULT_THUMBNAIL_HEIGHT=32,l._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR="#ffffff",l._DEFAULT_ZOOM_CONTROL_BORDER_COLOR="#d6d7d8",l._DEFAULT_ZOOM_CONTROL_DIAMETER=31,l._DEFAULT_ZOOM_CONTROL_PADDING=10.5,l._DEFAULT_ZOOM_CONTROL_SPACING=9,l.getItemDescriptionStyle=function(t){var i=t._series.getOptions().styleDefaults.item.descriptionStyle,s=t.getStyle();if(s){var r=new e.CSSStyle(s);i.parseInlineStyle(r)}return i},l.getItemTitleStyle=function(t){var i=t._series.getOptions().styleDefaults.item.titleStyle,s=t.getStyle();if(s){var r=new e.CSSStyle(s);i.parseInlineStyle(r)}return i},l.getReferenceObjectColor=function(e){return e.styleDefaults.referenceObject.color},l.getSeriesLabelStyle=function(e){return e.styleDefaults.series.labelStyle},l.getSeriesLabelBackgroundStyle=function(){return l._DEFAULT_SERIES_LABEL_BACKGROUND_STYLE},l.getSeriesLabelBackgroundOpacity=function(){return l._DEFAULT_SERIES_LABEL_BACKGROUND_OPACITY},l.getSeriesLabelPadding=function(){return l._DEFAULT_SERIES_LABEL_PADDING},l.getSeriesLabelSpacing=function(){return l._DEFAULT_SERIES_LABEL_SPACING},l.getEmptyTextStyle=function(e){return e.styleDefaults.series.emptyTextStyle},l.getBubbleOffset=function(){return l._DEFAULT_BUBBLE_OFFSET},l.getBubbleSpacing=function(){return l._DEFAULT_BUBBLE_SPACING},l.getItemContentSpacing=function(){return l._DEFAULT_ITEM_CONTENT_SPACING},l.getItemFillColor=function(t){var i=t.getStyle();if(i){var s=new e.CSSStyle(i).getStyle(e.CSSStyle.BACKGROUND_COLOR);if(s)return s}return t._series.getOptions().styleDefaults.item.backgroundColor},l.getItemStrokeColor=function(t){var i=t.getStyle();if(i){var s=new e.CSSStyle(i).getStyle(e.CSSStyle.BORDER_COLOR);if(s)return s}return t._series.getOptions().styleDefaults.item.borderColor},l.getItemStrokeWidth=function(){return l._DEFAULT_ITEM_ENABLED_STROKE_WIDTH},l.getItemHoverFillColor=function(e){var t=e._series.getOptions().styleDefaults.item.hoverBackgroundColor;return t||l.getItemFillColor(e)},l.getItemHoverStrokeColor=function(e){var t=e._series.getOptions().styleDefaults.item.hoverBorderColor;return t||l.getItemStrokeColor(e)},l.getItemHoverStrokeWidth=function(){return l._DEFAULT_ITEM_HOVER_STROKE_WIDTH},l.getItemSelectedFillColor=function(e){var t=e._series.getOptions().styleDefaults.item.selectedBackgroundColor;return t||l.getItemFillColor(e)},l.getItemSelectedStrokeColor=function(e){var t=e._series.getOptions().styleDefaults.item.selectedBorderColor;return t||l.getItemStrokeColor(e)},l.getItemSelectedStrokeWidth=function(){return l._DEFAULT_ITEM_SELECTED_STROKE_WIDTH},l.getSeriesStyle=function(){return l._DEFAULT_SERIES_STYLE},l.getColorsArray=function(e){return e.styleDefaults.series.colors},l.getDurationFeelerOffset=function(){return l._DEFAULT_DURATION_FEELER_OFFSET},l.getThumbnailWidth=function(){return l._DEFAULT_THUMBNAIL_WIDTH},l.getThumbnailHeight=function(){return l._DEFAULT_THUMBNAIL_HEIGHT},l.getSeriesAxisSeparatorStyle=function(){return l._DEFAULT_SERIES_AXIS_SEPARATOR_STYLE},l.getItemInnerActiveStrokeColor=function(){return l._DEFAULT_ITEM_ACTIVE_INNER_STROKE_COLOR},l.getItemInnerFillColor=function(){return l._DEFAULT_ITEM_INNER_FILL_COLOR},l.getItemInnerStrokeColor=function(){return l._DEFAULT_ITEM_ENABLED_INNER_STROKE_COLOR},l.getItemInnerStrokeWidth=function(){return l._DEFAULT_ITEM_INNER_STROKE_WIDTH},l.getTimelineStyle=function(){return l._DEFAULT_TIMELINE_STYLE},l.getOverviewWidth=function(){return l._DEFAULT_OVERVIEW_WIDTH},l.getOverviewHeight=function(){return l._DEFAULT_OVERVIEW_HEIGHT},l.getOverviewWindowBackgroundColor=function(e){return e.styleDefaults.overview.window.backgroundColor},l.getOverviewWindowBorderColor=function(e){return e.styleDefaults.overview.window.borderColor},l.getOverviewBackgroundColor=function(e){return e.styleDefaults.overview.backgroundColor},l.getOverviewLabelStyle=function(e){return e.styleDefaults.overview.labelStyle},l.getSeriesAxisLabelStyle=function(e){return e.styleDefaults.majorAxis.labelStyle},l.getSeriesAxisLabelBackgroundStyle=function(){return l._DEFAULT_SERIES_AXIS_LABEL_BACKGROUND_STYLE},l.getSeriesAxisLabelBackgroundOpacity=function(){return l._DEFAULT_SERIES_AXIS_LABEL_BACKGROUND_OPACITY},l.getAxisSeparatorStyle=function(){return l._DEFAULT_AXIS_SEPARATOR_STYLE},l.getSeriesAxisLabelPadding=function(){return l._DEFAULT_SERIES_AXIS_LABEL_PADDING},l.getAnimationDuration=function(t){return e.CSSStyle.getTimeMilliseconds(t.styleDefaults.animationDuration)/1e3},l.getZoomInButtonBackgroundColor=function(e){return e.zoomIn_bgc?e.zoomIn_bgc:l._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},l.getZoomInButtonActiveBackgroundColor=function(e){return e.zoomIn_a_bgc?e.zoomIn_a_bgc:l._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},l.getZoomInButtonHoverBackgroundColor=function(e){return e.zoomIn_h_bgc?e.zoomIn_h_bgc:l._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},l.getZoomInButtonDisabledBackgroundColor=function(e){return e.zoomIn_d_bgc?e.zoomIn_d_bgc:l._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},l.getZoomInButtonBorderColor=function(e){return e.zoomIn_bc?e.zoomIn_bc:l._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},l.getZoomInButtonActiveBorderColor=function(e){return e.zoomIn_a_bc?e.zoomIn_a_bc:l._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},l.getZoomInButtonHoverBorderColor=function(e){return e.zoomIn_h_bc?e.zoomIn_h_bc:l._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},l.getZoomInButtonDisabledBorderColor=function(e){return e.zoomIn_d_bc?e.zoomIn_d_bc:l._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},l.getZoomOutButtonBackgroundColor=function(e){return e.zoomOut_bgc?e.zoomOut_bgc:l._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},l.getZoomOutButtonActiveBackgroundColor=function(e){return e.zoomOut_a_bgc?e.zoomOut_a_bgc:l._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},l.getZoomOutButtonHoverBackgroundColor=function(e){return e.zoomOut_h_bgc?e.zoomOut_h_bgc:l._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},l.getZoomOutButtonDisabledBackgroundColor=function(e){return e.zoomOut_d_bgc?e.zoomOut_d_bgc:l._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},l.getZoomOutButtonBorderColor=function(e){return e.zoomOut_bc?e.zoomOut_bc:l._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},l.getZoomOutButtonActiveBorderColor=function(e){return e.zoomOut_a_bc?e.zoomOut_a_bc:l._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},l.getZoomOutButtonHoverBorderColor=function(e){return e.zoomOut_h_bc?e.zoomOut_h_bc:l._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},l.getZoomOutButtonDisabledBorderColor=function(e){return e.zoomOut_d_bc?e.zoomOut_d_bc:l._DEFAULT_ZOOM_CONTROL_BORDER_COLOR};var _=function(e,t,i){this.Init(e,t,i)};e.Obj.createSubclass(_,e.BaseComponent),_.prototype.Init=function(e,t,i){_.superclass.Init.call(this,e),this._callback=t,this._callbackObj=i,this._blocks=[],this._renderedReferenceObjects=[],this._seriesTicksArray=[]},_.prototype.triggerAnimations=function(){var t=this.getCtx();if(this._rmAnimationElems&&0!=this._rmAnimationElems.length){this._callbackObj.EventManager.removeListeners(this._callbackObj);var i=new e.ParallelPlayable(t,new e.AnimFadeOut(t,this._rmAnimationElems,l.getAnimationDuration(this.Options)));e.Playable.appendOnEnd(i,this._onRmAnimationEnd,this),this._callbackObj.Animation=i,i.play()}else if(this._mvAnimator&&this._hasMvAnimations)this._callbackObj.EventManager.removeListeners(this._callbackObj),e.Playable.appendOnEnd(this._mvAnimator,this._onMvAnimationEnd,this),this._callbackObj.Animation=this._mvAnimator,this._mvAnimator.play();else if(this._frAnimationElems&&0!=this._frAnimationElems.length){this._callbackObj.EventManager.removeListeners(this._callbackObj);var s=new e.ParallelPlayable(t,new e.AnimFadeIn(t,this._frAnimationElems,l.getAnimationDuration(this.Options),(this._isInitialRender,0)));e.Playable.appendOnEnd(s,this._onAnimationEnd,this),this._callbackObj.Animation=s,s.play()}},_.prototype._onRmAnimationEnd=function(){for(var t=0;t<this._rmAnimationElems.length;t++){var i=this._rmAnimationElems[t],s=i.getParent();s&&s.removeChild(i)}this._mvAnimator&&this._hasMvAnimations?(this._callbackObj.Animation=this._mvAnimator,e.Playable.appendOnEnd(this._mvAnimator,this._onMvAnimationEnd,this),this._mvAnimator.play()):this._onMvAnimationEnd()},_.prototype._onMvAnimationEnd=function(){if(this._frAnimationElems&&0!=this._frAnimationElems.length){var t=new e.ParallelPlayable(this.getCtx(),new e.AnimFadeIn(this.getCtx(),this._frAnimationElems,l.getAnimationDuration(this.Options),(this._isInitialRender,0)));e.Playable.appendOnEnd(t,this._onAnimationEnd,this),this._callbackObj.Animation=t,t.play()}else this._onAnimationEnd()},_.prototype._onAnimationEnd=function(){this._callbackObj.onAnimationEnd()},_.prototype.render=function(t,i,s){if(t){this.SetOptions(t),this.Width?this._isInitialRender=!1:this._isInitialRender=!0,this.Width=i,this.Height=s;var r=this.Options.orientation;if(r&&r==e.Timeline.ORIENTATION_VERTICAL?(0==this._isVertical?this._allowUpdates=!1:this._allowUpdates=!0,this._isVertical=!0):(this._isVertical?this._allowUpdates=!1:this._allowUpdates=!0,this._isVertical=!1),this.Options){var n=this.Parse(this.Options);this._applyParsedProperties(n)}this._fetchStartPos=0,this._isVertical?(this._fetchEndPos=s,this._maxOverflowValue=i,this._length=s,this._size=i):(this._fetchEndPos=i,this._maxOverflowValue=s,this._length=i,this._size=s),this._isInverted=this.Options.inverted,this._colorCount=0,this._maxDurationSize=0,m.renderSeries(this,i,s),e.TimeAxis.supportsTouch()&&this._items.length>0&&this._setAriaProperty("flowto","_bt_"+this._items[0].getId());var a=this.GetComponentDescription();a&&(e.ToolkitUtils.setAttrNullNS(this.getElem(),"role","group"),e.ToolkitUtils.setAttrNullNS(this.getElem(),"aria-label",e.TextUtils.processAriaLabel(a)))}else this._handleResize(i,s)},_.prototype.GetComponentDescription=function(){var t=this.Options.translations,i=[t.labelSeries];return this._label?i.push(this._label):i.push(this.Options.index+1),e.ResourceUtils.format(t.labelAndValue,i)},_.prototype._handleResize=function(e,t){this._canvas.setTranslateY(0),this._canvas.setTranslateX(0),this.Width=e,this.Height=t,this._fetchStartPos=0,this._isVertical?(this._fetchEndPos=t,this._maxOverflowValue=e,this._length=t,this._size=e):(this._fetchEndPos=e,this._maxOverflowValue=t,this._length=e,this._size=t),this._background.setWidth(e),this._background.setHeight(t),m.updateSeriesForZoom(this)},_.prototype.applyStyleValues=function(){if(this._style=new e.CSSStyle(l.getSeriesStyle()),this._seriesStyleDefaults=this.Options.seriesStyleDefaults,this._axisStyleDefaults=this.Options.axisStyleDefaults,this._colors=l.getColorsArray(this.Options),this._referenceObjects=this.Options.referenceObjects,this._seriesStyleDefaults){var t=this._seriesStyleDefaults.backgroundColor;t&&this._style.parseInlineStyle("background-color:"+t+";")}this._style.parseInlineStyle(this._inlineStyle)},_.prototype.SetOptions=function(e){this.Options=e},_.prototype.Parse=function(e){return this._parser=new u(this.getCtx()),this._parser.parse(e,this._items)},_.prototype._applyParsedProperties=function(e){this._items&&(this._oldItems=this._items),this._items=e.items,this._items&&this._items.length>0?this._isEmpty=!1:this._isEmpty=!0,this._isIRAnimationEnabled=e.isIRAnimationEnabled,this._isDCAnimationEnabled=e.isDCAnimationEnabled,this._label=e.label,this._timeAxis=e.timeAxis,this._emptyText=e.emptyText,null==this._emptyText&&(this._emptyText=this.Options.translations.labelNoData),this._isTopToBottom=e.isTopToBottom,this._isRandomItemLayout=e.isRandomItemLayout,this._customTimeScales=e.customTimeScales,this._customFormatScales=e.customFormatScales,this._start=e.start,this._end=e.end,this._inlineStyle=e.inlineStyle,this._scale=e.scale,this._converter=e.converter,this._data=e.data,this.applyStyleValues()},_.prototype.calculateSpacing=function(e,t){if(null!=this._items&&0!=this._items.length){var i=this._maxOverflowValue,s=e.getSpacing();if(this._isRandomItemLayout){if(null==s){var r=e.getHeight(),n=this._initialSpacing,a=this._maxOverflowValue-r-n;a<0&&(a=0),s=Math.round(Math.random()*a)+n,this._maxOverflowValue<s+r&&(this._maxOverflowValue=s+r+l.getBubbleSpacing())}return s}if(null==s&&(s=this._initialSpacing),this._isVertical)for(g=0;g<t;g++){i<s+(u=(v=this._items[g]).getWidth()+10)&&(i=s+u)}else{for(var o=e.getLoc(),_=e.getWidth()+10,h=l.getBubbleSpacing(),c=[],g=0;g<t;g++){var u=(v=this._items[g]).getWidth()+10,m=v.getLoc();(o>=m&&o<=m+u||m>=o&&m<=o+_)&&c.push(v)}for(var g=0;g<c.length;g++){for(var d=!1,S=0;S<c.length;S++){var v,f=(v=c[S]).getHeight(),p=v.getSpacing();if(s>=p&&s<=p+f){s=p+f+h,e.setSpacing(s),d=!0;break}}if(!d)break}i<s+f&&(i=s+f)}return i>this._maxOverflowValue&&(this._maxOverflowValue=i+l.getBubbleSpacing()),s}},_.prototype.calculateDurationSize=function(e,t){if(null!=this._items&&0!=this._items.length){var i=e.getStartTime(),s=e.getEndTime();if(s&&s!=i){var r=e.getDurationLevel();null==r&&(r=1);for(var n=[],a=0;a<t;a++){var o=(c=this._items[a]).getStartTime(),l=c.getEndTime();l&&l!=o&&(i>=o&&i<=l&&n.push(c))}for(a=0;a<n.length;a++){for(var _=!1,h=0;h<n.length;h++){var c,g=(c=n[h]).getDurationLevel();if(r==g){r=g+1,e.setDurationLevel(r),_=!0;break}}if(!_)break}return r>this._maxDurationSize&&(this._maxDurationSize=r),r}}},_.prototype.prepareDurations=function(e){for(var t=0;t<this._items.length;t++){var i=this._items[t],s=i.getStartTime(),r=i.getEndTime();r&&r!=s&&(i.setDurationLevel(this.calculateDurationSize(i,t)),i.setDurationSize(22+10*i.getDurationLevel()-5),null==i.getDurationFillColor()&&(i.setDurationFillColor(this._colors[this._colorCount]),this._colorCount++,this._colorCount==this._colors.length&&(this._colorCount=0)))}},_.prototype.prepareItems=function(t){this.isVertical()?this._initialSpacing=20*(this._maxDurationSize>0?1:0)+l.getBubbleSpacing()+10*this._maxDurationSize:this._initialSpacing=20+l.getBubbleSpacing()+10*this._maxDurationSize;for(var i=0;i<t.length;i++){var s=t[i],r=e.TimeAxis.getDatePosition(this._start,this._end,s.getStartTime(),this._length),n=s.getEndTime();if(n&&n!=s.getStartTime()){var a=e.TimeAxis.getDatePosition(this._start,this._end,n,this._length)-r;r+=Math.min(l.getDurationFeelerOffset(),a/2)}s.setLoc(r)}for(i=0;i<this._items.length;i++){s=this._items[i];(r=e.TimeAxis.getDatePosition(this._start,this._end,s.getStartTime(),this._length))<this._fetchStartPos||r>this._fetchEndPos||c.initializeItem(s,this,i)}},_.prototype.getData=function(t){if(t){var i={emptyText:this._data.emptyText,id:this._data.id,itemLayout:this._data.itemLayout,label:this._data.label,svgStyle:this._data.svgStyle,items:this._data.items};return e.TimeComponent.sanitizeData(i,"series")}return this._data},_.prototype.getLabel=function(){return this._label},_.prototype.getEmptyText=function(){return this._emptyText},_.prototype.findItem=function(t){if(null!=this._items)for(var i=0;i<this._items.length;i++){var s=this._items[i];if(e.Obj.compareValues(this.getCtx(),s.getId(),t))return s}return null},_.prototype.isInverted=function(){return this._isInverted},_.prototype.isTopToBottom=function(){return this._isTopToBottom},_.prototype.isVertical=function(){return this._isVertical},_.prototype.addTick=function(t,i,s,r,n,a,o){var l=new e.Line(this.getCtx(),i,r,s,n,o);return l.setStroke(a),l.setPixelHinting(!0),t.addChild(l),l},_.prototype.setVScrollPos=function(e){null!=this._canvas&&this._canvas.setTranslateY(0-e)},_.prototype.setHScrollPos=function(e){null!=this._canvas&&this._canvas.setTranslateX(0-e)};var h=function(e,t){this.Init(e,t)};e.Obj.createSubclass(h,e.Container),h.ENABLED_STATE_KEY="en",h.SELECTED_STATE_KEY="sel",h.ACTIVE_SELECTED_STATE_KEY="asel",h.HOVER_STATE_KEY="hl",h.prototype.Init=function(e,t){h.superclass.Init.call(this,e,"g",t)},h.prototype.setSelected=function(e){this._isSelected!=e&&(this._isSelected=e,e?this._isShowingHoverEffect?this.applyState(h.ACTIVE_SELECTED_STATE_KEY):this.applyState(h.SELECTED_STATE_KEY):this.applyState(h.ENABLED_STATE_KEY))},h.prototype.showHoverEffect=function(e){this._isShowingHoverEffect||(this._isShowingHoverEffect=!0,this._isSelected&&e?this.applyState(h.ACTIVE_SELECTED_STATE_KEY):this._isSelected?this.applyState(h.SELECTED_STATE_KEY):this.applyState(h.HOVER_STATE_KEY))},h.prototype.hideHoverEffect=function(e){this._isSelected&&e?this.applyState(h.ACTIVE_SELECTED_STATE_KEY):this._isSelected?this.applyState(h.SELECTED_STATE_KEY):this.applyState(h.ENABLED_STATE_KEY),this._isShowingHoverEffect=!1},h.prototype.applyState=function(t){var i=this._node,s=i.getBubble();if(null!=s){var r=s.getChildAt(0),n=r.getChildAt(0),a=i.getDurationBar();if(t==h.ACTIVE_SELECTED_STATE_KEY)var o=l.getItemSelectedFillColor(i),_=l.getItemSelectedStrokeColor(i),c=l.getItemSelectedStrokeWidth(),g=l.getItemInnerActiveStrokeColor();else t==h.SELECTED_STATE_KEY?(o=l.getItemSelectedFillColor(i),_=l.getItemSelectedStrokeColor(i),c=l.getItemSelectedStrokeWidth(),g=l.getItemInnerStrokeColor()):t==h.HOVER_STATE_KEY?(o=l.getItemHoverFillColor(i),_=l.getItemHoverStrokeColor(i),c=l.getItemHoverStrokeWidth(),g=l.getItemInnerActiveStrokeColor()):(o=l.getItemFillColor(i),_=l.getItemStrokeColor(i),c=l.getItemStrokeWidth(),g=l.getItemInnerStrokeColor());var u=l.getItemInnerStrokeWidth(),m=new e.Stroke(_,1,c),d=new e.Stroke(g,1,u);r.setSolidFill(o),r.setStroke(m),n.setStroke(d);var S=i.getFeeler();S&&S.setStroke(m),a&&a.setStroke(m)}};var c=new Object;e.Obj.createSubclass(c,e.Obj),c.renderItem=function(e,t,i,s,r,n){e._content?(c._renderBubble(e,t,i,r),c._displayBubble(e,t,s,null,!1)):(t._hasMvAnimations=!0,c._displayBubble(e,t,s,n,!0)),t.isVertical()||(e.getFeeler()&&t._allowUpdates?c._updateFeeler(e,t,s,n):c._renderFeeler(e,t,i.feelers,s,r))},c.initializeItem=function(e,t,i){e.getBubble()&&t._allowUpdates?c._updateBubble(e,t,i):c._createBubble(e,t,i)},c._createBubble=function(e,t,i){var s=c._getBubbleContent(e,t);e.setWidth(s._w+10),e.setHeight(s._h+10),e._content=s;var r=t.calculateSpacing(e,i);e.setSpacing(r)},c._renderBubble=function(t,i,s,r){var n=i.getCtx(),a=e.Agent.isRightToLeft(n),o=t.getId(),_=t._content;t._content=null;var c=t.getWidth(),g=t.getHeight(),u="_bubble_"+o;if(i.isVertical()){var m=g/2,d=m-6,S=m+6;if(!a&&i.isInverted()||a&&!i.isInverted())var v=[0,0,0,d,-6,m,0,S,0,g,c,g,c,0,0,0],f=[2,2,2,d,-4,m,2,S,2,g-2,c-2,g-2,c-2,2,2,2];else v=[0,0,0,g,c,g,c,S,c+6,m,c,d,c,0,0,0],f=[2,2,2,g-2,c-2,g-2,c-2,S,c+4,m,c-2,d,c-2,2,2,2]}else d=(m=a?c-l.getBubbleOffset():l.getBubbleOffset())-6,S=m+6,i.isInverted()?(v=[0,0,d,0,m,-6,S,0,c,0,c,g,0,g,0,0],f=[2,2,d,2,m,-4,S,2,c-2,2,c-2,g-2,2,g-2,2,2]):(v=[0,0,0,g,d,g,m,g+6,S,g,c,g,c,0,0,0],f=[2,2,2,g-2,d,g-2,m,g+4,S,g-2,c-2,g-2,c-2,2,2,2]);var p=new e.Polygon(n,v,u),T=new e.Polygon(n,f,u+"_i");T.setSolidFill(l.getItemInnerFillColor()),_.setTranslate(5,5),p.addChild(T),p.addChild(_);var b=new h(n,"_bt_"+o);r&&(b.setAlpha(0),r.push(b)),b.addChild(p),e.TimeAxis.supportsTouch()&&e.ToolkitUtils.setAttrNullNS(b._elem,"id",b._id),b._node=t,t.setBubble(b),b.applyState(h.ENABLED_STATE_KEY),t.getLoc()>=0&&s.addChild(b),b.setAriaRole("group"),i._callbackObj.EventManager.associate(b,t)},c._displayBubble=function(t,i,s,r,n){var a,o,_=i.getCtx(),c=e.Agent.isRightToLeft(_),g=t.getLoc(),u=t.getWidth(),m=t.getHeight(),d=t.getSpacing(),S=t.getBubble();n&&S.applyState(h.ENABLED_STATE_KEY),i.isVertical()?(o=g-m/2,c&&i.isInverted()||!c&&!i.isInverted()?a=i._size-(u+i._initialSpacing)+s:(a=i._initialSpacing,s=0)):(a=c?i._length-g-u+l.getBubbleOffset():g-l.getBubbleOffset(),i.isInverted()?(o=i.isTopToBottom()?d:i.Height-d-m+s+i._initialSpacing-l.getBubbleSpacing(),s=0):o=i.isTopToBottom()?d-i._initialSpacing+l.getBubbleSpacing():i.Height-d-m+s),r?(i.isVertical()?S.setTranslateX(S.getTranslateX()+i._canvasOffsetX+s):S.setTranslateY(S.getTranslateY()+i._canvasOffsetY+s),r.addProp(e.Animator.TYPE_NUMBER,S,S.getTranslateX,S.setTranslateX,a),r.addProp(e.Animator.TYPE_NUMBER,S,S.getTranslateY,S.setTranslateY,o)):S.setTranslate(a,o),t._updateAriaLabel()},c._getBubbleContent=function(t,i){var s=i.getCtx(),r=e.Agent.isRightToLeft(s),n=t.getTitle(),a=t.getDescription(),o=t.getThumbnail(),_=new e.Container(s),h=0,c=0,g=0,u=0,m=0;if(r){if(n&&((p=new e.OutputText(s,n,0,0)).setCSSStyle(l.getItemTitleStyle(t)),h=(T=p.getDimensions()).w,c=m=T.h,_.addChild(p)),a){(b=new e.OutputText(s,a,0,c)).setCSSStyle(l.getItemDescriptionStyle(t));var d=(T=b.getDimensions()).w;0!=h&&d!=h?d>h?(p.setX(d-h),h=d):b.setX(h-d):h=d,m=c+T.h,_.addChild(b)}o&&(S=l.getThumbnailWidth(),v=l.getThumbnailHeight(),h=0==h?0:h+l.getItemContentSpacing(),(f=new e.Image(s,o,h,0,S,v,"_tn")).setMouseEnabled(!1),_.addChild(f),g=S,u=v),_._w=h+g}else{if(o){var S=l.getThumbnailWidth(),v=l.getThumbnailHeight(),f=new e.Image(s,o,0,0,S,v,"_tn");f.setMouseEnabled(!1),_.addChild(f),h=S+l.getItemContentSpacing(),u=v}if(n){var p=new e.OutputText(s,n,h,0);p.setCSSStyle(l.getItemTitleStyle(t));var T=p.getDimensions();g=T.w,c=m=T.h,_.addChild(p)}if(a){var b=new e.OutputText(s,a,h,c);b.setCSSStyle(l.getItemDescriptionStyle(t)),T=b.getDimensions(),g=Math.max(g,T.w),m=c+T.h,_.addChild(b)}_._w=0==g?Math.max(h-l.getItemContentSpacing(),0):h+g}return _._h=Math.max(u,m),_},c._updateBubble=function(e,t,i){var s=t.calculateSpacing(e,i);e.setSpacing(s)},c._renderFeeler=function(t,i,s,r,n){var a,o=i.getCtx(),_=e.Agent.isRightToLeft(o),h=t.getId(),c=t.getLoc(),g=t.getSpacing(),u="_feeler_"+h;if(i.isInverted())m=t.getDurationSize(),d=i.isTopToBottom()?g:i.Height-g-t.getHeight()+r+i._initialSpacing-l.getBubbleSpacing();else{var m=i.Height+r-t.getDurationSize();if(i.isTopToBottom())d=g-i._initialSpacing+l.getBubbleSpacing()+t.getHeight();else var d=i.Height-g+r}a=_?i._length-c:c;var S=new e.Line(o,a,m,a,d,u);n&&(S.setAlpha(0),n.push(S)),s.addChild(S);var v=l.getItemStrokeWidth(),f=l.getItemStrokeColor(t),p=new e.Stroke(f,1,v);S.setStroke(p),S._node=t,t.setFeeler(S)},c._updateFeeler=function(t,i,s,r){if(i.isVertical())t.setFeeler(null);else{var n,a=i.getCtx(),o=e.Agent.isRightToLeft(a),_=t.getFeeler();if(i.isInverted())h=t.getDurationSize(),c=i.isTopToBottom()?t.getSpacing():i.Height-t.getSpacing()-t.getHeight()+s+i._initialSpacing-l.getBubbleSpacing(),s=0;else{var h=i.Height+s-t.getDurationSize();if(i.isTopToBottom())c=t.getSpacing()-i._initialSpacing+l.getBubbleSpacing()+t.getHeight();else var c=i.Height-t.getSpacing()+s}n=o?i._length-t.getLoc():t.getLoc(),r?(_.setY1(_.getY1()+i._canvasOffsetY+s),_.setY2(_.getY2()+i._canvasOffsetY+s),r.addProp(e.Animator.TYPE_NUMBER,_,_.getX1,_.setX1,n),r.addProp(e.Animator.TYPE_NUMBER,_,_.getY1,_.setY1,h),r.addProp(e.Animator.TYPE_NUMBER,_,_.getX2,_.setX2,n),r.addProp(e.Animator.TYPE_NUMBER,_,_.getY2,_.setY2,c)):(_.setX1(n),_.setY1(h),_.setX2(n),_.setY2(c))}},c.renderDuration=function(e,t,i,s,r,n){e.getDurationBar()?c._updateDuration(e,t,s,n):c._renderDuration(e,t,i,s,r)},c._renderDuration=function(t,i,s,r,n){var a=i.getCtx(),o=e.Agent.isRightToLeft(a),_=t.getStartTime(),h=t.getEndTime(),c=e.TimeAxis.getDatePosition(i._start,i._end,_,i._length),g="_duration_"+t.getId(),u=22+10*t.getDurationLevel(),m=e.TimeAxis.getDatePosition(i._start,i._end,h,i._length);if(i.isVertical()){if(!o&&!i.isInverted()||o&&i.isInverted())var d=new e.Rect(a,i._size-u+5,c,u,m-c,g);else d=new e.Rect(a,-5,c,u,m-c,g),r=0;d.setTranslateX(r),d.setY(c),d.setWidth(u),d.setHeight(m-c)}else{var S=m-c;if(o)v=i._length-c-S;else var v=c;i.isInverted()?(d=new e.Rect(a,v,-5,S,u,g)).setTranslateY(0):(d=new e.Rect(a,v,i._size-u+5,S,u,g)).setTranslateY(r)}n&&(d.setAlpha(0),n.push(d)),d.setCornerRadius(5),d.setSolidFill(t.getDurationFillColor());var f=l.getItemStrokeWidth(),p=l.getItemStrokeColor(t),T=new e.Stroke(p,1,f);d.setStroke(T),d._node=t,i._callbackObj.EventManager.associate(d,t),s.addChild(d),t.setDurationBar(d)},c._updateDuration=function(t,i,s,r){var n=i.getCtx(),a=e.Agent.isRightToLeft(n),o=t.getDurationBar();if(null!=o){var l=e.TimeAxis.getDatePosition(i._start,i._end,t.getStartTime(),i._length),_=22+10*t.getDurationLevel(),h=e.TimeAxis.getDatePosition(i._start,i._end,t.getEndTime(),i._length);if(i.isVertical()){var c=0;if(!a&&!i.isInverted()||a&&i.isInverted())var g=i._size-_+5;else g=-5,s=0;var u=s,m=l,d=_,S=h-l}else{u=0;var v=h-l;g=a?i._length-l-v:l,i.isInverted()?(s=0,c=0,m=-5,d=v,S=_):(c=s,m=i._size-_+5,d=v,S=_)}r?(i.isVertical()?o.setTranslateX(o.getTranslateX()+i._canvasOffsetX+s):o.setTranslateY(o.getTranslateY()+i._canvasOffsetY+s),r.addProp(e.Animator.TYPE_NUMBER,o,o.getTranslateX,o.setTranslateX,u),r.addProp(e.Animator.TYPE_NUMBER,o,o.getTranslateY,o.setTranslateY,c),r.addProp(e.Animator.TYPE_NUMBER,o,o.getX,o.setX,g),r.addProp(e.Animator.TYPE_NUMBER,o,o.getY,o.setY,m),r.addProp(e.Animator.TYPE_NUMBER,o,o.getWidth,o.setWidth,d),r.addProp(e.Animator.TYPE_NUMBER,o,o.getHeight,o.setHeight,S)):(o.setTranslateX(u),o.setTranslateY(c),o.setX(g),o.setY(m),o.setWidth(d),o.setHeight(S))}};var g=function(e,t,i){this.Init(e,t,i)};e.Obj.createSubclass(g,e.Obj),g.prototype.Init=function(e,t,i){this._timeline=e,this._seriesIndex=t,this._series=e._series[t],this._id=i.id,this._rowKey=i.rowKey,this._startTime=parseInt(i.startTime),i.endTime&&(this._endTime=parseInt(i.endTime)),this._title=i.title,this._desc=i.desc,this._thumbnail=i.thumbnail,this._shortDesc=i.shortDesc,this._style=i.style,this._data=i.data,this._durationFillColor=i.durationFillColor,this._durationSize=0,this._markerShape=i.markerShape,this._markerScaleX=i.markerScaleX,this._markerScaleY=i.markerScaleY,this._markerShortDesc=i.markerShortDesc,this._markerFillColor=i.markerFillColor,this._markerGradientFill=i.markerGradientFill,this._markerOpacity=i.markerOpacity,this._markerSD=i.markerSD,this._data=i.data},g.prototype.getId=function(){return this._id},g.prototype.getSeries=function(){return this._series},g.prototype.getSeriesIndex=function(){return this._seriesIndex},g.prototype.getRowKey=function(){return this._rowKey},g.prototype.getStartTime=function(){return this._startTime},g.prototype.setStartTime=function(e){this._startTime=e},g.prototype.getEndTime=function(){return this._endTime},g.prototype.setEndTime=function(e){this._endTime=e},g.prototype.getTitle=function(){return this._title},g.prototype.getDescription=function(){return this._desc},g.prototype.getThumbnail=function(){return this._thumbnail},g.prototype.getShortDesc=function(){return this._shortDesc},g.prototype.getStyle=function(){return this._style},g.prototype.setStyle=function(e){this._style=e},g.prototype.getBubble=function(){return this._displayable},g.prototype.setBubble=function(e){this._displayable=e},g.prototype.getFeeler=function(){return this._feeler},g.prototype.setFeeler=function(e){this._feeler=e},g.prototype.getDurationBar=function(){return this._durationBar},g.prototype.setDurationBar=function(e){this._durationBar=e},g.prototype.getLoc=function(){return this._loc},g.prototype.setLoc=function(e){this._loc=e},g.prototype.getSpacing=function(){return this._spacing},g.prototype.setSpacing=function(e){this._spacing=e},g.prototype.getDurationLevel=function(){return this._durationLevel},g.prototype.setDurationLevel=function(e){this._durationLevel=e},g.prototype.getDurationSize=function(){return this._durationSize},g.prototype.setDurationSize=function(e){this._durationSize=e},g.prototype.getDurationFillColor=function(){return this._durationFillColor},g.prototype.setDurationFillColor=function(e){this._durationFillColor=e},g.prototype.getLabel=function(){var t=this._timeline.getOptions().translations,i=this.getStartTime(),s=this._timeline.getTimeAxis().formatDate(new Date(i),null,"general"),r=e.ResourceUtils.format(t.accessibleItemStart,[s]),n=this.getEndTime();if(n&&n!=i){var a=this._timeline.getTimeAxis().formatDate(new Date(n),null,"general");r=r+" "+e.ResourceUtils.format(t.accessibleItemEnd,[a])}var o=this.getTitle();o&&""!=o&&(r=r+" "+e.ResourceUtils.format(t.accessibleItemTitle,[o]));var l=this.getDescription();return l&&""!=l&&(r=r+" "+e.ResourceUtils.format(t.accessibleItemDesc,[l])),r},g.prototype.getWidth=function(){return this._w},g.prototype.setWidth=function(e){this._w=e},g.prototype.getHeight=function(){return this._h},g.prototype.setHeight=function(e){this._h=e},g.prototype.getMarkerShape=function(){return this._markerShape},g.prototype.getMarkerScaleX=function(){return this._markerScaleX},g.prototype.getMarkerScaleY=function(){return this._markerScaleY},g.prototype.getMarkerShortDesc=function(){return this._markerShortDesc},g.prototype.getMarkerFillColor=function(){return this._markerFillColor},g.prototype.getMarkerGradientFill=function(){return this._markerGradientFill},g.prototype.getMarkerOpacity=function(){return this._markerOpacity},g.prototype.getMarkerSD=function(){return this._markerSD},g.prototype.getNextNavigable=function(t){var s=this._timeline.EventManager.getKeyboardHandler();if(t.type==e.MouseEvent.CLICK||s.isMultiSelectEvent(t))return this;if(s.isNavigationEvent(t)){for(var r=[],n=0;n<this._timeline._series.length;n++)r.push(this._timeline._series[n]._items);return i.getNextNavigable(this,t,r)}return null},g.prototype.getTargetElem=function(){return this._displayable.getElem()},g.prototype.getKeyboardBoundingBox=function(e){return this._displayable.getDimensions(e)},g.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect(),this._timeline.updateScrollForItemNavigation(this)},g.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()},g.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},g.prototype.getDisplayables=function(){return[this._displayable]},g.prototype.getAriaLabel=function(){var t=[];this.isSelectable()&&t.push(this._timeline.getOptions().translations[this.isSelected()?"stateSelected":"stateUnselected"]);var i=d.getDatatip(this,!1);return e.Displayable.generateAriaLabel(i,t)},g.prototype.getData=function(t){return t?e.TimeComponent.sanitizeData(this._data,"item"):this._data},g.prototype.getDataContext=function(){var e=this.getData()._itemData;return{data:this.getData(!0),seriesData:this._series.getData(!0),itemData:e||null,color:d.getDatatipColor(this),component:this._timeline.getOptions()._widgetConstructor}},g.prototype.getDatatip=function(){return d.getDatatip(this,!0)},g.prototype.getDatatipColor=function(){return d.getDatatipColor(this)},g.prototype.setSelectable=function(e){this._isSelectable=e},g.prototype.isSelectable=function(){return this._isSelectable},g.prototype.isSelected=function(){return this._isSelected},g.prototype.setSelected=function(e){this._isSelected=e,this._displayable.setSelected(e),this._updateAriaLabel(),this._timeline._hasOverview&&this._timeline._overview&&(e?this._timeline._overview.selSelectItem(this.getId()):this._timeline._overview.selUnselectItem(this.getId()))},g.prototype.showHoverEffect=function(e){var t=this._timeline.EventManager.getFocus()==this;this._displayable.showHoverEffect(t),!e&&this._timeline._hasOverview&&this._timeline._overview.highlightItem(this.getId()),(this._timeline._isVertical||this._series._isRandomItemLayout)&&(this._index||(this._index=this._series._blocks[0].getChildIndex(this.getBubble())),this._series._blocks[0].addChild(this.getBubble()))},g.prototype.hideHoverEffect=function(e){var t=this._timeline.EventManager.getFocus()==this;this._displayable.hideHoverEffect(t),!e&&this._timeline._hasOverview&&this._timeline._overview.unhighlightItem(this.getId()),(this._timeline._isVertical||this._series._isRandomItemLayout)&&this._index&&!this._isSelected&&this._series._blocks[0].addChildAt(this.getBubble(),this._index)},g.prototype._updateAriaLabel=function(){e.Agent.deferAriaCreation()||this._displayable.setAriaProperty("label",this.getAriaLabel())};var u=function(e){this._context=e};e.Obj.createSubclass(u,e.Obj),u.prototype.parse=function(e,t){var i=this.buildData(e),s=new Object;return s.start=new Date(e.start).getTime(),s.end=new Date(e.end).getTime(),s.inlineStyle=e.style,e.svgStyle&&(s.inlineStyle=e.svgStyle),s.scale=e.scale,s.timeAxis=e.timeAxis,s.label=e.label,s.emptyText=e.emptyText,s.isIRAnimationEnabled="auto"==e.animationOnDisplay,s.isDCAnimationEnabled="auto"==e.animationOnDataChange,s.items=this._parseDataNode(e.timeline,e.index,i.data,t,s.start,s.end),s.rtl="false",s.isRandomItemLayout=e._isRandomItemLayout,s.customTimeScales=e._cts,s.customFormatScales=e._cfs,null==e.itemLayout||"auto"==e.itemLayout?s.isTopToBottom=e.inverted:s.isTopToBottom="topToBottom"==e.itemLayout,s.data=e._data,s},u.prototype.buildData=function(e){var t={},i=[],s=e.items;if(s)for(var r=0;r<s.length;r++){var n=s[r];i.push(n)}return t.data=i,t},u.prototype._parseDataNode=function(e,t,i,s,r,n){var a=new Array,o=e._series[t];if(i)for(var l=0;l<i.length;l++){var _=this.ParseNodeAttributes(i[l],r,n);if(_){if(o._allowUpdates){var h=this._findExistingItem(_,s);if(h){var c=s.indexOf(h);s.splice(c,1),h.setSpacing(null),h.setDurationLevel(null),h.setLoc(null),h.setSelected(!1),h.setStartTime(_.startTime),h.setEndTime(_.endTime),h.setStyle(_.style)}else(h=new g(e,t,_)).setSelectable(!0)}else(h=new g(e,t,_)).setSelectable(!0);for(var u=h.getStartTime(),m=!0,d=0;d<a.length;d++)if(u<a[d].getStartTime()){a.splice(d,0,h),m=!1;break}m&&a.push(h)}}return a},u.prototype._findExistingItem=function(t,i){if(i)for(var s=0;s<i.length;s++){var r=i[s];if(e.Obj.compareValues(this._context,t.id,r.getId())&&t.title==r.getTitle()&&t.desc==r.getDescription()&&t.thumbnail==r.getThumbnail())return r}},u.prototype.getDate=function(e){return null==e?null:e.getTime?e.getTime():isNaN(e)?new Date(e).getTime()+0:e},u.prototype.ParseNodeAttributes=function(e,t,i){var s=new Object;return s.id=e.id,s.rowKey=s.id,s.startTime=this.getDate(e.start),s.endTime=this.getDate(e.end),(s.endTime?s.endTime:s.startTime)<t||s.startTime>i?null:(s.title=e.title,s.desc=e.description,s.thumbnail=e.thumbnail,s.shortDesc=e.shortDesc,s.data=e,s.style=e.style,e.svgStyle&&(s.style=e.svgStyle),s.durationFillColor=e.durationFillColor,s.markerShape=e._markerShape,s.markerScaleX=e._markerScaleX,s.markerScaleY=e._markerScaleY,s.markerShortDesc=e._markerShortDesc,s.markerFillColor=e._markerFillColor,s.markerGradientFill=e._markerGradientFill,s.markerOpacity=e._markerOpacity,0==e._markerSD?s.markerSD="false":s.markerSD="true",s.data=e,s)};var m=new Object;e.Obj.createSubclass(m,e.Obj),m.renderSeries=function(t,i,s){if(m._renderBackground(t,i,s),m._renderScrollableCanvas(t),m._renderReferenceObjects(t,t._canvas),m._renderSeriesTicks(t),null!=t._items){if(0==t._blocks.length){var r=t.getCtx(),n=new e.Container(r,"itemBlock_"+t._fetchStartPos+"_"+t._fetchEndPos);n.startPos=t._fetchStartPos,n.endPos=t._fetchEndPos;var a=new e.Container(r,"feelers");n.addChild(a),n.feelers=a;var o=new e.Container(r,"durations");n.addChild(o),n.durations=o,t._canvas.addChild(n),t._blocks.push(n)}else n=t._blocks[0];t.prepareDurations(t._items),t.prepareItems(t._items),t._isInitialRender?(t._isIRAnimationEnabled?t._frAnimationElems=[]:t._frAnimationElems=null,t._mvAnimator=null,t._rmAnimationElems=null):t._allowUpdates&&t._isDCAnimationEnabled?(t._frAnimationElems=[],t._mvAnimator=new e.Animator(t.getCtx(),l.getAnimationDuration(t.Options),0,e.Easing.cubicInOut),t._rmAnimationElems=[]):(t._frAnimationElems=null,t._mvAnimator=null,t._rmAnimationElems=null),t._hasMvAnimations=!1;var _=Math.max(0,t._maxOverflowValue-t._size);t._overflowOffset=_,m._adjustBackground(t,_),t._oldItems&&m._removeItems(t._oldItems,t,n,t._rmAnimationElems),t._oldItems=null,t.isVertical()&&n.feelers.removeChildren(),m._renderItems(t._items,t,n,t._fetchStartPos,t._fetchEndPos,_,t._frAnimationElems,t._mvAnimator),t._callbackObj.SelectionHandler&&n.setCursor(e.SelectionEffectUtils.getSelectingCursor()),m._updateReferenceObjects(t),m._updateSeriesTicks(t)}},m.updateSeriesForZoom=function(e){m._updateItemsForZoom(e._items,e),m._updateReferenceObjects(e),m._updateSeriesTicks(e)},m._renderBackground=function(t,i,s){if(t._background){var r=!1;t._background.setWidth(i),t._background.setHeight(s)}else r=!0,t._background=new e.Rect(t.getCtx(),0,0,i,s,"bg");t._background.setCSSStyle(t._style),t._background.setPixelHinting(!0),r&&t.addChild(t._background)},m._adjustBackground=function(t,i){var s=t.getCtx(),r=e.Agent.isRightToLeft(s);i>0&&(t.isVertical()?t._background.setWidth(t._maxOverflowValue):t._background.setHeight(t._maxOverflowValue)),t.isVertical()?(!t.isInverted()&&!r||t.isInverted()&&r)&&(t._background.setTranslateX(-i),t.setHScrollPos(i)):t.isInverted()||(t._background.setTranslateY(-i),t.setVScrollPos(i))},m._renderScrollableCanvas=function(t){if(t._canvas)return t._canvasOffsetX=t._canvas.getTranslateX(),t._canvasOffsetY=t._canvas.getTranslateY(),t._canvas.setTranslateX(0),void t._canvas.setTranslateY(0);t._canvas=new e.Container(t.getCtx(),"canvas"),t.addChild(t._canvas)},m._renderItems=function(t,i,s,r,n,a,o,l){for(var _=0;_<t.length;_++){var h=t[_],g=e.TimeAxis.getDatePosition(i._start,i._end,h.getStartTime(),i._length);g<r||g>n||c.renderItem(h,i,s,a,o,l)}if(e.TimeAxis.supportsTouch())for(_=0;_<t.length-1;_++){var u=(h=t[_]).getBubble();if(u){var d=t[_+1];if(!d.getBubble())break;u._setAriaProperty("flowto","_bt_"+d.getId())}}m._renderDurations(t,i,s,a,o,l)},m._updateItemsForZoom=function(t,i){if(null!=t&&0!=t.length){var s=i._fetchStartPos,r=i._fetchEndPos,n=i._blocks[0];n.startPos=s,n.endPos=r,i.isVertical()?i._initialSpacing=20*(i._maxDurationSize>0?1:0)+l.getBubbleSpacing()+10*i._maxDurationSize:i._initialSpacing=20+l.getBubbleSpacing()+10*i._maxDurationSize;for(var a=0;a<t.length;a++){var o=(S=t[a]).getStartTime(),_=e.TimeAxis.getDatePosition(i._start,i._end,o,i._length),h=S.getEndTime();if(h&&h!=o){var g=e.TimeAxis.getDatePosition(i._start,i._end,h,i._length)-_;_+=Math.min(l.getDurationFeelerOffset(),g/2)}S.setLoc(_),i._isRandomItemLayout||S.setSpacing(null)}for(a=0;a<t.length;a++){var u=(S=t[a]).getStartTime();u<i._start||u>i._end||c._updateBubble(S,i,a)}var d=Math.max(0,i._maxOverflowValue-i._size);m._adjustBackground(i,d);for(a=0;a<t.length;a++){var S=t[a];c._displayBubble(S,i,d,null,!1),c._updateFeeler(S,i,d,null),c._updateDuration(S,i,d,null)}}},m._renderDurations=function(e,t,i,s,r,n){for(var a=i.durations,o=t._maxDurationSize;o>0;o--)for(var l=0;l<e.length;l++){var _=e[l],h=_.getStartTime(),g=_.getEndTime();g&&g!=h&&o==_.getDurationLevel()&&c.renderDuration(_,t,a,s,r,n)}},m._renderSeriesTicks=function(t){if(null==t._seriesTicks?(t._seriesTicks=new e.Container(t.getCtx()),t._canvas.addChild(t._seriesTicks)):(t._seriesTicks.removeChildren(),t._seriesTicksArray=[]),t._scale&&t._timeAxis){var i=new e.CSSStyle(l.getSeriesAxisSeparatorStyle());if(t._axisStyleDefaults){var s=t._axisStyleDefaults.separatorColor;s&&i.parseInlineStyle("color:"+s+";")}t._separatorStroke=new e.Stroke(i.getStyle(e.CSSStyle.COLOR),1,1,!1,{dashArray:"3"}),m._renderSeriesTimeAxis(t,t._fetchStartPos,t._fetchEndPos,t._seriesTicks)}},m._updateSeriesTicks=function(t){for(var i=t.getCtx(),s=e.Agent.isRightToLeft(i),r=0;r<t._seriesTicksArray.length;r++){var n=t._seriesTicksArray[r];if(!t.isVertical()&&s)var a=t._length-e.TimeAxis.getDatePosition(t._start,t._end,n.time,t._length);else a=e.TimeAxis.getDatePosition(t._start,t._end,n.time,t._length);t.isVertical()?(n.setX1(0),n.setY1(a),n.setX2(t._maxOverflowValue),n.setY2(a)):(n.setX1(a),n.setY1(0),n.setX2(a),n.setY2(t._maxOverflowValue))}},m._renderSeriesTimeAxis=function(t,i,s,r){var n,a=t.getCtx(),o=e.Agent.isRightToLeft(a),l=t._start,_=t._end;if(t._customTimeScales&&t._customTimeScales[t._scale])n=t._customTimeScales[t._scale].times;else if(t._customFormatScales&&t._customFormatScales[t._scale]){n=t._customFormatScales[t._scale].times}else{n=[];var h=e.TimeAxis.getPositionDate(l,_,i,t._length),c=t._timeAxis.adjustDate(h),g=e.TimeAxis.getDatePosition(l,_,c,t._length);for(n.push(c.getTime());g<s;)c=t._timeAxis.getNextDate(c.getTime()),g=e.TimeAxis.getDatePosition(l,_,c,t._length),n.push(c.getTime())}for(var u=0;u<n.length-1;u++){var m=n[u];if(g=e.TimeAxis.getDatePosition(l,_,m,t._length),!t.isVertical()&&o)var d=t._length-g;else d=g;if(t.isVertical())var S=0,v=d,f=t._maxOverflowValue,p=d;else S=d,v=0,f=d,p=t._maxOverflowValue;var T=t.addTick(r,S,f,v,p,t._separatorStroke,"o_tick"+g);T.time=m,t._seriesTicksArray.push(T)}},m._renderReferenceObjects=function(t,i){var s=t.getCtx(),r=e.Agent.isRightToLeft(s);null==t._refObjectsContainer&&(t._refObjectsContainer=new e.Container(s),i.addChild(t._refObjectsContainer));var n=t._referenceObjects;if(n)for(var a=Math.min(1,n.length),o=0;o<a;o++){var _=n[o];if(_){var h=e.TimeAxis.getDatePosition(t._start,t._end,_,t._length);if(0==t._renderedReferenceObjects.length){if(t.isVertical())var c=new e.Line(s,0,h,t._maxOverflowValue,h,"zoomOrder[i]");else r&&(h=t._length-h),c=new e.Line(s,h,0,h,t._maxOverflowValue,"zoomOrder[i]");var g=new e.Stroke(l.getReferenceObjectColor(t.Options));c.setStroke(g),c.setPixelHinting(!0),c.date=_,t._refObjectsContainer.addChild(c),t._renderedReferenceObjects[o]=c}else(c=t._renderedReferenceObjects[o]).date=_,h=e.TimeAxis.getDatePosition(t._start,t._end,c.date,t._length),t.isVertical()?(c.setX1(0),c.setY1(h),c.setX2(t._maxOverflowValue),c.setY2(h)):(r&&(h=t._length-h),c.setX1(h),c.setY1(0),c.setX2(h),c.setY2(t._maxOverflowValue))}}else t._refObjectsContainer.removeChildren(),t._renderedReferenceObjects=[]},m._updateReferenceObjects=function(t){for(var i=t.getCtx(),s=e.Agent.isRightToLeft(i),r=0;r<t._renderedReferenceObjects.length;r++){var n=t._renderedReferenceObjects[r],a=e.TimeAxis.getDatePosition(t._start,t._end,n.date,t._length);t.isVertical()?(n.setX1(0),n.setY1(a),n.setX2(t._maxOverflowValue),n.setY2(a)):(s&&(a=t._length-a),n.setX1(a),n.setY1(0),n.setX2(a),n.setY2(t._maxOverflowValue))}},m._removeItems=function(e,t,i,s){if(s)m._animateItemRemoval(e,t,s);else for(var r=0;r<e.length;r++){var n=e[r],a=n.getBubble();if(i.removeChild(a),!t.isVertical()){var o=i.feelers,l=n.getFeeler();o.removeChild(l)}var _=n.getStartTime(),h=n.getEndTime();if(h&&h!=_){var c=i.durations,g=n.getDurationBar();c.removeChild(g)}}},m._animateItemRemoval=function(e,t,i){for(var s=0;s<e.length;s++){var r=e[s],n=r.getBubble();if(t.isVertical()?n.setTranslateX(n.getTranslateX()+t._canvasOffsetX+t._overflowOffset):n.setTranslateY(n.getTranslateY()+t._canvasOffsetY+t._overflowOffset),i.push(n),!t.isVertical()){var a=r.getFeeler();a.setTranslateY(a.getTranslateY()+t._canvasOffsetY+t._overflowOffset),i.push(a)}var o=r.getStartTime(),l=r.getEndTime();if(l&&l!=o){var _=r.getDurationBar();t.isVertical()?_.setTranslateX(_.getTranslateX()+t._canvasOffsetX+t._overflowOffset):_.setTranslateY(_.getTranslateY()+t._canvasOffsetY+t._overflowOffset),i.push(_)}}};var d=new Object;e.Obj.createSubclass(d,e.Obj),d.getDatatipColor=function(e){var t=e.getDurationFillColor();return t||null},d.getDatatip=function(t,i,s){var r=t._timeline,n=r.getOptions().tooltip,a=n?n.renderer:null;if(i&&a){var o=r.getCtx().getTooltipManager(),l=t.getDataContext();return o.getCustomTooltip(a,l)}var _=t.getShortDesc();if(null!=_)return _;if(s&&!r.getCtx().isCustomElement()){var h=r.getOptions().translations,c=t.getStartTime(),g=r.getTimeAxis().formatDate(new Date(c),null,"general"),u=e.ResourceUtils.format(h.accessibleItemStart,[g]),m=t.getEndTime();if(m&&m!=c){var S=r.getTimeAxis().formatDate(new Date(m),null,"general");u=u+" "+e.ResourceUtils.format(h.accessibleItemEnd,[S])}var v=t.getTitle();v&&""!=v&&(u=u+" "+e.ResourceUtils.format(h.accessibleItemTitle,[v]));var f=t.getDescription();return f&&""!=f&&(u=u+" "+e.ResourceUtils.format(h.accessibleItemDesc,[f])),u}var p=[];return d._addItemDatatip(p,t,i),d._processDatatip(p,r,i)},d._processDatatip=function(t,i,s){return 0===t.length?null:s?e.HtmlTooltipManager.createElement("table",i.getOptions().styleDefaults._tooltipStyle,t):t.join("")},d._addItemDatatip=function(e,t,i){var s=t._timeline,r=t.getTitle();r&&d._addDatatipRow(e,s,"title","Title",r,i);var n=t.getDescription();n&&d._addDatatipRow(e,s,"description","Description",n,i);var a=t.getStartTime(),o=t.getEndTime();a&&o&&o!=a?(d._addDatatipRow(e,s,"start","Start",a,i),d._addDatatipRow(e,s,"end","End",o,i)):d._addDatatipRow(e,s,"date","Date",a,i);var l=t._series.getLabel();null==l&&(l=t._series.getId()),d._addDatatipRow(e,s,"series","Series",l,i)},d._addDatatipRow=function(t,i,s,r,n,a,o){if(null!=n&&""!==n){var l,_=i.getOptions().styleDefaults,h=d.getValueFormat(i,s),c=h.tooltipDisplay,g=i.getOptions().translations;if("off"!=c)if("string"==typeof h.tooltipLabel&&(l=h.tooltipLabel),null==l&&(l=null==r?"":g["label"+r]),n=d.formatValue(i,s,h,n),a){var u=e.Agent.isRightToLeft(i.getCtx());_.tooltipLabelStyle.setStyle(e.CSSStyle.TEXT_ALIGN,u?"left":"right"),_.tooltipValueStyle.setStyle(e.CSSStyle.TEXT_ALIGN,u?"right":"left");var m=[e.HtmlTooltipManager.createElement("td",_.tooltipLabelStyle,l),e.HtmlTooltipManager.createElement("td",_.tooltipValueStyle,n)];t.push(e.HtmlTooltipManager.createElement("tr",null,m))}else t.push((t.length>0?"<br>":"")+e.ResourceUtils.format(g.labelAndValue,[l,n]))}},d.getValueFormat=function(e,t){var i=e.getOptions().valueFormats;if(!i)return{};if(i instanceof Array){for(var s={},r=0;r<i.length;r++){var n=i[r];s[n.type]=n}e.getOptions().valueFormats=s,i=s}return i[t]?i[t]:{}},d.formatValue=function(e,t,i,s){var r=i.converter;return"start"==t||"end"==t||"date"==t?e.getTimeAxis().formatDate(new Date(s),r,"general"):r&&r.format?r.format(s):s}}(dvt);
  return dvt;
});
