/**
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(['./DvtToolkit'], function(dvt) {
  "use strict";
  // Internal use only.  All APIs and functionality are subject to change at any time.

!function(t){t.Breadcrumbs=function(t,e,i,s){this.Init(t,e,i,s)},t.Obj.createSubclass(t.Breadcrumbs,t.Container),t.Breadcrumbs.prototype.Init=function(e,s,n,o){t.Breadcrumbs.superclass.Init.call(this,e),this.setOptions(o),this._eventHandler=new i(this,e,s,n),this._eventHandler.addListeners(this),this.setId("breadcrumbs1000"+Math.floor(1e9*Math.random())),this._curCrumbIdx=-1,this._keyboardFocusRect=null,this._crumbs=null},t.Breadcrumbs.prototype.setOptions=function(t){this._options=e.calcOptions(t)},t.Breadcrumbs.prototype.render=function(e,i){this._data=e?t.JsonUtils.clone(e):this._data,this.removeChildren(),this.SetCrumbs(null),n.render(this,this,i)},t.Breadcrumbs.prototype.__getData=function(){return this._data?this._data:{}},t.Breadcrumbs.prototype.__getOptions=function(){return this._options},t.Breadcrumbs.prototype.getEventManager=function(){return this._eventHandler},t.Breadcrumbs.prototype.hideKeyboardFocusEffect=function(){var t=this._curCrumbIdx;this._curCrumbIdx=-1,this._updateKeyboardFocusEffect(t,this._curCrumbIdx)},t.Breadcrumbs.prototype.getCurrentCrumbIndex=function(){return this._curCrumbIdx},t.Breadcrumbs.prototype.getNumCrumbs=function(){return this._data.items.length},t.Breadcrumbs.prototype.updateCrumbFocus=function(t){var e=this._curCrumbIdx;return this._curCrumbIdx=this._getUpdatedCrumbIndex(e,!t),this._updateKeyboardFocusEffect(e,this._curCrumbIdx),this._curCrumbIdx},t.Breadcrumbs.prototype._getUpdatedCrumbIndex=function(t,e){return-1==t?e?0:this._data.items.length-2:e?t==this._data.items.length-2?-1:++t:0==t?-1:--t},t.Breadcrumbs.prototype._updateKeyboardFocusEffect=function(e,i){var s=this._keyboardFocusRect,n=null,o=this.getCrumb(i);if(o){var a=this._eventHandler.GetLogicalObject(o);if(a&&a.isDrillable&&a.isDrillable()){var r=this.getCtx(),l=o.getDimensions(),h=o.getMatrix();n=new t.KeyboardFocusEffect(r,this,l,h),this._keyboardFocusRect=n}else this._keyboardFocusRect=null}s&&s.hide(),n&&n.show()},t.Breadcrumbs.prototype.getCrumb=function(t){var e=this.GetCrumbs();return t<0||!e||t>=e.length?null:e[t]},t.Breadcrumbs.prototype.getCrumbIndex=function(t){for(var e=this.GetCrumbs(),i=0;i<e.length;i++)if(e[i]==t)return i},t.Breadcrumbs.prototype.SetCrumbs=function(t){this._crumbs=t},t.Breadcrumbs.prototype.GetCrumbs=function(){return this._crumbs};var e=new Object;t.Obj.createSubclass(e,t.Obj),e.VERSION_1={labelStyle:t.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #003286;",disabledLabelStyle:t.BaseComponentDefaults.FONT_FAMILY_ALTA_11,__labelGap:4,__labelSeparator:">"},e.calcOptions=function(i){var s=e._getDefaults(i);return i?t.JsonUtils.merge(i,s):s},e._getDefaults=function(i){return t.JsonUtils.clone(e.VERSION_1)},e.getGapSize=function(t,e){return Math.ceil(e*t.layout.gapRatio)};var i=function(t,e,i,s){this.Init(e,i,s),this._breadcrumbs=t};t.Obj.createSubclass(i,t.EventManager),i.prototype.OnClick=function(t){i.superclass.OnClick.call(this,t),this._processBreadcrumbs(this.GetLogicalObject(t.target))},i.prototype.HandleTouchClickInternal=function(t){this._processBreadcrumbs(this.GetLogicalObject(t.target))},i.prototype._processBreadcrumbs=function(e){if(e&&e instanceof s&&e.isDrillable()){var i=t.EventFactory.newBreadcrumbsDrillEvent(e.getId());this.FireEvent(i,this._breadcrumbs)}},i.prototype.handleKeyboardEvent=function(e){var i=!0,s=e.keyCode;if(s==t.KeyboardEvent.TAB){var n=this._breadcrumbs.updateCrumbFocus(e.shiftKey);-1==n?i=!1:this.UpdateActiveElement(this._breadcrumbs.getCrumb(n))}else if(s==t.KeyboardEvent.ENTER){var o=this._breadcrumbs.getCrumb(this._breadcrumbs.getCurrentCrumbIndex());this._processBreadcrumbs(this.GetLogicalObject(o))}return i&&t.EventManager.consumeEvent(e),i};var s=function(t,e,i){this.Init(),this._id=t,this._bDrillable=!1,this._displayable=e,this._displayableText=i,this._truncated=!1};t.Obj.createSubclass(s,t.SimpleObjPeer),s.prototype.getId=function(){return this._id},s.prototype.isDrillable=function(){return this._bDrillable},s.prototype.setDrillable=function(t){this._bDrillable=t},s.prototype.getDisplayable=function(){return this._displayable},s.prototype.getTooltip=function(t){return this._truncated?this._displayableText:null},s.prototype.setTruncated=function(t){this._truncated=t};var n=new Object;t.Obj.createSubclass(n,t.Obj),n._TOUCH_BUFFER=3,n.render=function(e,i,o){for(var a=e.getCtx(),r=e.__getData().items?e.__getData().items:[],l=e.__getOptions(),h=e.getEventManager(),_=[],d=[],u=0;u<r.length;u++){var c=r[u];if(c){var p=c.label?c.label:"",g=n._createLabel(a,p,l,u<r.length-1);_.push(g);var f=new s(c.id,g,p);h.associate(g,f),d.push(f),u<r.length-1&&f.setDrillable(!0)}}e.SetCrumbs(_),t.Agent.isRightToLeft(a)?n._positionLabelsBidi(e,i,o,_,d):n._positionLabels(e,i,o,_,d)},n._createButtonState=function(e,i,s){var n=new t.OutputText(e,i,0,0);n.setMouseEnabled(!1),n.setCSSStyle(s);var o=s.getPadding(t.CSSStyle.PADDING_TOP),a=s.getPadding(t.CSSStyle.PADDING_RIGHT),r=s.getPadding(t.CSSStyle.PADDING_BOTTOM),l=s.getPadding(t.CSSStyle.PADDING_LEFT),h=t.DisplayableUtils.getDimensionsForced(e,n),_=new t.Rect(e,0,0,h.w+l+a,h.h+o+r);return _.setInvisibleFill(),_.setCSSStyle(s),n.setTranslate(l,o),_.addChild(n),_},n._createLabel=function(e,i,s,o){var a;if(o&&(s.labelStyleOver||s.labelStyleDown)){var r=new t.CSSStyle(s.labelStyle),l=new t.CSSStyle(s.labelStyleOver),h=new t.CSSStyle(s.labelStyleDown),_=n._createButtonState(e,i,r),d=n._createButtonState(e,i,l),u=n._createButtonState(e,i,h);(a=new t.Button(e,_,d,u)).setAriaRole("link"),a.setAriaProperty("label",i)}else{var c=o?s.labelStyle:s.disabledLabelStyle,p=new t.CSSStyle(c);p.getPadding(t.CSSStyle.PADDING_LEFT)||p.getPadding(t.CSSStyle.PADDING_RIGHT)||p.getPadding(t.CSSStyle.PADDING_TOP)||p.getPadding(t.CSSStyle.PADDING_BOTTOM)?a=n._createButtonState(e,i,p):(a=new t.OutputText(e,i,0,0)).setCSSStyle(p)}return a},n._getLabelTextString=function(e){return e instanceof t.Button?e.upState.getChildAt(0).getTextString():e instanceof t.Rect?e.getChildAt(0).getTextString():e.getTextString()},n._truncateLabels=function(e,i){if(e instanceof t.Button){var s=e.upState.getChildAt(0);return t.TextUtils.fitText(s,Math.max(i-s.getTranslateX(),0),1/0,s.getParent()),s=e.overState.getChildAt(0),t.TextUtils.fitText(s,Math.max(i-s.getTranslateX(),0),1/0,s.getParent()),s=e.downState.getChildAt(0),void t.TextUtils.fitText(s,Math.max(i-s.getTranslateX(),0),1/0,s.getParent())}if(e instanceof t.Rect){s=e.getChildAt(0);t.TextUtils.fitText(s,Math.max(i-s.getTranslateX(),0),1/0,s.getParent())}else t.TextUtils.fitText(e,i,1/0,e.getParent())},n._positionLabels=function(e,i,s,o,a){for(var r=e.__getOptions(),l=e.getEventManager(),h=[],_=0,d=0;d<o.length;d++){i.addChild(o[d]);var u=o[d].getDimensions();h[d]=u,_=Math.max(u.h,_),i.removeChild(o[d])}var c=0;for(d=0;d<o.length;d++){i.addChild(o[d]);u=h[d];if(o[d].setTranslate(c,.5*(_-u.h)),t.Agent.isTouchDevice()){var p=new t.Rect(i.getCtx(),-n._TOUCH_BUFFER,-n._TOUCH_BUFFER,u.w+2*n._TOUCH_BUFFER,u.h+2*n._TOUCH_BUFFER);p.setInvisibleFill(),o[d].addChild(p),d<a.length&&l.associate(p,a[d])}if(c+u.w>s){var g=n._getLabelTextString(o[d]);return n._truncateLabels(o[d],s-c),void(d<a.length?a[d].setTruncated(!0):l.associate(o[d],new t.SimpleObjPeer(g)))}if(c+=u.w+r.__labelGap,d<o.length-1){var f=n._newSeparator(e);i.addChild(f);var y=f.getDimensions();f.setTranslate(c,.5*(_-y.h));var E=y.w;if(c+E>s)return void i.removeChild(f);c+=E+r.__labelGap}}},n._positionLabelsBidi=function(e,i,s,o,a){for(var r=e.__getOptions(),l=e.getEventManager(),h=s,_=0;_<o.length;_++){i.addChild(o[_]);var d=o[_].getDimensions();if(t.Agent.isTouchDevice()){var u=new t.Rect(i.getCtx(),-n._TOUCH_BUFFER,-n._TOUCH_BUFFER,d.w+2*n._TOUCH_BUFFER,d.h+2*n._TOUCH_BUFFER);u.setInvisibleFill(),o[_].addChild(u),_<a.length&&l.associate(u,a[_])}if(h-d.w<0){var c=n._getLabelTextString(o[_]);return n._truncateLabels(o[_],h),o[_].setTranslateX(0),void(_<a.length?a[_].setTruncated(!0):l.associate(o[_],new t.SimpleObjPeer(c)))}if(o[_].setTranslateX(h-d.w),h-=d.w+r.__labelGap,_<o.length-1){var p=n._newSeparator(e);i.addChild(p);var g=p.getDimensions().w;if(h-g<0)return void i.removeChild(p);p.setTranslateX(h-g),h-=g+r.__labelGap}}},n._newSeparator=function(e){var i=e.__getOptions(),s=new t.OutputText(e.getCtx(),i.__labelSeparator,0,0);return s.setCSSStyle(new t.CSSStyle(i.labelStyle)),s};var o=function(){};t.Obj.createSubclass(o,t.BaseComponent),o.prototype.Init=function(t,e,i){o.superclass.Init.call(this,t,e,i),this.EventManager=this.CreateEventManager(this,t,this.dispatchEvent,this),this.EventManager.addListeners(this),this._legend=null,this._hasFocus=!1,this._navigableIdToFocus=null},o.prototype.SetOptions=function(e){if(e){if(this.Options=this.Defaults.calcOptions(e),t.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none"),this.Options._nodes=this.Options.nodes,this.Options.rootNode){this.Options._ancestors=null;var i=p.findRootAndAncestors(this.getCtx(),this.Options.nodes,this.Options.rootNode,[]);i&&i.root&&(this.Options.nodes=[i.root]),i&&i.ancestors&&(this.Options._ancestors=i.ancestors)}}else this.Options||(this.Options=this.GetDefaults())},o.prototype.render=function(e,i,s){var n=e||!this.Options;this.SetOptions(e);var o=this._processNodes();this.ApplyParsedProperties({root:o}),isNaN(i)||isNaN(s)||(this.Width=i,this.Height=s),this.EventManager&&this.EventManager.hideTooltip();var r=new t.Rectangle(0,0,this.Width,this.Height);this.Layout(r);var l=new t.Container(this.getCtx());this.addChild(l),this._templates&&(this._afContext=new t.AfContext(this.getCtx(),this.EventManager),this._afContext.setRmIfNotFit(!0)),this.Render(l,r),this.StopAnimation();var h=this.getOptions().animationOnDataChange,_=new t.Rectangle(0,0,this.Width,this.Height),d=!1;if(this._container){if(h&&n)if(t.BlackBoxAnimationHandler.isSupported(h))this.Animation=t.BlackBoxAnimationHandler.getCombinedAnimation(this.getCtx(),h,this._container,l,_,this.AnimationDuration),d=!0;else if(this._oldRoot&&"auto"==h){this._deleteContainer=this.GetDeleteContainer(),this.addChild(this._deleteContainer);var u=new a(this.getCtx(),this._deleteContainer);u.animate(this._oldRoot,this._root,this._oldAncestors,this._ancestors),this.Animation=u.getAnimation(!0)}}else this.Animation=this.GetDisplayAnimation(l,_);this._oldRoot=null,this._oldAncestors=null,this.Animation&&(this.EventManager.removeListeners(this),this.Animation.setOnEnd(this.OnAnimationEnd,this),this.Animation.play()),d?this._oldContainer=this._container:this._container&&this.removeChild(this._container),this._container=l,n?this._processInitialSelections():this.ReselectNodes(),this._processInitialFocus(!this.Animation),this.Animation||this._processInitialHighlighting(),this.UpdateAriaAttributes(),this.Animation||this.RenderComplete()},o.prototype.Parse=function(t){return null},o.prototype.Layout=function(t){},o.prototype.Render=function(t,e){},o.prototype.RenderBackground=function(e,i){var s=new t.Rect(this.getCtx(),0,0,this.Width,this.Height);s.setInvisibleFill(),e.addChild(s)},o.prototype.LayoutBreadcrumbs=function(t){if(this._ancestors.length>0){var e=this._root?this._root.getLabel():null;this._breadcrumbs&&this.EventManager.removeComponentKeyboardHandler(this._breadcrumbs.getEventManager()),this._breadcrumbs=_.render(this,t,this._ancestors,e),this.EventManager.addComponentKeyboardHandlerAt(this._breadcrumbs.getEventManager(),0)}else this._breadcrumbs&&this.EventManager.removeComponentKeyboardHandler(this._breadcrumbs.getEventManager()),this._breadcrumbs=null},o.prototype.RenderBreadcrumbs=function(t){this._breadcrumbs&&t.addChild(this._breadcrumbs)},o.prototype.LayoutLegend=function(t){this._legend=d.render(this,t,this._legendSource)},o.prototype.RenderLegend=function(t){this._legend&&(t.addChild(this._legend),this._legend=null)},o.prototype.RenderEmptyText=function(e){var i=this.getOptions(),s=i.emptyText;s||(s=i.translations.labelNoData),t.TextUtils.renderEmptyText(e,s,new t.Rectangle(0,0,this.Width,this.Height),this.getEventManager(),i._statusMessageStyle)},o.prototype.HasValidData=function(){return this._root&&this._root.getSize()>0},o.prototype.GetDisplayAnimation=function(e,i){var s=this.getOptions().animationOnDisplay;return t.BlackBoxAnimationHandler.isSupported(s)?t.BlackBoxAnimationHandler.getInAnimation(this.getCtx(),s,e,i,this.AnimationDuration):null},o.prototype.OnAnimationEnd=function(){this._deleteContainer&&(this.removeChild(this._deleteContainer),this._deleteContainer=null),this._oldContainer&&(this.removeChild(this._oldContainer),this._oldContainer=null),this.EventManager.addListeners(this),this._processInitialFocus(!0),this._processInitialHighlighting(),this.AnimationStopped||this.RenderComplete(),this.Animation=null,this.AnimationStopped=!1},o.prototype.GetDeleteContainer=function(){return new t.Container(this.getCtx())},o.prototype.CreateKeyboardHandler=function(t){return new u(t)},o.prototype.CreateEventManager=function(t,e,i,s){return new r(t,e,i,s)},o.prototype.GetInitialFocusedItem=function(t){if(t&&t.isArtificialRoot()){var e=t.getChildNodes();if(e&&e.length>0)return e[0]}return t},o.prototype.highlight=function(e){this.getOptions().highlightedCategories=t.JsonUtils.clone(e),t.CategoryRolloverHandler.highlight(e,p.getAllNodes(this._root),"any"==this.getOptions().highlightMatch)},o.prototype.select=function(e){var i=this.getOptions();if(i.selection=t.JsonUtils.clone(e),this._selectionHandler){var s=p.getAllNodes(this._root);this._selectionHandler.processInitialSelections(i.selection,s)}},o.prototype.__getMaxDepth=function(){return this._maxDepth},o.prototype.__getNodeCount=function(){return this._nodeCount},o.prototype.ApplyParsedProperties=function(e){var i=this.getOptions();this._oldRoot=this._root,this._oldAncestors=this._ancestors,this._root=e.root,this._ancestors=i._ancestors?i._ancestors:[],this._nodeCount=this._root?p.calcNodeCount(this._root):0,this._maxDepth=this._root?p.calcMaxDepth(this._root,0):0,this.AnimationDuration=t.CSSStyle.getTimeMilliseconds(i.animationDuration)/1e3,this._styles=e.styles?e.styles:{},"none"==i.selectionMode?this._nodeSelection=null:"single"==i.selectionMode?this._nodeSelection=t.SelectionHandler.TYPE_SINGLE:this._nodeSelection=t.SelectionHandler.TYPE_MULTIPLE,this._nodeSelection?(this._selectionHandler=new t.SelectionHandler(this.getCtx(),this._nodeSelection),this._initialSelection=i.selection):this._selectionHandler=null,this.EventManager.setSelectionHandler(this._selectionHandler),this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this._legendSource=null;var s=i._templates;if(s)for(var n in this._templates={},s){var o=t.AfComponentFactory.parseJsonElement(s[n]);this._templates[n]=o}},o.prototype.ReselectNodes=function(){for(var t=this._selectionHandler?this._selectionHandler.getSelection():new Array,e=0;e<t.length;e++)t[e].setSelected(!0)},o.prototype._processInitialSelections=function(){if(this._selectionHandler&&this._initialSelection){var t=p.getAllNodes(this._root);this._selectionHandler.processInitialSelections(this._initialSelection,t),this._initialSelection=null}},o.prototype._processInitialHighlighting=function(){var t=this.getOptions().highlightedCategories;t&&t.length>0&&this.highlight(t)},o.prototype._processInitialFocus=function(t){var e=null,i=this.__getNavigableIdToFocus();i&&(e=l.getNodeById(this._root,i),this.EventManager.setFocus(e)),t&&this.__setNavigableIdToFocus(null),e||(e=this.GetInitialFocusedItem(this._root),this.EventManager.setFocus(e)),t&&this.setFocused(this.isFocused())},o.prototype.setFocused=function(t){this._hasFocus=t,this.EventManager.setFocused(t)},o.prototype.isFocused=function(){return this._hasFocus},o.prototype.__getAnimationDuration=function(){return this.AnimationDuration},o.prototype.__getTemplate=function(t){return this._templates?this._templates[t]:null},o.prototype.__getAfContext=function(){return this._afContext},o.prototype.__getNodeUnderPoint=function(t,e){return this._root.getNodeUnderPoint(t,e)},o.prototype.__isDragAvailable=function(t){return this._selectionHandler?t[0]:null},o.prototype.__getDragTransferable=function(t){t.isSelected()||(this._selectionHandler.processClick(t,!1),this.EventManager.fireSelectionEvent());for(var e=[],i=this._selectionHandler.getSelection(),s=0;s<i.length;s++)e.push(i[s].getId());return e},o.prototype.__getDragFeedback=function(){for(var t=[],e=this._selectionHandler.getSelection(),i=0;i<e.length;i++)t.push(e[i].getDisplayable());return t},o.prototype.__showDropSiteFeedback=function(t){if(this._dropSiteFeedback&&(this.removeChild(this._dropSiteFeedback),this._dropSiteFeedback=null),t&&(this._dropSiteFeedback=t.getDropSiteFeedback(),this._dropSiteFeedback)){var e=this.getOptions().styleDefaults;this._dropSiteFeedback.setSolidFill(e._dropSiteFillColor,e._dropSiteOpacity),this._dropSiteFeedback.setSolidStroke(e._dropSiteBorderColor),this.addChild(this._dropSiteFeedback)}return this._dropSiteFeedback},o.prototype.__processBreadcrumbsEvent=function(t){"breadcrumbsDrill"===t.type&&this.__drill(t.id,!1)},o.prototype.__drill=function(e,i){var s=this.getOptions()._widgetConstructor;i&&this._root&&e==this._root.getId()&&this._ancestors.length>0?(this.__setNavigableIdToFocus(e),this.dispatchEvent(t.EventFactory.newTreeDrillEvent(this._ancestors[0].id,p.findRootAndAncestors(this.getCtx(),this.getOptions()._nodes,this._ancestors[0].id,[]).root,s))):i||this.dispatchEvent(t.EventFactory.newTreeDrillEvent(e,p.findRootAndAncestors(this.getCtx(),this.getOptions()._nodes,e,[]).root,s)),this.getCtx().getTooltipManager().hideTooltip()},o.prototype.getLogicalObject=function(t){return this.EventManager.GetLogicalObject(t)},o.prototype.getRootNode=function(){return this._root},o.prototype.__getNavigableIdToFocus=function(){return this._navigableIdToFocus},o.prototype.__setNavigableIdToFocus=function(t){this._navigableIdToFocus=t},o.prototype.__getNodeSelection=function(){return this._nodeSelection},o.prototype.CreateNode=function(t){return null},o.prototype.getAutomation=function(){return new g(this)},o.prototype.getBreadcrumbs=function(){return this._breadcrumbs},o.prototype._processNodes=function(){var e=this.getOptions();if(null==e.nodes||0==e.displayLevels)return null;var i=[],s=t.ArrayUtils.createBooleanMap(e.hiddenCategories);for(r=0;r<e.nodes.length;r++){var n=e.nodes[r];n._index=r;var o=this._processNode(s,n,e.displayLevels);o&&i.push(o)}if(1==i.length)return i[0];for(var a=0,r=0;r<i.length;r++)a+=i[r].getSize();var l={value:a,bArtificialRoot:!0,id:this._id},h=this.CreateNode(l);return h.setChildNodes(i),h},o.prototype._processNode=function(t,e,i){if(p.isHiddenNode(t,e))return null;var s=this.CreateNode(e);if(s.isDisclosed()&&i>1){for(var n=[],o=e.nodes?e.nodes:[],a=0;a<o.length;a++){var r=o[a];r._index=a;var l=this._processNode(t,r,null!=i?i-1:i);l&&n.push(l)}s.setChildNodes(n)}return s},o.prototype.UpdateAriaNavigation=function(e){if(t.Agent.isTouchDevice()||t.Agent.isEnvironmentTest())for(var i=p.getAllVisibleNodes(e),s=0;s<i.length-1;s++){var n=this.getId()+(i[s+1].getId()?i[s+1].getId():i[s+1].getLabel());n=n.replace(/\s+/g,""),i[s+1].getDisplayable().setId(n,!0),i[s].getDisplayable().setAriaProperty("flowto",n)}},o.prototype.hasDataProvider=function(){return!!this.getOptions().data};var a=function(t,e){this.Init(t,e)};t.Obj.createSubclass(a,t.DataAnimationHandler),a.prototype.animate=function(t,e,i,s){if(this._bDrill=!1,this._oldRoot=t,this._oldAncestors=i,a._isAncestor(s,t)||a._isAncestor(i,e)){this._bDrill=!0;var n=t.getDescendantNodes(),o=e.getDescendantNodes();n.push(t),o.push(e),this.constructAnimation(n,o)}else this.constructAnimation([t],[e])},a.prototype.isDrillAnimation=function(){return this._bDrill},a.prototype.isAncestorInsert=function(e){return!!this._bDrill&&(t.Obj.compareValues(this.getCtx(),this._oldRoot.getId(),e.getId())||a._isAncestor(this._oldAncestors,e))},a._isAncestor=function(t,e){if(!e||!t)return!1;for(var i=0;i<t.length;i++)if(t[i].id==e.getId())return!0;return!1};var r=function(t,e,i,s){this.Init(e,i,s,t),this._view=t};t.Obj.createSubclass(r,t.EventManager),r.prototype.GetView=function(){return this._view},r.prototype.OnDblClickInternal=function(t){var e=this.GetLogicalObject(t.target);e&&e.isSelectable&&e.isSelectable()&&this._processDrill(e,t.shiftKey)},r.prototype.OnClick=function(t){r.superclass.OnClick.call(this,t);var e=this.GetLogicalObject(t.target);this._processNodeLabel(e),!e||e.isSelectable&&e.isSelectable()||this._processDrill(e,t.shiftKey)},r.prototype.OnMouseOver=function(t){r.superclass.OnMouseOver.call(this,t);var e=this.GetLogicalObject(t.target);e&&e.handleMouseOver&&e.handleMouseOver()},r.prototype.OnMouseOut=function(e){r.superclass.OnMouseOut.call(this,e);var i=this.GetLogicalObject(e.target);if(i&&i.handleMouseOut){var s=this.GetLogicalObject(e.relatedTarget),n=s&&s.getId?s.getId():null;null!=i.getId()&&t.Obj.compareValues(this.getCtx(),n,i.getId())||i.handleMouseOut()}},r.prototype.ProcessKeyboardEvent=function(e){var i=!1,s=e.keyCode,n=this.getFocus();return s!=t.KeyboardEvent.ENTER||e.ctrlKey?i=r.superclass.ProcessKeyboardEvent.call(this,e):((n=this.getFocus()).isDrillReplaceEnabled&&n.isDrillReplaceEnabled()&&(e.shiftKey&&(n=this._view.getRootNode()),this._view.__drill(n.getId(),e.shiftKey)),t.EventManager.consumeEvent(e),i=!0),i},r.prototype.HandleTouchClickInternal=function(t){var e=t.target,i=this.GetLogicalObject(e);this._processNodeLabel(i),this._currentHoverItem&&this._currentHoverItem!=i&&(this._currentHoverItem.handleMouseOut(),this._currentHoverItem=null),i&&(i instanceof l&&this._currentHoverItem!=i&&(this._currentHoverItem=i,i.handleMouseOver()),i.isSelectable&&i.isSelectable()||this._processDrill(i,t.shiftKey))},r.prototype.HandleTouchDblClickInternal=function(t){var e=t.target,i=this.GetLogicalObject(e);i&&i.isSelectable&&i.isSelectable()&&this._processDrill(i,!1)},r.prototype._processNodeLabel=function(t){t&&t instanceof h&&t.isDrillable()&&this._view.__drill(t.getId(),!1)},r.prototype._processDrill=function(t,e){t.isDrillReplaceEnabled&&t.isDrillReplaceEnabled()&&this._view.__drill(t.getId(),e)},r.prototype.ProcessRolloverEvent=function(e,i,s){var n=this._view.getOptions();if("dim"==n.hoverBehavior){var o=i.getCategories?i.getCategories():[];n.highlightedCategories=s?o.slice():null;var a=t.EventFactory.newCategoryHighlightEvent(n.highlightedCategories,s),r=p.getAllNodes(this.GetView().getRootNode()),l=t.CSSStyle.getTimeMilliseconds(n.hoverBehaviorDelay);this.RolloverHandler.processEvent(a,r,l,"any"==n.highlightMatch)}},r.prototype.GetTouchResponse=function(){return this._view.getOptions().touchResponse};var l=function(){};t.Obj.createSubclass(l,t.Obj),l._ANIMATION_DELETE_PRIORITY=0,l._ANIMATION_UPDATE_PRIORITY=1,l._ANIMATION_INSERT_PRIORITY=2,l._DEFAULT_FILL_COLOR="#000000",l._DEFAULT_TEXT_SIZE=11,l.__NODE_SELECTED_SHADOW=new t.Shadow("#000000",2,5,5,45,.5),l.prototype.Init=function(e,i){this._view=e,this._options=i;var s=this._view.getOptions();this._id=i.id||i.label,this._color=i.color?i.color:l._DEFAULT_FILL_COLOR,this._textStr=i.label,this._labelStyle=i.labelStyle?new t.CSSStyle(i.labelStyle):null,this._pattern=i.pattern,this._selectable=i.selectable,this._shortDesc=i.shortDesc?i.shortDesc:i.tooltip,this._size=i.value;var n=i.drilling;this._drilling="on"==n||"off"==n?n:s.drilling,this._stampId=i.S,this._bArtificialRoot=i.bArtificialRoot,this._alpha=1,this._lastVisitedChild=null,this._isShowingKeyboardFocusEffect=!1,this.IsHover=!1},l.prototype.setChildNodes=function(t){if(null!=t)for(var e=0;e<t.length;e++)t[e]._parent=this;this._children=t},l.prototype.getChildNodes=function(){return this._children?this._children:[]},l.prototype.getDescendantNodes=function(){var t,e,i=[];if(!this.hasChildren())return i;for(var s=0;s<this._children.length;s++)t=(e=this._children[s]).getDescendantNodes(),i.push(e),i=i.concat(t);return i},l.prototype.SetLastVisitedChild=function(t){this._lastVisitedChild=t},l.prototype.GetLastVisitedChild=function(){return this._lastVisitedChild},l.prototype.MarkAsLastVisitedChild=function(){var t=this.GetParent();t&&t.SetLastVisitedChild(this)},l.prototype.isDescendantOf=function(t){return!(!t||!this.GetParent())&&(this.GetParent()==t||this.GetParent().isDescendantOf(t))},l.prototype.GetNodesAtDepth=function(t,e){var i=[];if(e<0)return i;if(0==e)return[this];if(t.hasChildren())for(var s,n=t.getChildNodes(),o=0;o<n.length;o++)s=n[o],i=i.concat(s.GetNodesAtDepth(s,e-1));return i},l.getNodeById=function(e,i){if(t.Obj.compareValues(e.getView().getCtx(),e.getId(),i))return e;for(var s=null,n=e.getChildNodes(),o=n.length,a=null,r=0;r<o;r++)if(a=n[r],s=l.getNodeById(a,i))return s;return null},l.prototype.getView=function(){return this._view},l.prototype.getStampId=function(){return this._stampId},l.prototype.getOptions=function(){return this._options},l.prototype.getCategories=function(){if(this.isArtificialRoot())return[];var t=this.getOptions().categories;if(!t&&!this.getView().hasDataProvider()){var e=this.GetParent(),i=e?e.getCategories():null;(t=i?i.slice():[]).push(this.getId())}return t},l.prototype.getId=function(){return this._id},l.prototype.getSize=function(){return this._size},l.prototype.getColor=function(){return this._color},l.prototype.getDatatip=function(){var t=this._view.getOptions().tooltip,e=t?t.renderer:null;return e?this.getView().getCtx().getTooltipManager().getCustomTooltip(e,this.getDataContext()):this._shortDesc},l.prototype.getDatatipColor=function(){return this._color},l.prototype.getShortDesc=function(){return this._shortDesc},l.prototype.getDataContext=function(){var e,i=this.getOptions(),s=i;return i._noTemplate?(e=i._itemData,s=i._itemData):i._itemData&&(e=i._itemData,s=i=t.JsonUtils.clone(i),delete i._itemData),{id:this.getId(),label:this.getLabel(),value:this.getSize(),color:this.getColor(),data:s,itemData:e,component:this.getView().getOptions()._widgetConstructor}},l.prototype.getIndex=function(){return this.getOptions()._index},l.prototype.getAlpha=function(){return this._alpha},l.prototype.setAlpha=function(t){this._alpha=t,this._shape&&this._shape.setAlpha(this._alpha)},l.prototype.setDisclosed=function(t){this.getOptions()._expanded=t},l.prototype.isDisclosed=function(){return!1!==this.getOptions()._expanded},l.prototype.isArtificialRoot=function(){return this._bArtificialRoot},l.prototype.isDrillReplaceEnabled=function(){return"on"==this._drilling},l.prototype.render=function(t){},l.prototype.renderChildren=function(t){var e=this.getChildNodes();if(null!=e)for(var i=0;i<e.length;i++)e[i].render(t)},l.prototype.getNextNavigable=function(t){return this.MarkAsLastVisitedChild(),this},l.prototype.getKeyboardBoundingBox=function(e){return new t.Rectangle(0,0,0,0)},l.prototype.getTargetElem=function(){return null},l.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect(),this.handleMouseOver&&this.handleMouseOver()},l.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect&&(this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()),this.handleMouseOut&&this.handleMouseOut()},l.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},l.prototype.handleMouseOver=function(){this.IsHover=!0},l.prototype.handleMouseOut=function(){this.IsHover=!1},l.prototype.isSelectable=function(){return"off"!=this._selectable&&null!=this.getView().__getNodeSelection()},l.prototype.isSelected=function(){return this._selected},l.prototype.setSelected=function(t){this._selected=t,this.UpdateAriaLabel()},l.prototype.showHoverEffect=function(){},l.prototype.hideHoverEffect=function(){},l.prototype.highlight=function(t,e){this.setAlpha(e)},l.prototype.isDragAvailable=function(t){return this.getView().__isDragAvailable(t)},l.prototype.getDragTransferable=function(t,e){return this.getView().__getDragTransferable(this)},l.prototype.getDragFeedback=function(t,e){return this.getView().__getDragFeedback()},l.prototype.getDropSiteFeedback=function(){return null},l.prototype.contains=function(t,e){return!1},l.prototype.getNodeUnderPoint=function(t,e){return null},l.prototype.GetAnimationParams=function(){return[]},l.prototype.SetAnimationParams=function(t){},l.prototype.animateUpdate=function(e,i){e.isDrillAnimation()||e.constructAnimation(i.getChildNodes(),this.getChildNodes());var s,n=this.GetAnimationParams(),o=i.GetAnimationParams(n);if(!t.ArrayUtils.equals(o,n)){(s=new t.CustomAnimation(this.getView().getCtx(),this,this.getView().__getAnimationDuration())).getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimationParams,this.SetAnimationParams,n),e.add(s,l._ANIMATION_UPDATE_PRIORITY);var a=this._size!=i._size,r=t.ColorUtils.getRGBA(this._color)!=t.ColorUtils.getRGBA(i._color);this.SetAnimationParams(o);var h=this._view.getOptions().animationUpdateColor;h&&(a||r)&&(this._color=h)}},l.prototype.animateInsert=function(e){if(!e.isDrillAnimation()||!e.isAncestorInsert(this)){this.setAlpha(0);var i=new t.AnimFadeIn(this.getView().getCtx(),this,this.getView().__getAnimationDuration());if(e.add(i,l._ANIMATION_INSERT_PRIORITY),this.hasChildren())for(var s=0;s<this._children.length;s++)this._children[s].animateInsert(e)}},l.prototype.animateDelete=function(e,i){i.addChild(this._shape);var s=new t.AnimFadeOut(this.getView().getCtx(),this,this.getView().__getAnimationDuration());if(e.add(s,l._ANIMATION_DELETE_PRIORITY),!e.isDrillAnimation()&&this.hasChildren())for(var n=0;n<this._children.length;n++)this._children[n].animateDelete(e,i)},l.prototype.hasChildren=function(){return null!=this._children&&this._children.length>0},l.prototype.hasDPChildren=function(){var t=this.getView().getOptions().data;if(t){var e=t.getChildDataProvider(this.getId());return!!e&&"yes"!==e.isEmpty()}return!1},l.prototype.hasPattern=function(){return this._pattern&&"none"!=this._pattern},l.prototype.GetParent=function(){return this._parent},l.prototype.GetDepth=function(){for(var t=0,e=this.GetParent();e;)t++,e=e.GetParent();return t},l.prototype.GetFill=function(){return this.hasPattern()?new t.PatternFill(this._pattern,this._color):new t.SolidFill(this._color)},l.GetNodeTextColor=function(e){return e.hasPattern()?"#000000":t.ColorUtils.getContrastingTextColor(e._color)},l.prototype.ApplyLabelTextStyle=function(e){var i=l.GetNodeTextColor(this);e.setSolidFill(i),e.setCSSStyle(this.getMergedLabelTextStyle()),t.Agent.isHighContrast()&&e.setSolidFill(i)},l.prototype.getMergedLabelTextStyle=function(){var e=new Array;return e.push(this._view.getOptions().nodeDefaults.labelStyle),this._labelStyle&&e.push(this._labelStyle),t.CSSStyle.mergeStyles(e)},l.prototype.GetTextSize=function(){var t=l._DEFAULT_TEXT_SIZE,e=this._view.getOptions().nodeDefaults.labelStyle.getFontSize();return e&&(t=parseFloat(e)),t},l.prototype.getLabelBackgroundColor=function(){var t=this._labelStyle,e=t?t.getStyle("background-color"):null;return e||this._view.getOptions().nodeDefaults.labelStyle.getStyle("background-color")},l.prototype.getDisplayable=function(){return this._shape},l.prototype.getLabel=function(){return this._textStr},l.prototype.GetAfContext=function(){return this.getView().__getAfContext()},l.prototype.GetElAttributes=function(){return this.getOptions()._cf},l.prototype.GetTemplate=function(){return this.getView().__getTemplate(this.getStampId())},l.prototype.isDoubleClickable=function(){return this.isDrillReplaceEnabled()},l.prototype.UpdateAriaLabel=function(){},l.prototype.isRootNode=function(){return t.Obj.compareValues(this.getView().getCtx(),this.getId(),this.getView().getRootNode().getId())||this.isArtificialRoot()};var h=function(t,e,i,s,n){this.Init(i,s,n),this._node=t,this._id=e,this._bDrillable=!1};t.Obj.createSubclass(h,t.SimpleObjPeer),h.prototype.getId=function(){return this._id},h.prototype.isDrillable=function(){return this._bDrillable},h.prototype.setDrillable=function(t){this._bDrillable=t},h.prototype.handleMouseOver=function(){this._node&&this._node.handleMouseOver&&this._node.handleMouseOver()},h.prototype.handleMouseOut=function(){this._node&&this._node.handleMouseOut&&this._node.handleMouseOut()};var _=function(){};t.Obj.createSubclass(_,t.Obj),_._COMPONENT_GAP=6,_._ENABLED_INLINE_STYLE="color: #003286;",_.render=function(e,i,s,n){var o=e.getCtx(),a=e.getOptions().styleDefaults,r=new Array;r.push(new t.CSSStyle(_._ENABLED_INLINE_STYLE)),r.push(a._drillTextStyle);var l=t.CSSStyle.mergeStyles(r).toString(),h=l+"text-decoration: underline;",d=new Array;d.push(a._currentTextStyle);var u={labelStyle:l,labelStyleOver:h,labelStyleDown:h,disabledLabelStyle:t.CSSStyle.mergeStyles(d).toString()},c=new t.Breadcrumbs(o,e.__processBreadcrumbsEvent,e,u);e.addChild(c);var p=s.slice(0).reverse();p.push({label:n});var g={items:p};c.render(g,i.w);var f=c.getDimensions();c.setTranslate(i.x,i.y);var y=f.h+_._COMPONENT_GAP;return i.y+=y,i.h-=y,e.removeChild(c),c};var d=function(){};t.Obj.createSubclass(d,t.Obj),d._LEGEND_GAP=4,d._LEGEND_LABEL_GAP=7,d._LEGEND_SECTION_GAP=24,d._LABEL_SIZE=11,d._LABEL_COLOR="#636363",d._LABEL_INLINE_STYLE="color:"+d._LABEL_COLOR+";",d.render=function(e,i){var s=e.getOptions(),n=s.sizeLabel,o=s.colorLabel;if(null!=n||null!=o){var a=e.getCtx(),r=(e.getEventManager(),new t.Container(a));e.addChild(r);var l=d._renderLabels(a,e,r,i.w,n,o);(new Array).push(s.styleDefaults._labelStyle);var h=l?l.getDimensions():null;l&&l.setTranslateX(i.y+(i.w-h.w)/2);var _=r.getDimensions();return r.setTranslateY(i.y+i.h-_.h),i.h-=_.h+d._LEGEND_GAP,e.removeChild(r),r}},d._renderLabels=function(e,i,s,n,o,a){var r=t.Agent.isRightToLeft(e),l=i.getEventManager(),h=i.getOptions().styleDefaults,_=null;if(o||a){_=new t.Container(e),s.addChild(_);var u=new Array;u.push(h._attributeTypeTextStyle);var c=t.CSSStyle.mergeStyles(u);(u=new Array).push(h._attributeValueTextStyle);var p,g,f,y,E,S,v,C,b=t.CSSStyle.mergeStyles(u),A=0;if(o){var T=i.getOptions().translations.labelSize;(p=new t.OutputText(e,T,0,0)).setCSSStyle(c),_.addChild(p),f=p.getDimensions().w,(g=new t.OutputText(e,o,0,0)).setCSSStyle(b),_.addChild(g),A=f+(y=g.getDimensions().w)+d._LEGEND_LABEL_GAP}var O=0;if(a){var I=i.getOptions().translations.labelColor;(E=new t.OutputText(e,I,0,0)).setCSSStyle(c),_.addChild(E),v=E.getDimensions().w,(S=new t.OutputText(e,a,0,0)).setCSSStyle(b),_.addChild(S),O=v+(C=S.getDimensions().w)+d._LEGEND_LABEL_GAP}if(A+O>(n-=d._LEGEND_SECTION_GAP)){var R=n/2;if(A>R&&O>R){var m=R-f-d._LEGEND_LABEL_GAP;t.TextUtils.fitText(g,m,1/0,_)?(y=g.getDimensions().w,l.associate(g,new t.SimpleObjPeer(o))):(_.removeChild(p),_.removeChild(g),g=null,y=0);var D=R-v-d._LEGEND_LABEL_GAP;t.TextUtils.fitText(S,D,1/0,_)?(C=S.getDimensions().w,l.associate(S,new t.SimpleObjPeer(a))):(_.removeChild(E),_.removeChild(S),S=null,C=0)}else A>O?t.TextUtils.fitText(g,n-O-f-d._LEGEND_LABEL_GAP,1/0,_)?(y=g.getDimensions().w,l.associate(g,new t.SimpleObjPeer(o))):(_.removeChild(p),_.removeChild(g),g=null,y=0):t.TextUtils.fitText(S,n-A-v-d._LEGEND_LABEL_GAP,1/0,_)?(C=S.getDimensions().w,l.associate(S,new t.SimpleObjPeer(a))):(_.removeChild(E),_.removeChild(S),S=null,C=0)}var x=0;r?(S&&(S.setX(x),x+=C+d._LEGEND_LABEL_GAP,E.setX(x),x+=v+d._LEGEND_SECTION_GAP),g&&(g.setX(x),x+=y+d._LEGEND_LABEL_GAP,p.setX(x))):(g&&(p.setX(x),x+=f+d._LEGEND_LABEL_GAP,g.setX(x),x+=y+d._LEGEND_SECTION_GAP),S&&(E.setX(x),x+=v+d._LEGEND_LABEL_GAP,S.setX(x)))}return _};var u=function(t){this.Init(t)};t.Obj.createSubclass(u,t.KeyboardHandler),u.prototype.isSelectionEvent=function(t){return this.isNavigationEvent(t)&&!t.ctrlKey},u.prototype.isMultiSelectEvent=function(e){return e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey};var c=function(){};t.Obj.createSubclass(c,t.BaseComponentDefaults),c.SKIN_ALTA={skin:t.CSSStyle.SKIN_ALTA,animationDuration:500,animationOnDataChange:"none",animationOnDisplay:"none",drilling:"off",displayLevels:Number.MAX_VALUE,highlightMatch:"all",hoverBehavior:"none",hoverBehaviorDelay:200,nodeDefaults:{labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11),labelMinLength:1},selectionMode:"multiple",sorting:"off",_statusMessageStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),styleDefaults:{_attributeTypeTextStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_12+"color:#4F4F4F"),_attributeValueTextStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12),_currentTextStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12),_drillTextStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12),_labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA)},touchResponse:"auto",_resources:{}},c.prototype.Init=function(e){var i={alta:t.JsonUtils.merge(e.alta,c.SKIN_ALTA)};c.superclass.Init.call(this,i)},c.prototype.getAnimationDuration=function(t){return t.animationDuration};var p={};t.Obj.createSubclass(p,t.Obj),p.calcMaxDepth=function(t,e){var i=e,s=t.getChildNodes();if(s)for(var n=0;n<s.length;n++){var o=p.calcMaxDepth(s[n],e+1);i=Math.max(i,o)}return i},p.calcNodeCount=function(t){var e=1,i=t.getChildNodes();if(i)for(var s=0;s<i.length;s++)e+=p.calcNodeCount(i[s]);return e},p.getAllNodes=function(t){var e=[];return p._addNodesToArray(t,e),e},p.getAllVisibleNodes=function(t){var e=[];return p._addNodesToArray(t,e,!1,!0),e},p.getLeafNodes=function(t){var e=[];return p._addNodesToArray(t,e,!0),e},p.isHiddenNode=function(e,i){return t.ArrayUtils.hasAnyMapItem(e,i.categories)},p._addNodesToArray=function(t,e,i,s){if(t){var n=t.getChildNodes(),o=n?n.length:0;i&&0!=o||s&&!t.getDisplayable()||e.push(t);for(var a=0;a<o;a++)p._addNodesToArray(n[a],e,i,s)}},p.findRootAndAncestors=function(e,i,s,n){for(var o=0;o<i.length;o++){if(t.Obj.compareValues(e,i[o].id,s))return{root:i[o],ancestors:n};if(i[o].nodes){n.unshift(i[o]);var a=p.findRootAndAncestors(e,i[o].nodes,s,n);if(null!=a)return a;n.shift()}}return null};var g=function(t){this._treeView=t};t.Obj.createSubclass(g,t.Automation),g.NODE_ID_PREFIX="node",g.BREADCRUMBS_PREFIX="breadcrumbs",g.DISCLOSURE_SUFFIX="disclosure",g.ISOLATE_SUFFIX="isolate",g.RESTORE="restore",g.prototype.GetSubIdForDomElement=function(e){var i=this._treeView.getLogicalObject(e),s=this._treeView.getRootNode(),n=e instanceof t.Button;if(e.getParent()instanceof t.Button&&(e=e.getParent(),n=!0),!i){var o=e.getParent();return o instanceof t.Breadcrumbs?g.BREADCRUMBS_PREFIX+"["+o.getCrumbIndex(e)+"]":null}var a=null;if(i instanceof h&&n){var r=i._node;return a=this.GetSubIdForDomElement(r.getDisplayable()),this._getSubIdForButton(a,r,e)}if(i instanceof l){var _=i,d="";if(!s.isArtificialRoot()){if(_==s)return g.NODE_ID_PREFIX+"[0]";d+="[0]"}var u=this._getIndicesFromNode(_,s.getChildNodes());return(d=u?d+u:d).length>0&&(a=g.NODE_ID_PREFIX+d),n?this._getSubIdForButton(a,i,e):a}return null},g.prototype._getSubIdForButton=function(t,e,i){if(t){if(e instanceof f){var s=i.getAriaProperty("label"),n=options.translations.stateIsolated;return s.indexOf(n)>=0?g.RESTORE:t+":"+g.ISOLATE_SUFFIX}if(e instanceof A)return t+":"+g.DISCLOSURE_SUFFIX}return null},g.prototype._getIndicesFromNode=function(t,e){if(e&&e.length>0)for(var i=0;i<e.length;i++){if(e[i]==t)return"["+i+"]";var s=this._getIndicesFromNode(t,e[i].getChildNodes());if(s)return"["+i+"]"+s}return null},g.prototype.getDomElementForSubId=function(e){if(!e)return null;var i=this._treeView.getRootNode();if(e==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._treeView);if(0==e.indexOf(g.BREADCRUMBS_PREFIX)){var s=e.substring(e.indexOf("[")+1,e.indexOf("]")),n=i.getView().getBreadcrumbs().getCrumb(s);return n?n.getElem():null}if(e==g.RESTORE){var o=this._treeView._restoreNode||this._treeView.__getLastIsolatedNode();if(o)return o.getIsolateRestoreButton().getElem()}i.isArtificialRoot()||(e=e.substring(0,e.indexOf("["))+e.substring(e.indexOf("]")+1));var a=-1==e.indexOf("[")?i:this._getNodeFromSubId(i,e);if(a){var r=e.indexOf(":");if(!(r>=0))return a.getDisplayable().getElem();if(e=e.substring(r+1),a instanceof A&&e==g.DISCLOSURE_SUFFIX){var l=a.getExpandCollapseButton();if(l)return l.getElem()}if(a instanceof f&&e==g.ISOLATE_SUFFIX){var h=a.getIsolateRestoreButton();if(h)return h.getElem()}}return null},g.prototype._getNodeFromSubId=function(t,e){var i=e.indexOf("["),s=e.indexOf("]");if(i>=0&&s>=0){var n=e.substring(i+1,s),o=(e=e.substring(s+1)).indexOf("["),a=e.indexOf("]"),r=g._getNodeByIndex(t.getChildNodes(),n);return r&&o>=0&&a>=0?this._getNodeFromSubId(r,e):r}},g.prototype._getNodeFromPath=function(t,e){var i=e.shift(),s=g._getNodeByIndex(t.getChildNodes(),i);return 0==e.length?s:e.length>0?this._getNodeFromPath(s,e):null},g.prototype.getNode=function(t){var e=this._treeView.getRootNode();if(!e)return null;e.isArtificialRoot()||0!=t[0]||t.shift();var i=0==t.length?e:this._getNodeFromPath(e,t);return i?{color:i.getColor(),label:i.getLabel(),selected:null!=i.isSelected()&&i.isSelected(),size:i.getSize(),tooltip:i.getShortDesc()}:null},g._getNodeByIndex=function(t,e){for(var i=0;i<t.length;i++)if(e==t[i].getIndex())return t[i];return null},t.Treemap=function(t,e,i){this.Init(t,e,i)},t.Obj.createSubclass(t.Treemap,o),t.Treemap._BUFFER_SPACE=7,t.Treemap._MIN_BUFFER_SPACE=1,t.Treemap._BACKGROUND_FILL_COLOR="#EBEFF5",t.Treemap._BACKGROUND_BORDER_COLOR="#DBE0EA",t.Treemap._BACKGROUND_INLINE_DEFAULT="background-color:"+t.Treemap._BACKGROUND_FILL_COLOR+";border-color:"+t.Treemap._BACKGROUND_BORDER_COLOR+";border-width:2px",t.Treemap.newInstance=function(e,i,s){return new t.Treemap(e,i,s)},t.Treemap.prototype.Init=function(e,i,s){t.Treemap.superclass.Init.call(this,e,i,s),this.Defaults=new b(e),this._nodeContent={},this.setId("treemap1000"+Math.floor(1e9*Math.random()))},t.Treemap.prototype.ApplyParsedProperties=function(e){t.Treemap.superclass.ApplyParsedProperties.call(this,e);var i=this.getOptions();"sliceAndDiceHorizontal"==i.layout?this._layout=new S(!0):"sliceAndDiceVertical"==i.layout?this._layout=new S(!1):this._layout=new E,this._isolatedNodes=[],this._processInitialIsolate(i.isolatedNode),"auto"==i.animationOnDisplay&&(i.animationOnDisplay="alphaFade")},t.Treemap.prototype.Layout=function(e){var i="jet"!=this.getOptions()._environment?t.Treemap._BUFFER_SPACE:t.Treemap._MIN_BUFFER_SPACE;i=Math.max(Math.ceil(i*Math.min(e.w,e.h)/400),t.Treemap._MIN_BUFFER_SPACE),e.x+=i,e.y+=i,e.w-=2*i,e.h-=2*i;var s=this._layout.getGapSize(this,1);e.x+=s,e.w-=2*s,this.LayoutBreadcrumbs(e),this.LayoutLegend(e),e.x-=s,e.w+=2*s;var n=this._isolatedNodes.length;if(n>0&&this._isolateRestoreLayout){var o=this._isolatedNodes[n-1];this._layout.layout(this,o,e.x,e.y,e.w,e.h,!0)}else{this._root&&this._layout.layout(this,this._root,e.x,e.y,e.w,e.h,!1);for(var a=0;a<n;a++){var r=this._isolatedNodes[a];this._layout.layout(this,r,e.x,e.y,e.w,e.h,!0)}}},t.Treemap.prototype.Render=function(e,i){if(this.RenderBackground(e,t.Treemap._BACKGROUND_INLINE_DEFAULT),this.RenderBreadcrumbs(e),this.RenderLegend(e),this.HasValidData()){this._groupTextLayer=new t.Container(this.getCtx()),e.addChild(this._groupTextLayer),this._isolatedNode?this._isolatedNode.render(e):this._root.hasChildren()?(this._root.renderChildren(e),this.UpdateAriaNavigation(this._root)):this._root.render(e),this._isolatedLayer=new t.Container(this.getCtx()),e.addChild(this._isolatedLayer),this._selectedLayer=new t.Container(this.getCtx()),e.addChild(this._selectedLayer),e.addChild(this._groupTextLayer),this._hoverEffect=new t.Rect(this.getCtx(),0,0,0,0),this._hoverEffect.setVisible(!1),this._hoverEffect.setMouseEnabled(!1),this._hoverEffect.setPixelHinting(!0),this._hoverEffect.setInvisibleFill(),e.addChild(this._hoverEffect);for(var s=0;s<this._isolatedNodes.length;s++){var n=this._isolatedNodes[s].getDisplayable();this._isolatedLayer.addChild(n)}}else this.RenderEmptyText(e)},t.Treemap.prototype.OnAnimationEnd=function(){if(!this.AnimationStopped){this._container.removeChildren();var e=new t.Rectangle(0,0,this.Width,this.Height);this.Layout(e),this.Render(this._container),this.ReselectNodes()}t.Treemap.superclass.OnAnimationEnd.call(this)},t.Treemap.prototype.ReselectNodes=function(){for(var t=this._selectionHandler?this._selectionHandler.getSelection():new Array,e=0;e<t.length;e++)if(this._isolatedNodes.length>0){var i=this._isolatedNodes[this._isolatedNodes.length-1];(t[e]==i||t[e].isDescendantOf(i))&&t[e].setSelected(!0)}else t[e].setSelected(!0)},t.Treemap.prototype.CreateKeyboardHandler=function(t){return new v(t)},t.Treemap.prototype.CreateEventManager=function(t,e,i,s){return new C(t,e,i,s)},t.Treemap.prototype.GetInitialFocusedItem=function(t){var e=this.__getLastIsolatedNode();return e?this.__getDefaultNavigable(p.getLeafNodes(e)):t?this.__getDefaultNavigable(p.getLeafNodes(t)):null},t.Treemap.prototype.__showHoverEffect=function(t,e,i,s,n){this._hoverEffect.setX(t).setY(e).setWidth(i).setHeight(s),this._hoverEffect.setStroke(n),this._hoverEffect.setVisible(!0)},t.Treemap.prototype.__hideHoverEffect=function(){this._hoverEffect.setVisible(!1)},t.Treemap.prototype.__getGroupTextLayer=function(){return this._groupTextLayer},t.Treemap.prototype.__moveToSelectedLayer=function(t){for(var e=0,i=this._selectedLayer.getNumChildren(),s=0;s<i;s++){var n=this._selectedLayer.getChildAt(s);t.zIndex>n.zIndex&&(e=s+1)}e<i?this._selectedLayer.addChildAt(t,e):this._selectedLayer.addChild(t)},t.Treemap.prototype.__getNodeUnderPoint=function(t,e){return this._isolatedNodes.length>0?this._isolatedNodes[this._isolatedNodes.length-1].getNodeUnderPoint(t,e):this._root.getNodeUnderPoint(t,e)},t.Treemap.prototype.__isolate=function(e){var i=this.getEventManager().getFocus();i&&i.hideKeyboardFocusEffect(),this._isolatedNodes.push(e),this.getOptions().isolatedNode=e.getId(),this.dispatchEvent(t.EventFactory.newTreemapIsolateEvent(e.getId())),this._isolateRestoreLayout=!0,this.Layout(new t.Rectangle(0,0,this.Width,this.Height)),this._isolateRestoreLayout=!1;var s=e.getDisplayable();this._isolatedLayer.addChild(s),this._renderIsolateRestore(e)},t.Treemap.prototype.__restore=function(){this._restoreNode=this._isolatedNodes.pop(),this.getOptions().isolatedNode=this._isolatedNodes.length>0?this._isolatedNodes[this._isolatedNodes.length-1].getId():null;var e=this.getEventManager().getFocus();e&&e.hideKeyboardFocusEffect(),this.__setNavigableIdToFocus(this._restoreNode.getId()),this.dispatchEvent(t.EventFactory.newTreemapIsolateEvent()),this._isolateRestoreLayout=!0,this.Layout(new t.Rectangle(0,0,this.Width,this.Height)),this._isolateRestoreLayout=!1,this._renderIsolateRestore(this._restoreNode),this._restoreNode=null},t.Treemap.prototype.__getLastIsolatedNode=function(){return this._isolatedNodes&&this._isolatedNodes.length>0?this._isolatedNodes[this._isolatedNodes.length-1]:null},t.Treemap.prototype._renderIsolateRestore=function(e){if("none"!=this.getOptions().animationOnDataChange){for(var i=this._selectionHandler?this._selectionHandler.getSelection():new Array,s=0;s<i.length;s++)i[s].setSelected(!1);var n=e.getIsolateAnimation();this.Animation=new t.ParallelPlayable(this.getCtx(),n),this.Animation.setOnEnd(this.OnAnimationEnd,this),this.getEventManager().removeListeners(this),this.Animation.play()}else this.render(null,this.Width,this.Height,!0)},t.Treemap.prototype._processInitialIsolate=function(e){if(e&&this._root){var i=this._root.getDescendantNodes();i.push(this._root);for(var s=0;s<i.length;s++)if(t.Obj.compareValues(this.getCtx(),i[s].getId(),e))return void this._isolatedNodes.push(i[s])}},t.Treemap.prototype.__getDefaultNavigable=function(t){var e=this.getEventManager().getKeyboardHandler();return e?e.getDefaultNavigable(t):t&&t.length>0?t[0]:null},t.Treemap.prototype.CreateNode=function(t){return new f(this,t)},t.Treemap.prototype.getIsolatedNodes=function(){return this._isolatedNodes},t.Treemap.prototype.getNodeContent=function(){return this._nodeContent};var f=function(e,i){this.Init(e,i);var s=this._view.getOptions(),n=s.nodeDefaults,o=n.header,a=i.header?i.header:{};this._groupLabelDisplay=i.groupLabelDisplay?i.groupLabelDisplay:n.groupLabelDisplay,this._labelDisplay=i.labelDisplay?i.labelDisplay:n.labelDisplay,this._labelHalign=i.labelHalign?i.labelHalign:n.labelHalign,this._labelValign=i.labelValign?i.labelValign:n.labelValign,this._headerHalign=a.labelHalign?a.labelHalign:o.labelHalign,this._headerLabelStyle=a.labelStyle?new t.CSSStyle(a.labelStyle):null,this._bHeaderUseNodeColor="on"==(a.useNodeColor?a.useNodeColor:o.useNodeColor),this._className=i.className||i.svgClassName,this._style=i.style||i.svgStyle,this._isolate=a.isolate?a.isolate:o.isolate,"auto"==this._isolate&&(this._isolate=t.Agent.isTouchDevice()?"off":"on"),this._bIsolated=null!=s.isolatedNode&&t.Obj.compareValues(this.getView().getCtx(),s.isolatedNode,this.getId())};t.Obj.createSubclass(f,l),f.TEXT_STYLE_HEADER="header",f.TEXT_STYLE_NODE="node",f.TEXT_STYLE_OFF="off",f.TEXT_BUFFER_HORIZ=5,f.TEXT_BUFFER_VERT=2,f.MIN_TEXT_BUFFER=2,f._LINE_FUDGE_FACTOR=1,f._ANIMATION_ISOLATE_DURATION=.3,f._MIN_TITLE_BAR_HEIGHT=22,f._MIN_TITLE_BAR_HEIGHT_ISOLATE=22,f.DEFAULT_HEADER_BORDER_WIDTH=1,f.DEFAULT_HEADER_WITH_NODE_COLOR_ALPHA=.5,f._ISOLATE_ICON_SIZE=12,f._ISOLATE_GAP_SIZE=4,f._ISOLATE_TOUCH_BUFFER=3,f.DEFAULT_NODE_TOP_BORDER_COLOR="#FFFFFF",f.DEFAULT_NODE_BOTTOM_BORDER_COLOR="#000000",f.DEFAULT_NODE_BORDER_WIDTH=1,f.DEFAULT_NODE_BORDER_OPACITY=.3,f.DEFAULT_NODE_PATTERN_BORDER_OPACITY=.15,f.MIN_SIZE_FOR_BORDER=2*f.DEFAULT_NODE_BORDER_WIDTH,f.GROUP_HOVER_INNER_OPACITY=.8,f.GROUP_HOVER_INNER_WIDTH=3,f.NODE_HOVER_OPACITY=1,f.NODE_SELECTION_WIDTH=2,f.prototype.render=function(e){if(this._hasLayout){var i;if(this._shape=this._createShapeNode(),e.addChild(this._shape),this.hasChildren()?(this._childNodeGroup=new t.Container(this.getView().getCtx()),this._shape.addChild(this._childNodeGroup),this.renderChildren(this._childNodeGroup)):i=this.GetTemplate(),i){var s=this.GetElAttributes(),n=this.GetAfContext();n.setELContext(s);var o=f.DEFAULT_NODE_BORDER_WIDTH+f._LINE_FUDGE_FACTOR,a=f.TEXT_BUFFER_HORIZ,r=f.TEXT_BUFFER_VERT,l=this._width-2*a-o,h=this._height-2*r-o;if(l>0&&h>0){n.setAvailableWidth(l),n.setAvailableHeight(h),n.setFontSize(this.GetTextSize());var _,d=t.AfComponentFactory.parseAndLayout(n,i,this._shape);if(this._contentRoot=d,t.Agent.isRightToLeft(e.getCtx())){var u=d.getDimensions();_=this._x+this._width-a-.5*o-u.w}else _=this._x+a+.5*o;d.setTranslate(_,this._y+r+.5*o)}}else if(!this._createCustomNodeContent()&&(this._text=this._createTextNode(this._shape),null!=this._text)){var c=this.getLabelBackgroundColor();if(this._textStyle!=f.TEXT_STYLE_HEADER&&(this.hasPattern()||c)){var p=this._text.getDimensions();this._textBackground=new t.Rect(this.getView().getCtx(),p.x,p.y,p.w,p.h),c?this._textBackground.setSolidFill(c):this._textBackground.setSolidFill("#FFFFFF"),this._textBackground.setMouseEnabled(!1),this._shape.addChild(this._textBackground),this._addChildText(this._text)}}this.hasChildren()?this._shape.setAriaRole("group"):this._shape.setAriaRole("img"),this.UpdateAriaLabel()}},f.prototype.setSelected=function(e){if(f.superclass.setSelected.call(this,e),this._shape){var i=this.getView().getOptions().nodeDefaults,s=i.header;if(this.isSelected()){var n=this._x,o=this._y+f._LINE_FUDGE_FACTOR,a=Math.max(this._width-f._LINE_FUDGE_FACTOR,0),r=Math.max(this._height-f._LINE_FUDGE_FACTOR,0);"safari"!==t.Agent.browser&&"chrome"!==t.Agent.browser||(o-=f._LINE_FUDGE_FACTOR),this._removeChildShape(this._selectionOuter),this._removeChildShape(this._selectionInner),this._selectionOuter=null,this._selectionInner=null,this._selectionOuter=new t.Rect(this.getView().getCtx(),n,o,a,r),this._selectionOuter.setMouseEnabled(!1),this._selectionOuter.setFill(null),this._selectionOuter.setPixelHinting(!0),this._shape.addChild(this._selectionOuter);var h=Math.max(a-2,0),_=Math.max(r-2,0);this._selectionInner=new t.Rect(this.getView().getCtx(),n+1,o+1,h,_),this._selectionInner.setMouseEnabled(!1),this._selectionInner.setFill(null),this._selectionInner.setPixelHinting(!0),this._shape.addChild(this._selectionInner),this._textStyle==f.TEXT_STYLE_HEADER?(this.IsHover||this.isShowingKeyboardFocusEffect()?this._innerShape.setSolidFill(s.hoverBackgroundColor):(this._innerShape.setSolidFill(s.selectedBackgroundColor),this._text&&this.ApplyHeaderTextStyle(this._text,"_selectedLabelStyle")),this._selectionOuter.setSolidStroke(s.selectedOuterColor),this._selectionInner.setSolidStroke(s.selectedInnerColor),t.Agent.isTouchDevice()&&(this._isolateButton=this._createIsolateRestoreButton(this._shape))):(this._selectionOuter.setSolidStroke(i.selectedOuterColor),this._selectionInner.setSolidStroke(i.selectedInnerColor),"safari"!==t.Agent.browser&&"firefox"!==t.Agent.browser&&this._shape.addDrawEffect(l.__NODE_SELECTED_SHADOW),this.getView().__moveToSelectedLayer(this._shape))}else if(this._removeChildShape(this._selectionInner),this._selectionInner=null,t.Agent.isTouchDevice()&&this._removeIsolateRestoreButton(),this._textStyle==f.TEXT_STYLE_HEADER)this.IsHover||this.isShowingKeyboardFocusEffect()?this._innerShape.setSolidFill(s.hoverBackgroundColor):(this.ApplyHeaderStyle(this._shape,this._innerShape),this._text&&(this.isDrillReplaceEnabled()?this.ApplyHeaderTextStyle(this._text,"_drillableLabelStyle"):this.ApplyHeaderTextStyle(this._text,"labelStyle"))),this._selectionOuter&&(this.IsHover||this.isShowingKeyboardFocusEffect()?this._selectionOuter.setSolidStroke(s.hoverOuterColor):(this._removeChildShape(this._selectionOuter),this._selectionOuter=null));else{this._shape.removeAllDrawEffects(),this._selectionOuter&&(this._removeChildShape(this._selectionOuter),this._selectionOuter=null);var d=this.GetParent();d&&d._childNodeGroup&&d._childNodeGroup.addChild(this._shape)}}},f.prototype.showHoverEffect=function(){if(this._shape&&this._hasLayout){var e,i,s,n,o,a=this.getView().getOptions().nodeDefaults,r=a.header,l=this._view.__getLastIsolatedNode();if(null==l||l==this||this.isDescendantOf(l))this._textStyle==f.TEXT_STYLE_HEADER?(this._innerShape.setSolidFill(r.hoverBackgroundColor),this._selectionOuter||(i=this._x,s=this._y,n=this._width-f._LINE_FUDGE_FACTOR,o=this._height-f._LINE_FUDGE_FACTOR,this._selectionOuter=new t.Rect(this.getView().getCtx(),i,s,n,o),this._selectionOuter.setMouseEnabled(!1),this._selectionOuter.setFill(null),this._selectionOuter.setPixelHinting(!0),this._shape.addChild(this._selectionOuter)),this._selectionOuter.setSolidStroke(this.isSelected()?r.selectedOuterColor:r.hoverOuterColor),i=this._x+f.GROUP_HOVER_INNER_WIDTH/2,s=this._y+this._titleBarHeight+f.GROUP_HOVER_INNER_WIDTH/2,n=this._width-f.GROUP_HOVER_INNER_WIDTH-f._LINE_FUDGE_FACTOR,o=this._height-this._titleBarHeight-f.GROUP_HOVER_INNER_WIDTH-f._LINE_FUDGE_FACTOR,e=new t.Stroke(r.hoverInnerColor,f.GROUP_HOVER_INNER_OPACITY,f.GROUP_HOVER_INNER_WIDTH),this._text&&(this.isDrillReplaceEnabled()?this.ApplyHeaderTextStyle(this._text,"_drillableHoverLabelStyle"):this.ApplyHeaderTextStyle(this._text,"_hoverLabelStyle"))):(i=this._x+f.NODE_SELECTION_WIDTH/2,s=this._y+f.NODE_SELECTION_WIDTH/2,n=this._width-f.NODE_SELECTION_WIDTH-f._LINE_FUDGE_FACTOR,o=this._height-f.NODE_SELECTION_WIDTH-f._LINE_FUDGE_FACTOR,e=new t.Stroke(a.hoverColor,f.NODE_HOVER_OPACITY,f.NODE_SELECTION_WIDTH)),o=Math.max(o,0),n=Math.max(n,0),this.getView().__showHoverEffect(i,s,n,o,e)}},f.prototype.hideHoverEffect=function(){if(this._shape&&this._hasLayout){var t=this.getView().getOptions().nodeDefaults.header;this._textStyle==f.TEXT_STYLE_HEADER&&(this.isSelected()?(this._innerShape.setSolidFill(t.selectedBackgroundColor),this._selectionOuter.setSolidStroke(t.selectedOuterColor),this._text&&(this.isDrillReplaceEnabled()?this.ApplyHeaderTextStyle(this._text,"_drillableSelectedLabelStyle"):this.ApplyHeaderTextStyle(this._text,"_selectedLabelStyle"))):(this.ApplyHeaderStyle(this._shape,this._innerShape),this._selectionOuter&&(this._shape.removeChild(this._selectionOuter),this._selectionOuter=null),this._text&&(this.isDrillReplaceEnabled()?this.ApplyHeaderTextStyle(this._text,"_drillableLabelStyle"):this.ApplyHeaderTextStyle(this._text,"labelStyle")))),this.getView().__hideHoverEffect()}},f.prototype.highlight=function(t,e){this.hasChildren()?(this._text&&this._text.setAlpha(e),this._textStyle==f.TEXT_STYLE_HEADER&&this._bHeaderUseNodeColor&&this._innerShape&&this._innerShape.setAlpha(e)):f.superclass.highlight.call(this,t,e)},f.prototype.isIsolateEnabled=function(){return"off"!=this._isolate&&this._textStyle==f.TEXT_STYLE_HEADER},f.prototype.getNextNavigable=function(e){var i,s;if(e.type==t.MouseEvent.CLICK)return f.superclass.getNextNavigable.call(this,e);if((i=e.keyCode)==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;if(i==t.KeyboardEvent.UP_ARROW&&e.altKey||i==t.KeyboardEvent.CLOSE_BRACKET)(a=this.GetParent())&&a.getId()!=this.getView().getRootNode().getId()?(s=a,a.MarkAsLastVisitedChild()):s=this;else if(i==t.KeyboardEvent.DOWN_ARROW&&e.altKey||i==t.KeyboardEvent.OPEN_BRACKET)s=this.GetLastVisitedChild()||(this.hasChildren()?this.getView().__getDefaultNavigable(this.getChildNodes()):this);else{var n=this.getView().__getLastIsolatedNode(),o=0;if(n)if(this==n)o=0;else{var a=this.GetParent();for(o=1;n!=a;)o++,a=a.GetParent()}else{for(n=this;n.GetParent();)n=n.GetParent();o=this.GetDepth()}var r=this.GetNodesAtDepth(n,o);s=t.KeyboardHandler.getNextNavigable(this,e,r)}return s.MarkAsLastVisitedChild(),s},f.prototype.getKeyboardBoundingBox=function(e){return new t.Rectangle(this._x,this._y,this._width,this._height)},f.prototype.getTargetElem=function(){return this._shape?this._shape.getElem():null},f.prototype.setZIndex=function(t){this._zIndex=t},f.prototype.setLayoutParams=function(e,i,s,n){if(!(s<=0||n<=0)){if(this._hasLayout=!0,this._oldState=this.GetAnimationParams(),this._x=e,this._y=i,this._width=s||0,this._height=n||0,this.hasChildren()?this._textStyle=this._groupLabelDisplay:this._textStyle=this._labelDisplay,this._textStr||(this._textStyle=f.TEXT_STYLE_OFF),this._textStyle==f.TEXT_STYLE_HEADER){this._titleBarHeight=f._MIN_TITLE_BAR_HEIGHT;var o=new t.OutputText(this.getView().getCtx(),this._textStr);o.setFontSize(this.GetTextSize()),this.ApplyHeaderTextStyle(o,"labelStyle");var a=o.getDimensions().h;o=null,this._titleBarHeight=Math.max(this._titleBarHeight,a),this.isIsolateEnabled()&&(this._titleBarHeight=Math.max(this._titleBarHeight,f._MIN_TITLE_BAR_HEIGHT_ISOLATE));var r=this._x,l=this._y+this._titleBarHeight,h=this._width,_=this._height-this._titleBarHeight;if(h>=0&&_>=0)return new t.Rectangle(r,l,h,_);this._textStyle=null}return new t.Rectangle(this._x,this._y,this._width,this._height)}},f.prototype.getNodeUnderPoint=function(t,e){if(this.contains(t,e)||!this._hasLayout){for(var i=this.getChildNodes(),s=0;s<i.length;s++)if(i[s].contains(t,e))return i[s].getNodeUnderPoint(t,e);if(this._hasLayout)return this}return null},f.prototype.contains=function(t,e){return t>=this._x&&t<=this._x+this._width&&e>=this._y&&e<=this._y+this._height},f.prototype.GetAnimationParams=function(){var e=t.ColorUtils.getRed(this._color),i=t.ColorUtils.getGreen(this._color),s=t.ColorUtils.getBlue(this._color);return[this._x,this._y,this._width,this._height,e,i,s,this.hasChildren()?0:Math.random()]},f.prototype.SetAnimationParams=function(e){this.setLayoutParams(e[0],e[1],e[2],e[3]);var i=Math.round(e[4]),s=Math.round(e[5]),n=Math.round(e[6]);this._color=t.ColorUtils.makeRGB(i,s,n),this._updateShapes()},f.prototype.getIsolateAnimation=function(){for(var t=[this._getIsolateAnimation()],e=this.getDescendantNodes(),i=0;i<e.length;i++)t.push(e[i]._getIsolateAnimation());return t},f.prototype._getIsolateAnimation=function(){if(this._oldState){var e=new t.CustomAnimation(this.getView().getCtx(),this,f._ANIMATION_ISOLATE_DURATION);return e.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimationParams,this.SetAnimationParams,this.GetAnimationParams()),this.SetAnimationParams(this._oldState),e}return null},f.prototype.animateUpdate=function(t,e){return this._removeAllNodeContent(),0==this.GetDepth()||e._hasLayout&&e._width>0&&e._height>0?f.superclass.animateUpdate.call(this,t,e):this.animateInsert(t)},f.prototype.animateInsert=function(t,e){this._removeAllNodeContent(),f.superclass.animateInsert.call(this,t,e)},f.prototype.animateDelete=function(t,e){this._removeAllNodeContent(),f.superclass.animateDelete.call(this,t,e)},f.prototype._createShapeNode=function(){var e,i=this.getView().getCtx(),s="gaps"==this.getView().getOptions().nodeSeparators;if(this._textStyle==f.TEXT_STYLE_HEADER){if(s){var n=this._getGeometriesWithGaps();e=new t.Rect(i,n._shape.x,n._shape.y,n._shape.w,n._shape.h),this._innerShape=new t.Rect(i,n._innerShape.x,n._innerShape.y,n._innerShape.w,n._innerShape.h),this._backgroundShape=new t.Rect(i,n._backgroundShape.x,n._backgroundShape.y,n._backgroundShape.w,n._backgroundShape.h),this._backgroundShape.setSolidFill("#FFFFFF"),e.addChild(this._backgroundShape)}else e=new t.Rect(i,this._x,this._y,this._width,this._height),this._innerShape=new t.Rect(i,this._x+1,this._y+1,this._width-2,this._height-2);this.ApplyHeaderStyle(e,this._innerShape),this._innerShape.setMouseEnabled(!1),e.addChild(this._innerShape),this.__isIsolated()&&(this._isolateButton=this._createIsolateRestoreButton(e))}else{var o=this.GetFill();if(s){n=this._getGeometriesWithGaps();(e=new t.Rect(i,n._shape.x,n._shape.y,n._shape.w,n._shape.h)).setFill(this.hasChildren()?t.SolidFill.invisibleFill():o)}else{if(e=new t.Rect(i,this._x,this._y,this._width,this._height),(this.getView().__getNodeCount()<1e3||!t.Agent.isTouchDevice())&&this._width>=f.MIN_SIZE_FOR_BORDER&&this._height>=f.MIN_SIZE_FOR_BORDER){new t.Stroke(f.DEFAULT_NODE_TOP_BORDER_COLOR),new t.Stroke(f.DEFAULT_NODE_BOTTOM_BORDER_COLOR,f.DEFAULT_NODE_BORDER_OPACITY);this.hasPattern()&&new t.Stroke(this._color,f.DEFAULT_NODE_PATTERN_BORDER_OPACITY);var a=this.getColor(),r=t.ColorUtils.interpolateColor(f.DEFAULT_NODE_TOP_BORDER_COLOR,a,1-f.DEFAULT_NODE_BORDER_OPACITY),l=t.ColorUtils.interpolateColor(f.DEFAULT_NODE_BOTTOM_BORDER_COLOR,a,1-f.DEFAULT_NODE_BORDER_OPACITY),h=Math.min(this._width,this._height);h>=4?(e.setSolidFill(l),this._topLeftShape=new t.Rect(i,this._x,this._y,this._width-1,this._height-1),this._topLeftShape.setSolidFill(r),this._topLeftShape.setMouseEnabled(!1),e.addChild(this._topLeftShape),this._fillShape=new t.Rect(i,this._x+1,this._y+1,this._width-2,this._height-2),this._fillShape.setFill(o),this._fillShape.setMouseEnabled(!1),e.addChild(this._fillShape)):h>=2?(e.setSolidFill(l),this._fillShape=new t.Rect(i,this._x,this._y,this._width-1,this._height-1),this._fillShape.setFill(o),this._fillShape.setMouseEnabled(!1),e.addChild(this._fillShape)):e.setFill(o)}else e.setFill(o)}e.setStyle(this._style),e.setClassName(this._className)}return this.getView().getEventManager().associate(e,this),this.isSelectable()?e.setSelectable(!0):this.isDrillReplaceEnabled()?e.setCursor("pointer"):e.setCursor("default"),e.zIndex=this._zIndex,e},f.prototype._createIsolateRestoreButton=function(e){if(this._textStyle!=f.TEXT_STYLE_HEADER||!this.isIsolateEnabled())return null;var i=null,s=this._x,n=this._x+this._width-f._LINE_FUDGE_FACTOR,o=this._y+f._LINE_FUDGE_FACTOR,a=this._y+this._titleBarHeight;if(n-s-2*f._ISOLATE_GAP_SIZE>f._ISOLATE_ICON_SIZE){var r;if(i=this.__isIsolated()?this._getRestoreButton():this._getIsolateButton(),r=t.Agent.isRightToLeft(e.getCtx())?s+f._ISOLATE_GAP_SIZE:n-f._ISOLATE_ICON_SIZE-f._ISOLATE_GAP_SIZE,i.setTranslate(r,(a+o-f._ISOLATE_ICON_SIZE)/2),e.addChild(i),t.Agent.isTouchDevice()){var l=new t.Rect(e.getCtx(),-f._ISOLATE_TOUCH_BUFFER,-f._ISOLATE_TOUCH_BUFFER,f._ISOLATE_ICON_SIZE+2*f._ISOLATE_TOUCH_BUFFER,f._ISOLATE_ICON_SIZE+2*f._ISOLATE_TOUCH_BUFFER);l.setInvisibleFill(),i.addChild(l)}this.getView().getEventManager().associate(i,this)}return i},f.prototype._removeIsolateRestoreButton=function(){this._isolateButton&&(this._removeChildShape(this._isolateButton),this._isolateButton=null)},f.prototype._createTextNode=function(e){var i=t.Agent.isRightToLeft(e.getCtx());if(!this._textStr||!e||!this._textStyle||this._textStyle==f.TEXT_STYLE_OFF)return null;var s=this._height;if((p=this.GetTextSize())>s)return null;var n=this._textStyle==f.TEXT_STYLE_NODE?this._labelHalign:this._headerHalign;i&&("start"==n?n="end":"end"==n&&(n="start"));var o,a=this._width-(f.TEXT_BUFFER_HORIZ+f.MIN_TEXT_BUFFER),r=0;if(this.isIsolateEnabled()&&(r=f._ISOLATE_ICON_SIZE+f._ISOLATE_GAP_SIZE,a-="center"==n?2*r:r),a<=0)return null;var l=this.getMergedLabelTextStyle();if(o=this._textStyle==f.TEXT_STYLE_NODE&&s>2*p&&"nowrap"!=l.getStyle(t.CSSStyle.WHITE_SPACE)&&t.TextUtils.getTextStringWidth(this.getView().getCtx(),this._textStr,l)>a?new t.MultilineText(this.getView().getCtx(),this._textStr):new t.OutputText(this.getView().getCtx(),this._textStr),"start"==n?(i?o.setX(this._x+f.TEXT_BUFFER_HORIZ+r):o.setX(this._x+f.TEXT_BUFFER_HORIZ),o.alignLeft()):"center"==n?(o.setX(this._x+this._width/2),o.alignCenter()):"end"==n&&(i?o.setX(this._x+this._width-f.TEXT_BUFFER_HORIZ):o.setX(this._x+this._width-f.TEXT_BUFFER_HORIZ-r),o.alignRight()),this._textStyle==f.TEXT_STYLE_NODE)this.ApplyLabelTextStyle(o),s=this._height-2*f.TEXT_BUFFER_VERT;else if(this._textStyle==f.TEXT_STYLE_HEADER){var _="safari"===t.Agent.browser||"chrome"===t.Agent.browser?f._LINE_FUDGE_FACTOR:0;o.setY(this._y+f.DEFAULT_HEADER_BORDER_WIDTH+this._titleBarHeight/2+_),o.alignMiddle(),this.ApplyHeaderTextStyle(o,"labelStyle")}if(null!=o){if(this._textStyle==f.TEXT_STYLE_HEADER&&this.isDrillReplaceEnabled()){this.ApplyHeaderTextStyle(o,"_drillableLabelStyle"),o.setCursor("pointer");var d=new h(this,this.getId(),null,this.getDatatip.bind(this),this.getDatatipColor.bind(this));d.setDrillable(!0),this.getView().getEventManager().associate(o,d)}else o.setMouseEnabled(!1);var u=this.getView().getOptions().nodeDefaults.labelMinLength,c=t.TextUtils.fitText(o,a,s,e,u);if(this._textStyle==f.TEXT_STYLE_NODE){var p=o.getDimensions().h;"top"==this._labelValign?o.setY(this._y+f.TEXT_BUFFER_VERT):"center"==this._labelValign?o.setY(this._y+this._height/2-p/2):"bottom"==this._labelValign&&o.setY(this._y+this._height-f.TEXT_BUFFER_VERT-p)}return c?o:null}},f.prototype.ApplyHeaderStyle=function(e,i){var s=this.getView().getOptions().nodeDefaults.header;if(this._bHeaderUseNodeColor){var n=this.getColor();i.setSolidFill(n);var o=t.ColorUtils.interpolateColor(s.borderColor,n,1-f.DEFAULT_HEADER_WITH_NODE_COLOR_ALPHA);e.setSolidFill(o)}else e.setSolidFill(s.borderColor),i.setSolidFill(s.backgroundColor);this._backgroundShape&&this._backgroundShape.setFill(i.getFill())},f.prototype.ApplyHeaderTextStyle=function(e,i){var s=[];this.GetDepth()<=1&&this.getView().__getMaxDepth()>=3&&s.push(new t.CSSStyle("font-weight:bold;")),s.push(this.getView().getOptions().nodeDefaults.header[i]),!this._bHeaderUseNodeColor||"labelStyle"!=i&&"_drillableLabelStyle"!=i||s.push(new t.CSSStyle("color: "+l.GetNodeTextColor(this))),this._headerLabelStyle&&s.push(this._headerLabelStyle),e.setCSSStyle(t.CSSStyle.mergeStyles(s))},f.prototype.handleMouseOver=function(){this._isolateButton||t.Agent.isTouchDevice()||(this._isolateButton=this._createIsolateRestoreButton(this._shape)),f.superclass.handleMouseOver.call(this)},f.prototype.handleMouseOut=function(){!0===this.__isIsolated()||t.Agent.isTouchDevice()||this._removeIsolateRestoreButton(),f.superclass.handleMouseOut.call(this)},f.prototype._getGeometriesWithGaps=function(){var e={};if(this._textStyle==f.TEXT_STYLE_HEADER){e._shape=new t.Rectangle(this._x,this._y,this._width-1,this._titleBarHeight),e._innerShape=new t.Rectangle(this._x+1,this._y+1,this._width-3,this._titleBarHeight-1);var i=Math.max(this._width-1,0),s=Math.max(this._height-this._titleBarHeight-1,0);e._backgroundShape=new t.Rectangle(this._x,this._y+this._titleBarHeight,i,s)}else if(this.hasChildren())e._shape=new t.Rectangle(this._x,this._y,0,0);else{var n=Math.max(this._width-1,0),o=Math.max(this._height-1,0);e._shape=new t.Rectangle(this._x,this._y,n,o)}return e},f.prototype._updateShapes=function(){if(this._shape){var t=this.getView().getOptions();if("gaps"==t.nodeSeparators){var e=this._getGeometriesWithGaps();this._shape.setRect(e._shape),this._innerShape&&this._innerShape.setRect(e._innerShape),this._backgroundShape&&this._backgroundShape.setRect(e._backgroundShape)}else this._shape.setRect(this._x,this._y,this._width,this._height),this._innerShape&&this._innerShape.setRect(this._x+1,this._y+1,this._width-2,this._height-2);(this._textStyle!=f.TEXT_STYLE_HEADER||this._bHeaderUseNodeColor)&&this._shape.setFill(this.GetFill()),this.isSelected()&&this.setSelected(!1),this._removeChildShape(this._fillShape),this._removeChildShape(this._topLeftShape),this._fillShape=null,this._topLeftShape=null,this._removeIsolateRestoreButton(),this.GetTemplate()?(this._removeChildShape(this._contentRoot),this._contentRoot=null):t.nodeContent&&t.nodeContent.renderer&&this._textStyle!=f.TEXT_STYLE_HEADER?this._removeAllNodeContent():(this._removeChildShape(this._textBackground),this._textBackground=null,this._text&&this._text.getParent().removeChild(this._text),this._text=this._createTextNode(this._shape))}},f.prototype.getDropSiteFeedback=function(){return this._shape?new t.Rect(this.getView().getCtx(),this._shape.getX(),this._shape.getY(),this._shape.getWidth(),this._shape.getHeight()):null},f.prototype._addChildText=function(t){this._textStyle==f.TEXT_STYLE_NODE&&this.hasChildren()?this.getView().__getGroupTextLayer().addChild(t):this._shape.addChild(t)},f.prototype._removeChildShape=function(t){t&&this._shape.removeChild(t)},f.prototype._getIsolateButton=function(){var e=this.getView().getCtx(),i=t.Agent.isRightToLeft(this._context),s=this.getView().getOptions()._resources,n=i&&s.isolateRtl?s.isolateRtl:s.isolate,o=i&&s.isolateOverRtl?s.isolateOverRtl:s.isolateOver,a=i&&s.isolateDownRtl?s.isolateDownRtl:s.isolateDown,r=new t.Image(e,n,0,0,f._ISOLATE_ICON_SIZE,f._ISOLATE_ICON_SIZE),l=new t.Image(e,o,0,0,f._ISOLATE_ICON_SIZE,f._ISOLATE_ICON_SIZE),h=new t.Image(e,a,0,0,f._ISOLATE_ICON_SIZE,f._ISOLATE_ICON_SIZE);r.setInvisibleFill(),l.setInvisibleFill(),h.setInvisibleFill();var _=new t.Button(e,r,l,h);return _.addEvtListener(t.MouseEvent.CLICK,this.__isolateNode,!1,this),_},f.prototype._getRestoreButton=function(){var e=this.getView().getCtx(),i=t.Agent.isRightToLeft(this._context),s=this.getView().getOptions()._resources,n=i&&s.restoreRtl?s.restoreRtl:s.restore,o=i&&s.restoreOverRtl?s.restoreOverRtl:s.restoreOver,a=i&&s.restoreDownRtl?s.restoreDownRtl:s.restoreDown,r=new t.Image(e,n,0,0,f._ISOLATE_ICON_SIZE,f._ISOLATE_ICON_SIZE),l=new t.Image(e,o,0,0,f._ISOLATE_ICON_SIZE,f._ISOLATE_ICON_SIZE),h=new t.Image(e,a,0,0,f._ISOLATE_ICON_SIZE,f._ISOLATE_ICON_SIZE);r.setInvisibleFill(),l.setInvisibleFill(),h.setInvisibleFill();var _=new t.Button(e,r,l,h);return _.addEvtListener(t.MouseEvent.CLICK,this.__restoreNode,!1,this),_},f.prototype.__isIsolated=function(){return this._bIsolated},f.prototype.__isolateNode=function(t){this._bIsolated=!0,this._removeAllNodeContent(),this.hideHoverEffect(),this.getView().__isolate(this),this._removeIsolateRestoreButton(),this.UpdateAriaLabel(),t&&t.stopPropagation()},f.prototype.__restoreNode=function(t){this._bIsolated=!1,this.hideHoverEffect(),this.getView().__restore(),this._removeIsolateRestoreButton(),this.UpdateAriaLabel(),t&&t.stopPropagation()},f.prototype.getIsolateRestoreButton=function(){return this._isolateButton},f.prototype.getDatatip=function(e,i,s){return e&&e instanceof t.Button?null:f.superclass.getDatatip.call(this,e,i,s)},f.prototype.getDatatipColor=function(e){return e&&e instanceof t.Button?null:f.superclass.getDatatipColor.call(this,e)},f.prototype.getTooltip=function(e){return e&&e instanceof t.Button?this.getView().getOptions().translations[this.__isIsolated()?"tooltipRestore":"tooltipIsolate"]:null},f.prototype.getAriaLabel=function(){var e=this.getView().getOptions().translations,i=[];return this.isSelectable()&&i.push(e[this.isSelected()?"stateSelected":"stateUnselected"]),this.__isIsolated()&&i.push(e.stateIsolated),this.isDrillReplaceEnabled()&&i.push(e.stateDrillable),t.Displayable.generateAriaLabel(this.getShortDesc(),i)},f.prototype.UpdateAriaLabel=function(){!t.Agent.deferAriaCreation()&&this._shape&&this._shape.setAriaProperty("label",this.getAriaLabel())},f.prototype._createCustomNodeContent=function(){var e=this.getView(),i=e.getOptions(),s=this.getId();this._removeNodeContent(s);var n=i.nodeContent.renderer;if(!n||this.hasChildren())return!1;var o=e.getIsolatedNodes();if(o.length<=0||this.isDescendantOf(o[e._isolatedNodes.length-1])){var a,r=e.getCtx(),l=i=this.getOptions();i._noTemplate?(a=i._itemData,l=i._itemData):i._itemData&&(a=i._itemData,l=i=t.JsonUtils.clone(i),delete i._itemData);var h={bounds:{x:this._x,y:this._y,width:this._width-f.DEFAULT_NODE_BORDER_WIDTH,height:this._height-f.DEFAULT_NODE_BORDER_WIDTH},id:s,data:l,itemData:a,component:i._widgetConstructor};h=r.fixRendererContext(h);var _=r.getContainer(),d=n(h);if(!d)return;var u=r.createOverlayDiv();Array.isArray(d)?d.forEach(function(t){u.appendChild(t)}):u.appendChild(d),e.getNodeContent()[s]=u,_.appendChild(u);var c=r.getOverlayAttachedCallback();c&&c(u)}return!0},f.prototype._removeNodeContent=function(t){var e=this.getView(),i=e.getNodeContent(),s=i[t];s&&(e.getCtx().getContainer().removeChild(s),delete i[t])},f.prototype._removeAllNodeContent=function(){for(var t in this.getView().getNodeContent())this._removeNodeContent(t)};var y=function(){this.Init()};t.Obj.createSubclass(y,t.Obj),y._GROUP_GAP=2,y.prototype.Init=function(){this._zIndex=0},y.prototype.layout=function(t,e,i,s,n,o,a){},y.prototype.setNodeBounds=function(e,i,s,n,o,a){if(e.setZIndex(this._zIndex),this._zIndex++,!a||!e.hasChildren()){var r=this.getGapSize(e.getView(),e.GetDepth()),l=Math.round(i+r),h=Math.round(s+r),_=Math.round(i+n-r)-l,d=Math.round(s+o-r)-h,u=e.setLayoutParams(l,h,_,d);if(u)return u}return new t.Rectangle(i,s,n,o)},y.prototype.getGapSize=function(t,e){var i=t.getOptions().groupGaps;return"outer"==i?1==e&&t.__getMaxDepth()>=2?y._GROUP_GAP:0:"all"==i&&e<t.__getMaxDepth()?y._GROUP_GAP:0};var E=function(){this.Init()};t.Obj.createSubclass(E,y),E.prototype.layout=function(t,e,i,s,n,o,a){var r=!a;this._layout(e,i,s,n,o,r)},E.prototype._layout=function(e,i,s,n,o,a){var r=this.setNodeBounds(e,i,s,n,o,a),l=e.getChildNodes();if(null!=l&&l.length>0){this._calcPixelSize(l,r.w*r.h),l=l.slice(0).sort(function(t,e){return t.getSize()-e.getSize()});var h=Math.min(r.w,r.h),_=new t.Rectangle(r.x,r.y,r.w,r.h);this._squarify(l,new Array,h,_,1/0)}},E.prototype._calcPixelSize=function(t,e){var i=0,s=0;for(s=0;s<t.length;s++)i+=t[s].getSize()>0?t[s].getSize():0;var n=0==e?0:e/i;for(s=0;s<t.length;s++){var o=t[s];o.__pxSize=o.getSize()*n}},E.prototype._squarify=function(t,e,i,s,n){if(null!=t&&0!=t.length)for(;t.length>0;){var o=t.pop();if(o.__pxSize<0)return void this._layoutRow(e,i,s);e.push(o);var a=this._getWorst(e,i);if(a>n)return t.push(o),e.pop(),s=this._layoutRow(e,i,s),void this._squarify(t,new Array,Math.min(s.w,s.h),s,1/0);if(0==t.length)return void this._layoutRow(e,i,s);n=a}else this._layoutRow(e,i,s)},E.prototype._getWorst=function(t,e){for(var i=0,s=1/0,n=-1/0,o=0;o<t.length;o++)i+=t[o].__pxSize,s=Math.min(s,t[o].__pxSize),n=Math.max(n,t[o].__pxSize);var a=i*i,r=e*e;return Math.max(r*n/a,a/(r*s))},E.prototype._layoutRow=function(e,i,s){var n,o=0;for(n=0;n<e.length;n++)o+=e[n].__pxSize;var a,r,l=s.x,h=s.y;if(i==s.w){for(r=0==i?0:o/i,n=0;n<e.length;n++)a=e[n].__pxSize/r,this._layout(e[n],l,h,a,r,!1),l+=a;return new t.Rectangle(s.x,s.y+r,s.w,s.h-r)}for(a=0==i?0:o/i,n=0;n<e.length;n++)r=e[n].__pxSize/a,this._layout(e[n],l,h,a,r,!1),h+=r;return new t.Rectangle(s.x+a,s.y,s.w-a,s.h)};var S=function(t){this.Init(),this._isHoriz=t};t.Obj.createSubclass(S,y),S.prototype.layout=function(t,e,i,s,n,o,a){var r=!a;this._layout(this._isHoriz,t,e,i,s,n,o,r)},S.prototype._layout=function(e,i,s,n,o,a,r,l){var h=i.getOptions(),_=this.setNodeBounds(s,n,o,a,r,l),d=s.getChildNodes();if(null!=d){var u,c=_.x,p=_.y,g=_.w,f=_.h,y=0;for(u=0;u<d.length;u++)y+=d[u].getSize()>0?d[u].getSize():0;for("on"==h.sorting&&(d=d.slice(0)).sort(function(t,e){return e.getSize()-t.getSize()}),e&&t.Agent.isRightToLeft(i.getCtx())&&(d=d.slice(0).reverse()),u=0;u<d.length;u++){var E=d[u];if(!(E.getSize()<=0)){var S=E.getSize()/y;e?g=_.w*S:f=_.h*S,this._layout(!e,i,E,c,p,g,f,!1),e?c+=g:p+=f}}}};var v=function(t){this.Init(t)};t.Obj.createSubclass(v,u),v.prototype.isNavigationEvent=function(e){var i=v.superclass.isNavigationEvent.call(this,e);if(!i){var s=e.keyCode;s!=t.KeyboardEvent.OPEN_BRACKET&&s!=t.KeyboardEvent.CLOSE_BRACKET||(i=!0)}return i};var C=function(t,e,i,s){r.call(this,t,e,i,s)};t.Obj.createSubclass(C,r),C.prototype.ProcessKeyboardEvent=function(e){var i=!0;if(e.keyCode==t.KeyboardEvent.ENTER&&e.ctrlKey){var s=this.getFocus();s.isIsolateEnabled()&&(s.__isIsolated()?s.__restoreNode():s.__isolateNode()),t.EventManager.consumeEvent(e)}else i=C.superclass.ProcessKeyboardEvent.call(this,e);return i},C.prototype.isClearMenuAllowed=function(){return!1};var b=function(t){this.Init({alta:b.SKIN_ALTA},t)};t.Obj.createSubclass(b,c),b.SKIN_ALTA={groupGaps:"outer",nodeDefaults:{header:{backgroundColor:"#FFFFFF",borderColor:"#d6dfe6",hoverBackgroundColor:"#ebeced",hoverOuterColor:"#ebeced",hoverInnerColor:"#d6d7d8",isolate:"auto",labelHalign:"start",labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color:#252525;"),selectedBackgroundColor:"#dae9f5",selectedInnerColor:"#FFFFFF",selectedOuterColor:"#000000",useNodeColor:"off",_hoverLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color:#252525;"),_selectedLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color:#252525;"),_drillableLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color:#145c9e;"),_drillableHoverLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color:#145c9e;"),_drillableSelectedLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color:#145c9e;")},hoverColor:"#ebeced",groupLabelDisplay:"header",labelDisplay:"node",labelHalign:"center",labelValign:"center",selectedInnerColor:"#FFFFFF",selectedOuterColor:"#000000"},nodeSeparators:"gaps",nodeContent:{}},t.Sunburst=function(t,e,i){this.Init(t,e,i)},t.Obj.createSubclass(t.Sunburst,o),t.Sunburst._ROTATION_SHAPE_RADIUS=15,t.Sunburst._ROTATION_SHAPE_RADIUS_TOUCH=60,t.Sunburst._ANIMATION_TYPE_FAN="fan",t.Sunburst._BACKGROUND_INLINE_DEFAULT="",t.Sunburst._BUFFER_SPACE=3,t.Sunburst._MIN_BUFFER_SPACE=2,t.Sunburst.LARGE_DATASET_THRESHOLD=1e3,t.Sunburst.newInstance=function(e,i,s){return new t.Sunburst(e,i,s)},t.Sunburst.prototype.Init=function(e,i,s){t.Sunburst.superclass.Init.call(this,e,i,s),this.Defaults=new I(e),this._angleExtent=2*Math.PI,this.setId("sunburst")},t.Sunburst.prototype.ApplyParsedProperties=function(e){t.Sunburst.superclass.ApplyParsedProperties.call(this,e);var i=this.getOptions();"ie"===t.Agent.browser||"edge"===t.Agent.browser?this._rotateCursor="url("+i._resources.rotateCursor+"), auto":this._rotateCursor="url("+i._resources.rotateCursor+") 8 8, auto",this._startAngle=(360-i.startAngle)*A.TWO_PI/360,this._startAngle>Math.PI&&(this._startAngle-=A.TWO_PI),"auto"==i.animationOnDisplay&&(i.animationOnDisplay="fan")},t.Sunburst.prototype.Layout=function(e){var i=Math.max(Math.ceil(t.Sunburst._BUFFER_SPACE*Math.min(e.w,e.h)/400),t.Sunburst._MIN_BUFFER_SPACE);e.x+=i,e.y+=i,e.w-=2*i,e.h-=2*i,this.LayoutBreadcrumbs(e),this.LayoutLegend(e),this._totalRadius=Math.floor(Math.min(e.w,e.h)/2),this._root&&T.layout(this._totalRadius,this._root,this._startAngle,this._angleExtent,this.getOptions().sorting)},t.Sunburst.prototype.Render=function(e,i){if(this.RenderBackground(e,t.Sunburst._BACKGROUND_INLINE_DEFAULT),this.RenderBreadcrumbs(e),this.RenderLegend(e),this._translatePt=new t.Point(i.x+i.w/2,i.y+i.h/2),this.__isRotationEnabled()&&this.HasValidData()){var s=t.Agent.isTouchDevice()?t.Sunburst._ROTATION_SHAPE_RADIUS_TOUCH:t.Sunburst._ROTATION_SHAPE_RADIUS,n=new t.Circle(this.getCtx(),i.x+i.w/2,i.y+i.h/2,this._totalRadius+s);n.setInvisibleFill(),n.setCursor(this._rotateCursor),e.addChild(n),this.getEventManager().associate(n,new h(null,O.ROTATION_ID))}var o=new t.Container(this.getCtx());if(o.setTranslate(this._translatePt.x,this._translatePt.y),e.addChild(o),this.HasValidData()){var a=new t.Container(this.getCtx());o.addChild(a),this._root.render(a),this.UpdateAriaNavigation(this._root),this._selectedLayer=new t.Container(this.getCtx()),o.addChild(this._selectedLayer),this._hoverLayer=new t.Container(this.getCtx()),o.addChild(this._hoverLayer)}else this.RenderEmptyText(e)},t.Sunburst.prototype.CreateEventManager=function(t,e,i,s){return new O(t,e,i,s)},t.Sunburst.prototype.GetDisplayAnimation=function(e,i){if(this.getOptions().animationOnDisplay===t.Sunburst._ANIMATION_TYPE_FAN&&this.HasValidData()){this._animateAngleExtent(0);var s=new t.CustomAnimation(this.getCtx(),this,this.AnimationDuration);return s.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.__getAngleExtent,this._animateAngleExtent,2*Math.PI),s}return t.Sunburst.superclass.GetDisplayAnimation.call(this,e,i)},t.Sunburst.prototype.GetDeleteContainer=function(){var e=t.Sunburst.superclass.GetDeleteContainer.call(this);return e&&e.setTranslate(this._translatePt.x,this._translatePt.y),e},t.Sunburst.prototype.OnAnimationEnd=function(){if(!this.AnimationStopped){this._container.removeChildren();var e=new t.Rectangle(0,0,this.Width,this.Height);this.Layout(e),this.Render(this._container,e);for(var i=this._selectionHandler?this._selectionHandler.getSelection():new Array,s=0;s<i.length;s++)i[s].setSelected(!0)}this._angleExtent<2*Math.PI&&this._animateAngleExtent(2*Math.PI),t.Sunburst.superclass.OnAnimationEnd.call(this)},t.Sunburst.prototype.__moveToHoverLayer=function(t){this._hoverLayer.addChild(t)},t.Sunburst.prototype.__moveToSelectedLayer=function(e){this._selectedLayer.addChild(e),"safari"!==t.Agent.browser&&"firefox"!==t.Agent.browser&&(this._selectedLayer.removeAllDrawEffects(),this._selectedLayer.addDrawEffect(l.__NODE_SELECTED_SHADOW))},t.Sunburst.prototype.__getAngleExtent=function(){return this._angleExtent},t.Sunburst.prototype._animateAngleExtent=function(e){this._angleExtent=e;var i=new t.Rectangle(0,0,this.Width,this.Height);this.Layout(i),this._root&&this._root.updateShapes(!0)},t.Sunburst.prototype.__startRotation=function(t,e){this.__setRotationAnchor(this._calcAngle(t,e))},t.Sunburst.prototype.__setRotationAnchor=function(e){this._currentAngle=e,this._rotationMask=new t.Rect(this.getCtx(),0,0,this.Width,this.Height),this._rotationMask.setInvisibleFill(),this._rotationMask.setCursor(this._rotateCursor),this.addChild(this._rotationMask),this.getEventManager().associate(this._rotationMask,new h(null,O.ROTATION_ID))},t.Sunburst.prototype.__continueRotation=function(t,e){this.__rotate(this._calcAngle(t,e))},t.Sunburst.prototype.__rotate=function(e){var i=e-this._currentAngle;this._currentAngle=e,this._updateStartAngle(i);var s=360-Math.round(180*this._startAngle/Math.PI);this.dispatchEvent(t.EventFactory.newSunburstRotationEvent(s,!1))},t.Sunburst.prototype.__endRotation=function(){this._currentAngle=null,this.removeChild(this._rotationMask),this._rotationMask=null;var e=360-Math.round(180*this._startAngle/Math.PI);this.dispatchEvent(t.EventFactory.newSunburstRotationEvent(e,!1)),this.dispatchEvent(t.EventFactory.newSunburstRotationEvent(e,!0))},t.Sunburst.prototype.SetOptions=function(e){t.Sunburst.superclass.SetOptions.call(this,e),this.Options.expanded instanceof Array&&(this.Options._expandedNodes=t.ArrayUtils.createBooleanMap(this.Options.expanded))},t.Sunburst.prototype.expandCollapseNode=function(e){var i=this.getRootNode(),s=!l.getNodeById(i,e).isDisclosed(),n=this.getOptions().expanded;if("all"==n){for(var o=p.getAllNodes(this._root),a=0;a<o.length;a++)o[a]=o[a].getId();n=o}if(n instanceof Array)if(s)n.push(e);else{var r=n.indexOf(e);r>-1&&n.splice(r,1)}else n.has&&(n=s?n.add([e]):n.delete([e]));this.dispatchEvent(new t.EventFactory.newExpandCollapseEvent(s?"expand":"collapse",e,p.findRootAndAncestors(this.getCtx(),this.getOptions()._nodes,e,[]).root,this.getOptions()._widgetConstructor,n)),this.__setNavigableIdToFocus(e)},t.Sunburst.prototype._calcAngle=function(t,e){return Math.atan2(e-this._translatePt.y,t-this._translatePt.x)},t.Sunburst.prototype._updateStartAngle=function(e){this._startAngle+=e,this._startAngle<-Math.PI?this._startAngle+=2*Math.PI:this._startAngle>Math.PI&&(this._startAngle-=2*Math.PI);var i=new t.Rectangle(0,0,this.Width,this.Height);this.Layout(i),this._root&&this._root.updateShapes(!0)},t.Sunburst.prototype.__getNodeUnderPoint=function(t,e){return this._root.getNodeUnderPoint(t-this._translatePt.x,e-this._translatePt.y)},t.Sunburst.prototype.__showDropSiteFeedback=function(e){var i=t.Sunburst.superclass.__showDropSiteFeedback.call(this,e);return i&&i.setTranslate(this._translatePt.x,this._translatePt.y),i},t.Sunburst.prototype.__isRotationEnabled=function(){return"off"!=this.getOptions().rotation},t.Sunburst.prototype.CreateNode=function(t){return new A(this,t)},t.Sunburst.prototype.getCenterPoint=function(){return this._translatePt};var A=function(t,e){this.Init(t,e);var i=this._view.getOptions().nodeDefaults;this._labelDisplay=e.labelDisplay?e.labelDisplay:i.labelDisplay,this._evaluateExpanded(t,e),this._labelHalign=e.labelHalign?e.labelHalign:i.labelHalign,this._radius=e.radius,this._className=e.className||e.svgClassName,this._style=e.style||e.svgStyle,this._showDisclosure="on"==e.showDisclosure||"off"!=e.showDisclosure&&"on"==i.showDisclosure};t.Obj.createSubclass(A,l),A.TEXT_BUFFER_HORIZ=6,A._EXPAND_ICON_SIZE=16,A._ROOT_NODE_MARGIN=2,A._MIN_ARC_LENGTH=1.5,A._MIN_ANGLE_EXTENT=6e-4,A.TWO_PI=2*Math.PI,A._CENTER_ARTIFICIAL_ROOT_RADIUS=.25,A._CENTER_NODE_RADIUS=.5,A._CENTER_WITH_CONTENT_RADIUS=1,A.prototype.render=function(e){if(this._hasLayout){this._nodeContainer=e,this._shape=this._createShapeNode(),e.addChild(this._shape);var i=this.GetTemplate();if(this._showRootContent()&&i){var s=Math.sqrt(2),n=this._outerRadius*s-2*A._ROOT_NODE_MARGIN,o=n;this._x=-this._outerRadius/s+A._ROOT_NODE_MARGIN,this._y=-this._outerRadius/s+A._ROOT_NODE_MARGIN;var a=this.GetElAttributes(),r=this.GetAfContext();if(r.setELContext(a),n>0&&o>0){r.setAvailableWidth(n),r.setAvailableHeight(o),r.setFontSize(this.GetTextSize());var l=t.AfComponentFactory.parseAndLayout(r,i,this._shape);this._contentRoot=l;var h=l.getDimensions();l.setTranslate(this._x+(n-h.w)/2,this._y+(o-h.h)/2)}}else if(!(this.isRootNode()&&this._createRootNodeContent()||(this._text=this._createTextNode(this._shape),null==this._text))){this._shape.addChild(this._text);var _=this.getLabelBackgroundColor();if(this.hasPattern()||_){h=this._text.getDimensions();this._textBackground=new t.Rect(this.getView().getCtx(),h.x,h.y,h.w,h.h),_?this._textBackground.setSolidFill(_):this._textBackground.setSolidFill("#FFFFFF"),this._textBackground.setMouseEnabled(!1),this._shape.addChild(this._textBackground);var d=this._text.getMatrix();d.isIdentity()||this._textBackground.setMatrix(d),this._shape.addChild(this._text)}}this._shape.setAriaRole("img"),this._shape.setStyle(this._style),this._shape.setClassName(this._className),this.UpdateAriaLabel(),this.renderChildren(e)}},A.prototype.renderChildren=function(e){var i=this.getChildNodes(),s=this.getView().__getNodeCount()>=t.Sunburst.LARGE_DATASET_THRESHOLD;if(null!=i)for(var n=0,o=0;o<i.length;o++){var a=i[o]._angleExtent;if(!(a<A._MIN_ANGLE_EXTENT)){if(s){var r=i[o]._getOuterRadius(),l=a*r,h=(i[o]._startAngle+a)*r;if(l<A._MIN_ARC_LENGTH&&Math.abs(n-h)<A._MIN_ARC_LENGTH)continue;n=h}i[o].render(e)}}},A.prototype.setSelected=function(e){A.superclass.setSelected.call(this,e),null!=this._shape&&(this.isSelected()?(this._shape.setSelected(!0),this.getView().__moveToSelectedLayer(this._shape)):(this._shape.setSelected(!1),t.Agent.isTouchDevice()&&this._expandButton?this.getView().__moveToSelectedLayer(this._shape):this._nodeContainer&&this._nodeContainer.addChild(this._shape)))},A.prototype.showHoverEffect=function(){this._shape&&this._hasLayout&&(this._shape.showHoverEffect(),this.isSelected()?this.getView().__moveToSelectedLayer(this._shape):this.getView().__moveToHoverLayer(this._shape))},A.prototype.hideHoverEffect=function(){this._shape&&this._hasLayout&&!this.isShowingKeyboardFocusEffect()&&(this._shape.hideHoverEffect(),!this.isSelected()&&this._nodeContainer&&this._nodeContainer.addChild(this._shape))},A.prototype.isExpandCollapseEnabled=function(){return this._showDisclosure},A.prototype.getNextNavigable=function(e){var i,s,n,o,a;if(e.type==t.MouseEvent.CLICK)return A.superclass.getNextNavigable.call(this,e);if((i=e.keyCode)==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;for(a=this;a.GetParent();)a=a.GetParent();n=this.GetNodesAtDepth(a,this.GetDepth()),o=A._findNodeIndex(this,n);var r,l,h=this._startAngle+this._angleExtent/2;switch(h=A._normalizedRadToDeg(h),i){case t.KeyboardEvent.UP_ARROW:if(this===a||h>180){if((r=this.GetLastVisitedChild())&&(l=r._startAngle+r._angleExtent/2,(l=A._normalizedRadToDeg(l))>180))return r;s=t.KeyboardHandler.getNextAdjacentNavigable(this,e,this.getDescendantNodes())}else s=this._navigateToParent();break;case t.KeyboardEvent.DOWN_ARROW:if(this===a||h>=0&&h<=180){if((r=this.GetLastVisitedChild())&&(l=r._startAngle+r._angleExtent/2,(l=A._normalizedRadToDeg(l))>=0&&l<=180))return r;s=t.KeyboardHandler.getNextAdjacentNavigable(this,e,this.getDescendantNodes())}else s=this._navigateToParent();break;case t.KeyboardEvent.LEFT_ARROW:s=1==n.length?this:0==o?n[n.length-1]:n[o-1];break;case t.KeyboardEvent.RIGHT_ARROW:s=1==n.length?this:o==n.length-1?n[0]:n[o+1];break;default:s=this}return s.MarkAsLastVisitedChild(),s},A.prototype._navigateToParent=function(){var t,e=this.GetParent();return e?(t=e,e.MarkAsLastVisitedChild()):t=this,t.MarkAsLastVisitedChild(),t},A._normalizedRadToDeg=function(e){var i=t.Math.radsToDegrees(e);return i<0?i+=360:i>360&&(i-=360),i},A.prototype.getKeyboardBoundingBox=function(e){if(this._shape){var i=this._shape.getDimensions(),s=new t.Point(i.x,i.y);return s=this._shape.localToStage(s),i.x=s.x,i.y=s.y,i}return new t.Rectangle(0,0,0,0)},A.prototype.getTargetElem=function(){return this._shape?this._shape.getElem():null},A.prototype.setLayoutParams=function(t,e,i,s){this._innerRadius=t,this._outerRadius=e,this._startAngle=i,this._angleExtent=s,this._hasLayout=!0},A.prototype.GetFill=function(){return this.isArtificialRoot()?t.SolidFill.invisibleFill():A.superclass.GetFill.call(this)},A.prototype.GetAnimationParams=function(e){var i=t.ColorUtils.getRed(this._color),s=t.ColorUtils.getGreen(this._color),n=t.ColorUtils.getBlue(this._color),o=this._startAngle;if(e&&!isNaN(e[2])){var a=e[2];a-this._startAngle>Math.PI?o+=A.TWO_PI:this._startAngle-a>Math.PI&&(o-=A.TWO_PI)}return[this._innerRadius,this._outerRadius,o,this._angleExtent,i,s,n]},A.prototype.SetAnimationParams=function(e){this.setLayoutParams(e[0],e[1],e[2],e[3]);var i=Math.round(e[4]),s=Math.round(e[5]),n=Math.round(e[6]);this._color=t.ColorUtils.makeRGB(i,s,n),this.updateShapes(!1)},A.prototype.animateUpdate=function(t,e){!this.isRootNode()||e._getOuterRadius()==this._getOuterRadius()&&e.getId()==this.getId()||this._removeRootNodeContentOverlay(),e._hasLayout&&e._angleExtent>0?A.superclass.animateUpdate.call(this,t,e):this.animateInsert(t)},A.prototype.animateInsert=function(t,e){this.isRootNode()&&this._removeRootNodeContentOverlay(),A.superclass.animateInsert.call(this,t,e)},A.prototype.animateDelete=function(t,e){this.isRootNode()&&this._removeRootNodeContentOverlay(),A.superclass.animateDelete.call(this,t,e)},A.prototype.getNodeUnderPoint=function(t,e){if(this.contains(t,e))return this;for(var i=this.getChildNodes(),s=0;s<i.length;s++){var n=i[s].getNodeUnderPoint(t,e);if(n)return n}return null},A.prototype.contains=function(t,e){var i=A._calcRadius(t,e),s=A._calcAngle(t,e);return this.ContainsRadius(i)&&this.ContainsAngle(s)},A.prototype.ContainsAngle=function(t){for(;t<this._startAngle;)t+=A.TWO_PI;for(;t-this._startAngle>A.TWO_PI;)t-=A.TWO_PI;return t>=this._startAngle&&t<=this._startAngle+this._angleExtent},A.prototype.ContainsRadius=function(t){return t>=this._innerRadius&&t<=this._outerRadius},A._calcPointOnArc=function(t,e){return{x:Math.cos(e)*t,y:Math.sin(e)*t}},A._calcAngle=function(t,e){var i=Math.atan2(e,t);return i<0?i+=A.TWO_PI:i>A.TWO_PI&&(i-=A.TWO_PI),i},A._calcRadius=function(t,e){return Math.sqrt(t*t+e*e)},A.prototype._createShapeNode=function(){if(!this._angleExtent||this._angleExtent<=0)return null;var e=this._createPathCmd(),i=new t.Path(this.getView().getCtx(),e);this.getView().getEventManager().associate(i,this),i.setAlpha(this.getAlpha()),i.setFill(this.GetFill());var s=this._view.getOptions().nodeDefaults,n=this.getOptions(),o=n.borderColor||s.borderColor,a=n.borderWidth||s.borderWidth;return i.setStroke(new t.Stroke(o,1,a)),i.setHoverStroke(new t.Stroke(s.hoverColor,1,3)),i.setSelectedStroke(new t.Stroke(s.selectedInnerColor,1,1.5),new t.Stroke(s.selectedOuterColor,1,3.5)),i.setSelectedHoverStroke(new t.Stroke(s.hoverColor,1,3)),i.setSelectable(this.isSelectable()),this.isDrillReplaceEnabled()&&i.setCursor("pointer"),this.isArtificialRoot()&&(i.setAlpha(.001),i.setMouseEnabled(!1)),i},A.prototype._createPathCmd=function(){var e,i,s,n,o;return this._angleExtent<A.TWO_PI?(i=A._calcPointOnArc(this._outerRadius,this._startAngle),s=A._calcPointOnArc(this._outerRadius,this._startAngle+this._angleExtent),n=A._calcPointOnArc(this._innerRadius,this._startAngle+this._angleExtent),o=A._calcPointOnArc(this._innerRadius,this._startAngle),e=t.PathUtils.moveTo(i.x,i.y)+t.PathUtils.arcTo(this._outerRadius,this._outerRadius,this._angleExtent,1,s.x,s.y)+t.PathUtils.lineTo(n.x,n.y)+t.PathUtils.arcTo(this._innerRadius,this._innerRadius,this._angleExtent,0,o.x,o.y)+t.PathUtils.closePath()):(i=A._calcPointOnArc(this._outerRadius,this._startAngle),s=A._calcPointOnArc(this._outerRadius,this._startAngle+this._angleExtent/2),n=A._calcPointOnArc(this._innerRadius,this._startAngle),o=A._calcPointOnArc(this._innerRadius,this._startAngle+this._angleExtent/2),e=t.PathUtils.moveTo(i.x,i.y)+t.PathUtils.arcTo(this._outerRadius,this._outerRadius,this._angleExtent/2,1,s.x,s.y)+t.PathUtils.arcTo(this._outerRadius,this._outerRadius,this._angleExtent/2,1,i.x,i.y),this._innerRadius>0&&(e+=t.PathUtils.moveTo(o.x,o.y)+t.PathUtils.arcTo(this._innerRadius,this._innerRadius,this._angleExtent/2,0,n.x,n.y)+t.PathUtils.arcTo(this._innerRadius,this._innerRadius,this._angleExtent/2,0,o.x,o.y)),e+=t.PathUtils.closePath()),e},A.prototype._createExpandCollapseButton=function(t){var e=this.isDisclosed();if(!t||!this.isExpandCollapseEnabled()||!this.hasChildren()&&e||this.getView().hasDataProvider()&&!this.hasDPChildren())return null;var i=e?this._getCollapseButton():this._getExpandButton();this._positionButton(i),t.addChild(i);var s=this.getView().getOptions().translations[this.isDisclosed()?"tooltipCollapse":"tooltipExpand"];return this.getView().getEventManager().associate(i,new h(this,this.getId(),s)),i},A.prototype._positionButton=function(t){var e=A._calcPointOnArc(this._outerRadius,this._startAngle+this._angleExtent/2);t.setTranslate(e.x-A._EXPAND_ICON_SIZE/2,e.y-A._EXPAND_ICON_SIZE/2)},A.prototype._createTextNode=function(e){if(!this._textStr||!e||!this._labelDisplay||"off"==this._labelDisplay)return null;if(this==this.getView().getRootNode()&&this._angleExtent<A.TWO_PI)return null;var i=!1;return"auto"==this._labelDisplay?i="ie"===t.Agent.browser||"edge"===t.Agent.browser||"windows"!=t.Agent.os:"rotated"==this._labelDisplay&&(i=!0),i&&this._angleExtent<this.getView().__getAngleExtent()?this._createTextRotated(e):this._createTextHoriz(e)},A.prototype._createTextHoriz=function(e){var i;if(0==this._innerRadius)i={x:0,y:0};else{i=A._calcPointOnArc((this._innerRadius+this._outerRadius)/2,this._startAngle+this._angleExtent/2);var s=3*this.GetTextSize()/2,n=A._calcAngle(i.x-s/2,i.y),o=A._calcAngle(i.x+s/2,i.y);this.ContainsAngle(n)&&this.ContainsAngle(o)||(i=null)}if(i){var a=new t.OutputText(this.getView().getCtx(),this._textStr,i.x,i.y,null);a.setFontSize(this.GetTextSize()),this.ApplyLabelTextStyle(a),a.alignCenter(),a.alignMiddle(),a.setMouseEnabled(!1);for(var r=a.getDimensions(),l=i.x,h=i.x,_=i.y-r.h/2,d=i.y+r.h/2,u=!0;this.contains(l,_)&&this.contains(l,d)&&u;)l--,this._angleExtent>Math.PI&&i.x-l>=r.w&&(u=!1);for(var c=!0;this.contains(h,_)&&this.contains(h,d)&&c;)h++,this._angleExtent>Math.PI&&h-i.x>=r.w&&(c=!1);l+=3,h-=3;var p=2*Math.min(i.x-l,h-i.x);p<r.w&&(a.setX((l+h)/2),p=h-l);var g=this.getView().getOptions().nodeDefaults.labelMinLength;return t.TextUtils.fitText(a,p,r.h,e,g)?a:null}},A.prototype._createTextRotated=function(e){var i=Math.max(this._innerRadius,10),s=this._outerRadius-i-A.TEXT_BUFFER_HORIZ,n=this._angleExtent*(i+A.TEXT_BUFFER_HORIZ)*1.1;if(n<=6)return null;var o=new t.OutputText(this.getView().getCtx(),this._textStr,0,0);if(o.setFontSize(this.GetTextSize()),this.ApplyLabelTextStyle(o),!t.TextUtils.fitText(o,s,n,e))return null;var a=(i+this._outerRadius)/2;if("inner"==this._labelHalign||"outer"==this._labelHalign){e.addChild(o);var r=o.getDimensions().w,l=.75*A.TEXT_BUFFER_HORIZ;"inner"==this._labelHalign?a=i+l+r/2:"outer"==this._labelHalign&&(a=this._outerRadius-l-r/2)}var h=A._calcPointOnArc(a,this._startAngle+this._angleExtent/2);o.alignCenter(),o.alignMiddle();var _=this._startAngle+this._angleExtent/2;return(_=(_=_>=A.TWO_PI?_-A.TWO_PI:_)<0?_+A.TWO_PI:_)>.5*Math.PI&&_<1.5*Math.PI&&(_+=Math.PI),o.setRotation(_),o.setTranslate(h.x,h.y),o.setMouseEnabled(!1),o},A._findNodeIndex=function(t,e){for(var i=0;i<e.length;i++)if(t===e[i])return i;return-1},A.prototype.handleMouseOver=function(){this._expandButton||(this._expandButton=this._createExpandCollapseButton(this._shape)),A.superclass.handleMouseOver.call(this)},A.prototype.handleMouseOut=function(){this._expandButton&&this._shape&&(this._shape.removeChild(this._expandButton),this._expandButton=null),A.superclass.handleMouseOut.call(this)},A.prototype.updateShapes=function(e){if(this._shape){var i=this._createPathCmd();if(this._shape.setCmds(i),!this._showRootContent()){this._text&&this._shape.removeChild(this._text),this._text=this._createTextNode(this._shape);var s=this.getLabelBackgroundColor();if(this._text&&(this.hasPattern()||s)){var n=this._text.getDimensions();this._textBackground?this._textBackground.setRect(n.x,n.y,n.w,n.h):(this._textBackground=new t.Rect(this.getView().getCtx(),n.x,n.y,n.w,n.h),s?this._textBackground.setSolidFill(s):this._textBackground.setSolidFill("#FFFFFF"),this._textBackground.setMouseEnabled(!1),this._shape.addChild(this._textBackground));var o=this._text.getMatrix();o.isIdentity()||this._textBackground.setMatrix(o)}else this._textBackground&&(this._shape.removeChild(this._textBackground),this._textBackground=null)}if(t.Agent.isTouchDevice()&&this._expandButton&&this._positionButton(this._expandButton),this._shape.setFill(this.GetFill()),e)for(var a=this.getChildNodes(),r=0;r<a.length;r++)a[r].updateShapes(!0)}},A.prototype.getDropSiteFeedback=function(){return this._shape instanceof t.Circle?new t.Circle(this.getView().getCtx(),this._shape.getCx(),this._shape.getCy(),this._shape.getRadius()):this._shape instanceof t.Path?new t.Path(this.getView().getCtx(),this._shape.getCmds()):null},A.prototype._getExpandButton=function(){var e=this.getView().getCtx(),i=this.getView().getOptions()._resources,s=new t.Image(e,i.expand,0,0,A._EXPAND_ICON_SIZE,A._EXPAND_ICON_SIZE),n=new t.Image(e,i.expandOver,0,0,A._EXPAND_ICON_SIZE,A._EXPAND_ICON_SIZE),o=new t.Image(e,i.expandDown,0,0,A._EXPAND_ICON_SIZE,A._EXPAND_ICON_SIZE);s.setInvisibleFill(),n.setInvisibleFill(),o.setInvisibleFill();var a=new t.Button(e,s,n,o);return a.addEvtListener(t.MouseEvent.CLICK,this.expandCollapse,!1,this),a},A.prototype._getCollapseButton=function(){var e=this.getView().getCtx(),i=this.getView().getOptions()._resources,s=new t.Image(e,i.collapse,0,0,A._EXPAND_ICON_SIZE,A._EXPAND_ICON_SIZE),n=new t.Image(e,i.collapseOver,0,0,A._EXPAND_ICON_SIZE,A._EXPAND_ICON_SIZE),o=new t.Image(e,i.collapseDown,0,0,A._EXPAND_ICON_SIZE,A._EXPAND_ICON_SIZE);s.setInvisibleFill(),n.setInvisibleFill(),o.setInvisibleFill();var a=new t.Button(e,s,n,o);return a.addEvtListener(t.MouseEvent.CLICK,this.expandCollapse,!1,this),a},A.prototype.expandCollapse=function(t){this.getView().expandCollapseNode(this.getId()),t.stopPropagation()},A.prototype.getExpandCollapseButton=function(){return this._expandButton},A.prototype._showRootContent=function(){return!this._parent&&0==this._innerRadius&&this._angleExtent==A.TWO_PI},A.prototype.hasRootContent=function(){return!!this.GetTemplate()},A.prototype.__getRadius=function(){return null!=this._radius?Number(this._radius):this.GetParent()?1:this.isArtificialRoot()?A._CENTER_ARTIFICIAL_ROOT_RADIUS:this.hasRootContent()?A._CENTER_WITH_CONTENT_RADIUS:A._CENTER_NODE_RADIUS},A.prototype.getAriaLabel=function(){var e=this.getView().getOptions().translations,i=[];return this.isSelectable()&&i.push(e[this.isSelected()?"stateSelected":"stateUnselected"]),this.isExpandCollapseEnabled()&&i.push(e[this.isDisclosed()?"stateExpanded":"stateCollapsed"]),this.isDrillReplaceEnabled()&&i.push(e.stateDrillable),t.Displayable.generateAriaLabel(this.getShortDesc(),i)},A.prototype.UpdateAriaLabel=function(){!t.Agent.deferAriaCreation()&&this._shape&&this._shape.setAriaProperty("label",this.getAriaLabel())},A.prototype.getDataContext=function(){var t=A.superclass.getDataContext.call(this);return t.radius=this.__getRadius(),t},A.prototype._createRootNodeContent=function(){var e=this.getView(),i=e.getOptions(),s=i.rootNodeContent.renderer;if(this._removeRootNodeContentOverlay(),!s)return!1;var n,o=e.getCtx(),a=e.getCenterPoint(),r=this._outerRadius,l=r*Math.sqrt(2),h=this.getOptions(),_=h;h._noTemplate?(n=h._itemData,_=h._itemData):h._itemData&&(n=h._itemData,_=h=t.JsonUtils.clone(h),delete h._itemData);var d={outerBounds:{x:a.x-r,y:a.y-r,width:2*r,height:2*r},innerBounds:{x:a.x-l/2,y:a.y-l/2,width:l,height:l},id:this._id,data:_,itemData:n,component:i._widgetConstructor};d=o.fixRendererContext(d);var u=o.getContainer(),c=s(d);if(c){var p=o.createOverlayDiv();Array.isArray(c)?c.forEach(function(t){p.appendChild(t)}):p.appendChild(c),e.rootNodeContent=p,u.appendChild(p);var g=o.getOverlayAttachedCallback();return g&&g(p),!0}},A.prototype._getOuterRadius=function(){return this._outerRadius},A.prototype._removeRootNodeContentOverlay=function(){var t=this.getView(),e=t.rootNodeContent;e&&t.getCtx().getContainer().removeChild(e),t.rootNodeContent=null},A.prototype._evaluateExpanded=function(e,i){var s=e.getOptions(),n=s.expanded;i.bArtificialRoot||i._expanded||(n.has?n.has(i.id)||this.setDisclosed(!1):n instanceof Array&&!t.ArrayUtils.hasAnyMapItem(s._expandedNodes,[i.id])&&this.setDisclosed(!1))};var T=new Object;t.Obj.createSubclass(T,t.Obj),T.layout=function(t,e,i,s,n){var o=t/T._calcLargestRadius(e);T._layout(o,e,i,s,n,0)},T._layout=function(e,i,s,n,o,a){var r=a+i.__getRadius()*e;i.setLayoutParams(a,r,s,n);var l=i.getChildNodes();if(null!=l&&i.isDisclosed()){var h,_=s;"on"==o&&(l=l.slice(0)).sort(function(t,e){return e.getSize()-t.getSize()}),t.Agent.isRightToLeft(i.getView().getCtx())&&(l=l.slice(0).reverse());var d=0;for(h=0;h<l.length;h++)d+=l[h].getSize()>0?l[h].getSize():0;for(h=0;h<l.length;h++){var u=l[h];if(!(u.getSize()<=0)){var c=u.getSize()/d*n;T._layout(e,u,_,c,o,r),_+=c}}}},T._calcLargestRadius=function(t){var e=0,i=t.getChildNodes();if(i&&i.length>0){for(var s=0;s<i.length;s++){var n=T._calcLargestRadius(i[s]);e=Math.max(e,n)}return e+t.__getRadius()}return t.__getRadius()};var O=function(t,e,i,s){r.call(this,t,e,i,s)};t.Obj.createSubclass(O,r),O.ROTATION_ID="_rotationShape",O.prototype.OnMouseDown=function(t){var e=this.GetLogicalObject(t.target);if(e&&e.getId&&e.getId()==O.ROTATION_ID&&!this._bRotating){this._bRotating=!0;var i=this._context.pageToStageCoords(t.pageX,t.pageY);this.GetView().__startRotation(i.x,i.y)}else O.superclass.OnMouseDown.call(this,t)},O.prototype.OnMouseMove=function(t){if(this._bRotating){var e=this._context.pageToStageCoords(t.pageX,t.pageY);this.GetView().__continueRotation(e.x,e.y)}else O.superclass.OnMouseMove.call(this,t)},O.prototype.OnMouseUp=function(t){this._bRotating?(this._bRotating=!1,this.GetView().__endRotation()):O.superclass.OnMouseUp.call(this,t)},O.prototype.ProcessKeyboardEvent=function(e){var i=!0,s=e.keyCode,n=this.getFocus(),o=this.GetView();if(n.isExpandCollapseEnabled()&&(t.KeyboardEvent.isPlus(e)&&!n.isDisclosed()||t.KeyboardEvent.isMinus(e)&&n.isDisclosed()||e.ctrlKey&&s==t.KeyboardEvent.ENTER))o.expandCollapseNode(n.getId()),t.EventManager.consumeEvent(e);else if(o&&o.__isRotationEnabled()&&(s==t.KeyboardEvent.LEFT_ARROW||s==t.KeyboardEvent.RIGHT_ARROW)&&!e.ctrlKey&&e.altKey&&e.shiftKey){var a;a=s==t.KeyboardEvent.LEFT_ARROW?Math.PI/180*-5:Math.PI/180*5,o.__setRotationAnchor(0),o.__rotate(a),o.__endRotation(),t.EventManager.consumeEvent(e)}else i=O.superclass.ProcessKeyboardEvent.call(this,e);return i},O.ROTATE_KEY="rotateKey",O.prototype.HandleImmediateTouchStartInternal=function(t){var e=this.GetLogicalObject(t.target);e&&e.getId&&e.getId()==O.ROTATION_ID&&this.TouchManager.processAssociatedTouchAttempt(t,O.ROTATE_KEY,this.RotateStartTouch,this)},O.prototype.HandleImmediateTouchMoveInternal=function(t){this.TouchManager.processAssociatedTouchMove(t,O.ROTATE_KEY)},O.prototype.HandleImmediateTouchEndInternal=function(t){this.TouchManager.processAssociatedTouchEnd(t,O.ROTATE_KEY)},O.prototype.RotateStartTouch=function(t,e){if(this.TouchManager.getTouchIdsForObj(O.ROTATE_KEY).length<=1){this.TouchManager.saveProcessedTouch(e.identifier,O.ROTATE_KEY,null,O.ROTATE_KEY,O.ROTATE_KEY,this.RotateMoveTouch,this.RotateEndTouch,this),this.TouchManager.setTooltipEnabled(e.identifier,!1);var i=this._context.pageToStageCoords(e.pageX,e.pageY);this.GetView().__startRotation(i.x,i.y),t.blockTouchHold()}},O.prototype.RotateMoveTouch=function(t,e){var i=this._context.pageToStageCoords(e.pageX,e.pageY);this.GetView().__continueRotation(i.x,i.y),t.preventDefault()},O.prototype.RotateEndTouch=function(t,e){this.GetView().__endRotation()};var I=function(t){this.Init({alta:I.SKIN_ALTA},t)};t.Obj.createSubclass(I,c),I.SKIN_ALTA={nodeDefaults:{borderColor:"rgba(255,255,255,0.3)",borderWidth:1,hoverColor:"#FFFFFF",labelDisplay:"auto",labelHalign:"center",selectedInnerColor:"#FFFFFF",selectedOuterColor:"#000000"},rootNodeContent:{},rotation:"on",expanded:"all",startAngle:90}}(dvt);
  return dvt;
});
