/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(["ojs/ojcore","jquery","ojs/ojdatasource-common"],function(t,r){"use strict";t.ArrayCellSet=function(t,r,e,a,o){this.m_startRow=t,this.m_endRow=r,this.m_startColumn=e,this.m_endColumn=a,this.m_callback=o},t.ArrayCellSet.prototype.getData=function(t){var r=this,e=t.row,a=t.column,o={};return Object.defineProperty(o,"data",{enumerable:!0,get:function(){return r.m_callback._getCellData(e,a)},set:function(t){r.m_callback._setCellData(e,a,t)}}),o},t.ArrayCellSet.prototype.getMetadata=function(t){return this.m_callback._getCellMetadata(t.row,t.column)},t.ArrayCellSet.prototype.getStart=function(t){return"row"===t?this.m_startRow:"column"===t?this.m_startColumn:-1},t.ArrayCellSet.prototype.getCount=function(t){return"row"===t?Math.max(0,this.m_endRow-this.m_startRow):"column"===t?Math.max(0,this.m_endColumn-this.m_startColumn):0},t.ArrayCellSet.prototype.getExtent=function(t){return{row:{extent:1,more:{before:!1,after:!1}},column:{extent:1,more:{before:!1,after:!1}}}},t.ArrayCellSet.prototype.getStartRow=function(){return this.m_startRow},t.ArrayCellSet.prototype.getStartColumn=function(){return this.m_startColumn},t.ArrayDataGridDataSource=function(r,e){if(!(r instanceof Array)&&"function"!=typeof r&&"function"!=typeof r.subscribe){throw new Error("_ERR_DATA_INVALID_TYPE_SUMMARY\n_ERR_DATA_INVALID_TYPE_DETAIL")}this.rowHeaderKey=this._getRowHeaderFromOptions(e),null!=e&&(this.columns=e.columns,this.sortCriteria=e.initialSort),t.ArrayDataGridDataSource.superclass.constructor.call(this,r)},t.Object.createSubclass(t.ArrayDataGridDataSource,t.DataGridDataSource,"oj.ArrayDataGridDataSource"),t.ArrayDataGridDataSource.prototype.Init=function(){null==this.columns&&(this.columns=this._getColumnsForScaffolding(this.getDataArray())),this._initializeRowKeys(),"function"==typeof this.data&&this.data.subscribe(this._subscribe.bind(this),null,"arrayChange"),t.ArrayDataGridDataSource.superclass.Init.call(this)},t.ArrayDataGridDataSource.prototype.comparator=null,t.ArrayDataGridDataSource.prototype.sortCriteria=null,t.ArrayDataGridDataSource.prototype._getRowHeaderFromOptions=function(t){if(null!=t&&null!=t.rowHeader){var r=t.rowHeader;if("object"==typeof r){if(null!=r.default){if("none"===r.default)return;if("index"===r.default)return"m_defaultIndex"}}else if(null!=r)return r}return"m_defaultIndex"},t.ArrayDataGridDataSource.prototype._initializeRowKeys=function(){var t;for(t=this.getDataArray(),this.lastKey=0;this.lastKey<t.length;this.lastKey+=1)t[this.lastKey].ojKey=this.lastKey.toString()},t.ArrayDataGridDataSource.prototype._getColumnsForScaffolding=function(t){if("number"!=typeof t.length||0===t.length)return[];for(var r=[],e=Object.keys(t[0]),a=0;a<e.length;a++){var o=e[a];void 0!==this.rowHeaderKey&&o===this.rowHeaderKey||r.push(o)}return r},t.ArrayDataGridDataSource.prototype.getCount=function(t){return"row"===t?this._size():"column"===t?this.columns.length:0},t.ArrayDataGridDataSource.prototype.getCountPrecision=function(t){return"exact"},t.ArrayDataGridDataSource.prototype._getHeaderData=function(t,r){{if("row"===t)return void 0===this.rowHeaderKey?null:"m_defaultIndex"===this.rowHeaderKey?this._getRowKeyByIndex(r):this.getDataArray()[r][this.rowHeaderKey];if("column"===t)return this.columns[r]}},t.ArrayDataGridDataSource.prototype._getHeaderMetadata=function(t,r){var e;return"row"===t?{key:this._getRowKeyByIndex(r)}:"column"===t?(e=this._getHeaderData(t,r),null!=this.sortCriteria&&this.sortCriteria.key===e?{key:this._getHeaderData(t,r),sortDirection:this.sortCriteria.direction}:{key:e}):void 0},t.ArrayDataGridDataSource.prototype.fetchHeaders=function(r,e,a){var o,n=r.axis,i=r.start,s=r.count;if(i=Math.max(0,i),"column"===n)o=Math.min(this.columns.length,i+s);else{var u=this.getDataArray();o=void 0===this.rowHeaderKey?i:Math.min(u.length,i+s)}var l=new t.ArrayHeaderSet(i,o,n,this);null!=e&&null!=e.success&&(null==a&&(a={}),e.success.call(a.success,l,r,null))},t.ArrayDataGridDataSource.prototype._getCellData=function(t,r){var e=this.columns[r];return this.getDataArray()[t][e]},t.ArrayDataGridDataSource.prototype._setCellData=function(t,r,e){this.getDataArray()[t][this.columns[r]]=e},t.ArrayDataGridDataSource.prototype._getCellMetadata=function(t,r){return{keys:{row:this._getRowKeyByIndex(t),column:this.columns[r]}}},t.ArrayDataGridDataSource.prototype.fetchCells=function(r,e,a){for(var o,n,i,s,u=0;u<r.length;u+=1){var l=r[u];"row"===l.axis?(o=l.start,n=Math.min(this._size(),o+l.count)):"column"===l.axis&&(i=l.start,s=Math.min(this.columns.length,i+l.count))}if(void 0!==n&&void 0!==s){var c=new t.ArrayCellSet(o,n,i,s,this);null!=e&&null!=e.success&&(null==a&&(a={}),e.success.call(a.success,c,r))}else null!=e&&null!=e.error&&(null==a&&(a={}),e.error.call(a.error))},t.ArrayDataGridDataSource.prototype.keys=function(t){var r=t.row,e=t.column;return new Promise(function(t){t({row:this._getRowKeyByIndex(r),column:this.columns[e]})}.bind(this))},t.ArrayDataGridDataSource.prototype.indexes=function(t){var r=t.row,e=t.column;return new Promise(function(t){t({row:this._getRowIndexByKey(r),column:this.columns.indexOf(e)})}.bind(this))},t.ArrayDataGridDataSource.prototype.sort=function(t,r,e){var a=[],o=[];if(null!=r&&null==e&&(e={}),void 0===this.origData&&(this._origSortCriteria=this.sortCriteria,this.origData=this.data.slice()),null==t?t=this.sortCriteria:this.sortCriteria=t,null!=t){var n=t.axis,i=t.key;if("column"===n)this.getDataArray().sort(this._getComparator()),null!=r&&null!=r.success&&r.success.call(e.success);else if("row"===n){var s,u=this._getRowIndexByKey(i);for(s=0;s<this.columns.length;s+=1)a[s]=this.getDataArray()[u][this.columns[s]];for(a.sort(this._getComparator()),s=0;s<this.columns.length;s+=1)o[s]=this.columns[a.indexOf(this.getDataArray()[u][this.columns[s]])];this.origColumns=this.columns,this.columns=o,null!=r&&null!=r.success&&r.success.call(e.success)}else null!==r&&null!=r.error&&r.error.call(e.error,"Invalid axis value")}else this._resetSortOrder(r,e)},t.ArrayDataGridDataSource.prototype._resetSortOrder=function(t,r){void 0!==this.origData&&(this.data=this.origData,this.sortCriteria=this._origSortCriteria),null!=this.origColumns&&(this.columns=this.origColumns),null!=t&&null!=t.success&&t.success.call(r.success)},t.ArrayDataGridDataSource.prototype.getCapability=function(t){return"sort"===t?"column":"move"===t?"row":null},t.ArrayDataGridDataSource.prototype._getComparator=function(){var t=this.comparator;if(null==t){var r=this.sortCriteria.key,e=this.sortCriteria.direction,a=this.sortCriteria.axis;return this._naturalSort(e,r,a)}return t},t.ArrayDataGridDataSource.prototype._naturalSort=function(t,r,e){return"ascending"===t?function(t,a){var o,n,i=t,s=a;return null!=r&&"column"===e&&(i instanceof Array?(i=i[parseInt(r,10)],s=s[parseInt(r,10)]):(i=i[r],s=s[r])),o=isNaN(i),n=isNaN(s),i instanceof Date&&(i=i.toISOString(),o=!0),s instanceof Date&&(s=s.toISOString(),n=!0),o&&n?i<s?-1:i===s?0:1:o?1:n?-1:i-s}:"descending"===t?function(t,a){var o,n,i=t,s=a;return null!=r&&"column"===e&&(i instanceof Array?(i=i[parseInt(r,10)],s=s[parseInt(r,10)]):(i=i[r],s=s[r])),o=isNaN(i),n=isNaN(s),i instanceof Date&&(i=i.toISOString(),o=!0),s instanceof Date&&(s=s.toISOString(),n=!0),o&&n?i>s?-1:i===s?0:1:o?-1:n?1:s-i}:void 0},t.ArrayDataGridDataSource.prototype.move=function(t,r,e,a,o){var n,i,s=this._getRowIndexByKey(t),u=this.data.splice(s,1)[0];this.data instanceof Array&&(i=this._getModelEvent("delete",t,null,s,-1,!0),this.handleEvent("change",i)),null===r?(this.data.push(u),n=this.data.length-1):(n=this._getRowIndexByKey(r),this.data.splice(n,0,u)),this.data instanceof Array&&(i=this._getModelEvent("insert",t,null,n,-1),this.handleEvent("change",i)),void 0!==this.origData&&(this.origData=this.data.slice())},t.ArrayDataGridDataSource.prototype.moveOK=function(t,r,e){return"valid"},t.ArrayDataGridDataSource.prototype.getDataArray=function(){return"function"==typeof this.data?this.data():this.data},t.ArrayDataGridDataSource.prototype._getRowIndexByKey=function(t){for(var r=this.getDataArray(),e=0;e<r.length;e++)if(r[e].ojKey===t)return e;return-1},t.ArrayDataGridDataSource.prototype._getRowKeyByIndex=function(t){var r=this.getDataArray();return r[t]?r[t].ojKey:null},t.ArrayDataGridDataSource.prototype._getModelEvent=function(t,r,e,a,o,n){var i={};return i.source=this,i.operation=t,i.keys={row:r,column:e},i.indexes={row:a,column:o},i.silent=n,i},t.ArrayDataGridDataSource.prototype._subscribe=function(t){var r,e,a,o=!1,n=!1;for(r=0;r<t.length;r++){if(void 0!==(e=t[r]).moved){n=!0,a=this._getModelEvent("refresh",null,null),this.handleEvent("change",a);break}"added"===e.status&&(o=!0)}if(!n){var i,s,u,l=[],c=[];for(r=0;r<t.length;r++)"deleted"===(e=t[r]).status&&(i=e.value,u=e.index,s=i.ojKey,l.push({row:s,column:-1}),c.push({row:u,column:-1}));for(l.length>0&&(a={source:this,operation:"delete",keys:l,indexes:c,silent:o},this.handleEvent("change",a)),r=0;r<t.length;r++)"added"===(e=t[r]).status&&(i=e.value,u=e.index,null==i.ojKey&&(i.ojKey=this.lastKey.toString(),this.lastKey+=1),s=i.ojKey,a=this._getModelEvent("insert",s,null,u,-1),this.handleEvent("change",a))}void 0!==this.origData&&(this.origData=this.data.slice())},t.ArrayDataGridDataSource.prototype._size=function(){return this.getDataArray().length},t.ArrayDataGridDataSource.prototype.getRowHeaderKey=function(){return this.rowHeaderKey},t.ArrayDataGridDataSource.prototype.getColumns=function(){return this.columns},t.ArrayDataGridDataSource.prototype.getData=function(){return this.data},t.ArrayHeaderSet=function(t,r,e,a){this.m_start=t,this.m_end=r,this.m_axis=e,this.m_callback=a},t.ArrayHeaderSet.prototype.getData=function(r,e){return null==this.m_callback?null:(t.Assert.assert(r<=this.m_end&&r>=this.m_start,"index out of bounds"),t.Assert.assert(null==e||0===e,"level out of bounds"),this.m_callback._getHeaderData(this.m_axis,r))},t.ArrayHeaderSet.prototype.getMetadata=function(r,e){return null==this.m_callback?null:(t.Assert.assert(r<=this.m_end&&r>=this.m_start,"index out of bounds"),t.Assert.assert(null==e||0===e,"level out of bounds"),this.m_callback._getHeaderMetadata(this.m_axis,r))},t.ArrayHeaderSet.prototype.getLevelCount=function(){return this.getCount()>0?1:0},t.ArrayHeaderSet.prototype.getExtent=function(r,e){return t.Assert.assert(r<=this.m_end&&r>=this.m_start,"index out of bounds"),t.Assert.assert(null==e||0===e,"level out of bounds"),{extent:1,more:{before:!1,after:!1}}},t.ArrayHeaderSet.prototype.getDepth=function(r,e){return t.Assert.assert(r<=this.m_end&&r>=this.m_start,"index out of bounds"),t.Assert.assert(null==e||0===e,"level out of bounds"),1},t.ArrayHeaderSet.prototype.getLabel=function(){return null},t.ArrayHeaderSet.prototype.getCount=function(){return null==this.m_callback?0:Math.max(0,this.m_end-this.m_start)},t.ArrayHeaderSet.prototype.getStart=function(){return this.m_start};var e={};return e.ArrayDataGridDataSource=t.ArrayDataGridDataSource,e.ArrayHeaderSet=t.ArrayHeaderSet,e.ArrayCellSet=t.ArrayCellSet,e});