/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(["ojs/ojcore","ojs/ojtranslation","jquery","ojs/ojlogger","ojs/ojdatasource-common"],function(t,e,a,r){"use strict";t.ArrayTableDataSource=function(e,a){if(this.data=e||{},!(e instanceof Array||this._isObservableArray(e))){var i=t.TableDataSource._LOGGER_MSG._ERR_DATA_INVALID_TYPE_SUMMARY,s=t.TableDataSource._LOGGER_MSG._ERR_DATA_INVALID_TYPE_DETAIL;throw new Error(i+"\n"+s)}null!=a&&null!=a.idAttribute||r.info(t.ArrayTableDataSource._LOGGER_MSG._INFO_ARRAY_TABLE_DATASOURCE_IDATTR),t.ArrayTableDataSource.superclass.constructor.call(this,e,a),this._eventHandlers=[],this._rows={},null!=e&&(this._idAttribute=null,null!=a&&null!=a.idAttribute&&(this._idAttribute=a.idAttribute)),(null==a||"enabled"!==a.startFetch&&null!=a.startFetch)&&null!=a||(this._startFetchEnabled=!0)},t.Object.createSubclass(t.ArrayTableDataSource,t.TableDataSource,"oj.ArrayTableDataSource"),t.ArrayTableDataSource.prototype.comparator=null,t.ArrayTableDataSource.prototype.sortCriteria=null,t.ArrayTableDataSource.prototype.Init=function(){t.ArrayTableDataSource.superclass.Init.call(this)},t.ArrayTableDataSource.prototype.add=function(t,e){e=e||{},this._checkDataLoaded();var a=e.at;return this._addToRowSet(t,a,e)},t.ArrayTableDataSource.prototype.at=function(t,e){var a;return this._checkDataLoaded(),a=t<0||t>=this._rows.data.length?null:{data:this._rows.data[t],index:t,key:this._getId(this._rows.data[t])},new Promise(function(t){t(a)})},t.ArrayTableDataSource.prototype.change=function(e,a){a=a||{},this._checkDataLoaded();var r=a.silent,i={data:[],keys:[],indexes:[]};e instanceof Array||(e=[e]);for(var s=0;s<e.length;s++){var n=e[s];if(null!=n){var o=this._getId(n),l=this._getInternal(o,!1);i.data.push(this._wrapWritableValue(n)),i.keys.push(o),i.indexes.push(l.index),this._rows.data[l.index]=n}}return!r&&i.data.length>0&&t.TableDataSource.superclass.handleEvent.call(this,t.TableDataSource.EventType.CHANGE,i),Promise.resolve(i)},t.ArrayTableDataSource.prototype.fetch=function(t){return"init"!==(t=t||{}).fetchType||this._startFetchEnabled?this._fetchInternal(t):Promise.resolve()},t.ArrayTableDataSource.prototype.get=function(t,e){return this._checkDataLoaded(),Promise.resolve(this._getInternal(t,!0))},t.ArrayTableDataSource.prototype.getCapability=function(t){return"full"},t.ArrayTableDataSource.prototype.remove=function(t,e){return e=e||{},this._checkDataLoaded(),this._removeInternal(t,e)},t.ArrayTableDataSource.prototype.reset=function(e,a){(a=a||{}).previousRows=this._rows;var r=a.silent;return null!=e&&(this.data=e),this._rows={},this._totalSize=0,this._arrayChangeSubscription&&(this._arrayChangeSubscription.dispose(),this._arrayChangeSubscription=null),r||t.TableDataSource.superclass.handleEvent.call(this,t.TableDataSource.EventType.RESET,null),Promise.resolve()},t.ArrayTableDataSource.prototype.sort=function(e){null==e?e=this.sortCriteria:this.sortCriteria=e,e=e||{},this._checkDataLoaded();var a=this;return new Promise(function(r){var i=a._getComparator();a._rows.data.sort(function(e,r){return t.ArrayTableDataSource._sortFunc(e,r,i,a)}),a._sorted=!0;var s={header:e.key,direction:e.direction};t.TableDataSource.superclass.handleEvent.call(a,t.TableDataSource.EventType.SORT,s),r(s)})},t.ArrayTableDataSource.prototype.totalSize=function(){return this._checkDataLoaded(),this._totalSize},t.ArrayTableDataSource.prototype._addToRowSet=function(e,a,r){var i=(r=r||{}).silent,s={data:[],keys:[],indexes:[]};e instanceof Array||(e=[e]),null==a||a instanceof Array||(a=[a]);for(var n=0;n<e.length;n++){var o=e[n];if(null!=o){var l=this._getId(o);if(s.data.push(this._wrapWritableValue(o)),s.keys.push(l),!0===this._sorted&&this._rows.data.length>0)for(var u=0;u<this._rows.data.length;u++){if(t.ArrayTableDataSource._sortFunc(o,this._rows.data[u],this._getComparator(),this)<0){this._rows.data.splice(u,0,o),s.indexes.push(u);break}if(u===this._rows.data.length-1){this._rows.data.push(o),s.indexes.push(u+1);break}}else null==a?(this._rows.data.push(o),s.indexes.push(this._rows.data.length-1)):(this._rows.data.splice(a[n],0,o),s.indexes.push(a[n]));this._totalSize+=1,this._realignRowIndices()}}return!i&&s.data.length>0&&t.TableDataSource.superclass.handleEvent.call(this,t.TableDataSource.EventType.ADD,s),Promise.resolve(s)},t.ArrayTableDataSource.prototype._checkDataLoaded=function(){if(!this._isDataLoaded()){var t=[];this.data instanceof Array?t=this.data:this._isObservableArray(this.data)&&(t=this.data.peek(),this._subscribeObservableArray(this.data)),this._rows=this._getRowArray(t),this._totalSize=t.length}},t.ArrayTableDataSource.prototype._isDataLoaded=function(){return null!=this._rows&&null!=this._rows.data},t.ArrayTableDataSource.prototype._fetchInternal=function(e){var a,r,i,s;e=e||{},this._startFetch(e),this._checkDataLoaded();try{a=e.pageSize>0?e.pageSize:-1,this._startIndex||(this._startIndex=0),this._startIndex=null==e.startIndex?this._startIndex:e.startIndex,s=t.ArrayTableDataSource._getEndIndex(this._rows,this._startIndex,a),r=[],i=[];for(var n=this._startIndex;n<=s;n++){var o=this._getId(this._rows.data[n]),l=this._wrapWritableValue(this._rows.data[n]);r[n-this._startIndex]=l,i[n-this._startIndex]=o}}catch(t){return this._endFetch(e,null,t),Promise.reject(t)}s<this._startIndex&&(this._startIndex=s+1),e.pageSize=a,e.startIndex=this._startIndex,e.refresh=!0;var u={data:r,keys:i,startIndex:this._startIndex};return this._endFetch(e,u,null),Promise.resolve(u)},t.ArrayTableDataSource.prototype._getInternal=function(t,e){for(var r=null,i=0;i<this._rows.data.length;i++){var s=this._rows.data[i];if(void 0!==s){var n=this._getId(s);if(a.isArray(n)&&a.isArray(t)){if(n.length===t.length){for(var o=!0,l=0;l<t.length;l++)if(n[l]!==t[l]){o=!1;break}if(o){r=e?{data:this._wrapWritableValue(s),key:n,index:this._rows.indexes[i]}:{data:s,key:n,index:this._rows.indexes[i]};break}}}else if(n===t){r=e?{data:this._wrapWritableValue(s),key:n,index:this._rows.indexes[i]}:{data:s,key:n,index:this._rows.indexes[i]};break}}}return r},t.ArrayTableDataSource.prototype._getComparator=function(){var t=this.comparator;if(null==t){var e=this.sortCriteria.key,r=this.sortCriteria.direction;"ascending"===r?t=function(t){return a.isFunction(t[e])?t[e]():t[e]}:"descending"===r&&(t=function(t,r){var i,s;return a.isFunction(t[e])?(i=t[e](),s=r[e]()):(i=t[e],s=r[e]),i===s?0:i>s?-1:1})}return t},t.ArrayTableDataSource.prototype._realignRowIndices=function(){for(var t=0;t<this._rows.data.length;t++)this._rows.indexes[t]=t},t.ArrayTableDataSource.prototype._removeInternal=function(e,a){var r,i=(a=a||{}).silent,s={data:[],keys:[],indexes:[]};e instanceof Array||(e=[e]);var n=[];for(r=0;r<e.length;r++){var o=e[r];if(null!=o){var l=this._getId(o),u=this._getInternal(l,!1);null!=u&&n.push({data:u.data,key:u.key,index:u.index})}}for(n.sort(function(t,e){return t.index-e.index}),r=0;r<n.length;r++)s.data.push(n[r].data),s.keys.push(n[r].key),s.indexes.push(n[r].index);for(r=s.indexes.length-1;r>=0;r--)this._rows.data.splice(s.indexes[r],1),this._rows.indexes.splice(s.indexes[r],1),this._totalSize-=1;return this._realignRowIndices(),!i&&s.data.length>0&&t.TableDataSource.superclass.handleEvent.call(this,t.TableDataSource.EventType.REMOVE,s),Promise.resolve(s)},t.ArrayTableDataSource.prototype._setRow=function(t,e){this._rows[t]=e,e.index=t},t.ArrayTableDataSource.prototype._startFetch=function(e){e.silent||t.TableDataSource.superclass.handleEvent.call(this,t.TableDataSource.EventType.REQUEST,{startIndex:e.startIndex})},t.ArrayTableDataSource.prototype._endFetch=function(e,a,r){null!=r?t.TableDataSource.superclass.handleEvent.call(this,t.TableDataSource.EventType.ERROR,r):e.silent||t.TableDataSource.superclass.handleEvent.call(this,t.TableDataSource.EventType.SYNC,a)},t.ArrayTableDataSource.prototype._handleRowChange=function(e){e.startIndex=this._startIndex,t.TableDataSource.superclass.handleEvent.call(this,t.TableDataSource.EventType.CHANGE,e)},t.ArrayTableDataSource._compareKeys=function(t,e,a){if("descending"===a){if(t<e)return 1;if(e<t)return-1}else{if(t>e)return 1;if(e>t)return-1}return 0},t.ArrayTableDataSource._getEndIndex=function(t,e,a){var r=t.data.length-1;return a>0&&(r=(r=e+a-1)>t.data.length-1?t.data.length-1:r),r},t.ArrayTableDataSource._getKey=function(t,e){return"function"==typeof t[e]?t[e]():t[e]},t.ArrayTableDataSource.prototype._getRowArray=function(t){var e=t.length-1,a={data:[],indexes:[]};this._attributes=null;for(var r=0;r<=e;r++){for(var i={},s=t[r],n=Object.keys(s),o=0;o<n.length;o++){var l=n[o];i[l]=s[l],0===r&&(null==this._attributes&&(this._attributes=[]),this._attributes.push(l))}a.data[r]=i,a.indexes[r]=r}return a},t.ArrayTableDataSource.prototype._getId=function(r){var i,s,n=this._getIdAttr(r);if(a.isArray(n)){var o;for(i=[],o=0;o<n.length;o++){if(!(n[o]in r))throw s=e.applyParameters(t.ArrayTableDataSource._LOGGER_MSG._ERR_ARRAY_TABLE_DATASOURCE_IDATTR_NOT_IN_ROW,[n[o]]),new Error(s);i[o]=t.ArrayTableDataSource._getKey(r,n[o])}}else{if(!(n in r))throw s=e.applyParameters(t.ArrayTableDataSource._LOGGER_MSG._ERR_ARRAY_TABLE_DATASOURCE_IDATTR_NOT_IN_ROW,[n]),new Error(s);i=t.ArrayTableDataSource._getKey(r,n)}return i},t.ArrayTableDataSource.prototype._getIdAttr=function(t){if(null!=this._idAttribute)return this._idAttribute;if(null==this._attributes){this._attributes=[];for(var e=Object.keys(t),a=0;a<e.length;a++){var r=e[a];this._attributes.push(r)}}return Object.prototype.hasOwnProperty.call(this._attributes,"id")?"id":this._attributes},t.ArrayTableDataSource._sortFunc=function(e,r,i,s){var n,o,l,u,c=s.sortCriteria.direction;if(a.isFunction(i)){if(1===i.length){n=i.call(s,e),o=i.call(s,r);var h=t.StringUtils.isString(n)?n.split(","):[n],d=t.StringUtils.isString(o)?o.split(","):[o];for(l=0;l<h.length;l++)if(0!==(u=t.ArrayTableDataSource._compareKeys(h[l],d[l],c)))return u;return 0}return i.call(s,e,r)}if(t.StringUtils.isString(i)){var _=i.split(",");for(l=0;l<_.length;l++)if(n=t.ArrayTableDataSource._getKey(e,_[l]),o=t.ArrayTableDataSource._getKey(r,_[l]),0!==(u=t.ArrayTableDataSource._compareKeys(n,o,c)))return u}return 0},t.ArrayTableDataSource.prototype._subscribeObservableArray=function(e){if(!(e instanceof Array)){var a=this;this._arrayChangeSubscription=e.subscribe(function(e){var r,i,s,n,o=[],l=[];for(r=0;r<e.length;r++)for(s=e[r].index,n=e[r].status,i=0;i<e.length;i++)i!==r&&s===e[i].index&&n!==e[i].status&&o.indexOf(r)<0&&l.indexOf(r)<0&&("deleted"===n?(l.push(r),o.push(i)):(l.push(i),o.push(r)));var u=[];for(r=0;r<e.length;r++)if(o.indexOf(r)>=0){var c=a._getId(a._rows.data[e[r].index]),h=a._getId(e[r].value);null==h||t.Object.compareValues(h,c)||(a._rows.data[e[r].index]=e[r].value),u.push(e[r].value)}a.change(u,null),u=[];var d=[];for(r=0;r<e.length;r++)o.indexOf(r)<0&&l.indexOf(r)<0&&"deleted"===e[r].status&&u.push(e[r].value);for(a.remove(u,null),u=[],d=[],r=0;r<e.length;r++)o.indexOf(r)<0&&l.indexOf(r)<0&&"added"===e[r].status&&(u.push(e[r].value),d.push(e[r].index));a.add(u,{at:d})},null,"arrayChange")}},t.ArrayTableDataSource.prototype._wrapWritableValue=function(e){for(var a={},r=Object.keys(e),i=0;i<r.length;i++)t.ArrayTableDataSource._defineProperty(a,e,r[i]);return a},t.ArrayTableDataSource.prototype._isObservableArray=function(t){return"function"==typeof t&&"function"==typeof t.subscribe},t.ArrayTableDataSource._defineProperty=function(t,e,a){Object.defineProperty(t,a,{get:function(){return e[a]},set:function(t){e[a]=t},enumerable:!0})},t.ArrayTableDataSource._LOGGER_MSG={_INFO_ARRAY_TABLE_DATASOURCE_IDATTR:"idAttribute option has not been specified. Will default to using 'id' if the field exists. If not, will use all the fields.",_ERR_ARRAY_TABLE_DATASOURCE_IDATTR_NOT_IN_ROW:"Specified idAttribute {0} not in row data. Please ensure all specified idAttribute fields are in the row data or do not specify idAttribute and all fields will be used as id."}});