/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(["ojs/ojcore","jquery","ojs/ojcontext","ojs/ojcomponentcore","ojs/ojlogger","promise","touchr"],function(e,t,i,s,r){"use strict";var n={properties:{arrowPlacement:{type:"string",enumValues:["adjacent","overlay"],value:"adjacent"},arrowVisibility:{type:"string",enumValues:["auto","hidden","hover","visible"],value:"auto"},currentItem:{type:"object",writeback:!0,value:{index:0},properties:{id:{type:"string"},index:{type:"number"}}},looping:{type:"string",enumValues:["off","page"],value:"off"},maxItemsPerPage:{type:"number",value:0},orientation:{type:"string",enumValues:["horizontal","vertical"],value:"horizontal"},translations:{type:"object",value:{},properties:{labelAccArrowNextPage:{type:"string"},labelAccArrowPreviousPage:{type:"string"},labelAccFilmStrip:{type:"string"},tipArrowNextPage:{type:"string"},tipArrowPreviousPage:{type:"string"}}}},methods:{refresh:{},getItemsPerPage:{},getPagingModel:{},setProperty:{},getProperty:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};e.FilmStripPagingModel=function(){this.Init()},e.Object.createSubclass(e.FilmStripPagingModel,e.EventSource,"oj.FilmStripPagingModel"),e.FilmStripPagingModel.prototype.Init=function(){e.FilmStripPagingModel.superclass.Init.call(this),this._page=-1,this._totalSize=0,this._pageSize=-1},e.FilmStripPagingModel.prototype.setTotalSize=function(e){this._totalSize=e},e.FilmStripPagingModel.prototype.getPageSize=function(){return this._pageSize},e.FilmStripPagingModel.prototype.getPage=function(){return this._page},e.FilmStripPagingModel.prototype.setPage=function(e,t){e=parseInt(e,10);try{var i=this.getPageCount(),s=this._page,r=this._pageSize,n=r;if(t&&t.pageSize&&(n=t.pageSize),0===this._totalSize&&-1===n)return Promise.resolve();var a=Math.ceil(this._totalSize/n);if(e<0||e>a-1)throw new Error("JET FilmStrip: Invalid 'page' set: "+e);var o=!1;if(e!==s||n!==r){if(!1===this.handleEvent("beforePage",{page:e,previousPage:s}))return Promise.reject();o=!0}this._page=e,this._pageSize=n;var l=this.getPageCount(),h=this;return new Promise(function(r){if(i!==l&&h.handleEvent("pageCount",{pageCount:l,previousPageCount:i}),o){var n={page:e,previousPage:s};t&&t.loopDirection&&(n.loopDirection=t.loopDirection),h.handleEvent("page",n)}r(null)})}catch(e){return Promise.reject(e)}},e.FilmStripPagingModel.prototype.getStartItemIndex=function(){return-1===this._page&&-1===this._pageSize?-1:this._page*this._pageSize},e.FilmStripPagingModel.prototype.getEndItemIndex=function(){return Math.min(this.getStartItemIndex()+this._pageSize,this._totalSize)-1},e.FilmStripPagingModel.prototype.getPageCount=function(){return Math.ceil(this._totalSize/this._pageSize)},e.FilmStripPagingModel.prototype.totalSize=function(){return this._totalSize},e.FilmStripPagingModel.prototype.totalSizeConfidence=function(){return"actual"},function(){var n="",a="-ms-transform",o="transform",l="-webkit-transform";function h(e,t){e.css(l,t).css(a,t).css(o,t)}function p(e){e.css(l,n).css(a,n).css(o,n)}function u(e){var i=t("<div></div>");return i.text(e),i[0].innerHTML}e.__registerWidget("oj.ojFilmStrip",t.oj.baseComponent,{defaultElement:"<div>",widgetEventPrefix:"oj",options:{maxItemsPerPage:0,orientation:"horizontal",currentItem:{index:0},arrowPlacement:"adjacent",arrowVisibility:"auto",looping:"off"},_ComponentCreate:function(){this._super();var e=this.element;e.addClass("oj-filmstrip oj-component").attr("tabindex",0).attr("role","region"),e.uniqueId();var t=this.options;if(t.disabled&&r.warn("JET FilmStrip: 'disabled' property not supported"),"horizontal"!==t.orientation&&"vertical"!==t.orientation)throw new Error("JET FilmStrip: Unsupported value set as 'orientation' property: "+t.orientation);if("adjacent"!==t.arrowPlacement&&"overlay"!==t.arrowPlacement)throw new Error("Unsupported value set as 'arrowPlacement' property: "+t.arrowPlacement);if("visible"!==t.arrowVisibility&&"hidden"!==t.arrowVisibility&&"hover"!==t.arrowVisibility&&"auto"!==t.arrowVisibility)throw new Error("Unsupported value set as 'arrowVisibility' property: "+t.arrowVisibility);if("off"!==t.looping&&"page"!==t.looping)throw new Error("Unsupported value set as 'looping' property: "+t.looping);this.touchEventNamespace=this.eventNamespace+"Touch",this.mouseEventNamespace=this.eventNamespace+"Mouse",this.keyEventNamespace=this.eventNamespace+"Key",this.navArrowHoverableEventNamespace=this.eventNamespace+"NavArrowHoverable",t.currentItem=this._convertItemToObj(t.currentItem),this._setup(!0),this._populateItemObj(t.currentItem),this.option("currentItem",t.currentItem,{_context:{internalSet:!0,writeback:!0}})},refresh:function(){this._super(),this._setup(!1)},getItemsPerPage:function(){return this._itemsPerPage},getPagingModel:function(){return this._pagingModel},_NotifyShown:function(){this._super(),this._needsSetup?this._setup(this._needsSetup[0]):this._handleResize()},_NotifyAttached:function(){this._super(),this._needsSetup?this._setup(this._needsSetup[0]):this._handleResize()},_setup:function(i){var r=this;if(i&&!this._pagingModel&&(this._pagingModel=new e.FilmStripPagingModel),i&&!this._filterNestedFilmStripsFunc&&(this._filterNestedFilmStripsFunc=function(e,i){return t(i).closest(".oj-filmstrip")[0]===r.element[0]}),!this._canCalculateSizes()){var n=!1;return this._needsSetup&&(n=this._needsSetup[0]),void(this._needsSetup=[i||n])}this._needsSetup=null,this._bRTL="rtl"===this._GetReadingDirection(),this._bTouchSupported=e.DomUtils.isTouchSupported();var a=this.element;i?(this._itemsPerPage=0,this._handlePageFunc=function(e){r._handlePage(e)},this._componentSize=0,this._itemSize=-1,this._handleTransitionEndFunc=function(e){r._handleTransitionEnd()},this._handleResizeFunc=function(e,t){r._handleResize()},this._bTouchSupported&&(this._handleTouchStartFunc=function(e){r._handleTouchStart(e)},this._handleTouchMoveFunc=function(e){r._handleTouchMove(e)},this._handleTouchEndFunc=function(e){r._handleTouchEnd(e)},this._addTouchListeners()),this._handleMouseDownFunc=function(e){r._handleMouseDown(e)},this._handleMouseMoveFunc=function(e){r._handleMouseMove(e)},this._handleMouseUpFunc=function(e){r._handleMouseUp(e)},this._addMouseListeners(),this._handleKeyDownFunc=function(e){r._handleKeyDown(e)},this._addKeyListeners()):this._destroyInternal();var o,l=a.children();for(o=0;o<l.length;o++)s.subtreeDetached(l[o]);var h=this._pagingModel;if(i&&h.on("page",this._handlePageFunc),h.setTotalSize(l.length),this._wrapChildren(),l.length>0){for(this._adjustSizes(),o=0;o<l.length;o++)s.subtreeAttached(l[o]);e.DomUtils.addResizeListener(a[0],this._handleResizeFunc,25)}},_destroy:function(){this._bTouchSupported&&(this._removeTouchListeners(),this._handleTouchStartFunc=null,this._handleTouchMoveFunc=null,this._handleTouchEndFunc=null),this._removeMouseListeners(),this._handleMouseDownFunc=null,this._handleMouseMoveFunc=null,this._handleMouseUpFunc=null,this._removeKeyListeners(),this._handleKeyDownFunc=null,this._destroyInternal(),this._pagingModel.off("page",this._handlePageFunc),this._handlePageFunc=null,this._pagingModel=null,this._handleResizeFunc=null,this._handleTransitionEndFunc=null,this._filterNestedFilmStripsFunc=null;var e=this.element;e.removeClass("oj-filmstrip oj-component oj-filmstrip-hover").removeAttr("tabindex role").removeAttr("aria-labelledby"),e.removeUniqueId(),this._super()},_destroyInternal:function(){this._deferredHandleResize=!1,this._resolveBusyState();var t=this.element;e.DomUtils.removeResizeListener(t[0],this._handleResizeFunc),this._itemSize=-1,this._queuedHandleResize&&(clearTimeout(this._queuedHandleResize),this._queuedHandleResize=null);var i,r=this._getItems();for(i=0;i<r.length;i++)s.subtreeDetached(r[i]);for(this._clearCalculatedSizes(),this._getItemContainers().unwrap(),this._unwrapChildren(),i=0;i<r.length;i++)s.subtreeAttached(r[i])},_setOption:function(e,t,i){var s=this.options,n=!1,a=-1,o=this._pagingModel,l=o.getPage();switch(e){case"disabled":r.warn("JET FilmStrip: 'disabled' property not supported");break;case"orientation":if("horizontal"!==t&&"vertical"!==t)throw new Error("JET FilmStrip: Unsupported value set as 'orientation' property: "+t);n=s.orientation!==t;break;case"maxItemsPerPage":n=s.maxItemsPerPage!==t;break;case"arrowPlacement":if("adjacent"!==t&&"overlay"!==t)throw new Error("Unsupported value set as 'arrowPlacement' property: "+t);n=s.arrowPlacement!==t;break;case"arrowVisibility":if("visible"!==t&&"hidden"!==t&&"hover"!==t&&"auto"!==t)throw new Error("Unsupported value set as 'arrowVisibility' property: "+t);n=s.arrowVisibility!==t;break;case"looping":if("off"!==t&&"page"!==t)throw new Error("Unsupported value set as 'looping' property: "+t);n=s.looping!==t;break;case"currentItem":t=this._convertItemToObj(t),this._populateItemObj(t);var h=s.currentItem;if(h&&t&&(h.id!==t.id||h.index!==t.index)&&((a=this._findPage(t))<0||a>=o.getPageCount()))throw new Error("JET FilmStrip: Value of 'currentItem' property not found: "+t)}switch(this._super(e,t,i),e){case"currentItem":a>-1&&a!==l&&o.setPage(a)}n&&this._setup(!1)},_handleResize:function(){if(this._busyStateResolveFunc)this._deferredHandleResize=!0;else if(this._bHandlingResize){if(!this._queuedHandleResize){var e=this;this._queuedHandleResize=setTimeout(function(){e._queuedHandleResize=null,e._handleResize()},0)}}else this._bHandlingResize=!0,this._adjustSizes(!0),this._bHandlingResize=!1},_isHorizontal:function(){return"vertical"!==this.options.orientation},_isLoopingPage:function(){return"page"===this.options.looping},_getCssPositionAttr:function(){return this._isHorizontal()?this._bRTL?"right":"left":"top"},_getCssSizeAttr:function(){return this._isHorizontal()?"width":"height"},_canCalculateSizes:function(){var e=document.createElement("div"),t=e.style;t.position="absolute",t.width="10px",t.height="10px";var i=this.element[0];i.appendChild(e);var s=!1;try{s=e.offsetWidth>0&&e.offsetHeight>0}catch(e){}return i.removeChild(e),s},_wrapChildren:function(){var e=this.element,t=this._isHorizontal(),i=e.children();i.addClass("oj-filmstrip-item").wrap("<div class='oj-filmstrip-container oj-filmstrip-item-container'></div>");var s=this._getCssPositionAttr(),r=e.children().wrapAll("<div class='oj-filmstrip-container oj-filmstrip-pages-container'></div>").parent().css(s,"0px");this._pagesWrapper=r;var n=this.options;"hidden"!==n.arrowVisibility&&"adjacent"===n.arrowPlacement&&(this._contentWrapper=r.wrap("<div class='oj-filmstrip-container oj-filmstrip-content-container'></div>").parent()),e.addClass("oj-filmstrip-container"),t||e.addClass("oj-filmstrip-vertical");var a=this._createPageInfoElem(),o=e.attr("id"),l=a.attr("id");e.append(a),e.attr("aria-labelledby",o+" "+l),this._pageInfoElem=a,"hidden"!==n.arrowVisibility&&i.length>0&&(this._prevButton=this._createPrevNavArrow(),this._nextButton=this._createNextNavArrow(),this._navArrowsShownOnHover()&&this._setupNavArrowsHoverable())},_unwrapChildren:function(){var e=this.element,t=this._getItems();this._tearDownNavArrowsHoverable(),this._prevButton&&(this._UnregisterChildNode(this._prevButton),this._prevButton=null),this._nextButton&&(this._UnregisterChildNode(this._nextButton),this._nextButton=null);var i=e.children(".oj-filmstrip-arrow-container");i&&i.remove(),this._pageInfoElem&&(this._UnregisterChildNode(this._pageInfoElem),this._pageInfoElem.remove(),this._pageInfoElem=null),t.removeClass("oj-filmstrip-item").unwrap().unwrap(),this._pagesWrapper=null,this._contentWrapper&&(t.unwrap(),this._contentWrapper=null),e.removeClass("oj-filmstrip-container oj-filmstrip-vertical")},_createPageInfoElem:function(){var e=t(document.createElement("div"));return e.uniqueId(),e.addClass("oj-helper-hidden-accessible oj-filmstrip-liveregion"),e.attr({role:"region","aria-live":"polite","aria-atomic":"true"}),e},_updatePageInfoElem:function(){var e=this._pagingModel,t=e.getPage(),i=e.getPageCount(),s=u(this.getTranslatedString("labelAccFilmStrip",{pageIndex:t+1,pageCount:i})),r=this._pageInfoElem;r&&r.attr("aria-label",s)},_setupNavArrowsHoverable:function(){this.element.on("mouseenter"+this.navArrowHoverableEventNamespace,function(e){t(e.currentTarget).hasClass("oj-disabled")||t(e.currentTarget).addClass("oj-filmstrip-hover")}).on("mouseleave"+this.navArrowHoverableEventNamespace,function(e){t(e.currentTarget).removeClass("oj-filmstrip-hover")})},_tearDownNavArrowsHoverable:function(){this.element.off(this.navArrowHoverableEventNamespace)},_navArrowsShownOnHover:function(){var e=this.options,t=e.arrowVisibility;return"hover"===t||"auto"===t&&"overlay"===e.arrowPlacement},_hasPrevPage:function(){return this._pagingModel.getPage()>0},_hasNextPage:function(){var e=this._pagingModel;return e.getPage()<e.getPageCount()-1},_prevPage:function(){var e=this._pagingModel;if(this._hasPrevPage())e.setPage(e.getPage()-1);else{var t=e.getPageCount();this._isLoopingPage()&&t>1&&e.setPage(t-1,{loopDirection:"prev"})}},_nextPage:function(){var e=this._pagingModel;if(this._hasNextPage())e.setPage(e.getPage()+1);else{var t=e.getPageCount();this._isLoopingPage()&&t>1&&e.setPage(0,{loopDirection:"next"})}},_displayNavigationArrow:function(e,t){"adjacent"===this.options.arrowPlacement?t.css("visibility",e?"":"hidden"):t.parent().css("display",e?"":"none")},_updateNavigationArrowsDisplay:function(){if("hidden"!==this.options.arrowVisibility){var e=this._pagingModel,t=e.getPage(),i=e.getPageCount(),s=this._isLoopingPage()&&i>1;this._displayNavigationArrow(s||0!==t,this._prevButton),this._displayNavigationArrow(s||t!==i-1,this._nextButton)}},_createPrevNavArrow:function(){var e=this.element,t=this._isHorizontal()?"oj-start":"oj-top",i=this._createNavigationArrowContainer(t);"overlay"===this.options.arrowPlacement?e.append(i):e.prepend(i);var s=u(this.getTranslatedString("labelAccArrowPreviousPage")),r=u(this.getTranslatedString("tipArrowPreviousPage")),n=this._createNavigationArrow(i,t,s,r),a=this;return n.on("click",function(){a._prevPage()}),n},_createNextNavArrow:function(){var e=this.element,t=this._isHorizontal()?"oj-end":"oj-bottom",i=this._createNavigationArrowContainer(t);e.append(i);var s=u(this.getTranslatedString("labelAccArrowNextPage")),r=u(this.getTranslatedString("tipArrowNextPage")),n=this._createNavigationArrow(i,t,s,r),a=this;return n.on("click",function(){a._nextPage()}),n},_createNavigationArrowContainer:function(e){var i=t(document.createElement("div"));return i.addClass("oj-filmstrip-arrow-container "+e),"overlay"===this.options.arrowPlacement&&(i.addClass("oj-filmstrip-arrow-container-overlay"),this._navArrowsShownOnHover()&&i.addClass("oj-filmstrip-arrow-transition")),i},_createNavigationArrow:function(e,t,i,s){var r="<div class='oj-filmstrip-arrow oj-default oj-enabled "+t+"' role='button' tabindex='-1'";r+="><span class='oj-filmstrip-arrow-icon "+t+" oj-component-icon'></span></div>",e.append(r);var n=e.children(".oj-filmstrip-arrow").eq(0);n.uniqueId();var a=n.attr("id");i&&n.attr("aria-label",i),s&&n.attr("title",s);var o=this._pageInfoElem.attr("id");return n.attr("aria-labelledby",o+" "+a),this._AddHoverable(n),this._AddActiveable(n),"adjacent"===this.options.arrowPlacement&&this._navArrowsShownOnHover()&&n.addClass("oj-filmstrip-arrow-transition"),n},_getItemContainers:function(){return this._pagesWrapper.find(".oj-filmstrip-item-container").filter(this._filterNestedFilmStripsFunc)},_getItems:function(){return this._pagesWrapper.find(".oj-filmstrip-item").filter(this._filterNestedFilmStripsFunc)},_getPages:function(){return this._pagesWrapper.children(".oj-filmstrip-page")},_clearCalculatedSizes:function(){var e=this._pagesWrapper;this._getPages().css("flex-basis",n).css("-webkit-flex-basis",n),this._getItemContainers().css("flex-basis",n).css("-webkit-flex-basis",n),e.css(this._getCssSizeAttr(),n)},_adjustSizes:function(e){this._clearCalculatedSizes();var i=this.options,r=this._isHorizontal(),a=i.maxItemsPerPage,o=a<1,l=this.element,h=this._getItemContainers();if(this._itemSize<0){var p=this._getItemIndex(i.currentItem),u=t(h[p]),d=u.children(".oj-filmstrip-item");d.css("display",n),s.subtreeShown(d[0]),this._itemSize=r?u.width():u.height()}var g=r?l.width():l.height();if("hidden"!==i.arrowVisibility&&"adjacent"===i.arrowPlacement){var c=l.children(".oj-filmstrip-arrow-container").eq(0);g-=2*(r?c.width():c.height())}if(this._componentSize=g,!o){var _=Math.max(Math.floor(g/this._itemSize),1);_<a&&(a=_)}var f=o?Math.max(Math.floor(g/this._itemSize),1):a,m=g/f;h.css("flex-basis",m+"px").css("-webkit-flex-basis",m+"px");var v=Math.ceil(h.length/f),P=this._getPages(),b=!1,w=this._pagingModel;if(w.getPageCount()!==v||this._itemsPerPage!==f||!P||P.length<1){var S;if(b=!0,e)for(S=0;S<h.length;S++)s.subtreeDetached(h[S]);for(P&&P.length>0&&h.unwrap(),S=0;S<h.length;S+=f){h.slice(S,S+f).wrapAll("<div class='oj-filmstrip-container oj-filmstrip-page' aria-hidden='true'></div>").parent().css("display","none")}if(e)for(S=0;S<h.length;S++)s.subtreeAttached(h[S])}(P=this._getPages()).css("flex-basis",g+"px").css("-webkit-flex-basis",g+"px");var y=this._pagesWrapper,j=this._contentWrapper;y.css(this._getCssSizeAttr(),g),j&&j.css(this._getCssSizeAttr(),g);var C=0;if(i.currentItem&&(C=this._findPage(i.currentItem,f)),w.getPageCount()!==v||this._itemsPerPage!==f||w.getPage()!==C)w.setPage(C,{pageSize:f});else if(b){var F=w.getPage();this._handlePage({previousPage:F,page:F})}},_handlePage:function(e){var i=e.page,s=e.loopDirection,r=e.previousPage,n=this._pagesWrapper,a=this._getPages(),o=this._pagingModel,l=o.getPageSize(),h=o.getPageCount(),p=r<0||r===i||this._itemsPerPage!==l,u=this._isLoopingPage();this._itemsPerPage=l;var d=null;p||(d=t(a[r]));var g=this._getCssPositionAttr(),c=t(a[i]),_=c.is(":hidden");_&&this._unhidePage(c);var f,m=this._bDragInit;if(r>-1&&!p){f=i>r,u&&s&&(f="next"===s);var v=u&&!f&&h>1&&0===r,P=u&&f&&h>1&&r===h-1;m=!0,n.css(this._getCssSizeAttr(),2*this._componentSize),f||_&&n.css(g,-this._componentSize+"px"),f?(d.addClass("oj-filmstrip-transition-next-oldpage-from"),c.addClass("oj-filmstrip-transition-next-newpage-from"),P&&c.addClass("oj-filmstrip-transition-display-as-lastpage")):(d.addClass("oj-filmstrip-transition-prev-oldpage-from"),c.addClass("oj-filmstrip-transition-prev-newpage-from"),v&&c.addClass("oj-filmstrip-transition-display-as-firstpage"))}if(this._busyStateResolveFunc=this._addBusyState("scrolling"),m){var b=this,w=this._bDragInit;if(w&&r<0)a.filter(":visible").addClass("oj-filmstrip-transition");setTimeout(function(){b._finishHandlePage(i,r,f,p,w)},25)}else this._finishHandlePage(i,r,f,p)},_finishHandlePage:function(e,i,s,r,n){var a=this._pagesWrapper;if(r||(this._bPageChangeTransition=!0,a.on("transitionend"+this.eventNamespace+" webkitTransitionEnd"+this.eventNamespace,this._handleTransitionEndFunc)),r)this._handleTransitionEnd();else{var o=this._getPages();if(n&&p(o),i>-1){var l=t(o[i]),u=t(o[e]);l.addClass("oj-filmstrip-transition"),u.addClass("oj-filmstrip-transition"),s?(l.removeClass("oj-filmstrip-transition-next-oldpage-from"),u.removeClass("oj-filmstrip-transition-next-newpage-from"),l.addClass("oj-filmstrip-transition-next-oldpage-to"),u.addClass("oj-filmstrip-transition-next-newpage-to")):(l.removeClass("oj-filmstrip-transition-prev-oldpage-from"),u.removeClass("oj-filmstrip-transition-prev-newpage-from"),l.addClass("oj-filmstrip-transition-prev-oldpage-to"),u.addClass("oj-filmstrip-transition-prev-newpage-to"))}else if(n){h(o.filter(":visible"),"translate3d(0, 0, 0)")}}},_handleTransitionEnd:function(){this._bPageChangeTransition=!1;var i=this._pagesWrapper,s=this._getCssPositionAttr();i.off(this.eventNamespace).css(this._getCssSizeAttr(),this._componentSize).css(s,"0px");var r=null;(e.FocusUtils.containsFocus(i[0])||this._nextButton&&e.FocusUtils.containsFocus(this._nextButton[0])||this._prevButton&&e.FocusUtils.containsFocus(this._prevButton[0]))&&(r=document.activeElement);for(var n=this._pagingModel.getPage(),a=this._getPages(),o=0;o<a.length;o++)o!==n&&this._hidePage(t(a[o]));if(a.removeClass("oj-filmstrip-transition oj-filmstrip-transition-next-oldpage-to oj-filmstrip-transition-next-newpage-to oj-filmstrip-transition-prev-oldpage-to oj-filmstrip-transition-prev-newpage-to oj-filmstrip-transition-display-as-firstpage oj-filmstrip-transition-display-as-lastpage"),p(a),this._updateNavigationArrowsDisplay(),r&&t(r).is(":hidden")){var l=this.element,h=e.FocusUtils.getFirstTabStop(a[n]);h?e.FocusUtils.focusElement(h):e.FocusUtils.focusElement(l[0])}var u=this.options;if(this._findPage(u.currentItem)!==n){var d=this._getFirstItemOnPage(n);d&&this.option("currentItem",d,{_context:{writeback:!0}})}this._deferredHandleResize&&(this._deferredHandleResize=!1,this._handleResize()),this._updatePageInfoElem(),this._resolveBusyState()},_getItemIndex:function(t){var i=-1;if(t){var s=this._getItems();if(t.id&&e.DomUtils.isValidIdentifier(t.id))for(var r=0;r<s.length;r++){var n=s[r].id;if(n&&n.length>0&&n===t.id){i=r;break}}else null!=t.index&&t.index>=0&&t.index<s.length&&(i=t.index)}return i},_convertItemToObj:function(e){var t=null;return"object"==typeof e?t=e:"number"==typeof e?t={index:e}:"string"==typeof e&&(t={id:e}),t},_populateItemObj:function(e){if(e&&this._pagingModel.getPage()>=0){var t=this._getItemIndex(e);if(e.index=t,null==e.id&&-1!==t){var i=this._getItems();e.id=i[t].id}}},_findPage:function(e,t){var i=this._getItemIndex(e),s=-1;return i>-1&&(void 0===t&&(t=this._itemsPerPage),s=Math.floor(i/t)),s},_getFirstItemOnPage:function(e,t,i){var s=this._pagingModel;if(void 0===t&&(t=s.getPageCount()),e>=0&&e<t){var r=this._getItems();void 0===i&&(i=this._itemsPerPage);var n=e*i;if(n<r.length)return{id:r[n].id,index:n}}return null},_hidePage:function(e){s.subtreeHidden(e[0]),e.css("display","none").attr("aria-hidden","true"),e.find(".oj-filmstrip-item").filter(this._filterNestedFilmStripsFunc).css("display","none")},_unhidePage:function(e){e.css("display",n).removeAttr("aria-hidden"),e.find(".oj-filmstrip-item").filter(this._filterNestedFilmStripsFunc).css("display",n),s.subtreeShown(e[0])},_addKeyListeners:function(){this.element.on("keydown"+this.keyEventNamespace,this._handleKeyDownFunc)},_removeKeyListeners:function(){this.element.off(this.keyEventNamespace)},_addMouseListeners:function(){this.element.on("mousedown"+this.mouseEventNamespace,this._handleMouseDownFunc).on("mousemove"+this.mouseEventNamespace,this._handleMouseMoveFunc).on("mouseup"+this.mouseEventNamespace,this._handleMouseUpFunc)},_removeMouseListeners:function(){this.element.off(this.mouseEventNamespace)},_addTouchListeners:function(){this.element.on("touchstart"+this.touchEventNamespace,this._handleTouchStartFunc).on("touchmove"+this.touchEventNamespace,this._handleTouchMoveFunc).on("touchend"+this.touchEventNamespace,this._handleTouchEndFunc).on("touchcancel"+this.touchEventNamespace,this._handleTouchEndFunc)},_removeTouchListeners:function(){this.element.off(this.touchEventNamespace)},_handleKeyDown:function(e){var i=this._pagingModel,s=i.getPage(),r=i.getPageCount(),n=-2;switch(e.keyCode){case t.ui.keyCode.RIGHT:n=this._bRTL?s-1:s+1;break;case t.ui.keyCode.LEFT:n=this._bRTL?s+1:s-1;break;case t.ui.keyCode.DOWN:n=s+1;break;case t.ui.keyCode.UP:n=s-1;break;case t.ui.keyCode.HOME:n=0;break;case t.ui.keyCode.END:n=r-1;break;default:return}if(n>-1&&n<r)i.setPage(n);else if(this._isLoopingPage()&&r>1){var a={};n===r&&(n=0,a.loopDirection="next"),-1===n&&(n=r-1,a.loopDirection="prev"),i.setPage(n,a)}e.preventDefault()},_handleMouseDown:function(e){var t=e.originalEvent;this._dragScrollStart(t)},_handleMouseMove:function(e){var t=e.originalEvent;this._dragScrollMove(e,t)},_handleMouseUp:function(e){this._dragScrollEnd()},_handleTouchStart:function(e){var t=e.originalEvent.touches;if(1===t.length){var i=t[0];this._dragScrollStart(i)}},_handleTouchMove:function(e){var t=e.originalEvent.touches[0];this._dragScrollMove(e,t),(this._bTouch||this._scrolledForThisTouch)&&e.preventDefault()},_handleTouchEnd:function(e){this._dragScrollEnd()},_dragScrollStart:function(e){if(this._pagingModel.getPageCount()>1&&!this._bPageChangeTransition){this._bTouch=!0,this._bDragInit=!1,this._bFirstToLast=!1,this._bLastToFirst=!1;var t=this._isHorizontal();this._touchStartCoord=t?e.pageX:e.pageY,this._touchStartCoord2=t?e.pageY:e.pageX}},_initDragScroll:function(e,i,s){var r=this._isHorizontal();this._touchStartCoord=r?e.pageX:e.pageY,this._touchStartCoord2=r?e.pageY:e.pageX;var n=this._getCssPositionAttr(),a=this._pagesWrapper,o=this._pagingModel,l=o.getPage(),h=o.getPageCount(),p=this._getPages(),u=1;i||s?(i&&(this._unhidePage(t(p[h-1])),a.css(n,-this._componentSize+"px"),u+=1,t(p[h-1]).addClass("oj-filmstrip-transition-display-as-firstpage")),s&&(this._unhidePage(t(p[0])),u+=1,t(p[0]).addClass("oj-filmstrip-transition-display-as-lastpage"))):(l>0&&(this._unhidePage(t(p[l-1])),a.css(n,-this._componentSize+"px"),u+=1),l<h-1&&(this._unhidePage(t(p[l+1])),u+=1)),u>1&&a.css(this._getCssSizeAttr(),u*this._componentSize),this._touchStartScroll=parseInt(a.css(n),10)},_dragScrollMove:function(e,i){if(this._bTouch){var s=this._isHorizontal(),r=(s?i.pageX:i.pageY)-this._touchStartCoord,n=(s?i.pageY:i.pageX)-this._touchStartCoord2,a=s&&this._bRTL?r>0:r<0,o=this._pagingModel,l=o.getPage(),p=o.getPageCount(),u=this._isLoopingPage(),d=u&&!a&&p>1&&0===l,g=u&&a&&p>1&&l===p-1;if(!this._bDragInit)return Math.abs(n)>Math.abs(r)&&(this._bTouch=!1,this._scrolledForThisTouch=!1),Math.abs(r)>3&&(this._initDragScroll(i,d,g),this._bDragInit=!0),this._bFirstToLast=d,void(this._bLastToFirst=g);if(d===this._bFirstToLast&&g===this._bLastToFirst||(this._dragScrollResetPages(),this._initDragScroll(i,d,g),this._bFirstToLast=d,this._bLastToFirst=g),a&&l<o.getPageCount()-1||!a&&l>0||u){var c=this.element[0],_=Math.min(.33*(s?c.offsetWidth:c.offsetHeight),100),f=this._getCssPositionAttr(),m=this._pagesWrapper,v=this._getPages();if(Math.abs(r)>=_){var P,b,w={};if(d||g?(d?(P=p-1,b=p>2?1:-1):g&&(P=0,b=p>2?p-2:-1),w.loopDirection=a?"next":"prev"):(P=a?l+1:l-1,b=a?l-1:l+1),b>-1&&b<o.getPageCount()&&this._hidePage(t(v[b])),a&&b>-1&&!g){var S=parseInt(m.css(f),10);m.css(f,S+this._componentSize+"px")}m.css(this._getCssSizeAttr(),2*this._componentSize),this._bTouch=!1,o.setPage(P,w)}else{var y=s?"translate3d("+r+"px, 0, 0)":"translate3d(0, "+r+"px, 0)";h(v.filter(":visible"),y)}this._scrolledForThisTouch=!0}this._scrolledForThisTouch&&(e.preventDefault(),e.stopPropagation())}},_dragScrollEnd:function(){if(this._bTouch&&this._bDragInit){var e=this._pagingModel.getPage();this._handlePage({previousPage:e,page:e})}this._bTouch=!1,this._bDragInit=!1,this._bFirstToLast=!1,this._bLastToFirst=!1,this._scrolledForThisTouch=!1},_dragScrollResetPages:function(){for(var e=this._pagesWrapper,i=this._getCssPositionAttr(),s=this._pagingModel,r=s.getPage(),n=s.getPageCount(),a=this._getPages(),o=0;o<a.length;o++)o!==r&&this._hidePage(t(a[o]));e.css(i,"0px"),t(a[0]).removeClass("oj-filmstrip-transition-display-as-lastpage"),t(a[n-1]).removeClass("oj-filmstrip-transition-display-as-firstpage")},_addBusyState:function(e){var t=this.element,s=i.getContext(t[0]).getBusyContext(),r="FilmStrip";r+=" (id='"+t.attr("id")+"')";var n={description:r+=": "+e};return s.addBusyState(n)},_resolveBusyState:function(){this._busyStateResolveFunc&&(this._busyStateResolveFunc(),this._busyStateResolveFunc=null)},getNodeBySubId:function(e){if(null==e)return this.element?this.element[0]:null;var t=e.subId;return"oj-filmstrip-start-arrow"===t?this.widget().find(".oj-filmstrip-arrow.oj-start").filter(this._filterNestedFilmStripsFunc)[0]:"oj-filmstrip-end-arrow"===t?this.widget().find(".oj-filmstrip-arrow.oj-end").filter(this._filterNestedFilmStripsFunc)[0]:"oj-filmstrip-top-arrow"===t?this.widget().find(".oj-filmstrip-arrow.oj-top").filter(this._filterNestedFilmStripsFunc)[0]:"oj-filmstrip-bottom-arrow"===t?this.widget().find(".oj-filmstrip-arrow.oj-bottom").filter(this._filterNestedFilmStripsFunc)[0]:null},getSubIdByNode:function(e){for(var t=this.getNodeBySubId({subId:"oj-filmstrip-start-arrow"}),i=this.getNodeBySubId({subId:"oj-filmstrip-end-arrow"}),s=this.getNodeBySubId({subId:"oj-filmstrip-top-arrow"}),r=this.getNodeBySubId({subId:"oj-filmstrip-bottom-arrow"}),n=e,a=this.element[0];n&&n!==a;){if(n===t)return{subId:"oj-filmstrip-start-arrow"};if(n===i)return{subId:"oj-filmstrip-end-arrow"};if(n===s)return{subId:"oj-filmstrip-top-arrow"};if(n===r)return{subId:"oj-filmstrip-bottom-arrow"};n=n.parentElement}return null},_CompareOptionValues:function(t,i,s){return"currentItem"===t?e.Object.compareValues(i,s):this._super(t,i,s)}})}(),n.extension._WIDGET_NAME="ojFilmStrip",e.CustomElementBridge.register("oj-film-strip",{metadata:n})});