/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(["ojs/ojcore","jquery","ojs/ojdatasource-common","ojs/ojrowexpander"],function(e,t){"use strict";e.FlattenedTreeCellSet=function(t,r,a,s,n,o){e.Assert.assertArrayOrNull(o),this.m_startRow=t,this.m_endRow=r,this.m_startColumn=a,this.m_endColumn=s,this.m_nodeSet=n,this.m_columns=o},e.FlattenedTreeCellSet.prototype.getData=function(t){var r=this._getRelIndexes(t);if(null==r)return null;var a=r[0],s=r[1];e.Assert.assert(a<this.m_nodeSet.getStart()+this.m_nodeSet.getCount()&&s<this.m_columns.length);var n=this.m_columns[s],o=this.m_nodeSet.getData(a);if(null!=o){var l,u,c={};return l=o.get?function(){return o.get(n)}:function(){return o[n]},u=o.set?function(e){return o.set(n,e)}:function(e){o[n]=e},Object.defineProperty(c,"data",{enumerable:!0,get:l,set:u}),c}return null},e.FlattenedTreeCellSet.prototype.getMetadata=function(t){var r=this._getRelIndexes(t);if(null==r)return null;var a=r[0],s=r[1];e.Assert.assert(a<this.m_nodeSet.getStart()+this.m_nodeSet.getCount()&&s<this.m_columns.length);var n=this.m_columns[s],o=this.m_nodeSet.getMetadata(a),l=o.key;return o.keys={row:l,column:n},o},e.FlattenedTreeCellSet.prototype._getRelIndexes=function(t){if(e.Assert.assertObject(t),null==this.m_nodeSet||0===this.m_nodeSet.length)return null;var r=t.row-this.m_startRow+this.m_nodeSet.getStart(),a=t.column;return e.Assert.assertNumber(r,null),e.Assert.assertNumber(a,null),e.Assert.assert(r>=0&&a>=0),[r,a]},e.FlattenedTreeCellSet.prototype.getStart=function(e){return"row"===e?this.m_startRow:"column"===e?this.m_startColumn:0},e.FlattenedTreeCellSet.prototype.getCount=function(e){return"row"===e?Math.min(this.m_endRow-this.m_startRow,this.m_nodeSet.getCount()):"column"===e?this.m_endColumn-this.m_startColumn:0},e.FlattenedTreeCellSet.prototype.getExtent=function(e){return{row:{extent:1,more:{before:!1,after:!1}},column:{extent:1,more:{before:!1,after:!1}}}},e.FlattenedTreeDataGridDataSource=function(t,r){e.FlattenedTreeDataGridDataSource.superclass.constructor.call(this,t,r)},e.Object.createSubclass(e.FlattenedTreeDataGridDataSource,e.FlattenedTreeDataSource,"oj.FlattenedTreeDataGridDataSource"),e.FlattenedTreeDataGridDataSource.prototype.Init=function(){e.FlattenedTreeDataGridDataSource.superclass.Init.call(this),this.m_columns=e.FlattenedTreeDataGridDataSource.superclass.getOption.call(this,"columns"),this.m_rowHeader=e.FlattenedTreeDataGridDataSource.superclass.getOption.call(this,"rowHeader")},e.FlattenedTreeDataGridDataSource.prototype.getCountPrecision=function(e){return"row"===e?"estimate":"actual"},e.FlattenedTreeDataGridDataSource.prototype.getCount=function(e){return"row"===e?-1:"column"===e?this.m_columns.length:0},e.FlattenedTreeDataGridDataSource.prototype.fetchHeaders=function(t,r,a){var s,n=t.axis;if("column"===n){var o=t.start+t.count;o>this.getCount("column")&&(o=this.getCount("column")-t.start),s=new e.FlattenedTreeHeaderSet(t.start,o,this.m_columns)}else if("row"===n&&null!=this.m_rowHeader)return void(this.m_fetchHeaderRequest={range:t,callbacks:r,callbackObjects:a});null!=r&&null!=r.success&&(null==a&&(a={}),r.success.call(a.success,s,t,null))},e.FlattenedTreeDataGridDataSource.prototype.fetchCells=function(t,r,a){for(var s,n,o=0;o<t.length;o++){var l=t[o];if("row"===l.axis){s=l.start,n=l.count;break}}var u=this.m_fetchSize;this.m_fetchSize=n,e.FlattenedTreeDataGridDataSource.superclass.fetchRows.call(this,{start:s,count:n},{success:function(e){this._handleFetchRowsSuccess(e,t,r,a,0)}.bind(this),error:function(e){this._handleFetchRowsError(e,{start:s,count:n},r,a)}.bind(this)}),this.m_fetchSize=u},e.FlattenedTreeDataGridDataSource.prototype.keys=function(t){var r=t.row,a=t.column;return new Promise(function(t){r>e.FlattenedTreeDataGridDataSource.superclass.getFetchedRange.call(this).end||a>this.m_columns.length?t(null):t({row:e.FlattenedTreeDataGridDataSource.superclass.getKey.call(this,r),column:this.m_columns[a]})}.bind(this))},e.FlattenedTreeDataGridDataSource.prototype.indexes=function(t){var r=t.row,a=t.column;return new Promise(function(t){for(var s,n=e.FlattenedTreeDataGridDataSource.superclass.getIndex.call(this,r),o=0;o<this.m_columns.length;o++)if(this.m_columns[o]===a){s=o;break}t(n>=0||s>=0?{row:n,column:s}:null)}.bind(this))},e.FlattenedTreeDataGridDataSource.prototype.sort=function(t,r,a){return e.FlattenedTreeDataGridDataSource.superclass.getWrappedDataSource.call(this).sort(t,{success:function(){this._handleSortSuccess(r,a)}.bind(this),error:r.error})},e.FlattenedTreeDataGridDataSource.prototype._handleSortSuccess=function(e,t){this.refresh(),e.success&&(null==t&&(t={}),e.success.call(t.success))},e.FlattenedTreeDataGridDataSource.prototype.move=function(t,r,a,s){e.FlattenedTreeDataGridDataSource.superclass.getWrappedDataSource.call(this).move(t,r,a,s)},e.FlattenedTreeDataGridDataSource.prototype.getCapability=function(t){return"default"===e.FlattenedTreeDataGridDataSource.superclass.getWrappedDataSource.call(this).getCapability(t)?"column":"none"},e.FlattenedTreeDataGridDataSource.prototype.insertMetadata=function(t,r){e.FlattenedTreeDataGridDataSource.superclass.insertMetadata.call(this,t,r)},e.FlattenedTreeDataGridDataSource.prototype._handleFetchRowsSuccess=function(t,r,a,s){for(var n,o,l,u,c=0;c<r.length;c++){var i=r[c];"row"===i.axis?(n=i.start,o=i.count):"column"===i.axis&&(l=i.start)+(u=i.count)>this.getCount("column")&&(u=this.getCount("column")-l)}if(this.m_fetchHeaderRequest){var d=this.m_fetchHeaderRequest.range;d.start===n&&d.count===o&&(this._handleRowHeaderFetchSuccess(t,d,this.m_fetchHeaderRequest.callbacks,this.m_fetchHeaderRequest.callbackObjects),this.m_fetchHeaderRequest=null)}var h=new e.FlattenedTreeCellSet(n,n+o,l,l+u,t,this.m_columns);a.success&&(null==s&&(s={}),a.success.call(s.success,h,r))},e.FlattenedTreeDataGridDataSource.prototype._handleFetchRowsError=function(e,t,r,a){if(this.m_fetchHeaderRequest){var s=this.m_fetchHeaderRequest.range;if(s.start===t.start&&s.count===t.count){var n=this.m_fetchHeaderRequest.callbacks,o=this.m_fetchHeaderRequest.callbackObjects;n.error&&(null==o&&(o={}),n.error.call(o.error,e))}this.m_fetchHeaderRequest=null}r.error&&(null==a&&(a={}),r.success.call(a.error,e))},e.FlattenedTreeDataGridDataSource.prototype._handleRowHeaderFetchSuccess=function(t,r,a,s){var n=new e.FlattenedTreeHeaderSet(r.start,r.start+r.count,this.m_columns,t,this.m_rowHeader);a.success&&(null==s&&(s={}),a.success.call(s.success,n,r,null))},e.FlattenedTreeDataGridDataSource.prototype.insertRows=function(t,r,a){var s=null;this.m_rowHeader&&(s=new e.FlattenedTreeHeaderSet(t,t+a.getCount(),this.m_columns,a,this.m_rowHeader));for(var n=new e.FlattenedTreeCellSet(t,t+a.getCount(),0,this.m_columns.length,a,this.m_columns),o=[],l=[],u=0;u<a.getCount();u++)o.push({row:this._getEntry(t+u).key}),l.push({row:t+u,column:-1});var c={};c.source=this,c.operation="insert",c.result=n,s&&(c.header=s),c.keys=o,c.indexes=l,e.FlattenedTreeDataGridDataSource.superclass.handleEvent.call(this,"change",c)},e.FlattenedTreeDataGridDataSource.prototype.removeRows=function(t){for(var r=[],a=[],s=0;s<t.length;s++)r.push({row:t[s].key}),a.push({row:t[s].index,column:-1});var n={};n.source=this,n.operation="delete",n.keys=r,n.indexes=a,e.FlattenedTreeDataGridDataSource.superclass.handleEvent.call(this,"change",n)},e.FlattenedTreeDataGridDataSource.prototype.handleMaxCountReached=function(t,r){var a=new e.EmptyNodeSet(null,t.start);r.success.call(null,a)},e.FlattenedTreeHeaderSet=function(t,r,a,s,n){e.Assert.assertArrayOrNull(a),this.m_start=t,this.m_end=r,this.m_headers=a,this.m_nodeSet=s,this.m_rowHeader=n},e.FlattenedTreeHeaderSet.prototype.getData=function(t,r){var a;return e.Assert.assert(t<=this.m_end&&t>=this.m_start,"index out of bounds"),e.Assert.assert(null==r||0===r,"level out of bounds"),null!=this.m_rowHeader&&null!=this.m_nodeSet?null!=(a=this.m_nodeSet.getData(t-this.m_start+this.m_nodeSet.getStart()))?a.get?a.get(this.m_rowHeader):a[this.m_rowHeader]:null:this.m_headers[t]},e.FlattenedTreeHeaderSet.prototype.getMetadata=function(t,r){return e.Assert.assert(t<=this.m_end&&t>=this.m_start,"index out of bounds"),e.Assert.assert(null==r||0===r,"level out of bounds"),null!=this.m_rowHeader&&null!=this.m_nodeSet?this.m_nodeSet.getMetadata(t-this.m_start+this.m_nodeSet.getStart()):{key:this.getData(t)}},e.FlattenedTreeHeaderSet.prototype.getCount=function(){return null!=this.m_rowHeader&&null!=this.m_nodeSet?Math.min(this.m_nodeSet.getCount(),this.m_end-this.m_start):Math.max(0,this.m_end-this.m_start)},e.FlattenedTreeHeaderSet.prototype.getLevelCount=function(){return this.getCount()>0?1:0},e.FlattenedTreeHeaderSet.prototype.getExtent=function(t,r){return e.Assert.assert(t<=this.m_end&&t>=this.m_start,"index out of bounds"),e.Assert.assert(null==r||0===r,"level out of bounds"),{extent:1,more:{before:!1,after:!1}}},e.FlattenedTreeHeaderSet.prototype.getDepth=function(t,r){return e.Assert.assert(t<=this.m_end&&t>=this.m_start,"index out of bounds"),e.Assert.assert(null==r||0===r,"level out of bounds"),1},e.FlattenedTreeHeaderSet.prototype.getLabel=function(){return null};var r={};return r.FlattenedTreeDataGridDataSource=e.FlattenedTreeDataGridDataSource,r.FlattenedTreeHeaderSet=e.FlattenedTreeHeaderSet,r.FlattenedTreeCellSet=e.FlattenedTreeCellSet,r});