/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(["ojs/ojcore","jquery","ojs/ojlogger","ojdnd","ojs/ojlistview"],function(t,e,i){"use strict";t.ListViewDndContext=function(t){this.listview=t},t.Object.createSubclass(t.ListViewDndContext,t.Object,"oj.ListViewDndContext"),t.ListViewDndContext.C_KEY=67,t.ListViewDndContext.V_KEY=86,t.ListViewDndContext.X_KEY=88,t.ListViewDndContext.CUT_COMMAND="cut",t.ListViewDndContext.COPY_COMMAND="copy",t.ListViewDndContext.PASTE_COMMAND="paste",t.ListViewDndContext.PASTE_BEFORE_COMMAND="pasteBefore",t.ListViewDndContext.PASTE_AFTER_COMMAND="pasteAfter",t.ListViewDndContext.prototype.reset=function(){this._unsetSelectionDraggable(),this.m_itemsDragged=null,this.m_dragImage=null,this.m_currentDragItem=null,this.m_dragItems=null,this.m_contextMenuItem=null},t.ListViewDndContext.prototype._getDndOptions=function(t){var e=this.listview.GetOption("dnd");return null!=e&&e[t]?e[t].items:null},t.ListViewDndContext.prototype._getDragOptions=function(){return this._getDndOptions("drag")},t.ListViewDndContext.prototype._getDropOptions=function(){return this._getDndOptions("drop")},t.ListViewDndContext.prototype.IsItemReOrdering=function(){return"enabled"===this._getDndOptions("reorder")},t.ListViewDndContext.prototype.GetDragAffordanceClass=function(){return"oj-listview-drag-handle"},t.ListViewDndContext.prototype.GetDragImageClass=function(){return"oj-listview-drag-image"},t.ListViewDndContext.prototype.GetDragItemClass=function(){return"oj-listview-drag-item"},t.ListViewDndContext.prototype.GetCutStyleClass=function(){return"oj-listview-cut"},t.ListViewDndContext.prototype.GetCommandPrefix=function(){return"oj-listview-"},t.ListViewDndContext.prototype._findItem=function(t){return this.listview.FindItem(t)},t.ListViewDndContext.prototype._getSelectedItems=function(t){var i=[];if(this.listview._isSelectionEnabled())for(var n=this.listview.GetOption("selection"),s=0;s<n.length;s++){var r=this.listview.FindElementByKey(n[s]);null==r||this.listview.SkipFocus(e(r))||i.push(r)}else{var o=this._getActiveItem();null!=o&&i.push(o)}return!t&&null!=this.m_contextMenuItem&&this.m_contextMenuItem.length>0&&(this.listview.element.get(0).contains(this.m_contextMenuItem.get(0))?-1===i.indexOf(this.m_contextMenuItem.get(0))&&(i=[this.m_contextMenuItem.get(0)]):this.m_contextMenuItem=null),i},t.ListViewDndContext.prototype._getActiveItem=function(){return null==this.listview.m_active?null:this.listview.m_active.elem[0]},t.ListViewDndContext.prototype.itemRenderComplete=function(t,i){e(t).hasClass(this.listview.getItemStyleClass())||(t=t.firstElementChild);var n=e(t).find("."+this.GetDragAffordanceClass());if(null!=n&&n.length>0){var s=n.attr("aria-labelledby");null==s?n.attr("aria-labelledby",this.listview._createSubId("instr")):n.attr("aria-labelledby",s+" "+this.listview._createSubId("instr")),this.listview._isTouchSupport()&&n.attr("draggable","true")}},t.ListViewDndContext.prototype._unsetSelectionDraggable=function(){this.m_draggableSelection&&e.each(this.m_draggableSelection,function(t,i){e(i).removeClass("oj-draggable")})},t.ListViewDndContext.prototype.setSelectionDraggable=function(){var t=[];this._unsetSelectionDraggable();for(var i=this.listview.GetOption("selection"),n=0;n<i.length;n++){var s=this.listview.FindElementByKey(i[n]);null==s||this.listview.SkipFocus(e(s))||(t.push(s),e(s).addClass("oj-draggable"))}this.m_draggableSelection=t},t.ListViewDndContext.prototype._setItemDraggable=function(t){var e=this.GetDragAffordanceClass(),i=t.find("."+e);return null!=i&&i.length>0||(t.addClass("oj-draggable"),!1)},t.ListViewDndContext.prototype._unsetItemDraggable=function(t){t.removeClass("oj-draggable")},t.ListViewDndContext.prototype._setDraggable=function(t){if(null!=this._getDragOptions()||this.IsItemReOrdering()){var i,n=this.GetDragAffordanceClass();if(t.hasClass(n))i=e(t);else{var s=this._findItem(t);if(this.shouldDragCurrentItem())i=s;else{if(null!=s)if(this._setItemDraggable(s))return;var r=this._getSelectedItems(!0);r.length>0&&(null!=s&&r.indexOf(s[0])>-1?i=s:e(r[0]).removeClass("oj-draggable"))}}null!=i&&i.attr("draggable",!0)}},t.ListViewDndContext.prototype._unsetDraggable=function(t){if(null!=this._getDragOptions()||this.IsItemReOrdering()){var i,n=this.GetDragAffordanceClass();null!=(i=t.hasClass(n)?e(t):this._findItem(t))&&(i.removeAttr("draggable"),this._unsetItemDraggable(i))}},t.ListViewDndContext.prototype.isDndInProgress=function(){return null!=this.m_dragImage},t.ListViewDndContext.prototype._invokeDndCallback=function(t,e,n,s){var r,o="drag"===t?this._getDragOptions():this._getDropOptions();if(o){var a=o[e];if(a&&"function"==typeof a)try{this.listview.ojContext._IsCustomElement()?(a(n.originalEvent,s),n.originalEvent.defaultPrevented&&n.preventDefault()):(n.dataTransfer=n.originalEvent.dataTransfer,r=a(n,s))}catch(t){i.error("Error: "+t)}else r=-1}else r=-1;return r},t.ListViewDndContext.prototype._setDragItemDataTransfer=function(t,e,i){for(var n=[],s=0;s<i.length;s++){var r=this.listview._getDataForItem(i[s]);r&&(r.innerHTML&&r.tagName&&"LI"===r.tagName?n.push(r.innerHTML):n.push(r))}return n.length>0?(this._setDragItemData(t.originalEvent,e,n),this.SetDragItemImage(t.originalEvent,i),{items:n}):null},t.ListViewDndContext.prototype._setDragItemData=function(t,e,i){var n=t.dataTransfer,s=JSON.stringify(i);if("string"==typeof e)n.setData(e,s);else if(e)for(var r=0;r<e.length;r++)n.setData(e[r],s);n.setData(this.GetDragSourceType(),this.listview.element.get(0).id)},t.ListViewDndContext.prototype.SetDragItemImage=function(t,i){var n,s,r,o=0,a=0,l=t.target;if(i.length>1){var d;(n=e(document.createElement("ul"))).get(0).className=this.listview.element.get(0).className,n.addClass(this.GetDragImageClass()).css({width:this.listview.element.css("width"),height:this.listview.element.css("height")});var h=Number.MAX_VALUE;for(d=0;d<i.length;d++)h=Math.min(h,i[d].offsetTop);for(d=0;d<i.length;d++){s=i[d].offsetTop-h;var m=i[d].offsetWidth;(r=e(i[d].cloneNode(!0))).removeClass("oj-selected oj-focus oj-hover").css({position:"absolute",top:s,width:m}),n.append(r)}}else e(l).hasClass(this.GetDragAffordanceClass())?(s=0,e.contains(i[0],l.offsetParent)&&(s=l.offsetTop),o=Math.max(0,l.offsetLeft-i[0].offsetLeft)+l.offsetWidth/2,a=s+l.offsetHeight/2):(o=Math.max(0,t.offsetX),a=Math.max(0,t.offsetY)),(r=e(i[0].cloneNode(!0))).removeClass("oj-selected oj-focus oj-hover").addClass("oj-drag"),(n=e(document.createElement("ul"))).get(0).className=this.listview.element.get(0).className,n.addClass(this.GetDragImageClass()).css({width:this.GetDragImageWidth(i[0]),height:2*i[0].offsetHeight}).append(r);this.listview.isCardLayout()&&n.addClass("oj-listview-card-layout"),e("body").append(n),this.m_dragImage=n,t.dataTransfer.setDragImage(n.get(0),o,a)},t.ListViewDndContext.prototype.GetDragImageWidth=function(){return this.listview.element.css("width")},t.ListViewDndContext.prototype.GetDefaultDataType=function(){return"text/ojlistview-items-data"},t.ListViewDndContext.prototype._handleDragStart=function(t){var i,n,s=this._getDragOptions();if((null!=s||this.IsItemReOrdering())&&(i=null!=s?s.dataTypes:this.GetDefaultDataType(),e(t.target).hasClass(this.GetDragAffordanceClass())||this.shouldDragCurrentItem()?(n=[]).push(this._findItem(t.target)[0]):n=this._getSelectedItems(!0),n.length>0)){this.m_dragItems=n,this.m_currentDragItem=e(n[0]);var r=this._setDragItemDataTransfer(t,i,n);if(r){var o=this._invokeDndCallback("drag","dragStart",t,r);if(-1===o)return;return o}return!1}},t.ListViewDndContext.prototype._handleDrag=function(t){return this._invokeDndCallback("drag","drag",t)},t.ListViewDndContext.prototype._destroyDragImage=function(){null!=this.m_dragImage&&(this.m_dragImage.remove(),this.m_dragImage=null)},t.ListViewDndContext.prototype._handleDragEnd=function(t){if(null!=this.m_currentDragItem&&null!=this.m_dragItems){this.m_currentDragItem.find("."+this.GetDragAffordanceClass()).removeAttr("draggable"),this.m_currentDragItem.removeClass("oj-drag oj-draggable").removeAttr("draggable");for(var i=0;i<this.m_dragItems.length;i++)e(this.m_dragItems[i]).removeClass(this.GetDragItemClass()).css("display","")}this._cleanupDropTarget(),this._destroyDragImage(),this._unsetSelectionDraggable(),this._invokeDndCallback("drag","dragEnd",t),this.m_itemsDragged=this.m_dragItems,this.m_dragImage=null,this.m_currentDragItem=null,this.m_dragItems=null,this.listview._doBlur()},t.ListViewDndContext.prototype._matchDragDataType=function(t){var e=this._getDropOptions();if(e&&e.dataTypes)for(var i=e.dataTypes,n="string"==typeof i?[i]:i,s=t.originalEvent.dataTransfer.types,r=0;r<s.length;r++)if(n.indexOf(s[r])>=0)return!0;return!1},t.ListViewDndContext.prototype._invokeDropCallback=function(t,e,i){var n=this._invokeDndCallback("drop",t,e,i);return void 0!==n&&-1!==n||this._matchDragDataType(e)&&e.preventDefault(),n},t.ListViewDndContext.prototype._createDropTarget=function(t){if(null==this.m_dropTarget){var i=e(t.get(0).cloneNode(!1));i.addClass("oj-drop").removeClass("oj-drag oj-draggable oj-hover oj-focus oj-selected").css({display:"block",height:t.outerHeight(),width:t.outerWidth()}),this.m_dropTarget=i}return this.m_dropTarget},t.ListViewDndContext.prototype._cleanupGroupItem=function(){null!=this.m_currentDropItem&&-1===this.m_dropTargetIndex&&this.m_currentDropItem.children("."+this.listview.getGroupItemStyleClass()).removeClass("oj-drop")},t.ListViewDndContext.prototype._cleanupEmptyList=function(){null!=this.m_currentDropItem&&this.m_currentDropItem.hasClass(this.listview.getEmptyTextStyleClass())&&(this.m_currentDropItem.removeClass("oj-drop"),this.m_currentDropItem.get(0).textContent=this.listview._getEmptyText())},t.ListViewDndContext.prototype._cleanupDropTarget=function(){null!=this.m_dropTarget&&(this.m_dropTarget.css("height","0"),this.m_dropTarget.remove(),this.m_dropTarget=null),this._cleanupEmptyList(),this._cleanupGroupItem()},t.ListViewDndContext.prototype._handleDragEnter=function(t){var e=this._findItem(t.target);if(null!=e&&e.length>0){var i=this._invokeDropCallback("dragEnter",t,{item:e.get(0)});if(-1!==i)return i}},t.ListViewDndContext.prototype._setCurrentDropItem=function(t){null!=this.m_currentDropItem&&this.m_currentDropItem.removeClass("oj-valid-drop oj-invalid-drop"),this.m_currentDropItem=t,this.m_currentDropItem.addClass("oj-valid-drop")},t.ListViewDndContext.prototype._setAccInfo=function(t,e){var i=t.attr("aria-label");null==i&&(i=t.text());var n="accessibleReorder"+e.charAt(0).toUpperCase()+e.substr(1)+"Item",s=this.listview.ojContext.getTranslatedString(n,{item:i});this.listview._setAccInfoText(s)},t.ListViewDndContext.prototype._adjustGroupItemStyle=function(){null==this.m_maxHeightAdjusted&&this.listview._isTouchSupport()&&(this.listview.element.find("ul."+this.listview.getGroupStyleClass()).each(function(){e(this).attr("oldMaxHeight",e(this).css("maxHeight").toString()),e(this).css("maxHeight",1e4)}),this.m_maxHeightAdjusted="adjusted")},t.ListViewDndContext.prototype._restoreGroupItemStyle=function(){this.listview._isTouchSupport()&&this.listview.element.find("ul."+this.listview.getGroupStyleClass()).each(function(){e(this).css("maxHeight",parseInt(e(this).attr("oldMaxHeight"),10)),e(this).removeAttr("oldMaxHeight")}),this.m_maxHeightAdjusted=null},t.ListViewDndContext.prototype._handleDragOver=function(t){var i,n,s;if(this._adjustGroupItemStyle(),null!=this.m_dragItems&&"none"!==e(this.m_dragItems[0]).css("display")){if(i=e(this.m_dragItems[0]),-1===(s=this._invokeDropCallback("dragOver",t,{item:i.get(0)}))&&this.IsItemReOrdering()&&this.isDndInProgress()||!1===s||t.isDefaultPrevented()){n=this._createDropTarget(i);for(var r=0;r<this.m_dragItems.length;r++)e(this.m_dragItems[r]).addClass(this.GetDragItemClass()).css("display","none");n.insertBefore(i),this.m_dropTargetIndex=n.index()}}else if(null!=(i=this._findItem(t.target))&&i.length>0)if(-1===(s=this._invokeDropCallback("dragOver",t,{item:i.get(0)}))&&this.IsItemReOrdering()&&this.isDndInProgress()||!1===s||t.isDefaultPrevented()){if(i.hasClass(this.listview.getItemStyleClass())){if(this._cleanupGroupItem(),!i.hasClass("oj-drop")){n=this._createDropTarget(i);var o=i.index();null==this.m_dropTargetIndex||this.m_dropTargetIndex<o?(n.insertAfter(i),this.m_dropPosition="after"):(n.insertBefore(i),this.m_dropPosition="before"),this._setAccInfo(i,this.m_dropPosition),this._setCurrentDropItem(i),this.m_dropTargetIndex=n.index()}}else this._cleanupDropTarget(),i.children("."+this.listview.getGroupItemStyleClass()).addClass("oj-drop"),this._setCurrentDropItem(i),this.m_dropTargetIndex=-1,this.m_dropPosition="inside",this._setAccInfo(i,this.m_dropPosition);t.preventDefault()}else e(t.target).hasClass(this.listview.getGroupStyleClass())||(i.addClass("oj-invalid-drop"),this._cleanupDropTarget());else{var a=this.listview.element.children("."+this.listview.getEmptyTextStyleClass());null!=a&&a.length>0&&(a.addClass("oj-drop"),a.get(0).textContent="",this._setCurrentDropItem(a),t.preventDefault())}return s},t.ListViewDndContext.prototype._isDndEventInElement=function(t,e){var i=e.getBoundingClientRect(),n=t.originalEvent;return n.clientX>=i.left&&n.clientX<i.right&&n.clientY>=i.top&&n.clientY<i.bottom},t.ListViewDndContext.prototype._handleDragLeave=function(t){var e;if(null!=this.m_currentDropItem){var i=this._findItem(t.target);return null!=i&&i.length>0?(i.removeClass("oj-valid-drop oj-invalid-drop"),e=this._invokeDropCallback("dragLeave",t,{item:i.get(0)}),!this._isDndEventInElement(t,t.currentTarget)&&i.hasClass("oj-drop")&&(this._cleanupDropTarget(),this._restoreGroupItemStyle())):this._isDndEventInElement(t,t.currentTarget)||this._cleanupEmptyList(),-1!==e?e:void 0}},t.ListViewDndContext.prototype._handleDrop=function(t){if(null!=this.m_currentDropItem){var e,i=t.originalEvent.dataTransfer.getData(this.GetDragSourceType());e=this.m_currentDropItem.hasClass(this.listview.getEmptyTextStyleClass())?{}:{item:this.m_currentDropItem.get(0),position:this.m_dropPosition},this.IsItemReOrdering()&&i===this.listview.element.get(0).id?e.reorder=!0:e.reorder=!1,null!=this.m_currentDropItem&&this.m_currentDropItem.removeClass("oj-valid-drop"),this._cleanupDropTarget(),this._restoreGroupItemStyle(),this._destroyDragImage();var n=this._invokeDropCallback("drop",t,e);if(e.reorder&&(e.items=null==this.m_dragItems?this.m_itemsDragged:this.m_dragItems,this.listview.Trigger("reorder",t,this.CreateReorderPayload(e.items,e.position,e.item)),t.preventDefault()),this.m_currentDropItem=null,this.m_dropTargetIndex=-1,this.m_dropPosition=null,this.m_itemsDragged=null,-1!==n)return n}},t.ListViewDndContext.prototype.CreateReorderPayload=function(t,e,i){return{items:t,position:e,reference:i}},t.ListViewDndContext.prototype.prepareContextMenu=function(t){var i=this;if(this.IsItemReOrdering()){var n=e(t);this.m_contextMenu!==t&&(this.m_contextMenu=t,"OJ-MENU"===t.tagName?(t.addEventListener("ojBeforeOpen",this._handleContextMenuBeforeOpen.bind(this)),t.addEventListener("ojAction",this._handleContextMenuSelect.bind(this))):(n.on("ojbeforeopen",this._handleContextMenuBeforeOpen.bind(this)),n.on("ojselect",this._handleContextMenuSelect.bind(this))));var s=this._getCommands(t,function(t,n){var s=i._buildContextMenuItem(n,t.tagName);"OJ-OPTION"===t.tagName?(t.innerHTML=s.get(0).innerHTML,e(t).attr("data-oj-command",s.attr("data-oj-command"))):(s.get(0).className=e(t).get(0).className,e(t).replaceWith(s))});this.m_menuItemsSet=s,s.length>0&&n.data("oj-ojMenu")&&("OJ-MENU"===t.tagName?t.refresh():e(t).ojMenu("refresh"))}},t.ListViewDndContext.prototype._getDndContextMenuItemSelector=function(){var t=this,e="",i=["cut","copy","paste","paste-before","paste-after","pasteBefore","pasteAfter"];return this.m_dndMenuItemSelector||(i.forEach(function(n,s){e+="[data-oj-command="+t.GetCommandPrefix()+n+"],",e+="[data-oj-command="+n+"]",s<i.length-1&&(e+=",")}),this.m_dndMenuItemSelector=e),this.m_dndMenuItemSelector},t.ListViewDndContext.prototype._getCommands=function(i,n){var s=this,r=[];return e(i).find(this._getDndContextMenuItemSelector()).each(function(){var i;0===e(this).children("a").length?0===e(this).attr("data-oj-command").indexOf(s.GetCommandPrefix())&&(i=e(this).attr("data-oj-command").substring(s.GetCommandPrefix().length),n&&n(this,i)):(i=e(this).attr("data-oj-command"))===t.ListViewDndContext.PASTE_BEFORE_COMMAND?i="paste-before":i===t.ListViewDndContext.PASTE_AFTER_COMMAND&&(i="paste-after"),i&&r.push(i)}),r},t.ListViewDndContext.prototype._buildContextMenuItem=function(e,i){return"paste-before"===e?this._buildContextMenuListItem(t.ListViewDndContext.PASTE_BEFORE_COMMAND,i):"paste-after"===e?this._buildContextMenuListItem(t.ListViewDndContext.PASTE_AFTER_COMMAND,i):this._buildContextMenuListItem(e,i)},t.ListViewDndContext.prototype._buildContextMenuListItem=function(t,i){var n=e(document.createElement(i));return n.attr("data-oj-command",t),n.append(this._buildContextMenuLabel(t,"OJ-OPTION"===i)),n},t.ListViewDndContext.prototype._buildContextMenuLabel=function(t,i){var n="label"+t.charAt(0).toUpperCase()+t.slice(1),s=document.createTextNode(this.listview.ojContext.getTranslatedString(n));return i?s:e('<a href="#"></a>').append(s)},t.ListViewDndContext.prototype._handleCut=function(t){null!=this.m_clipboard&&e(this.m_clipboard).removeClass(this.GetCutStyleClass());var i=this.GetCutItems(t);this.listview.ojContext.element.focus(),e(i).addClass(this.GetCutStyleClass()),this.m_clipboard=i,this.listview.Trigger("cut",t,{items:i})},t.ListViewDndContext.prototype.GetCutItems=function(t){return this._getSelectedItems()},t.ListViewDndContext.prototype._handleCopy=function(t){null!=this.m_clipboard&&e(this.m_clipboard).removeClass(this.GetCutStyleClass());var i=this._getSelectedItems();this.m_clipboard=i,this.listview.Trigger("copy",t,{items:i})},t.ListViewDndContext.prototype._handlePaste=function(t,i,n){this.listview.Trigger("paste",t,{item:i.get(0)}),e(this.m_clipboard).removeClass(this.GetCutStyleClass()),this.listview.Trigger("reorder",t,this.CreateReorderPayload(this.m_clipboard,n,i.get(0))),this.m_clipboard=null},t.ListViewDndContext.prototype._handleContextMenuSelect=function(i,n){if(null!=this.m_contextMenuItem)switch((n?n.item:e(i.target)).attr("data-oj-command")){case t.ListViewDndContext.CUT_COMMAND:this._handleCut(i);break;case t.ListViewDndContext.COPY_COMMAND:this._handleCopy(i);break;case t.ListViewDndContext.PASTE_COMMAND:this._handlePaste(i,this.m_contextMenuItem,"inside"),this.m_contextMenuItem=null;break;case t.ListViewDndContext.PASTE_BEFORE_COMMAND:this._handlePaste(i,this.m_contextMenuItem,"before"),this.m_contextMenuItem=null;break;case t.ListViewDndContext.PASTE_AFTER_COMMAND:this._handlePaste(i,this.m_contextMenuItem,"after"),this.m_contextMenuItem=null}},t.ListViewDndContext.prototype._appendToMenuContainer=function(e,i){null!=this.m_menuItemsSet&&("paste-before"===i?i=t.ListViewDndContext.PASTE_BEFORE_COMMAND:"paste-after"===i&&(i=t.ListViewDndContext.PASTE_AFTER_COMMAND),e.find("[data-oj-command='"+i+"']").removeClass("oj-disabled"))},t.ListViewDndContext.prototype._handleContextMenuBeforeOpen=function(t,i){var n=e(t.target);n.find(this._getDndContextMenuItemSelector()).addClass("oj-disabled");var s=i?i.openOptions.launcher:t.detail.openOptions.launcher;null!=s&&null!=this.m_menuItemsSet&&0!==this.m_menuItemsSet.length?(s.children().first().hasClass(this.listview.getGroupItemStyleClass())?null!=this.m_clipboard&&this._appendToMenuContainer(n,"paste"):(this._appendToMenuContainer(n,"cut"),this._appendToMenuContainer(n,"copy"),null!=this.m_clipboard&&(this._appendToMenuContainer(n,"paste-before"),this._appendToMenuContainer(n,"paste-after"))),"OJ-MENU"!==n.get(0).tagName&&n.ojMenu("refresh"),this.m_contextMenuItem=s):"OJ-MENU"!==n.get(0).tagName&&n.ojMenu("refresh")},t.ListViewDndContext.prototype.HandleKeyDown=function(i){if(i.ctrlKey||i.metaKey){var n=i.keyCode;if(n===t.ListViewDndContext.X_KEY||n===t.ListViewDndContext.C_KEY||t.ListViewDndContext.V_KEY){if(!this.IsItemReOrdering())return!1;var s=this.listview.ojContext._GetContextMenu();if(null==s)return!1;var r=this._getCommands(s);if(0===r.length)return!1;if(n===t.ListViewDndContext.X_KEY&&r.indexOf("cut")>-1)return this._handleCut(i),!0;if(n===t.ListViewDndContext.C_KEY&&r.indexOf("copy")>-1)return this._handleCopy(i),!0;if(n===t.ListViewDndContext.V_KEY&&null!=this.m_clipboard){var o,a=e(this._getActiveItem());if(a.children().first().hasClass(this.listview.getGroupItemStyleClass())?r.indexOf("paste")>-1&&(o="inside"):r.indexOf("paste-before")>-1?o="before":r.indexOf("paste-after")>-1&&(o="after"),null!=o)return this._handlePaste(i,a,o),!0}}}return!1},t.ListViewDndContext.prototype.shouldDragCurrentItem=function(){return!1},t.ListViewDndContext.prototype.GetDragSourceType=function(){return"text/ojlistview-dragsource-id"}});