/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(["ojs/ojcore","jquery","ojs/ojmessaging","ojs/ojpagingtabledatasource"],function(t,e,a){"use strict";t.PagingCellSet=function(t,e){this.m_cellSet=t,this.m_startIndex=e},t.PagingCellSet.prototype.getData=function(t){var e={column:t.column,row:t.row+this.m_startIndex};return this.m_cellSet.getData(e)},t.PagingCellSet.prototype.getMetadata=function(t){var e={column:t.column,row:t.row+this.m_startIndex};return this.m_cellSet.getMetadata(e)},t.PagingCellSet.prototype.getCount=function(t){return this.m_cellSet.getCount(t)},t.PagingCellSet.prototype.getCellSet=function(){return this.m_cellSet},t.PagingCellSet.prototype.getStartIndex=function(){return this.m_startIndex},t.PagingCellSet.prototype.getExtent=function(t){var e={column:t.column,row:t.row+this.m_startIndex};return this.m_cellSet.getExtent(e)},t.PagingDataGridDataSource=function(e,n){if(!(e instanceof t.DataGridDataSource))throw new a("Not a datagridatasource","Not a datagridatasource",a.SEVERITY_LEVEL.ERROR);this.dataSource=e,this._startIndex=0,this.Init()},t.Object.createSubclass(t.PagingDataGridDataSource,t.DataGridDataSource,"oj.PagingDataGridDataSource"),t.PagingDataGridDataSource.prototype.Init=function(){t.PagingDataGridDataSource.superclass.Init.call(this),this._registerEventListeners()},t.PagingDataGridDataSource.prototype._registerEventListeners=function(){this.dataSource.on("change",this._handleChange.bind(this))},t.PagingDataGridDataSource.prototype.getPage=function(){return this._page},t.PagingDataGridDataSource.prototype.setPage=function(e,a){a=a||{},e=parseInt(e,10);try{t.PagingDataGridDataSource.superclass.handleEvent.call(this,t.PagingModel.EventType.BEFOREPAGE,{page:e,previousPage:this._page})}catch(t){return Promise.reject(t)}this._pageSize=null!=a.pageSize?a.pageSize:this._pageSize,a.startIndex=e*this._pageSize;var n=this._page;this._page=e,this._startIndex=a.startIndex;var r=this;return new Promise(function(t,e){r._fetchInternal(a).then(function(){t(null)},function(t){r._page=n,r._startIndex=r._page*r._pageSize,e(t)})})},t.PagingDataGridDataSource.prototype._fetchInternal=function(t){this._initialized=!0,this._startIndex=t.startIndex;var e=this;return new Promise(function(t){e.handleEvent("change",{operation:"sync",pageSize:e._pageSize}),t(void 0)})},t.PagingDataGridDataSource.prototype.fetch=function(t){return this._pageSize=t.pageSize+t.startIndex,t.startIndex=0,this._fetchInternal(t)},t.PagingDataGridDataSource.prototype.getStartItemIndex=function(){return this._startIndex},t.PagingDataGridDataSource.prototype.getEndItemIndex=function(){return this._endIndex},t.PagingDataGridDataSource.prototype.getPageCount=function(){var t=this.totalSize();return-1===t?-1:Math.ceil(t/this._pageSize)},t.PagingDataGridDataSource.prototype._handleChange=function(e){switch(e.operation){case"refresh":this._startIndex=0,this._page=0,this.handleEvent("change",{operation:"sync",pageSize:this._pageSize}),this.handleEvent(t.PagingTableDataSource.EventType.REFRESH,null);break;case"reset":this.handleEvent(t.PagingTableDataSource.EventType.RESET,null);break;case"insert":this.handleEvent(t.PagingTableDataSource.EventType.ADD,{index:e.indexes.row});break;case"delete":this.handleEvent(t.PagingTableDataSource.EventType.REMOVE,null);break;case"update":e.indexes.row=e.indexes.row-this._startIndex>=0?e.indexes.row-this._startIndex:-1,this.handleEvent("change",e);break;default:this.handleEvent("change",e),this.handleEvent(t.PagingTableDataSource.EventType.SYNC,null)}},t.PagingDataGridDataSource.prototype.getCount=function(t){var e=this.dataSource.getCount(t);return"row"===t&&e>=0?this._startIndex+this._pageSize<e?this._pageSize:e-this._startIndex:e},t.PagingDataGridDataSource.prototype.getCountPrecision=function(t){return this.dataSource.getCountPrecision(t)},t.PagingDataGridDataSource.prototype.fetchHeaders=function(t,e,a){null==this._initialized?null!=e&&e.success&&e.success.call(a.success,null,t,null):"row"===t.axis?(t.start+=this._startIndex,t.start+t.count>this._startIndex+this._pageSize&&(t.count=this._pageSize-t.start),this._pendingRowHeaderCallback={headerRange:t,callbacks:e,callbackObjects:a},this.dataSource.fetchHeaders(t,{success:this._handleRowHeaderFetchSuccess.bind(this),error:this._handleRowHeaderFetchError.bind(this)},a)):this.dataSource.fetchHeaders(t,e,a)},t.PagingDataGridDataSource.prototype._handleRowHeaderFetchSuccess=function(e,a,n){var r,i;if(this._pendingRowHeaderCallback.headerRange===a){a.start-=this._startIndex,a.count+=1,null!=e&&(r=new t.PagingHeaderSet(e,this._startIndex)),null!=n&&(i=new t.PagingHeaderSet(n,this._startIndex));var o=this._pendingRowHeaderCallback.callbacks.success,s=this._pendingRowHeaderCallback.callbackObjects.success;this._pendingRowHeaderCallback=null,o.call(s,r,a,i)}},t.PagingDataGridDataSource.prototype._handleRowHeaderFetchError=function(t){var e=this._pendingRowHeaderCallback.callbacks.error,a=this._pendingRowHeaderCallback.callbackObjects.error;this._pendingRowHeaderCallback=null,e.call(a,t)},t.PagingDataGridDataSource.prototype.fetchCells=function(t,e,a){if(null==this._initialized){var n={getData:function(){return null},getMetaData:function(){return null},getStart:function(){return 0},getCount:function(){return 0},getLevelCount:function(){return 0},getExtent:function(){return 0},getDepth:function(){return 1}};null!=e&&e.success&&e.success.call(a.success,n,t)}else{for(var r=0;r<t.length;r+=1)"row"===t[r].axis&&(t[r].start+=this._startIndex,t[r].start+t[r].count>this._startIndex+this._pageSize&&(t[r].count=this._pageSize-t[r].start));this._pendingCellCallback={cellRanges:t,callbacks:e,callbackObjects:a},this.dataSource.fetchCells(t,{success:this._handleCellsFetchSuccess.bind(this),error:this._handleCellsFetchError.bind(this)},a)}},t.PagingDataGridDataSource.prototype._handleCellsFetchSuccess=function(e,a){if(!this._pendingCellCallback.cellRanges!==a){for(var n=0;n<a.length;n+=1)"row"===a[n].axis&&(a[n].start-=this._startIndex,a[n].count+=1);var r=new t.PagingCellSet(e,this._startIndex),i=this._pendingCellCallback.callbacks.success,o=this._pendingCellCallback.callbackObjects.success;this._pendingCellCallback=null,this._endIndex=this._startIndex+e.getCount("row")-1,this.handleEvent("sync",{data:new Array(e.getCount("row")),startIndex:this._startIndex}),i.call(o,r,a)}},t.PagingDataGridDataSource.prototype._handleCellsFetchError=function(t){var e=this._pendingCellCallback.callbacks.error,a=this._pendingCellCallback.callbackObjects.error;this._pendingCellCallback=null,e.call(a,t)},t.PagingDataGridDataSource.prototype.keys=function(t){var e={column:t.column,row:t.row+this._startIndex};return this.dataSource.keys(e)},t.PagingDataGridDataSource.prototype.indexes=function(t){var e=this.dataSource.indexes(t);return-1!==e.row&&(e.row-=this._startIndex),e},t.PagingDataGridDataSource.prototype.getCapability=function(t){return this.dataSource.getCapability(t)},t.PagingDataGridDataSource.prototype.size=function(){var t;return null==this._initialized?-1:(t=this.dataSource.getCount("row"),this.dataSource.getCount("row")>this._pageSize?this._pageSize:t)},t.PagingDataGridDataSource.prototype.sort=function(t,e,a){this.dataSource.sort(t,e,a)},t.PagingDataGridDataSource.prototype.totalSize=function(){return null==this._initialized?-1:this.dataSource.getCount("row")},t.PagingDataGridDataSource.prototype.totalSizeConfidence=function(){return"actual"},t.PagingDataGridDataSource.prototype.moveOK=function(t,e,a){return this.dataSource.moveOK(t,e,a)},t.PagingDataGridDataSource.prototype.move=function(t,e,a,n,r){this.dataSource.move(t,e,a,n,r)},t.PagingHeaderSet=function(t,e){this.m_headerSet=t,this.m_startIndex=e},t.PagingHeaderSet.prototype.getData=function(t,e){return this.m_headerSet.getData(t+this.m_startIndex,e)},t.PagingHeaderSet.prototype.getMetadata=function(t,e){return this.m_headerSet.getMetadata(t+this.m_startIndex,e)},t.PagingHeaderSet.prototype.getCount=function(){return this.m_headerSet.getCount()},t.PagingHeaderSet.prototype.getLevelCount=function(){return this.m_headerSet.getLevelCount()},t.PagingHeaderSet.prototype.getExtent=function(t,e){return this.m_headerSet.getExtent(t+this.m_startIndex,e)},t.PagingHeaderSet.prototype.getDepth=function(t,e){return this.m_headerSet.getDepth(t+this.m_startIndex,e)},t.PagingHeaderSet.prototype.getHeaderSet=function(){return this.m_headerSet},t.PagingHeaderSet.prototype.getStartIndex=function(){return this.m_startIndex},t.PagingHeaderSet.prototype.getLabel=function(t){return this.m_headerSet.getLabel(t)};var n={};return n.PagingDataGridDataSource=t.PagingDataGridDataSource,n.PagingHeaderSet=t.PagingHeaderSet,n.PagingCellSet=t.PagingCellSet,n});