/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(["ojs/ojcore","jquery","ojs/ojcontext","ojs/ojthemeutils","ojs/ojcomponentcore","ojs/ojanimation","promise","ojs/ojpopupcore"],function(e,t,i,s,o,n){"use strict";var r,a,l={properties:{autoDismiss:{type:"string",enumValues:["focusLoss","none"],value:"focusLoss"},chrome:{type:"string",enumValues:["default","none"],value:"default"},initialFocus:{type:"string",enumValues:["auto","firstFocusable","none","popup"],value:"auto"},modality:{type:"string",enumValues:["modal","modeless"],value:"modeless"},position:{type:"object",properties:{at:{type:"object",properties:{horizontal:{type:"string",enumValues:["center","end","left","right","start"],value:"start"},vertical:{type:"string",enumValues:["bottom","center","top"],value:"bottom"}}},collision:{type:"string",enumValues:["fit","flip","flipcenter","flipfit","none"],value:"flip"},my:{type:"object",properties:{horizontal:{type:"string",enumValues:["center","end","left","right","start"],value:"start"},vertical:{type:"string",enumValues:["bottom","center","top"],value:"top"}}},of:{type:"string|object"},offset:{type:"object",properties:{x:{type:"number",value:0},y:{type:"number",value:0}}}}},tail:{type:"string",enumValues:["none","simple"],value:"none"},translations:{type:"object",value:{},properties:{ariaCloseSkipLink:{type:"string"},ariaFocusSkipLink:{type:"string"},ariaLiveRegionInitialFocusFirstFocusable:{type:"string"},ariaLiveRegionInitialFocusFirstFocusableTouch:{type:"string"},ariaLiveRegionInitialFocusNone:{type:"string"},ariaLiveRegionInitialFocusNoneTouch:{type:"string"}}}},methods:{open:{},close:{},isOpen:{},refresh:{},setProperty:{},getProperty:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojBeforeOpen:{},ojOpen:{},ojBeforeClose:{},ojClose:{},ojFocus:{},ojAnimateStart:{},ojAnimateEnd:{}},extension:{}};r=["oj-left","oj-center","oj-right","oj-top","oj-middle","oj-bottom"],a={"right-top":"oj-right oj-top","right-middle":"oj-right oj-middle","right-bottom":"oj-right oj-bottom","left-top":"oj-left oj-top","left-middle":"oj-left oj-middle","left-bottom":"oj-left oj-bottom","center-top":"oj-center oj-top","center-middle":"oj-left oj-middle","center-bottom":"oj-center oj-bottom"},e.__registerWidget("oj.ojPopup",t.oj.baseComponent,{widgetEventPrefix:"oj",options:{animation:null,autoDismiss:"focusLoss",chrome:"default",initialFocus:"auto",position:{my:{horizontal:"start",vertical:"top"},offset:{x:0,y:0},at:{horizontal:"start",vertical:"bottom"},of:void 0,collision:"flip"},tail:"none",modality:"modeless",role:"tooltip",beforeOpen:null,open:null,beforeClose:null,close:null,focus:null,animateStart:null,animateEnd:null},_ComponentCreate:function(){this._super();var i=this._getRootStyle(),s=this.element;s.hide().addClass(i).attr("aria-hidden","true"),s.addClass("oj-component");var o=t("<div>");o.addClass([i,"content"].join("-")),o.attr("role","presentation"),o.append(s[0].childNodes),o.appendTo(s),this._content=o,this._setChrome(),this._setupFocus(s);var n=this.options;n.position=e.PositionUtils.coerceToJet(n.position)},_AfterCreate:function(){this._super(),this.element.uniqueId(),this._createTail()},_destroy:function(){e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN&&this._closeImplicitly(),this._setWhenReady("none"),this._destroyTail(),delete this._popupServiceEvents;var t=this.element;t.hide().attr("aria-hidden","true").removeUniqueId();var i=this._content;delete this._content,t.append(i[0].childNodes),i.remove();var s=this._closeDelayTimer;s&&(delete this._closeDelayTimer,s()),this._super()},open:function(t,i){if(!this._isOperationPending("open",[t,i])){e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN&&this._closeImplicitly();var s=this.element,o=e.ZOrderUtils.getStatus(s);if(o===e.ZOrderUtils.STATUS.CLOSE||o===e.ZOrderUtils.STATUS.UNKNOWN)if(e.ZOrderUtils.setStatus(s,e.ZOrderUtils.STATUS.BEFORE_OPEN),!1!==this._trigger("beforeOpen")){this._setWhenReady("open"),this._setLauncher(t);var n=this._launcher,r=this.options;(i=i||r.position).of||(this._hasPositionOfLauncherOverride=!0,i.of=n),this._setPosition(i),this._setAutoDismiss(r.autoDismiss),this._addDescribedBy(),this._IsCustomElement()&&s[0].hasAttribute("role")||s.attr("role",r.role);var a=this._getPositionAsJqUi(),l=this._getRootStyle(),u=[l,"layer"].join("-"),c=r.tail;"none"!==c&&(u+=" "+[l,"tail",c].join("-"));var p={};p[e.PopupService.OPTION.POPUP]=s,p[e.PopupService.OPTION.LAUNCHER]=n,p[e.PopupService.OPTION.POSITION]=a,p[e.PopupService.OPTION.EVENTS]=this._getPopupServiceEvents(),p[e.PopupService.OPTION.LAYER_SELECTORS]=u,p[e.PopupService.OPTION.MODALITY]=r.modality,p[e.PopupService.OPTION.CUSTOM_ELEMENT]=this._IsCustomElement(),e.PopupService.getInstance().open(p)}else e.ZOrderUtils.setStatus(this.element,o)}},_beforeOpenHandler:function(t){var i=t[e.PopupService.OPTION.POPUP],s=t[e.PopupService.OPTION.POSITION];i.show(),i.position(s);var o=this.options.animation;if(o&&o.open){var r=o.actionPrefix,a=r?[r,"open"].join("-"):"open";return n.startAnimation(i[0],a,e.PositionUtils.addTransformOriginAnimationEffectsOption(i,o.open),this)}},_afterOpenHandler:function(t){var i=t[e.PopupService.OPTION.POPUP],s=t[e.PopupService.OPTION.LAUNCHER];this._initVoiceOverAssist(),this._trigger("open"),this._intialFocus(),this._on(i,{keydown:this._keyHandler}),s&&s.length>0&&this._on(s,{keydown:this._keyHandler})},_GetContextMenu:function(){if(!this._IsCustomElement())return this._super();var t=e.BaseCustomElementBridge.getSlotMap(this._content[0]).contextMenu;return t&&t.length>0?t[0]:void 0},close:function(){if(!this._isOperationPending("close",[])){var t=this.element,i=e.ZOrderUtils.getStatus(t);if(i===e.ZOrderUtils.STATUS.OPEN)if(e.ZOrderUtils.setStatus(t,e.ZOrderUtils.STATUS.BEFORE_CLOSE),!1!==this._trigger("beforeClose")||this._ignoreBeforeCloseResultant){this._setWhenReady("close");var s=this._launcher;this._off(t,"keydown"),s&&s.length>0&&this._off(s,"keydown"),this._restoreFocus(),this._destroyVoiceOverAssist();var o={};o[e.PopupService.OPTION.POPUP]=t,e.PopupService.getInstance().close(o)}else e.ZOrderUtils.setStatus(t,i)}},_beforeCloseHandler:function(t){var i=t[e.PopupService.OPTION.POPUP],s=this.options.animation;if(!this._ignoreBeforeCloseResultant&&s&&s.close){var o=s.actionPrefix,r=o?[o,"close"].join("-"):"close";return n.startAnimation(i[0],r,e.PositionUtils.addTransformOriginAnimationEffectsOption(i,s.close),this).then(function(){i.hide()})}i.hide()},_afterCloseHandler:function(e){this._removeDescribedBy(),this._setAutoDismiss(),delete this._launcher,this._trigger("close"),this._hasPositionOfLauncherOverride&&(this.options.position.of=null,delete this._hasPositionOfLauncherOverride)},isOpen:function(){var t=e.ZOrderUtils.getStatus(this.element);return t===e.ZOrderUtils.STATUS.OPENING||t===e.ZOrderUtils.STATUS.OPEN||t===e.ZOrderUtils.STATUS.BEFORE_CLOSE||t===e.ZOrderUtils.STATUS.CLOSING},refresh:function(){if(this._super(),e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN&&this._reposition()){var t=this.element;e.PopupService.getInstance().triggerOnDescendents(t,e.PopupService.EVENT.POPUP_REFRESH)}},_setOption:function(t,i){var s=this.options;switch(t){case"tail":i!==s.tail&&this._setTail(i);break;case"chrome":i!==s.chrome&&this._setChrome(i);break;case"position":return this._setPosition(i),void this.refresh();case"autoDismiss":e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN&&i!==s.autoDismiss&&this._setAutoDismiss(i);break;case"modality":if(e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN){var o=this.element,n={};n[e.PopupService.OPTION.POPUP]=o,n[e.PopupService.OPTION.MODALITY]=i,e.PopupService.getInstance().changeOptions(n)}}this._superApply(arguments)},_getRootStyle:function(){return"oj-popup"},_setTail:function(e){this._destroyTail(),this._createTail(e),this._reposition()},_createTail:function(i){var s=i||this.options.tail;if("none"!==s){var o=this._getRootStyle(),n=[o,"tail"].join("-"),r=[n,s].join("-"),a=t("<div>").hide();a.addClass(n).addClass(r),a.attr("role","presentation"),this._tailId=a.attr("id",this._getSubId("tail")).attr("id");var l=this.element;if(a.appendTo(l),l.addClass(r),e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN){var u=[o,"layer"].join("-");u+=" "+r;var c={};c[e.PopupService.OPTION.POPUP]=l,c[e.PopupService.OPTION.LAYER_SELECTORS]=u,e.PopupService.getInstance().changeOptions(c)}}},_getTail:function(){var e=this._tailId;return e?t(document.getElementById(e)):null},_destroyTail:function(){var t=this._getTail();t&&t.remove(),delete this._tailId;var i=this.options.tail,s=this._getRootStyle(),o=[s,"tail",i].join("-"),n=this.element;if(n.removeClass(o),e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN){var r=[s,"layer"].join("-"),a={};a[e.PopupService.OPTION.POPUP]=n,a[e.PopupService.OPTION.LAYER_SELECTORS]=r,e.PopupService.getInstance().changeOptions(a)}},_setChrome:function(e){var t=e||this.options.chrome,i=[this._getRootStyle(),"no-chrome"].join("-"),s=this.element;"default"===t&&s.hasClass(i)?s.removeClass(i):"none"!==t||s.hasClass(i)||s.addClass(i)},_setLauncher:function(i){var s=i;if(s?"string"===t.type(s)?s=t(s):1===s.nodeType&&(s=t(s)):s=t(document.activeElement),s instanceof t&&s.length>1)for(var o=this.element,n=0;n<s.length;n++){var r=s[0];if(!e.DomUtils.isAncestorOrSelf(o[0],r)){s=t(r);break}}else s instanceof t&&!(s instanceof t&&0===s.length)||(s=t(document.activeElement));this._launcher=s},_setPosition:function(t){var i=this.options;t&&(i.position=e.PositionUtils.coerceToJet(t,i.position))},_getPositionAsJqUi:function(){var i=this.options,s=e.PositionUtils.coerceToJqUi(i.position),o="rtl"===this._GetReadingDirection(),n=(s=e.PositionUtils.normalizeHorizontalAlignment(s,o)).using;return n=t.isFunction(n)?n:null,s.using=this._usingHandler.bind(this,n),s},_resolveBusyStateAndCloseImplicitly:function(e){e(),delete this._closeDelayTimer,this._closeImplicitly()},_resolveBusyStateAndCancelDelayedClosure:function(e,t){window.clearTimeout(e),t()},_usingHandler:function(t,s,o){var n=o.element.element;if(s.top!==n.css("top")||s.left!==n.css("left")){var l=this._getTail();if(l){l.hide();for(var u=0;u<r.length;u++)l.removeClass(r[u]),n.removeClass(r[u]);if(l.removeAttr("style"),o.target&&0===o.target.height&&0===o.target.width){var c="rtl"===this._GetReadingDirection(),p=e.PositionUtils.normalizeHorizontalAlignment(this.options.position,c).my;if(!e.StringUtils.isEmptyOrUndefined(p)){var h="center"===p.horizontal?p.horizontal:o.horizontal,d="center"===p.vertical?"middle":p.vertical;o.horizontal=h,o.vertical=d}}var f,_,m=[o.horizontal,o.vertical].join("-"),v=a[m];if(l.addClass(v),n.addClass(v),l.show(),"left"===o.horizontal?(f=l.outerWidth(),f-=f+e.DomUtils.getCSSLengthAsInt(l.css("left")),s.left+=f-2):"right"===o.horizontal&&(f=l.outerWidth(),f-=f+e.DomUtils.getCSSLengthAsInt(l.css("right")),s.left-=f-2),"top"===o.vertical?(_=l.outerHeight(),_-=_+e.DomUtils.getCSSLengthAsInt(l.css(o.vertical)),s.top+=_-2):"bottom"===o.vertical&&(_=l.outerHeight(),_-=_+e.DomUtils.getCSSLengthAsInt(l.css(o.vertical)),s.top-=_-2),n.css(s),"center"===o.horizontal&&"middle"!==o.vertical){var g=n.width(),O=Math.round((g/2-l.outerWidth()/2)/g*100);l.css({left:O+"%"})}else if("middle"===o.vertical){var S=n.height(),P=Math.round((S/2-l.outerHeight()/2)/S*100);l.css({top:P+"%"})}}else n.css(s);if(e.PositionUtils.captureTransformOriginAnimationEffectsOption(n,o),t&&t(s,o),"focusLoss"===this.options.autoDismiss&&e.PositionUtils.isAligningPositionClipped(o)){this._ignoreRestoreFocus=!0;var y=i.getContext(this.element[0]).getBusyContext(),T={description:["ojPopup identified by '",this.element.attr("id"),"' is pending implicit closure."].join("")},U=y.addBusyState(T),E=window.setTimeout(this._resolveBusyStateAndCloseImplicitly.bind(this,U),0);this._closeDelayTimer=this._resolveBusyStateAndCancelDelayedClosure.bind(this,E,U)}}},_reposition:function(){var i=this.element,s=this._getPositionAsJqUi();if(e.StringUtils.isString(s.of)){var o=t(s.of);if(0===o.length)return!1;s.of=o}return i.position(s),!0},_intialFocus:function(e){var t=this._deriveInitialFocus();(e||"none"!==t)&&(this.GetFocusElement().focus(),this._trigger("focus"))},GetFocusElement:function(){var i=document.activeElement;if(i&&this._isFocusInPopup(i))return i;var s,o=this._deriveInitialFocus();if("none"===o&&(o="popup"),"firstFocusable"===o){for(var n=this._content.find(":focusable"),r=0;r<n.length;r++)if(e.FocusUtils.isFocusable(n[r])){s=t(n[r]);break}s||(o="popup")}if("popup"===o){var a=this._closeSkipLink;a?s=a.getLink():(s=this.element).attr("tabindex","-1")}return s[0]},_deriveInitialFocus:function(){var t=this.options,i=t.initialFocus;return"auto"===i&&(i="modal"===t.modality?e.DomUtils.isTouchSupported()?"popup":"firstFocusable":"none"),i},_isFocusInPopup:function(t,i){if(t||(t=document.activeElement),!t)return!1;var s=this.element;return i&&(s=s.parent()),e.DomUtils.isAncestorOrSelf(s[0],t)},_isFocusInLauncher:function(t){t||(t=document.activeElement);var i=this._launcher;return e.DomUtils.isAncestorOrSelf(i[0],t)},_restoreFocus:function(){this._ignoreRestoreFocus?delete this._ignoreRestoreFocus:this._isFocusInPopup(null,!0)&&this._launcher.focus()},_keyHandler:function(e){if(!e.isDefaultPrevented()){var i=this._content,s=e.target;if(e.keyCode===t.ui.keyCode.ESCAPE&&(this._isFocusInPopup(s)||this._isFocusInLauncher(s)))e.preventDefault(),this.close();else if(117===e.keyCode)this._isFocusInPopup(s)?"modeless"===this.options.modality?(e.preventDefault(),this._launcher.focus()):this.close():this._isFocusInLauncher(s)&&(e.preventDefault(),this._intialFocus(!0));else if(e.keyCode===t.ui.keyCode.TAB&&this._isFocusInPopup(s)){var o=i.find(":tabbable");if(o.length>0){var n=o[0],r=o[o.length-1],a=this.element;n!==s&&a[0]!==s||!e.shiftKey?r!==s||e.shiftKey||(e.preventDefault(),r===n?(a.attr("tabindex","-1"),a.focus()):t(n).focus()):(e.preventDefault(),n===r&&n===s?(a.attr("tabindex","-1"),a.focus()):t(r).focus())}else e.preventDefault(),"modeless"===this.options.modality?this._launcher.focus():this.close()}}},_setAutoDismiss:function(t){var i=this._focusLossCallback,s=this._getPopupServiceEvents();if(i&&(delete s[e.PopupService.EVENT.POPUP_AUTODISMISS],delete this._focusLossCallback),"focusLoss"===t&&(i=this._dismissalHandler.bind(this),this._focusLossCallback=i,s[e.PopupService.EVENT.POPUP_AUTODISMISS]=i),e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN){var o=this.element,n={};n[e.PopupService.OPTION.POPUP]=o,n[e.PopupService.OPTION.EVENTS]=s,e.PopupService.getInstance().changeOptions(n)}},_dismissalHandler:function(t){if(e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN){var i=this._launcher,s=this.element.parent(),o=t.target,n=this._focusSkipLink;if(n){var r=n.getLink();if(r&&e.DomUtils.isAncestorOrSelf(r[0],o))return}if(!e.DomUtils.isAncestorOrSelf(i[0],o)&&!e.DomUtils.isAncestorOrSelf(s[0],o)){if(e.FocusUtils.isFocusable(o)){if("mousedown"===t.type||"touchstart"===t.type)return;this._ignoreRestoreFocus=!0}this.close()}}},_addDescribedBy:function(){var e=this._launcher,i=this.element.attr("id"),s=e.attr("aria-describedby"),o=s?s.split(/\s+/):[];o.push(i),s=t.trim(o.join(" ")),e.attr("aria-describedby",s)},_removeDescribedBy:function(){var e=this._launcher,i=this.element;if(e&&0!==e.length){var s=i.attr("id"),o=e.attr("aria-describedby"),n=o?o.split(/\s+/):[],r=t.inArray(s,n);-1!==r&&n.splice(r,1),(o=t.trim(n.join(" ")))?e.attr("aria-describedby",o):e.removeAttr("aria-describedby")}},_initVoiceOverAssist:function(){var t,i=e.AgentUtils.getAgentInfo().os===e.AgentUtils.OS.IOS||e.AgentUtils.getAgentInfo().os===e.AgentUtils.OS.ANDROID,s=this._liveRegion;s||(s=new e.PopupLiveRegion,this._liveRegion=s);var o=this._deriveInitialFocus();if(t=i?this.getTranslatedString("none"===o?"ariaLiveRegionInitialFocusNoneTouch":"ariaLiveRegionInitialFocusFirstFocusableTouch"):this.getTranslatedString("none"===o?"ariaLiveRegionInitialFocusNone":"ariaLiveRegionInitialFocusFirstFocusable"),s.announce(t),i){var n=this._getSubId("focusSkipLink"),r=this._launcher,a=this._intialFocus.bind(this,!0);t=this.getTranslatedString("ariaFocusSkipLink"),this._focusSkipLink=new e.PopupSkipLink(r,t,a,n);var l=this._content,u=this._getSubId("closeSkipLink");a=this._closeImplicitly.bind(this),t=this.getTranslatedString("ariaCloseSkipLink"),this._closeSkipLink=new e.PopupSkipLink(l,t,a,u)}},_destroyVoiceOverAssist:function(){this._liveRegion.destroy(),delete this._liveRegion;var e=this._focusSkipLink;e&&(e.destroy(),delete this._focusSkipLink);var t=this._closeSkipLink;t&&(t.destroy(),delete this._closeSkipLink)},_getSubId:function(t){var i=this.element.attr("id");return e.StringUtils.isEmptyOrUndefined(i)&&(i=this.uuid),[i,t].join("_")},_surrogateRemoveHandler:function(){var t=this.element;e.ZOrderUtils.getStatus(t)===e.ZOrderUtils.STATUS.OPEN&&t.remove()},_getPopupServiceEvents:function(){if(!this._popupServiceEvents){var t={};this._popupServiceEvents=t,t[e.PopupService.EVENT.POPUP_CLOSE]=this._closeImplicitly.bind(this),t[e.PopupService.EVENT.POPUP_REMOVE]=this._surrogateRemoveHandler.bind(this),t[e.PopupService.EVENT.POPUP_REFRESH]=this.refresh.bind(this),t[e.PopupService.EVENT.POPUP_BEFORE_OPEN]=this._beforeOpenHandler.bind(this),t[e.PopupService.EVENT.POPUP_AFTER_OPEN]=this._afterOpenHandler.bind(this),t[e.PopupService.EVENT.POPUP_BEFORE_CLOSE]=this._beforeCloseHandler.bind(this),t[e.PopupService.EVENT.POPUP_AFTER_CLOSE]=this._afterCloseHandler.bind(this)}return this._popupServiceEvents},_closeImplicitly:function(){this._ignoreBeforeCloseResultant=!0,this.close(),delete this._ignoreBeforeCloseResultant},_setWhenReady:function(t){var i=this._whenReadyMediator;i&&(i.destroy(),delete this._whenReadyMediator),["open","close"].indexOf(t)<0||(this._whenReadyMediator=new e.PopupWhenReadyMediator(this.element,t,"ojPopup",this._IsCustomElement()))},_isOperationPending:function(e,t){var i=this._whenReadyMediator;return!!i&&i.isOperationPending(this,e,e,t)},_setupFocus:function(e){var i=this;this._focusable({applyHighlight:!0,setupHandlers:function(s,o){i._on(e,{focus:function(e){s(t(e.currentTarget))},blur:function(e){o(t(e.currentTarget))}})}})},_NotifyDetached:function(){e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN&&this._closeImplicitly(),this._super()}}),o.setDefaultOptions({ojPopup:{modality:o.createDynamicPropertyGetter(function(){return(s.parseJSONFromFontFamily("oj-popup-option-defaults")||{}).modality}),animation:o.createDynamicPropertyGetter(function(){return(s.parseJSONFromFontFamily("oj-popup-option-defaults")||{}).animation})}}),l.extension._WIDGET_NAME="ojPopup",e.CustomElementBridge.register("oj-popup",{metadata:l})});