/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(["ojs/ojcore","jquery","ojs/ojtranslation","ojs/ojmessaging","ojs/ojlocaledata","ojs/ojlogger"],function(t,r,e,a,n,o){"use strict";t.OraI18nUtils={},t.OraI18nUtils.numeringSystems={latn:"0123456789",arab:"٠١٢٣٤٥٦٧٨٩",thai:"๐๑๒๓๔๕๖๗๘๙"},t.OraI18nUtils.regexTrim=/^\s+|\s+$|\u200f|\u200e/g,t.OraI18nUtils.regexTrimNumber=/\s+|\u200f|\u200e/g,t.OraI18nUtils.regexTrimRightZeros=/0+$/g,t.OraI18nUtils.zeros=["0","00","000"],t.OraI18nUtils._ISO_DATE_REGEXP=/^[+-]?\d{4}(?:-\d{2}(?:-\d{2})?)?(?:T\d{2}:\d{2}(?::\d{2}(?:\.\d{1,3})?)?(Z|[+-]\d{2}(?::?\d{2})?)?)?$|^T\d{2}:\d{2}(?::\d{2}(?:\.\d{1,3})?)?(Z|[+-]\d{2}(?::?\d{2})?)?$/,t.OraI18nUtils.getLocalTimeZoneOffset=function(){var r=(new Date).getTimezoneOffset();return t.OraI18nUtils.getTimeStringFromOffset("Etc/GMT",r,!1,!1)},t.OraI18nUtils.dateToLocalIso=function(r){var e=r;"number"==typeof e&&(e=new Date(e));var a=t.OraI18nUtils.padZeros(e.getFullYear(),4)+"-"+t.OraI18nUtils.padZeros(e.getMonth()+1,2)+"-"+t.OraI18nUtils.padZeros(e.getDate(),2)+"T"+t.OraI18nUtils.padZeros(e.getHours(),2)+":"+t.OraI18nUtils.padZeros(e.getMinutes(),2)+":"+t.OraI18nUtils.padZeros(e.getSeconds(),2);return e.getMilliseconds()>0&&(a+="."+t.OraI18nUtils.trimRightZeros(t.OraI18nUtils.padZeros(e.getMilliseconds(),3))),a},t.OraI18nUtils.partsToIsoString=function(r){var e=t.OraI18nUtils.padZeros(r[0],4)+"-"+t.OraI18nUtils.padZeros(r[1],2)+"-"+t.OraI18nUtils.padZeros(r[2],2)+"T"+t.OraI18nUtils.padZeros(r[3],2)+":"+t.OraI18nUtils.padZeros(r[4],2)+":"+t.OraI18nUtils.padZeros(r[5],2);return r[6]>0&&(e+="."+t.OraI18nUtils.trimRightZeros(t.OraI18nUtils.padZeros(r[6],3))),e},t.OraI18nUtils.isoToLocalDate=function(t){return t&&"string"==typeof t?this._isoToLocalDateIgnoreTimezone(t):null},t.OraI18nUtils._isoToLocalDateIgnoreTimezone=function(r){var e=t.OraI18nUtils._IsoStrParts(r);return new Date(e[0],e[1]-1,e[2],e[3],e[4],e[5],e[6])},t.OraI18nUtils._IsoStrParts=function(r){!1===t.OraI18nUtils._ISO_DATE_REGEXP.test(r)&&t.OraI18nUtils._throwInvalidISOStringSyntax(r);var e,a=r.split("T"),n=r.indexOf("T"),o=new Date,i=!1,s=[o.getFullYear(),o.getMonth()+1,o.getDate(),0,0,0,0];if(""!==a[0]){t.OraI18nUtils.startsWith(a[0],"-")&&(a[0]=a[0].substr(1),i=!0);var l=a[0].split("-");for(e=0;e<l.length;e++){var u=parseInt(l[e],10);if(1===e&&(u<1||u>12)&&t.OraI18nUtils._throwInvalidISOStringRange(r,"month",u,1,12),2===e){var d=t.OraI18nUtils._getDaysInMonth(s[0],s[1]-1);(u<1||u>d)&&t.OraI18nUtils._throwInvalidISOStringRange(r,"day",u,1,d)}s[e]=u}i&&(s[0]=-s[0])}if(-1!==n){var c=a[1].split("."),g=c[0].split(":");for(e=0;e<g.length;e++){var p=parseInt(g[e],10);0===e&&(p<0||p>24)&&t.OraI18nUtils._throwInvalidISOStringRange(r,"hour",p,0,24),1===e&&(p<0||p>59)&&t.OraI18nUtils._throwInvalidISOStringRange(r,"minute",p,0,59),2===e&&(p<0||p>59)&&t.OraI18nUtils._throwInvalidISOStringRange(r,"second",p,0,59),s[3+e]=p}2===c.length&&c[1]&&(s[6]=parseInt(t.OraI18nUtils.zeroPad(c[1],3,!1),10))}return s},t.OraI18nUtils.getISOStrFormatInfo=function(r){var e={format:null,dateTime:null,timeZone:"",isoStrParts:null},a=t.OraI18nUtils._ISO_DATE_REGEXP.exec(r);if(null===a&&t.OraI18nUtils._throwInvalidISOStringSyntax(r),void 0===a[1]&&void 0===a[2])return e.format="local",e.dateTime=r,e.isoStrParts=t.OraI18nUtils._IsoStrParts(e.dateTime),e;e.timeZone=void 0!==a[1]?a[1]:a[2],"Z"===e.timeZone?e.format="zulu":e.format="offset";var n=r.length,o=e.timeZone.length;return e.dateTime=r.substring(0,n-o),e.isoStrParts=t.OraI18nUtils._IsoStrParts(e.dateTime),e},t.OraI18nUtils._isLeapYear=function(t){return t%400==0||t%100!=0&&t%4==0},t.OraI18nUtils._getDaysInMonth=function(r,e){switch(e){case 0:case 2:case 4:case 6:case 7:case 9:case 11:return 31;case 1:return t.OraI18nUtils._isLeapYear(r)?29:28;default:return 30}},t.OraI18nUtils._throwInvalidISOStringRange=function(t,r,e,a,n){var o=new RangeError("The string "+t+" is not a valid ISO 8601 string: "+e+" is out of range.  Enter a value between "+a+" and "+n+" for "+r),i={errorCode:"isoStringOutOfRange",parameterMap:{isoString:t,value:e,minValue:a,maxValue:n,propertyName:r}};throw o.errorInfo=i,o},t.OraI18nUtils._throwInvalidISOStringSyntax=function(t){var r=new Error("The string "+t+" is not a valid ISO 8601 string syntax."),e={errorCode:"invalidISOString",parameterMap:{isoStr:t}};throw r.errorInfo=e,r},t.OraI18nUtils.trim=function(r){return(r+"").replace(t.OraI18nUtils.regexTrim,"")},t.OraI18nUtils.trimRightZeros=function(r){return(r+"").replace(t.OraI18nUtils.regexTrimRightZeros,"")},t.OraI18nUtils.trimNumber=function(r){return(r+"").replace(t.OraI18nUtils.regexTrimNumber,"")},t.OraI18nUtils.startsWith=function(t,r){return 0===t.indexOf(r)},t.OraI18nUtils.toUpper=function(t){return t.split(" ").join(" ").toUpperCase()},t.OraI18nUtils.padZeros=function(r,e){var a=r+"",n=!1;return r<0&&(a=a.substr(1),n=!0),e>1&&a.length<e&&(a=(a=t.OraI18nUtils.zeros[e-2]+a).substr(a.length-e,e)),n&&(a="-"+a),a},t.OraI18nUtils.zeroPad=function(t,r,e){for(var a=""+t,n=a.length;n<r;n+=1)a=e?"0"+a:a+"0";return a},t.OraI18nUtils.getTimeStringFromOffset=function(r,e,a,n){var o=a?e>=0:e<0,i=Math.abs(e),s=Math.floor(i/60),l=i%60,u=o?"-":"+";n&&(s=t.OraI18nUtils.zeroPad(s,2,!0));var d=r+u+s;return(l>0||n)&&(d+=":"+t.OraI18nUtils.zeroPad(l,2,!0)),d},t.OraI18nUtils.getNumberingSystemKey=function(r,e){if(void 0===e)return"latn";var a=t.OraI18nUtils.getNumberingExtension(e),n="symbols-numberSystem-"+a;return void 0===r.numbers[n]&&(a="latn"),a},t.OraI18nUtils.getBCP47Lang=function(t){return t.split("-")[0]},t.OraI18nUtils.getBCP47Region=function(t){var r=t.split("-");return 3===r.length?r[2]:2===r.length&&2===r[1].length?r[1]:"001"},t.OraI18nUtils.getNumberingExtension=function(t){var r=t||"en-US",e=r.indexOf("-u-nu-"),a="latn";return-1!==e&&(a=r.substr(e+6,4)),a},t.OraI18nUtils.haveSamePropertiesLength=function(t){return Object.keys(t).length},t.OraI18nUtils.getLocaleElementsMainNode=function(t){var r=t.main;return r[Object.keys(r)[0]]},t.OraI18nUtils.getLocaleElementsMainNodeKey=function(t){var r=t.main;return Object.keys(r)[0]},t.OraI18nUtils._toBoolean=function(t){if("string"==typeof t)switch(t.toLowerCase().trim()){case"true":case"1":return!0;case"false":case"0":return!1;default:return t}return t},t.OraI18nUtils.getGetOption=function(r,e){if(void 0===r)throw new Error("Internal "+e+" error. Default options missing.");return function(a,n,o,i){if(void 0!==r[a]){var s=r[a];switch(n){case"boolean":s=t.OraI18nUtils._toBoolean(s);break;case"string":s=String(s);break;case"number":s=Number(s);break;default:throw new Error("Internal error. Wrong value type.")}if(void 0!==o&&-1===o.indexOf(s)){for(var l=[],u=0;u<o.length;u++)l.push(o[u]);var d="The value '"+r[a]+"' is out of range for '"+e+"' options property '"+a+"'. Valid values: "+l,c=new RangeError(d),g={errorCode:"optionOutOfRange",parameterMap:{propertyName:a,propertyValue:r[a],propertyValueValid:l,caller:e}};throw c.errorInfo=g,c}return s}return i}},t.OraI18nUtils.matchString=function(r,e,a,n){void 0===n&&(n={sensitivity:"base",usage:"sort"});var o=t.OraI18nUtils.getGetOption(n,"oj.OraI18nUtils.matchString");n.usage=o("usage","string",["sort","search"],"sort"),n.sensitivity=o("sensitivity","string",["base","accent","case","variant"],"base");for(var i=r.length,s=e.length-1,l=0;l<i;l++)for(var u=0;u<3;u++){var d=i-l;if(d=Math.min(d,s+u),0===r.substr(l,d).localeCompare(e,a,n))return[l,l+(d-1)]}return null};var i={fullYear:{pos:0,pad:4},month:{pos:1,pad:2},date:{pos:2,pad:2},hours:{pos:3,pad:2},minutes:{pos:4,pad:2},seconds:{pos:5,pad:2},milliseconds:{pos:6,pad:3},timeZone:{pos:7}};t.OraI18nUtils.isoToDate=function(t){return new Date(this._normalizeIsoString(t))},t.OraI18nUtils._copyTimeOver=function(t,r){if(!t||!r)throw new Error("Provided invalid arguments");var e=this._normalizeIsoString(r),a=t.indexOf("T"),n=e.indexOf("T");return e.substring(0,n)+(-1!==a?t.substring(a):"T00:00:00.000")},t.OraI18nUtils._clearTime=function(t){return this._dateTime(t,{hours:0,minutes:0,seconds:0,milliseconds:0})},t.OraI18nUtils._dateTime=function(t,e,a){if(!t||!e)throw new Error("Invalid argument invocation");var n,o,s=null,l=i,u=this.padZeros,d=this._normalizeIsoString(t),c=/(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):?(\d{2})?\.?(\d{3})?(.*)?/.exec(d);if(!c)throw new Error("Unable to capture anything");if(c=c.slice(1),Array.isArray(e)){s={};for(var g=0,p=e.length;g<p;g++){var h=e[g];if(h in l){if(o=c[n=l[h].pos],a&&"timeZone"===h)throw new Error("Dude you tried to ask timezone to be parsed");if(a){var f=parseInt(o,10);s[h]=1===n?f-1:f}else s[h]=o}}}else if(r.isPlainObject(e)){for(var m=Object.keys(e),v=0;v<m.length;v++){var _=m[v],I=l[_];n=I.pos,o=e[_],1===n&&"number"==typeof o&&(o+=1),c[n]=I.pad?u(o,I.pad):o}s=c[0]+"-"+c[1]+"-"+c[2]+"T"+c[3]+":"+c[4]+":"+c[5]+(c.length>6&&c[6]?"."+c[6]+(8===c.length&&c[7]?c[7]:""):"")}return s},t.OraI18nUtils._normalizeIsoString=function(t){if(!t)throw new Error("Provided invalid arguments");var r,e=(new Date).toISOString(),a=e.substring(0,e.indexOf("T")),n=t.indexOf("T"),o=-1===n?t:t.substring(0,n);return(o=o||a)+(-1!==n?(r=t.substring(n)).split(":").length>1?r:r+":00":"T00:00:00.000")},t.OraI18nUtils.formatString=function(t,r){for(var e=r.length,a=t,n=0;n<e;n++){var o="{"+n+"}";a=a.replace(o,r[n])}return a},t.OraI18nUtils.getInitials=function(t,r){var e,a=0,n=0;if(void 0!==t&&t.length>0&&(a=t.charCodeAt(0)),a>=1536&&a<=1791)return"";if(a>=2304&&a<=2431)return t.charAt(0);if(a>=3584&&a<=3711)return t.charAt(0);if(a>=4352&&a<=4607||a>=12592&&a<=12687||a>=43360&&a<=43391||a>=44032&&a<=55295)return t;if(void 0!==r&&r.length>0&&(a=r.charCodeAt(0)),a>=11904&&a<=12255||a>=12288&&a<=12591||a>=12688&&a<=12799||a>=13056&&a<=19903||a>=19968&&a<=40959||a>=63744&&a<=64255)return r;if(a>=55296&&a<=56319){if(r.length<2)return"";if((n=r.charCodeAt(1))<56320||n>57343)return"";if((e=1024*(a-55296)+(n-56320)+65536)>=110592&&e<=110847||e>=127488&&e<=127743||e>=131072&&e<=173791||e>=173824&&e<=177983||e>=177984&&e<=178207||e>=178208&&e<=183983||e>=194560&&e<=195103)return r}return a="",n="",void 0!==t&&t.length>0&&(a=t.charAt(0).toUpperCase()),void 0!==r&&r.length>0&&(n=r.charAt(0).toUpperCase()),a+n},t.Validation={},t.Validation._converterFactories={},t.Validation._validatorFactories={},t.Validation._defaultConverterFactories={},t.Validation._defaultValidatorFactories={},t.Validation._CONTRACTS={converter:{name:"oj.ConverterFactory",type:t.ConverterFactory},validator:{name:"oj.ValidatorFactory",type:t.ValidatorFactory}},t.Validation.converterFactory=function(r,e){var a;return r&&!e?a=t.Validation._getFactory(r,t.Validation._converterFactories):r&&e&&(a=t.Validation._registerFactory(r,e,t.Validation._converterFactories,t.Validation._CONTRACTS.converter)),a},t.Validation.validatorFactory=function(r,e){var a;return r&&!e?a=t.Validation._getFactory(r,t.Validation._validatorFactories):r&&e&&(a=t.Validation._registerFactory(r,e,t.Validation._validatorFactories,t.Validation._CONTRACTS.validator)),a},t.Validation.getDefaultConverterFactory=function(r){return t.Validation._getFactory(r,t.Validation._defaultConverterFactories)},t.Validation.getDefaultValidatorFactory=function(r){return t.Validation._getFactory(r,t.Validation._defaultValidatorFactories)},t.Validation.__registerDefaultConverterFactory=function(r,e){var a=t.Validation._CONTRACTS.converter;t.Validation._registerFactory(r,e,t.Validation._defaultConverterFactories,a),t.Validation._registerFactory(r,e,t.Validation._converterFactories,a)},t.Validation.__registerDefaultValidatorFactory=function(r,e){var a=t.Validation._CONTRACTS.validator;t.Validation._registerFactory(r,e,t.Validation._defaultValidatorFactories,a),t.Validation._registerFactory(r,e,t.Validation._validatorFactories,a)},t.Validation._doImplementsCheck=function(r,e,a){if(e&&!t.Validation._quacksLike(r,e))throw new Error("Factory instance does not implement the methods expected by the factory of type "+a)},t.Validation._getFactory=function(r,e){t.Assert.assertString(r);return(e[r.toLowerCase()]||{}).instance||null},t.Validation._quacksLike=function(r,e){var a=!0;t.Assert.assertObject(r),t.Assert.assertObject(e);for(var n=Object.keys(e),o=0;o<n.length;o++){var i=n[o];if("function"==typeof e[i]&&(!r[i]||"function"!=typeof r[i])){a=!1;break}}return a},t.Validation._registerFactory=function(r,e,a,n){t.Assert.assertString(r),t.Assert.assertObject(e);var o={};o.instance=e,t.Validation._doImplementsCheck(e,n.type,n.name),a[r.toLowerCase()]=o},t.ConverterFactory={CONVERTER_TYPE_NUMBER:"number",CONVERTER_TYPE_DATETIME:"datetime",CONVERTER_TYPE_COLOR:"color",createConverter:function(t){}},t.ValidatorFactory={VALIDATOR_TYPE_REQUIRED:"required",VALIDATOR_TYPE_REGEXP:"regexp",VALIDATOR_TYPE_NUMBERRANGE:"numberRange",VALIDATOR_TYPE_LENGTH:"length",VALIDATOR_TYPE_DATETIMERANGE:"dateTimeRange",VALIDATOR_TYPE_DATERESTRICTION:"dateRestriction",createValidator:function(t){}},t.Converter=function(t){this.Init(t)},t.Object.createSubclass(t.Converter,t.Object,"oj.Converter"),t.Converter.prototype.Init=function(r){t.Converter.superclass.Init.call(this),this._options=r},t.Converter.prototype.getOptions=function(){return this._options||{}},t.Converter.prototype.resolvedOptions=function(){var t={};return r.extend(t,this._options),t},t.ConverterError=function(t,r){var e={summary:t,detail:r,severity:a.SEVERITY_LEVEL.ERROR};this.Init(e)},t.ConverterError.prototype=new Error,t.ConverterError.prototype.Init=function(t){var r=t.detail,e=t.summary;this._message=t,this.name="Converter Error",this.message=r||e},t.ConverterError.prototype.getMessage=function(){return this._message},t.Validator=function(t){this.Init(t)},t.Object.createSubclass(t.Validator,t.Object,"oj.Validator"),t.Validator.prototype.Init=function(r){t.Validator.superclass.Init.call(this)},t.ValidatorError=function(t,r){var e={summary:t,detail:r,severity:a.SEVERITY_LEVEL.ERROR};this.Init(e)},t.ValidatorError.prototype=new Error,t.ValidatorError.prototype.Init=function(t){var r=t.detail,e=t.summary;this._message=t,this.name="Validator Error",this.message=r||e},t.ValidatorError.prototype.getMessage=function(){return this._message},t.RegExpValidator=function(t){this.Init(t)},t.Object.createSubclass(t.RegExpValidator,t.Validator,"oj.RegExpValidator"),t.RegExpValidator._BUNDLE_KEY_DETAIL="oj-validator.regExp.detail",t.RegExpValidator._BUNDLE_KEY_SUMMARY="oj-validator.regExp.summary",t.RegExpValidator.prototype.Init=function(r){t.RegExpValidator.superclass.Init.call(this),this._options=r},t.RegExpValidator.prototype.validate=function(r){var a,n,o,i=this._options&&this._options.pattern||"";if(null==r||""===r)return!0;var s=r.toString(),l="^("+i+")$",u=s.match(l);if(null===u||u[0]!==s){this._options&&(o=this._options.messageSummary||null,a=this._options.messageDetail||null,n=this._options&&this._options.label||"");var d={label:n,pattern:i,value:s},c=o?e.applyParameters(o,d):e.getTranslatedString(this._getSummaryKey(),d),g=a?e.applyParameters(a,d):e.getTranslatedString(this._getDetailKey(),d);throw new t.ValidatorError(c,g)}return!0},t.RegExpValidator.prototype.getHint=function(){var t=null,r={};return this._options&&this._options.hint&&(r={pattern:this._options.pattern},t=e.applyParameters(this._options.hint,r)),t},t.RegExpValidator.prototype._getSummaryKey=function(){return t.RegExpValidator._BUNDLE_KEY_SUMMARY},t.RegExpValidator.prototype._getDetailKey=function(){return t.RegExpValidator._BUNDLE_KEY_DETAIL},t.RequiredValidator=function(t){this.Init(t)},t.Object.createSubclass(t.RequiredValidator,t.Validator,"oj.RequiredValidator"),t.RequiredValidator._BUNDLE_KEY_DETAIL="oj-validator.required.detail",t.RequiredValidator._BUNDLE_KEY_SUMMARY="oj-validator.required.summary",t.RequiredValidator.prototype.Init=function(r){t.RequiredValidator.superclass.Init.call(this),this._options=r},t.RequiredValidator.prototype.validate=function(r){var a,n,o,i,s,l="";if("number"==typeof r&&0===r||r&&0!==r.length)return!0;throw this._options&&(a=this._options.messageDetail||this._options.message||null,i=this._options.messageSummary||null,l=this._options.label||""),s={label:l},o=i?e.applyParameters(i,s):e.getTranslatedString(this._getSummaryKey(),s),n=a?e.applyParameters(a,s):e.getTranslatedString(this._getDetailKey(),s),new t.ValidatorError(o,n)},t.RequiredValidator.prototype.getHint=function(){var t="";return this._options&&this._options.hint&&(t=e.getTranslatedString(this._options.hint)),t},t.RequiredValidator.prototype._getSummaryKey=function(){return t.RequiredValidator._BUNDLE_KEY_SUMMARY},t.RequiredValidator.prototype._getDetailKey=function(){return t.RequiredValidator._BUNDLE_KEY_DETAIL},function(){function r(t,r){return"#"+function(t,r){return function(t,r,e,a){var o=[n(Math.round(t).toString(16)),n(Math.round(r).toString(16)),n(Math.round(e).toString(16))];if(a&&o[0].charAt(0)===o[0].charAt(1)&&o[1].charAt(0)===o[1].charAt(1)&&o[2].charAt(0)===o[2].charAt(1))return o[0].charAt(0)+o[1].charAt(0)+o[2].charAt(0);return o.join("")}(t._r,t._g,t._b,r)}(t,r)}function a(t,r){(function(t){return"string"==typeof t&&-1!==t.indexOf(".")&&1===parseFloat(t)})(t)&&(t="100%");var e=function(t){return"string"==typeof t&&-1!==t.indexOf("%")}(t);return t=Math.min(r,Math.max(0,parseFloat(t))),e&&(t=parseInt(t*r,10)/100),Math.abs(t-r)<1e-6?1:t%r/parseFloat(r)}function n(t){return 1===t.length?"0"+t:""+t}t.ColorConverter=function(t){this.Init(t)},t.Object.createSubclass(t.ColorConverter,t.Converter,"oj.ColorConverter"),t.ColorConverter.prototype.Init=function(r){(r=r||{}).format=r.format||"rgb",t.ColorConverter.superclass.Init.call(this,r)},t.ColorConverter.prototype.format=function(n){var o=this._getFormat(),i=null;return"rgb"===o?i=n.toString():"hsl"===o?i=function(t){var r=function(t,r,e){t=a(t,255),r=a(r,255),e=a(e,255);var n,o,i=Math.max(t,r,e),s=Math.min(t,r,e),l=(i+s)/2;if(i===s)n=0,o=0;else{var u=i-s;switch(o=l>.5?u/(2-i-s):u/(i+s),i){case t:n=(r-e)/u+(r<e?6:0);break;case r:n=(e-t)/u+2;break;case e:n=(t-r)/u+4}n/=6}return{h:n,s:o,l:l}}(t._r,t._g,t._b),e=Math.round(360*r.h),n=Math.round(100*r.s),o=Math.round(100*r.l);return 1===t._a?"hsl("+e+", "+n+"%, "+o+"%)":"hsla("+e+", "+n+"%, "+o+"%, "+t._a+")"}(n):"hex"===o?i=r(n):"hex3"===o?i=r(n,!0):"hsv"===o?i=function(t){var r=function(t,r,e){t=a(t,255),r=a(r,255),e=a(e,255);var n,o=Math.max(t,r,e),i=Math.min(t,r,e),s=o,l=o-i,u=0===o?0:l/o;if(o===i)n=0;else{switch(o){case t:n=(r-e)/l+(r<e?6:0);break;case r:n=(e-t)/l+2;break;case e:n=(t-r)/l+4}n/=6}return{h:n,s:u,v:s}}(t._r,t._g,t._b),e=Math.round(360*r.h),n=Math.round(100*r.s),o=Math.round(100*r.v);return 1===t._a?"hsv("+e+", "+n+"%, "+o+"%)":"hsva("+e+", "+n+"%, "+o+"%, "+t._a+")"}(n):function(){var r=e.getTranslatedString("oj-converter.color.invalidFormat.summary"),a=e.getTranslatedString("oj-converter.color.invalidFormat.detail");throw new t.ConverterError(r,a)}(),i||t.ColorConverter.superclass.format.call(this,n)},t.ColorConverter.prototype.parse=function(r){try{return new t.Color(r)}catch(r){throw function(){var r=e.getTranslatedString("oj-converter.color.invalidSyntax.summary"),a=e.getTranslatedString("oj-converter.color.invalidSyntax.detail");throw new t.ConverterError(r,a)}()}},t.ColorConverter.prototype.getHint=function(){return this._getFormat()},t.ColorConverter.prototype.resolvedOptions=function(){return{format:this._getFormat()}},t.ColorConverter.prototype._getFormat=function(){return t.ColorConverter.superclass.getOptions.call(this).format}}(),t.IntlConverterUtils={},t.IntlConverterUtils.isoToDate=function(r){return t.OraI18nUtils.isoToDate(r)},t.IntlConverterUtils.isoToLocalDate=function(r){return t.OraI18nUtils.isoToLocalDate(r)},t.IntlConverterUtils.dateToLocalIso=function(r){return t.OraI18nUtils.dateToLocalIso(r)},t.IntlConverterUtils.getLocalTimeZoneOffset=function(){return t.OraI18nUtils.getLocalTimeZoneOffset()},t.IntlConverterUtils.getConverterInstance=function(r){var e="",a={},n=null;if(r&&("object"==typeof r&&(r instanceof t.Converter||r.parse&&"function"==typeof r.parse||r.format&&"function"==typeof r.format?n=r:(e=r.type,a=r.options||{})),!n&&(e=e||r)&&"string"==typeof e)){var i=t.Validation.converterFactory(e);return null===i&&o.error("Converter of type "+e+" cannot be found. Make sure the correct converter/validation module is included."),i.createConverter(a)}return n},t.IntlConverterUtils._minMaxIsoString=function(t,r){if(t){var e=(r=r||this.dateToLocalIso(new Date)).indexOf("T");0===t.indexOf("T")&&e>0&&(t=r.substring(0,e)+t)}return t},t.IntlConverterUtils.__getConverterOptionError=function(r,a){t.Assert.assertObject(a);var n,o="",i="",s=a.propertyName;if("optionTypesMismatch"===r){var l=a.requiredPropertyName;n=a.requiredPropertyValueValid,o=e.getTranslatedString("oj-converter.optionTypesMismatch.summary",{propertyName:s,propertyValue:a.propertyValue,requiredPropertyName:l}),i=t.IntlConverterUtils._getOptionValueDetailMessage(l,n)}else"optionTypeInvalid"===r?(s=a.propertyName,n=a.propertyValueValid,o=e.getTranslatedString("oj-converter.optionTypeInvalid.summary",{propertyName:s}),i=t.IntlConverterUtils._getOptionValueDetailMessage(s,n)):"optionOutOfRange"===r?(o=e.getTranslatedString("oj-converter.optionOutOfRange.summary",{propertyName:s,propertyValue:a.propertyValue}),n=a.propertyValueValid,i=t.IntlConverterUtils._getOptionValueDetailMessage(s,n)):"optionValueInvalid"===r&&(o=e.getTranslatedString("oj-converter.optionValueInvalid.summary",{propertyName:s,propertyValue:a.propertyValue}),n=a.propertyValueHint,i=t.IntlConverterUtils._getOptionValueDetailMessage(s,n));return new t.ConverterError(o,i)},t.IntlConverterUtils._getOptionValueDetailMessage=function(t,r){var a;return r?("string"==typeof r?a="oj-converter.optionHint.detail":(a="oj-converter.optionHint.detail-plural",r=r.join(e.getTranslatedString("oj-converter.plural-separator"))),e.getTranslatedString(a,{propertyName:t,propertyValueValid:r})):""},t.IntlConverterUtils.__getNullFormattedValue=function(){return""},t.IntlConverterUtils._copyTimeOver=function(r,e){return t.OraI18nUtils._copyTimeOver(r,e)},t.IntlConverterUtils._clearTime=function(r){return t.OraI18nUtils._clearTime(r)},t.IntlConverterUtils._dateTime=function(r,e,a){return t.OraI18nUtils._dateTime(r,e,a)},t.IntlConverterUtils._normalizeIsoString=function(r){return t.OraI18nUtils._normalizeIsoString(r)},t.IntlConverterUtils.getInitials=function(r,e){return t.OraI18nUtils.getInitials(r,e)},t.LengthValidator=function(t){this.Init(t)},t.LengthValidator.defaults={countBy:"codeUnit"},t.Object.createSubclass(t.LengthValidator,t.Validator,"oj.LengthValidator"),t.LengthValidator.prototype.Init=function(r){var e=r.countBy;if(t.LengthValidator.superclass.Init.call(this),this._min=void 0!==r.min?parseInt(r.min,10):null,this._max=void 0!==r.max?parseInt(r.max,10):null,isNaN(this._min))throw new Error("length validator's min option is not a number. min option is "+r.min);if(isNaN(this._max))throw new Error("length validator's max option is not a number. max option is "+r.min);if(null!==this._min&&this._min<0)throw new Error("length validator's min option cannot be less than 0. min option is "+r.min);if(null!==this._max&&this._max<1)throw new Error("length validator's max option cannot be less than 1. max option is "+r.max);this._countBy=void 0===e?t.LengthValidator.defaults.countBy:e,r&&(this._hint=r.hint||{},this._customMessageSummary=r.messageSummary||{},this._customMessageDetail=r.messageDetail||{})},t.LengthValidator.prototype.getHint=function(){var t,r=null,a=this._hint,n=a.exact,o=a.inRange,i=a.max,s=a.min,l=this._max,u=this._min,d=e;return null!==u&&null!==l?u!==l?(t={min:u,max:l},r=o?d.applyParameters(o,t):d.getTranslatedString("oj-validator.length.hint.inRange",t)):(t={length:u},r=n?d.applyParameters(n,t):d.getTranslatedString("oj-validator.length.hint.exact",t)):null!==u?(t={min:u},r=s?d.applyParameters(s,t):d.getTranslatedString("oj-validator.length.hint.min",t)):null!==l&&(t={max:l},r=i?d.applyParameters(i,t):d.getTranslatedString("oj-validator.length.hint.max",t)),r},t.LengthValidator.prototype.validate=function(r){var a,n=this._customMessageDetail,o=this._customMessageSummary,i="",s=this._max,l=o.tooLong,u=o.tooShort,d=n.tooLong,c=n.tooShort,g=this._min,p="",h=e,f=""+r,m=this._getLength(f);if((null===g||m>=this._min)&&(null===s||m<=this._max))return f;throw m<this._min?(a={value:r,min:g},p=u?h.applyParameters(u,a):h.getTranslatedString("oj-validator.length.messageSummary.tooShort"),i=c?h.applyParameters(c,a):h.getTranslatedString("oj-validator.length.messageDetail.tooShort",a)):(a={value:r,max:s},p=l?h.applyParameters(l,a):h.getTranslatedString("oj-validator.length.messageSummary.tooLong"),i=d?h.applyParameters(d,a):h.getTranslatedString("oj-validator.length.messageDetail.tooLong",a)),new t.ValidatorError(p,i)},t.LengthValidator.prototype._getLength=function(r){var e,a=this._countBy.toLowerCase(),n=r.length,o=0;switch(a){case"codepoint":for(var i=0;i<n;i++)55296==(63488&r.charCodeAt(i))&&(o+=1);t.Assert.assert(o%2==0,"the number of surrogate chars must be an even number."),e=n-o/2;break;case"codeunit":default:e=n}return e},t.ColorConverterFactory=function(){return{createConverter:function(r){return function(r){return new t.ColorConverter(r)}(r)}}}(),t.Validation.__registerDefaultConverterFactory(t.ConverterFactory.CONVERTER_TYPE_COLOR,t.ColorConverterFactory),t.RequiredValidatorFactory=function(){return{createValidator:function(r){return function(r){return new t.RequiredValidator(r)}(r)}}}(),t.Validation.__registerDefaultValidatorFactory(t.ValidatorFactory.VALIDATOR_TYPE_REQUIRED,t.RequiredValidatorFactory),t.RegExpValidatorFactory=function(){return{createValidator:function(r){return function(r){return new t.RegExpValidator(r)}(r)}}}(),t.Validation.__registerDefaultValidatorFactory(t.ValidatorFactory.VALIDATOR_TYPE_REGEXP,t.RegExpValidatorFactory),t.LengthValidatorFactory=function(){return{createValidator:function(r){return function(r){return new t.LengthValidator(r)}(r)}}}(),t.Validation.__registerDefaultValidatorFactory(t.ValidatorFactory.VALIDATOR_TYPE_LENGTH,t.LengthValidatorFactory),t.LocaleData=n;var s={};return s.ColorConverter=t.ColorConverter,s.IntlConverterUtils=t.IntlConverterUtils,s.LengthValidator=t.LengthValidator,s.RegExpValidator=t.RegExpValidator,s.RequiredValidator=t.RequiredValidator,s.Validation=t.Validation,s});