/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(["ojs/ojcore","jquery","ojs/ojconfig","ojs/ojtranslation","ojL10n!ojtranslations/nls/localeElements","ojs/ojlocaledata","ojs/ojvalidation-base","ojs/ojlogger"],function(e,t,r,a,n,i,o,s){"use strict";var l;e.DateTimeConverter=function(e){this.Init(e)},e.Object.createSubclass(e.DateTimeConverter,e.Converter,"oj.DateTimeConverter"),e.DateTimeConverter.prototype.Init=function(t){e.DateTimeConverter.superclass.Init.call(this,t)},e.DateTimeConverter.prototype.format=function(t){return e.DateTimeConverter.superclass.format.call(this,t)},e.DateTimeConverter.prototype.isHourInDaySet=function(){e.Assert.failedInAbstractFunction()},e.DateTimeConverter.prototype.isHourInAMPMSet=function(){e.Assert.failedInAbstractFunction()},e.DateTimeConverter.prototype.isMinuteSet=function(){e.Assert.failedInAbstractFunction()},e.DateTimeConverter.prototype.isSecondSet=function(){e.Assert.failedInAbstractFunction()},e.DateTimeConverter.prototype.isMilliSecondSet=function(){e.Assert.failedInAbstractFunction()},e.DateTimeConverter.prototype.isYearSet=function(){e.Assert.failedInAbstractFunction()},e.DateTimeConverter.prototype.isMonthSet=function(){e.Assert.failedInAbstractFunction()},e.DateTimeConverter.prototype.isDaySet=function(){e.Assert.failedInAbstractFunction()},e.DateTimeConverter.prototype.isDayNameSet=function(){e.Assert.failedInAbstractFunction()},e.DateTimeConverter.prototype.calculateWeek=function(t){e.Assert.failedInAbstractFunction()},e.DateTimeConverter.prototype.parse=function(t){return e.DateTimeConverter.superclass.parse.call(this,t)},e.DateTimeConverter.prototype.compareISODates=function(t,r){return e.DateTimeConverter.superclass.compareISODates.call(this,t,r)},e.DateTimeConverter.prototype.getAvailableTimeZones=function(){return e.DateTimeConverter.superclass.getAvailableTimeZones.call(this)},e.DateRestrictionValidator=function(e){this.Init(e)},e.Object.createSubclass(e.DateRestrictionValidator,e.Validator,"oj.DateRestrictionValidator"),e.DateRestrictionValidator.prototype.Init=function(t){e.DateRestrictionValidator.superclass.Init.call(this),this._dayFormatter=t.dayFormatter,this._converter=o.IntlConverterUtils.getConverterInstance(t.converter),t&&(this._messageSummary=t.messageSummary||null,this._messageDetail=t.messageDetail||null)},e.DateRestrictionValidator.prototype._inDisabled=function(e){var t=this._dayFormatter;if(t){var r=t({fullYear:e.fullYear,month:e.month+1,date:e.date});return r&&r.disabled}return!1},e.DateRestrictionValidator.prototype.validate=function(t){var r="",n="",i=a,s=this._messageSummary,l=this._messageDetail,d=t?this._converter.format(t):t,u=t?o.IntlConverterUtils._dateTime(t,["fullYear","month","date"],!0):null;if(null===t)return t;if(this._inDisabled(u))throw r=s?i.applyParameters(s,{value:d}):i.getTranslatedString("oj-validator.restriction.date.messageSummary",{value:d}),n=l?i.applyParameters(l,{value:d}):i.getTranslatedString("oj-validator.restriction.date.messageDetail",{value:d}),new e.ValidatorError(r,n);return t},e.DateRestrictionValidator.prototype.getHint=function(){return null},e.DateTimeRangeValidator=function(e){this.Init(e)},e.Object.createSubclass(e.DateTimeRangeValidator,e.Validator,"oj.DateTimeRangeValidator"),e.DateTimeRangeValidator.prototype.Init=function(t){if(e.DateTimeRangeValidator.superclass.Init.call(this),this._converter=o.IntlConverterUtils.getConverterInstance(t.converter),!this._converter)throw new Error("oj.DateTimeRangeValidator missing a converter option");this._min=t.min||null,this._max=t.max||null,this._translationKey=t.translationKey||"datetime",t&&(this._hint=t.hint||{},this._customMessageSummary=t.messageSummary||{},this._customMessageDetail=t.messageDetail||{}),a.getTranslatedString("oj-validator.range."+this._translationKey+".messageSummary.rangeOverflow")||(this._translationKey="datetime")},e.DateTimeRangeValidator.prototype.validate=function(t){var r,n,i=this._customMessageSummary,s=this._customMessageDetail,l=s.rangeOverflow,d=s.rangeUnderflow,u=i.rangeOverflow,m=i.rangeUnderflow,c=o.IntlConverterUtils,v=this._min,g=this._max,h="",f="",p=a,y=null,I=t&&this._converter.format(t);if(null===t)return t;if(I=this._converter.format(t),v&&(v=c._minMaxIsoString(v,t),r=this._converter?this._converter.format(v):v),g&&(g=c._minMaxIsoString(g,t),n=this._converter?this._converter.format(g):g),null!==v&&null!==g){if(this._converter.compareISODates(t,v)>=0&&this._converter.compareISODates(t,g)<=0||this._converter.compareISODates(v,g)>0)return t}else if(null!==v){if(this._converter.compareISODates(t,v)>=0)return t}else if(null===g||this._converter.compareISODates(t,g)<=0)return t;throw null!==g&&this._converter.compareISODates(t,g)>0?(y={value:I,max:n},h=u||p.getTranslatedString("oj-validator.range."+this._translationKey+".messageSummary.rangeOverflow"),f=l?p.applyParameters(l,y):p.getTranslatedString("oj-validator.range."+this._translationKey+".messageDetail.rangeOverflow",y)):null!==v&&this._converter.compareISODates(t,v)<0&&(y={value:I,min:r},h=m||p.getTranslatedString("oj-validator.range."+this._translationKey+".messageSummary.rangeUnderflow"),f=d?p.applyParameters(d,y):p.getTranslatedString("oj-validator.range."+this._translationKey+".messageDetail.rangeUnderflow",y)),new e.ValidatorError(h,f)},e.DateTimeRangeValidator.prototype.getHint=function(){var e=null,t=this._hint,r=t.inRange,n=t.min,i=t.max,o=this._min,s=this._max,l=o&&this._converter?this._converter.format(o):o,d=s&&this._converter?this._converter.format(s):s,u=null,m=a;return null!==o&&null!==s?(u={min:l,max:d},e=r?m.applyParameters(r,u):m.getTranslatedString("oj-validator.range."+this._translationKey+".hint.inRange",u)):null!==o?(u={min:l},e=n?m.applyParameters(n,u):m.getTranslatedString("oj-validator.range."+this._translationKey+".hint.min",u)):null!==s&&(u={max:d},e=i?m.applyParameters(i,u):m.getTranslatedString("oj-validator.range."+this._translationKey+".hint.max",u)),e},e.DateTimeConverterFactory=function(){return{createConverter:function(t){return function(t){return new e.IntlDateTimeConverter(t)}(t)}}}(),o.Validation.__registerDefaultConverterFactory(e.ConverterFactory.CONVERTER_TYPE_DATETIME,e.DateTimeConverterFactory),e.DateTimeRangeValidatorFactory=function(){return{createValidator:function(t){return function(t){return new e.DateTimeRangeValidator(t)}(t)}}}(),o.Validation.__registerDefaultValidatorFactory(e.ValidatorFactory.VALIDATOR_TYPE_DATETIMERANGE,e.DateTimeRangeValidatorFactory),e.DateRestrictionValidatorFactory=function(){return{createValidator:function(t){return function(t){return new e.DateRestrictionValidator(t)}(t)}}}(),o.Validation.__registerDefaultValidatorFactory(e.ValidatorFactory.VALIDATOR_TYPE_DATERESTRICTION,e.DateRestrictionValidatorFactory),e.IntlDateTimeConverter=function(e){this.Init(e)},e.Object.createSubclass(e.IntlDateTimeConverter,e.DateTimeConverter,"oj.IntlDateTimeConverter"),e.IntlDateTimeConverter._DEFAULT_DATE=new Date(1998,10,29,15,45,31),e.IntlDateTimeConverter.prototype.Init=function(t){e.IntlDateTimeConverter.superclass.Init.call(this,t)},e.IntlDateTimeConverter.prototype._getWrapped=function(){return this._wrapped||(this._wrapped=l.getInstance()),this._wrapped},e.IntlDateTimeConverter.prototype.format=function(t){var a=i.__getBundle(),n=r.getLocale(),o=this.resolvedOptions();if(null==t||"string"==typeof t&&0===e.StringUtils.trim(""+t).length)return e.IntlConverterUtils.__getNullFormattedValue();try{return this._getWrapped().format(t,a,o,n)}catch(e){throw this._processConverterError(e,t)}},e.IntlDateTimeConverter.prototype.formatRelative=function(e,t){var a=i.__getBundle(),n=r.getLocale();try{return this._getWrapped().formatRelative(e,a,t,n)}catch(t){throw this._processConverterError(t,e)}},e.IntlDateTimeConverter.prototype.getHint=function(){return null},e.IntlDateTimeConverter.prototype._getHintValue=function(){var t="";try{t=this.format(o.IntlConverterUtils.dateToLocalIso(e.IntlDateTimeConverter._DEFAULT_DATE))}catch(r){r instanceof e.ConverterError&&(t="")}return t},e.IntlDateTimeConverter.prototype.getOptions=function(){return e.IntlDateTimeConverter.superclass.getOptions.call(this)},e.IntlDateTimeConverter.prototype.resolvedOptions=function(){var e,t=r.getLocale(),a=this.getOptions();if(t!==this._locale||!this._resolvedOptions){e=i.__getBundle();try{if(!e)return s.error("locale bundle for the current locale %s is unavailable",t),{};this._resolvedOptions=this._getWrapped().resolvedOptions(e,a,t),this._locale=t}catch(e){throw this._processConverterError(e)}}return this._resolvedOptions},e.IntlDateTimeConverter.prototype.isHourInDaySet=function(){var e=this.resolvedOptions(),t=e.hour,r=e.hour12;return!(!t||r)},e.IntlDateTimeConverter.prototype.isHourInAMPMSet=function(){var e=this.resolvedOptions(),t=e.hour,r=e.hour12;return!(!t||!r)},e.IntlDateTimeConverter.prototype.isMinuteSet=function(){return this._isOptionSet("minute")},e.IntlDateTimeConverter.prototype.isSecondSet=function(){return this._isOptionSet("second")},e.IntlDateTimeConverter.prototype.isMilliSecondSet=function(){return this._isOptionSet("millisecond")},e.IntlDateTimeConverter.prototype.isYearSet=function(){return this._isOptionSet("year")},e.IntlDateTimeConverter.prototype.isMonthSet=function(){return this._isOptionSet("month")},e.IntlDateTimeConverter.prototype.isDaySet=function(){return this._isOptionSet("day")},e.IntlDateTimeConverter.prototype.isDayNameSet=function(){return this._isOptionSet("weekday")},e.IntlDateTimeConverter.prototype.calculateWeek=function(e){return this._getWrapped().calculateWeek(e,i.__getBundle(),r.getLocale())},e.IntlDateTimeConverter.prototype.parse=function(e){if(null==e||""===e)return null;var t=i.__getBundle(),a=r.getLocale(),n=this.resolvedOptions();try{var o=this._getWrapped().parse(e,t,n,a),l=o.value;return l&&o.warning&&s.warn("The value "+e+" was leniently parsed to represent a date "+l.toString?l.toString():l),l}catch(t){throw this._processConverterError(t,e)}},e.IntlDateTimeConverter.prototype.compareISODates=function(t,r){var a=e.StringUtils.isString;if(!a(t)||!a(r))throw new Error("Invalid arguments for compareISODates ",t,r);return this._getWrapped().compareISODates(t,r,i.__getBundle())},e.IntlDateTimeConverter.prototype._processConverterError=function(t,r){var n,i,s,l,d=t.errorInfo;if(d){var u=d.errorCode,m=d.parameterMap||{};e.Assert.assertObject(m);var c=m.propertyName;c=a.getTranslatedString("oj-converter.datetime.datetimeOutOfRange."+c),m.propertyName=c,t instanceof TypeError?"optionTypesMismatch"!==u&&"optionTypeInvalid"!==u||(s=o.IntlConverterUtils.__getConverterOptionError(u,m)):t instanceof RangeError?"optionOutOfRange"===u?s=o.IntlConverterUtils.__getConverterOptionError(u,m):"datetimeOutOfRange"===u?(n=a.getTranslatedString("oj-converter.datetime.datetimeOutOfRange.summary",{propertyName:c,value:m.value}),i=a.getTranslatedString("oj-converter.datetime.datetimeOutOfRange.detail",{minValue:m.minValue,maxValue:m.maxValue}),s=new e.ConverterError(n,i)):"isoStringOutOfRange"===u&&(n=a.getTranslatedString("oj-converter.datetime.invalidISOString.invalidRangeSummary",{isoStr:m.isoString,propertyName:c,value:m.value}),i=a.getTranslatedString("oj-converter.datetime.datetimeOutOfRange.detail",{minValue:m.minValue,maxValue:m.maxValue}),s=new e.ConverterError(n,i)):t instanceof SyntaxError?"optionValueInvalid"===u&&(s=o.IntlConverterUtils.__getConverterOptionError(u,m)):t instanceof Error&&("dateFormatMismatch"===u?l="oj-converter.datetime.dateFormatMismatch.summary":"timeFormatMismatch"===u?l="oj-converter.datetime.timeFormatMismatch.summary":"datetimeFormatMismatch"===u?l="oj-converter.datetime.datetimeFormatMismatch.summary":"invalidTimeZoneID"===u?(n=a.getTranslatedString("oj-converter.datetime.invalidTimeZoneID.summary",{timeZoneID:m.timeZoneID}),i=a.getTranslatedString("oj-converter.hint.detail",{exampleValue:this._getHintValue()}),s=new e.ConverterError(n,i)):"nonExistingTime"===u?l="oj-converter.datetime.nonExistingTime.summary":"missingTimeZoneData"===u?l="oj-converter.datetime.missingTimeZoneData.summary":"dateToWeekdayMismatch"===u?(n=a.getTranslatedString("oj-converter.datetime.dateToWeekdayMismatch.summary",{date:m.date,weekday:m.weekday}),i=a.getTranslatedString("oj-converter.datetime.dateToWeekdayMismatch.detail"),s=new e.ConverterError(n,i)):"invalidISOString"===u&&(n=a.getTranslatedString("oj-converter.datetime.invalidISOString.summary",{isoStr:m.isoStr}),i=a.getTranslatedString("oj-converter.datetime.invalidISOString.detail"),s=new e.ConverterError(n,i)),l&&(n=a.getTranslatedString(l,{value:r||m.value,format:m.format}),i=a.getTranslatedString("oj-converter.hint.detail",{exampleValue:this._getHintValue()}),s=new e.ConverterError(n,i)))}return s||(n=t.message,i=t.message,s=new e.ConverterError(n,i)),s},e.IntlDateTimeConverter.prototype._isOptionSet=function(e){return!!this.resolvedOptions()[e]},e.IntlDateTimeConverter.prototype.getAvailableTimeZones=function(){return this._getWrapped().getAvailableTimeZones(i.__getBundle())},e.IntlDateTimeConverter.prototype._getTimePositioning=function(e){var t;return t=null===e?this.resolvedOptions():e,this._getWrapped().getTimePositioning(i.__getBundle(),t,r.getLocale())},l=function(){var t,r={},a={},n=/(\d{1,4})\D+?(\d{1,4})/g,i=/(\d{1,4})\D+?(\d{1,4})\D+?(\d{1,4})/g,o=/^[M][^M]|[^M]M[^M]|[^M]M$|^M$/g,s=/^[L][^L]|[^L]L[^L]|[^L]L$|^L$/g,u=/^[d][^d]|[^d]d[^d]|[^d]d$|^d$|^d[^d]/,m=/(?:^|[^h])h[^h]|[^H]H[^H]|[^k]k[^k]|[^K]K[^K]|^H[^H]|^H$|[^h]h$/,c=/'.*'/,v=/'[^d]*d[^d]*'/,g=/(\d{1,2})(?:\D+?(\d{1,2}))?(?:\D+?(\d{1,2}))?(?:\D+?(\d{1,3}))?/g,h=/h|H|K|k/g,f=/([\^$.*+?|\[\](){}])/g,p=/ccccc|cccc|ccc|cc|c|EEEEE|EEEE|EEE|EE|E|dd|d|MMMMM|MMMM|MMM|MM|M|LLLLL|LLLL|LLL|LL|L|yyyy|yy|y|hh|h|HH|H|KK|K|kk|k|mm|m|ss|s|aa|a|SSS|SS|S|zzzz|zzz|zz|z|v|ZZZ|ZZ|Z|XXX|XX|X|VV|GGGGG|GGGG|GGG|GG|G/g,y=/\s?(?:\(|\[)?z{1,4}(?:\)|\])?/g,I=!1,O={0:"sun",1:"mon",2:"tue",3:"wed",4:"thu",5:"fri",6:"sat"},k={s:46,m:46,h:23,d:7,w:4,M:12},T="zulu",D="local",M="auto",b="invariant",E="offset",U="UTC",w="(\\D+|\\d\\d?\\D|\\d\\d?|\\D+\\d\\d?)",x="(\\D+|\\D+\\d\\d?)",S={MMM:{token:"months",style:"format",mLen:"abbreviated",matchIndex:0,key:"month",value:"short",regExp:w},MMMM:{token:"months",style:"format",mLen:"wide",matchIndex:0,key:"month",value:"long",regExp:w},MMMMM:{token:"months",style:"format",mLen:"narrow",matchIndex:0,key:"month",value:"narrow",regExp:w},LLL:{token:"months",style:"stand-alone",mLen:"abbreviated",matchIndex:1,key:"month",value:"short",regExp:w},LLLL:{token:"months",style:"stand-alone",mLen:"wide",matchIndex:1,key:"month",value:"long",regExp:w},LLLLL:{token:"months",style:"stand-alone",mLen:"narrow",matchIndex:1,key:"month",value:"narrow",regExp:w},E:{token:"days",style:"format",dLen:"abbreviated",matchIndex:0,key:"weekday",value:"short",regExp:x},EE:{token:"days",style:"format",dLen:"abbreviated",matchIndex:0,key:"weekday",value:"short",regExp:x},EEE:{token:"days",style:"format",dLen:"abbreviated",matchIndex:0,key:"weekday",value:"short",regExp:x},EEEE:{token:"days",style:"format",dLen:"wide",matchIndex:0,key:"weekday",value:"long",regExp:x},EEEEE:{token:"days",style:"format",dLen:"narrow",matchIndex:0,key:"weekday",value:"narrow",regExp:x},c:{token:"days",style:"stand-alone",dLen:"abbreviated",matchIndex:1,key:"weekday",value:"short",regExp:x},cc:{token:"days",style:"stand-alone",dLen:"abbreviated",matchIndex:1,key:"weekday",value:"short",regExp:x},ccc:{token:"days",style:"stand-alone",dLen:"abbreviated",matchIndex:1,key:"weekday",value:"short",regExp:x},cccc:{token:"days",style:"stand-alone",dLen:"wide",matchIndex:1,key:"weekday",value:"long",regExp:x},ccccc:{token:"days",style:"stand-alone",dLen:"narrow",matchIndex:1,key:"weekday",value:"narrow",regExp:x},h:{token:"time",timePart:"hour",start1:0,end1:11,start2:1,end2:12,key:"hour",value:"numeric",regExp:"(\\d\\d?)"},hh:{token:"time",timePart:"hour",start1:0,end1:11,start2:1,end2:12,key:"hour",value:"2-digit",regExp:"(\\d\\d?)"},K:{token:"time",timePart:"hour",start1:0,end1:11,start2:0,end2:11,key:"hour",value:"numeric",regExp:"(\\d\\d?)"},KK:{token:"time",timePart:"hour",start1:0,end1:11,start2:0,end2:11,key:"hour",value:"2-digit",regExp:"(\\d\\d?)"},H:{token:"time",timePart:"hour",start1:0,end1:23,start2:0,end2:23,key:"hour",value:"numeric",regExp:"(\\d\\d?)"},HH:{token:"time",timePart:"hour",start1:0,end1:23,start2:0,end2:23,key:"hour",value:"2-digit",regExp:"(\\d\\d?)"},k:{token:"time",timePart:"hour",start1:0,end1:23,start2:1,end2:24,key:"hour",value:"numeric",regExp:"(\\d\\d?)"},kk:{token:"time",timePart:"hour",start1:0,end1:23,start2:1,end2:24,key:"hour",value:"2-digit",regExp:"(\\d\\d?)"},m:{token:"time",timePart:"minute",start1:0,end1:59,start2:0,end2:59,key:"minute",value:"numeric",regExp:"(\\d\\d?)"},mm:{token:"time",timePart:"minute",start1:0,end1:59,start2:0,end2:59,key:"minute",value:"2-digit",regExp:"(\\d\\d?)"},s:{token:"time",timePart:"second",start1:0,end1:59,start2:0,end2:59,key:"second",value:"numeric",regExp:"(\\d\\d?)"},ss:{token:"time",timePart:"second",start1:0,end1:59,start2:0,end2:59,key:"second",value:"2-digit",regExp:"(\\d\\d?)"},S:{token:"time",timePart:"millisec",start1:0,end1:999,start2:0,end2:999,key:"millisecond",value:"numeric",regExp:"(\\d{1,3})"},SS:{token:"time",timePart:"millisec",start1:0,end1:999,start2:0,end2:999,key:"millisecond",value:"numeric",regExp:"(\\d{1,3})"},SSS:{token:"time",timePart:"millisec",start1:0,end1:999,start2:0,end2:999,key:"millisecond",value:"numeric",regExp:"(\\d{1,3})"},d:{token:"dayOfMonth",key:"day",value:"numeric",getPartIdx:2,regExp:"(\\d\\d?)"},dd:{token:"dayOfMonth",key:"day",value:"2-digit",getPartIdx:2,regExp:"(\\d\\d?)"},M:{token:"monthIndex",key:"month",value:"numeric",getPartIdx:1,regExp:"(\\d\\d?)"},MM:{token:"monthIndex",key:"month",value:"2-digit",getPartIdx:1,regExp:"(\\d\\d?)"},L:{token:"monthIndex",key:"month",value:"numeric",getPartIdx:1,regExp:"(\\d\\d?)"},LL:{token:"monthIndex",key:"month",value:"2-digit",getPartIdx:1,regExp:"(\\d\\d?)"},y:{token:"year",key:"year",value:"numeric",regExp:"(\\d{1,4})"},yy:{token:"year",key:"year",value:"2-digit",regExp:"(\\d\\d?)"},yyyy:{token:"year",key:"year",value:"numeric",regExp:"(\\d{1,4})"},a:{token:"ampm",key:"hour12",value:!0,regExp:"(\\D*)"},z:{token:"tzAbbrev",regExp:"(.+?)"},v:{token:"tzAbbrev",key:"timeZoneName",value:"short",regExp:"(.+?)"},zz:{token:"tzAbbrev",regExp:"(.+?)"},zzz:{token:"tzAbbrev",regExp:"(.+?)"},zzzz:{token:"tzFull",regExp:"(.+?)"},Z:{token:"tzhm",regExp:"([+-]?\\d{1,4})"},ZZ:{token:"tzhm",regExp:"([+-]?\\d{1,4})"},ZZZ:{token:"tzhm",regExp:"([+-]?\\d{1,4})"},X:{token:"tzh",regExp:"([+-]?\\d{1,2})"},XX:{token:"tzhm",key:"XX",regExp:"([+-]?\\d{1,4})"},XXX:{token:"tzhsepm",regExp:"([+-]?\\d{1,2}:\\d{1,2})"},VV:{token:"tzid",regExp:"(.+?)"},G:{token:"era",key:"era",value:"short",regExp:x},GG:{token:"era",key:"era",value:"short",regExp:x},GGG:{token:"era",key:"era",value:"short",regExp:x},GGGG:{token:"era",key:"era",value:"long",regExp:x},GGGGG:{token:"era",key:"era",value:"narrow",regExp:x},"/":{token:"slash",regExp:"(\\/)"}};function C(e){var t=e["two-digit-year-start"];return(void 0===t||isNaN(t))&&(t=1950),t=parseInt(t,10)}function _(t){var r=t._ojLocale_,a=e.OraI18nUtils.getBCP47Region(r);return"h"===t.supplemental.prefferedHours[a]}function L(t,r,a){var n,i,o,s=e.OraI18nUtils.getLocaleElementsMainNode(r),l=e.OraI18nUtils.getGetOption(t,a),d=l("formatType","string",["date","time","datetime"],"date"),u=l("dateFormat","string",["short","medium","long","full"],"short"),m=l("timeFormat","string",["short","medium","long","full"],"short"),c=s.dates.calendars.gregorian,v=c.dateFormats,g=c.timeFormats;switch(u){case"full":n=v.full;break;case"long":n=v.long;break;case"medium":n=v.medium;break;case"short":n=v.short}switch(m){case"full":i=g.full;break;case"long":i=g.long;break;case"medium":i=g.medium;break;case"short":i=g.short}return void 0===n||"datetime"!==d&&"date"!==d||(o=n),void 0===i||"datetime"!==d&&"time"!==d||(I&&(i=i.replace(y,"")),o=o?o+" "+i:i),o}function F(e,t){for(var r=0,a=!1,n=0,i=e.length;n<i;n++){var o=e.charAt(n);switch(o){case"'":a?t.push("'"):r+=1,a=!1;break;case"\\":a&&t.push("\\"),a=!a;break;default:t.push(o),a=!1}}return r}function Z(e,t,r){var a,n=void 0!==t.year||void 0!==t.month||void 0!==t.weekday||void 0!==t.day,i=void 0!==t.hour||void 0!==t.minute||void 0!==t.second;a=n&&i?"MM/dd/yy hh:mm:ss a":n?"MM/dd/yy":"hh:mm:ss a";var o=new SyntaxError("Unexpected character(s) "+r+' encountered in the pattern "'+e+' An example of a valid pattern is "'+a+'".'),s={errorCode:"optionValueInvalid",parameterMap:{propertyName:"pattern",propertyValue:e,"propertyValueHint ":a}};throw o.errorInfo=s,o}function N(t,r,a,n){for(var i,o=e.OraI18nUtils.getLocaleElementsMainNode(r).dates.calendars.gregorian.dateTimeFormats.availableFormats,s=["weekday","era","year","month","day","hour","minute","second","timeZoneName"],l={"2-digit":0,numeric:1,narrow:2,short:3,long:4},d=-1/0,u=Object.keys(o),m=0;m<u.length;m++){var c=u[m],v=!1,g={};g.pattern=o[c];for(var h=0,f=p.exec(c);null!==f;){var y=f[0];("h"!==y&&"hh"!==y||n)&&("H"!==y&&"HH"!==y||!n)?void 0!==S[y]&&(g[S[y].key]=S[y].value):v=!0,f=p.exec(c)}if(!v){for(var I=0;I<s.length;I++){var O=t[s[I]],k=g[s[I]];if(void 0===O&&void 0!==k)h-=20;else if(void 0!==O&&void 0===k)h-=120;else if(void 0!==O&&void 0!==k){var T=l[O],D=l[k],M=Math.max(Math.min(D-T,2),-2);2===M?h-=6:1===M?h-=3:-1===M?h-=6:-2===M&&(h-=8)}}h>d&&(d=h,i=g)}}return void 0!==i?i.pattern:null}function j(e,t,r,a){return void 0!==r?(e[t]=r,a[r]):""}function z(e,t,r){var a;if(Object.keys(t).length>1)return null;for(var n=e.length;n>0;n--)if(void 0!==(a=r[e.substr(0,n)]))return a;return e}function P(t,a,n,i){var l,d,g,f=e.OraI18nUtils.getLocaleElementsMainNode(a),p=e.OraI18nUtils.getLocaleElementsMainNodeKey(a),y=e.OraI18nUtils.getGetOption(t,i),I=y("formatMatcher","string",["basic","munger"],"munger");0===Object.keys(t).length&&(t={year:"numeric",month:"numeric",day:"numeric"});var O=y("millisecond","string",["numeric","2-digit"]),k=y("second","string",["numeric","2-digit"]);void 0!==O&&(d=y("hour","string",["numeric","2-digit"]),g=y("minute","string",["numeric","2-digit"]),t.second="2-digit");var T=function(t,r,a){var n="",i="",o={},s={},l=e.OraI18nUtils.getGetOption(t,a),d=l("era","string",["narrow","short","long"]);n+=j(o,"era",d,{narrow:"GGGGG",short:"GGG",long:"GGGG"}),n+=j(o,"year",d=l("year","string",["2-digit","numeric"]),{"2-digit":"yy",numeric:"y"}),n+=j(o,"month",d=l("month","string",["2-digit","numeric","narrow","short","long"]),{"2-digit":"MM",numeric:"M",narrow:"MMMMM",short:"MMM",long:"MMMM"}),n+=j(o,"weekday",d=l("weekday","string",["narrow","short","long"]),{narrow:"EEEEE",short:"E",long:"EEEE"}),n+=j(o,"day",d=l("day","string",["2-digit","numeric"]),{"2-digit":"dd",numeric:"d"});var u=l("hour12","boolean",[!0,!1]);return void 0===u&&(u=_(r)),i+=j(s,"hour",d=l("hour","string",["2-digit","numeric"]),!0===u?{"2-digit":"hh",numeric:"h"}:{"2-digit":"HH",numeric:"H"}),i+=j(s,"minute",d=l("minute","string",["2-digit","numeric"]),{"2-digit":"mm",numeric:"m"}),i+=j(s,"second",d=l("second","string",["2-digit","numeric"]),{"2-digit":"ss",numeric:"s"}),[n,i+=j(s,"timeZoneName",d=l("timeZoneName","string",["short","long"]),{short:"v",long:"v"}),o,s]}(t,a,i);if(void 0!==r[p]){var D=r[p].dates.calendars.gregorian.dateTimeFormats[T[0]+T[1]];if(void 0!==D)return D=w(D)}if(""===T[0]&&""===T[1])return L(t,a,i);var M=f.dates.calendars.gregorian.dateTimeFormats.availableFormats,b=M[T[0]],E=y("hour12","boolean",[!0,!1]);void 0===E&&(E=_(a)),void 0===b&&""!==T[0]&&(null===(b=z(T[0],T[2],M))&&(b=N(T[2],a,0,E)),null!==b?"basic"!==I&&(b=function(t,r,a){var n=t,i=e.OraI18nUtils.getGetOption(r,a),l=i("year","string",["2-digit","numeric"]),d={"2-digit":"yy",numeric:"yyyy"};void 0!==l&&(n=n.replace(/y{1,4}/,d[l])),void 0!==(l=i("month","string",["2-digit","numeric","narrow","short","long"]))&&(void 0!==(d={"2-digit":"MM",numeric:"M",narrow:"MMMMM",short:"MMM",long:"MMMM"})[l]&&d[l].length>2?n=(n=n.replace(/M{3,5}/,d[l])).replace(/L{3,5}/,{"2-digit":"LL",numeric:"L",narrow:"LLLLL",short:"LLL",long:"LLLL"}[l]):"2-digit"===l&&(o.lastIndex=0,o.test(t)&&(n=n.replace("M","MM")),s.test(t)&&(n=n.replace("L","LL"))));void 0!==(l=i("weekday","string",["narrow","short","long"]))&&(n=(n=n.replace(/E{1,5}/,{narrow:"EEEEE",short:"EEE",long:"EEEE"}[l])).replace(/c{1,5}/,{narrow:"ccccc",short:"ccc",long:"cccc"}[l]));if(void 0!==(l=i("day","string",["2-digit","numeric"]))&&"2-digit"===l){u.lastIndex=0,v.lastIndex=0;var m=v.test(t);!0===u.test(t)&&!1===m&&(n=n.replace("d","dd"))}return n}(b,t,i)):b=T[0]);var U=M[T[1]];return void 0===U&&""!==T[1]&&(null===(U=z(T[1],T[3],M))&&(U=N(T[3],a,0,E)),null!==U?"basic"!==I&&(U=function(t,r,a){var n=t;if("2-digit"===e.OraI18nUtils.getGetOption(r,a)("hour","string",["2-digit","numeric"])){m.lastIndex=0,c.lastIndex=0;var i=t.replace(c,""),o=m.exec(i);if(null!==o){h.lastIndex=0;var s=h.exec(o[0]),l=s[0]+s[0];n=t.replace(s[0],l)}}return n}(U,t,i)):U=T[1]),l=b||"",void 0!==U&&(""!==l?l+=" "+U:l=U),void 0===r[p]&&(r[p]={},r[p].dates={},r[p].dates.calendars={},r[p].dates.calendars.gregorian={},r[p].dates.calendars.gregorian.dateTimeFormats={}),r[p].dates.calendars.gregorian.dateTimeFormats[T[0]+T[1]]=l,l=w(l);function w(r){if(void 0!==O){var a=(i=f,o=n,s="symbols-numberSystem-"+e.OraI18nUtils.getNumberingSystemKey(i,o),i.numbers[s].decimal);a=void 0===d&&void 0===g&&void 0===k?"S":"ss"+a+"SSS",r=r.replace("ss",a),void 0===k&&(t.second=void 0)}var i,o,s,l=y("timeZoneName","string",["short","long"]);return void 0!==l&&(r=r.replace(/v/,{short:"z",long:"zzzz"}[l])),r}}function V(e){var t=e.split(" "),r=t[0].split("-"),a=new Date(r[0],r[1]-1,r[2]);return t.length>1&&(r=t[1].split(":"),a.setHours(r[0]),a.setMinutes(r[1])),a.getTime()}function G(e,t,r){var a=new Date(e[0],e[1]-1,e[2],e[3],e[4],e[5]).getTime(),n=t.split("/"),i=n[0],o=n[1],s=r[i];if(void 0===s)return null;if(void 0===(s=s[o]))return null;for(var l,d,u=s.length,m=0;m<u;m++){var c=s[m].usesMetazone._from,v=s[m].usesMetazone._to,g=s[m].usesMetazone._mzone;if(void 0===c&&void 0===v)return g;if(void 0===c&&void 0!==v&&a<=(d=V(v)))return g;if(void 0!==c&&void 0===v&&a>=(l=V(c)))return g;if(void 0!==c&&void 0!==v&&(l=V(c),d=V(v),a>=l&&a<d))return g}}function R(t,r,a,n,i){var o=e.OraI18nUtils.getLocaleElementsMainNode(t),s="",l=a.timeZone,d=e.OraI18nUtils.getGetOption(a,"OraDateTimeConverter")("dst","boolean",[!0,!1],!1);if(void 0===l)return s;var u,m,c=G(r,l,t.supplemental.metazones),v="standard",g=!i,h=A(l,t),f=H(h,r,d,g,!0);if(void 0!==o.dates.timeZoneNames.metazone&&(u=o.dates.timeZoneNames.metazone[c]),void 0===u){var p=h.ofset(f);return e.OraI18nUtils.getTimeStringFromOffset(U,p,!0,!0)}m=1===n?u.long:u.short;var y=h.ofset(f);return y<h.ofset(f+1)&&(v="daylight"),void 0!==m&&void 0!==(s=m[v])?s:e.OraI18nUtils.getTimeStringFromOffset(U,y,!0,!0)}function A(e,t){return d.getInstance().getZone(e,t)}function H(e,t,r,a,n){var i=Date.UTC(t[0],t[1]-1,t[2],t[3],t[4],t[5]);return e.parse(i,r,a,n)}function K(e){var t=e.split(":");return 2===t.length?(t[0]=parseInt(t[0],10),t[1]=parseInt(t[1],10)):3===e.length?(t[0]=parseInt(e,10),t[1]=0):(t[0]=parseInt(e.substr(0,3),10),t[1]=parseInt(e.substr(3),10)),t}function W(t,r,a,n){var i,o,s,l=a.isoStrParts,d=0===a.dateTime.indexOf("T"),u=e.OraI18nUtils.getLocaleElementsMainNode(t),m=e.OraI18nUtils.getGetOption(r,"OraDateTimeConverter.format");o=r.pattern||P(r,t,n,"OraDateTimeConverter.format"),i=[];var c=0,v=u.dates.calendars.gregorian;function g(e,t){switch(t){case 0:return e[0];case 1:return e[1];case 2:return e[2];case 3:var r=new Date(e[0],e[1]-1,e[2],e[3],e[4],e[5]);return O[r.getDay()];default:return}}function h(t,a,n,i,o){var s;switch(i.timePart){case"hour":s=11===i.end1?a[3]%12:a[3],"h"===o||"hh"===o?0===s&&(s=12):"k"!==o&&"kk"!==o||0===s&&(s=24);break;case"minute":s=a[4];break;case"second":s=void 0===r.second&&void 0!==r.millisecond?0:a[5];break;case"millisec":s=a[6]}t.push(n>1?e.OraI18nUtils.padZeros(s,n):s)}function f(r,n,i){var o,s,l,d=n.timeZone,u=m("dst","boolean",[!0,!1],!1),c=!i;if(void 0!==d)l=H(s=A(d,t),r,u,c,!0),o=-s.ofset(l);else if(a.format!==D)switch(a.format){case E:var v=K(a.timeZone),g=v[0],h=v[1];o=60*g+(e.OraI18nUtils.startsWith(a.timeZone,"-")?-h:h);break;case T:default:o=0}return o}var y,I,k,M,b,w=r.timeZone;for(a.format!==D&&void 0!==w&&we(a,r,t);;){var x=p.lastIndex,C=p.exec(o);if(c+=F(o.slice(x,C?C.index:o.length),i),!C)break;if(c%2)i.push(C[0]);else{var _=C[0],L=_.length,N=S[_];switch(N.token){case"days":s=v[N.token][N.style][N.dLen],i.push(s[g(l,3)]);break;case"months":s=v[N.token][N.style][N.mLen],i.push(s[g(l,1)]);break;case"dayOfMonth":case"monthIndex":i.push((y=i,I=l,k=N.getPartIdx,M=L,void 0,b=g(I,k),void y.push(M>1?e.OraI18nUtils.padZeros(b,M):b)));break;case"year":s=l[0],2===L&&(s%=100),i.push(e.OraI18nUtils.padZeros(s,L));break;case"time":h(i,l,L,N,_);break;case"ampm":s=l[3]<12?v.dayPeriods.format.wide.am:v.dayPeriods.format.wide.pm,i.push(s);break;case"tzhm":0===(s=f(l,r,d))?"XX"===N.key?i.push("Z"):i.push("+0000"):void 0!==s&&i.push((s<=0?"-":"+")+e.OraI18nUtils.padZeros(Math.floor(Math.abs(s/60)),2)+e.OraI18nUtils.padZeros(Math.floor(Math.abs(s%60)),2));break;case"tzhsepm":0===(s=f(l,r,d))?i.push("Z"):void 0!==s&&i.push((s<=0?"-":"+")+e.OraI18nUtils.padZeros(Math.floor(Math.abs(s/60)),2)+":"+e.OraI18nUtils.padZeros(Math.floor(Math.abs(s%60)),2));break;case"tzh":0===(s=f(l,r,d))?i.push("Z"):void 0!==s&&i.push((s<=0?"-":"+")+e.OraI18nUtils.padZeros(Math.floor(Math.abs(s/60)),2));break;case"tzid":s=void 0!==w?w:a.format===T?U:"",i.push(s);break;case"tzAbbrev":s=R(t,l,r,0,d),i.push(s);break;case"tzFull":s=R(t,l,r,1,d),i.push(s);break;case"era":s=v.eras.eraAbbr,i.push(s[1]);break;case"slash":i.push("/");break;default:Z(o,r,_)}}}return i.join("")}function X(e,t){return e.getFullYear()===t.getFullYear()}function Y(e,t){return t.getFullYear()-e.getFullYear()==1}function $(e,t){return X(e,t)&&e.getMonth()===t.getMonth()}function B(e,t){return X(e,t)?t.getMonth()-e.getMonth()==1:!!Y(e,t)&&(11===e.getMonth()&&0===t.getMonth())}function q(t,r){var a=t.getDate(),n=r.getDate();return B(t,r)&&(n+=e.OraI18nUtils._getDaysInMonth(t.getFullYear,t.getMonth())),n-a}function J(t,r){var a=t._ojLocale_,n=e.OraI18nUtils.getBCP47Region(a),i=t.supplemental.weekData.firstDay,o=i[n];void 0===o&&(o=i["001"]);var s=r-o;return s<0&&(s+=7),s}function Q(e,t,r){if(!$(t,r)&&!B(t,r))return!1;var a=q(t,r)+J(e,t.getDay());return a>=7&&a<=13}function ee(e,t){return X(e,t)&&$(e,t)&&e.getDate()===t.getDate()}function te(e,t){return!(!$(e,t)&&!B(e,t))&&1===q(e,t)}function re(e,t){return te(t,e)}function ae(t,r,a){var n=e.OraI18nUtils._IsoStrParts(t),i=e.OraI18nUtils._IsoStrParts(r);return a?(n=Date.UTC(n[0],n[1]-1,n[2],0,0,0,0),i=Date.UTC(i[0],i[1]-1,i[2],0,0,0,0)):(n=Date.UTC(n[0],n[1]-1,n[2],n[3],n[4],n[5],n[6]),i=Date.UTC(i[0],i[1]-1,i[2],i[3],i[4],i[5],i[6])),n-i}function ne(e,t){return e.replace(/\{(\d+)\}/g,function(){return t[arguments[1]]})}function ie(t,r,a,n){var i=e.OraI18nUtils.getLocaleElementsMainNode(n).dates.fields,o=e.OraI18nUtils.getGetOption(a,"OraDateTimeConverter.formatRelative")("dateField","string",["day","week","month","year","hour","minute","second"]),s=e.OraI18nUtils.isoToLocalDate(t),l=e.OraI18nUtils.isoToLocalDate(r);switch(o){case"day":return ee(s,l)?i.day["relative-type-0"]:te(s,l)?i.day["relative-type-1"]:re(s,l)?i.day["relative-type--1"]:se(t,r,n,"day");case"week":return function(e,t,r){if(t>r){var a=t;t=r,r=a}if(!$(t,r)&&!B(t,r))return!1;var n=q(t,r)+J(e,t.getDay());return n>=0&&n<=6}(n,s,l)?i.week["relative-type-0"]:Q(n,s,l)?i.week["relative-type-1"]:function(e,t,r){return Q(e,r,t)}(n,s,l)?i.week["relative-type--1"]:se(t,r,n,"week");case"month":return $(s,l)?i.month["relative-type-0"]:B(s,l)?i.month["relative-type-1"]:B(l,s)?i.month["relative-type--1"]:se(t,r,n,"month");case"year":return X(s,l)?i.year["relative-type-0"]:Y(s,l)?i.year["relative-type-1"]:function(e,t){return Y(t,e)}(s,l)?i.year["relative-type--1"]:se(t,r,n,"year");case"hour":return se(t,r,n,"hour");case"minute":return se(t,r,n,"minute");case"second":return se(t,r,n,"second")}return null}function oe(e){return e.split("-")[0]}function se(t,r,a,n){var i,o,s,l=e.OraI18nUtils.getLocaleElementsMainNodeKey(a),d=e.OraI18nUtils.getLocaleElementsMainNode(a),u=oe(l),m=a.supplemental.plurals,c=d.dates.fields,v=ae(r,t,!1),g=Math.abs(v),h=(o=function(e){return 4800*e/146097}((i=g)/864e5),s=o/12,{year:Math.round(s),month:Math.round(o),week:Math.round(i/6048e5),day:Math.round(i/864e5),hour:Math.round(i/36e5),minute:Math.round(i/6e4),second:Math.round(i/1e3),millisecond:i});if(null===n&&(n=(h.second<k.s?"second":h.minute<k.m&&"minute")||h.hour<k.h&&"hour"||h.day<k.d&&"day"||h.week<k.w&&"week"||h.month<k.M&&"month"||"year"),"second"===n&&h.second<k.s)return c[n]["relative-type-0"];var f="relativeTimePattern-count-"+m[u](h[n]),p=v<0?"relativeTime-type-past":"relativeTime-type-future",y=c[n][p][f];return void 0===y&&(f="relativeTimePattern-count-other",y=c[n][p][f]),y=ne(y,[h[n]])}function le(t,r,a){var n=e.OraI18nUtils.dateToLocalIso(new Date);if("number"==typeof t)t=e.OraI18nUtils.dateToLocalIso(new Date(t));else{if("string"!=typeof t)return null;if(""===e.OraI18nUtils.trim(t))return null}void 0===a&&(a={formatUsing:"displayName"});var i=e.OraI18nUtils.getGetOption(a,"OraDateTimeConverter.formatRelative"),o=i("relativeTime","string",["fromNow","toNow"],"fromNow"),s=i("dateField","string",["day","week","month","year","hour","minute","second"]);if(t=function(t,r,a){var n=a.timeZone;if(e.OraI18nUtils.getISOStrFormatInfo(t).format===D&&void 0===n)return t;var i={isoStrFormat:"zulu"};void 0!==n&&(i.timeZone=n,i.dst=!0);var o=Ce(t,r,i,"en-US");return i={timeZone:e.OraI18nUtils.getLocalTimeZoneOffset(),isoStrFormat:"local"},Ce(o.value,r,i,"en-US").value}(t,r,a),"toNow"===o){var l=n;n=t,t=l}return"calendar"===i("formatUsing","string",["displayName","calendar"],"displayName")?function(t,r,a,n){var i,o,s,l,d=e.OraI18nUtils.getLocaleElementsMainNode(a),u=d.dates.calendars.gregorian.dateTimeFormats.long,m=d.dates.calendars.gregorian.days.format.wide,c=d.dates.fields,v=e.OraI18nUtils.isoToLocalDate(r),g=e.OraI18nUtils.isoToLocalDate(t),h=e.OraI18nUtils.getISOStrFormatInfo(r);if(ee(g,v))i=c.day["relative-type-0"];else if(te(g,v))i=c.day["relative-type-1"];else if(re(g,v))i=c.day["relative-type--1"];else{s=v.getDay(),l=O[s];var f=ae(r,t,!0);if((f/=864e5)<-1&&f>-7)i=c[l]["relative-type--1"];else{if(!(f>1&&f<7))return W(a,{year:"numeric",month:"numeric",day:"numeric"},h,"en-US");i=m[l]}}return n?i:(o=W(a,{hour:"numeric",minute:"numeric"},h,"en-US"),u=ne(u=u.replace(/'/g,""),[o,i]))}(n,t,r,i("dateOnly","boolean",[!0,!1],!1)):void 0!==s?ie(n,t,a,r):se(n,t,r,null)}function de(e,t){var r=new Error("The weekday "+e+" does not match the date "+t),a={errorCode:"dateToWeekdayMismatch",parameterMap:{weekday:e,date:t}};throw r.errorInfo=a,r}function ue(e,t,r){var a,n;2===r?(a='The value "'+e+'" does not match the expected date-time format "'+t+'"',n="datetimeFormatMismatch"):0===r?(a='The value "'+e+'" does not match the expected date format "'+t+'"',n="dateFormatMismatch"):(a='The value "'+e+'" does not match the expected time format "'+t+'"',n="timeFormatMismatch");var i=new Error(a),o={errorCode:n,parameterMap:{value:e,format:t}};throw i.errorInfo=o,i}function me(e,t){if(t<100){var r=e%100;t+=100*Math.floor(e/100)+(t<r?100:0)}return t}function ce(t,r){for(var a={sun:0,mon:1,tue:2,wed:3,thu:4,fri:5,sat:6},n=Object.keys(t),i=0;i<n.length;i++){var o=n[i];if(e.OraI18nUtils.trim(e.OraI18nUtils.toUpper(t[o]))===e.OraI18nUtils.trim(r))return a[o]}return-1}function ve(t,r){for(var a=Object.keys(t),n=0;n<a.length;n++){var i=a[n];if(e.OraI18nUtils.trim(e.OraI18nUtils.toUpper(t[i]))===e.OraI18nUtils.trim(r))return n}return-1}function ge(t,r,a){var n,i,o=e.OraI18nUtils.getLocaleElementsMainNode(t),s=o.dates.calendars.gregorian.days.format,l=o.dates.calendars.gregorian.days["stand-alone"];switch(a){case 0:i=[s.abbreviated,s.wide];break;case 1:i=[l.abbreviated,l.wide]}return r=e.OraI18nUtils.toUpper(r),-1===(n=ce(i[0],r))&&(n=ce(i[1],r)),n}function he(t,r,a){var n,i=-1,o=e.OraI18nUtils.getLocaleElementsMainNode(t),s=o.dates.calendars.gregorian.months.format,l=o.dates.calendars.gregorian.months["stand-alone"];switch(a){case 0:n=[s.wide,s.abbreviated];break;case 1:n=[l.wide,l.abbreviated];break;case 2:n=[s.wide,s.abbreviated,l.wide,l.abbreviated];break;default:return-1}r=e.OraI18nUtils.toUpper(r);for(var d=0;d<n.length;d++)if(-1!==(i=ve(n[d],r)))return i;return i}function fe(e,t,r,a,n,i,o){if(t<r||t>a){var s=new RangeError(n+" is out of range.  Enter a value between "+i+" and "+o+" for "+e),l={errorCode:"datetimeOutOfRange",parameterMap:{value:n,minValue:i,maxValue:o,propertyName:e}};throw s.errorInfo=l,s}}function pe(e,t){for(var r=0;r<e.length;r++)if(void 0!==e[r][t])return r;return 0}function ye(t,r,a,n,i){var o=e.OraI18nUtils.getLocaleElementsMainNode(n).dates.calendars.gregorian.dayPeriods.format.wide.pm;g.lastIndex=0;var s=0,l=0,d=0,u=0,m=g.exec(r);switch(null===m&&ue(r,a,i),void 0!==m[1]&&(s=parseInt(m[1],10)),void 0!==m[2]&&(l=parseInt(m[2],10)),void 0!==m[3]&&(d=parseInt(m[3],10)),void 0!==m[4]&&(u=parseInt(m[4],10)),h.lastIndex=0,(m=h.exec(a))[0]){case"h":12===s&&(s=0),fe("hour",s,0,11,s,1,12),-1!==e.OraI18nUtils.toUpper(r).indexOf(e.OraI18nUtils.toUpper(o))&&s<12&&(s+=12);break;case"K":fe("hour",s,0,11,s,0,11),-1!==e.OraI18nUtils.toUpper(r).indexOf(e.OraI18nUtils.toUpper(o))&&s<12&&(s+=12);break;case"H":fe("hour",s,0,23,s,0,23);break;case"k":24===s&&(s=0),fe("hour",s,0,23,s,1,24)}fe("minute",l,0,59,l,0,59),fe("second",d,0,59,d,0,59),fe("millisec",u,0,999,u,0,999),t.setHours(s,l,d,u)}function Ie(t,r){for(var a=e.OraI18nUtils.getLocaleElementsMainNode(r),n=a.dates.calendars.gregorian.days.format,i=a.dates.calendars.gregorian.days["stand-alone"],o=[n.wide,n.abbreviated,i.wide,i.abbreviated],s=0;s<o.length;s++)for(var l=Object.keys(o[s]),d=0;d<l.length;d++){var u=o[s][l[d]];if(new RegExp(u+"\\b","i").test(t))return u}return null}function Oe(t,r,a,o,s){var l=t;t=e.OraI18nUtils.toUpper(t);var d,u,m,c=e.OraI18nUtils.getLocaleElementsMainNode(o),v=c.dates.calendars.gregorian.months.format,g=c.dates.calendars.gregorian.months["stand-alone"],h=[v.wide,v.abbreviated,g.wide,g.abbreviated],f=!1;for(u=0;u<h.length;u++){d=[];var p,y=Object.keys(h[u]);for(p=0;p<y.length;p++)m=e.OraI18nUtils.toUpper(h[u][y[p]]),d.unshift({idx:p,name:m});for(d.sort(function(e,t){return t.idx-e.idx}),p=0;p<d.length;p++)if(m=d[p].name,-1!==t.indexOf(m)){f=!0,t=t.replace(m,"");break}if(f)break}if(!f)return function(t,r,a,n,o){i.lastIndex=0;var s=i.exec(t);null===s&&ue(t,r,o?2:0);var l,d,u,m,c,v,g=[{y:r.indexOf("y")},{M:r.indexOf("M")},{d:r.indexOf("d")}];g.sort(function(e,t){var r=Object.keys(e)[0],a=Object.keys(t)[0];return e[r]-t[a]});var h=pe(g,"d"),f=!1,p=!1;for(v=1;v<=3;v++){var y=s[v];(y.length>2||y>31)&&(l=y,f=!0,m=v-1)}for(f||(m=pe(g,"y"),l=s[pe(g,"y")+1]),v=0;v<3;v++)if(v!==m&&s[v+1]>12){u=s[v+1],p=!0,c=v;break}if(p){for(v=0;v<3;v++)if(v!==c&&v!==m){d=s[v+1];break}void 0===d&&(d=s[pe(g,"M")+1])}else m===pe(g,"d")?(u=s[pe(g,"y")+1],d=s[pe(g,"M")+1]):m===pe(g,"M")?(u=s[pe(g,"d")+1],d=s[pe(g,"y")+1]):(u=s[pe(g,"d")+1],d=s[pe(g,"M")+1]);d-=1;var I=e.OraI18nUtils._getDaysInMonth(l,d);p&&h!==c&&d>12&&fe("month",u,0,11,u,1,12),fe("month",d,0,11,d+1,1,12),fe("day",u,1,I,u,1,I),fe("year",l=me(C(a),parseInt(l,10)),0,9999,l,0,9999);var O=new Date(l,d,u),k=Ie(t,n);if(null!==k){var T=ge(n,k,0);O.getDay()!==T&&de(k,O.getDate())}var D={value:O,offset:"",warning:"lenient parsing was used"};if(o){var M=t.substr(i.lastIndex);0===M.length?D.value.setHours(0,0,0,0):ye(D.value,M,r,n,2)}return D.value=e.OraI18nUtils.dateToLocalIso(D.value),D}(l,r,a,o,s);var I=he(o,m,2);fe("month",I,0,11,I,1,12);var O=Ie(l,o),k=new RegExp(O+"\\W","i");null!==O&&(t=t.replace(k,"")),n.lastIndex=0;var T=n.exec(t);null===T&&ue(l,r,s?2:0);var D,M,b,E=[{y:r.indexOf("y")},{d:r.indexOf("d")}];E.sort(function(e,t){var r=Object.keys(e)[0],a=Object.keys(t)[0];return e[r]-t[a]});var U=!1;for(u=1;u<=2;u++){var w=T[u];(w.length>2||w>31)&&(D=w,U=!0,b=u-1)}U||(b=pe(E,"y"),D=T[pe(E,"y")+1]),M=b===pe(E,"d")?T[pe(E,"y")+1]:T[pe(E,"d")+1],fe("year",D=me(C(a),parseInt(D,10)),0,9999,D,0,9999);var x=new Date(D,I,M);if(null!==O){var S=ge(o,O,0);x.getDay()!==S&&de(O,x.getDate())}var _=e.OraI18nUtils._getDaysInMonth(D,I);fe("day",M,1,_,M,1,_);var L={value:x,offset:"",warning:"lenient parsing was used"};if(s){var F=t.substr(n.lastIndex);0===F.length?L.value.setHours(0,0,0,0):ye(L.value,F,r,o,2)}return L.value=e.OraI18nUtils.dateToLocalIso(L.value),L}function ke(t,r,a,n){switch(Ee(a,"OraDateTimeConverter.parse")){case 0:return Oe(t,r,a,n,!1);case 1:var i=new Date;return ye(i,t,r,n,1),{value:e.OraI18nUtils.dateToLocalIso(i),offset:"",warning:"lenient parsing was used"};case 2:return Oe(t,r,a,n,!0)}return null}function Te(t,r,a,n,i,o,s,l,d,u,m){var c,v=e.OraI18nUtils.getLocaleElementsMainNode(t).dates.calendars.gregorian[r][i];return fe(m,c="months"===r?he(t,a,o):ge(t,a,o),s,l,a,v[n][d],v[n][u]),c}function De(e,t,r,a){var n=t;n[r.timePart]=e,"h"===a||"hh"===a?12===e&&(n[r.timePart]=0):"k"!==a&&"kk"!==a||24===e&&(n[r.timePart]=0),fe(r.timePart,n[r.timePart],r.start1,r.end1,e,r.start2,r.end2)}function Me(t,r,a,n){var i=e.OraI18nUtils.getLocaleElementsMainNode(n),o=i.dates.calendars.gregorian.eras.eraAbbr[1],s=e.OraI18nUtils.trimNumber(o);t=t.replace(o,s);var l=e.OraI18nUtils.getGetOption(a,"OraDateTimeConverter.parse")("lenientParse","string",["none","full"],"full"),d=Ee(a,"OraDateTimeConverter.parse"),u=function(e,t){for(var r=e.replace(f,"\\\\$1"),a=["^"],n=[],i=0,o=0,s=p.exec(r);null!==s;){var l=r.slice(i,s.index);if(i=p.lastIndex,(o+=F(l,a))%2)a.push(s[0]);else{var d,u=s[0];void 0!==S[u]?d=S[u].regExp:Z(e,t,u),d&&a.push(d),n.push(s[0])}s=p.exec(r)}F(r.slice(i),a),a.push("$");var m={regExp:a.join("").replace(/\s+/g,"\\s+"),groups:n};return m}(r,a),m=new RegExp(u.regExp).exec(t);if(null===m){if("full"===l)return ke(t,r,a,n);ue(t,r,d)}for(var c,v=u.groups,g=null,h=null,y=null,I=null,O="",k=null,T=!1,D={hour:0,minute:0,second:0,millisec:0},M=i.dates.calendars.gregorian.dayPeriods.format.wide.pm,b=C(a),E=0,U=v.length;E<U;E++){var w=m[E+1];if(w){var x=v[E],_=parseInt(w,10),L=S[x];switch(L.token){case"months":h=Te(n,L.token,w,L.mLen,L.style,L.matchIndex,0,11,"1","12","month name");break;case"days":c=w,I=Te(n,L.token,w,L.dLen,L.style,L.matchIndex,0,6,"sun","sat","weekday");break;case"time":De(_,D,L,x);break;case"dayOfMonth":if((y=_)>31&&"full"===l)try{return ke(t,r,a,n)}catch(t){var N=e.OraI18nUtils._getDaysInMonth(g,h);fe("day",y,1,N,y,1,N)}break;case"monthIndex":if((h=_-1)>11&&"full"===l)try{return ke(t,r,a,n)}catch(e){fe("month",h,0,11,h+1,1,12)}break;case"year":fe("year",g=me(b,_),0,9999,g,0,9999);break;case"ampm":T=-1!==e.OraI18nUtils.toUpper(w).indexOf(e.OraI18nUtils.toUpper(M));break;case"tzhm":O=w.substr(-2),O=w.substr(0,3)+":"+O;break;case"tzhsepm":O=w;break;case"tzh":O=w+":00";break;case"tzid":k=w}}}var j=new Date;null===g&&(g=j.getFullYear()),null===h&&null===y?(h=j.getMonth(),y=j.getDate()):null===y&&(y=1),fe("month",h,0,11,h+1,1,12);var z=e.OraI18nUtils._getDaysInMonth(g,h);fe("day",y,1,z,y,1,z),j.setFullYear(g,h,y),null!==I&&j.getDay()!==I&&de(c,j.getDate()),T&&D.hour<12&&(D.hour+=12);var P=[g,h+1,y,D.hour,D.minute,D.second,D.millisec],V=e.OraI18nUtils.partsToIsoString(P);if(null!==k){var G=A(k,n),R=H(G,P,!1,!0,!0);O=-G.ofset(R),O=e.OraI18nUtils.getTimeStringFromOffset("",O,!1,!0)}return""!==O&&(V+=O),{value:V}}function be(e,t,r){for(var a=r.replace(f,"\\\\$1"),n=["^"],i=0,o=0,s={locale:e,numberingSystem:t,calendar:"gregorian"},l=p.exec(a);null!==l;){var d=a.slice(o,l.index);if(o=p.lastIndex,(i+=F(d,n))%2==0){var u=l[0];"/"!==u&&"zzzz"!==u&&"zzz"!==u&&"zz"!==u&&"z"!==u&&(void 0!==S[u]?(void 0!==S[u].key&&(s[S[u].key]=S[u].value),"kk"===u||"HH"===u||"H"===u||"k"===u?s.hour12=!1:"KK"!==u&&"hh"!==u&&"h"!==u&&"K"!==u||(s.hour12=!0)):Z(r,s,u))}l=p.exec(a)}return s}function Ee(t,r){if(void 0!==t.pattern)return function(e){var t=be("","",e),r=void 0!==t.year||void 0!==t.month||void 0!==t.weekday||void 0!==t.day,a=void 0!==t.hour||void 0!==t.minute||void 0!==t.second||void 0!==t.millisecond;return r&&a?2:a?1:0}(t.pattern);var a=e.OraI18nUtils.getGetOption(t,r),n=void 0!==a("hour","string",["2-digit","numeric"])||void 0!==a("minute","string",["2-digit","numeric"])||void 0!==a("second","string",["2-digit","numeric"])||void 0!==a("millisecond","string",["numeric"]),i=void 0!==a("year","string",["2-digit","numeric"])||void 0!==a("month","string",["2-digit","numeric","narrow","short","long"])||void 0!==a("day","string",["2-digit","numeric"])||void 0!==a("weekday","string",["narrow","short","long"]);if(i&&n)return 2;if(n)return 1;if(i)return 0;var o=a("formatType","string",["date","time","datetime"],"date");return"datetime"===o?2:"time"===o?1:0}function Ue(e,t){var r=H(e,t,!1,!0,!1),a=e.ofset(r),n=e.ofset(r+1);return Math.max(a,n)}function we(t,r,a){var n,i,o,s,l=t.isoStrParts,d=t.format,u=A(r.timeZone,a);switch(n=Date.UTC(l[0],l[1]-1,l[2],l[3],l[4],l[5]),d){case E:var m=K(t.timeZone),c=m[0],v=m[1];i=60*c+(c<0?-v:v);break;case T:i=0}n-=6e4*((o=Ue(u,l))+i);var g=e.OraI18nUtils.getGetOption(r,"OraDateTimeConverter")("dst","boolean",[!0,!1],!1),h=0===t.dateTime.indexOf("T");s=u.parse(n,g,!h,!1),o=-u.ofset(s),o-=i;var f=new Date(Date.UTC(l[0],l[1]-1,l[2],l[3],l[4],l[5])),p=f.getUTCMinutes()+o;f.setUTCHours(f.getUTCHours()+(p/60<<0),p%60),l[0]=f.getUTCFullYear(),l[1]=f.getUTCMonth()+1,l[2]=f.getUTCDate(),l[3]=f.getUTCHours(),l[4]=f.getUTCMinutes(),l[5]=f.getUTCSeconds()}function xe(t,r){var a,n="";switch(t){case 0:n=e.OraI18nUtils.padZeros(r[0],4)+"-"+e.OraI18nUtils.padZeros(r[1],2)+"-"+e.OraI18nUtils.padZeros(r[2],2);break;case 1:n="T"+e.OraI18nUtils.padZeros(r[3],2)+":"+e.OraI18nUtils.padZeros(r[4],2)+":"+e.OraI18nUtils.padZeros(r[5],2),(a=r[6])>0&&(n+="."+e.OraI18nUtils.trimRightZeros(e.OraI18nUtils.padZeros(a,3)));break;default:n=e.OraI18nUtils.padZeros(r[0],4)+"-"+e.OraI18nUtils.padZeros(r[1],2)+"-"+e.OraI18nUtils.padZeros(r[2],2)+"T"+e.OraI18nUtils.padZeros(r[3],2)+":"+e.OraI18nUtils.padZeros(r[4],2)+":"+e.OraI18nUtils.padZeros(r[5],2),(a=r[6])>0&&(n+="."+e.OraI18nUtils.trimRightZeros(e.OraI18nUtils.padZeros(a,3)))}return n}function Se(t,r,a,n,i,o){var s=A(t,i),l=H(s,r,a,n,o),d=s.ofset(l);return e.OraI18nUtils.getTimeStringFromOffset("",d,!0,!0)}function Ce(t,r,a,n){var i,o,s=e.OraI18nUtils.getNumberingExtension(n);if(void 0===e.OraI18nUtils.numeringSystems[s]&&(s="latn"),"latn"!==s){for(var l=[],d=0;d<t.length;d++){var u=e.OraI18nUtils.numeringSystems[s].indexOf(t[d]);-1!==u?l.push(u):l.push(t[d])}t=l.join("")}(arguments.length<=2||void 0===a)&&(a={year:"numeric",month:"numeric",day:"numeric"});var m,c,v,g={};return!0===e.OraI18nUtils._ISO_DATE_REGEXP.test(t)?(m=t,i=-1===(v=t.indexOf("T"))?0:v>0?2:1):(o=a.pattern||P(a,r,n,"OraDateTimeConverter.parse"),i=Ee(a,"OraDateTimeConverter.parse"),m=(g=Me(t,o,a,r)).value),c=e.OraI18nUtils.getISOStrFormatInfo(m),void 0!==a.timeZone&&c.format!==D&&we(c,a,r),m=function(t,r,a,n){var i,o,s,l=e.OraI18nUtils.getGetOption(a,"OraDateTimeConverter.parse"),d=l("isoStrFormat","string",[T,E,b,D,M],M),u=l("dst","boolean",[!0,!1],!1),m=!0,c=r.isoStrParts,v=r.timeZone,g=a.timeZone,h=r.format,f=a.isoStrFormat,p=xe(t,c);if(0===t||"local"===f)return p;switch(1===t&&(m=!1),d){case E:void 0===g&&h===E?p+=v:void 0===g&&h===D?p+="":void 0===g&&h===T?p+="+00:00":void 0!==g&&(p+=s=Se(g,c,u,m,n,!0));break;case T:var y=0;if(void 0===g){if(h===E){s=v.split(":");var I=parseInt(s[0],10),O=parseInt(s[1],10);y=-(y=60*I+(e.OraI18nUtils.startsWith(s[0],"-")?-O:O))}}else o=H(i=A(g,n),c,u,m,!0),y=s=i.ofset(o);if(0!==y){var k=new Date(Date.UTC(c[0],c[1]-1,c[2],c[3],c[4],c[5],c[6]));y=k.getUTCMinutes()+y,k.setUTCHours(k.getUTCHours()+(y/60<<0),y%60),c[0]=k.getUTCFullYear(),c[1]=k.getUTCMonth()+1,c[2]=k.getUTCDate(),c[3]=k.getUTCHours(),c[4]=k.getUTCMinutes(),c[5]=k.getUTCSeconds(),p=xe(t,c)}p+="Z";break;case M:void 0!==g?p+=s=Se(g,c,u,m,n,!0):(s=v)&&(p+=s)}return p}(i,c,a,r),g.value=m,g}function _e(e,t,r,a,n,i,o,s){var d={locale:s,numberingSystem:o,calendar:"gregorian"};if(0===Object.keys(e).length)return d.year="numeric",d.month="numeric",d.day="numeric",d.lenientParse="full",d;void 0!==r&&(d.timeZone=r,void 0!==n&&(d.isoStrFormat=n)),function(e,t){var r=t,a=e("formatUsing","string",["displayName","calendar"]);void 0!==a&&(r.formatUsing=a),void 0!==(a=e("dateField","string",["day","week","month","year","hour","minute","second"]))&&(r.dateField=a),void 0!==(a=e("relativeTime","string",["fromNow","toNow"]))&&(r.relativeTime=a),void 0!==(a=e("dateOnly","boolean",[!0,!1]))&&(r.dateOnly=a)}(t,d);var u=function(e,t,r,a){var n,i=t,o=!1;return void 0!==r&&(i.dst=r),void 0!==(n=e("year","string",["2-digit","numeric"]))&&(i.year=n,o=!0),void 0!==(n=e("era","string",["narrow","short","long"]))&&(i.era=n,o=!0),void 0!==(n=e("month","string",["2-digit","numeric","narrow","short","long"]))&&(i.month=n,o=!0),void 0!==(n=e("day","string",["2-digit","numeric"]))&&(i.day=n,o=!0),void 0!==(n=e("weekday","string",["narrow","short","long"]))&&(i.weekday=n,o=!0),void 0!==(n=e("hour","string",["2-digit","numeric"]))&&(i.hour=n,o=!0,void 0===(n=e("hour12","boolean",[!0,!1]))&&(n=_(a)),i.hour12=n),void 0!==(n=e("minute","string",["2-digit","numeric"]))&&(i.minute=n,o=!0),void 0!==(n=e("second","string",["2-digit","numeric"]))&&(i.second=n,o=!0),void 0!==(n=e("millisecond","string",["numeric"]))&&(i.millisecond=n,o=!0),o}(t,d,a,i);if(d["two-digit-year-start"]=C(e),!u)return function(e,t,r,a){var n=e,i=L(t,r,l.resolvedOptions),o=a("formatType","string",["date","time","datetime"],"date"),s=a("dateFormat","string",["short","medium","long","full"],"short"),d=a("timeFormat","string",["short","medium","long","full"],"short");n.formatType=o,"datetime"!==o&&"date"!==o||(n.dateFormat=s),"datetime"!==o&&"time"!==o||(n.timeFormat=d),n.patternFromOptions=i,n.lenientParse=a("lenientParse","string",["none","full"],"full")}(d,e,i,t),d;if(void 0!==r){var m=t("timeZoneName","string",["short","long"]);void 0!==m&&(d.timeZoneName=m)}return d.lenientParse=t("lenientParse","string",["none","full"],"full"),d.patternFromOptions=P(d,i,s,"OraDateTimeConverter.resolvedOptions"),d}function Le(t,r,a){var n,i,o;(arguments.length<3||void 0===a)&&(a=e.OraI18nUtils.getLocaleElementsMainNodeKey(t)),(arguments.length<2||void 0===r)&&(r={year:"numeric",month:"numeric",day:"numeric"});var s=e.OraI18nUtils.getGetOption(r,"OraDateTimeConverter.resolvedOptions");void 0!==r&&(i=s("isoStrFormat","string",[T,E,b,D,M],M),o=s("dst","boolean",[!0,!1],!1),n=r.timeZone);var l=e.OraI18nUtils.getNumberingExtension(a);return void 0===e.OraI18nUtils.numeringSystems[l]&&(l="latn"),void 0!==r&&void 0!==r.pattern?function(e,t,r,a,n,i,o){var s=be(a,n,i.pattern);return s.pattern=i.pattern,void 0!==e&&(s.isoStrFormat=e),void 0!==t&&(s.timeZone=t),void 0!==r&&(s.dst=r),s["two-digit-year-start"]=C(i),s.lenientParse=o("lenientParse","string",["none","full"],"full"),s}(i,n,o,a,l,r,s):void 0!==r?_e(r,s,n,o,i,t,l,a):function(e,t,r){return{calendar:"gregorian",locale:t,numberingSystem:r,year:"numeric",month:"numeric",day:"numeric",patternFromOptions:P({year:"numeric",month:"numeric",day:"numeric"},e,t,"OraDateTimeConverter.resolvedOptions"),lenientParse:"full"}}(t,a,l)}function Fe(){return{format:function(t,r,a,n){var i;if("number"==typeof t)i=e.OraI18nUtils.dateToLocalIso(new Date(t));else{if("string"!=typeof t)return null;if(""===(i=e.OraI18nUtils.trim(t)))return null}(arguments.length<=2||void 0===a)&&(a={year:"numeric",month:"numeric",day:"numeric"});var o=W(r,a,e.OraI18nUtils.getISOStrFormatInfo(i),n),s=e.OraI18nUtils.getNumberingExtension(n);if(void 0===e.OraI18nUtils.numeringSystems[s]&&(s="latn"),"latn"!==s){for(var l=[],d=0;d<o.length;d++)o[d]>="0"&&o[d]<="9"?l.push(e.OraI18nUtils.numeringSystems[s][o[d]]):l.push(o[d]);return l.join("")}return o},formatRelative:function(e,t,r){return le(e,t,r)},parse:function(e,t,r,a){return Ce(e,t,r,a)},resolvedOptions:function(e,t,r){return Le(e,t,r)},calculateWeek:function(t){var r,a=e.OraI18nUtils.isoToLocalDate(t),n=new Date(a.getTime());return n.setDate(n.getDate()+4-(n.getDay()||7)),r=n.getTime(),n.setMonth(0),n.setDate(1),Math.floor(Math.round((r-n)/864e5)/7)+1},getAvailableTimeZones:function(t){return function(t){var r=d.getInstance(),n={sensitivity:"variant"},i=e.OraI18nUtils.getLocaleElementsMainNodeKey(t),o=e.OraI18nUtils.getLocaleElementsMainNode(t),s=o.dates.timeZoneNames.metazone,l=o.dates.timeZoneNames.zone,u=[],m={},c=t.supplemental.timeZoneData,v=new Date,g=[v.getFullYear(),v.getMonth()+1,v.getDate(),v.getHours(),v.getMinutes(),v.getSeconds()];function h(r,a,n,i){var o=r.split("/"),s=o[0],l=o[1],d="",u="",m={},c=i[s];void 0!==c&&void 0!==(d=c[l])&&void 0!==(d=d.exemplarCity)&&(d=" "+d);var v=s+"/"+l,h=t.supplemental.metazones,f=G(g,v,h);void 0!==n&&(f=n[f]),null!=f&&void 0!==f.long&&(void 0===(u=f.long.generic)&&(u=f.long.standard),void 0!==u&&(u=" - "+u));var p="("+U+")";return 0!==a&&(p="("+(p=e.OraI18nUtils.getTimeStringFromOffset(U,a,!0,!0))+")"),void 0===d||void 0===u?null:(m.offsetLocName=p+d+u,m.locName=d+u,m)}function f(e){for(var a,n=Object.keys(e),i=0;i<n.length;i++){var o=n[i],d=h(o,a=Ue(r.getZone(o,t),g),s,l);null!==d&&u.push({id:o,displayName:d}),m[o]=a}}var p=e.OraI18nUtils.getLocaleElementsMainNodeKey(t);if(void 0!==a[p]){var y=a[p].availableTimeZones;if(void 0!==y)return y}f(c.zones),f(c.links),u.sort(function(e,t){return m[t.id]-m[e.id]+e.displayName.locName.localeCompare(t.displayName.locName,i,n)});for(var I=u.length,O=0;O<I;O++)u[O].displayName=u[O].displayName.offsetLocName;return void 0===a[p]&&(a[p]={},a[p].availableTimeZones=u),u}(t)},compareISODates:function(t,r,a){var n=function(t,r){var a={isoStrFormat:D},n=e.OraI18nUtils.getISOStrFormatInfo(t),i=e.OraI18nUtils.getISOStrFormatInfo(r),o=n.format,s=i.format;return o===D||s===D?a:(a.isoStrFormat=T,a)}(t,r),i=Ce(t,a,n,"en-US"),o=Ce(r,a,n,"en-US"),s=i.value.replace("Z",""),l=o.value.replace("Z",""),d=e.OraI18nUtils._IsoStrParts(s);d=Date.UTC(d[0],d[1]-1,d[2],d[3],d[4],d[5],d[6]);var u=e.OraI18nUtils._IsoStrParts(l);return d-(u=Date.UTC(u[0],u[1]-1,u[2],u[3],u[4],u[5],u[6]))},isHour12:function(e){return _(e)},getTimePositioning:function(t,r,a){var n=Le(t,r,a),i=n.pattern||n.patternFromOptions;i=(i=i.replace(/'[^']*'/g,"").replace(/[^hHkKma]*/g,"")).replace(/(h|H|k|K)+/,"h").replace(/m+/,"m");var o=oe(e.OraI18nUtils.getLocaleElementsMainNodeKey(t)),s="ar"===o||"he"===o,l={},d=0,u=i.length;for(d=0;d<u;d++)l[i.charAt(d)]=d;return s&&(d=l.h,l.h=l.m,l.m=d),l}}}return{getInstance:function(){return t||(t=Fe()),t}}}();var d=function(){var e,t={},r=/^Etc\/GMT/i,a=6e4,n=60*a,i=-840,o=720,s="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWX",l=1e-6;function d(e,t){for(var r="",a=Math.abs(e),n=Math.floor(a),i=function(e,t){for(var r=".",a="";t>0;){t-=1,e*=60;var n=Math.floor(e+l);r+=s[n],e-=n,n&&(a+=r,r="")}return a}(a-n,Math.min(t,10));n>0;)r=s[n%60]+r,n=Math.floor(n/60);return e<0&&(r="-"+r),r&&i?r+i:(i||"-"!==r)&&(r||i)||"0"}function u(e){return e>96?e-87:e>64?e-29:e-48}function m(e){var t=0,r=e.split("."),a=r[0],n=r[1]||"",i=1,o=0,s=1;for(45===e.charCodeAt(0)&&(t=1,s=-1);t<a.length;t++)o=60*o+u(a.charCodeAt(t));for(t=0;t<n.length;t++)i/=60,o+=u(n.charCodeAt(t))*i;return o*s}function c(e){for(var t=0;t<e.length;t++)e[t]=m(e[t])}function v(e,t){for(var r=[],a=0;a<t.length;a++)r[a]=e[t[a]];return r}function g(e,t){var r=t.split("|"),n=r[1].split(" "),i=r[2].split(""),o=r[3].split(" ");return c(n),c(i),c(o),function(e,t){for(var r=0;r<t;r++)e[r]=Math.round((e[r-1]||0)+e[r]*a);e[t-1]=1/0}(o,i.length),{name:e,abbrs:v(r[0].split(" "),i),offsets:v(n,i),untils:o}}function h(){var e=new Error("The input time does not exist because it falls during the transition to daylight saving time.");throw e.errorInfo={errorCode:"nonExistingTime"},e}function f(e,t){var a=t.zones[e];if(r.test(e)){var n=e.replace(r,"").split(":"),s=60*parseInt(n[0],10),l=0;if(isNaN(s))return;if(2===n.length&&(l=parseInt(n[1],10),isNaN(l)))return;if((s+=s>=0?l:-l)<i||s>o)return;s=d(s,1),a=e.replace("/etc//i","").toUpperCase()+"|"+s+"|0|"}void 0!==a&&this._set(g(e,a))}function p(e){return(e||"").toLowerCase().replace(/\//g,"_")}function y(e,r){var a=p(e);return void 0===t[a]&&function(e,r){var a=new f(e,r),n=p(a.name);t[n]=a}(e,r),t[p(e)]||null}function I(){return{getZone:function(e,t){var r=t.supplemental.timeZoneData;void 0===r&&function(){var e=new Error("TimeZone data is missing. Please call require 'ojs/ojtimezonedata' in order to load the TimeZone data.");throw e.errorInfo={errorCode:"missingTimeZoneData"},e}();var a=y(e,r);if(!a){var n=r.links[e];n&&(a=y(n,r))}return a||function(e){var t=new Error("invalid timeZone ID: "+e),r={errorCode:"invalidTimeZoneID",parameterMap:{timeZoneID:e}};throw t.errorInfo=r,t}(e),a}}}return f.prototype={_set:function(e){this.name=e.name,this.abbrs=e.abbrs,this.untils=e.untils,this.offsets=e.offsets},parse:function(e,t,r,i){for(var o=this.offsets,s=this.untils,l=s.length-1,d=0;d<l;d++){var u=o[d],m=o[d+1],c=s[d],v=c-u*a,g=v-n;if(e>=v&&e<v+n&&u>m){if(!0!==i)return d+1;h()}if(e>=g&&e<v&&u<m)return t?d:d+1;if(e<c-u*a)return!1===r?t?u<m?d:d+1:u<m?d+1:d:d}return l},abbr:function(e){return this.abbrs[e]},ofset:function(e){var t=this.offsets.length;return e>=0&&e<t?parseInt(this.offsets[e],10):parseInt(this.offsets[t-1],10)},len:function(){return this.offsets.length}},{getInstance:function(){return e||(e=I()),e}}}(),u={};return u.DateRestrictionValidator=e.DateRestrictionValidator,u.DateTimeConverter=e.DateTimeConverter,u.DateTimeRangeValidator=e.DateTimeRangeValidator,u.IntlDateTimeConverter=e.IntlDateTimeConverter,u});