/**
 * Copyright (c) 2017, Oracle and/or its affiliates.
 * All rights reserved.
 */

/**
 * Copyright (c) 2014-2016 GitHub, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.prototype
 */

define("persist/impl/logger",[],function(){"use strict";function e(){Object.defineProperty(this,"LEVEL_NONE",{value:0,enumerable:!0}),Object.defineProperty(this,"LEVEL_ERROR",{value:1,enumerable:!0}),Object.defineProperty(this,"LEVEL_WARN",{value:2,enumerable:!0}),Object.defineProperty(this,"LEVEL_INFO",{value:3,enumerable:!0}),Object.defineProperty(this,"LEVEL_LOG",{value:4,enumerable:!0}),Object.defineProperty(this,"_METHOD_ERROR",{value:"error"}),Object.defineProperty(this,"_METHOD_WARN",{value:"warn"}),Object.defineProperty(this,"_METHOD_INFO",{value:"info"}),Object.defineProperty(this,"_METHOD_LOG",{value:"log"}),Object.defineProperty(this,"_defaultOptions",{value:{level:this.LEVEL_ERROR,writer:null}}),Object.defineProperty(this,"_options",{value:this._defaultOptions,writable:!0})}function t(e,r,i,s){var o=e;if(o.option("level")<r)return;var u=n(o);if(u!=null){if(s.length==1&&s[0]instanceof Function){var a=s[0]();s=[a]}u[i]&&u[i].apply?u[i].apply(u,s):u[i]&&(u[i]=Function.prototype.bind.call(u[i],u),t(o,r,i,s))}}function n(e){var t=e,n=null;return t.option("writer")?n=t.option("writer"):typeof window!="undefined"&&window.console!==undefined?n=window.console:typeof console!="undefined"&&(n=console),n}return e.prototype.error=function(e){t(this,this.LEVEL_ERROR,this._METHOD_ERROR,arguments)},e.prototype.info=function(e){t(this,this.LEVEL_INFO,this._METHOD_INFO,arguments)},e.prototype.warn=function(e){t(this,this.LEVEL_WARN,this._METHOD_WARN,arguments)},e.prototype.log=function(e){t(this,this.LEVEL_LOG,this._METHOD_LOG,arguments)},e.prototype.option=function(e,t){var n={},r;if(arguments.length==0){for(r in this._options)this._options.hasOwnProperty(r)&&(n[r]=this._options[r]);return n}if(typeof e=="string"&&t===undefined)return this._options[e]===undefined?null:this._options[e];if(typeof e=="string")this._options[e]=t;else{var i=e;for(r in i)i.hasOwnProperty(r)&&this.option(r,i[r])}},new e}),define("persist/persistenceUtils",["./impl/logger"],function(e){"use strict";function t(e){return e.headers.has("x-oracle-jscpt-cache-expiration-date")}function n(e){return e.headers.has("x-oracle-jscpt-etag-generated")}function r(e,n){var r=n.headers.get("Content-Type"),s=e.responseType;return i(n.headers)?"text":t(n)||s==="blob"?"blob":r&&r.indexOf("image/")!==-1||s==="arraybuffer"?"arraybuffer":r&&r.indexOf("multipart/form-data")!==-1?"multipart":"text"}function i(e){var t=e.get("Content-Type");return t&&(t.match(/.*text\/.*/)||t.match(/.*application\/.*json.*/))?!0:!1}function s(e){var t=e.get("Content-Type");return t&&t.indexOf("multipart/")!==-1}function o(t,n){e.log("Offline Persistence Toolkit persistenceUtils: requestToJSON()");if(!n||!n._noClone)t=t.clone();var r={};return u(t,r,["body","headers","signal"]),r.headers=f(t.headers),c(t,r)}function u(e,t,n){for(var r in e)typeof e[r]!="function"&&!a(r)&&n.indexOf(r)===-1&&(t[r]=e[r])}function a(e){return e.indexOf("_")===0}function f(e){var t={};if(e.entries){var n=e.entries(),r,i,s;do r=n.next(),r.value&&(i=r.value[0],s=r.value[1],t[i]=s);while(!r.done)}else e.forEach&&e.forEach(function(e,n){t[n]=e});return l(t),t}function l(t){var n=t.date;n||(e.log("Offline Persistence Toolkit persistenceUtils: Setting HTTP date header since it's null or not exposed"),n=(new Date).toUTCString(),t.date=n)}function c(e,t){return t.body={},e instanceof Request&&s(e.headers)?h(e,t):e instanceof Request||i(e.headers)?e.text().then(function(e){return t.body.text=e,t}):e instanceof Request||typeof e.arrayBuffer!="function"?Promise.reject(new Error({message:"payload body type is not supported"})):e.arrayBuffer().then(function(e){return e.byteLength>0&&(t.body.arrayBuffer=e),t})}function h(t,n){e.log("Offline Persistence Toolkit persistenceUtils: Copying multipart payload");if(typeof t.formData=="function")return t.formData().then(function(e){var t={},r=e.entries(),i,s,o,u;do i=r.next(),s=i.value,s&&(o=s[0],u=s[1],t[o]=u);while(!i.done);return n.body.formData=t,n});var r=t.headers.get("Content-Type");return t.text().then(function(e){var t=E(e,r),i={};for(var s=0;s<t.length;s++)i[t[s].headers.name]=t[s].data;return n.body.formData=i,n})}function p(t,n){e.log("Offline Persistence Toolkit persistenceUtils: responseToJSON()");if(!n||!n._noClone)t=t.clone();var r={};return u(t,r,["body","headers"]),r.headers=f(t.headers),n&&n.excludeBody?Promise.resolve(r):c(t,r)}function d(t){e.log("Offline Persistence Toolkit persistenceUtils: requestFromJSON()");var n={};u(t,n,["headers","body","signal"]);var r=v(t,n);return n.headers=m(t,r),g(t,n)}function v(e,t){var n=!1,r=e.body;if(r.text&&r.text.length>0)t.body=r.text;else if(r.arrayBuffer)t.body=r.arrayBuffer;else if(r.formData){n=!0;var i=new FormData,s=r.formData;Object.keys(s).forEach(function(e){i.append(e,s[e])}),t.body=i}return n}function m(e,t){var n=new Headers;return Object.keys(e.headers).forEach(function(r){(r!=="content-type"||!t&&r==="content-type")&&n.append(r,e.headers[r])}),n}function g(e,t){return Promise.resolve(new Request(e.url,t))}function y(t){e.log("Offline Persistence Toolkit persistenceUtils: responseFromJSON()");var n={};return u(t,n,["headers","body"]),n.headers=m(t,!1),b(t,n)}function b(e,t){var n,r=e.body;return r&&r.text?n=new Response(r.text,t):r&&r.arrayBuffer?(t.responseType="blob",n=new Response(r.arrayBuffer,t)):r&&r.blob?(t.responseType="blob",n=new Response(r.blob,t)):n=new Response(null,t),Promise.resolve(n)}function w(t,n){return e.log("Offline Persistence Toolkit persistenceUtils: setResponsePayload()"),p(t).then(function(e){var t=e.body;return t.arrayBuffer=null,t.blob=null,t.text=null,n instanceof ArrayBuffer?t.arrayBuffer=n:n instanceof Blob?t.blob=n:t.text=JSON.stringify(n),y(e)})}function E(t,n){e.log("Offline Persistence Toolkit persistenceUtils: parseMultipartFormData()");var r=n.match(/boundary=(?:"([^"]+)"|([^;]+))/i);if(!r)throw new Error("not a valid multipart form data value.");var i=function(e){var t={},n={},r=e.split("\r\n");for(var i=0;i<r.length;i++){var s=r[i];if(s.length===0)continue;var o=s.split(";");if(o.length===1&&o[0].indexOf("Content-Type")===0)t.contentType=o[0].split(":")[1].trim();else for(var u=0;u<o.length;u++){if(o[u].indexOf("=")===-1)continue;var a=o[u].split("=");n[a[0].trim()]=a[1].substring(1,a[1].length-1)}}return t.headers=n,t},s=function(e,t){var n=e.split("\r\n");return t&&t.indexOf("image")>=0?o(n[0],t):n[0]},o=function(e,t){var n=null;try{n=atob(e)}catch(r){return null}var i=new ArrayBuffer(n.length),s=new Uint8Array(i);for(var o=0;o<n.length;o++)s[o]=n.charCodeAt(o);var u=new Blob([i],{type:t});return u},u=r[1]||r[2],a=typeof t=="string",f;if(a)f=t;else{var l=new Uint8Array(t);f=String.fromCharCode.apply(null,l)}var c=f.split(new RegExp(u)),h=[];for(var p=1;p<c.length-1;p++){var d={},v=c[p],m=v.split("\r\n\r\n"),g=m[0],y=m[1],b=i(g);d.headers=b.headers,d.data=s(y,b.contentType),h.push(d)}return h}function S(t){e.log("Offline Persistence Toolkit persistenceUtils: buildEndpointKey() for Request with url: "+t.url);var n={url:t.url,id:Math.random().toString(36).replace(/[^a-z]+/g,"")};return JSON.stringify(n)}function x(e){return o(e,{_noClone:!0}).then(function(e){return d(e).then(function(e){return e})})}function T(e,t){return t=t||{},p(e,{_noClone:!0}).then(function(e){return y(e).then(function(e){return t.url!=null&&t.url.length>0&&e.headers.get("x-oracle-jscpt-response-url")==null&&e.headers.set("x-oracle-jscpt-response-url",t.url),e})})}return{requestToJSON:o,requestFromJSON:d,responseToJSON:p,responseFromJSON:y,setResponsePayload:w,parseMultipartFormData:E,isCachedResponse:t,isGeneratedEtagResponse:n,_isTextPayload:i,buildEndpointKey:S,_cloneRequest:x,_cloneResponse:T,_derivePayloadType:r}}),define("persist/impl/PersistenceXMLHttpRequest",["../persistenceUtils","./logger"],function(e,t){"use strict";function n(e){var t=this;Object.defineProperty(this,"_eventListeners",{value:[],writable:!0}),Object.defineProperty(this,"_browserXMLHttpRequest",{value:e}),Object.defineProperty(this,"_method",{value:null,writable:!0}),Object.defineProperty(this,"onabort",{value:null,enumerable:!0,writable:!0}),Object.defineProperty(this,"onerror",{value:null,enumerable:!0,writable:!0}),Object.defineProperty(this,"onload",{value:null,enumerable:!0,writable:!0}),Object.defineProperty(this,"onloadend",{value:null,enumerable:!0,writable:!0}),Object.defineProperty(this,"onloadstart",{value:null,enumerable:!0,writable:!0}),Object.defineProperty(this,"onprogress",{value:null,enumerable:!0,writable:!0}),Object.defineProperty(this,"onreadystatechange",{value:null,enumerable:!0,writable:!0}),Object.defineProperty(this,"ontimeout",{value:null,enumerable:!0,writable:!0}),Object.defineProperty(this,"_password",{value:null,writable:!0}),Object.defineProperty(this,"_readyState",{value:0,writable:!0}),Object.defineProperty(this,"readyState",{enumerable:!0,get:function(){return t._readyState}}),Object.defineProperty(this,"_requestHeaders",{value:{},writable:!0}),Object.defineProperty(this,"_response",{value:"",writable:!0}),Object.defineProperty(this,"response",{enumerable:!0,get:function(){return t._response}}),Object.defineProperty(this,"_responseHeaders",{value:{},writable:!0}),Object.defineProperty(this,"_responseText",{value:"",writable:!0}),Object.defineProperty(this,"responseText",{enumerable:!0,get:function(){return t._responseText}}),Object.defineProperty(this,"responseType",{value:"",enumerable:!0,writable:!0}),Object.defineProperty(this,"_responseURL",{value:"",writable:!0}),Object.defineProperty(this,"responseURL",{enumerable:!0,get:function(){return t._responseURL}}),Object.defineProperty(this,"_responseXML",{value:null,writable:!0}),Object.defineProperty(this,"responseXML",{enumerable:!0,get:function(){return t._responseXML}}),Object.defineProperty(this,"_status",{value:0,writable:!0}),Object.defineProperty(this,"status",{enumerable:!0,get:function(){return t._status}}),Object.defineProperty(this,"_statusText",{value:"",writable:!0}),Object.defineProperty(this,"statusText",{enumerable:!0,get:function(){return t._statusText}}),Object.defineProperty(this,"timeout",{value:0,enumerable:!0}),Object.defineProperty(this,"upload",{value:null,enumerable:!0}),Object.defineProperty(this,"_url",{value:null,writable:!0}),Object.defineProperty(this,"_username",{value:null,writable:!0}),Object.defineProperty(this,"withCredentials",{value:!1,enumerable:!0,writable:!0})}function r(e,t){e._readyState=t,e.dispatchEvent(new l("readystatechange")),e._readyState==n.DONE&&(e.dispatchEvent(new l("load",!1,!1,e)),e.dispatchEvent(new l("loadend",!1,!1,e)))}function i(e){var t=e.toLowerCase();if(t.indexOf("http:")===0||t.indexOf("https:")===0)return!1;if(t.indexOf("file:")===0||t.indexOf("cdvfile:")===0)return!0;if(URL&&URL.prototype){t=(new URL(e,window.location.href)).origin;if(t!=null&&t!="null"&&t.length>0)return t.toLowerCase().indexOf("file:")===0?!0:!1}var n=document.createElement("a");return n.href=e,t=n.protocol,t&&t.toLowerCase().indexOf("file:")===0?!0:!1}function s(e){function n(n){t.append(n,e._requestHeaders[n])}var t=new Headers;return Object.keys(e._requestHeaders).forEach(n),t}function o(e,t){var n=s(e),r=e.withCredentials?"include":"same-origin",i={method:e._method,headers:n,mode:"cors",cache:"default",credentials:r};return e._method!=="GET"&&e._method!=="HEAD"&&e._method!=="DELETE"&&(i.body=t),i}function u(i,s,o){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: Processing Response"),a(i,o.headers);var u=o.headers.get("Content-Type");i._status=o.status,i._statusText=o.statusText,i._responseURL=s.url;var f=e._derivePayloadType(i,o);if(f==="blob")t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: Calling response.blob()"),o.blob().then(function(e){i._responseType="blob",i._response=e,r(i,n.DONE),typeof i.onload=="function"&&i.onload()},function(e){t.error(e)});else if(f==="arraybuffer")t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: Calling response.arrayBuffer()"),o.arrayBuffer().then(function(e){i._responseType="arrayBuffer",i._response=e,r(i,n.DONE),typeof i.onload=="function"&&i.onload()},function(e){t.error("error reading response as arrayBuffer!")});else if(f==="multipart"){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: Calling response.formData()"),i._responseType="formData";var l=function(t){var s="",o=e.parseMultipartFormData(t,u);o.forEach(function(e){s+=e.data}),i._response=s,i._responseText=s,r(i,n.DONE),typeof i.onload=="function"&&i.onload()};if(o.formData)try{o.formData().then(function(e){var t="",s=e.values(),o,u;do u=s.next(),o=u.value,o&&(t+=o);while(!u.done);i._response=t,i._responseText=t,r(i,n.DONE),typeof i.onload=="function"&&i.onload()})}catch(c){o.text().then(function(e){l(e)})}else o.text().then(function(e){l(e)})}else o.text().then(function(e){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: Calling response.text()"),i._responseType="",i._response=e,i._responseText=e,r(i,n.DONE),typeof i.onload=="function"&&i.onload()},function(e){t.error(e)})}function a(e,t){e._responseHeaders={};if(t.entries){var i=t.entries(),s,o,u;do s=i.next(),s.value&&(o=s.value[0],u=s.value[1],e._forceMimeType&&o.toLowerCase()=="content-type"?e._responseHeaders[o]=e._forceMimeType:e._responseHeaders[o]=u);while(!s.done)}else t.forEach&&t.forEach(function(t,n){e._forceMimeType&&n.toLowerCase()=="content-type"?e._responseHeaders[n]=e._forceMimeType:e._responseHeaders[n]=t});r(e,n.HEADERS_RECEIVED)}function f(e){if(e._readyState!==n.OPENED)throw new Error("INVALID_STATE_ERR")}function l(e,t,n,r){Object.defineProperty(this,"type",{value:e,enumerable:!0}),Object.defineProperty(this,"bubbles",{value:t,enumerable:!0}),Object.defineProperty(this,"cancelable",{value:n,enumerable:!0}),Object.defineProperty(this,"target",{value:r,enumerable:!0})}return Object.defineProperty(n,"UNSENT",{value:0,enumerable:!0}),Object.defineProperty(n,"OPENED",{value:1,enumerable:!0}),Object.defineProperty(n,"HEADERS_RECEIVED",{value:2,enumerable:!0}),Object.defineProperty(n,"LOADING",{value:3,enumerable:!0}),Object.defineProperty(n,"DONE",{value:4,enumerable:!0}),n.prototype.open=function(e,s,o,u,a){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: open() for method: "+e+", url: "+s);if(typeof o=="boolean"&&!o)throw new Error("InvalidAccessError: Failed to execute 'open' on 'XMLHttpRequest': Synchronous requests are disabled on the XHR Adapter");this._method=e,this._url=s;var f=i(s);if(f){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: open called for a File url");var l=this;this._passthroughXHR=new l._browserXMLHttpRequest,this._passthroughXHR.onreadystatechange=function(){var e=l._passthroughXHR.readyState;if(e==n.DONE){l._status=l._passthroughXHR.status,l._statusText=l._passthroughXHR.statusText,l._response=l._passthroughXHR.response,l._responseHeaders=l._passthroughXHR.responseHeaders,l._responseType=l._passthroughXHR.responseType;if(l._responseType==null||l._responseType==""||l._responseType=="text")l._responseText=l._passthroughXHR.responseText;l._responseURL=l._passthroughXHR.responseURL;if(l._responseType==null||l._responseType==""||l._responseType=="document")l._responseXML=l._passthroughXHR.responseXML}r(l,l._passthroughXHR.readyState)},this._passthroughXHR.open(e,s,o,u,a)}else this._passthroughXHR=null;this._username=u,this._password=a,this._responseText=null,this._responseXML=null,this._requestHeaders={},r(this,n.OPENED)},n.prototype.setRequestHeader=function(e,n){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: setRequestHeader() with header: "+e+" ,value: "+n),f(this);var r=this._requestHeaders[e];this._requestHeaders[e]=r?r+=","+n:n},n.prototype.send=function(e){var i=this;t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: send()");if(this._passthroughXHR)this.responseType!=null&&(this._passthroughXHR.responseType=this.responseType),this._passthroughXHR.send(e);else{f(this),r(this,n.OPENED);var s=o(this,e),a=new Request(this._url,s),i=this;try{fetch(a).then(function(e){u(i,a,e)},function(e){i.dispatchEvent(new l("error",!1,!1,i))})}catch(c){throw c}this.dispatchEvent(new l("loadstart",!1,!1,this))}},n.prototype.abort=function(){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: abort() is not supported by the XHR Adapter")},n.prototype.getResponseHeader=function(e){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: getResponseHeader() for header: "+e);if(this._readyState<n.HEADERS_RECEIVED)return null;e=e.toLowerCase();for(var r in this._responseHeaders)if(r.toLowerCase()==e.toLowerCase())return this._responseHeaders[r];return null},n.prototype.getAllResponseHeaders=function(){function i(t){r+=t+": "+e._responseHeaders[t]+"\r\n"}t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: getAllResponseHeaders()");var e=this;if(this._readyState<n.HEADERS_RECEIVED)return"";var r="";return this._responseHeaders&&Object.keys(this._responseHeaders).forEach(i),r},n.prototype.overrideMimeType=function(e){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: overrideMimeType() for mimeType: "+e),typeof e=="string"&&(this._forceMimeType=e.toLowerCase())},n.prototype.addEventListener=function(e,n){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: addEventListener() for event type: "+e),this._eventListeners[e]=this._eventListeners[e]||[],this._eventListeners[e].push(n)},n.prototype.removeEventListener=function(e,n){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: removeEventListener() for event type: "+e);var r=this._eventListeners[e]||[],i,s=r.length;for(i=0;i<s;i++)if(r[i]==n)return r.splice(i,1)},n.prototype.dispatchEvent=function(e){t.log("Offline Persistence Toolkit PersistenceXMLHttpRequest: dispatchEvent() for event type: "+e.type);var n=this,r=e.type,i=this._eventListeners[r]||[];i.forEach(function(t){typeof t=="function"?t.call(n,e):t.handleEvent(e)});switch(r){case"abort":this.onabort&&this.onabort(e);break;case"error":this.onerror&&this.onerror(e);break;case"load":this.onload&&this.onload(e);break;case"loadend":this.onloadend&&this.onloadend(e);break;case"loadstart":this.onloadstart&&this.onloadstart(e);break;case"progress":this.onprogress&&this.onprogress(e);break;case"readystatechange":this.onreadystatechange&&this.onreadystatechange(e);break;case"timeout":this.ontimeout&&this.ontimeout(e)}return!!e.defaultPrevented},l.prototype.stopPropagation=function(){},l.prototype.preventDefault=function(){this.defaultPrevented=!0},n}),define("persist/persistenceStoreManager",["./impl/logger"],function(e){"use strict";var t=function(){Object.defineProperty(this,"_stores",{value:{},writable:!0}),Object.defineProperty(this,"_factories",{value:{},writable:!0}),Object.defineProperty(this,"_DEFAULT_STORE_FACTORY_NAME",{value:"_defaultFactory",writable:!1}),Object.defineProperty(this,"_storeNameMapping",{value:{},writable:!0})};return t.prototype.registerStoreFactory=function(e,t){if(!t)throw TypeError("A valid factory must be provided.");if(!e)throw TypeError("A valid name must be provided.");var n=this._mapStoreName(e),r=this._factories[n];if(r&&r!==t)throw TypeError("A factory with the same name has already been registered.");this._factories[n]=t},t.prototype.registerDefaultStoreFactory=function(e){this.registerStoreFactory(this._DEFAULT_STORE_FACTORY_NAME,e)},t.prototype.openStore=function(t,n){e.log("Offline Persistence Toolkit PersistenceStoreManager: openStore() for name: "+t);var r=this._mapStoreName(t),i=this._stores[r],s=n&&n.version||"0";if(i&&i[s])return Promise.resolve(i[s]);var o=this._factories[r];o||(o=this._factories[this._DEFAULT_STORE_FACTORY_NAME]);if(!o)return Promise.reject(new Error("no factory is registered to create the store."));var u=this;return e.log("Offline Persistence Toolkit PersistenceStoreManager: Calling createPersistenceStore on factory"),o.createPersistenceStore(r,n).then(function(e){return i=i||{},i[s]=e,u._stores[r]=i,e})},t.prototype.hasStore=function(e,t){var n=this._mapStoreName(e),r=this._stores[n];return r?!t||!t.version?!0:r[t.version]?!0:!1:!1},t.prototype.deleteStore=function(t,n){e.log("Offline Persistence Toolkit PersistenceStoreManager: deleteStore() for name: "+t);var r=this._mapStoreName(t),i=this._stores[r];if(!i)return Promise.resolve(!1);var s=n&&n.version;if(s){var o=i[s];return o?(e.log("Offline Persistence Toolkit PersistenceStoreManager: Calling delete on store"),o.delete().then(function(){return delete i[s],!0})):Promise.resolve(!1)}var u=function(e){return function(t){var n=e[t];return n.delete()}},a=Object.keys(i).map(u(i),this),f=this;return Promise.all(a).then(function(){return delete f._stores[r],!0})},t.prototype._mapStoreName=function(e,t){var n=this._storeNameMapping[e];return n?n:(n=e.replace(/(.*):\/\/(.*)/gi,"$1$2"),this._storeNameMapping[e]=n,n)},new t}),define("persist/impl/defaultCacheHandler",["../persistenceUtils","../persistenceStoreManager","./logger"],function(e,t,n){"use strict";function r(){Object.defineProperty(this,"_endpointToOptionsMap",{value:{},writable:!0})}function i(e){var t=e.map(function(e){var t=Object.keys(e)[0],n=e[t];return!n||!n.length?Promise.resolve():s(t,n)});return Promise.all(t)}function s(e,r){return n.log("Offline Persistence Toolkit DefaultCacheHandler: Updating store with shredded data"),t.openStore(e).then(function(e){return e.upsertAll(r)})}function o(e){var t=e.name,n=e.resourceIdentifier,r=e.keys,i=[],s=(new Date).toUTCString();for(var o=0;o<r.length;o++){var u={key:r[o],metadata:{lastUpdated:s,resourceIdentifier:n},value:e.data[o]};i.push(u)}var a={};return a[t]=i,a}function u(e){var n=e.name;return t.openStore(n).then(function(t){if(e.keys&&e.keys.length){if(e.keys.length===1)return t.findByKey(e.keys[0]);var n=e.keys.map(function(e){return{key:{$eq:e}}}),r={selector:{$or:n}};return t.find(r)}return Promise.resolve([])}).then(function(t){return Array.isArray(t)||(t=[t]),e.data=t,Promise.resolve(e)})}r.prototype.constructRequestResponseCacheData=function(t,r){var i=this,s={};return n.log("Offline Persistence Toolkit DefaultCacheHandler: constructRequestResponseCacheData()"),e.requestToJSON(t).then(function(n){s.requestData=n;var o=i.hasShredder(t);return e.responseToJSON(r,{excludeBody:o})}).then(function(e){return s.responseData=e,{key:i._constructCacheKey(t,r),metadata:i.constructMetadata(t),value:s}})},r.prototype.constructShreddedData=function(e,t){n.log("Offline Persistence Toolkit DefaultCacheHandler: constructShreddedData()");var r=this._getShredder(e);return r?r(t).then(function(e){var t=e.map(o);return Promise.resolve(t)}):Promise.resolve()},r.prototype.shredResponse=function(e,t){n.log("Offline Persistence Toolkit DefaultCacheHandler: shredResponse()");var r=this._getShredder(e);return r?r(t):Promise.resolve()},r.prototype.cacheShreddedData=function(e){n.log("Offline Persistence Toolkit DefaultCacheHandler: cacheShreddedData()");var t=e.map(o);return i(t)},r.prototype._constructCacheKey=function(e,t){var n=e.url+e.method;if(t){var r=t.headers;if(r){var i=r.get("vary");if(i)if(i==="*")n+=(new Date).getTime();else{var s=e.headers,o=i.split(",");for(var u=0;u<o.length;u++){var a=o[u];a=a.trim();var i=s?s.get(a):"undefined";n+=a+"="+i}}}}return n},r.prototype.constructMetadata=function(e){var t=(new Date).getTime(),n={url:e.url,method:e.method,created:t,lastupdated:t};return n},r.prototype.constructResponse=function(t){return n.log("Offline Persistence Toolkit DefaultCacheHandler: constructResponse()"),e.responseFromJSON(t).then(function(t){return e.isCachedResponse(t)||t.headers.set("x-oracle-jscpt-cache-expiration-date",""),Promise.resolve(t)})},r.prototype.constructSearchCriteria=function(e,t){n.log("Offline Persistence Toolkit DefaultCacheHandler: constructSearchCriteria()");var r=!1;t&&t.ignoreSearch!==undefined&&(r=t.ignoreSearch);var i=!1;t&&t.ignoreMethod!==undefined&&(i=t.ignoreMethod);var s,o,u=e.url.indexOf("?");u>=0?o=e.url.substring(0,u):o=e.url,r?s={"metadata.url":{$regex:"^"+a(o)+"(\\?|$)"}}:s={"metadata.url":e.url},i||(s["metadata.method"]=e.method);var f={selector:s,sort:[{"metadata.created":"asc"}]};return f},r.prototype.registerEndpointOptions=function(e,t){if(!e)throw new Error({message:"a valid endpointKey must be provided."});if(this._endpointToOptionsMap[e])throw new Error({message:"endpointKey can only be registered once."});this._endpointToOptionsMap[e]=t},r.prototype.unregisterEndpointOptions=function(e){if(!e)throw new Error({message:"a valid endpointKey must be provided."});delete this._endpointToOptionsMap[e]},r.prototype.hasShredder=function(e){return this._getShredder(e)!==null},r.prototype._getShredder=function(e){var t=this._getJsonProcessor(e);return t?t.shredder:null},r.prototype._getUnshredder=function(e){var t=this._getJsonProcessor(e);return t?t.unshredder:null},r.prototype._getJsonProcessor=function(e){var t=Object.keys(this._endpointToOptionsMap);for(var n=0;n<t.length;n++){var r=t[n];if(e.url===JSON.parse(r).url){var i=this._endpointToOptionsMap[r];return i&&i.jsonProcessor&&i.jsonProcessor.shredder&&i.jsonProcessor.unshredder?i.jsonProcessor:null}}return null},r.prototype.fillResponseBodyWithShreddedData=function(e,t,r){n.log("Offline Persistence Toolkit DefaultCacheHandler: fillResponseBodyWithShreddedData()"),e.url!=null&&e.url.length>0&&r.headers.get("x-oracle-jscpt-response-url")==null&&r.headers.set("x-oracle-jscpt-response-url",e.url),t&&t.length===1&&t[0].resourceType==="single"&&r.headers.set("x-oracle-jscpt-resource-type","single");var i=this._getUnshredder(e),s=this._getShredder(e);if(!i||!s||!r||!t||!t.length)return Promise.resolve(r);var o=t.map(function(e){return u(e)});return Promise.all(o).then(function(e){return i(e,r)})},r.prototype.deleteShreddedData=function(e){var n=[];return e.forEach(function(e){var r=e.name,i=e.keys;if(r&&i&&i.length){var s=t.openStore(r).then(function(e){var t=i.map(function(e){return{key:{$eq:e}}}),n={selector:{$or:t}};return e.delete(n)});n.push(s)}}),Promise.all(n)};var a=function(e){return String(e).replace(/([.*+?^=!:${}()|\[\]\/\\])/g,"\\$1")};return new r}),define("persist/impl/PersistenceSyncManager",["require","../persistenceUtils","../persistenceStoreManager","./defaultCacheHandler","./logger"],function(e,t,n,r,i){"use strict";function s(e,t,n){Object.defineProperty(this,"_eventListeners",{value:[],writable:!0}),Object.defineProperty(this,"_isOnline",{value:e}),Object.defineProperty(this,"_browserFetch",{value:t}),Object.defineProperty(this,"_cache",{value:n})}function o(e){var t=e;return c().then(function(e){return h(e)}).then(function(e){return t._readingSyncLog=null,e})}function u(e,t){var n=e,r=n._options.preflightOptionsRequest,s=n._options.preflightOptionsRequestTimeout;if(t.url!=null&&r!="disabled"&&t.url.match(r)!=null){i.log("Offline Persistence Toolkit PersistenceSyncManager: Checking URL based on preflightOptionsRequest");if(!n._pingedURLs)n._pingedURLs=[];else if(n._pingedURLs.indexOf(t.url)>=0)return Promise.resolve(!0);return n._preflightOptionsRequestId=(new Date).getTime(),new Promise(function(e){return function(r,i){n._repliedOptionsRequest=!1;var o=new Request(t.url,{method:"OPTIONS"}),u=6e4;s!=null&&(u=s),setTimeout(function(){!n._repliedOptionsRequest&&n._preflightOptionsRequestId==e&&i(!1)},u),n._browserFetch(o).then(function(e){n._repliedOptionsRequest=!0,n._pingedURLs||(n._pingedURLs=[]),n._pingedURLs.push(t.url),r(!0)},function(e){n._repliedOptionsRequest=!0,r(!0)})}}(n._preflightOptionsRequestId))}return Promise.resolve(!0)}function a(e){return e=e||{},e.action==="stop"}function f(e){if(e&&e.length>0){var t=[],n,r;for(n=0;n<e.length;n++)r=e[n].request,r.method!="GET"&&r.method!="HEAD"&&t.push(e[n]);for(n=0;n<e.length;n++)r=e[n].request,(r.method=="GET"||r.method=="HEAD")&&t.push(e[n]);return t}return e}function l(e,t){return{requestId:e,request:t,undo:function(){return m(e)},redo:function(){return v(e)}}}function c(){return S().then(function(e){return e.find(d())})}function h(e){var n=[],r,i,s=function(e){return!e||e.length==0?Promise.resolve(n):(r=e[0].metadata.created.toString(),i=e[0].value,t.requestFromJSON(i).then(function(t){return n.push(l(r,t)),e.shift(),s(e)}))};return s(e)}function p(e,t){var n=e;return n.getSyncLog().then(function(e){var n,r,i=e.length;for(n=0;n<i;n++)if(e[n].requestId===t)return r=e[n].request,r})}function d(){var e={},t=[],n=[];n.push("metadata.created"),e.sort=n,t.push("metadata.created"),t.push("value"),e.fields=t;var r={},i={};return i.$exists=!0,r["metadata.created"]=i,e.selector=r,e}function v(e){return x().then(function(t){return t.findByKey(e)}).then(function(e){return e!=null?g(e,!1).then(function(){return!0}):!1})}function m(e){return x().then(function(t){return t.findByKey(e)}).then(function(e){return e!=null?g(e,!0).then(function(){return!0}):!1})}function g(e,t){var r,i=[],s,o,u,a;e instanceof Array||(e=[e]);var f=e.length,l=function(c){if(!(c<f))return Promise.resolve();o=e[c].storeName,s=e[c].operation,u=e[c].undoRedoData;if(s=="upsert"||s=="remove"&&t){i=[],a=u.length;for(r=0;r<a;r++)t?i.push({key:u[r].key,value:u[r].undo}):i.push({key:u[r].key,value:u[r].redo});return n.openStore(o).then(function(e){return i.length==1&&i[0].value==null&&i[0].key!=null?e.removeByKey(i[0].key).then(function(){return l(++c)}):e.upsertAll(i).then(function(){return l(++c)})})}if(s=="remove")return n.openStore(o).then(function(e){return e.removeByKey(u[0].key).then(function(){return l(++c)})})};return l(0)}function y(e,t,n,r){var i=e,s=i._eventListeners.filter(b(t,r));return w(n,s)}function b(e,t){return function(n){return e.toLowerCase()==n.type&&(t!=null&&t.match(n.scope)||t==null||n.scope==null)}}function w(e,t){return t.length>0?t[0].listener(e).then(function(e){if(e!=null)return Promise.resolve(e);if(t.length>1)return w(t.slice(1))}):Promise.resolve(null)}function E(e){var t={index:["metadata.created"]};return n.openStore(e,t)}function S(){return E("syncLog")}function x(){return E("redoUndoLog")}return s.prototype.addEventListener=function(e,t,n){i.log("Offline Persistence Toolkit PersistenceSyncManager: addEventListener() for type: "+e+" and scope: "+n),this._eventListeners.push({type:e.toLowerCase(),listener:t,scope:n})},s.prototype.removeEventListener=function(e,t,n){i.log("Offline Persistence Toolkit PersistenceSyncManager: removeEventListener() for type: "+e+" and scope: "+n),this._eventListeners=this._eventListeners.filter(function(r){return e.toLowerCase()==r.type&&t==r.listener&&n==r.scope?!1:!0})},s.prototype.getSyncLog=function(){return i.log("Offline Persistence Toolkit PersistenceSyncManager: getSyncLog()"),this._readingSyncLog||(this._readingSyncLog=o(this)),this._readingSyncLog},s.prototype.insertRequest=function(e,n){i.log("Offline Persistence Toolkit PersistenceSyncManager: insertRequest() for Request with url: "+e.url);var s={};return S().then(function(n){return s.store=n,t.requestToJSON(e,{_noClone:!0})}).then(function(t){return s.requestData=t,s.metadata=r.constructMetadata(e),s.requestId=s.metadata.created.toString(),s.store.upsert(s.requestId,s.metadata,s.requestData)}).then(function(){if(n!=null){var e=n.undoRedoDataArray;return e!=null?x().then(function(t){var n=function(r){return r<e.length&&e[r]!=null?t.upsert(s.requestId,s.metadata,e[r]).then(function(){return n(++r)}):Promise.resolve()};return n(0)}):Promise.resolve()}return Promise.resolve()})},s.prototype.removeRequest=function(e){i.log("Offline Persistence Toolkit PersistenceSyncManager: removeRequest() for Request with requestId: "+e);var t=this,n={};return S().then(function(r){return n.store=r,p(t,e)}).then(function(t){return n.request=t,n.store.removeByKey(e)}).then(function(){return x()}).then(function(t){return t.removeByKey(e)}).then(function(){return n.request})},s.prototype.updateRequest=function(e,n){return i.log("Offline Persistence Toolkit PersistenceSyncManager: updateRequest() for Request with requestId: "+e),Promise.all([S(),t.requestToJSON(n)]).then(function(t){var i=t[0],s=t[1],o=r.constructMetadata(n);return i.upsert(e,o,s)})},s.prototype.sync=function(e){i.log("Offline Persistence Toolkit PersistenceSyncManager: sync()"),this._options=e||{};var n=this;if(this._syncing)return Promise.reject("Cannot start sync while sync is in progress");this._syncing=!0;var r=new Promise(function(e,r){n.getSyncLog().then(function(s){if(n._isOnline()){i.log("Offline Persistence Toolkit PersistenceSyncManager: Processing sync, is online");var o,l,c,h,p=function(s){s.length==0&&(i.log("Offline Persistence Toolkit PersistenceSyncManager: Sync finished, no requests in sync log"),e()),s.length>0&&(i.log("Offline Persistence Toolkit PersistenceSyncManager: Processing sync, # of request in sync log: "+s.length),o=s[0].requestId,l=s[0].request,c=l.clone(),i.log("Offline Persistence Toolkit PersistenceSyncManager: Dispatching beforeSyncRequest event"),y(n,"beforeSyncRequest",{requestId:o,request:c.clone()},l.url).then(function(f){if(a(f)){i.log("Offline Persistence Toolkit PersistenceSyncManager: Sync stopped by beforeSyncRequest event listener"),e();return}f=f||{},f.action!=="skip"?(f.action==="replay"&&(i.log("Offline Persistence Toolkit PersistenceSyncManager: Replay request from beforeSyncRequest event listener"),l=f.request),c=l.clone(),u(n,l).then(function(){i.log("Offline Persistence Toolkit PersistenceSyncManager: Replaying request with url: "+l.url),n._browserFetch(l).then(function(u){h=u.status;if(h>=400){r({error:u.statusText,requestId:o,request:c.clone(),response:u.clone()});return}t._cloneResponse(u,{url:l.url}).then(function(u){i.log("Offline Persistence Toolkit PersistenceSyncManager: Dispatching syncRequest event"),y(n,"syncRequest",{requestId:o,request:c.clone(),response:u.clone()},l.url).then(function(f){a(f)?e():(i.log("Offline Persistence Toolkit PersistenceSyncManager: Removing replayed request"),n.removeRequest(o).then(function(){s.shift(),l.method=="GET"||l.method=="HEAD"?t._cloneResponse(u,{url:l.url}).then(function(e){n._cache().put(l,e).then(function(){i.log("Offline Persistence Toolkit PersistenceSyncManager: Replayed request/response is cached."),p(s)})}):p(s)},function(e){r({error:e,requestId:o,request:c.clone()})}))})})},function(e){r({error:e,requestId:o,request:c.clone()})})},function(e){if(e===!1){var t={status:504,statusText:"Preflight OPTIONS request timed out"};r({error:"Preflight OPTIONS request timed out",requestId:o,request:c.clone(),response:new Response(null,t)})}else r({error:e,requestId:o,request:c.clone()})})):(i.log("Offline Persistence Toolkit PersistenceSyncManager: Removing skipped request"),n.removeRequest(o).then(function(){s.shift(),p(s)},function(e){r({error:e,requestId:o,request:c.clone()})}))}))};s=f(s),p(s)}else e()})});return r.then(function(e){return n._syncing=!1,n._pingedURLs=null,e},function(e){return n._syncing=!1,n._pingedURLs=null,Promise.reject(e)})},s}),define("persist/impl/OfflineCache",["./defaultCacheHandler","../persistenceStoreManager","./logger"],function(e,t,n){"use strict";function r(e,t){if(!e)throw TypeError("A name must be provided to create an OfflineCache!");if(!t)throw TypeError("A persistence store must be provided to create an OfflineCache!");this._name=e,this._storeName=t,this._store=null}function i(e,t,n){if(n&&n.length)for(var r=0;r<n.length;r++){var i=n[r];if(u(e,t,i))return i.responseData}return null}function s(e,t,n){var r=[];if(n&&n.length){var i=n.filter(o(e,t));r=i.map(function(e){return e.responseData})}return r}function o(e,t,n){return function(r){var i;return n?i=r[n]:i=r,u(e,t,i)}}function u(e,t,r){if(e)return!0;if(!r||!t)return!1;var i=r.requestData.headers,s=r.responseData.headers,o=t.headers,u=s.vary;n.log("Offline Persistence Toolkit OfflineCache: Processing HTTP Vary header");if(!u)return!0;if(u.trim()==="*")return!1;var a=u.split(",");for(var f=0;f<a.length;f++){var l=a[f].toLowerCase();l=l.trim();var c=o.get(l),h=i[l];n.log("Offline Persistence Toolkit OfflineCache: HTTP Vary header name: "+l),n.log("Offline Persistence Toolkit OfflineCache: Request HTTP Vary header value: "+c),n.log("Offline Persistence Toolkit OfflineCache: Cached HTTP Vary header value: "+h);if(!h&&!c||h&&c&&h===c)continue;return!1}return!0}function a(t){if(t){n.log("Offline Persistence Toolkit OfflineCache: Converting cached entry to Response object");var r=[],i=t.bodyAbstract;return i?(r.push(Promise.resolve(JSON.parse(i))),delete t.bodyAbstract):r.push(Promise.resolve()),r.push(e.constructResponse(t)),Promise.all(r)}return Promise.resolve()}function f(e){if(!e||!e.length)return Promise.resolve();var t=e.map(function(e){return a(e)});return Promise.all(t)}function l(e){var t=e.map(function(e){return{name:e.name,keys:e.keys?e.keys.reduce(function(e,t){return t?e.push(t.toString()):n.warn("should not have undefined key in the shredded data"),e},[]):e.keys,resourceType:e.resourceType}});return JSON.stringify(t)}return r.prototype.getName=function(){return this._name},r.prototype.add=function(e){n.log("Offline Persistence Toolkit OfflineCache: add()");var t=this;return fetch(e).then(function(n){var r=n.clone();return t.put(e,n).then(function(){Promise.resolve(r)})})},r.prototype.addAll=function(e){n.log("Offline Persistence Toolkit OfflineCache: addAll()");var t=e.map(this.add,this);return Promise.all(t)},r.prototype.match=function(t,r){n.log("Offline Persistence Toolkit OfflineCache: match() for Request with url: "+t.url);var s=this,o=e.constructSearchCriteria(t,r),u=r&&r.ignoreVary;return s._getStore().then(function(e){return e.find(o)}).then(function(e){var n=i(u,t,e);return a(n)}).then(function(n){if(n){var r=n[0],i=n[1];return e.fillResponseBodyWithShreddedData(t,r,i)}return Promise.resolve()})},r.prototype.matchAll=function(t,r){n.log("Offline Persistence Toolkit OfflineCache: matchAll() for Request with url: "+t.url);var i=this,o=e.constructSearchCriteria(t,r),u=r&&r.ignoreVary;return i._getStore().then(function(e){return e.find(o)}).then(function(e){var n=s(u,t,e);return f(n)}).then(function(n){if(n&&n.length){var r=n.map(function(n){var r=n[0],i=n[1];return e.fillResponseBodyWithShreddedData(t,r,i)});return Promise.all(r)}return Promise.resolve([])})},r.prototype._getStore=function(){var e=this;return e._store?Promise.resolve(e._store):t.openStore(e._storeName).then(function(t){return e._store=t,e._store})},r.prototype.put=function(t,r){n.log("Offline Persistence Toolkit OfflineCache: put() for Request with url: "+t.url);var i=this,s=[];return s.push(e.constructRequestResponseCacheData(t,r)),s.push(e.shredResponse(t,r)),Promise.all(s).then(function(t){return i._getStore().then(function(n){var r=t[0],i=t[1];if(!i)return n.upsert(r.key,r.metadata,r.value);var s=[];return r.value.responseData.bodyAbstract=l(i),s.push(n.upsert(r.key,r.metadata,r.value)),s.push(e.cacheShreddedData(i)),Promise.all(s)})})},r.prototype.delete=function(t,r){t?n.log("Offline Persistence Toolkit OfflineCache: delete() for Request with url: "+t.url):n.log("Offline Persistence Toolkit OfflineCache: delete()");var i=this;if(e.hasShredder(t)){var s=e.constructSearchCriteria(t,r);s.fields=["key","value"];var u=r&&r.ignoreVary,a;return i._getStore().then(function(e){return a=e,a.find(s)}).then(function(r){if(r&&r.length){var i=r.filter(o(u,t,"value")),s=[];return i.forEach(function(t){s.push(a.removeByKey(t.key)),t.value.responseData.bodyAbstract&&t.value.responseData.bodyAbstract.length&&s.push(e.deleteShreddedData(JSON.parse(t.value.responseData.bodyAbstract)))}),Promise.all(s).then(function(){return n.log("Offline Persistence Toolkit OfflineCache: all matching entries are deleted from both the cache store and the shredded store."),!0}).catch(function(e){return n.log("Offline Persistence Toolkit OfflineCache: error occurred when deleting matched cache entries."),!1})}return n.log("Offline Persistence Toolkit OfflineCache: no matching entries are found from the cache."),!1})}return i.keys(t,r).then(function(e){return i._getStore().then(function(t){if(e&&e.length){var n=e.map(t.removeByKey,t);return Promise.all(n)}return!1})}).then(function(e){return e&&e.length?!0:!1})},r.prototype.keys=function(t,r){t?n.log("Offline Persistence Toolkit OfflineCache: keys() for Request with url: "+t.url):n.log("Offline Persistence Toolkit OfflineCache: keys()");var i=this;return i._getStore().then(function(n){if(t){var i=e.constructSearchCriteria(t,r);i.fields=["key","value"];var s=r&&r.ignoreVary;return n.find(i).then(function(e){if(e&&e.length){var n=e.filter(o(s,t,"value")),r=n.map(function(e){return e.key});return r}return[]})}return n.keys()})},r.prototype.hasMatch=function(t,r){n.log("Offline Persistence Toolkit OfflineCache: hasMatch() for Request with url: "+t.url);var s=this,o=e.constructSearchCriteria(t,r),u=r&&r.ignoreVary;return s._getStore().then(function(e){return e.find(o).then(function(e){var n=i(u,t,e);return n!==null})})},r}),define("persist/impl/offlineCacheManager",["./OfflineCache","./logger"],function(e,t){"use strict";function n(){this._prefix="offlineCaches-",this._caches={},this._cachesArray=[]}return n.prototype.open=function(n){t.log("Offline Persistence Toolkit OfflineCacheManager: open() with name: "+n);var r=this._caches[n];return r||(r=new e(n,this._prefix+n),this._caches[n]=r,this._cachesArray.push(r)),r},n.prototype.match=function(e,n){t.log("Offline Persistence Toolkit OfflineCacheManager: match() for Request with url: "+e.url);var r=this,i=function(t,r){if(r===t.length)return Promise.resolve();var s=t[r];return s.match(e,n).then(function(e){return e?e.clone():i(t,r+1)})};return i(r._cachesArray,0)},n.prototype.has=function(e){return t.log("Offline Persistence Toolkit OfflineCacheManager: has() for name: "+e),this._caches[e]?Promise.resolve(!0):Promise.resolve(!1)},n.prototype.delete=function(e){t.log("Offline Persistence Toolkit OfflineCacheManager: delete() for name: "+e);var n=this,r=n._caches[e];return r?r.delete().then(function(){return n._cachesArray.splice(n._cachesArray.indexOf(e),1),delete n._caches[e],!0}):Promise.resolve(!1)},n.prototype.keys=function(){t.log("Offline Persistence Toolkit OfflineCacheManager: keys()");var e=[];for(var n=0;n<this._cachesArray.length;n++)e.push(this._cachesArray[n].getName());return Promise.resolve(e)},new n}),function(e){"use strict";function s(e){typeof e!="string"&&(e=String(e));if(/[^a-z0-9\-#$%&'*+.\^_`|~]/i.test(e))throw new TypeError("Invalid character in header field name");return e.toLowerCase()}function o(e){return typeof e!="string"&&(e=String(e)),e}function u(e){var n={next:function(){var t=e.shift();return{done:t===undefined,value:t}}};return t.iterable&&(n[Symbol.iterator]=function(){return n}),n}function a(e){this.map={},e instanceof a?e.forEach(function(e,t){this.append(t,e)},this):Array.isArray(e)?e.forEach(function(e){this.append(e[0],e[1])},this):e&&Object.getOwnPropertyNames(e).forEach(function(t){this.append(t,e[t])},this)}function f(e){if(e.bodyUsed)return Promise.reject(new TypeError("Already read"));e.bodyUsed=!0}function l(e){return new Promise(function(t,n){e.onload=function(){t(e.result)},e.onerror=function(){n(e.error)}})}function c(e){var t=new FileReader,n=l(t);return t.readAsArrayBuffer(e),n}function h(e){var t=new FileReader,n=l(t);return t.readAsText(e),n}function p(e){var t=new Uint8Array(e),n=new Array(t.length);for(var r=0;r<t.length;r++)n[r]=String.fromCharCode(t[r]);return n.join("")}function d(e){if(e.slice)return e.slice(0);var t=new Uint8Array(e.byteLength);return t.set(new Uint8Array(e)),t.buffer}function v(){return this.bodyUsed=!1,this._initBody=function(e){this._bodyInit=e;if(!e)this._bodyText="";else if(typeof e=="string")this._bodyText=e;else if(t.blob&&Blob.prototype.isPrototypeOf(e))this._bodyBlob=e;else if(t.formData&&FormData.prototype.isPrototypeOf(e))this._bodyFormData=e;else if(t.searchParams&&URLSearchParams.prototype.isPrototypeOf(e))this._bodyText=e.toString();else if(t.arrayBuffer&&t.blob&&r(e))this._bodyArrayBuffer=d(e.buffer),this._bodyInit=new Blob([this._bodyArrayBuffer]);else{if(!t.arrayBuffer||!ArrayBuffer.prototype.isPrototypeOf(e)&&!i(e))throw new Error("unsupported BodyInit type");this._bodyArrayBuffer=d(e)}this.headers.get("content-type")||(typeof e=="string"?this.headers.set("content-type","text/plain;charset=UTF-8"):this._bodyBlob&&this._bodyBlob.type?this.headers.set("content-type",this._bodyBlob.type):t.searchParams&&URLSearchParams.prototype.isPrototypeOf(e)&&this.headers.set("content-type","application/x-www-form-urlencoded;charset=UTF-8"))},t.blob&&(this.blob=function(){var e=f(this);if(e)return e;if(this._bodyBlob)return Promise.resolve(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(new Blob([this._bodyArrayBuffer]));if(this._bodyFormData)throw new Error("could not read FormData body as blob");return Promise.resolve(new Blob([this._bodyText]))},this.arrayBuffer=function(){return this._bodyArrayBuffer?f(this)||Promise.resolve(this._bodyArrayBuffer):this.blob().then(c)}),this.text=function(){var e=f(this);if(e)return e;if(this._bodyBlob)return h(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(p(this._bodyArrayBuffer));if(this._bodyFormData)throw new Error("could not read FormData body as text");return Promise.resolve(this._bodyText)},t.formData&&(this.formData=function(){return this._bodyFormData?Promise.resolve(this._bodyFormData):this.text().then(b)}),this.json=function(){return this.text().then(JSON.parse)},this}function g(e){var t=e.toUpperCase();return m.indexOf(t)>-1?t:e}function y(e,t){t=t||{};var n=t.body;if(e instanceof y){if(e.bodyUsed)throw new TypeError("Already read");this.url=e.url,this.credentials=e.credentials,t.headers||(this.headers=new a(e.headers)),this.method=e.method,this.mode=e.mode,!n&&e._bodyInit!=null&&(n=e._bodyInit,e.bodyUsed=!0)}else this.url=String(e);this.credentials=t.credentials||this.credentials||"omit";if(t.headers||!this.headers)this.headers=new a(t.headers);this.method=g(t.method||this.method||"GET"),this.mode=t.mode||this.mode||null,this.referrer=null;if(!(this.method!=="GET"&&this.method!=="HEAD"||!n))throw new TypeError("Body not allowed for GET or HEAD requests");this._initBody(n)}function b(e){var t=new FormData;return e.trim().split("&").forEach(function(e){if(e){var n=e.split("="),r=n.shift().replace(/\+/g," "),i=n.join("=").replace(/\+/g," ");t.append(decodeURIComponent(r),decodeURIComponent(i))}}),t}function w(e){var t=new a,n=e.replace(/\r?\n[\t ]+/g," ");return n.split(/\r?\n/).forEach(function(e){var n=e.split(":"),r=n.shift().trim();if(r){var i=n.join(":").trim();t.append(r,i)}}),t}function E(e,t){t||(t={}),this.type="default",this.status="status"in t?t.status:200,this.ok=this.status>=200&&this.status<300,this.statusText="statusText"in t?t.statusText:"OK",this.headers=new a(t.headers),this.url=t.url||"",this._initBody(e)}if(e.fetch)return;var t={searchParams:"URLSearchParams"in e,iterable:"Symbol"in e&&"iterator"in Symbol,blob:"FileReader"in e&&"Blob"in e&&function(){try{return new Blob,!0}catch(e){return!1}}(),formData:"FormData"in e,arrayBuffer:"ArrayBuffer"in e};if(t.arrayBuffer)var n=["[object Int8Array]","[object Uint8Array]","[object Uint8ClampedArray]","[object Int16Array]","[object Uint16Array]","[object Int32Array]","[object Uint32Array]","[object Float32Array]","[object Float64Array]"],r=function(e){return e&&DataView.prototype.isPrototypeOf(e)},i=ArrayBuffer.isView||function(e){return e&&n.indexOf(Object.prototype.toString.call(e))>-1};a.prototype.append=function(e,t){e=s(e),t=o(t);var n=this.map[e];this.map[e]=n?n+","+t:t},a.prototype["delete"]=function(e){delete this.map[s(e)]},a.prototype.get=function(e){return e=s(e),this.has(e)?this.map[e]:null},a.prototype.has=function(e){return this.map.hasOwnProperty(s(e))},a.prototype.set=function(e,t){this.map[s(e)]=o(t)},a.prototype.forEach=function(e,t){for(var n in this.map)this.map.hasOwnProperty(n)&&e.call(t,this.map[n],n,this)},a.prototype.keys=function(){var e=[];return this.forEach(function(t,n){e.push(n)}),u(e)},a.prototype.values=function(){var e=[];return this.forEach(function(t){e.push(t)}),u(e)},a.prototype.entries=function(){var e=[];return this.forEach(function(t,n){e.push([n,t])}),u(e)},t.iterable&&(a.prototype[Symbol.iterator]=a.prototype.entries);var m=["DELETE","GET","HEAD","OPTIONS","POST","PUT"];y.prototype.clone=function(){return new y(this,{body:this._bodyInit})},v.call(y.prototype),v.call(E.prototype),E.prototype.clone=function(){return new E(this._bodyInit,{status:this.status,statusText:this.statusText,headers:new a(this.headers),url:this.url})},E.error=function(){var e=new E(null,{status:0,statusText:""});return e.type="error",e};var S=[301,302,303,307,308];E.redirect=function(e,t){if(S.indexOf(t)===-1)throw new RangeError("Invalid status code");return new E(null,{status:t,headers:{location:e}})},e.Headers=a,e.Request=y,e.Response=E,e.fetch=function(e,n){return new Promise(function(r,i){var s=new y(e,n),o=new XMLHttpRequest;o.onload=function(){var e={status:o.status,statusText:o.statusText,headers:w(o.getAllResponseHeaders()||"")};e.url="responseURL"in o?o.responseURL:e.headers.get("X-Request-URL");var t="response"in o?o.response:o.responseText;r(new E(t,e))},o.onerror=function(){i(new TypeError("Network request failed"))},o.ontimeout=function(){i(new TypeError("Network request failed"))},o.open(s.method,s.url,!0),s.credentials==="include"&&(o.withCredentials=!0),"responseType"in o&&t.blob&&(o.responseType="blob"),s.headers.forEach(function(e,t){o.setRequestHeader(t,e)}),o.send(typeof s._bodyInit=="undefined"?null:s._bodyInit)})},e.fetch.polyfill=!0}(typeof self!="undefined"?self:this),define("persist/impl/fetch",function(){}),define("persist/persistenceManager",["./impl/PersistenceXMLHttpRequest","./impl/PersistenceSyncManager","./impl/offlineCacheManager","./impl/logger","./impl/fetch"],function(e,t,n,r){"use strict";function i(){Object.defineProperty(this,"_registrations",{value:[],writable:!0}),Object.defineProperty(this,"_eventListeners",{value:[],writable:!0}),Object.defineProperty(this,"_forceOffline",{value:!1,writable:!0}),Object.defineProperty(this,"_isOffline",{value:!1,writable:!0}),Object.defineProperty(this,"_cache",{value:null,writable:!0}),Object.defineProperty(this,"_persistenceSyncManager",{value:new t(this.isOnline.bind(this),this.browserFetch.bind(this),this.getCache.bind(this))})}function s(e){var t=e;o()&&!t._addedBrowserEventListeners&&(r.log("Offline Persistence Toolkit PersistenceManager: Adding browser event listeners"),window.addEventListener("offline",function(e){t._isOffline=!0},!1),window.addEventListener("online",function(e){t._isOffline=!1},!1),t._addedBrowserEventListeners=!0)}function o(){return typeof window!="undefined"&&window!=null}function u(e,t,n){var i,s,o,u,a=null,f=e._registrations,l=f!=null?f.length:0,c;for(i=0;i<l;i++){u=f[i];if(n.request.url.match(u["scope"])!=null){c=u._eventListeners.length;for(s=0;s<c;s++)if(u._eventListeners[s]["type"]==t)if(t=="fetch")a===null&&n._setPromiseCallbacks instanceof Function&&(a=new Promise(function(e,t){n._setPromiseCallbacks(e,t)})),r.log("Offline Persistence Toolkit PersistenceManager: Calling fetch event listener"),u._eventListeners[s].listener(n);else{r.log("Offline Persistence Toolkit PersistenceManager: Calling event listener"),o=u._eventListeners[s].listener(n);if(o===!1)return!1}if(a!=null)return a}}return!0}function a(e){var t=e;t._cache=n.open("systemCache")}function f(t){var n=t;o()&&!n._browserFetchFunc&&!n._browserXMLHttpRequest&&(r.log("Offline Persistence Toolkit PersistenceManager: Replacing browser APIs"),Object.defineProperty(n,"_browserFetchFunc",{value:window.fetch,writable:!1}),Object.defineProperty(n,"_browserXMLHttpRequest",{value:window.XMLHttpRequest,writable:!1}),window.fetch=h(t),window.XMLHttpRequest=function(){return n._browserFetchRequest!=null?new n._browserXMLHttpRequest:new e(n._browserXMLHttpRequest)})}function l(e,t){var n=e,r=n._registrations.indexOf(t);return r>-1?(n._registrations.splice(r,1),!0):!1}function c(e,t){Object.defineProperty(this,"scope",{value:e,enumerable:!0}),Object.defineProperty(this,"_persistenceManager",{value:t}),Object.defineProperty(this,"_eventListeners",{value:[],writable:!0})}function h(e){function t(e){Object.defineProperty(this,"isReload",{value:!1,enumerable:!0}),Object.defineProperty(this,"clientId",{value:null,enumerable:!0}),Object.defineProperty(this,"client",{value:null,enumerable:!0}),Object.defineProperty(this,"request",{value:e,enumerable:!0}),Object.defineProperty(this,"_resolveCallback",{value:null,writable:!0}),Object.defineProperty(this,"_rejectCallback",{value:null,writable:!0})}return t.prototype.respondWith=function(e){var t=this;if(e instanceof Promise)e.then(function(e){t._resolveCallback(e)},function(e){t._rejectCallback(e)});else if(typeof e=="function"){var n=e();t._resolveCallback(n)}},t.prototype._setPromiseCallbacks=function(e,t){this._resolveCallback=e,this._rejectCallback=t},function(n,r){var i;return Request.prototype.isPrototypeOf(n)&&!r?i=n:i=new Request(n,r),e.getRegistration(i.url).then(function(n){if(n!=null){var r=new t(i),s=u(e,"fetch",r);if(s!=null&&s instanceof Promise)return s}return e.browserFetch(i)})}}return i.prototype.init=function(){return f(this),s(this),a(this),Promise.resolve()},i.prototype.forceOffline=function(e){r.log("Offline Persistence Toolkit PersistenceManager: forceOffline is called with value: "+e),this._forceOffline=e},i.prototype.getCache=function(){return this._cache},i.prototype.isOnline=function(){var e=navigator.onLine;return navigator.network&&navigator.network.connection&&navigator.network.connection.type==Connection.NONE&&(e=!1,r.log("Offline Persistence Toolkit PersistenceManager: Cordova network info plugin is returning online value: "+e)),e&&!this._isOffline&&!this._forceOffline},i.prototype.register=function(e){e=e||{};var t=new c(e.scope,this);return this._registrations.push(t),Promise.resolve(t)},i.prototype.getRegistration=function(e){var t,n,r=this._registrations.length;for(t=0;t<r;t++){n=this._registrations[t];if(e.match(n.scope))return Promise.resolve(n)}return Promise.resolve()},i.prototype.getRegistrations=function(){return Promise.resolve(this._registrations.slice())},i.prototype.getSyncManager=function(){return this._persistenceSyncManager},i.prototype.browserFetch=function(e){r.log("Offline Persistence Toolkit PersistenceManager: browserFetch() for Request with url: "+e.url);if(o()){Object.defineProperty(this,"_browserFetchRequest",{value:e,writable:!0});var t=this;return new Promise(function(n,i){r.log("Offline Persistence Toolkit PersistenceManager: Calling browser fetch function for Request with url: "+e.url),t._browserFetchFunc.call(window,e).then(function(e){n(e)},function(e){i(e)}),t._browserFetchRequest=null})}return fetch(e)},c.prototype.addEventListener=function(e,t){this._eventListeners.push({type:e.toLowerCase(),listener:t})},c.prototype.unregister=function(){return Promise.resolve(l(this._persistenceManager,this))},new i});