/**
 * Copyright (c) 2017, Oracle and/or its affiliates.
 * All rights reserved.
 */

define("persist/fetchStrategies",["./persistenceManager","./persistenceUtils","./impl/defaultCacheHandler","./impl/logger"],function(e,t,n,r){"use strict";function i(i){i=i||{};var s=i.serverResponseCallback,o=i.backgroundFetch,u=o=="disabled"?!0:!1;return u&&(s=null),!s&&!u&&(s=function(e,t){return Promise.resolve(t)}),function(i,o){r.log("Offline Persistence Toolkit fetchStrategies: Processing CacheFirstStrategy");if(s)var u=function(r,i){var u=t.buildEndpointKey(r);n.registerEndpointOptions(u,o);var a={};return t._cloneResponse(i,{url:r.url}).then(function(e){return s(r,e)}).then(function(t){return a.resolvedResponse=t,e.getCache().hasMatch(r)}).then(function(n){var i=a.resolvedResponse.clone();return n?a.resolvedResponse==null||!!t.isCachedResponse(a.resolvedResponse)||r.method!="GET"&&r.method!="HEAD"?i:e.getCache().put(r,a.resolvedResponse).then(function(){return i}):i}).then(function(e){return n.unregisterEndpointOptions(u),Promise.resolve(e)})};return a(i,o,u)}}function s(){return function(n,i){return r.log("Offline Persistence Toolkit fetchStrategies: Processing CacheIfOfflineStrategy"),e.isOnline()?e.browserFetch(n).then(function(e){return e.ok?t._cloneResponse(e,{url:n.url}):o(n,e,i)},function(e){return r.log(e),a(n,i)}):a(n,i)}}function o(e,t,n){return t.status<500?(r.log("Offline Persistence Toolkit fetchStrategies: Response is not ok"),Promise.resolve(t)):a(e,n)}function u(t){return e.getCache().match(t)}function a(t,n,i){return new Promise(function(s,o){r.log("Offline Persistence Toolkit fetchStrategies: Process queryParams for Request"),l(t,n).then(function(n){n?(s(n.clone()),f(t,i)):(r.log("Offline Persistence Toolkit fetchStrategies: Response for queryParams is not null"),u(t).then(function(n){n?(r.log("Offline Persistence Toolkit fetchStrategies: Cached Response is not null"),s(n),f(t,i)):(r.log("Offline Persistence Toolkit fetchStrategies: Cached Response is null"),e.browserFetch(t).then(function(e){var n=e.clone();s(n),i&&i(t,e);return},function(e){var t={status:503,statusText:"No cached response exists"};s(new Response(null,t))}))}))})})}function f(n,i){i&&(r.log("Offline Persistence Toolkit fetchStrategies: Fetch for ServerResponseCallback"),e.browserFetch(n).then(function(e){t._cloneResponse(e,{url:n.url}).then(function(e){i(n,e)})}))}function l(e,t){var n=c(t);return n==null?Promise.resolve():n(e,t)}function c(e){var t=null;return e["queryHandler"]!=null&&(t=e.queryHandler),t}return{getCacheFirstStrategy:i,getCacheIfOfflineStrategy:s}}),define("persist/cacheStrategies",["./persistenceManager","./persistenceUtils","./impl/logger"],function(e,t,n){"use strict";function r(){return function(e,t){return i(e,t).then(function(t){return s(e,t)}).then(function(t){return o(e,t)}).then(function(t){return u(e,t)}).then(function(t){return a(e,t)}).then(function(t){return l(e,t)})}}function i(e,r){var i=r.headers.get("Expires"),s=r.headers.get("x-oracle-jscpt-cache-expiration-date");return i&&t.isCachedResponse(r)&&(!s||s.length==0)&&(r.headers.set("x-oracle-jscpt-cache-expiration-date",i),n.log("Offline Persistence Toolkit cacheStrategies: Set x-oracle-jscpt-cache-expiration-date header based on HTTP Expires header")),Promise.resolve(r)}function s(e,r){var i=c(r.headers,"max-age");if(i!=null&&t.isCachedResponse(r)){var s=e.headers.get("Date");s||(s=(new Date).toUTCString());var o=(new Date(s)).getTime(),u=o+1e3*i,a=new Date(u);r.headers.set("x-oracle-jscpt-cache-expiration-date",a.toUTCString()),n.log("Offline Persistence Toolkit cacheStrategies: Set x-oracle-jscpt-cache-expiration-date header based on HTTP max-age header")}return Promise.resolve(r)}function o(r,i){var s=r.headers.get("If-Match"),o=r.headers.get("If-None-Match");if(s||o){if(!!e.isOnline())return h(r,i,!1);var u=i.headers.get("ETag");if(s&&u.indexOf(s)<0)return t.responseToJSON(i).then(function(e){return e.status=412,e.statusText="If-Match failed due to no matching ETag while offline",n.log("Offline Persistence Toolkit cacheStrategies: Returning Response status 412 based on ETag and HTTP If-Match header"),t.responseFromJSON(e)});if(o&&u.indexOf(o)>=0)return t.responseToJSON(i).then(function(e){return e.status=412,e.statusText="If-None-Match failed due to matching ETag while offline",n.log("Offline Persistence Toolkit cacheStrategies: Returning Response status 412 based on ETag and HTTP If-None-Match header"),t.responseFromJSON(e)})}return Promise.resolve(i)}function u(e,t){var r=c(t.headers,"must-revalidate");if(r){var i=t.headers.get("x-oracle-jscpt-cache-expiration-date");if(i){var s=(new Date(i)).getTime(),o=(new Date).getTime();if(o>s)return n.log("Offline Persistence Toolkit cacheStrategies: Handling revalidation HTTP must-revalidate header"),h(e,t,!0)}}return Promise.resolve(t)}function a(e,t){return f(e,t)?h(e,t):Promise.resolve(t)}function f(e,t){if(c(t.headers,"no-cache"))return n.log("Offline Persistence Toolkit cacheStrategies: Has HTTP no-cache header"),!0;var r=e.headers.get("Pragma"),i=r&&r.trim()==="no-cache";return i&&n.log("Offline Persistence Toolkit cacheStrategies: Has HTTP Pragma no-cache header"),i}function l(e,r){var i=c(r.headers,"no-store");return i!=null?(t.isCachedResponse(r)&&r.headers.delete("x-oracle-jscpt-cache-expiration-date"),n.log("Offline Persistence Toolkit cacheStrategies: Has HTTP no-store header"),Promise.resolve(r)):p(e,r)}function c(e,t){var n=e.get("Cache-Control");if(n){var r=n.split(","),i,s,o;for(i=0;i<r.length;i++){s=r[i].trim();if(s.indexOf(t)===0)return o=s.split("="),o.length>1?o[1].trim():!0}}return null}function h(r,i,s){return t.isCachedResponse(i)?e.isOnline()?e.browserFetch(r).then(function(t){return t.status==304?i:e.getCache().delete(r).then(function(){return n.log("Offline Persistence Toolkit cacheStrategies: Removing old entry based on HTTP revalidation"),t})}):s?t.responseToJSON(i).then(function(e){return e.status=504,e.statusText="cache-control: must-revalidate failed due to application being offline",n.log("Offline Persistence Toolkit cacheStrategies: Returning Response status 504 based HTTP revalidation"),t.responseFromJSON(e)}):Promise.resolve(i):Promise.resolve(i)}function p(r,i){if(i==null||!!t.isCachedResponse(i)||r.method!="GET"&&r.method!="HEAD")return Promise.resolve(i);var s=i.clone();return e.getCache().put(r,i).then(function(){return n.log("Offline Persistence Toolkit cacheStrategies: Cached Request/Response"),s})}return{getHttpCacheHeaderStrategy:r}}),define("persist/defaultResponseProxy",["./persistenceManager","./persistenceUtils","./fetchStrategies","./cacheStrategies","./persistenceStoreManager","./impl/defaultCacheHandler","./impl/logger"],function(e,t,n,r,i,s,o){"use strict";function u(e){e=e||{},e["fetchStrategy"]==null&&(e.fetchStrategy=n.getCacheIfOfflineStrategy()),e["cacheStrategy"]==null&&(e.cacheStrategy=r.getHttpCacheHeaderStrategy()),e.requestHandlerOverride=e.requestHandlerOverride||{},e["requestHandlerOverride"]["handleGet"]==null&&(e.requestHandlerOverride.handleGet=this.handleGet),e["requestHandlerOverride"]["handlePost"]==null&&(e.requestHandlerOverride.handlePost=this.handlePost),e["requestHandlerOverride"]["handlePut"]==null&&(e.requestHandlerOverride.handlePut=this.handlePut),e["requestHandlerOverride"]["handlePatch"]==null&&(e.requestHandlerOverride.handlePatch=this.handlePatch),e["requestHandlerOverride"]["handleDelete"]==null&&(e.requestHandlerOverride.handleDelete=this.handleDelete),e["requestHandlerOverride"]["handleHead"]==null&&(e.requestHandlerOverride.handleHead=this.handleHead),e["requestHandlerOverride"]["handleOptions"]==null&&(e.requestHandlerOverride.handleOptions=this.handleOptions),Object.defineProperty(this,"_options",{value:e})}function a(e){return new u(e)}function f(e,t){var n=e,r=n._options,i=null;return t.method==="POST"?i=r.requestHandlerOverride.handlePost:t.method==="GET"?i=r.requestHandlerOverride.handleGet:t.method==="PUT"?i=r.requestHandlerOverride.handlePut:t.method==="PATCH"?i=r.requestHandlerOverride.handlePatch:t.method==="DELETE"?i=r.requestHandlerOverride.handleDelete:t.method==="HEAD"?i=r.requestHandlerOverride.handleHead:t.method==="OPTIONS"&&(i=r.requestHandlerOverride.handleOptions),i}function l(t){if(!e.isOnline()){var n={status:503,statusText:"Must provide handlePost override for offline"};return Promise.resolve(new Response(null,n))}return e.browserFetch(t)}function c(e,t){var n=e,r=n._options.fetchStrategy;return r(t,n._options)}function h(t,n){var r=t;return e.isOnline()?e.browserFetch(n.clone()).then(function(e){return e.ok?(o.log("Offline Persistence Toolkit DefaultResponseProxy: Response is ok for default PUT Handler"),e):m(r,n,e,p)},function(e){return p(r,n)}):p(r,n)}function p(e,n){return o.log("Offline Persistence Toolkit DefaultResponseProxy: Processing offline logic for default PUT Handler"),t.requestToJSON(n).then(function(e){e.status=200,e.statusText="OK",e.headers["content-type"]="application/json",e.headers["x-oracle-jscpt-cache-expiration-date"]="";var n=e.headers["if-match"],r=e.headers["if-none-match"];if(n||r){o.log("Offline Persistence Toolkit DefaultResponseProxy: Generating ETag for offline Response for default PUT Handler");var i=Math.floor(Math.random()*1e6);e.headers.etag=(Date.now()+i).toString(),e.headers["x-oracle-jscpt-etag-generated"]=e.headers.etag,delete e.headers["if-match"],delete e.headers["if-none-match"]}return t.responseFromJSON(e)})}function d(t,n){var r=t;return e.isOnline()?e.browserFetch(n.clone()).then(function(e){return e.ok?(o.log("Offline Persistence Toolkit DefaultResponseProxy: Response is ok for default DELETE Handler"),e):m(r,n,e,v)},function(e){return v(r,n)}):v(r,n)}function v(e,n){var r=e;return o.log("Offline Persistence Toolkit DefaultResponseProxy: Processing offline logic for default DELETE Handler"),t.requestToJSON(n).then(function(e){return e.status=200,e.statusText="OK",e.headers["content-type"]="application/json",e.headers["x-oracle-jscpt-cache-expiration-date"]="",t.responseFromJSON(e).then(function(s){var o=g(n),u=null;return r._options&&r._options.jsonProcessor&&r._options.jsonProcessor.shredder&&(u=r._options.jsonProcessor.shredder),u?u(s).then(function(n){if(n){var r=n[0].name;return i.openStore(r).then(function(n){return n.findByKey(o).then(function(n){return n?t.responseFromJSON(e).then(function(e){return t.setResponsePayload(e,n).then(function(e){return e})}):s})})}return s}):s})})}function m(e,t,n,r){var i=e;return n.status<500?Promise.resolve(n):r(i,t)}function g(e){var t=e.url.split("/");return t[t.length-1]}function y(e,t,n){var r=e;if(t.method==="GET"||t.method==="HEAD"){var i=r._options.cacheStrategy;return i(t,n,r._options)}return Promise.resolve(n)}function b(t,n,r){return!e.isOnline()||r?e.getSyncManager().insertRequest(t,{undoRedoDataArray:n}):Promise.resolve()}function w(e,t){return e.method=="GET"||e.method=="HEAD"?Promise.resolve():E(e,t)}function E(e,t){return s.constructShreddedData(e,t).then(function(t){return t?S(e,t):Promise.resolve()})}function S(e,t){var n=[];return t.forEach(function(t){var r=Object.keys(t)[0];n.push(x(e,r,t[r]))}),Promise.all(n)}function x(e,t,n){return T(e,t,n).then(function(r){if(e.method==="DELETE"){if(!n||n.length===0){var i=g(e);n=[{key:i}]}return C(t,n,r)}return N(t,n,r)})}function g(e){var t=e.url.split("/");return t.length>1?t[t.length-1].split("?")[0]:null}function T(e,t,n){var r=[],s,o,u=function(n,a){return n<a.length&&e.method!=="GET"&&e.method!=="HEAD"?(s=a[n].key.toString(),e.method!=="DELETE"?o=a[n].value:o=null,i.openStore(t).then(function(e){return e.findByKey(s).then(function(e){return r.push({key:s,undo:e,redo:o}),u(++n,a)},function(e){return r.push({key:s,undo:null,redo:o}),u(++n,a)})})):Promise.resolve(r)};return u(0,n)}function N(e,t,n){return i.openStore(e).then(function(e){return e.upsertAll(t)}).then(function(){return n.length>0?{storeName:e,operation:"upsert",undoRedoData:n}:null})}function C(e,t,n){return i.openStore(e).then(function(e){return e.removeByKey(t[0].key)}).then(function(){return n.length>0?{storeName:e,operation:"remove",undoRedoData:n}:null})}return u.prototype.getFetchEventListener=function(){var e=this;return function(t){t.respondWith(e.processRequest(t.request))}},u.prototype.processRequest=function(e){var n=this,r=t.buildEndpointKey(e);return new Promise(function(i,u){s.registerEndpointOptions(r,n._options);var a=f(n,e),l={},c=e.clone();o.log("Offline Persistence Toolkit DefaultResponseProxy: Calling requestHandler for request with enpointKey: "+r),a.call(n,e).then(function(i){return t.isCachedResponse(i)&&(o.log("Offline Persistence Toolkit DefaultResponseProxy: Response is cached for request with enpointKey: "+r),l.isCachedResponse=!0),i.ok?(o.log("Offline Persistence Toolkit DefaultResponseProxy: Response is ok for request with enpointKey: "+r),y(n,e,i)):(o.log("Offline Persistence Toolkit DefaultResponseProxy: Response is not ok for request with enpointKey: "+r),i)}).then(function(t){return l.response=t,t.ok?(o.log("Offline Persistence Toolkit DefaultResponseProxy: Response is ok after cacheStrategy for request with enpointKey: "+r),w(e,t)):(o.log("Offline Persistence Toolkit DefaultResponseProxy: Response is not ok after cacheStrategy for request with enpointKey: "+r),null)}).then(function(t){return b(e,t,l.isCachedResponse)}).then(function(){s.unregisterEndpointOptions(r),i(l.response)}).catch(function(e){o.log("Offline Persistence Toolkit DefaultResponseProxy: Insert Response in syncManager after error for request with enpointKey: "+r),b(c,null,!0).then(function(){s.unregisterEndpointOptions(r),u(e)},function(){s.unregisterEndpointOptions(r),u(e)})})})},u.prototype.handlePost=function(e){return o.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default POST Handler"),l(e)},u.prototype.handleGet=function(e){return o.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default GET Handler"),c(this,e)},u.prototype.handleHead=function(e){return o.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default HEAD Handler"),c(this,e)},u.prototype.handleOptions=function(e){return o.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default OPTIONS Handler"),l(e)},u.prototype.handlePut=function(e){return o.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default PUT Handler"),h(this,e)},u.prototype.handlePatch=function(e){return o.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default PATCH Handler"),l(e)},u.prototype.handleDelete=function(e){return o.log("Offline Persistence Toolkit DefaultResponseProxy: Processing Request with default DELETE Handler"),d(this,e)},{getResponseProxy:a}}),define("persist/simpleJsonShredding",["./persistenceUtils","./impl/logger"],function(e,t){"use strict";function i(e){if(!e||e.length!==1)throw new Error({message:"shredded data is not in the correct format."});var t=e[0].data;return t&&t.length===1&&e[0].resourceType==="single"?t[0]:t}var n=function(e,n){return function(r){t.log("Offline Persistence Toolkit simpleJsonShredding: Shredding Response");var i=r.clone(),s=i.headers.get("Etag");return i.text().then(function(r){var i=[],o=[],u="collection";if(r&&r.length>0)try{var a=JSON.parse(r);if(Array.isArray(a))i=a.map(function(e){if(n instanceof Array){var t=[];return n.forEach(function(n){t.push(e[n])}),t}return e[n]}),o=a;else{if(n instanceof Array){var f=[];n.forEach(function(e){f.push(a[e])}),i[0]=f}else i[0]=a[n];o[0]=a,u="single"}}catch(l){t.log("Offline Persistence Toolkit simpleRestJsonShredding: Error during shredding: "+l)}return[{name:e,resourceIdentifier:s,keys:i,data:o,resourceType:u}]})}},r=function(){return function(n,r){return t.log("Offline Persistence Toolkit simpleJsonShredding: Unshredding Response"),Promise.resolve().then(function(){var t=i(n);return e.setResponsePayload(r,t)}).then(function(e){return e.headers.set("x-oracle-jscpt-cache-expiration-date",""),Promise.resolve(e)})}};return{getShredder:n,getUnshredder:r}}),define("persist/oracleRestJsonShredding",["./persistenceUtils","./impl/logger"],function(e,t){"use strict";function i(e,t){if(!e||e.length!==1)throw new Error({message:"shredded data is not in the correct format."});var n,r=e[0].data;return r&&r.length===1&&e[0].resourceType==="single"?n=r[0]:n={items:r,count:r.length},n}var n=function(e,n){return function(r){t.log("Offline Persistence Toolkit oracleRestJsonShredding: Shredding Response");var i=r.clone(),s=i.headers.get("X-ORACLE-DMS-ECID");return i.text().then(function(r){var i=[],o=[],u="collection";if(r!=null&&r.length>0)try{var a=JSON.parse(r);if(a.items!=null)i=a.items.map(function(e){if(n instanceof Array){var t=[];return n.forEach(function(n){t.push(e[n])}),t}return e[n]}),o=a.items;else{if(n instanceof Array){var f=[];n.forEach(function(e){f.push(a[e])}),i[0]=f}else i[0]=a[n];o[0]=a,u="single"}}catch(l){t.log("Offline Persistence Toolkit oracleRestJsonShredding: Error during shredding: "+l)}return[{name:e,resourceIdentifier:s,keys:i,data:o,resourceType:u}]})}},r=function(){return function(n,r){t.log("Offline Persistence Toolkit oracleRestJsonShredding: Unshredding Response");var s=i(n,r);return e.setResponsePayload(r,s).then(function(e){return e.headers.set("x-oracle-jscpt-cache-expiration-date",""),e})}};return{getShredder:n,getUnshredder:r}}),define("persist/simpleBinaryDataShredding",["./persistenceUtils"],function(e){"use strict";function r(e){if(!e||e.length!==1)throw new Error({message:"shredded data is not in the correct format."});var t=e[0].data;return t&&t.length===1&&e[0].resourceType==="single"?t[0]:t}var t=function(e){return function(t){var n=t.clone(),r=n.headers.get("Etag");return n.blob().then(function(n){var i=[],s=[];return i[0]=t.url==null||t.url.length==0?t.headers.get("x-oracle-jscpt-response-url"):t.url,s[0]=n,[{name:e,resourceIdentifier:r,keys:i,data:s,resourceType:"single"}]})}},n=function(){return function(t,n){var i=r(t);return e.setResponsePayload(n,i).then(function(e){return e.headers.set("x-oracle-jscpt-cache-expiration-date",""),Promise.resolve(e)})}};return{getShredder:t,getUnshredder:n}}),!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define("persist/impl/sql-where-parser.min",[],e);else{var t;t="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,t.SqlWhereParser=e()}}(function(){var e;return function t(e,n,r){function i(o,u){if(!n[o]){if(!e[o]){var a="function"==typeof require&&require;if(!u&&a)return a(o,!0);if(s)return s(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};e[o][0].call(l.exports,function(t){var n=e[o][1][t];return i(n?n:t)},l,l.exports,t,e,n,r)}return n[o].exports}for(var s="function"==typeof require&&require,o=0;o<r.length;o++)i(r[o]);return i}({1:[function(e,t,n){"use strict";function r(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function i(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}var s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},o=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),u=e("es6-symbol"),a=e("tokenize-this"),f=u("-"),l=1,c=2,h=3,p=i({},f,l),d=function(){function e(t,n,i){r(this,e),this.value=t,this.type=n,this.precedence=i}return o(e,[{key:"toJSON",value:function(){return this.value}},{key:"toString",value:function(){return""+this.value}}]),e}(),v=function(){function e(t){var n=this;r(this,e),t||(t={}),t=Object.assign({},this.constructor.defaultConfig,t),this.tokenizer=new a(t.tokenizer),this.operators={},t.operators.forEach(function(e,t){Object.keys(e).concat(Object.getOwnPropertySymbols(e)).forEach(function(r){n.operators[r]=new d(r,e[r],t)})})}return o(e,[{key:"parse",value:function(e,t){var n=this,r=[],i=[],s=void 0,o=0,u=!1;for(t||(t=this.defaultEvaluator),this.tokenizer.tokenize("("+e+")",function(e,a){if(o++,"string"!=typeof e||a)i.push(e),u=!1;else{var l=e.toUpperCase();if(n.operators[l]){if("BETWEEN"===s&&"AND"===l)return void (s="AND");for("-"!==l||1!==o&&!u||(l=f);r[r.length-1]&&"("!==r[r.length-1]&&n.operatorPrecedenceFromValues(l,r[r.length-1]);){for(var c=n.operators[r.pop()],h=[],p=c.type;p--;)h.unshift(i.pop());i.push(t(c.value,h))}r.push(l),s=l,u=!0}else if("("===e)r.push(e),u=!0;else if(")"===e){for(;r.length&&"("!==r[r.length-1];){for(var d=n.operators[r.pop()],v=[],m=d.type;m--;)v.unshift(i.pop());i.push(t(d.value,v))}if(!r.length)throw new SyntaxError("Unmatched parenthesis.");r.pop(),u=!1}else i.push(e),u=!1}});r.length;){var a=r.pop();if("("===a)throw new SyntaxError("Unmatched parenthesis.");for(var l=this.operators[a],c=[],h=l.type;h--;)c.unshift(i.pop());i.push(t(l.value,c))}if(i.length>1)throw new SyntaxError("Could not reduce to a single expression.");return i[0]}},{key:"toArray",value:function(e){var t=this,n=[],r=0,i=void 0,s=[];for(this.tokenizer.tokenize("("+e+")",function(e,o){switch(r++,e){case"(":s.push(n.length);break;case")":for(var u=s.pop(),a=n.splice(u,n.length);a&&a.constructor===Array&&1===a.length;)a=a[0];n.push(a);break;case"":break;case",":break;default:var l=null;o||(l=t.getOperator(e),"-"===e&&(1===r||"("===i||i&&i.constructor===d)&&(l=t.getOperator(f))),n.push(l?l:e)}i=e});n&&n.constructor===Array&&1===n.length;)n=n[0];return n}},{key:"operatorPrecedenceFromValues",value:function(e,t){return this.operators[t].precedence<=this.operators[e].precedence}},{key:"getOperator",value:function(e){return"string"==typeof e?this.operators[e.toUpperCase()]:"symbol"===("undefined"==typeof e?"undefined":s(e))?this.operators[e]:null}},{key:"defaultEvaluator",value:function(e,t){return e===f&&(e="-"),","===e?[].concat(t[0],t[1]):i({},e,t)}}],[{key:"defaultConfig",get:function(){return{operators:[{"!":l},p,{"^":c},{"*":c,"/":c,"%":c},{"+":c,"-":c},{"=":c,"<":c,">":c,"<=":c,">=":c,"!=":c},{",":c},{NOT:l},{BETWEEN:h,IN:c,IS:c,LIKE:c},{AND:c},{OR:c}],tokenizer:{shouldTokenize:["(",")",",","*","/","%","+","-","=","!=","!","<",">","<=",">=","^"],shouldMatch:['"',"'","`"],shouldDelimitBy:[" ","\n","\r","	"]}}}},{key:"Operator",get:function(){return d}},{key:"OPERATOR_UNARY_MINUS",get:function(){return f}}]),e}();t.exports=v},{"es6-symbol":2,"tokenize-this":20}],2:[function(e,t,n){"use strict";t.exports=e("./is-implemented")()?Symbol:e("./polyfill")},{"./is-implemented":3,"./polyfill":18}],3:[function(e,t,n){"use strict";var r={object:!0,symbol:!0};t.exports=function(){var e;if("function"!=typeof Symbol)return!1;e=Symbol("test symbol");try{String(e)}catch(e){return!1}return!!r[typeof Symbol.iterator]&&!!r[typeof Symbol.toPrimitive]&&!!r[typeof Symbol.toStringTag]}},{}],4:[function(e,t,n){"use strict";t.exports=function(e){return!!e&&("symbol"==typeof e||!!e.constructor&&"Symbol"===e.constructor.name&&"Symbol"===e[e.constructor.toStringTag])}},{}],5:[function(e,t,n){"use strict";var r,i=e("es5-ext/object/assign"),s=e("es5-ext/object/normalize-options"),o=e("es5-ext/object/is-callable"),u=e("es5-ext/string/#/contains");r=t.exports=function(e,t){var n,r,o,a,f;return arguments.length<2||"string"!=typeof e?(a=t,t=e,e=null):a=arguments[2],null==e?(n=o=!0,r=!1):(n=u.call(e,"c"),r=u.call(e,"e"),o=u.call(e,"w")),f={value:t,configurable:n,enumerable:r,writable:o},a?i(s(a),f):f},r.gs=function(e,t,n){var r,a,f,l;return"string"!=typeof e?(f=n,n=t,t=e,e=null):f=arguments[3],null==t?t=void 0:o(t)?null==n?n=void 0:o(n)||(f=n,n=void 0):(f=t,t=n=void 0),null==e?(r=!0,a=!1):(r=u.call(e,"c"),a=u.call(e,"e")),l={get:t,set:n,configurable:r,enumerable:a},f?i(s(f),l):l}},{"es5-ext/object/assign":6,"es5-ext/object/is-callable":9,"es5-ext/object/normalize-options":13,"es5-ext/string/#/contains":15}],6:[function(e,t,n){"use strict";t.exports=e("./is-implemented")()?Object.assign:e("./shim")},{"./is-implemented":7,"./shim":8}],7:[function(e,t,n){"use strict";t.exports=function(){var e,t=Object.assign;return"function"==typeof t&&(e={foo:"raz"},t(e,{bar:"dwa"},{trzy:"trzy"}),e.foo+e.bar+e.trzy==="razdwatrzy")}},{}],8:[function(e,t,n){"use strict";var r=e("../keys"),i=e("../valid-value"),s=Math.max;t.exports=function(e,t){var n,u,a,f=s(arguments.length,2);for(e=Object(i(e)),a=function(e){try{r[e]=t[e]}catch(r){n||(n=r)}},u=1;u<f;++u)t=arguments[u],r(t).forEach(a);if(void 0!==n)throw n;return e}},{"../keys":10,"../valid-value":14}],9:[function(e,t,n){"use strict";t.exports=function(e){return"function"==typeof e}},{}],10:[function(e,t,n){"use strict";t.exports=e("./is-implemented")()?Object.keys:e("./shim")},{"./is-implemented":11,"./shim":12}],11:[function(e,t,n){"use strict";t.exports=function(){try{return Object.keys("primitive"),!0}catch(e){return!1}}},{}],12:[function(e,t,n){"use strict";var r=Object.keys;t.exports=function(e){return r(null==e?e:Object(e))}},{}],13:[function(e,t,n){"use strict";var r=Array.prototype.forEach,i=Object.create,s=function(e,t){var n;for(n in e)t[n]=e[n]};t.exports=function(e){var t=i(null);return r.call(arguments,function(e){null!=e&&s(Object(e),t)}),t}},{}],14:[function(e,t,n){"use strict";t.exports=function(e){if(null==e)throw new TypeError("Cannot use null or undefined");return e}},{}],15:[function(e,t,n){"use strict";t.exports=e("./is-implemented")()?String.prototype.contains:e("./shim")},{"./is-implemented":16,"./shim":17}],16:[function(e,t,n){"use strict";var r="razdwatrzy";t.exports=function(){return"function"==typeof r.contains&&r.contains("dwa")===!0&&r.contains("foo")===!1}},{}],17:[function(e,t,n){"use strict";var r=String.prototype.indexOf;t.exports=function(e){return r.call(this,e,arguments[1])>-1}},{}],18:[function(e,t,n){"use strict";var r,i,s,o,u=e("d"),a=e("./validate-symbol"),f=Object.create,l=Object.defineProperties,c=Object.defineProperty,h=Object.prototype,p=f(null);if("function"==typeof Symbol){r=Symbol;try{String(r()),o=!0}catch(e){}}var d=function(){var e=f(null);return function(t){for(var n,r,i=0;e[t+(i||"")];)++i;return t+=i||"",e[t]=!0,n="@@"+t,c(h,n,u.gs(null,function(e){r||(r=!0,c(this,n,u(e)),r=!1)})),n}}();s=function(e){if(this instanceof s)throw new TypeError("TypeError: Symbol is not a constructor");return i(e)},t.exports=i=function v(e){var t;if(this instanceof v)throw new TypeError("TypeError: Symbol is not a constructor");return o?r(e):(t=f(s.prototype),e=void 0===e?"":String(e),l(t,{__description__:u("",e),__name__:u("",d(e))}))},l(i,{"for":u(function(e){return p[e]?p[e]:p[e]=i(String(e))}),keyFor:u(function(e){var t;a(e);for(t in p)if(p[t]===e)return t}),hasInstance:u("",r&&r.hasInstance||i("hasInstance")),isConcatSpreadable:u("",r&&r.isConcatSpreadable||i("isConcatSpreadable")),iterator:u("",r&&r.iterator||i("iterator")),match:u("",r&&r.match||i("match")),replace:u("",r&&r.replace||i("replace")),search:u("",r&&r.search||i("search")),species:u("",r&&r.species||i("species")),split:u("",r&&r.split||i("split")),toPrimitive:u("",r&&r.toPrimitive||i("toPrimitive")),toStringTag:u("",r&&r.toStringTag||i("toStringTag")),unscopables:u("",r&&r.unscopables||i("unscopables"))}),l(s.prototype,{constructor:u(i),toString:u("",function(){return this.__name__})}),l(i.prototype,{toString:u(function(){return"Symbol ("+a(this).__description__+")"}),valueOf:u(function(){return a(this)})}),c(i.prototype,i.toPrimitive,u("",function(){var e=a(this);return"symbol"==typeof e?e:e.toString()})),c(i.prototype,i.toStringTag,u("c","Symbol")),c(s.prototype,i.toStringTag,u("c",i.prototype[i.toStringTag])),c(s.prototype,i.toPrimitive,u("c",i.prototype[i.toPrimitive]))},{"./validate-symbol":19,d:5}],19:[function(e,t,n){"use strict";var r=e("./is-symbol");t.exports=function(e){if(!r(e))throw new TypeError(e+" is not a symbol");return e}},{"./is-symbol":4}],20:[function(n,r,i){(function(s){!function(n){if("object"==typeof i&&"undefined"!=typeof r)r.exports=n();else if("function"==typeof e&&e.amd)e([],n);else{var u;u="undefined"!=typeof window?window:"undefined"!=typeof s?s:"undefined"!=typeof self?self:this,u.TokenizeThis=n()}}(function(){return function e(t,r,i){function s(u,a){if(!r[u]){if(!t[u]){var f="function"==typeof n&&n;if(!a&&f)return f(u,!0);if(o)return o(u,!0);var l=new Error("Cannot find module '"+u+"'");throw l.code="MODULE_NOT_FOUND",l}var c=r[u]={exports:{}};t[u][0].call(c.exports,function(e){var n=t[u][1][e];return s(n?n:e)},c,c.exports,e,t,r,i)}return r[u].exports}for(var o="function"==typeof n&&n,u=0;u<i.length;u++)s(i[u]);return s}({1:[function(e,t,n){"use strict";function r(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var i=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),s="modeNone",o="modeDefault",u="modeMatch",a=function(e,t){return e.length>t.length?-1:e.length<t.length?1:0},f=function(){function e(t,n,i){r(this,e),this.factory=t,this.str=n,this.forEachToken=i,this.previousChr="",this.toMatch="",this.currentToken="",this.modeStack=[s]}return i(e,[{key:"getCurrentMode",value:function(){return this.modeStack[this.modeStack.length-1]}},{key:"setCurrentMode",value:function(e){return this.modeStack.push(e)}},{key:"completeCurrentMode",value:function(){var e=this.getCurrentMode();return e===o&&this.pushDefaultModeTokenizables(),(e===u&&""===this.currentToken||""!==this.currentToken)&&this.push(this.currentToken),this.currentToken="",this.modeStack.pop()}},{key:"push",value:function(e){var t="";if(this.factory.convertLiterals&&this.getCurrentMode()!==u)switch(e.toLowerCase()){case"null":e=null;break;case"true":e=!0;break;case"false":e=!1;break;default:isFinite(e)&&(e=Number(e))}else t=this.toMatch;this.forEachToken&&this.forEachToken(e,t)}},{key:"tokenize",value:function(){for(var e=0;e<this.str.length;)this.consume(this.str.charAt(e++));for(;this.getCurrentMode()!==s;)this.completeCurrentMode()}},{key:"consume",value:function(e){this[this.getCurrentMode()](e),this.previousChr=e}},{key:s,value:function(e){return this.factory.matchMap[e]?(this.setCurrentMode(u),void (this.toMatch=e)):(this.setCurrentMode(o),this.consume(e))}},{key:o,value:function(e){return this.factory.delimiterMap[e]?this.completeCurrentMode():this.factory.matchMap[e]?(this.completeCurrentMode(),this.consume(e)):(this.currentToken+=e,this.currentToken)}},{key:"pushDefaultModeTokenizables",value:function(){for(var e=0,t=1/0,n=null;this.currentToken&&e<this.factory.tokenizeList.length;){var r=this.factory.tokenizeList[e++],i=this.currentToken.indexOf(r);i!==-1&&i<t&&(t=i,n=r)}if(n)return t>0&&this.push(this.currentToken.substring(0,t)),t!==-1?(this.push(n),this.currentToken=this.currentToken.substring(t+n.length),this.pushDefaultModeTokenizables()):void 0}},{key:u,value:function(e){if(e===this.toMatch){if(this.previousChr!==this.factory.escapeCharacter)return this.completeCurrentMode();this.currentToken=this.currentToken.substring(0,this.currentToken.length-1)}return this.currentToken+=e,this.currentToken}}]),e}(),l=function(){function e(t){var n=this;r(this,e),t||(t={}),t=Object.assign({},this.constructor.defaultConfig,t),this.convertLiterals=t.convertLiterals,this.escapeCharacter=t.escapeCharacter,this.tokenizeList=[],this.tokenizeMap={},this.matchList=[],this.matchMap={},this.delimiterList=[],this.delimiterMap={},t.shouldTokenize.sort(a).forEach(function(e){n.tokenizeMap[e]||(n.tokenizeList.push(e),n.tokenizeMap[e]=e)}),t.shouldMatch.forEach(function(e){n.matchMap[e]||(n.matchList.push(e),n.matchMap[e]=e)}),t.shouldDelimitBy.forEach(function(e){n.delimiterMap[e]||(n.delimiterList.push(e),n.delimiterMap[e]=e)})}return i(e,[{key:"tokenize",value:function(e,t){var n=new f(this,e,t);return n.tokenize()}}],[{key:"defaultConfig",get:function(){return{shouldTokenize:["(",")",",","*","/","%","+","-","=","!=","!","<",">","<=",">=","^"],shouldMatch:['"',"'","`"],shouldDelimitBy:[" ","\n","\r","	"],convertLiterals:!0,escapeCharacter:"\\"}}}]),e}();t.exports=l},{}]},{},[1])(1)})}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}]},{},[1])(1)}),define("persist/queryHandlers",["./persistenceManager","./persistenceStoreManager","./persistenceUtils","./impl/logger","./impl/sql-where-parser.min"],function(e,t,n,r,i){"use strict";function s(e,t){return t=t||function(e){return u(e,null)},function(i,s){if(i.method=="GET"||i.method=="HEAD"){r.log("Offline Persistence Toolkit queryHandlers: OracleRestQueryHandler processing request");var u=i.url.split("?"),a={},f,c;typeof URLSearchParams=="undefined"?c=l(u[1]):c=(new URLSearchParams(u[1])).entries();var h,p,d,v,m;do h=c.next(),h["value"]!=null&&(p=h.value[0],d=h.value[1],p=="q"?f=d:p=="limit"?v=d:p=="offset"&&(m=d));while(!h.done);var a=t(f),g,y;s["jsonProcessor"]!=null&&(g=s.jsonProcessor.shredder,y=s.jsonProcessor.unshredder);if(g!=null&&y!=null)return o(i,e,a,g,y,m,v).then(function(e){if(!e)return Promise.resolve();var t=e.clone();return t.text().then(function(t){if(t!=null&&t.length>0)try{var r=JSON.parse(t);return r.links?Promise.resolve(e):(r.links=[{rel:"self",href:i.url}],n.setResponsePayload(e,r).then(function(e){return Promise.resolve(e)}))}catch(s){}})})}return Promise.resolve()}}function o(r,i,s,o,u,a,f){return e.getCache().hasMatch(r,{ignoreSearch:!0}).then(function(l){return t.openStore(i).then(function(t){if(l)return e.getCache().match(r,{ignoreSearch:!0}).then(function(e){return e.headers.get("x-oracle-jscpt-resource-type")==="single"?Promise.resolve():t.find(s)});var n=h(r);return n?t.findByKey(n):Promise.resolve([])}).then(function(t){return e.getCache().match(r,{ignoreSearch:!0}).then(function(s){if(s){var l=!1,c=0;return t&&(c=t.length,a&&a>0&&(a<t.length?l=!0:l=!1,t=t.slice(a,t.length)),f&&f>0&&(f<=t.length?l=!0:l=!1,t=t.slice(0,f))),o(s).then(function(e){var r=e[0].resourceType,o={name:i,data:t!=null?t:e[0].data,resourceType:r};return u([o],s).then(function(e){var t=e.clone();return t.text().then(function(t){if(!(t!=null&&t.length>0))return e;try{var r=JSON.parse(t);return r.items!=null&&(f&&(r.limit=parseInt(f,10)),a&&(r.offset=parseInt(a,10)),r.hasMore=l,r.totalResults=c),n.setResponsePayload(e,r)}catch(i){}})})})}if(t&&Object.keys(t).length>0){var h=p(r);return h?n.requestToJSON(r).then(function(r){return r.url=h,n.requestFromJSON(r).then(function(n){return e.getCache().match(n,{ignoreSearch:!0}).then(function(e){if(e){var n={name:i,data:[t],resourceType:"single"};return u([n],e)}})})}):Promise.resolve()}return Promise.resolve()})})})}function u(e){var t={};if(e){var n=new i,r=e.split(";"),s,o={},u=[],a={};for(s=0;s<r.length;s++)a=n.parse(r[s],function(e,t){e=e.toUpperCase(),e!="AND"&&e!="OR"&&(t[0]="value."+t[0]);var n=t[0],r=t[1],i={};switch(e){case">":i[n]={$gt:r};break;case"<":i[n]={$lt:r};break;case">=":i[n]={$gte:r};break;case"<=":i[n]={$lte:r};break;case"=":i[n]={$eq:r};break;case"!=":i[n]={$ne:r};break;case"AND":i={$and:t};break;case"OR":i={$or:t};break;case"LIKE":r=r.replace("%",".+"),i[n]={$regex:r};break;case"BETWEEN":var s=[];s[0]={},s[1]={},s[0][n]={$gte:t[1]},s[1][n]={$lte:t[2]},i={$and:s}}return i}),u.push(a);u.length>1?o.$and=u:u.length==1&&(o=u[0]),Object.keys(o).length>0&&(t.selector=o)}return t}function a(e,t){return function(n,i){if(n.method=="GET"||n.method=="HEAD"){r.log("Offline Persistence Toolkit queryHandlers: SimpleQueryHandler processing request");var s=n.url.split("?"),u=f(s,t),a,l;i["jsonProcessor"]!=null&&(a=i.jsonProcessor.shredder,l=i.jsonProcessor.unshredder);if(a!=null&&l!=null)return o(n,e,u,a,l)}return Promise.resolve()}}function f(e,t){var n={};if(e&&e.length>1){var r={},i;typeof URLSearchParams=="undefined"?i=l(e[1]):i=(new URLSearchParams(e[1])).entries();var s,o,u;do{s=i.next();if(s["value"]!=null){o=s.value[0],u=s.value[1];if(!t||t.indexOf(o)==-1)r["value."+o]=u}}while(!s.done);Object.keys(r).length>0&&(n.selector=r)}return n}function l(e){var t=[];if(e!=null){e.charAt(0)==="?"&&(e=e.slice(1)),e=e||"";var n=e.split("&"),r,i,s;t=n.map(function(e){return s=e.indexOf("="),s>-1?(r=e.slice(0,s),i=e.slice(s+1),i=c(i)):(r=e,i=""),r=c(r),[r,i]})}var o={next:function(){var e=t.shift();return{done:e===undefined,value:e}}};return o}function c(e){return decodeURIComponent(e.replace(/\+/g," "))}function h(e){var t=e.url.split("/");return t.length>1?t[t.length-1].split("?")[0]:null}function p(e){var t=e.url.split("/");return t.length>1?(t.pop(),t.join("/")):null}return{getSimpleQueryHandler:a,getOracleRestQueryHandler:s}});