/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ApacheScanner;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ContainerDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Directive;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveFactory;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveList;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.FileLevelContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.IncludeDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Parameter;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParameterList;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Parser;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserException;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.PerlContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.PerlParser;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.PrimitiveDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Token;

public class ApacheParser
implements Parser {
    private ApacheScanner m_scanner;
    private Token m_nextToken;

    public ApacheParser(InputStream inputStream) throws ParserException {
        this(new InputStreamReader(inputStream));
    }

    public ApacheParser(Reader reader) throws ParserException {
        this.m_scanner = new ApacheScanner(reader);
        this.nextToken();
    }

    public FileLevelContainer parse() throws ParserException {
        DirectiveList directiveList = this.directiveList();
        if (this.m_nextToken.getID() != 0) {
            throw new ParserException("End of File <EOF>, <IDENTIFIER> or < expected", this.m_nextToken);
        }
        return new FileLevelContainer("", directiveList);
    }

    private DirectiveList directiveList() throws ParserException {
        DirectiveList directiveList = new DirectiveList();
        while (this.m_nextToken.getID() == 1) {
            this.nextToken();
        }
        Directive directive = this.directive();
        while (directive != null) {
            directiveList.add(directive);
            while (this.m_nextToken.getID() == 1) {
                this.nextToken();
            }
            directive = this.directive();
        }
        return directiveList;
    }

    private Directive directive() throws ParserException {
        Token token = this.m_nextToken.getSpecialToken();
        Directive directive = this.containerDirective();
        if (directive == null && (directive = this.primitiveDirective()) != null && directive instanceof IncludeDirective) {
            ApacheParser apacheParser;
            String string = ((IncludeDirective)directive).getFilePath();
            try {
                apacheParser = new ApacheParser(new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ParserException(fileNotFoundException.getMessage());
            }
            FileLevelContainer fileLevelContainer = apacheParser.parse();
            fileLevelContainer.setFilePath(string, false);
            ((IncludeDirective)directive).setIncludedConfig(fileLevelContainer, false);
        }
        if (directive != null && token != null) {
            directive.setComment(token.getValue(), false);
        }
        return directive;
    }

    private PrimitiveDirective primitiveDirective() throws ParserException {
        if (this.m_nextToken.getID() == 5) {
            String string = this.m_nextToken.getValue();
            this.nextToken();
            ParameterList parameterList = this.parameterList();
            if (this.m_nextToken.getID() != 1 && this.m_nextToken.getID() != 0) {
                throw new ParserException("End of line <EOL> or end of file <EOF> expected", this.m_nextToken);
            }
            this.nextToken();
            return DirectiveFactory.createPrimitiveDirective(string, parameterList, false);
        }
        return null;
    }

    private ContainerDirective containerDirective() throws ParserException {
        if (this.m_nextToken.getID() == 9) {
            String string = this.m_nextToken.getValue();
            this.nextToken();
            int n = string.indexOf("<Perl>");
            int n2 = string.lastIndexOf("</Perl>");
            n += 6;
            while (Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            String string2 = string.substring(n, n2);
            PerlParser perlParser = new PerlParser(string2);
            PerlContainer perlContainer = perlParser.parse();
            return perlContainer;
        }
        if (this.m_nextToken.getID() != 2) {
            return null;
        }
        this.nextToken();
        if (this.m_nextToken.getID() != 5) {
            throw new ParserException("A container name <IDENTIFIER> expected", this.m_nextToken);
        }
        String string = this.m_nextToken.getValue();
        this.nextToken();
        ParameterList parameterList = this.parameterList();
        if (this.m_nextToken.getID() != 3) {
            throw new ParserException("> expected", this.m_nextToken);
        }
        this.nextToken();
        if (this.m_nextToken.getID() != 1) {
            throw new ParserException("End of line expected", this.m_nextToken);
        }
        this.nextToken();
        DirectiveList directiveList = this.directiveList();
        if (this.m_nextToken.getID() != 4) {
            throw new ParserException("</ expected", this.m_nextToken);
        }
        this.nextToken();
        if (this.m_nextToken.getID() != 5) {
            throw new ParserException("container name " + string + " expected", this.m_nextToken);
        }
        String string3 = this.m_nextToken.getValue();
        if (!string3.equals(string)) {
            throw new ParserException(String.valueOf(string) + " expected", this.m_nextToken);
        }
        this.nextToken();
        if (this.m_nextToken.getID() != 3) {
            throw new ParserException("> expected", this.m_nextToken);
        }
        this.nextToken();
        if (this.m_nextToken.getID() != 1 && this.m_nextToken.getID() != 0) {
            throw new ParserException("End of line <EOL> or end of file <EOF> expected", this.m_nextToken);
        }
        this.nextToken();
        ContainerDirective containerDirective = DirectiveFactory.createContainerDirective(string, parameterList, false);
        containerDirective.add(directiveList, false);
        return containerDirective;
    }

    private ParameterList parameterList() throws ParserException {
        ParameterList parameterList = new ParameterList();
        Parameter parameter = this.parameter();
        while (parameter != null) {
            parameterList.add(parameter);
            parameter = this.parameter();
        }
        return parameterList;
    }

    private Parameter parameter() throws ParserException {
        if (this.m_nextToken.getID() == 5 || this.m_nextToken.getID() == 6 || this.m_nextToken.getID() == 7) {
            Parameter parameter = new Parameter(this.m_nextToken.getValue());
            this.nextToken();
            return parameter;
        }
        return null;
    }

    private void nextToken() throws ParserException {
        this.m_nextToken = this.m_scanner.nextToken();
    }
}

