/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.CharBuffer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserException;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Token;

public class ApacheScanner {
    private static final int STATE_START = 0;
    private static final int STATE_ACCEPT = 1;
    private static final int STATE_COMMENT = 2;
    private static final int STATE_IDENTIFIER = 3;
    private static final int STATE_LITERAL_STRING = 4;
    private static final int STATE_NON_LITERAL_STRING = 5;
    private static final int STATE_PERL_SECTION = 6;
    private static final int TEMPBUF_SIZE = 1024;
    private int m_state = 0;
    private char m_nextChar;
    private String m_tokenValue = new String();
    private char[] m_tempBuf = new char[1024];
    private int m_tempBufIndex;
    private CharBuffer m_charBuffer;
    private Token m_specialToken;
    private Vector m_queuedTokenList = new Vector();

    public ApacheScanner(Reader reader) throws ParserException {
        this.m_charBuffer = new CharBuffer(reader);
        this.nextChar();
    }

    public ApacheScanner(InputStream inputStream) throws ParserException {
        this.m_charBuffer = new CharBuffer(new InputStreamReader(inputStream));
        this.nextChar();
    }

    private void init() {
        this.m_state = 0;
        this.m_tempBufIndex = 0;
        this.m_tokenValue = new String();
    }

    public Token nextToken() throws ParserException {
        if (this.m_queuedTokenList.size() > 0) {
            Token token = (Token)this.m_queuedTokenList.elementAt(0);
            this.m_queuedTokenList.removeElementAt(0);
            return token;
        }
        return this.makeToken();
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private Token makeToken() throws ParserException {
        var1_1 = null;
        var2_2 = false;
        while (!var2_2) {
            this.init();
            var3_3 = 0;
            var4_4 = 0;
            block9: while (this.m_state != 1) {
                block40: {
                    cfr_temp_0 = -2147483648;
                    while (true) {
                        switch (cfr_temp_0 == -2147483648 ? this.m_state : cfr_temp_0) {
                            case 0: {
                                var3_3 = this.m_charBuffer.getCurLineNumber();
                                var4_4 = this.m_charBuffer.getCurColumnNumber();
                                if (this.m_nextChar == '\uffff') {
                                    var1_1 = new Token(0, "");
                                    this.switchTo(1);
                                    continue block9;
                                }
                                if (!this.isWhiteSpace(this.m_nextChar)) {
                                    if (this.m_nextChar == '\\') {
                                        var5_5 = this.lookAheadNewLine();
                                        if (var5_5 > 0) {
                                            this.advance(var5_5 + 1);
                                            continue block9;
                                        }
                                        this.switchTo(5);
                                        continue block9;
                                    }
                                    if (this.m_nextChar == '<') {
                                        if (this.lookAheadString("Perl>") > 0) {
                                            this.switchTo(6);
                                            continue block9;
                                        }
                                        if (this.getChar(1) == '/') {
                                            this.nextChar();
                                            var1_1 = new Token(4, "</");
                                        } else {
                                            var1_1 = new Token(2, "<");
                                        }
                                        this.nextChar();
                                        this.switchTo(1);
                                        continue block9;
                                    }
                                    if (this.m_nextChar == '>') {
                                        var1_1 = new Token(3, ">");
                                        this.nextChar();
                                        this.switchTo(1);
                                        continue block9;
                                    }
                                    if (this.m_nextChar == '\n') {
                                        var1_1 = new Token(1, "\n");
                                        this.nextChar();
                                        this.switchTo(1);
                                        continue block9;
                                    }
                                    if (this.isIdentifierChar(this.m_nextChar)) {
                                        this.storeChar(this.m_nextChar);
                                        this.nextChar();
                                        this.switchTo(3);
                                        continue block9;
                                    }
                                    if (this.m_nextChar == '\"') {
                                        this.storeChar(this.m_nextChar);
                                        this.nextChar();
                                        this.switchTo(4);
                                        continue block9;
                                    }
                                    if (this.m_nextChar == '#') {
                                        this.storeChar(this.m_nextChar);
                                        this.nextChar();
                                        this.switchTo(2);
                                        continue block9;
                                    }
                                    this.storeChar(this.m_nextChar);
                                    this.nextChar();
                                    this.switchTo(5);
                                    continue block9;
                                }
                                ** GOTO lbl87
                            }
                            case 6: {
                                this.storeChar("<Perl>");
                                this.advance(6);
                                while (true) {
                                    if (this.m_state == 1 || this.m_nextChar == '\uffff') {
                                        if (this.m_state == 1) continue block9;
                                        throw new ParserException("</Perl> is expected");
                                    }
                                    if (this.m_nextChar == '<' && this.lookAheadString("/Perl>") > 0) {
                                        this.storeChar("</Perl>");
                                        this.advance(7);
                                        var1_1 = new Token(9, this.getTokenValue());
                                        this.switchTo(1);
                                        continue;
                                    }
                                    this.storeChar(this.m_nextChar);
                                    this.nextChar();
                                }
                            }
                            default: {
                                continue block9;
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.nextChar();
lbl87:
                                // 2 sources

                                ** while (this.isWhiteSpace((char)this.m_nextChar))
                            }
lbl88:
                            // 1 sources

                            continue block9;
                            while (true) {
                                this.storeChar(this.m_nextChar);
                                cfr_temp_0 = 3;
                                this.nextChar();
                                break;
                            }
                            case 3: {
                                if (this.isIdentifierChar(this.m_nextChar)) ** continue;
                                if (!this.isNonLiteralStringChar(this.m_nextChar)) {
                                    var1_1 = new Token(5, this.getTokenValue());
                                    this.switchTo(1);
                                    continue block9;
                                }
                                this.switchTo(5);
                                continue block9;
                            }
                            while (true) {
                                this.storeChar(this.m_nextChar);
                                cfr_temp_0 = 4;
                                this.nextChar();
                                break;
                            }
                            case 4: {
                                if (this.m_nextChar != '\"' && this.m_nextChar != '\\' && this.m_nextChar != '\uffff') ** continue;
                                if (this.m_nextChar == '\"') {
                                    this.storeChar(this.m_nextChar);
                                    this.nextChar();
                                    var1_1 = new Token(6, this.getTokenValue());
                                    this.switchTo(1);
                                    continue block9;
                                }
                                if (this.m_nextChar != '\\') {
                                    throw new ParserException("\" expected, but encounter the end of file EOF");
                                }
                                this.storeChar(this.m_nextChar);
                                this.nextChar();
                                if (this.m_nextChar != '\"') continue block9;
                                this.storeChar(this.m_nextChar);
                                var5_5 = this.lookAheadNewLine();
                                if (var5_5 > 0) {
                                    this.advance(var5_5);
                                    var1_1 = new Token(6, this.getTokenValue());
                                    this.switchTo(1);
                                    continue block9;
                                }
                                this.nextChar();
                                continue block9;
                            }
                            while (true) {
                                this.storeChar(this.m_nextChar);
                                cfr_temp_0 = 5;
                                this.nextChar();
                                break;
                            }
                            case 5: {
                                if (this.isNonLiteralStringChar(this.m_nextChar)) ** continue;
                                var1_1 = new Token(7, this.getTokenValue());
                                this.switchTo(1);
                                continue block9;
                            }
                            while (true) {
                                this.storeChar(this.m_nextChar);
                                cfr_temp_0 = 2;
                                this.nextChar();
                                break;
                            }
                            case 2: 
                        }
                        break;
                    }
                    break block40;
                    if (true) ** continue;
                }
                if (this.m_nextChar != '\n') ** continue;
                while (this.isWhiteSpace(this.m_nextChar) || this.m_nextChar == '\n') {
                    this.storeChar(this.m_nextChar);
                    this.nextChar();
                }
                if (this.m_nextChar != '#') {
                    var1_1 = new Token(8, this.getTokenValue());
                    var1_1.setSpecial(true);
                    this.switchTo(1);
                    continue;
                }
                this.storeChar(this.m_nextChar);
                this.nextChar();
            }
            var1_1.setLocation(var3_3, var4_4, this.m_charBuffer.getPreLineNumber(), this.m_charBuffer.getPreColumnNumber());
            if (this.m_specialToken != null) {
                var1_1.setSpecialToken(this.m_specialToken);
                this.m_specialToken = null;
            }
            if (var1_1.isSpecial()) {
                this.m_specialToken = var1_1;
                continue;
            }
            var2_2 = true;
        }
        return var1_1;
    }

    public Token getToken(int n) throws ParserException {
        int n2 = this.m_queuedTokenList.size();
        int n3 = n;
        while (n3 - n2 > 0) {
            this.m_queuedTokenList.addElement(this.makeToken());
            --n3;
        }
        return (Token)this.m_queuedTokenList.elementAt(n - 1);
    }

    private void nextChar() throws ParserException {
        this.m_nextChar = this.m_charBuffer.nextChar();
    }

    private char getChar(int n) throws ParserException {
        return this.m_charBuffer.getChar(n);
    }

    private void advance(int n) throws ParserException {
        this.m_nextChar = this.m_charBuffer.advance(n);
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\f' || c == '\r' || c == '\t';
    }

    private boolean isIdentifierChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    private boolean isNonLiteralStringChar(char c) {
        return !this.isWhiteSpace(c) && c != '\n' && c != '>' && c != '\uffff';
    }

    private int lookAheadNewLine() throws ParserException {
        int n = 1;
        char c = this.getChar(n);
        while (this.isWhiteSpace(c)) {
            c = this.getChar(++n);
        }
        if (c == '\n') {
            return n;
        }
        return 0;
    }

    private int lookAheadString(String string) throws ParserException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != this.getChar(n2 + 1)) {
                return 0;
            }
            ++n2;
        }
        return n;
    }

    private void storeChar(char c) {
        if (this.m_tempBufIndex >= 1024) {
            this.m_tokenValue = String.valueOf(this.m_tokenValue) + new String(this.m_tempBuf, 0, 1024);
            this.m_tempBufIndex = 0;
        }
        this.m_tempBuf[this.m_tempBufIndex++] = c;
    }

    private void storeChar(String string) {
        int n = 0;
        while (n < string.length()) {
            this.storeChar(string.charAt(n));
            ++n;
        }
    }

    private String getTokenValue() {
        return this.m_tokenValue.concat(new String(this.m_tempBuf, 0, this.m_tempBufIndex));
    }

    private void switchTo(int n) {
        this.m_state = n;
    }
}

