/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Directive;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveIterator;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveList;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.FileLevelContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.IncludeDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Parameter;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParameterList;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserTreeNode;

public abstract class ContainerDirective
extends Directive {
    protected DirectiveList directiveList = new DirectiveList();

    protected ContainerDirective() {
    }

    protected ContainerDirective(Parameter parameter) {
        super("", parameter);
    }

    protected ContainerDirective(ParameterList parameterList) {
        super("", parameterList);
    }

    protected ContainerDirective(Parameter parameter, DirectiveList directiveList) {
        super("", parameter);
        this.directiveList = directiveList;
        directiveList.setParent(this);
    }

    protected ContainerDirective(ParameterList parameterList, DirectiveList directiveList) {
        super("", parameterList);
        this.directiveList = directiveList;
        directiveList.setParent(this);
    }

    public abstract String getName();

    protected void add(Directive directive, boolean bl) {
        if (directive == null) {
            return;
        }
        ContainerDirective containerDirective = (ContainerDirective)this.getTargetObject(bl);
        directive.setParent(containerDirective);
        containerDirective.directiveList.add(directive);
    }

    public void add(Directive directive) {
        this.add(directive, true);
    }

    protected void add(DirectiveList directiveList, boolean bl) {
        if (directiveList == null) {
            return;
        }
        int n = 0;
        while (n < directiveList.size()) {
            this.add(directiveList.elementAt(n), bl);
            ++n;
        }
    }

    public void add(DirectiveList directiveList) {
        this.add(directiveList, true);
    }

    protected void addBefore(Directive directive, Directive directive2, boolean bl) {
        if (directive == null || directive2 == null) {
            return;
        }
        ContainerDirective containerDirective = (ContainerDirective)this.getTargetObject(bl);
        directive.setParent(containerDirective);
        containerDirective.directiveList.addBefore(directive, directive2);
    }

    public void addBefore(Directive directive, Directive directive2) {
        this.addBefore(directive, directive2, true);
    }

    protected void addAfter(Directive directive, Directive directive2, boolean bl) {
        if (directive == null || directive2 == null) {
            return;
        }
        ContainerDirective containerDirective = (ContainerDirective)this.getTargetObject(bl);
        directive.setParent(containerDirective);
        containerDirective.directiveList.addAfter(directive, directive2);
    }

    public void addAfter(Directive directive, Directive directive2) {
        this.addAfter(directive, directive2, true);
    }

    public DirectiveIterator getChildren(boolean bl, boolean bl2) {
        ContainerDirective containerDirective = (ContainerDirective)this.getSourceObject(bl);
        if (containerDirective != null) {
            if (!bl2) {
                return new DirectiveIterator(containerDirective.directiveList);
            }
            DirectiveList directiveList = new DirectiveList();
            int n = 0;
            while (n < containerDirective.directiveList.size()) {
                Directive directive = containerDirective.directiveList.elementAt(n);
                if (directive instanceof IncludeDirective) {
                    DirectiveIterator directiveIterator;
                    FileLevelContainer fileLevelContainer = ((IncludeDirective)directive).getIncludedConfig(bl);
                    if (fileLevelContainer != null && (directiveIterator = fileLevelContainer.getChildren(bl, bl2)) != null) {
                        while (directiveIterator.hasNext()) {
                            directiveList.add((Directive)directiveIterator.next());
                        }
                    }
                } else {
                    directiveList.add(directive);
                }
                ++n;
            }
            return new DirectiveIterator(directiveList);
        }
        return null;
    }

    public DirectiveIterator getChildren() {
        return this.getChildren(true, true);
    }

    public DirectiveIterator getChildren(String string, boolean bl, boolean bl2) {
        ContainerDirective containerDirective = (ContainerDirective)this.getSourceObject(bl);
        if (containerDirective == null) {
            return null;
        }
        DirectiveList directiveList = new DirectiveList();
        int n = 0;
        while (n < containerDirective.directiveList.size()) {
            Directive directive = containerDirective.directiveList.elementAt(n);
            if (bl2 && directive instanceof IncludeDirective) {
                DirectiveIterator directiveIterator;
                FileLevelContainer fileLevelContainer = ((IncludeDirective)directive).getIncludedConfig(bl);
                if (fileLevelContainer != null && (directiveIterator = fileLevelContainer.getChildren(string, bl, bl2)) != null) {
                    while (directiveIterator.hasNext()) {
                        directiveList.add((Directive)directiveIterator.next());
                    }
                }
            } else if (directive.getName().equals(string)) {
                directiveList.add(directive);
            }
            ++n;
        }
        return new DirectiveIterator(directiveList);
    }

    public DirectiveIterator getChildren(String string) {
        return this.getChildren(string, true, true);
    }

    protected void remove(Directive directive, boolean bl) {
        ((ContainerDirective)this.getTargetObject((boolean)bl)).directiveList.remove(directive);
    }

    public void remove(Directive directive) {
        this.remove(directive, true);
    }

    public void removeChildren(String string) {
        DirectiveIterator directiveIterator = this.getChildren(string);
        if (directiveIterator != null) {
            while (directiveIterator.hasNext()) {
                this.remove((Directive)directiveIterator.next());
            }
        }
    }

    protected void replace(Directive directive, Directive directive2, boolean bl) {
        ((ContainerDirective)this.getTargetObject((boolean)bl)).directiveList.replace(directive, directive2);
    }

    public void replace(Directive directive, Directive directive2) {
        this.replace(directive, directive2, true);
    }

    public String toString(boolean bl, boolean bl2) {
        ContainerDirective containerDirective = (ContainerDirective)this.getSourceObject(bl2);
        if (containerDirective == null) {
            return null;
        }
        String string = new String();
        if (bl) {
            string = "\n";
            if (containerDirective.comment != null) {
                string = String.valueOf(string) + containerDirective.comment;
            }
        }
        string = String.valueOf(string) + "<" + containerDirective.getName() + " " + containerDirective.parameterList.toString() + ">\n";
        string = String.valueOf(string) + containerDirective.directiveList.toString(bl, bl2);
        string = String.valueOf(string) + "</" + containerDirective.getName() + ">\n";
        return string;
    }

    public String toString(boolean bl) {
        return this.toString(bl, true);
    }

    public String toString() {
        return this.toString(false, true);
    }

    protected Object clone() {
        ContainerDirective containerDirective = (ContainerDirective)super.clone();
        if (containerDirective != null) {
            containerDirective.directiveList = (DirectiveList)this.directiveList.clone();
        }
        return containerDirective;
    }

    protected void copyFrom(Directive directive) {
        super.copyFrom(directive);
        this.directiveList = ((ContainerDirective)directive).directiveList;
    }

    protected boolean hasChild(Directive directive, boolean bl) {
        ContainerDirective containerDirective = (ContainerDirective)this.getSourceObject(bl);
        if (containerDirective != null) {
            return containerDirective.directiveList.getIndex(directive) >= 0;
        }
        return false;
    }

    protected boolean hasChild(Directive directive) {
        return this.hasChild(directive, true);
    }

    public ParserTreeNode getFirstChild(String string) {
        return this.getChildren(string).getFirst();
    }

    public ParserTreeNode getLastChild(String string) {
        return this.getChildren(string).getLast();
    }

    public int childrenCount(String string) {
        return this.getChildren(string).getDirectiveCount();
    }

    public void addChild(ParserTreeNode parserTreeNode) {
        if (parserTreeNode instanceof Directive) {
            this.add((Directive)parserTreeNode);
        }
    }

    public void removeChild(ParserTreeNode parserTreeNode) {
        if (parserTreeNode instanceof Directive) {
            this.remove((Directive)parserTreeNode);
        }
    }

    public void removeChildren() {
        this.directiveList.removeAllElements();
    }
}

