/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import java.util.Enumeration;
import java.util.Vector;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveIterator;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.FileLevelContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Parameter;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParameterList;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserTreeNode;

public abstract class Directive
implements Cloneable,
ParserTreeNode {
    protected static final byte CLONE_ORIGIN = 0;
    protected static final byte CLONE_CURRENT = 1;
    protected static final byte CLONE_TEMP = 2;
    protected String name;
    protected ParameterList parameterList = new ParameterList();
    protected String comment;
    private Directive parent;
    protected Directive clone;
    protected byte cloneType = 0;

    protected Directive() {
    }

    protected Directive(String string) {
        this.name = string;
    }

    protected Directive(String string, Parameter parameter) {
        this.name = string;
        this.addParameter(parameter, false);
    }

    protected Directive(String string, ParameterList parameterList) {
        this.name = string;
        this.parameterList = parameterList;
    }

    public ParserTreeNode getParentNode() {
        return this.getParent();
    }

    public Directive getParent() {
        return this.parent;
    }

    protected void setParent(Directive directive) {
        this.parent = directive;
    }

    public String getValue(boolean bl) {
        Directive directive = this.getSourceObject(bl);
        if (directive != null) {
            return directive.parameterList.toString();
        }
        return null;
    }

    public String getValue() {
        return this.getValue(true);
    }

    public String getName() {
        return this.name;
    }

    protected void setValue(String string, boolean bl) {
        this.getTargetObject((boolean)bl).parameterList = new ParameterList(string);
    }

    public void setValue(String string) {
        this.setValue(string, true);
    }

    public ParameterList getParameterList(boolean bl) {
        return this.getSourceObject((boolean)bl).parameterList;
    }

    public ParameterList getParameterList() {
        return this.getParameterList(true);
    }

    public Parameter getParameter(int n) {
        return this.parameterList.elementAt(n);
    }

    public Enumeration getAllParameters() {
        ParameterList parameterList = this.getParameterList();
        Vector<String> vector = new Vector<String>();
        int n = parameterList.size();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(parameterList.elementAt(n2++).toString());
        }
        return vector.elements();
    }

    protected void addParameter(Parameter parameter, boolean bl) {
        this.getTargetObject((boolean)bl).parameterList.add(parameter);
    }

    public void addParameter(Parameter parameter) {
        this.addParameter(parameter, true);
    }

    public void addParameter(String string) {
        this.addParameter(new Parameter(string));
    }

    protected void setParameter(int n, Parameter parameter, boolean bl) {
        this.getTargetObject((boolean)bl).parameterList.setParameter(parameter, n);
    }

    public void setParameter(int n, Parameter parameter) {
        this.setParameter(n, parameter, true);
    }

    protected void setParameterList(ParameterList parameterList, boolean bl) {
        this.getTargetObject((boolean)bl).parameterList = parameterList;
    }

    public void setParameterList(ParameterList parameterList) {
        this.setParameterList(parameterList, true);
    }

    protected boolean removeParameter(Parameter parameter, boolean bl) {
        return this.getTargetObject((boolean)bl).parameterList.remove(parameter);
    }

    public boolean removeParameter(Parameter parameter) {
        return this.removeParameter(parameter, true);
    }

    public String getComment(boolean bl) {
        Directive directive = this.getSourceObject(bl);
        if (directive != null) {
            return directive.comment;
        }
        return null;
    }

    public String getComment() {
        return this.getComment(true);
    }

    protected void setComment(String string, boolean bl) {
        this.getTargetObject((boolean)bl).comment = string;
    }

    public void setComment(String string) {
        this.setComment(string, true);
    }

    public String toString(boolean bl, boolean bl2) {
        Directive directive = this.getSourceObject(bl2);
        if (directive == null) {
            return null;
        }
        String string = new String();
        if (bl && directive.comment != null) {
            string = "\n" + directive.comment;
        }
        if (directive.name != null) {
            string = String.valueOf(string) + directive.name + " ";
        }
        string = String.valueOf(string) + directive.parameterList.toString() + "\n";
        return string;
    }

    public String toString(boolean bl) {
        return this.toString(bl, true);
    }

    public String toString() {
        return this.toString(false, true);
    }

    protected Object clone() {
        if (this.cloneType == 2) {
            return this;
        }
        try {
            Directive directive = (Directive)super.clone();
            directive.parameterList = (ParameterList)this.parameterList.clone();
            this.clone = directive;
            this.clone.cloneType = (byte)2;
            return directive;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println(outOfMemoryError.getMessage());
            return null;
        }
    }

    protected boolean hasChild(Directive directive, boolean bl) {
        return false;
    }

    protected boolean hasChild(Directive directive) {
        return this.hasChild(directive, true);
    }

    protected boolean isDeleted() {
        if (this.isCreated()) {
            return false;
        }
        if (this.parent == null) {
            return false;
        }
        if (!this.parent.hasChild(this, true)) {
            return true;
        }
        return this.parent.isDeleted();
    }

    protected boolean isCreated() {
        return this.cloneType == 1;
    }

    protected boolean isModified() {
        return !this.isDeleted() && this.getCurrentObject() != this;
    }

    protected Directive getCurrentObject() {
        if (this.cloneType == 2) {
            return this;
        }
        if (this.cloneType == 1) {
            if (this.clone != null) {
                return this.clone;
            }
            return this;
        }
        if (this.isDeleted()) {
            return null;
        }
        if (this.clone == null) {
            return this;
        }
        return this.clone.getCurrentObject();
    }

    protected boolean hasTempClone() {
        return this.cloneType == 2 || this.clone != null && (this.clone.cloneType == 2 || this.clone.clone != null && this.clone.clone.cloneType == 2);
    }

    private Directive getTempClone() {
        if (this.cloneType == 2) {
            return this;
        }
        if (this.clone == null) {
            return (Directive)this.clone();
        }
        if (this.clone.cloneType == 1) {
            return this.clone.getTempClone();
        }
        return this.clone;
    }

    protected void cancelTempClone() {
        if (this.cloneType == 2 || this.clone == null) {
            return;
        }
        if (this.clone.cloneType == 2) {
            this.clone = null;
            return;
        }
        this.clone.clone = null;
    }

    protected void commitTempClone() {
        Directive directive = null;
        if (this.cloneType == 2) {
            directive = this;
        } else if (this.clone != null) {
            if (this.clone.cloneType == 2) {
                directive = this.clone;
            } else if (this.clone.cloneType == 1 && this.clone.clone != null) {
                directive = this.clone.clone;
            }
        }
        if (directive == null) {
            return;
        }
        if (this.cloneType == 0) {
            this.clone = directive;
            this.clone.cloneType = 1;
            return;
        }
        if (this.cloneType == 1) {
            this.copyFrom(directive);
            this.clone = null;
            this.cloneType = 1;
            return;
        }
        this.cloneType = 1;
    }

    protected void copyFrom(Directive directive) {
        this.name = directive.name;
        this.parameterList = directive.parameterList;
        this.comment = directive.comment;
        this.parent = directive.parent;
        this.clone = directive.clone;
        this.cloneType = directive.cloneType;
    }

    protected FileLevelContainer getFileLevelContainer() {
        Directive directive = this;
        while (!(directive instanceof FileLevelContainer)) {
            directive = directive.getParent();
        }
        return (FileLevelContainer)directive;
    }

    protected Directive getSourceObject(boolean bl) {
        if (bl) {
            return this.getCurrentObject();
        }
        if (this.cloneType == 0) {
            return this;
        }
        return null;
    }

    protected Directive getTargetObject(boolean bl) {
        if (bl) {
            return this.getTempClone();
        }
        return this;
    }

    public abstract DirectiveIterator getChildren();

    public abstract DirectiveIterator getChildren(String var1);

    public abstract ParserTreeNode getFirstChild(String var1);

    public abstract ParserTreeNode getLastChild(String var1);

    public abstract int childrenCount(String var1);

    public abstract void addChild(ParserTreeNode var1);

    public abstract void removeChildren();

    public abstract void removeChildren(String var1);

    public abstract void removeChild(ParserTreeNode var1);
}

