/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ContainerDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Directive;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveList;

public class DirectiveIterator {
    private DirectiveList directiveList;
    private int curIndex = -1;

    public DirectiveIterator() {
        this.directiveList = new DirectiveList();
        this.curIndex = -1;
    }

    public DirectiveIterator(DirectiveList directiveList) {
        this.directiveList = directiveList;
        this.curIndex = -1;
    }

    public DirectiveIterator(ContainerDirective containerDirective) {
        this.directiveList = containerDirective.directiveList;
        this.curIndex = -1;
    }

    public boolean hasNext() {
        if (this.directiveList != null) {
            return this.curIndex < this.directiveList.size() - 1;
        }
        return false;
    }

    public Object next() {
        ++this.curIndex;
        if (this.directiveList != null) {
            return this.directiveList.elementAt(this.curIndex);
        }
        return null;
    }

    public Directive getFirst() {
        if (this.directiveList.size() >= 1) {
            return this.directiveList.elementAt(0);
        }
        return null;
    }

    public Directive getLast() {
        int n = this.directiveList.size();
        if (n >= 1) {
            return this.directiveList.elementAt(n - 1);
        }
        return null;
    }

    public Directive directiveAt(int n) {
        return this.directiveList.elementAt(n);
    }

    public int getIndex(Directive directive) {
        return this.directiveList.getIndex(directive);
    }

    public int getDirectiveCount() {
        return this.directiveList.size();
    }

    public void remove() {
        this.directiveList.remove(this.curIndex);
        --this.curIndex;
    }
}

