/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import java.util.Vector;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Directive;

public class DirectiveList
implements Cloneable {
    private Vector directives = new Vector();

    public DirectiveList() {
    }

    public DirectiveList(Vector vector) {
        this.directives = vector;
    }

    public void setParent(Directive directive) {
        if (this.directives != null) {
            int n = 0;
            while (n < this.directives.size()) {
                ((Directive)this.directives.elementAt(n)).setParent(directive);
                ++n;
            }
        }
    }

    public void add(Directive directive) {
        if (directive == null) {
            return;
        }
        if (this.directives == null) {
            this.directives = new Vector(5, 5);
        }
        this.directives.addElement(directive);
    }

    public void add(DirectiveList directiveList) {
        int n = 0;
        while (n < directiveList.size()) {
            this.add(directiveList.elementAt(n));
            ++n;
        }
    }

    public void add(Directive directive, int n) {
        if (directive == null || this.directives == null && n != 0) {
            return;
        }
        if (this.directives == null) {
            this.directives = new Vector(5, 5);
        }
        this.directives.insertElementAt(directive, n);
    }

    public void addBefore(Directive directive, Directive directive2) {
        if (directive == null || directive2 == null || this.directives == null) {
            return;
        }
        int n = this.directives.indexOf(directive2);
        if (n >= 0) {
            this.directives.insertElementAt(directive, n);
        }
    }

    public void addAfter(Directive directive, Directive directive2) {
        if (directive == null || directive2 == null || this.directives == null) {
            return;
        }
        int n = this.directives.indexOf(directive2);
        if (n >= 0) {
            this.directives.insertElementAt(directive, n + 1);
        }
    }

    public void remove(Directive directive) {
        if (this.directives != null) {
            this.directives.removeElement(directive);
        }
    }

    public Directive remove(int n) {
        if (this.directives != null) {
            Directive directive = (Directive)this.directives.elementAt(n);
            this.directives.removeElementAt(n);
            return directive;
        }
        return null;
    }

    public void removeAllElements() {
        if (this.directives != null) {
            this.directives.removeAllElements();
        }
    }

    public void replace(Directive directive, Directive directive2) {
        if (this.directives != null) {
            int n = this.directives.indexOf(directive);
            this.directives.setElementAt(directive2, n);
            directive2.setParent(directive.getParent());
        }
    }

    public Directive elementAt(int n) {
        if (this.directives != null && n >= 0 && n < this.directives.size()) {
            return (Directive)this.directives.elementAt(n);
        }
        return null;
    }

    public int getIndex(Directive directive) {
        if (this.directives != null) {
            return this.directives.indexOf(directive);
        }
        return -1;
    }

    public int size() {
        if (this.directives != null) {
            return this.directives.size();
        }
        return 0;
    }

    public String toString(boolean bl, boolean bl2) {
        String string = new String();
        if (this.directives != null) {
            int n = 0;
            while (n < this.directives.size()) {
                string = String.valueOf(string) + this.elementAt(n).toString(bl, bl2);
                ++n;
            }
        }
        return string;
    }

    public Object clone() {
        if (this.directives != null) {
            return new DirectiveList((Vector)this.directives.clone());
        }
        return new DirectiveList();
    }
}

