/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import java.io.InputStreamReader;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ApacheScanner;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.FileLevelContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Parser;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserException;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.TableRow;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Token;

public class TableParser
implements Parser {
    private ApacheScanner m_scanner;
    private Token m_nextToken;
    private int columnCount;

    public TableParser(int n, InputStreamReader inputStreamReader) throws ParserException {
        this.columnCount = n;
        this.m_scanner = new ApacheScanner(inputStreamReader);
        this.nextToken();
    }

    public FileLevelContainer parse() throws ParserException {
        FileLevelContainer fileLevelContainer = new FileLevelContainer();
        TableRow tableRow = this.tableRow();
        while (tableRow != null) {
            fileLevelContainer.add(tableRow, false);
            tableRow = this.tableRow();
        }
        return fileLevelContainer;
    }

    protected TableRow tableRow() throws ParserException {
        TableRow tableRow = null;
        int n = 0;
        if (this.m_nextToken.getID() == 0) {
            return null;
        }
        Token token = this.m_nextToken.getSpecialToken();
        while (this.m_nextToken.getID() == 1) {
            this.nextToken();
        }
        while (this.m_nextToken.getID() != 1) {
            if (tableRow == null) {
                tableRow = new TableRow(false);
            }
            if (this.columnCount == 0 || n < this.columnCount) {
                tableRow.addColumn(this.m_nextToken.getValue(), false);
                ++n;
            } else {
                String string = String.valueOf(tableRow.getColumn(this.columnCount - 1)) + " " + this.m_nextToken.getValue();
                tableRow.setColumn(this.columnCount - 1, string, false);
            }
            this.nextToken();
        }
        this.nextToken();
        if (token != null) {
            tableRow.setComment(token.getValue(), false);
        }
        return tableRow;
    }

    private void nextToken() throws ParserException {
        this.m_nextToken = this.m_scanner.nextToken();
    }
}

