/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import oracle.ldap.util.LogException;

public class Logger {
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int DEBUG = 4;
    public static final int ERROR = 8;
    public static final int ALL_TYPES = 15;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String ENCODING = "UTF8";
    private int m_flags = 0;
    private PrintWriter m_out = null;
    private PrintWriter m_consoleOut = null;
    private boolean m_xmlLog = false;
    private String m_fName = null;
    private boolean m_append = false;

    public Logger(String string, int n, boolean bl) throws LogException {
        this(string, n, bl, false);
    }

    public Logger(String string, int n, boolean bl, boolean bl2) throws LogException {
        File file = null;
        if (string == null) {
            throw new LogException("Invalid file name : " + string);
        }
        if (n < 1 || n > 15) {
            throw new LogException("Invalid severity ");
        }
        file = new File(string);
        if (file.isDirectory()) {
            throw new LogException("Specified file name is a directory : " + string);
        }
        this.m_append = bl;
        String string2 = file.getAbsolutePath();
        File file2 = new File(string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar)));
        if (!file2.exists() || !file2.canWrite()) {
            throw new LogException("Cannot open the log file " + string + " for writing");
        }
        if (file.exists() && !this.m_append) {
            File file3 = new File(string + ".bak");
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
        }
        try {
            this.m_out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath(), this.m_append), ENCODING), true);
            this.m_consoleOut = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, ENCODING), true);
        }
        catch (IOException iOException) {
            throw new LogException(iOException);
        }
        this.m_flags = n;
        this.m_xmlLog = bl2;
        if (this.m_xmlLog) {
            this.m_out.write("<LOG timestamp = \"");
            this.m_out.write(new Date(System.currentTimeMillis()).toString() + "\" >");
            this.m_out.write(NEW_LINE);
            if (this.m_out.checkError()) {
                System.out.println("I/O ERROR While writing to log file");
            }
        }
    }

    public Logger(OutputStream outputStream, int n) throws LogException {
        this(outputStream, n, false);
    }

    public Logger(OutputStream outputStream, int n, boolean bl) throws LogException {
        if (outputStream == null) {
            throw new LogException("NULL input value");
        }
        if (n < 1 || n > 15) {
            throw new LogException("Invalid severity ");
        }
        try {
            this.m_out = new PrintWriter((Writer)new OutputStreamWriter(outputStream, ENCODING), true);
            this.m_consoleOut = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, ENCODING), true);
        }
        catch (IOException iOException) {
            throw new LogException(iOException);
        }
        this.m_flags = n;
        this.m_xmlLog = bl;
        if (this.m_xmlLog) {
            this.m_out.write("<LOG timestamp = \"");
            this.m_out.write(new Date(System.currentTimeMillis()).toString() + "\" >");
            this.m_out.write(NEW_LINE);
            if (this.m_out.checkError()) {
                System.out.println("I/O ERROR While writing to log file");
            }
        }
    }

    public synchronized void setSeverity(int n) {
        this.m_flags |= n;
    }

    public synchronized void unsetSeverity(int n) {
        this.m_flags = this.m_flags & n ^ this.m_flags;
    }

    public void log(String string, int n) {
        this.log(string, n, false);
    }

    public void log(String string, int n, boolean bl) {
        if (bl) {
            this.writeLog(this.m_consoleOut, string, n);
        }
        this.writeLog(this.m_out, string, n);
    }

    public void log(Exception exception, int n) {
        this.log(exception, n, false);
    }

    public void log(Exception exception, int n, boolean bl) {
        if (exception != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            if (bl) {
                this.writeLog(this.m_consoleOut, stringWriter.getBuffer().toString(), n);
            }
            this.writeLog(this.m_out, stringWriter.getBuffer().toString(), n);
            stringWriter = null;
            printWriter = null;
        }
    }

    public void close() {
        if (this.m_out != null) {
            if (this.m_xmlLog) {
                this.m_out.write("</LOG>");
                this.m_out.write(NEW_LINE);
            }
            this.m_out.write(NEW_LINE);
            this.m_out.close();
            this.m_out = null;
        }
        if (this.m_consoleOut != null) {
            this.m_consoleOut = null;
        }
    }

    synchronized void writeLog(PrintWriter printWriter, String string, int n) {
        int n2 = this.m_flags & n;
        if (n2 == 1 || n2 == 2 || n2 == 4 || n2 == 8) {
            printWriter.write(this.getFormattedString(string, n));
            printWriter.flush();
        }
    }

    private String getFormattedString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getString(n);
        if (this.m_xmlLog) {
            stringBuffer.append("  <").append(string2).append(" timestamp = \"").append(new Date(System.currentTimeMillis()).toString()).append("\">").append(NEW_LINE).append("    ").append(string).append(NEW_LINE).append("  </").append(string2).append(">").append(NEW_LINE);
        } else {
            stringBuffer.append(this.getString(n)).append(": [").append(new Date(System.currentTimeMillis()).toString()).append("] ").append(string).append(NEW_LINE);
        }
        return stringBuffer.toString();
    }

    private String getString(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "INFO";
                break;
            }
            case 2: {
                string = "WARNING";
                break;
            }
            case 4: {
                string = "DEBUG";
                break;
            }
            case 8: {
                string = "ERROR";
                break;
            }
            default: {
                string = "ERROR";
            }
        }
        return string;
    }
}

