/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.NamingSecurityException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.User;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;
import oracle.ldap.util.jndi.ConnectionUtil;

public class OUILdap {
    public static final int GET_REALMS_QUERY = 0;
    public static final int GET_OID_VERSION_QUERY = 1;
    public static final int VALIDATE_DN_QUERY = 2;
    public static final int IS_MEMBER_QUERY = 3;
    public static final int AUTHENTICATE_USER_QUERY = 4;
    public static final int GET_OID_DB_INFO_QUERY = 5;
    public static final int GET_SSO_DB_INFO_QUERY = 6;
    public static final int LDAP_DELETE_QUERY = 7;
    public static final int GET_OID_PORTS_QUERY = 8;
    public static final int UPDATE_SSO_DB_DN_QUERY = 9;
    public static final int IS_SUPERUSER_QUERY = 10;
    public static final int SUCCESS = 0;
    public static final int PARAMETER_ERROR = 1;
    public static final int CONNECTION_ERROR = 2;
    public static final int LDAP_OPERATION_ERROR = 3;
    public static final int IS_NOT_MEMBER_ERROR = 4;
    public static final int AUTHENTICATION_ERROR = 5;
    public static final int INVALID_DN_ERROR = 6;
    public static final int NOT_INFRA_DB_ERROR = 7;
    public static final int SSO_NOT_CONFIGURED_ERROR = 8;
    public static final int CANNOT_LOCATE_SSO_DB_ERROR = 9;
    public static final int IS_NOT_SUPERUSER = 10;
    public static final int INVALID_QUERY_NUMBER = -1;

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"sandal", "3060", "", ""};
        String[] stringArray3 = OUILdap.runLdapQuery(1, stringArray2);
        int n = 0;
        while (n < stringArray3.length) {
            System.out.println(stringArray3[n]);
            ++n;
        }
    }

    public static String[] runLdapQuery(int n, String[] stringArray) {
        switch (n) {
            case 0: {
                return OUILdap.getRealms(stringArray);
            }
            case 1: {
                return OUILdap.getOIDVersion(stringArray);
            }
            case 2: {
                return OUILdap.validateDN(stringArray);
            }
            case 3: {
                return OUILdap.isMember(stringArray);
            }
            case 4: {
                return OUILdap.authenticateUser(stringArray);
            }
            case 5: {
                return OUILdap.getOIDDBInfo(null, stringArray, true);
            }
            case 6: {
                return OUILdap.getSSODBInfo(null, stringArray);
            }
            case 7: {
                return OUILdap.ldapDelete(stringArray);
            }
            case 8: {
                return OUILdap.getOIDPorts(stringArray);
            }
            case 9: {
                return OUILdap.updateSSODBDN(stringArray);
            }
            case 10: {
                return OUILdap.isSuperUser(stringArray);
            }
        }
        String[] stringArray2 = new String[]{Integer.toString(-1)};
        return stringArray2;
    }

    private static String[] isSuperUser(String[] stringArray) {
        String string;
        boolean bl = true;
        if (stringArray.length != 6) {
            String[] stringArray2 = new String[]{Integer.toString(1)};
            return stringArray2;
        }
        DirContext dirContext = OUILdap.getDirCtx(stringArray);
        if (dirContext == null) {
            return OUILdap.error_Connection(stringArray);
        }
        PropertySetCollection propertySetCollection = null;
        String string2 = null;
        try {
            propertySetCollection = Util.ldapSearch(dirContext, "", "objectclass=*", 0, new String[]{"orclsuname"});
            string = (String)propertySetCollection.getPropertySet(0).getProperty(0).getValue(0);
            string2 = Util.normalizeDN(string);
        }
        catch (UtilException utilException) {
            if (utilException.isNamingException() && utilException.returnNamingException() instanceof NamingSecurityException) {
                bl = false;
            }
            String[] stringArray3 = new String[]{Integer.toString(3), utilException.toString()};
            return stringArray3;
        }
        catch (NullPointerException nullPointerException) {
            String[] stringArray4 = new String[]{Integer.toString(3), "Cannot obtain super user DN information from Root DSE"};
            return stringArray4;
        }
        string = Util.normalizeDN(stringArray[5]);
        if (!string.equalsIgnoreCase(string2)) {
            bl = false;
        }
        String[] stringArray5 = new String[]{bl ? Integer.toString(0) : Integer.toString(10)};
        return stringArray5;
    }

    private static String[] updateSSODBDN(String[] stringArray) {
        Object var1_1 = null;
        if (stringArray.length != 7) {
            String[] stringArray2 = new String[]{Integer.toString(1)};
            return stringArray2;
        }
        DirContext dirContext = OUILdap.getDirCtx(stringArray);
        if (dirContext == null) {
            return OUILdap.error_Connection(stringArray);
        }
        String string = new StringTokenizer(stringArray[5].trim(), ".").nextToken();
        String string2 = stringArray[6];
        try {
            String[] stringArray3;
            Object object;
            PropertySetCollection propertySetCollection = Util.ldapSearch(dirContext, "cn=oraclecontext", "objectclass=orcldbserver", 1, new String[]{"orclsystemname", "orclsid"});
            boolean bl = false;
            String string3 = null;
            int n = 0;
            while (n < propertySetCollection.size()) {
                try {
                    object = propertySetCollection.getPropertySet(n);
                    stringArray3 = (String[])((PropertySet)object).getProperty("orclsystemname").getValue(0);
                    String string4 = (String)((PropertySet)object).getProperty("orclsid").getValue(0);
                    if (string.equalsIgnoreCase(new StringTokenizer(stringArray3.trim(), ".").nextToken()) && string2.equalsIgnoreCase(string4)) {
                        string3 = ((PropertySet)object).getDN();
                        bl = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            if (!bl) {
                object = new String[]{Integer.toString(9)};
                return object;
            }
            object = new ModPropertySet();
            ((ModPropertySet)object).addProperty(7, "seeAlso", string3);
            Util.ldapModify(dirContext, "orclApplicationCommonName=ORASSO_SSOSERVER,cn=SSO,cn=Products,cn=OracleContext", (ModPropertySet)object);
            stringArray3 = new String[]{Integer.toString(0)};
            return stringArray3;
        }
        catch (UtilException utilException) {
            String[] stringArray4 = new String[]{Integer.toString(3), utilException.returnNamingException().toString()};
            return stringArray4;
        }
        catch (Exception exception) {
            String[] stringArray5 = new String[]{Integer.toString(3), exception.toString()};
            return stringArray5;
        }
    }

    private static String[] getOIDPorts(String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length != 5) {
            String[] stringArray3 = new String[]{Integer.toString(1)};
            return stringArray3;
        }
        DirContext dirContext = OUILdap.getDirCtx(stringArray);
        if (dirContext == null) {
            return OUILdap.error_Connection(stringArray);
        }
        PropertySetCollection propertySetCollection = null;
        try {
            stringArray2 = "cn=configset0,cn=osdldapd,cn=subconfigsubentry";
            propertySetCollection = Util.ldapSearch(dirContext, (String)stringArray2, "objectclass=*", 0, new String[]{"orclnonsslport", "orclsslport", "orclsslenable"});
        }
        catch (UtilException utilException) {
            String[] stringArray4 = new String[]{Integer.toString(3), utilException.returnNamingException().toString()};
            return stringArray4;
        }
        stringArray2 = new String[4];
        stringArray2[0] = Integer.toString(0);
        try {
            stringArray2[1] = (String)propertySetCollection.getPropertySet(0).getProperty("orclnonsslport").getValue(0);
        }
        catch (NullPointerException nullPointerException) {
            stringArray2[1] = null;
        }
        try {
            stringArray2[2] = (String)propertySetCollection.getPropertySet(0).getProperty("orclsslport").getValue(0);
        }
        catch (NullPointerException nullPointerException) {
            stringArray2[2] = null;
        }
        try {
            stringArray2[3] = (String)propertySetCollection.getPropertySet(0).getProperty("orclsslenable").getValue(0);
        }
        catch (NullPointerException nullPointerException) {
            stringArray2[3] = null;
        }
        return stringArray2;
    }

    private static String[] ldapDelete(String[] stringArray) {
        if (stringArray.length != 6) {
            String[] stringArray2 = new String[]{Integer.toString(1)};
            return stringArray2;
        }
        DirContext dirContext = OUILdap.getDirCtx(stringArray);
        if (dirContext == null) {
            return OUILdap.error_Connection(stringArray);
        }
        try {
            Util.ldapDelete(dirContext, stringArray[5]);
            String[] stringArray3 = new String[]{Integer.toString(0)};
            return stringArray3;
        }
        catch (UtilException utilException) {
            String[] stringArray4 = new String[]{Integer.toString(3), utilException.returnNamingException().toString()};
            return stringArray4;
        }
    }

    private static String[] authenticateUser(String[] stringArray) {
        Object var1_1 = null;
        boolean bl = true;
        String string = null;
        if (stringArray.length == 7) {
            bl = true;
        } else if (stringArray.length == 8) {
            bl = false;
            string = stringArray[7];
        } else {
            String[] stringArray2 = new String[]{Integer.toString(1)};
            return stringArray2;
        }
        String string2 = stringArray[5];
        String string3 = stringArray[6];
        DirContext dirContext = OUILdap.getDirCtx(stringArray);
        if (dirContext == null) {
            return OUILdap.error_Connection(stringArray);
        }
        String string4 = Util.normalizeDN(string2);
        if (string4 != null) {
            DirContext dirContext2 = OUILdap.getDirCtx(new String[]{stringArray[0], stringArray[1], string2, string3, stringArray[4]});
            if (dirContext2 == null) {
                String[] stringArray3 = new String[]{Integer.toString(5)};
                return stringArray3;
            }
            String[] stringArray4 = new String[]{Integer.toString(0), string4};
            return stringArray4;
        }
        try {
            RootOracleContext rootOracleContext = new RootOracleContext(dirContext);
            Subscriber subscriber = bl ? rootOracleContext.getSubscriber(dirContext, Util.IDTYPE_DEFAULT, null, new String[]{"dn"}) : rootOracleContext.getSubscriber(dirContext, Util.IDTYPE_SIMPLE, string, new String[]{"dn"});
            User user = subscriber.getUser(dirContext, Util.IDTYPE_SIMPLE, string2, new String[0]);
            DirContext dirContext3 = OUILdap.getDirCtx(new String[]{stringArray[0], stringArray[1], user.getDN(dirContext), string3, stringArray[4]});
            if (dirContext3 == null) {
                String[] stringArray5 = new String[]{Integer.toString(5)};
                return stringArray5;
            }
            String[] stringArray6 = new String[]{Integer.toString(0), Util.normalizeDN(user.getDN(dirContext))};
            return stringArray6;
        }
        catch (UtilException utilException) {
            String[] stringArray7 = new String[]{Integer.toString(3)};
            return stringArray7;
        }
    }

    private static String[] getRealms(String[] stringArray) {
        Object var1_1 = null;
        if (stringArray.length != 5) {
            String[] stringArray2 = new String[]{Integer.toString(1)};
            return stringArray2;
        }
        DirContext dirContext = OUILdap.getDirCtx(stringArray);
        if (dirContext == null) {
            return OUILdap.error_Connection(stringArray);
        }
        try {
            RootOracleContext rootOracleContext = new RootOracleContext(dirContext);
            Subscriber[] subscriberArray = rootOracleContext.getAllSubscribers(dirContext, new String[]{"dn"});
            if (subscriberArray == null || subscriberArray.length < 1) {
                subscriberArray = new Subscriber[]{};
            }
            String[] stringArray3 = new String[subscriberArray.length + 1];
            stringArray3[0] = Integer.toString(0);
            int n = 0;
            while (n < subscriberArray.length) {
                stringArray3[n + 1] = subscriberArray[n].getDN(dirContext);
                ++n;
            }
            return stringArray3;
        }
        catch (Exception exception) {
            String[] stringArray4 = new String[]{Integer.toString(3), exception.toString()};
            return stringArray4;
        }
    }

    protected static String[] getSSODBInfo(DirContext dirContext, String[] stringArray) {
        DirContext dirContext2 = dirContext;
        if (dirContext2 == null) {
            if (stringArray.length != 5) {
                String[] stringArray2 = new String[]{Integer.toString(1)};
                return stringArray2;
            }
            dirContext2 = OUILdap.getDirCtx(stringArray);
            if (dirContext2 == null) {
                return OUILdap.error_Connection(stringArray);
            }
        }
        PropertySetCollection propertySetCollection = null;
        String string = null;
        try {
            propertySetCollection = Util.ldapSearch(dirContext2, "orclApplicationCommonName=ORASSO_SSOSERVER,cn=SSO,cn=Products,cn=OracleContext", "objectclass=*", 0, new String[]{"seeAlso"});
            string = (String)propertySetCollection.getPropertySet(0).getProperty("seeAlso").getValue(0);
        }
        catch (UtilException utilException) {
        }
        catch (Exception exception) {
            try {
                propertySetCollection = Util.ldapSearch(dirContext2, "cn=oraclecontext", "objectclass=*", 0, new String[]{"orclversion"});
                String string2 = (String)propertySetCollection.getPropertySet(0).getProperty("orclversion").getValue(0);
                if (string2.compareTo("90230") <= 0) {
                    String[] stringArray3 = new String[]{Integer.toString(8)};
                    return stringArray3;
                }
            }
            catch (UtilException utilException) {
                String[] stringArray4 = new String[]{Integer.toString(3)};
                return stringArray4;
            }
        }
        if (string != null) {
            try {
                String[] stringArray5;
                propertySetCollection = Util.ldapSearch(dirContext2, string, "objectclass=*", 0, new String[]{"orcldbglobalname", "orclnetdescstring"});
                stringArray5 = new String[]{Integer.toString(0), (String)propertySetCollection.getPropertySet(0).getProperty("orcldbglobalname").getValue(0), (String)propertySetCollection.getPropertySet(0).getProperty("orclnetdescstring").getValue(0), string, "orclReferenceName=" + stringArray5[1] + ",cn=IAS Infrastructure Databases,cn=IAS,cn=Products,cn=OracleContext"};
                return stringArray5;
            }
            catch (UtilException utilException) {
                String[] stringArray6 = new String[]{Integer.toString(3)};
                return stringArray6;
            }
        }
        return OUILdap.getOIDDBInfo(dirContext2, stringArray, false);
    }

    private static String[] getOIDDBInfo(DirContext dirContext, String[] stringArray, boolean bl) {
        String[] stringArray2;
        DirContext dirContext2 = dirContext;
        if (dirContext2 == null) {
            if (stringArray.length != 5) {
                String[] stringArray3 = new String[]{Integer.toString(1)};
                return stringArray3;
            }
            dirContext2 = OUILdap.getDirCtx(stringArray);
            if (dirContext2 == null) {
                return OUILdap.error_Connection(stringArray);
            }
        }
        PropertySetCollection propertySetCollection = null;
        String string = null;
        String string2 = null;
        try {
            propertySetCollection = Util.ldapSearch(dirContext2, "", "objectclass=*", 0, new String[]{"orclreplicaid"});
            string = "orclreplicaid=" + (String)propertySetCollection.getPropertySet(0).getProperty("orclreplicaid").getValue(0) + ",cn=replication configuration";
        }
        catch (UtilException utilException) {
            String[] stringArray4 = new String[]{Integer.toString(3), "While retrieving orclreplicaid from Root DSE - " + utilException.toString()};
            return stringArray4;
        }
        catch (Exception exception) {
            String[] stringArray5 = new String[]{Integer.toString(3), "Error when reading orclreplicaid value  - " + exception.toString()};
            return stringArray5;
        }
        try {
            propertySetCollection = Util.ldapSearch(dirContext2, string, "objectclass=*", 0, new String[]{"seeAlso"});
            string2 = (String)propertySetCollection.getPropertySet(0).getProperty("seeAlso").getValue(0);
        }
        catch (UtilException utilException) {
            String[] stringArray6 = new String[]{Integer.toString(3), "While retrieving orclreplicaid entry under cn=replication configuration - " + utilException.toString()};
            return stringArray6;
        }
        catch (Exception exception) {
            String[] stringArray7 = new String[]{Integer.toString(3), "Error when reading seeAlso of replicaid entry - " + exception.toString()};
            return stringArray7;
        }
        if (bl) {
            try {
                boolean bl2 = false;
                propertySetCollection = Util.ldapSearch(dirContext2, "cn=IAS Infrastructure Databases,cn=ias,cn=products,cn=oraclecontext", "objectclass=*", 1, new String[]{"seeAlso"});
                int n = 0;
                while (n < propertySetCollection.size()) {
                    stringArray2 = (String)propertySetCollection.getPropertySet(n).getProperty("seeAlso").getValue(0);
                    if (Util.normalizeDN(string2).equals(Util.normalizeDN((String)stringArray2))) {
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
                if (!bl2) {
                    stringArray2 = new String[]{Integer.toString(7)};
                    return stringArray2;
                }
            }
            catch (UtilException utilException) {
                String[] stringArray8 = new String[]{Integer.toString(3), "While retrieving Reference Names under cn=replication configuration - " + utilException.toString()};
                return stringArray8;
            }
            catch (Exception exception) {
                String[] stringArray9 = new String[]{Integer.toString(3), "Error when reading Reference Name entries " + exception.toString()};
                return stringArray9;
            }
        }
        try {
            String[] stringArray10;
            propertySetCollection = Util.ldapSearch(dirContext2, string2, "objectclass=*", 0, new String[]{"orcldbglobalname", "orclnetdescstring"});
            stringArray10 = new String[]{Integer.toString(0), (String)propertySetCollection.getPropertySet(0).getProperty("orcldbglobalname").getValue(0), (String)propertySetCollection.getPropertySet(0).getProperty("orclnetdescstring").getValue(0), string2, "orclReferenceName=" + stringArray10[1] + ",cn=IAS Infrastructure Databases,cn=IAS,cn=Products,cn=OracleContext"};
            return stringArray10;
        }
        catch (UtilException utilException) {
            String[] stringArray11 = new String[]{Integer.toString(3), "While retrieving DB registration entry " + string2 + " - " + utilException.toString()};
            return stringArray11;
        }
        catch (Exception exception) {
            stringArray2 = new String[]{Integer.toString(3), "Error when reading gdbname and netdescstring value from " + string2 + "  - " + exception.toString()};
            return stringArray2;
        }
    }

    private static String[] getOIDVersion(String[] stringArray) {
        Object var1_1 = null;
        if (stringArray.length != 5) {
            String[] stringArray2 = new String[]{Integer.toString(1)};
            return stringArray2;
        }
        DirContext dirContext = OUILdap.getDirCtx(stringArray);
        if (dirContext == null) {
            return OUILdap.error_Connection(stringArray);
        }
        try {
            PropertySetCollection propertySetCollection = Util.ldapSearch(dirContext, "", "objectclass=*", 0, new String[]{"orcldirectoryversion"});
            String[] stringArray3 = new String[2];
            stringArray3[0] = Integer.toString(0);
            String string = (String)propertySetCollection.getPropertySet(0).getProperty("orcldirectoryversion").getValue(0);
            stringArray3[1] = string.substring(string.indexOf("OID") + 3).trim();
            return stringArray3;
        }
        catch (UtilException utilException) {
            String[] stringArray4 = new String[]{Integer.toString(3)};
            return stringArray4;
        }
    }

    private static String[] isMember(String[] stringArray) {
        Object var1_1 = null;
        if (stringArray.length != 8) {
            String[] stringArray2 = new String[]{Integer.toString(1)};
            return stringArray2;
        }
        DirContext dirContext = OUILdap.getDirCtx(stringArray);
        if (dirContext == null) {
            return OUILdap.error_Connection(stringArray);
        }
        try {
            boolean bl = Util.ldapCompare(dirContext, stringArray[5], stringArray[6], stringArray[7]);
            String[] stringArray3 = new String[]{bl ? Integer.toString(0) : Integer.toString(4)};
            return stringArray3;
        }
        catch (UtilException utilException) {
            String[] stringArray4 = new String[]{Integer.toString(3)};
            return stringArray4;
        }
    }

    private static String[] validateDN(String[] stringArray) {
        Object var1_1 = null;
        if (stringArray.length != 1) {
            String[] stringArray2 = new String[]{Integer.toString(1)};
            return stringArray2;
        }
        String string = Util.normalizeDN(stringArray[0], new String[]{"dc", "o", "l", "c"});
        if (string == null || string.length() == 0) {
            String[] stringArray3 = new String[]{Integer.toString(6)};
            return stringArray3;
        }
        String[] stringArray4 = new String[]{Integer.toString(0), string};
        return stringArray4;
    }

    private static DirContext getDirCtx(String[] stringArray) {
        if (stringArray[4] == null || stringArray[4].length() != 0 && !stringArray[4].equals("oracle.ldap.util.jndi.LDAPSSLSocketFactoryImpl") && !stringArray[4].equals("oracle.ias.repqueries.InstallSSLSocketFactoryImpl")) {
            return null;
        }
        boolean bl = false;
        if (stringArray[4].length() != 0) {
            bl = true;
        }
        boolean bl2 = false;
        InitialLdapContext initialLdapContext = null;
        if (!bl) {
            try {
                initialLdapContext = ConnectionUtil.getDefaultDirCtx(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
                bl2 = true;
            }
            catch (NamingException namingException) {
                return null;
            }
        }
        try {
            initialLdapContext = ConnectionUtil.getSSLDirCtx(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        catch (NamingException namingException) {
            return null;
        }
        return initialLdapContext;
    }

    private static String[] error_Connection(String[] stringArray) {
        String[] stringArray2 = new String[]{Integer.toString(2), new String("Cannot establish connection with the following input:  host:" + stringArray[0] + " port:" + stringArray[1] + " bindDN:" + stringArray[2] + " bindPwd: *****" + " SSL Socket Factory:" + stringArray[4])};
        return stringArray2;
    }
}

