/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class OracleContext
extends LDAPEntry {
    public static final String oracleContextCN = "OracleContext";
    public static final String oracleContextRDN = "cn=OracleContext";
    public static final String oracleContextObjClass = "orclContext";
    private static final String adDefaultNamingContext = "defaultNamingContext";
    protected static final String listFileExt = ".lst";
    protected String ohome = null;
    protected String orclCtxVersion = null;
    protected String orclCtxFilePrefix = "oidContext";
    protected Vector subVector = null;
    protected PropertySetCollection commonPsc = null;
    protected String[] resolveAttrs = new String[]{"orclversion", "orclCommonNickNameAttribute", "orclCommonNamingAttribute", "orclCommonUserSearchBase", "orclCommonUserCreateBase", "orclCommonGroupSearchBase", "orclUserObjectclasses"};
    protected String fileSeparator = null;
    protected PrintStream pStream = System.out;

    public OracleContext(DirContext dirContext, String string, String string2) {
        this(dirContext, string, string2, System.out);
    }

    public OracleContext(DirContext dirContext, String string, String string2, PrintStream printStream) {
        this(dirContext, string2);
        this.pStream = printStream;
        this.ohome = string;
    }

    public OracleContext(DirContext dirContext, String string) {
        super(dirContext, string);
        this.fileSeparator = System.getProperty("file.separator");
    }

    public boolean exists(DirContext dirContext) {
        try {
            this.resolve(dirContext);
        }
        catch (UtilException utilException) {
            return false;
        }
        return true;
    }

    public void refresh(DirContext dirContext) throws UtilException {
        this.validated = false;
        this.resolve(dirContext);
    }

    public void resolve(DirContext dirContext) throws UtilException {
        if (!this.validated) {
            try {
                PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, this.entryDN, "(|(objectclass=orclContext)(cn=common))", 2, this.resolveAttrs);
                if (propertySetCollection.isEmpty() || propertySetCollection.size() < 2) {
                    throw new UtilException("Invalid OracleContext:  " + this.entryDN);
                }
                this.commonPsc = new PropertySetCollection();
                this.commonPsc.add(propertySetCollection.getPropertySet("cn=common,cn=products," + this.entryDN));
                this.entryPsc = new PropertySetCollection();
                this.entryPsc.add(propertySetCollection.getPropertySet(this.entryDN));
                this.validated = true;
            }
            catch (NamingException namingException) {
                if (namingException instanceof CommunicationException) {
                    throw new CommunicationErrorException(LDAPEntry.resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                }
                throw new UtilException(LDAPEntry.resBundle.getString("ORACLECONTEXT_RESOLVE_ERROR") + this.entryDN, namingException);
            }
        }
    }

    public void create(DirContext dirContext) throws UtilException {
        try {
            this.getSubstitutionVector(dirContext);
            String string = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "oid" + this.fileSeparator + this.orclCtxFilePrefix + "Create.lst";
            Util.ldapModify(dirContext, string, this.subVector, true, this.pStream);
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                throw new CommunicationErrorException(LDAPEntry.resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), exception);
            }
            throw new UtilException(LDAPEntry.resBundle.getString("ORACLECONTEXT_CREATION_ERROR"), exception);
        }
    }

    public String getVersion(DirContext dirContext) throws UtilException {
        this.validated = false;
        this.resolve(dirContext);
        return (String)this.entryPsc.getPropertySet(0).getProperty("orclversion").getValue(0);
    }

    public String getDBCompatibilityVersion(DirContext dirContext) throws UtilException {
        try {
            String[] stringArray = new String[]{"orclDBVersionCompatibility"};
            PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, "cn=OracleDBSecurity,cn=products," + this.entryDN, "(objectclass=*)", 0, stringArray);
            return (String)propertySetCollection.getPropertySet(0).getProperty(0).getValue(0);
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                throw new CommunicationErrorException(LDAPEntry.resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), exception);
            }
            throw new UtilException(LDAPEntry.resBundle.getString("ORACLECONTEXT_RESOLVE_ERROR") + this.entryDN, exception);
        }
    }

    public static String[] getOracleContext(DirContext dirContext) throws UtilException {
        return OracleContext.getOracleContext(dirContext, "");
    }

    public static String[] getOracleContext(DirContext dirContext, String string) throws UtilException {
        try {
            PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, string, "(objectclass=orclContext)", 2, new String[0]);
            int n = propertySetCollection.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = new String(propertySetCollection.getPropertySet(n2).getDN());
                ++n2;
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                throw new CommunicationErrorException(LDAPEntry.resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), exception);
            }
            throw new UtilException(LDAPEntry.resBundle.getString("GENERAL_ERROR_SEARCH"), exception);
        }
    }

    public void upgrade(DirContext dirContext) throws Exception {
        while (!this.isUpToDate(dirContext)) {
            String string = this.getVersion(dirContext);
            this.pStream.println("curVersion: " + string);
            this.pStream.println("");
            String string2 = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "oid" + this.fileSeparator + this.orclCtxFilePrefix + "UpgradeFrom" + string + listFileExt;
            this.pStream.println("Loading: " + string2);
            this.getSubstitutionVector(dirContext);
            Util.ldapModify(dirContext, string2, this.subVector, true, this.pStream);
        }
    }

    protected void getSubstitutionVector(DirContext dirContext) {
        try {
            Hashtable<?, ?> hashtable = dirContext.getEnvironment();
            String string = (String)hashtable.get("java.naming.security.principal");
            String string2 = Util.getParentDN(this.entryDN);
            this.subVector = new Vector(6);
            this.subVector.insertElementAt("s_CurrentUserDN", 0);
            this.subVector.insertElementAt(string, 1);
            this.subVector.insertElementAt("s_OracleContextParentDN", 2);
            this.subVector.insertElementAt(string2, 3);
            this.subVector.insertElementAt("s_OracleContextDN", 4);
            this.subVector.insertElementAt(this.entryDN, 5);
            this.subVector.toString();
        }
        catch (NamingException namingException) {}
    }

    public PropertySetCollection getCommonProperties(DirContext dirContext, String[] stringArray) throws UtilException {
        boolean bl = true;
        this.resolve(dirContext);
        try {
            if (bl && stringArray != null) {
                this.commonPsc.getPropertySet(0).doSearch(dirContext, stringArray);
                PropertySetCollection propertySetCollection = new PropertySetCollection();
                propertySetCollection.add(this.commonPsc.getPropertySet(0).returnPropertySet(stringArray));
                return propertySetCollection;
            }
            this.commonPsc = Util.getEntryDetails(dirContext, this.entryDN, "(objectclass=*)", 0, stringArray);
            return this.commonPsc;
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(LDAPEntry.resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException(LDAPEntry.resBundle.getString("ORACLECONTEXT_RESOLVE_ERROR") + this.entryDN, namingException);
        }
    }

    public boolean isUpToDate(DirContext dirContext) throws UtilException {
        try {
            String string = this.getVersion(dirContext);
            String string2 = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "versions.txt";
            this.pStream.println(string2);
            String string3 = Util.getParameterFromFile("ContextVersion", string2);
            this.pStream.println("version: " + string + " up_version: " + string3);
            return string3.compareTo(string) <= 0;
        }
        catch (IOException iOException) {
            return true;
        }
    }
}

