/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.ResourceBundle;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Service;
import oracle.ldap.util.ServiceRecipient;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class ServiceReference
extends LDAPEntry {
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    private String subscriptionContainerDN = null;
    private String serviceInstanceDN = null;

    public ServiceReference(DirContext dirContext, String string) {
        super(dirContext, string);
        try {
            this.resolve(dirContext);
        }
        catch (UtilException utilException) {}
    }

    public ServiceReference(DirContext dirContext, String string, PropertySet propertySet) {
        super(dirContext, string, propertySet);
        try {
            this.resolve(dirContext);
        }
        catch (UtilException utilException) {}
    }

    public Service getServiceInstance(DirContext dirContext) throws UtilException {
        this.resolve(dirContext);
        if (this.serviceInstanceDN == null) {
            throw new UtilException("Cannot locate Service Instance - attribute value missing");
        }
        Service service = new Service(dirContext, this.serviceInstanceDN);
        return service;
    }

    public ServiceRecipient getServiceRecipient(DirContext dirContext, String string) throws UtilException {
        this.resolve(dirContext);
        if (this.subscriptionContainerDN != null) {
            return new ServiceRecipient(dirContext, "cn=" + string + "," + this.subscriptionContainerDN);
        }
        throw new UtilException("Unable to locate subscription container");
    }

    public ServiceRecipient createServiceRecipient(DirContext dirContext, String string) throws UtilException {
        this.resolve(dirContext);
        if (this.subscriptionContainerDN == null) {
            throw new UtilException("Subscription Container not specified");
        }
        String string2 = "cn=" + string + "," + this.subscriptionContainerDN;
        String[] stringArray = new String[]{"groupOfUniqueNames", "orclServiceRecipient", "top"};
        ModPropertySet modPropertySet = new ModPropertySet(1);
        modPropertySet.addProperty(0, "objectclass", stringArray);
        modPropertySet.addProperty(0, "cn", string);
        modPropertySet.addProperty(0, "uniquemember", "cn=orcladmin");
        try {
            Util.ldapAdd(dirContext, string2, modPropertySet);
        }
        catch (UtilException utilException) {
            throw new UtilException("Cannot Create Service Recipient", utilException);
        }
        return new ServiceRecipient(dirContext, string2);
    }

    public ServiceRecipient[] getAllServiceRecipients(DirContext dirContext) throws UtilException {
        return this.getAllServiceRecipients(dirContext, new String[0]);
    }

    public ServiceRecipient[] getAllServiceRecipients(DirContext dirContext, String[] stringArray) throws UtilException {
        this.resolve(dirContext);
        if (this.subscriptionContainerDN == null) {
            throw new UtilException("Unable to locate subscription container");
        }
        ServiceRecipient[] serviceRecipientArray = null;
        try {
            PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, this.subscriptionContainerDN, "(objectclass=orclServiceRecipient)", 2, stringArray);
            if (propertySetCollection != null) {
                serviceRecipientArray = new ServiceRecipient[propertySetCollection.size()];
                int n = 0;
                while (n < propertySetCollection.size()) {
                    PropertySet propertySet = propertySetCollection.getPropertySet(n);
                    serviceRecipientArray[n] = new ServiceRecipient(dirContext, propertySet.getDN(), propertySet);
                    ++n;
                }
            }
            return serviceRecipientArray;
        }
        catch (NamingException namingException) {
            throw new UtilException(namingException.toString());
        }
    }

    public void resolve(DirContext dirContext) throws UtilException {
        String[] stringArray;
        PropertySetCollection propertySetCollection;
        if (!this.validated && !(propertySetCollection = Util.dnExists(dirContext, this.entryDN, stringArray = new String[]{"orclservicesubscriptionlocation", "orclserviceinstancelocation"})).isEmpty()) {
            Property property = propertySetCollection.getPropertySet(0).getProperty("orclservicesubscriptionlocation");
            Property property2 = propertySetCollection.getPropertySet(0).getProperty("orclserviceinstancelocation");
            this.validated = true;
            if (property != null) {
                this.subscriptionContainerDN = (String)property.getValue(0);
            } else {
                this.validated = false;
            }
            if (property2 != null) {
                this.serviceInstanceDN = (String)property2.getValue(0);
            } else {
                this.validated = false;
            }
        }
    }
}

