/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.ldap.das.util.UILabelsNLS;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.GeneralErrorException;
import oracle.ldap.util.Group;
import oracle.ldap.util.InvalidSubscriberOrclctxException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.NoSuchUserException;
import oracle.ldap.util.OracleContext;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.ServiceReference;
import oracle.ldap.util.User;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class Subscriber
extends LDAPEntry {
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    private String inSubId = null;
    private int subIdType = -1;
    private PropertySetCollection rootOracleContextCommonPsc = null;
    private OracleContext oracleContext = null;
    private String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    private String defaultUserGUID = "8da1c26fca6e10cae0340800208d6360";
    private String[] attrList = new String[0];
    private String ohome = null;
    private String[] userSearchBase = null;
    private String userNickNameAttr = null;
    private String userPrincipalAttr = null;
    private String userNameWinAttr = null;
    private boolean autoRegEnabled = false;
    private String[] userCreateBase = null;
    private String userNamingAttr = null;
    private LDIFAttribute userObjCls = null;
    private PropertySetCollection userMandatoryAttrPsc = null;
    private String[] groupSearchBase = null;
    private boolean validated = false;
    private boolean dnValidated = false;
    private boolean oracleContextValidated = false;
    private String subCreateCommonFilePrefix = "oidSubscriberCreateCommon";
    public static int EXTPROPTYPE_COMMON = 0;
    public static int EXTPROPTYPE_RESOURCE_ACCESS_TYPE = 1;
    public static int EXTPROPTYPE_DEFAULT_RAD = 2;
    static String SIMPLE_PRINCIPAL_ATTR = "orclcommonnicknameattribute";
    static String KERB_PRINCIPAL_ATTR = "orclcommonkrbprincipalattribute";
    static String WIN_PRINCIPAL_ATTR = "orclcommonwindowsprincipalattribute";
    public static final String USER_NAMING_ATTR_SIMPLE = "orclcommonnicknameattribute";
    public static final String USER_NAMING_ATTR_WINDOWS = "orclcommonwindowsprincipalattribute";
    public static final String USER_NAMING_ATTR_KERBEROS = "orclcommonkrbprincipalattribute";
    public static final int ENTRY_PROPERTIES = 0;
    public static final int DETACHED_PROPERTIES = 1;
    public static final int COMMON_PROPERTIES = 2;
    public static final int USER_NAMING_PROPERTIES = 3;
    protected static final int PROPERTY_USER_SEARCH_BASE = 2;
    static final int ATTRLIST_SEARCHBASE_MARK = 4;

    protected Subscriber(DirContext dirContext, String string) {
        super(dirContext, string);
        this.dnValidated = true;
    }

    protected Subscriber(DirContext dirContext, String string, PropertySet propertySet) {
        super(dirContext, string, propertySet);
        this.dnValidated = true;
    }

    public Subscriber(DirContext dirContext, int n, String string, boolean bl) throws UtilException {
        this(dirContext, n, string, null, null, new String[0]);
    }

    protected Subscriber(DirContext dirContext, int n, String string, String string2, PropertySetCollection propertySetCollection, String[] stringArray) throws UtilException {
        super(dirContext, string);
        if (string == null && n == Util.IDTYPE_DN) {
            n = Util.IDTYPE_DEFAULT;
        }
        if (string == null && n != Util.IDTYPE_DEFAULT) {
            throw new ParameterException(resBundle.getString("PARAMETER_NULL") + ":  inSubIdName");
        }
        if (n != Util.IDTYPE_DN && n != Util.IDTYPE_SIMPLE && n != Util.IDTYPE_GUID && n != Util.IDTYPE_DEFAULT) {
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  inSubIdType");
        }
        if (n == Util.IDTYPE_DN && string == null) {
            n = Util.IDTYPE_DEFAULT;
        }
        this.subIdType = n;
        this.inSubId = string;
        this.ohome = string2;
        this.rootOracleContextCommonPsc = propertySetCollection;
        this.attrList = stringArray;
        this.resolve(dirContext);
    }

    public PropertySetCollection getProperties(DirContext dirContext, String[] stringArray) throws UtilException {
        return super.getProperties(dirContext, stringArray, true);
    }

    public void setProperties(DirContext dirContext, ModPropertySet modPropertySet) throws UtilException {
        super.setProperties(dirContext, modPropertySet);
    }

    public void setExtendedProperties(DirContext dirContext, int n, ModPropertySet modPropertySet) throws UtilException {
        if (n == EXTPROPTYPE_COMMON) {
            Util.setEntryDetails(dirContext, "cn=common,cn=products,cn=oraclecontext," + this.entryDN, modPropertySet);
        }
    }

    public PropertySetCollection getExtendedProperties(DirContext dirContext, int n, String[] stringArray, String string) throws UtilException {
        if (!this.oracleContextValidated) {
            this.resolve(dirContext);
        }
        try {
            if (n == EXTPROPTYPE_COMMON) {
                return this.oracleContext.getCommonProperties(dirContext, stringArray);
            }
            if (n == EXTPROPTYPE_RESOURCE_ACCESS_TYPE) {
                return Util.getEntryDetails(dirContext, "cn=Resource Access Type," + this.commonDN + "," + this.entryDN, string, 2, stringArray);
            }
            if (n == EXTPROPTYPE_DEFAULT_RAD) {
                PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, "cn=Resource Access Descriptor, orclownerguid=" + this.defaultUserGUID + ",cn=Extended Properties,cn=OracleContext," + this.entryDN, string, 1, stringArray);
                if (propertySetCollection == null) {
                    throw new GeneralErrorException(resBundle.getString("GENERAL_ERROR_SEARCH") + ": Unable to get Default RAD");
                }
                if (propertySetCollection.isEmpty()) {
                    throw new GeneralErrorException(resBundle.getString("GENERAL_ERROR_SEARCH") + ": Unable to get Default RAD");
                }
                return propertySetCollection;
            }
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  propType");
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new GeneralErrorException(resBundle.getString("GENERAL_ERROR_SEARCH") + ":  getExtendedProperties", namingException);
        }
    }

    public void resolve(DirContext dirContext) throws UtilException {
        if (!this.validated) {
            Object object;
            Object object2;
            if (!this.dnValidated) {
                block44: {
                    if ((this.subIdType == Util.IDTYPE_DEFAULT || this.subIdType == Util.IDTYPE_SIMPLE) && this.rootOracleContextCommonPsc == null) {
                        object2 = new String[]{"orclSubscriberSearchBase", "orclSubscriberNickNameAttribute", "orclDefaultSubscriber"};
                        object = new RootOracleContext(dirContext, this.ohome);
                        this.rootOracleContextCommonPsc = ((OracleContext)object).getCommonProperties(dirContext, (String[])object2);
                    }
                    if (this.subIdType == Util.IDTYPE_DEFAULT) {
                        try {
                            this.entryDN = (String)this.rootOracleContextCommonPsc.getPropertySet(0).getProperty("orclDefaultSubscriber").getValue(0);
                        }
                        catch (Exception exception) {
                            throw new UtilException("Subscriber configuration not found");
                        }
                        try {
                            this.entryPsc = Util.getEntryDetails(dirContext, this.entryDN, "objectclass=orclSubscriber", 0, this.attrList);
                            if (this.entryPsc.size() < 1) {
                                throw new UtilException("Subscriber does not exist - DEFAULT = " + this.entryDN);
                            }
                            break block44;
                        }
                        catch (NamingException namingException) {
                            if (namingException instanceof CommunicationException) {
                                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                            }
                            throw new UtilException("NamingException encountered when resolving subscriber - DEFAULT = " + this.entryDN);
                        }
                    }
                    if (this.subIdType == Util.IDTYPE_SIMPLE) {
                        object2 = null;
                        object = null;
                        try {
                            object2 = this.rootOracleContextCommonPsc.getPropertySet(0).getProperty("orclSubscriberSearchBase") == null ? "" : (String)this.rootOracleContextCommonPsc.getPropertySet(0).getProperty("orclSubscriberSearchBase").getValue(0);
                            object = (String)this.rootOracleContextCommonPsc.getPropertySet(0).getProperty("orclSubscriberNickNameAttribute").getValue(0);
                        }
                        catch (Exception exception) {
                            throw new UtilException("Subscriber Configuration not found");
                        }
                        try {
                            this.entryPsc = Util.getEntryDetails(dirContext, (String)object2, "(&(objectclass=orclSubscriber)(" + (String)object + "=" + this.inSubId + "))", 2, this.attrList);
                            if (this.entryPsc.size() > 1) {
                                throw new UtilException("Multiple Subscribers found with Simple Name = " + this.inSubId);
                            }
                            if (this.entryPsc.size() < 1) {
                                throw new UtilException("Subscriber does not exist - SIMPLE NAME = " + this.inSubId);
                            }
                            this.entryDN = this.entryPsc.getPropertySet(0).getDN();
                        }
                        catch (NamingException namingException) {
                            if (namingException instanceof CommunicationException) {
                                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                            }
                            throw new UtilException("NamingException encountered when resolving subscriber - SIMPLE NAME = " + this.inSubId);
                        }
                    }
                    if (this.subIdType == Util.IDTYPE_GUID) {
                        try {
                            this.entryPsc = Util.getEntryDetails(dirContext, "", "(&(objectclass=orclSubscriber)(orclGuid=" + this.inSubId + "))", 2, this.attrList);
                            if (this.entryPsc.size() > 0) {
                                this.entryDN = this.entryPsc.getPropertySet(0).getDN();
                                break block44;
                            }
                            throw new UtilException("Subscriber does not exist - GUID = " + this.entryDN);
                        }
                        catch (NamingException namingException) {
                            if (namingException instanceof CommunicationException) {
                                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                            }
                            throw new UtilException("NamingException encountered when resolving subscriber - GUID = " + this.entryDN);
                        }
                    }
                    if (this.subIdType == Util.IDTYPE_DN) {
                        this.entryDN = this.inSubId;
                        try {
                            this.entryPsc = Util.getEntryDetails(dirContext, this.entryDN, "objectclass=*", 0, this.attrList);
                            if (this.entryPsc.size() < 0) {
                                throw new UtilException("Subscriber does not exist - DN = " + this.entryDN);
                            }
                        }
                        catch (NamingException namingException) {
                            if (namingException instanceof CommunicationException) {
                                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                            }
                            throw new UtilException("NamingException encountered when resolving subscriber - DN =" + this.entryDN);
                        }
                    }
                }
                this.dnValidated = true;
            }
            if (!this.oracleContextValidated) {
                this.oracleContext = new OracleContext(dirContext, this.ohome, "cn=oraclecontext," + this.entryDN);
                object2 = new String[]{"orclcommonusersearchbase", USER_NAMING_ATTR_SIMPLE, "orclcommonnamingattribute", "orclcommongroupsearchbase", "orclcommonautoregenabled", USER_NAMING_ATTR_KERBEROS, USER_NAMING_ATTR_WINDOWS};
                object = null;
                try {
                    object = this.oracleContext.getCommonProperties(dirContext, (String[])object2).getPropertySet(0);
                }
                catch (NullPointerException nullPointerException) {
                    throw new UtilException("Subscriber's naming is not configured");
                }
                Property property = ((PropertySet)object).getProperty("orclcommonusersearchbase");
                String[] stringArray = new String[property.size()];
                int n = 0;
                while (n < property.size()) {
                    stringArray[n] = (String)property.getValue(n);
                    ++n;
                }
                this.userSearchBase = stringArray;
                property = ((PropertySet)object).getProperty("orclcommongroupsearchbase");
                String[] stringArray2 = new String[property.size()];
                int n2 = 0;
                while (n2 < property.size()) {
                    stringArray2[n2] = (String)property.getValue(n2);
                    ++n2;
                }
                this.groupSearchBase = stringArray2;
                try {
                    String string;
                    Property property2 = ((PropertySet)object).getProperty("orclcommonautoregenabled");
                    this.autoRegEnabled = property2 == null ? false : (string = (String)property2.getValue(0)).equals("1");
                }
                catch (Exception exception) {
                    throw new InvalidSubscriberOrclctxException("orclcommonautoregenabled is missing");
                }
                try {
                    this.userNickNameAttr = (String)((PropertySet)object).getProperty(USER_NAMING_ATTR_SIMPLE).getValue(0);
                }
                catch (Exception exception) {
                    throw new InvalidSubscriberOrclctxException("orclcommonnicknameattribute is missing");
                }
                try {
                    this.userNamingAttr = (String)((PropertySet)object).getProperty("orclcommonnamingattribute").getValue(0);
                }
                catch (Exception exception) {
                    if (this.oracleContext.getVersion(dirContext).compareTo("90230") > 0) {
                        throw new InvalidSubscriberOrclctxException("orclcommonnamingattribute is missing");
                    }
                    this.userNamingAttr = this.userNickNameAttr;
                }
                try {
                    this.userPrincipalAttr = (String)((PropertySet)object).getProperty(USER_NAMING_ATTR_KERBEROS).getValue(0);
                }
                catch (Exception exception) {
                    this.userPrincipalAttr = this.userNickNameAttr;
                }
                try {
                    this.userNameWinAttr = (String)((PropertySet)object).getProperty(USER_NAMING_ATTR_WINDOWS).getValue(0);
                }
                catch (Exception exception) {
                    this.userNameWinAttr = "orclSAMAccountName";
                }
                this.oracleContextValidated = true;
            }
        }
    }

    public void refresh(DirContext dirContext) throws UtilException {
        this.validated = false;
        this.dnValidated = false;
        this.oracleContextValidated = false;
        this.resolve(dirContext);
    }

    public String getDN(DirContext dirContext) throws UtilException {
        this.resolve(dirContext);
        return this.entryDN;
    }

    public String getDn(DirContext dirContext) throws UtilException {
        return this.getDN(dirContext);
    }

    public User getUser(DirContext dirContext, int n, String string, String string2, String[] stringArray, boolean bl) throws UtilException {
        try {
            return this.getUser(dirContext, n, string, string2, stringArray);
        }
        catch (UtilException utilException) {
            if (bl && this.autoRegEnabled && utilException instanceof NoSuchUserException) {
                String string3 = null;
                if (n == Util.IDTYPE_DN) {
                    string3 = string;
                } else if (n == Util.IDTYPE_SIMPLE) {
                    this.getUserCreationInfo(dirContext);
                    string3 = this.userNickNameAttr + "=" + string + "," + this.userCreateBase[0];
                }
                User user = new User(dirContext, Util.IDTYPE_DN, string3, 0, null, null, null, null, null, new String[0], true, false);
                return user;
            }
            throw utilException;
        }
    }

    public User getUser(DirContext dirContext, int n, String string, String[] stringArray) throws UtilException {
        return this.getUser(dirContext, n, string, null, stringArray);
    }

    public User getUser(DirContext dirContext, int n, String string, String string2, String[] stringArray) throws UtilException {
        this.resolve(dirContext);
        if (n == Util.IDTYPE_SIMPLE || n == Util.IDTYPE_FILTER || n == Util.IDTYPE_WINDOWS || n == Util.IDTYPE_KERB_PRINCIPAL) {
            String[] stringArray2 = null;
            if (stringArray != null) {
                int n2 = stringArray.length + 4;
                stringArray2 = new String[n2];
                int n3 = 0;
                while (n3 < stringArray.length) {
                    stringArray2[n3] = stringArray[n3];
                    ++n3;
                }
                stringArray2[stringArray.length] = "orclguid";
                stringArray2[stringArray.length + 1] = this.userNickNameAttr;
                stringArray2[stringArray.length + 2] = this.userPrincipalAttr;
                stringArray2[stringArray.length + 3] = this.userNameWinAttr;
            }
            return (User)this.getUser_NICKNAME(dirContext, n, string, string2, stringArray2, true, null);
        }
        if (n == Util.IDTYPE_DN) {
            return this.getUser_DN(dirContext, string, stringArray);
        }
        if (n == Util.IDTYPE_GUID) {
            return this.getUser_GUID(dirContext, string, stringArray);
        }
        throw new UtilException("Invalid Parameters");
    }

    public User[] getUsers(DirContext dirContext, int n, String string, String string2, String[] stringArray) throws UtilException {
        return this.getUsers(dirContext, n, string, string2, stringArray, null);
    }

    public User[] getUsers(DirContext dirContext, int n, String string, String string2, String[] stringArray, SearchControls searchControls) throws UtilException {
        this.resolve(dirContext);
        SearchControls searchControls2 = null;
        if (searchControls != null) {
            searchControls2 = new SearchControls();
            searchControls2.setSearchScope(2);
            searchControls2.setCountLimit(searchControls.getCountLimit());
            searchControls2.setTimeLimit(searchControls.getTimeLimit());
        }
        String[] stringArray2 = null;
        if (stringArray != null) {
            int n2 = stringArray.length + 4;
            stringArray2 = new String[n2];
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringArray2[n3] = stringArray[n3];
                ++n3;
            }
            stringArray2[stringArray.length] = "orclguid";
            stringArray2[stringArray.length + 1] = this.userNickNameAttr;
            stringArray2[stringArray.length + 2] = this.userPrincipalAttr;
            stringArray2[stringArray.length + 3] = this.userNameWinAttr;
        }
        if (searchControls2 != null) {
            searchControls2.setReturningAttributes(stringArray2);
        }
        if (n == Util.IDTYPE_SIMPLE || n == Util.IDTYPE_FILTER) {
            return (User[])this.getUser_NICKNAME(dirContext, n, string, string2, stringArray2, false, searchControls2);
        }
        throw new ParameterException("Invalid userIdType");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private Object getUser_NICKNAME(DirContext dirContext, int n, String string, String string2, String[] stringArray, boolean bl, SearchControls searchControls) throws UtilException {
        User[] userArray;
        int n2;
        Object object;
        int n3;
        if (string2 != null) {
            boolean bl2 = false;
            n3 = 0;
            while (n3 < this.userSearchBase.length) {
                object = Util.normalizeDN(this.userSearchBase[n3]);
                if (((String)object).equals(Util.normalizeDN(string2))) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            if (!bl2) {
                throw new UtilException("Invalid user search base");
            }
            this.userSearchBase = new String[1];
            this.userSearchBase[0] = string2;
        }
        String string3 = null;
        if (n == Util.IDTYPE_SIMPLE) {
            string3 = "(" + this.userNickNameAttr + "=" + string + ")";
        } else if (n == Util.IDTYPE_FILTER) {
            string3 = "(&(" + string + ")(objectclass=organizationalperson))";
        } else if (n == Util.IDTYPE_WINDOWS) {
            if (this.userNameWinAttr == null) throw new UtilException("orclcommonwindowsprincipalattribute is not defined in this realm");
            string3 = "(" + this.userNameWinAttr + "=" + string + ")";
        } else if (n == Util.IDTYPE_KERB_PRINCIPAL) {
            if (this.userPrincipalAttr == null) throw new UtilException("orclcommonkrbprincipalattribute is not defined in this realm");
            string3 = "(" + this.userPrincipalAttr + "=" + string + ")";
        }
        n3 = 0;
        object = null;
        if (!bl) {
            object = new Vector();
        }
        User user = null;
        boolean bl3 = false;
        do {
            n2 = 0;
            while (n2 < this.userSearchBase.length) {
                try {
                    userArray = this.userSearchBase[n2];
                    NamingEnumeration namingEnumeration = (NamingEnumeration)(searchControls == null ? Util.getEntryDetails(dirContext, (String)userArray, string3, 2, stringArray, false) : Util.getEntryDetails(dirContext, (String)userArray, string3, searchControls));
                    boolean bl4 = namingEnumeration.hasMoreElements();
                    if (!bl4 && n2 == this.userSearchBase.length - 1 && bl && n3 == 0) {
                        if (n != Util.IDTYPE_WINDOWS) throw new NoSuchUserException("User does not exist - SIMPLE NAME = " + string);
                        if (bl3) throw new NoSuchUserException("User does not exist - SIMPLE NAME = " + string);
                        bl3 = true;
                    } else {
                        while (bl4) {
                            if (bl && n3 != 0) {
                                throw new UtilException("Multiple Users found with Simple Name = " + string);
                            }
                            SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                            String string4 = null;
                            String string5 = null;
                            string4 = userArray.equals("") ? new String(searchResult.getName()) : new String(searchResult.getName() + "," + (String)userArray);
                            if (stringArray != null) {
                                string5 = (String)searchResult.getAttributes().get("orclguid").get(0);
                            }
                            user = new User(dirContext, string4, string5, this.userSearchBase[n2], this, searchResult);
                            if (!bl) {
                                ((Vector)object).addElement(user);
                            } else {
                                n3 = 1;
                                bl3 = false;
                            }
                            bl4 = namingEnumeration.hasMoreElements();
                        }
                    }
                }
                catch (NamingException namingException) {
                    if (!(namingException instanceof CommunicationException)) throw new UtilException("NamingException encountered when resolving user - SIMPLE NAME = " + string, namingException);
                    throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
                }
                ++n2;
            }
        } while (bl3);
        if (bl) {
            return user;
        }
        n2 = ((Vector)object).size();
        userArray = new User[n2];
        int n4 = 0;
        while (n4 < n2) {
            userArray[n4] = (User)((Vector)object).elementAt(n4);
            ++n4;
        }
        return userArray;
    }

    private User getUser_GUID(DirContext dirContext, String string, String[] stringArray) throws UtilException {
        try {
            NamingEnumeration namingEnumeration = (NamingEnumeration)Util.getEntryDetails(dirContext, "", "(orclguid=" + string + ")", 2, stringArray, false);
            if (!namingEnumeration.hasMoreElements()) {
                throw new NoSuchUserException("User does not exist - GUID = " + string);
            }
            SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
            String string2 = new String(searchResult.getName());
            String string3 = string;
            return new User(dirContext, string2, string3, "", this, searchResult);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("NamingException encountered when resolving user - GUID = " + string, namingException);
        }
    }

    private User getUser_DN(DirContext dirContext, String string, String[] stringArray) throws UtilException {
        String[] stringArray2 = null;
        if (stringArray != null) {
            int n = stringArray.length + 4;
            stringArray2 = new String[n];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray2[n2] = stringArray[n2];
                ++n2;
            }
            stringArray2[stringArray.length] = "orclguid";
            stringArray2[stringArray.length + 1] = this.userNickNameAttr;
            stringArray2[stringArray.length + 2] = this.userPrincipalAttr;
            stringArray2[stringArray.length + 3] = this.userNameWinAttr;
        }
        try {
            NamingEnumeration namingEnumeration = (NamingEnumeration)Util.getEntryDetails(dirContext, string, "(objectclass=*)", 0, stringArray2, false);
            if (!namingEnumeration.hasMoreElements()) {
                throw new NoSuchUserException("User does not exist - DN = " + string);
            }
            SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
            String string2 = null;
            String string3 = string;
            NamingEnumeration namingEnumeration2 = null;
            try {
                string2 = (String)searchResult.getAttributes().get("orclguid").get(0);
            }
            catch (Exception exception) {
                namingEnumeration2 = (NamingEnumeration)Util.getEntryDetails(dirContext, string, "(objectclass=*)", 0, new String[]{"orclguid"}, false);
                SearchResult searchResult2 = (SearchResult)namingEnumeration2.nextElement();
                string2 = (String)searchResult2.getAttributes().get("orclguid").get(0);
            }
            return new User(dirContext, string3, string2, string3, this, searchResult);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("NamingException encountered when resolving user - DN = " + string, namingException);
        }
    }

    public ServiceReference[] getAllServiceReferences(DirContext dirContext) throws UtilException {
        return this.getAllServiceReferences(dirContext, new String[0]);
    }

    public ServiceReference[] getAllServiceReferences(DirContext dirContext, String[] stringArray) throws UtilException {
        try {
            this.resolve(dirContext);
            PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, "cn=Services,cn=OracleContext," + this.entryDN, "(objectclass=orclServiceInstanceReference)", 2, stringArray);
            ServiceReference[] serviceReferenceArray = new ServiceReference[propertySetCollection.size()];
            int n = 0;
            while (n < serviceReferenceArray.length) {
                PropertySet propertySet = propertySetCollection.getPropertySet(n);
                serviceReferenceArray[n] = new ServiceReference(dirContext, propertySet.getDN(), propertySet);
                ++n;
            }
            return serviceReferenceArray;
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException(namingException.toString());
        }
    }

    public User createUser(DirContext dirContext, ModPropertySet modPropertySet, boolean bl) throws UtilException {
        this.resolve(dirContext);
        this.getUserCreationInfo(dirContext);
        if (this.userCreateBase.length > 1) {
            throw new UtilException("multiple create user base");
        }
        return this.createUser(dirContext, this.userCreateBase[0], modPropertySet, bl);
    }

    public User createUser(DirContext dirContext, String string, ModPropertySet modPropertySet, boolean bl) throws UtilException {
        String string2;
        if (modPropertySet == null) {
            throw new ParameterException("Invalid Parameters");
        }
        this.resolve(dirContext);
        this.getUserCreationInfo(dirContext);
        if (bl) {
            this.userAttrCheck(modPropertySet);
        }
        boolean bl2 = false;
        if (string != null) {
            int n = 0;
            while (n < this.userCreateBase.length) {
                string2 = Util.normalizeDN(this.userCreateBase[n]);
                if (string2.equals(Util.normalizeDN(string))) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
        } else {
            if (this.userCreateBase.length > 1) {
                throw new UtilException("More than one user create base.  A create base must be specified");
            }
            string = this.userCreateBase[0];
            bl2 = true;
        }
        if (!bl2) {
            throw new UtilException("Invalid create user base");
        }
        LDIFRecord lDIFRecord = modPropertySet.getModProperty();
        string2 = lDIFRecord.getAttribute(this.userNamingAttr).getValue();
        String string3 = new String(this.userNamingAttr + "=" + string2 + "," + string);
        modPropertySet.addProperty(5, this.userObjCls);
        Util.ldapAdd(dirContext, string3, modPropertySet);
        User user = this.getUser(dirContext, Util.IDTYPE_DN, string3, null, new String[0]);
        String string4 = user.getGUID(dirContext);
        String string5 = new String("orclownerguid=" + string4 + ",cn=Extended Properties,cn=OracleContext," + this.entryDN);
        ModPropertySet modPropertySet2 = new ModPropertySet();
        String[] stringArray = new String[]{"top", "orclreferenceobject"};
        modPropertySet2.addProperty(0, "objectclass", stringArray);
        modPropertySet2.addProperty(0, "orclownerguid", string4);
        modPropertySet2.addProperty(0, "seealso", string3);
        Util.ldapAdd(dirContext, string5, modPropertySet2);
        string5 = "cn=Resource Access Descriptor," + string5;
        modPropertySet2 = new ModPropertySet();
        String[] stringArray2 = new String[]{"top", "orclcontainer", "orclauxiliaryguid"};
        modPropertySet2.addProperty(0, "objectclass", stringArray2);
        modPropertySet2.addProperty(0, "cn", "Resource Access Descriptor");
        modPropertySet2.addProperty(0, "orclownerguid", string4);
        Util.ldapAdd(dirContext, string5, modPropertySet2);
        return user;
    }

    private void userAttrCheck(ModPropertySet modPropertySet) throws UtilException {
        LDIFRecord lDIFRecord = modPropertySet.getModProperty();
        int n = 0;
        while (n < this.userMandatoryAttrPsc.size()) {
            String string;
            Property property;
            PropertySet propertySet = this.userMandatoryAttrPsc.getPropertySet(n);
            if (propertySet.size() != 0 && (property = propertySet.getProperty("orcldasismandatory")) != null && ((String)property.getValue(0)).equals("1") && !lDIFRecord.contains(string = Util.getAttrValueOfRDN(Util.getRDN(propertySet.getDN())))) {
                throw new UtilException("Mandatory Attribute missing for User Creation:  " + string);
            }
            ++n;
        }
        if (!lDIFRecord.contains(this.userNamingAttr)) {
            throw new UtilException("User Naming Attribute missing for User Creation:  " + this.userNamingAttr);
        }
        if (!lDIFRecord.contains(this.userNickNameAttr)) {
            throw new UtilException("User NickName Attribute missing for User Creation:  " + this.userNickNameAttr);
        }
    }

    private void getUserCreationInfo(DirContext dirContext) throws UtilException {
        String[] stringArray;
        if (this.userMandatoryAttrPsc == null) {
            stringArray = new String[]{"orcldasismandatory"};
            this.userMandatoryAttrPsc = Util.ldapSearch(dirContext, "cn=Attributes,cn=User Configuration,cn=Attribute Configuration, cn=DAS,cn=Products,cn=OracleContext," + this.entryDN, "(objectclass=*)", 1, stringArray);
        }
        if (this.userCreateBase == null) {
            Property property;
            stringArray = new String[]{"orclcommonusercreatebase", "orclcommonnamingattribute", "orcluserobjectclasses"};
            PropertySet propertySet = this.oracleContext.getCommonProperties(dirContext, stringArray).getPropertySet(0);
            if (this.oracleContext.getVersion(dirContext).compareTo("90230") > 0) {
                property = propertySet.getProperty("orclcommonusercreatebase");
                String[] stringArray2 = new String[property.size()];
                int n = 0;
                while (n < property.size()) {
                    stringArray2[n] = (String)property.getValue(n);
                    ++n;
                }
                this.userCreateBase = stringArray2;
                this.userNamingAttr = (String)propertySet.getProperty("orclcommonnamingattribute").getValue(0);
            } else {
                this.userCreateBase = this.userSearchBase;
                this.userNamingAttr = this.userNickNameAttr;
            }
            this.userObjCls = new LDIFAttribute("objectclass");
            property = propertySet.getProperty("orcluserobjectclasses");
            int n = 0;
            while (n < property.size()) {
                this.userObjCls.addValue((String)property.getValue(n));
                ++n;
            }
        }
    }

    public void deleteUser(DirContext dirContext, User user) throws UtilException {
        this.resolve(dirContext);
        String string = user.getGUID(dirContext);
        String string2 = "orclownerguid=" + string + ",cn=Extended Properties,cn=oracleContext," + this.entryDN;
        try {
            Util.bulkDelete(dirContext, string2, true);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("cannot remove extended prefs", namingException);
        }
        Group[] groupArray = user.getGroupMembership(dirContext, new String[0], false);
        Util.removeUniquemember(dirContext, groupArray, user.getDN(dirContext));
        Util.ldapDelete(dirContext, user.getDN(dirContext));
    }

    public Group getGroup(DirContext dirContext, int n, String string, String[] stringArray) throws UtilException {
        return this.getGroup(dirContext, n, string, null, stringArray);
    }

    public Group getGroup(DirContext dirContext, int n, String string, String string2, String[] stringArray) throws UtilException {
        this.resolve(dirContext);
        if (n == Util.IDTYPE_DN) {
            PropertySetCollection propertySetCollection = Util.dnExists(dirContext, string, stringArray);
            if (propertySetCollection != null) {
                Group group = new Group(dirContext, string, propertySetCollection.getPropertySet(0));
                return group;
            }
        } else if (n == Util.IDTYPE_GUID) {
            PropertySetCollection propertySetCollection = Util.ldapSearch(dirContext, "", "(orclGUID=" + string + ")", 2, stringArray);
            if (propertySetCollection != null) {
                Group group = new Group(dirContext, propertySetCollection.getPropertySet(0).getDN(), propertySetCollection.getPropertySet(0));
                return group;
            }
        } else if (n == Util.IDTYPE_SIMPLE) {
            PropertySetCollection propertySetCollection = Util.multiSearchBaseSearch(dirContext, null, this.groupSearchBase, "(cn=" + string + ")", stringArray, true);
            if (propertySetCollection != null) {
                Group group = new Group(dirContext, propertySetCollection.getPropertySet(0).getDN(), propertySetCollection.getPropertySet(0));
                return group;
            }
        } else {
            throw new ParameterException("Invalid groupIdType");
        }
        return null;
    }

    public Group[] getGroups(DirContext dirContext, int n, String string, String string2, String[] stringArray) throws UtilException {
        PropertySetCollection propertySetCollection = null;
        if (n == Util.IDTYPE_SIMPLE) {
            propertySetCollection = Util.multiSearchBaseSearch(dirContext, string2, this.groupSearchBase, "(cn=" + string + ")", stringArray, false);
        } else if (n == Util.IDTYPE_FILTER) {
            propertySetCollection = Util.multiSearchBaseSearch(dirContext, null, this.groupSearchBase, string, stringArray, false);
        } else {
            throw new ParameterException("Invalid groupIdType");
        }
        if (propertySetCollection != null) {
            int n2 = propertySetCollection.size();
            Group[] groupArray = new Group[n2];
            int n3 = 0;
            while (n3 < n2) {
                groupArray[n3] = new Group(dirContext, propertySetCollection.getPropertySet(n3).getDN(), propertySetCollection.getPropertySet(n3));
                ++n3;
            }
            return groupArray;
        }
        return null;
    }

    public String getPwdVerifierAttributeName(DirContext dirContext, int n) throws UtilException {
        if (n == Util.PWD_VERIFIERTYPE_COMMON) {
            return "orclpasswordverifier;orclcommongroupverifier";
        }
        throw new ParameterException("Invalid verifierType");
    }

    public String getPwdVerifierAttributeName(DirContext dirContext, String string) throws UtilException {
        PropertySetCollection propertySetCollection = Util.ldapSearch(dirContext, "cn=common,cn=products,cn=oraclecontext", "objectclass=orclcommonverifierprofile", 2, new String[]{"orclappid"});
        boolean bl = false;
        int n = 0;
        while (n < propertySetCollection.size()) {
            try {
                String string2 = (String)propertySetCollection.getPropertySet(n).getProperty("orclappid").getValue(0);
                if (string2.equalsIgnoreCase(string)) {
                    return "orclpasswordverifier;" + string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return null;
    }

    public void upgrade(DirContext dirContext, String string, PrintStream printStream) throws Exception {
        this.ohome = string;
        String string2 = "cn=OracleContext," + this.entryDN;
        OracleContext oracleContext = new OracleContext(dirContext, string, string2, printStream);
        oracleContext.upgrade(dirContext);
        String string3 = System.getProperty("file.separator");
        while (!this.isUpToDate(dirContext, printStream)) {
            String string4 = this.getVersion(dirContext);
            printStream.println("Realm curVersion: " + string4);
            String string5 = this.ohome + string3 + "ldap" + string3 + "schema" + string3 + "oid" + string3 + this.subCreateCommonFilePrefix + "UpgradeFrom" + string4 + ".lst";
            Vector vector = this.getSubstitutionVector();
            Util.ldapModify(dirContext, string5, vector, false, printStream);
        }
        UILabelsNLS.upgradeNLSLabels((DirContext)dirContext, (String)this.entryDN);
    }

    private Vector getSubstitutionVector() {
        Vector<String> vector = new Vector<String>(10);
        vector.insertElementAt("s_SubscriberParentDN", 0);
        vector.insertElementAt(Util.getParentDN(this.entryDN), 1);
        vector.insertElementAt("s_SubscriberDN", 2);
        vector.insertElementAt(this.entryDN, 3);
        vector.insertElementAt("s_RootOracleContextDN", 4);
        vector.insertElementAt("cn=OracleContext", 5);
        vector.insertElementAt("s_OracleContextDN", 6);
        vector.insertElementAt("cn=OracleContext," + this.entryDN, 7);
        vector.insertElementAt("s_OracleContextParentDN", 8);
        vector.insertElementAt(this.entryDN, 9);
        return vector;
    }

    public String getVersion(DirContext dirContext) throws UtilException {
        String string = null;
        PropertySetCollection propertySetCollection = this.getProperties(dirContext, new String[]{"orclversion"});
        try {
            string = (String)propertySetCollection.getPropertySet(0).getProperty("orclversion").getValue(0);
        }
        catch (NullPointerException nullPointerException) {
            if (!Util.dnExists(dirContext, "cn=Calendar Server," + this.entryDN)) {
                return "90100";
            }
            return "90110";
        }
        return string;
    }

    public boolean isUpToDate(DirContext dirContext, PrintStream printStream) {
        try {
            String string = System.getProperty("file.separator");
            String string2 = this.getVersion(dirContext);
            String string3 = this.ohome + string + "ldap" + string + "schema" + string + "versions.txt";
            printStream.println(string3);
            String string4 = Util.getParameterFromFile("RealmVersion", string3);
            printStream.println("Realm version: " + string2 + " up_version: " + string4);
            return string4.compareTo(string2) <= 0;
        }
        catch (Exception exception) {
            printStream.println(exception.toString());
            return true;
        }
    }

    public PropertySetCollection getProperties(DirContext dirContext, int n, String[] stringArray) throws UtilException {
        this.resolve(dirContext);
        switch (n) {
            case 3: {
                String[] stringArray2 = stringArray == null ? new String[]{USER_NAMING_ATTR_SIMPLE, USER_NAMING_ATTR_WINDOWS, USER_NAMING_ATTR_KERBEROS} : stringArray;
                PropertySetCollection propertySetCollection = this.oracleContext.getCommonProperties(dirContext, stringArray2);
                return propertySetCollection;
            }
            case 2: {
                return this.oracleContext.getCommonProperties(dirContext, stringArray);
            }
            case 0: {
                return this.getProperties(dirContext, stringArray);
            }
        }
        throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + n);
    }

    protected String[] getCommonAttrs(DirContext dirContext) throws UtilException {
        this.resolve(dirContext);
        String[] stringArray = new String[4 + this.userSearchBase.length];
        stringArray[0] = this.userNickNameAttr;
        stringArray[1] = this.userNamingAttr;
        stringArray[2] = this.userPrincipalAttr;
        stringArray[3] = this.userNameWinAttr;
        int n = 4;
        int n2 = 0;
        while (n2 < this.userSearchBase.length) {
            stringArray[n++] = this.userSearchBase[n2];
            ++n2;
        }
        return stringArray;
    }
}

