/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.jndi;

import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.SSLHandshakeException;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.discovery.DiscoveryHelper;
import oracle.ldap.util.jndi.ConnectionThread;

public class ConnectionUtil {
    private DirContext nonSSLctx = null;
    private String host = null;
    private String port = null;

    public static String discoverSSLPort(String string, String string2, String string3, String string4) throws NamingException {
        InitialLdapContext initialLdapContext = ConnectionUtil.getDefaultDirCtx(string, string2, string3, string4);
        String[] stringArray = new String[]{"orclsslport"};
        PropertySetCollection propertySetCollection = Util.getEntryDetails(initialLdapContext, "cn=configset0, cn=osdldapd, cn=subconfigsubentry", "(objectclass=*)", 0, stringArray);
        String string5 = (String)propertySetCollection.getPropertySet(0).getProperty(0).getValue(0);
        initialLdapContext.close();
        return string5;
    }

    public static InitialLdapContext getDefaultDirCtx(String string, String string2, String string3, String string4, long l) throws NamingException {
        Hashtable hashtable = ConnectionUtil.createCtxHash(string, string2, string3, string4);
        return ConnectionUtil.returnInitialLdapContext(hashtable, null, l);
    }

    public static InitialLdapContext getDefaultDirCtx(String string, String string2, String string3, String string4) throws NamingException {
        return ConnectionUtil.getDefaultDirCtx(string, string2, string3, string4, 10000L);
    }

    public static InitialLdapContext getDefaultDirCtx(DiscoveryHelper discoveryHelper, String string, String string2) throws NamingException {
        InitialLdapContext initialLdapContext = null;
        HashMap hashMap = new HashMap();
        ArrayList arrayList = null;
        int n = 0;
        switch (discoveryHelper.discoveryType) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new NoInitialContextException();
            }
        }
        String string3 = discoveryHelper.getProperty("3");
        if (string3 != null && !"0".equals(string3)) {
            throw new NoInitialContextException();
        }
        if (discoveryHelper.discover(hashMap) == 0) {
            arrayList = (ArrayList)hashMap.get(DiscoveryHelper.DIR_SERVERS);
            if (arrayList == null) {
                throw new NoInitialContextException();
            }
            n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                String string4 = (String)arrayList.get(n2);
                int n3 = string4.indexOf(58);
                if (n3 != -1) {
                    String string5 = string4.substring(0, n3);
                    String string6 = string4.substring(n3 + 1);
                    Hashtable hashtable = ConnectionUtil.createCtxHash(string5, string6, string, string2);
                    try {
                        initialLdapContext = new InitialLdapContext(hashtable, null);
                        break;
                    }
                    catch (CommunicationException communicationException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        if (initialLdapContext == null) {
            throw new NoInitialContextException();
        }
        return initialLdapContext;
    }

    public static InitialLdapContext getSSLDirCtx(String string, String string2, String string3, String string4) throws NamingException {
        return ConnectionUtil.getSSLDirCtx(string, string2, string3, string4, "oracle.ldap.util.jndi.LDAPSSLSocketFactoryImpl");
    }

    public static InitialLdapContext getSSLDirCtx(String string, String string2, String string3, String string4, String string5) throws NamingException {
        Hashtable hashtable = ConnectionUtil.createCtxHash(string, string2, string3, string4);
        hashtable.put("java.naming.ldap.factory.socket", string5);
        hashtable.put("java.naming.security.protocol", "ssl");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        int n = 0;
        while (true) {
            ++n;
            try {
                return new InitialLdapContext(hashtable, null);
            }
            catch (NamingException namingException) {
                Throwable throwable;
                System.out.println("Retry count " + n + " at " + new Date(System.currentTimeMillis()).toString());
                if ((throwable = namingException.getRootCause()) instanceof SSLHandshakeException && n <= 2) continue;
                throw namingException;
            }
            break;
        }
    }

    public static InitialLdapContext getSSLDirCtx(DiscoveryHelper discoveryHelper, String string, String string2) throws NamingException {
        InitialLdapContext initialLdapContext = null;
        HashMap hashMap = new HashMap();
        ArrayList arrayList = null;
        int n = 0;
        switch (discoveryHelper.discoveryType) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new NoInitialContextException();
            }
        }
        String string3 = discoveryHelper.getProperty("3");
        if (!"1".equals(string3)) {
            throw new NoInitialContextException();
        }
        if (discoveryHelper.discover(hashMap) == 0) {
            arrayList = (ArrayList)hashMap.get(DiscoveryHelper.DIR_SERVERS);
            if (arrayList == null) {
                throw new NoInitialContextException();
            }
            n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                String string4 = (String)arrayList.get(n2);
                int n3 = string4.indexOf(58);
                if (n3 != -1) {
                    String string5 = string4.substring(0, n3);
                    String string6 = string4.substring(n3 + 1);
                    Hashtable hashtable = ConnectionUtil.createCtxHash(string5, string6, string, string2);
                    Properties properties = System.getProperties();
                    properties.put("SSLSocketFactoryImplClass", "oracle.ldap.util.jndi.LDAPSSLSocketFactoryImpl");
                    Security.setProperty("ssl.SocketFactory.provider", "oracle.ldap.util.jndi.LDAPSSLSocketFactoryImpl");
                    hashtable.put("java.naming.ldap.factory.socket", "oracle.ldap.util.jndi.LDAPSSLSocketFactoryImpl");
                    hashtable.put("java.naming.security.protocol", "ssl");
                    try {
                        initialLdapContext = new InitialLdapContext(hashtable, null);
                        break;
                    }
                    catch (CommunicationException communicationException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        if (initialLdapContext == null) {
            throw new NoInitialContextException();
        }
        return initialLdapContext;
    }

    private static Hashtable createCtxHash(String string, String string2, String string3, String string4) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<Object> enumeration = System.getProperties().keys();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            if (!string5.startsWith("java.naming.") || System.getProperty(string5).equals("com.evermind.server.ApplicationInitialContextFactory")) continue;
            hashtable.put(string5, System.getProperty(string5));
        }
        if (hashtable.get("java.naming.factory.initial") == null) {
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        hashtable.put("java.naming.provider.url", "ldap://" + string + ":" + string2 + "/");
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", string3);
        hashtable.put("java.naming.security.credentials", string4);
        return hashtable;
    }

    private static InitialLdapContext returnInitialLdapContext(Hashtable hashtable, Control[] controlArray, long l) throws NamingException {
        ConnectionThread connectionThread = new ConnectionThread(hashtable, controlArray);
        connectionThread.start();
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        while (connectionThread.isAlive()) {
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            if (l4 <= l) continue;
            bl = true;
            break;
        }
        InitialLdapContext initialLdapContext = connectionThread.returnCtx();
        if (bl) {
            connectionThread.stop();
            throw new CommunicationException("returnInitialLdapContext() times out after " + l + " ms - JNDI initialization method not returning");
        }
        if (initialLdapContext == null) {
            throw connectionThread.returnNamingException();
        }
        return initialLdapContext;
    }
}

