/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.param;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.nls.NlsMsg;
import oracle.ldap.util.param.FlagParameterDescriptor;
import oracle.ldap.util.param.Parameter;
import oracle.ldap.util.param.ParameterDescriptor;
import oracle.ldap.util.param.ParameterParser;

public class CmdArgParser
extends ParameterParser {
    private String[] mArgs = null;
    private int mArgsStartIndex = 0;
    private boolean mOnlyFlags = false;

    public CmdArgParser(ParameterDescriptor[] parameterDescriptorArray, String[] stringArray) {
        super(parameterDescriptorArray);
        if (null == stringArray) {
            throw new IllegalArgumentException("args parameter cannot be NULL");
        }
        this.mArgs = stringArray;
    }

    public CmdArgParser(ParameterDescriptor[] parameterDescriptorArray, String[] stringArray, boolean bl) {
        this(parameterDescriptorArray, stringArray);
        this.mAllowUndescribedParam = bl;
    }

    public CmdArgParser(FlagParameterDescriptor[] flagParameterDescriptorArray, String[] stringArray) {
        super(flagParameterDescriptorArray);
        if (null == stringArray) {
            throw new IllegalArgumentException("args parameter cannot be NULL");
        }
        this.mArgs = stringArray;
        this.mOnlyFlags = true;
    }

    public void parse() throws ParameterException {
        if (this.mArgs.length != 0) {
            if (this.mOnlyFlags) {
                this.parseParamValues();
            } else {
                this.parseNameValuePairs();
            }
        }
    }

    public void setStartIndex(int n) {
        if (n < 0 || n >= this.mArgs.length) {
            throw new IllegalArgumentException();
        }
        this.mArgsStartIndex = n;
    }

    private void parseParamValues() throws ParameterException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        String string2 = null;
        int n = -1;
        this.mParsedParamHT = new Hashtable();
        this.mUnParsedParamVector = new Vector();
        int n2 = this.mArgsStartIndex;
        while (n2 < this.mArgs.length) {
            String string3 = this.mArgs[n2];
            int n3 = -1;
            if (string3.startsWith("-") || bl3) {
                if (string == null) {
                    string = string3.substring(1);
                    if (string.equals("")) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_NAME_NOT_SPECIFIED"));
                    }
                    bl3 = true;
                    n3 = string.indexOf(this.mParamNameValueDelim);
                    if (n3 != -1) {
                        if (0 == n3) {
                            throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_NAME_NOT_SPECIFIED"));
                        }
                        bl = true;
                        if (n3 < string.length() - 1) {
                            string2 = string.substring(n3 + 1);
                            bl2 = true;
                        }
                        string = string.substring(0, n3);
                    }
                    if ((n = this.getParameterDescriptorIndex(string, true)) == -1) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_UNKNOWN_FLAG", string));
                    }
                    if (!((FlagParameterDescriptor)this.mParamDes[n]).isValueRequired()) {
                        if (bl) {
                            throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_TAKES_NO_ARGUMENT", string));
                        }
                        bl2 = true;
                    }
                } else if (bl) {
                    string2 = string3;
                    bl2 = true;
                } else if (string3.startsWith(this.mParamNameValueDelim)) {
                    bl = true;
                    if (string3.length() > 1) {
                        string2 = string3.substring(1);
                        bl2 = true;
                    }
                } else {
                    string2 = string3;
                    bl2 = true;
                }
                if (bl2) {
                    if (this.mParsedParamHT.containsKey(string)) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_DUPLICATE", string));
                    }
                    if (((FlagParameterDescriptor)this.mParamDes[n]).isValueRequired() && !this.mParamDes[n].isValueValid(string2)) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_INVALID_ARGUMENT_VALUE", new String[]{string, string2}));
                    }
                    this.mParsedParamHT.put(this.mParamDes[n].getName(), new Parameter(this.mParamDes[n].getName(), string2, bl3));
                    n = -1;
                    string = null;
                    string2 = null;
                    bl2 = false;
                    bl3 = false;
                    bl = false;
                }
            } else {
                this.mUnParsedParamVector.add(string3);
            }
            ++n2;
        }
        if (string != null && string2 == null) {
            throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_VALUE_NOT_SPECIFIED"));
        }
        this.validateAndAddDefaultParams();
    }

    private void parseNameValuePairs() throws ParameterException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        String string2 = null;
        int n = -1;
        this.mParsedParamHT = new Hashtable();
        if (this.mAllowUndescribedParam) {
            this.mUnParsedParamVector = new Vector();
        }
        int n2 = this.mArgsStartIndex;
        while (n2 < this.mArgs.length) {
            int n3 = -1;
            String string3 = this.mArgs[n2];
            if (string == null) {
                string = string3;
                n3 = string3.indexOf(this.mParamNameValueDelim);
                if (n3 != -1) {
                    if (0 == n3) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_NAME_NOT_SPECIFIED"));
                    }
                    bl = true;
                    string = string3.substring(0, n3).trim();
                    if (n3 < string3.length() - 1) {
                        string2 = string3.substring(n3 + 1);
                        bl2 = true;
                    }
                }
            } else if (bl) {
                string2 = string3;
                bl2 = true;
            } else if (string3.startsWith(this.mParamNameValueDelim)) {
                bl = true;
                if (string3.length() > 1) {
                    string2 = string3.substring(1);
                    bl2 = true;
                }
            } else if (bl3) {
                string2 = string3;
                bl2 = true;
            } else {
                throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_VALUE_NOT_SPECIFIED"));
            }
            if (string.startsWith("-") && !bl3) {
                if ((string = string.substring(1)).equals("")) {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_NAME_NOT_SPECIFIED"));
                }
                n = this.getParameterDescriptorIndex(string, true);
                if (n == -1) {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_UNKNOWN_FLAG", string));
                }
                bl3 = true;
                if (((FlagParameterDescriptor)this.mParamDes[n]).isValueRequired()) {
                    if (null != string2) {
                        bl2 = true;
                    }
                } else {
                    if (bl) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_TAKES_NO_ARGUMENT", string));
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                if (!bl3) {
                    n = this.getParameterDescriptorIndex(string, true);
                    n = n != -1 ? -1 : this.getParameterDescriptorIndex(string, false);
                }
                if (-1 == n) {
                    if (!this.mAllowUndescribedParam) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_UNKNOWN", string));
                    }
                    if (this.mUnParsedParamVector.contains(string)) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_DUPLICATE", string));
                    }
                    this.mUnParsedParamVector.add(string);
                    this.mUnParsedParamVector.add(string2);
                } else {
                    if (!this.mParamDes[n].isValueValid(string2)) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_INVALID_ARGUMENT_VALUE", new String[]{string, string2}));
                    }
                    if (this.mParsedParamHT.containsKey(string)) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_DUPLICATE", string));
                    }
                    this.mParsedParamHT.put(this.mParamDes[n].getName(), new Parameter(this.mParamDes[n].getName(), string2, bl3));
                }
                string2 = null;
                string = null;
                bl3 = false;
                bl2 = false;
                bl = false;
                n = -1;
            }
            ++n2;
        }
        if (null != string) {
            throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_VALUE_NOT_SPECIFIED"));
        }
        this.validateAndAddDefaultParams();
    }

    private static void test1(String[] stringArray) throws ParameterException {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor("input_file", false, null, null), new ParameterDescriptor("output_file", false, null, null), new FlagParameterDescriptor("lookup", false, null), new FlagParameterDescriptor("load", false, null), new FlagParameterDescriptor("reconcile", true, new String[]{"NEW_ADD", "REPLACE_OLD"}), new ParameterDescriptor("host", true, null, null), new ParameterDescriptor("port", false, null, "389")};
        CmdArgParser cmdArgParser = new CmdArgParser(parameterDescriptorArray, stringArray, true);
        parameterDescriptorArray[5].setCaseSensitivity(true);
        ((ParameterParser)cmdArgParser).parse();
        Hashtable hashtable = cmdArgParser.getParsedParams();
        Vector vector = cmdArgParser.getUnParsedParams();
        System.out.println("++++++ PARSED PARAMS  ++++++");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Parameter parameter = (Parameter)hashtable.get(enumeration.nextElement());
            System.out.println(parameter);
        }
        System.out.println("++++++ UNPARSED PARAMS  ++++++");
        int n = 0;
        while (n < vector.size()) {
            System.out.println("[ " + vector.elementAt(n) + " ] [ " + vector.elementAt(n + 1) + " ]");
            n += 2;
        }
    }

    private static void test2(String[] stringArray) throws ParameterException {
        FlagParameterDescriptor[] flagParameterDescriptorArray = new FlagParameterDescriptor[]{new FlagParameterDescriptor("lookup", false, null), new FlagParameterDescriptor("load", false, null), new FlagParameterDescriptor("reconcile", true, true, new String[]{"NEW_ADD", "REPLACE_OLD"})};
        CmdArgParser cmdArgParser = new CmdArgParser(flagParameterDescriptorArray, stringArray);
        ((ParameterParser)cmdArgParser).parse();
        Hashtable hashtable = cmdArgParser.getParsedParams();
        Vector vector = cmdArgParser.getUnParsedParams();
        System.out.println("++++++ PARSED PARAMS  ++++++");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Parameter parameter = (Parameter)hashtable.get(enumeration.nextElement());
            System.out.println(parameter);
        }
        System.out.println("++++++ UNPARSED PARAMS  ++++++");
        int n = 0;
        while (n < vector.size()) {
            System.out.println("[ " + vector.elementAt(n) + " ]");
            ++n;
        }
    }
}

