/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.param;

public class ParameterDescriptor {
    protected String mName = null;
    protected String[] mPossibleValues = null;
    protected boolean mMandatory = false;
    protected boolean mIgnoreCase = true;
    private String mDefaultValue = null;

    protected ParameterDescriptor() {
    }

    public ParameterDescriptor(String string, boolean bl, String[] stringArray, String string2) {
        if (null == string) {
            throw new IllegalArgumentException("Name of the parameter cannot be NULL");
        }
        this.mName = string;
        this.mMandatory = bl;
        this.mPossibleValues = stringArray;
        this.mDefaultValue = string2;
    }

    public boolean isValueValid(String string) {
        if (null == this.mPossibleValues) {
            return true;
        }
        int n = 0;
        while (n < this.mPossibleValues.length) {
            if (this.mPossibleValues[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isManadatory() {
        return this.mMandatory;
    }

    public String getName() {
        return this.mName;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    public void setCaseSensitivity(boolean bl) {
        this.mIgnoreCase = !bl;
    }

    public boolean equals(String string) {
        return this.mIgnoreCase ? this.mName.equalsIgnoreCase(string) : this.mName.equals(string);
    }
}

