/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.directory.DirContext;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ParamDefn;
import oracle.ldap.util.provisioning.ProvisioningProfile;

public class ProvisioningCmdArgs {
    public static Vector mParamDefns = new Vector();
    private Hashtable vars;
    private int operation_type = 0;
    public static final int OPTYPE_CREATE = 1;
    public static final String OP_CREATE = "CREATE";
    public static final int OPTYPE_DISABLE = 2;
    public static final String OP_DISABLE = "DISABLE";
    public static final int OPTYPE_ENABLE = 3;
    public static final String OP_ENABLE = "ENABLE";
    public static final int OPTYPE_STATUS = 4;
    public static final String OP_STATUS = "STATUS";
    public static final int OPTYPE_DELETE = 5;
    public static final String OP_DELETE = "DELETE";
    public static final int OPTYPE_RESET = 6;
    public static final String OP_RESET = "RESET";
    public static final int OPTYPE_MODIFY = 7;
    public static final String OP_MODIFY = "MODIFY";
    public static final String INPUT_FILE = "INPUT_FILE";
    public static final String OUTPUT_FILE = "OUTPUT_FILE";
    public static final String OPERATION = "OPERATION";
    public static final String LDAP_HOST = "LDAP_HOST";
    public static final String LDAP_PORT = "LDAP_PORT";
    public static final String LDAP_USER_DN = "LDAP_USER_DN";
    public static final String LDAP_USER_PASSWORD = "LDAP_USER_PASSWORD";
    public static final String PROFILE_VERSION = "PROFILE_VERSION";
    public static final String PROFILE_STATUS = "PROFILE_STATUS";
    public static final String PROFILE_MODE = "PROFILE_MODE";
    public static final String SCHEDULE = "SCHEDULE";
    public static final String MAX_RETRIES = "MAX_RETRIES";
    public static final String MAX_EVENTS_PER_INVOCATION = "MAX_EVENTS_PER_INVOCATION";
    public static final String MAX_EVENTS_PER_SCHEDULE = "MAX_EVENTS_PER_SCHEDULE";
    public static final String PROFILE_GROUP = "PROFILE_GROUP";
    public static final String PROFILE_DEBUG = "PROFILE_DEBUG";
    public static final String CRYPT_KEY = "CRYPT_KEY";
    public static final String PROFILE_MAX_ERRORS = "PROFILE_MAX_ERRORS";
    public static final String APPLICATION_DN = "APPLICATION_DN";
    public static final String ORGANIZATION_DN = "ORGANIZATION_DN";
    public static final String ORGANIZATION_NAME = "ORGANIZATION_NAME";
    public static final String INTERFACE_NAME = "INTERFACE_NAME";
    public static final String INTERFACE_TYPE = "INTERFACE_TYPE";
    public static final String INTERFACE_CONNECT_INFO = "INTERFACE_CONNECT_INFO";
    public static final String INTERFACE_VERSION = "INTERFACE_VERSION";
    public static final String INTERFACE_ADDITIONAL_INFO = "INTERFACE_ADDITIONAL_INFO";
    public static final String EVENT_SUBSCRIPTION = "EVENT_SUBSCRIPTION";
    public static final String EVENT_MAPPING_RULES = "EVENT_MAPPING_RULES";
    public static final String EVENT_PERMITTED_OPERATIONS = "EVENT_PERMITTED_OPERATIONS";
    public static final String LASTCHANGENUMBER = "LASTCHANGENUMBER";
    public static final String SSL_MODE = "SSL_MODE";
    private static final char PARAM_NAME_VALUE_DELIM = '=';
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    private static String NEW_LINE = " \r\n";
    public static String ERROR_PREFIX = "ERROR: ";
    public static int debug = 0;

    public ProvisioningCmdArgs(String[] stringArray) throws InvalidParameterException {
        ProvisioningCmdArgs.initializeParamDefns();
        this.vars = new Hashtable(300);
        this.setDefaultValues();
        this.parseInputParameters(stringArray, '=');
    }

    public int getOperation() {
        return this.operation_type;
    }

    public String toString() {
        return this.vars.toString();
    }

    public void put(String string, String string2) {
        this.vars.put(string, string2);
    }

    public void putVector(String string, Vector vector) {
        this.vars.put(string, vector);
    }

    public String get(String string) {
        Object v = this.vars.get(string);
        return v == null ? null : v.toString();
    }

    public Vector getVector(String string) {
        Object v = this.vars.get(string);
        return v == null ? null : (Vector)v;
    }

    private void setDefaultValues() {
        this.put(INTERFACE_VERSION, "2.0");
        this.put(PROFILE_MODE, "OUTBOUND");
    }

    void computeDefaultValues(DirContext dirContext) throws Exception {
        try {
            String string = this.get(ORGANIZATION_DN);
            String string2 = this.get(ORGANIZATION_NAME);
            if (string == null && string2 == null) {
                ProvisioningCmdArgs.LOG("Locating the Default Subscriber");
                RootOracleContext rootOracleContext = new RootOracleContext(dirContext);
                Subscriber subscriber = rootOracleContext.getSubscriber(dirContext, Util.IDTYPE_DEFAULT, null, null);
                String string3 = subscriber.getDn(dirContext);
                this.put(ORGANIZATION_DN, string3);
                ProvisioningCmdArgs.LOG("Organization DN now is : " + this.get(ORGANIZATION_DN));
            } else if (string2 != null && string == null) {
                ProvisioningCmdArgs.LOG("Organization Simple Name specified is : " + string2);
                RootOracleContext rootOracleContext = new RootOracleContext(dirContext);
                Subscriber subscriber = rootOracleContext.getSubscriber(dirContext, Util.IDTYPE_SIMPLE, string2, null);
                String string4 = subscriber.getDn(dirContext);
                this.put(ORGANIZATION_DN, string4);
                ProvisioningCmdArgs.LOG("Organization DN now is : " + this.get(ORGANIZATION_DN));
            } else if (string2 == null && string != null) {
                this.put(ORGANIZATION_DN, string);
            } else if (string2 != null && string != null) {
                this.put(ORGANIZATION_DN, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidParameterException("Unable to resolve Organization : " + exception.toString());
        }
    }

    private void parseInputParameters(String[] stringArray, char c) throws InvalidParameterException {
        int n = stringArray.length;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        String string = null;
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = stringArray[n3].indexOf(61);
            if (n2 == -1) {
                throw new InvalidParameterException(resBundle.getString("PARAMETER_VALUE_NOT_SPECIFIED"));
            }
            string = stringArray[n3].substring(0, n2).trim();
            if (string.equals("")) {
                throw new InvalidParameterException(resBundle.getString("PARAMETER_NAME_NOT_SPECIFIED"));
            }
            string2 = stringArray[n3].substring(n2 + 1).trim();
            if (string2.equals("")) {
                throw new InvalidParameterException(resBundle.getString("PARAMETER_VALUE_NOT_SPECIFIED"));
            }
            if (string.equalsIgnoreCase(OPERATION)) {
                this.put(OPERATION, string2);
                if (string2.equalsIgnoreCase(OP_CREATE)) {
                    this.operation_type = 1;
                } else if (string2.equalsIgnoreCase(OP_DISABLE)) {
                    this.operation_type = 2;
                } else if (string2.equalsIgnoreCase(OP_ENABLE)) {
                    this.operation_type = 3;
                } else if (string2.equalsIgnoreCase(OP_STATUS)) {
                    this.operation_type = 4;
                } else if (string2.equalsIgnoreCase(OP_DELETE)) {
                    this.operation_type = 5;
                } else if (string2.equalsIgnoreCase(OP_RESET)) {
                    this.operation_type = 6;
                } else if (string2.equalsIgnoreCase(OP_MODIFY)) {
                    this.operation_type = 7;
                }
            } else if (string.equalsIgnoreCase(LDAP_HOST)) {
                this.put(LDAP_HOST, string2);
            } else if (string.equalsIgnoreCase(LDAP_PORT)) {
                this.put(LDAP_PORT, string2);
            } else if (string.equalsIgnoreCase(SSL_MODE)) {
                this.put(SSL_MODE, string2);
            } else if (string.equalsIgnoreCase(LDAP_USER_DN)) {
                this.put(LDAP_USER_DN, string2);
            } else if (string.equalsIgnoreCase(LDAP_USER_PASSWORD)) {
                this.put(LDAP_USER_PASSWORD, string2);
            } else if (string.equalsIgnoreCase(PROFILE_MODE)) {
                this.put(PROFILE_MODE, string2);
            } else if (string.equalsIgnoreCase(PROFILE_STATUS)) {
                this.put(PROFILE_STATUS, string2);
            } else if (string.equalsIgnoreCase(APPLICATION_DN)) {
                this.put(APPLICATION_DN, string2);
            } else if (string.equalsIgnoreCase(ORGANIZATION_DN)) {
                this.put(ORGANIZATION_DN, string2);
            } else if (string.equalsIgnoreCase(ORGANIZATION_NAME)) {
                this.put(ORGANIZATION_NAME, string2);
            } else if (string.equalsIgnoreCase(INTERFACE_NAME)) {
                this.put(INTERFACE_NAME, string2);
            } else if (string.equalsIgnoreCase(INTERFACE_TYPE)) {
                this.put(INTERFACE_TYPE, string2);
            } else if (string.equalsIgnoreCase(INTERFACE_CONNECT_INFO)) {
                this.put(INTERFACE_CONNECT_INFO, string2);
            } else if (string.equalsIgnoreCase(INTERFACE_VERSION)) {
                this.put(INTERFACE_VERSION, string2);
            } else if (string.equalsIgnoreCase(INTERFACE_ADDITIONAL_INFO)) {
                vector4.addElement(string2);
            } else if (string.equalsIgnoreCase(SCHEDULE)) {
                this.put(SCHEDULE, string2);
            } else if (string.equalsIgnoreCase(MAX_RETRIES)) {
                this.put(MAX_RETRIES, string2);
            } else if (string.equalsIgnoreCase(MAX_EVENTS_PER_INVOCATION)) {
                this.put(MAX_EVENTS_PER_INVOCATION, string2);
            } else if (string.equalsIgnoreCase(MAX_EVENTS_PER_SCHEDULE)) {
                this.put(MAX_EVENTS_PER_SCHEDULE, string2);
            } else if (string.equalsIgnoreCase(PROFILE_GROUP)) {
                this.put(PROFILE_GROUP, string2);
            } else if (string.equalsIgnoreCase(PROFILE_DEBUG)) {
                this.put(PROFILE_DEBUG, string2);
            } else if (string.equalsIgnoreCase(CRYPT_KEY)) {
                this.put(CRYPT_KEY, string2);
            } else if (string.equalsIgnoreCase(PROFILE_MAX_ERRORS)) {
                this.put(PROFILE_MAX_ERRORS, string2);
            } else if (string.equalsIgnoreCase(LASTCHANGENUMBER)) {
                this.put(LASTCHANGENUMBER, string2);
            } else if (string.equalsIgnoreCase("DEBUG")) {
                debug = Integer.parseInt(string2);
            } else if (string.equalsIgnoreCase(EVENT_SUBSCRIPTION)) {
                vector.addElement(string2);
            } else if (string.equalsIgnoreCase(EVENT_MAPPING_RULES)) {
                vector2.addElement(string2);
            } else if (string.equalsIgnoreCase(EVENT_PERMITTED_OPERATIONS)) {
                vector3.addElement(string2);
            }
            ++n3;
        }
        if (vector4.size() > 0) {
            this.putVector(INTERFACE_ADDITIONAL_INFO, vector4);
        }
        if (vector.size() > 0) {
            this.putVector(EVENT_SUBSCRIPTION, vector);
        }
        if (vector2.size() > 0) {
            this.putVector(EVENT_MAPPING_RULES, vector2);
        }
        if (vector3.size() > 0) {
            this.putVector(EVENT_PERMITTED_OPERATIONS, vector3);
        }
    }

    public static void initializeParamDefns() {
        ParamDefn paramDefn = null;
        paramDefn = new ParamDefn("1.0", null, OPERATION, true, OP_CREATE);
        paramDefn.setValidValues(new String[]{OP_CREATE, OP_DISABLE, OP_ENABLE, OP_STATUS, OP_DELETE, OP_RESET, OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, LDAP_HOST, false, "localhost");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, LDAP_PORT, false, "389");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, SSL_MODE, false, "0");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, LDAP_USER_DN, false, "cn=orcladmin");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, LDAP_USER_PASSWORD, false, "welcome");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, PROFILE_STATUS, false, "ENABLED");
        paramDefn.setValidValues(new String[]{"ENABLED", "DISABLED"});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, PROFILE_MODE, false, "OUTBOUND");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, SCHEDULE, false, "3600");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, MAX_RETRIES, false, "5");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, APPLICATION_DN, true, null);
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, ORGANIZATION_DN, false, null);
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, ORGANIZATION_NAME, false, null);
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, INTERFACE_NAME, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, INTERFACE_TYPE, false, "PLSQL");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, INTERFACE_CONNECT_INFO, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, INTERFACE_ADDITIONAL_INFO, false, null);
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, INTERFACE_VERSION, false, "1.1");
        paramDefn.setValidValues(new String[]{"1.0", "1.1"});
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, PROFILE_GROUP, false, "0");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, PROFILE_DEBUG, false, "0");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, EVENT_SUBSCRIPTION, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("1.0", null, LASTCHANGENUMBER, false, null);
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, OPERATION, true, OP_CREATE);
        paramDefn.setValidValues(new String[]{OP_CREATE, OP_DISABLE, OP_ENABLE, OP_STATUS, OP_DELETE, OP_RESET, OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, LDAP_HOST, false, "localhost");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, LDAP_PORT, false, "389");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, SSL_MODE, false, "0");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, LDAP_USER_DN, false, "cn=orcladmin");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, LDAP_USER_PASSWORD, false, "welcome");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, PROFILE_STATUS, false, "ENABLED");
        paramDefn.setValidValues(new String[]{"ENABLED", "DISABLED"});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, PROFILE_MODE, false, "OUTBOUND");
        paramDefn.setValidValues(new String[]{"BOTH", "INBOUND", "OUTBOUND"});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, SCHEDULE, false, "3600");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, MAX_RETRIES, false, "5");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, APPLICATION_DN, true, null);
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, ORGANIZATION_DN, false, null);
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, ORGANIZATION_NAME, false, null);
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, INTERFACE_NAME, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, INTERFACE_TYPE, false, "PLSQL");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, INTERFACE_CONNECT_INFO, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, INTERFACE_ADDITIONAL_INFO, false, null);
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, INTERFACE_VERSION, false, "2.0");
        paramDefn.setValidValues(new String[]{"2.0", "2.1"});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, MAX_EVENTS_PER_INVOCATION, false, "1");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, MAX_EVENTS_PER_SCHEDULE, false, "100");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, PROFILE_GROUP, false, "0");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, PROFILE_DEBUG, false, "0");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, CRYPT_KEY, false, "ABCDEFGH");
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", null, PROFILE_MAX_ERRORS, false, "50");
        paramDefn.setNotDefaultinOperations(new String[]{OP_MODIFY});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", "OUTBOUND", EVENT_SUBSCRIPTION, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", "BOTH", EVENT_SUBSCRIPTION, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", "OUTBOUND", LASTCHANGENUMBER, false, null);
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", "BOTH", LASTCHANGENUMBER, false, null);
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", "INBOUND", EVENT_MAPPING_RULES, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", "BOTH", EVENT_MAPPING_RULES, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", "INBOUND", EVENT_PERMITTED_OPERATIONS, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
        paramDefn = new ParamDefn("2.0", "BOTH", EVENT_PERMITTED_OPERATIONS, false, null);
        paramDefn.setRequiredOprns(new String[]{OP_CREATE});
        mParamDefns.addElement(paramDefn);
    }

    public void validateCmdArgs() throws InvalidParameterException {
        String string;
        Object object;
        boolean bl = false;
        ProvisioningCmdArgs.LOG("Validating Arguments");
        String string2 = (String)this.vars.get(INTERFACE_VERSION);
        if (!(string2.equals("1.0") || string2.equals("1.1") || string2.equals("2.0") || string2.equals("2.1") || string2.equals("1.0"))) {
            throw new InvalidParameterException(resBundle.getString("PROV_UNSUPPORTED_VERSION") + " - " + string2);
        }
        String string3 = null;
        if (string2.equals("1.0") || string2.equals("1.1")) {
            string3 = "1.0";
        }
        if (string2.equals("2.0") || string2.equals("2.1")) {
            string3 = "2.0";
        }
        String string4 = (String)this.vars.get(PROFILE_MODE);
        String string5 = (String)this.vars.get(OPERATION);
        if (string5 == null) {
            ProvisioningCmdArgs.usage();
            throw new InvalidParameterException(resBundle.getString("PROV_MAND_ARG_MISSING") + " - " + OPERATION);
        }
        ProvisioningCmdArgs.LOG("Checking For UnSupported Arguments");
        Enumeration enumeration = this.vars.keys();
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            ProvisioningCmdArgs.LOG("Checking Parameter : " + string6);
            bl = false;
            int n = 0;
            while (n < mParamDefns.size()) {
                object = (ParamDefn)mParamDefns.elementAt(n);
                string = ((ParamDefn)object).getParamName();
                ProvisioningCmdArgs.LOG("Found Param Defn : " + string);
                if (string.equalsIgnoreCase(string6)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            ProvisioningCmdArgs.usage();
            throw new InvalidParameterException(resBundle.getString("PROV_UNSUPPORTED_ARG") + " - " + string6);
        }
        this.put(PROFILE_VERSION, string3);
        ProvisioningCmdArgs.LOG("Checking Against Parameter Definitions");
        int n = 0;
        while (n < mParamDefns.size()) {
            ParamDefn paramDefn = (ParamDefn)mParamDefns.elementAt(n);
            object = paramDefn.getParamName();
            string = paramDefn.getProfileVersion();
            if (string == null || string.equals(string3)) {
                int n2;
                String[] stringArray;
                ProvisioningCmdArgs.LOG("Validating Argument : " + (String)object);
                ProvisioningCmdArgs.LOG("Argument Version : " + string);
                Object object2 = this.vars.get(object);
                String string7 = null;
                if (object2 == null && (string7 = paramDefn.getParamDefValue()) != null) {
                    object2 = string7;
                    stringArray = paramDefn.getNotDefaultinOperations();
                    boolean bl2 = true;
                    if (stringArray != null) {
                        n2 = 0;
                        while (n2 < stringArray.length) {
                            if (string5.equalsIgnoreCase(stringArray[n2])) {
                                bl2 = false;
                                ProvisioningCmdArgs.LOG("Cannot Default For this Operation: " + string5);
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (bl2) {
                        this.put((String)object, (String)object2);
                    }
                }
                if (object2 != null) {
                    if (object2 instanceof String) {
                        ProvisioningCmdArgs.LOG("Argument Value: " + (String)object2);
                    } else {
                        ProvisioningCmdArgs.LOG("Argument Value: " + (Vector)object2);
                    }
                }
                if ((stringArray = paramDefn.getProfileMode()) == null || stringArray.equalsIgnoreCase(string4)) {
                    String[] stringArray2;
                    if (paramDefn.getParamRequired()) {
                        if (object2 == null && paramDefn.getDependentParam() == null) {
                            ProvisioningCmdArgs.usage();
                            throw new InvalidParameterException(ERROR_PREFIX + " " + resBundle.getString("PROV_MAND_ARG_MISSING") + " - " + (String)object);
                        }
                    } else {
                        String[] stringArray3 = paramDefn.getParamRequiredOprns();
                        if (stringArray3 != null) {
                            n2 = 0;
                            while (n2 < stringArray3.length) {
                                if (stringArray3[n2].equalsIgnoreCase(string5) && object2 == null && paramDefn.getDependentParam() == null) {
                                    ProvisioningCmdArgs.usage();
                                    throw new InvalidParameterException(ERROR_PREFIX + " " + resBundle.getString("PROV_MAND_ARG_MISSING_FOR_OPRN") + " - " + string5 + " : " + (String)object);
                                }
                                ++n2;
                            }
                        }
                    }
                    if ((stringArray2 = paramDefn.getParamValidValues()) != null) {
                        bl = false;
                        n2 = 0;
                        while (n2 < stringArray2.length) {
                            if (stringArray2[n2].equalsIgnoreCase((String)object2)) {
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!bl) {
                            throw new InvalidParameterException(ERROR_PREFIX + " " + resBundle.getString("PROV_ARG_VAL_INVALID") + " - " + (String)object + " : " + (String)object2);
                        }
                    }
                }
            }
            ++n;
        }
    }

    public static void usage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NEW_LINE).append("Usage: oidprovtool  ").append("<Operation Information>  ").append("<Directory Information>  ").append(NEW_LINE).append("  <Profile Information>  <Profile Create Info>  ").append(NEW_LINE).append(NEW_LINE).append("  Operation Information: operation={create/disable/enable/status/delete/reset/modify} ").append(NEW_LINE).append(NEW_LINE).append("  Directory Information: ldap_host=<host> ldap_port=<port> ").append(NEW_LINE).append("                         ldap_user_dn=<dn> ldap_user_password=<passwd>").append(NEW_LINE).append(NEW_LINE).append("  Profile Information  : application_dn=<app_dn> organization_dn=<org_dn> organization_name=<orgSimpleName>").append(NEW_LINE).append(NEW_LINE).append("                profile_mode=<mode> profile_status=<status>").append(NEW_LINE).append("                profile_group=<group> profile_debug=<debug (0-63)>").append(NEW_LINE).append("                interface_name=<ifName> interface_type=<ifType> ").append(NEW_LINE).append("                interface_version=<ifVersion> ").append(NEW_LINE).append("                interface_connect_info=<ifConnInfo>").append(NEW_LINE).append("                interface_additional_info=<app Specific Info>").append(NEW_LINE).append("                crypt_key=<Key (multiple of 8 characters>").append(NEW_LINE).append("                schedule=<sched> max_retries=<max_retries> ").append(NEW_LINE).append("                lastchangenumber=<OID last change number> ").append(NEW_LINE).append("                max_events_per_schedule=<number>").append(NEW_LINE).append("                event_subscription=<ev1> event_subscription=<ev2> ...").append(NEW_LINE).append("                event_mapping_rules=<rules>").append(NEW_LINE).append("                event_permitted_operations=<oprns> ...").append(NEW_LINE).append("                ssl_mode=<0-NonSSL,1-SSL no authentication> ").append(NEW_LINE);
        if (!ProvisioningProfile.apimode) {
            System.out.println(stringBuffer.toString());
        }
    }

    public static void LOG(String string) {
        if (!ProvisioningProfile.apimode && debug > 0) {
            System.out.println(string);
        }
    }
}

