/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ProvisioningCmdArgs;
import oracle.ldap.util.provisioning.ProvisioningProfile;
import oracle.ldap.util.provisioning.ProvisioningProfileV2;

public class ProvisioningOutboundProfileV2
extends ProvisioningProfileV2 {
    public static final String ATTR_ProvEvents = "orclODIPProvisioningEventSubscription";
    public static final String ATTR_LastChgNum = "orclLastAppliedChangeNumber";
    public static final String ATTR_SubscriberDisable = "orclSubscriberDisable";
    protected Vector provisioningProfileEventSubscription;
    protected String profileChgLogLastAppliedChangeNumber;
    protected String profileChgLogSubscriberDisable;
    protected String profileProcessingStatus;
    protected Vector profileProcessingErrors;
    protected String profileLastProcessingTime;
    protected String profileLastSuccessfulProcTime;
    protected boolean valid = true;

    public ProvisioningOutboundProfileV2(DirContext dirContext, String string) throws Exception {
        try {
            this.readProfileFromDirectory(dirContext, "cn=OIDToApplication," + string);
        }
        catch (Exception exception) {
            this.valid = false;
        }
    }

    public ProvisioningOutboundProfileV2(DirContext dirContext, String string, String string2) throws Exception {
        try {
            String string3 = ProvisioningProfile.composeProfileDN(dirContext, string, string2);
            this.readProfileFromDirectory(dirContext, "cn=OIDToApplication," + string3);
        }
        catch (Exception exception) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void modify(DirContext dirContext, ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        String string;
        int n = 0;
        ModificationItem[] modificationItemArray = new ModificationItem[32];
        BasicAttribute basicAttribute = null;
        Vector vector = provisioningCmdArgs.getVector("EVENT_SUBSCRIPTION");
        if (vector != null) {
            ProvisioningCmdArgs.LOG("Updating Attribute :orclODIPProvisioningEventSubscription");
            basicAttribute = new BasicAttribute(ATTR_ProvEvents);
            int n2 = 0;
            while (n2 < vector.size()) {
                basicAttribute.add(vector.elementAt(n2));
                ++n2;
            }
            modificationItemArray[n++] = new ModificationItem(2, basicAttribute);
        }
        if ((string = provisioningCmdArgs.get("LASTCHANGENUMBER")) != null) {
            ProvisioningCmdArgs.LOG("Updating Attribute :orclLastAppliedChangeNumber");
            basicAttribute = new BasicAttribute(ATTR_LastChgNum);
            basicAttribute.add(string);
            modificationItemArray[n++] = new ModificationItem(2, new BasicAttribute(ATTR_LastChgNum, basicAttribute));
        }
        if (n == 0) {
            ProvisioningCmdArgs.LOG("Nothing TO modify in OUTBOUND Profile");
            return;
        }
        ModificationItem[] modificationItemArray2 = new ModificationItem[n];
        System.arraycopy(modificationItemArray, 0, modificationItemArray2, 0, n);
        ProvisioningCmdArgs.LOG("Modifying entry : (" + this.profileDN + ")");
        dirContext.modifyAttributes(this.profileDN, modificationItemArray2);
    }

    public void status(DirContext dirContext) throws Exception {
        String[] stringArray = new String[]{"*", "orclguid"};
        Property property = null;
        PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, this.profileDN, "objectclass=*", 0, stringArray);
        PropertySet propertySet = propertySetCollection.getPropertySet(0);
        property = propertySet.getProperty(ATTR_LastChgNum);
        if (property != null) {
            this.setProfileChgLogLastAppliedChangeNumber((String)property.getValue(0));
            System.out.println(ATTR_LastChgNum + ": " + (String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_SubscriberDisable)) != null) {
            this.setProfileChgLogSubscriberDisable((String)property.getValue(0));
            System.out.println(ATTR_SubscriberDisable + ": " + (String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileProcessingStatus")) != null) {
            this.setProfileProcessingStatus((String)property.getValue(0));
            System.out.println("orclODIPProfileProcessingStatus" + ": " + (String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileProcessingErrors")) != null && property.size() > 0) {
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                System.out.println("orclODIPProfileProcessingErrors" + ": " + (String)property.getValue(0));
                ++n;
            }
            this.setProfileProcessingErrors(vector);
        }
        if ((property = propertySet.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)property.getValue(0));
            System.out.println("orclODIPProfileLastProcessingTime" + ": " + (String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)property.getValue(0));
            System.out.println("orclODIPProfileLastSuccessfulProcessingTime" + ": " + (String)property.getValue(0));
        }
    }

    public static ProvisioningOutboundProfileV2 createNewOutboundProfileV2(DirContext dirContext, ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        ProvisioningOutboundProfileV2 provisioningOutboundProfileV2 = null;
        boolean bl = false;
        Vector vector = null;
        String string = ProvisioningProfile.composeProfileDN(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
        bl = ProvisioningProfile.directoryEntryExists(dirContext, "cn=OIDToApplication," + string);
        if (bl) {
            throw new Exception("Provisioning Profile Already Exists..");
        }
        BasicAttribute basicAttribute = null;
        BasicAttributes basicAttributes = new BasicAttributes();
        BasicAttribute basicAttribute2 = new BasicAttribute("objectclass");
        basicAttribute2.add("top");
        basicAttribute2.add("orclODIPProvisioningIntegrationOutBoundProfileV2");
        basicAttribute2.add("orclChangeSubscriber");
        basicAttributes.put(basicAttribute2);
        basicAttribute = new BasicAttribute("cn");
        basicAttribute.add("OIDToApplication");
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclStatus");
        basicAttribute.add(provisioningCmdArgs.get("PROFILE_STATUS"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProvisioningAppGUID");
        basicAttribute.add(ProvisioningProfile.getDirectoryEntryGUID(dirContext, provisioningCmdArgs.get("APPLICATION_DN")));
        basicAttributes.put(basicAttribute);
        vector = provisioningCmdArgs.getVector("EVENT_SUBSCRIPTION");
        if (vector != null) {
            basicAttribute = new BasicAttribute(ATTR_ProvEvents);
            int n = 0;
            while (n < vector.size()) {
                basicAttribute.add((String)vector.elementAt(n));
                ++n;
            }
            basicAttributes.put(basicAttribute);
        }
        basicAttribute = new BasicAttribute(ATTR_LastChgNum);
        String string2 = provisioningCmdArgs.get("LASTCHANGENUMBER");
        if (string2 != null) {
            basicAttribute.add(string2);
        } else {
            basicAttribute.add(ProvisioningProfile.getCurrentChangeNumber(dirContext));
        }
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute(ATTR_SubscriberDisable);
        basicAttribute.add("0");
        basicAttributes.put(basicAttribute);
        ProvisioningCmdArgs.LOG(((Object)basicAttributes).toString());
        DirContext dirContext2 = dirContext.createSubcontext("cn=OIDToApplication," + string, (Attributes)basicAttributes);
        ProvisioningCmdArgs.LOG("Created OutBound SubProfile Entry Successfully");
        provisioningOutboundProfileV2 = new ProvisioningOutboundProfileV2(dirContext, string);
        ProvisioningCmdArgs.LOG("Created OutBound SubProfile Object Successfully");
        return provisioningOutboundProfileV2;
    }

    private void readProfileFromDirectory(DirContext dirContext, String string) throws Exception {
        int n;
        Vector<Object> vector;
        String[] stringArray = new String[]{"*", "orclguid"};
        Property property = null;
        ProvisioningCmdArgs.LOG("Searching For OUTBOUND Profile : " + string);
        PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, string, "objectclass=*", 0, stringArray);
        PropertySet propertySet = propertySetCollection.getPropertySet(0);
        this.profileDN = string;
        property = propertySet.getProperty("orclStatus");
        if (property != null) {
            this.setProfileStatus((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_LastChgNum)) != null) {
            this.setProfileChgLogLastAppliedChangeNumber((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_SubscriberDisable)) != null) {
            this.setProfileChgLogSubscriberDisable((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProvisioningAppGUID")) != null) {
            this.setProvisioningProfileAppGUID((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProvEvents)) != null && property.size() > 0) {
            vector = new Vector<Object>();
            n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                ++n;
            }
            this.setProvisioningProfileEventSubscription(vector);
        }
        if ((property = propertySet.getProperty("orclODIPProfileProcessingStatus")) != null) {
            this.setProfileProcessingStatus((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileProcessingErrors")) != null && property.size() > 0) {
            vector = new Vector();
            n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                ++n;
            }
            this.setProfileProcessingErrors(vector);
        }
        if ((property = propertySet.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)property.getValue(0));
        }
    }

    public String getProfileStatus() {
        return this.profileStatus;
    }

    public void setProfileStatus(String string) {
        this.profileStatus = string;
    }

    public String getProfileChgLogLastAppliedChangeNumber() {
        return this.profileChgLogLastAppliedChangeNumber;
    }

    public void setProfileChgLogLastAppliedChangeNumber(String string) {
        this.profileChgLogLastAppliedChangeNumber = string;
    }

    public String getProfileChgLogSubscriberDisable() {
        return this.profileChgLogSubscriberDisable;
    }

    public void setProfileChgLogSubscriberDisable(String string) {
        this.profileChgLogSubscriberDisable = string;
    }

    public Vector getProvisioningProfileEventSubscription() {
        return this.provisioningProfileEventSubscription;
    }

    public void setProvisioningProfileEventSubscription(Vector vector) {
        this.provisioningProfileEventSubscription = vector;
    }

    public String getProfileProcessingStatus() {
        return this.profileProcessingStatus;
    }

    public void setProfileProcessingStatus(String string) {
        this.profileProcessingStatus = string;
    }

    public Vector getProfileProcessingErrors() {
        return this.profileProcessingErrors;
    }

    public void setProfileProcessingErrors(Vector vector) {
        this.profileProcessingErrors = vector;
    }

    public String getProfileLastProcessingTime() {
        return this.profileLastProcessingTime;
    }

    public void setProfileLastProcessingTime(String string) {
        this.profileLastProcessingTime = string;
    }

    public String getProfileLastSuccessfulProcTime() {
        return this.profileLastSuccessfulProcTime;
    }

    public void setProfileLastSuccessfulProcTime(String string) {
        this.profileLastSuccessfulProcTime = string;
    }
}

