/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.nt.NTAdapter;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    int port;
    String host;
    String prot;
    private Socket socket;
    private Properties socketOptions;

    public TcpNTAdapter(String string, Properties properties) throws NLException {
        this.socketOptions = properties;
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = new NVFactory().createNVPair(string);
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "PROTOCOL");
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "HOST");
        NVPair nVPair4 = nVNavigator.findNVPair(nVPair, "PORT");
        if (nVPair2 == null) {
            throw new NLException("NoNVPair-04614", "PROTOCOL");
        }
        if (nVPair3 == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        if (nVPair4 == null) {
            throw new NLException("NoNVPair-04614", "PORT");
        }
        this.prot = nVPair2.getAtom();
        this.host = nVPair3.getAtom();
        this.port = Integer.parseInt(nVPair4.getAtom());
        if (!this.prot.equals("TCP") && !this.prot.equals("tcp")) {
            throw new NLException("InvalidRHS-04615", "PROTOCOL");
        }
    }

    public void connect() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.setSocketOptions();
    }

    public void setSocketOptions() throws IOException {
        int n = 0;
        String string = null;
        Enumeration enumeration = ((Hashtable)this.socketOptions).keys();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            switch (n) {
                case 0: {
                    string = (String)((Hashtable)this.socketOptions).get(new Integer(0));
                    try {
                        if (string.equals("YES")) {
                            this.socket.setTcpNoDelay(true);
                            break;
                        }
                        this.socket.setTcpNoDelay(false);
                        break;
                    }
                    catch (SocketException socketException) {
                        throw new IOException(socketException.getMessage());
                    }
                }
            }
        }
    }

    public void disconnect() throws IOException {
        this.socket.close();
        this.socket = null;
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }
}

