/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import oracle.jdbc.driver.OracleDriver;
import oracle.ultrasearch.util.UtilErrorMessage;
import oracle.ultrasearch.util.loader.DocHandler;
import oracle.ultrasearch.util.loader.LovHandler;

public class MetaLoader {
    Hashtable m_argHash;
    String m_databaseConnStr;
    String m_user;
    String m_password;
    String m_instance;
    String m_type;
    String m_inputFile;
    Connection m_conn;
    Statement m_stmt;
    UtilErrorMessage m_utilErr = new UtilErrorMessage();

    protected MetaLoader() {
    }

    protected void parseArg(String[] stringArray) {
        this.m_argHash = new Hashtable();
        if (stringArray.length < 1) {
            this.exitWithMessage(null);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n == stringArray.length - 1) {
                this.exitWithMessage(stringArray[n]);
            }
            this.m_argHash.put(stringArray[n], stringArray[++n]);
            ++n;
        }
        if (!this.m_argHash.containsKey("-db")) {
            this.exitWithMessage("-db");
        } else {
            this.m_databaseConnStr = (String)this.m_argHash.get("-db");
        }
        if (!this.m_argHash.containsKey("-u")) {
            this.exitWithMessage("-u");
        } else {
            this.m_user = (String)this.m_argHash.get("-u");
        }
        if (!this.m_argHash.containsKey("-p")) {
            this.exitWithMessage("-p");
        } else {
            this.m_password = (String)this.m_argHash.get("-p");
        }
        if (!this.m_argHash.containsKey("-i")) {
            this.exitWithMessage("-i");
        } else {
            this.m_instance = (String)this.m_argHash.get("-i");
        }
        if (!this.m_argHash.containsKey("-type")) {
            this.exitWithMessage("-type");
        } else {
            this.m_type = (String)this.m_argHash.get("-type");
        }
        if (!this.m_argHash.containsKey("-f")) {
            this.exitWithMessage("-f");
        } else {
            this.m_inputFile = (String)this.m_argHash.get("-f");
        }
    }

    private void exitWithMessage(String string) {
        if (string != null) {
            System.out.println(this.m_utilErr.getMsg(40100, string));
        }
        System.out.println(this.m_utilErr.getMsg(40101) + "java MetaLoader -db <database_connection_string>" + " -u <user_name> -p <password> -i <instance_name>" + " -type <loader_type> -f <input_file>");
        System.exit(1);
    }

    private void initConnection() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.m_conn = DriverManager.getConnection("jdbc:oracle:thin:@" + this.m_databaseConnStr, this.m_user, this.m_password);
            this.m_stmt = this.m_conn.createStatement();
            this.m_stmt.execute("ALTER SESSION SET NLS_LANGUAGE = 'AMERICAN' ");
            this.m_stmt.execute("ALTER SESSION SET NLS_TERRITORY = 'AMERICA' ");
            String string = "BEGIN wk_adm.use_instance('" + this.m_instance + "'); EXCEPTION when others then wk_err.raise; END;";
            this.m_stmt.executeQuery(string);
            this.m_stmt.close();
        }
        catch (SQLException sQLException) {
            System.out.println(this.m_utilErr.getMsg(40102));
            System.exit(1);
        }
        catch (Exception exception) {
            System.out.println(this.m_utilErr.getMsg(40103));
            System.exit(1);
        }
    }

    private void load() {
        this.initConnection();
        LovHandler lovHandler = null;
        try {
            if (this.m_type.equalsIgnoreCase("lov")) {
                lovHandler = new LovHandler();
            } else if (this.m_type.equalsIgnoreCase("doc")) {
                lovHandler = new DocHandler();
            } else {
                System.out.println(this.m_utilErr.getMsg(40104, this.m_type));
                System.exit(1);
            }
            lovHandler.parseXML(this.m_inputFile);
            lovHandler.loadToDB(this.m_conn);
        }
        catch (Exception exception) {
            System.exit(1);
        }
    }

    private void close() {
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println(this.m_utilErr.getMsg(40103));
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        MetaLoader metaLoader = new MetaLoader();
        metaLoader.parseArg(stringArray);
        metaLoader.load();
        metaLoader.close();
    }
}

