/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CommandLineRun {
    private StringWriter m_errLog = null;
    private StringWriter m_outLog = null;
    private Process m_process;
    private String m_commandLine;
    private int exitCode = 0;

    public CommandLineRun(String commandLine) {
        this.m_commandLine = commandLine;
    }

    public void execute() throws Exception {
        this.m_outLog = new StringWriter();
        this.m_errLog = new StringWriter();
        if (this.m_commandLine == null || this.m_commandLine.trim().equals("")) {
            throw new Exception("Empty command. Not executing");
        }
        StringTokenizer token = new StringTokenizer(this.m_commandLine, "\"", true);
        String[] arr = new String[token.countTokens()];
        int i = 0;
        int quoteCount = 0;
        while (token.hasMoreTokens()) {
            arr[i] = token.nextToken();
            if (arr[i].equals("\"")) {
                ++quoteCount;
            }
            ++i;
        }
        ArrayList<String> lst = new ArrayList<String>();
        boolean gotQuotes = false;
        for (int j = 0; j < arr.length; ++j) {
            if (arr[j].equals("\"")) {
                gotQuotes = !gotQuotes;
                continue;
            }
            if (gotQuotes) {
                lst.add(String.valueOf(String.valueOf("").concat(String.valueOf(arr[j]))).concat(String.valueOf("")));
                continue;
            }
            StringTokenizer tok = new StringTokenizer(arr[j]);
            if (tok.countTokens() > 0) {
                while (tok.hasMoreTokens()) {
                    lst.add(tok.nextToken());
                }
                continue;
            }
            lst.add(arr[j]);
        }
        String[] mainArr = new String[lst.size()];
        for (int j = 0; j < mainArr.length; ++j) {
            mainArr[j] = (String)lst.get(j);
        }
        this.m_process = Runtime.getRuntime().exec(mainArr);
        StreamPipeThread spt1 = new StreamPipeThread(new InputStreamReader(this.m_process.getInputStream()), this.m_outLog);
        StreamPipeThread spt2 = new StreamPipeThread(new InputStreamReader(this.m_process.getErrorStream()), this.m_errLog);
        spt1.start();
        spt2.start();
        try {
            this.exitCode = this.m_process.waitFor();
        }
        catch (InterruptedException ie) {
            this.stop();
        }
        try {
            spt1.join();
            spt2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.m_outLog.close();
            this.m_errLog.close();
        }
        catch (Exception exception) {}
    }

    public void stop() {
        if (this.m_process != null) {
            this.m_process.destroy();
        }
    }

    public String getCommandLine() {
        return this.m_commandLine;
    }

    public StringWriter getErrLog() {
        return this.m_errLog;
    }

    public StringWriter getOutLog() {
        return this.m_outLog;
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

