/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util.CharConvBuilder;

import java.io.IOException;
import java.util.Vector;
import oracle.gss.util.CharConvBuilder.MappingSetter;
import oracle.sql.converter.CharacterConverter;
import oracle.sql.converter.CharacterConverter12Byte;

public class MultiByte12MapSetter
extends MappingSetter {
    static final int ENTRYWIDTH = 18;
    static final int MAXCHARVALUE = 65535;
    int m_l1KeyWidth;
    int m_ucsReplacement;
    Vector mapStore;
    CharacterConverter12Byte m_charConv;

    MultiByte12MapSetter(int n, int n2, int n3) {
        super(n);
        this.m_l1KeyWidth = n2;
        this.m_ucsReplacement = n3;
        this.mapStore = new Vector();
    }

    MultiByte12MapSetter(CharacterConverter characterConverter, CharacterConverter12Byte characterConverter12Byte, int n, int n2, int n3) throws IOException {
        super(n);
        this.m_l1KeyWidth = n2;
        this.m_ucsReplacement = n3;
        this.mapStore = new Vector();
        this.m_charConv = characterConverter12Byte;
        if (characterConverter != null) {
            Vector vector = new Vector(65535, 28671);
            characterConverter.extractCodepoints(vector);
            int n4 = 0;
            while (n4 < vector.size()) {
                int[] nArray = (int[])vector.elementAt(n4);
                this.set(nArray[0], nArray[1]);
                ++n4;
            }
        }
    }

    void buildMapping() {
        int n;
        int n2;
        int n3;
        char c;
        char c2;
        char[] cArray;
        int n4 = this.m_l1KeyWidth;
        int n5 = 16 - n4;
        int n6 = (1 << n4) - 1;
        int n7 = (1 << n5) - 1;
        int n8 = 1 << n4;
        char[] cArray2 = new char[n8];
        char[][] cArray3 = new char[n8][2];
        int n9 = 0;
        while (n9 < n8) {
            cArray2[n9] = '\u0000';
            cArray3[n9][0] = (char)n7;
            cArray3[n9][1] = '\u0000';
            ++n9;
        }
        int n10 = this.mapStore.size();
        int n11 = this.m_ucsReplacement;
        n9 = 0;
        while (n9 < n10) {
            cArray = (char[])this.mapStore.elementAt(n9);
            c2 = cArray[1];
            if (c2 != n11) {
                c = cArray[0];
                n3 = c >> n5 & n6;
                cArray2[n3] = '\u0001';
                n2 = c & n7;
                if (n2 < cArray3[n3][0]) {
                    cArray3[n3][0] = (char)n2;
                }
                if (n2 > cArray3[n3][1]) {
                    cArray3[n3][1] = (char)n2;
                }
            }
            ++n9;
        }
        int n12 = n = n7 + 1;
        int n13 = 0;
        n9 = 0;
        while (n9 < n8) {
            if (cArray2[n9] != '\u0000') {
                int n14 = cArray3[n9][0];
                cArray2[n9] = (char)(n12 - (n13 < n14 ? n13 : n14));
                n12 = cArray2[n9] + n;
                n13 = n - cArray3[n9][1] - 1;
            }
            ++n9;
        }
        char[] cArray4 = new char[n12];
        n9 = 0;
        while (n9 < n12) {
            cArray4[n9] = (char)n11;
            ++n9;
        }
        n10 = this.mapStore.size();
        n9 = 0;
        while (n9 < n10) {
            cArray = (char[])this.mapStore.elementAt(n9);
            c2 = cArray[1];
            if (c2 != n11) {
                c = cArray[0];
                n3 = c >> n5 & n6;
                n2 = c & n7;
                int n15 = cArray2[n3] + n2;
                cArray4[n15] = c2;
            }
            ++n9;
        }
        this.setArray2(cArray4);
        this.setArray(cArray2);
    }

    void finish() {
        this.buildMapping();
    }

    boolean set(int n, int n2) throws IOException {
        if (n > 65535 || n2 > 65535) {
            if (n > 65535) {
                this.printErrorMsg("***** Error: source code point " + MappingSetter.intToHex8(n) + " is too big for 1-2 byte converter");
            }
            if (n2 > 65535) {
                this.printErrorMsg("***** Error: target code point " + MappingSetter.intToHex8(n2) + " is too big for 1-2 byte converter");
            }
            return false;
        }
        char[] cArray = new char[]{(char)n, (char)n2};
        this.mapStore.addElement(cArray);
        return true;
    }

    void setArray(char[] cArray) {
        int n = cArray.length;
        this.m_charConv.m_ucsCharLevel1 = new char[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_charConv.m_ucsCharLevel1[n2] = cArray[n2];
            ++n2;
        }
    }

    void setArray2(char[] cArray) {
        int n = cArray.length;
        this.m_charConv.m_ucsCharLevel2 = new char[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_charConv.m_ucsCharLevel2[n2] = cArray[n2];
            ++n2;
        }
    }
}

