/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OraclePreparedStatement
extends OracleStatement
implements oracle.jdbc.internal.OraclePreparedStatement,
ScrollRsetStatement {
    private int min_binary_stream_size;
    private int min_ascii_stream_size;
    private int premature_batch_count;
    boolean check_bind_types = true;
    DBDataSet m_binds;
    boolean m_scrollRsetTypeSolved;
    boolean has_ref_cursors = false;
    protected static final int BSTYLE_UNKNOWN = 0;
    protected static final int BSTYLE_ORACLE = 1;
    protected static final int BSTYLE_JDBC = 2;
    protected int m_batchStyle = 0;

    public OraclePreparedStatement(OracleConnection oracleConnection, String string, int n, int n2) throws SQLException {
        this(oracleConnection, string, n, n2, 1003, 1007);
    }

    public OraclePreparedStatement(OracleConnection oracleConnection, String string, int n, int n2, int n3, int n4) throws SQLException {
        super(oracleConnection, n, n2, n3, n4);
        this.need_to_parse = true;
        this.has_ref_cursors = false;
        this.prepare_for_new_result(true);
        this.sql_query = string;
        this.m_originalSql = string;
        this.clear_params = true;
        this.m_binds = null;
        this.m_scrollRsetTypeSolved = false;
        this.m_stmtType = 1;
        this.premature_batch_count = 0;
        this.binds_in = this.connection.db_access.createDBDataSet(oracleConnection, this, n, 1);
        this.parseSqlKind();
        if (oracleConnection.db_access.getVersionNumber() >= 8000) {
            this.min_binary_stream_size = 2000;
            this.min_ascii_stream_size = 4000;
        } else {
            this.min_binary_stream_size = 255;
            this.min_ascii_stream_size = 2000;
        }
    }

    public synchronized void addBatch() throws SQLException {
        this.setJdbcBatchStyle();
        this.binds_in.rowCompleted(-1);
        if (this.binds_in.hasStreamType()) {
            DBError.throwSqlException(90, "streams type cannot be used in batching");
        }
        this.checkBindsInAndOut();
        ++this.m_currentRank;
    }

    public synchronized void addBatch(String string) throws SQLException {
        DBError.throwSqlException(23);
    }

    protected void checkBindObjectTypes(boolean bl, int n, int n2, StructDescriptor structDescriptor) throws SQLException {
        if (!this.check_bind_types) {
            return;
        }
        int n3 = bl ? this.binds_in.checkBindObjectTypes(this.binds_out, n, n2, structDescriptor) : this.binds_out.checkBindObjectTypes(this.binds_in, n, n2, structDescriptor);
        if (n3 == -1) {
            this.premature_batch_count = this.sendBatch();
            this.need_to_parse = true;
        }
    }

    protected void checkBindTypes(boolean bl, int n, int n2) throws SQLException {
        if (!this.check_bind_types) {
            return;
        }
        int n3 = bl ? this.binds_in.checkBindTypes(this.binds_out, n, n2) : this.binds_out.checkBindTypes(this.binds_in, n, n2);
        if (n3 == -1) {
            int n4 = this.m_currentRank;
            this.premature_batch_count = this.sendBatch();
            this.need_to_parse = true;
            this.binds_in.clearItem(n4, true);
        }
    }

    protected final void checkIfJdbcBatchExists() throws SQLException {
        if (this.doesJdbcBatchExist()) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    void checkPlsqlIndexTableBindTypes(boolean bl, int n, int n2, int n3, int n4) throws SQLException {
        switch (n3) {
            default: {
                DBError.throwSqlException(97);
            }
            case 1: 
            case 2: 
            case 6: 
            case 96: 
        }
        if (!this.check_bind_types) {
            return;
        }
        int n5 = bl ? this.binds_in.checkPlsqlIndexTableBindTypes(this.binds_out, n, n2, n4, n3) : this.binds_out.checkPlsqlIndexTableBindTypes(this.binds_in, n, n2, n4, n3);
        if (n5 == -1) {
            this.sendBatch();
            this.need_to_parse = true;
            this.clearDefines();
        }
    }

    private void cleanup() {
        if (this.connection.m_stmtClearMetaData && this.binds_in != null) {
            this.binds_in.cleanup();
        }
        this.clear_params = true;
    }

    public synchronized void clearBatch() throws SQLException {
        if (this.binds_in != null && this.binds_in.getNoOfArgs() > 0) {
            this.binds_in.clearItems();
        }
        this.m_currentRank = 0;
        this.clear_params = true;
    }

    public synchronized void clearParameters() throws SQLException {
        this.clear_params = true;
        if (this.binds_in != null) {
            this.binds_in.clearItem(this.m_currentRank, false);
        }
    }

    public void close() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.privateClose(null);
            }
        }
    }

    public void closeWithKey(String string) throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.privateClose(string);
            }
        }
    }

    public synchronized void defineParameterType(int n, int n2, int n3) throws SQLException {
        this.defineParameterTypeBytes(n, n2, n3 * this.connection.dataSizeScale);
    }

    public synchronized void defineParameterTypeBytes(int n, int n2, int n3) throws SQLException {
        if (n3 < 0) {
            DBError.throwSqlException(53);
        }
        if (n < 1) {
            DBError.throwSqlException(3);
        }
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 6;
                break;
            }
            case 999: {
                n2 = 999;
                break;
            }
            case 1: {
                n2 = 96;
                break;
            }
            case 12: {
                n2 = 1;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                n2 = 12;
                break;
            }
            case -103: {
                n2 = 182;
                break;
            }
            case -104: {
                n2 = 183;
                break;
            }
            case -100: {
                n2 = 180;
                break;
            }
            case -101: {
                n2 = 181;
                break;
            }
            case -102: {
                n2 = 231;
                break;
            }
            case -3: 
            case -2: {
                n2 = 23;
                break;
            }
            case -8: {
                n2 = 104;
                break;
            }
            case 2004: {
                n2 = 113;
                break;
            }
            case 2005: {
                n2 = 112;
                break;
            }
            case -13: {
                n2 = 114;
                break;
            }
            case -10: {
                n2 = 102;
                break;
            }
            default: {
                DBError.throwSqlException(23);
            }
        }
        this.binds_in.setType(n - 1, n2, n3, (short)1);
    }

    public synchronized void defineParameterTypeChars(int n, int n2, int n3) throws SQLException {
        int n4 = this.connection.db_access.getNlsRatio();
        if (n2 == 1 || n2 == 12) {
            this.defineParameterTypeBytes(n, n2, n3 * n4);
        } else {
            this.defineParameterTypeBytes(n, n2, n3);
        }
    }

    private int doScrollPstmtExecuteUpdate() throws SQLException {
        this.scrollStmt_cleanup(false);
        this.parseSqlKind();
        if (this.sql_kind != 0) {
            this.prepare_for_new_result(true);
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            return this.valid_rows;
        }
        boolean bl = true;
        String string = null;
        if (!this.m_needToAddIdentifier) {
            this.prepare_for_new_result(true);
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_realRsetType = this.m_userRsetType;
        } else {
            try {
                this.m_revisedSql = ResultSetUtil.addIdentifierToSql(this.m_originalSql);
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.prepare_for_new_result(true);
                this.sql_query = this.m_revisedSql;
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(1);
                }
                this.prepare_for_new_result(true);
                this.get_data_for_columns(this.batch);
                this.doExecuteWithTimeout();
                this.m_binds = this.binds_in;
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
            }
            catch (SQLException sQLException) {
                bl = false;
                string = sQLException.getMessage();
                this.m_binds = this.binds_in;
            }
            if (bl) {
                this.m_realRsetType = this.m_userRsetType;
            } else {
                this.m_realRsetType = this.m_userRsetType > 3 ? 3 : 1;
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.prepare_for_new_result(true);
                this.sql_query = this.m_originalSql;
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(-1);
                }
                this.prepare_for_new_result(true);
                this.doExecuteWithTimeout();
                this.m_binds = this.binds_in;
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                bl = true;
            }
        }
        if (this.current_result_set == null || !bl) {
            DBError.check_error(1, "Unable to create result set");
        } else {
            if (this.m_userRsetType != this.m_realRsetType) {
                this.m_warning = DBError.addSqlWarning(this.m_warning, 91, string);
            }
            this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
        }
        this.m_scrollRsetTypeSolved = true;
        return this.valid_rows;
    }

    private boolean doesJdbcBatchExist() {
        return this.m_currentRank > 0 && this.m_batchStyle == 2;
    }

    void end_of_result_set() throws SQLException {
        this.prepare_for_new_result(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                boolean bl;
                try {
                    this.executionType = (byte)3;
                    this.checkIfJdbcBatchExists();
                    this.executeUpdate();
                    DBAccess cfr_ignored_0 = this.connection.db_access;
                    bl = this.sql_kind == 0;
                    Object var7_4 = null;
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    this.executionType = (byte)-1;
                    throw throwable;
                }
                this.executionType = (byte)-1;
                {
                }
                return bl;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] executeBatch() throws SQLException {
        var1_1 = this.connection;
        synchronized (var1_1) {
            var4_2 = this;
            synchronized (var4_2) {
                block17: {
                    var6_3 = 0;
                    this.setJdbcBatchStyle();
                    if (this.m_currentRank == 0) {
                        return new int[0];
                    }
                    var7_10 = new int[this.m_currentRank];
                    this.open();
                    this.ensureOpen();
                    this.prepare_for_new_result(true);
                    if (this.sql_string_changed) {
                        this.parseSqlKind();
                    }
                    if (this.sql_kind == 0) {
                        DBError.throwBatchUpdateException(80, 0, null);
                    }
                    try {
                        try {
                            this.need_to_parse = true;
                            this.doExecuteOther(true);
                            break block17;
                        }
                        catch (SQLException var10_11) {
                            var6_3 = 0;
                            ** while (var6_3 < var7_10.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var7_10[var6_3] = -3;
                            ++var6_3;
                            continue;
                        }
lbl31:
                        // 1 sources

                        DBError.throwBatchUpdateException(var10_11, var7_10.length, var7_10);
                    }
                    catch (Throwable var8_14) {
                        var9_13 = null;
                        this.cleanupForBatching();
                        throw var8_14;
                    }
                }
                var9_12 = null;
                this.cleanupForBatching();
                if (this.valid_rows < 0) {
                    var6_3 = 0;
                    while (var6_3 < var7_10.length) {
                        var7_10[var6_3] = -3;
                        ++var6_3;
                    }
                    DBError.throwBatchUpdateException(81, 0, var7_10);
                }
                var6_3 = 0;
                while (var6_3 < var7_10.length) {
                    var7_10[var6_3] = -2;
                    ++var6_3;
                }
                return var7_10;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                OracleResultSet oracleResultSet;
                block11: {
                    OracleResultSetImpl oracleResultSetImpl;
                    block10: {
                        try {
                            this.executionType = 1;
                            this.executeUpdate();
                            if (this.isRegularResultSet()) {
                                oracleResultSetImpl = this.current_result_set = new OracleResultSetImpl(this.connection, this);
                                Object var7_5 = null;
                                break block10;
                            }
                            if (this.m_scrollRset == null) {
                                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                                this.m_scrollRset = this.current_result_set;
                            }
                            oracleResultSet = this.m_scrollRset;
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var7_7 = null;
                            this.executionType = (byte)-1;
                            throw throwable;
                        }
                    }
                    this.executionType = (byte)-1;
                    return oracleResultSetImpl;
                }
                Object var7_6 = null;
                this.executionType = (byte)-1;
                return oracleResultSet;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                int n;
                block16: {
                    int n2;
                    block15: {
                        int n3;
                        block14: {
                            try {
                                int n4;
                                if (this.executionType == -1) {
                                    this.executionType = (byte)2;
                                }
                                this.noMoreUpdateCounts = false;
                                this.checkIfJdbcBatchExists();
                                this.ensureOpen();
                                if (this.has_ref_cursors) {
                                    this.need_to_parse = true;
                                }
                                if (this.isRegularResultSet()) {
                                    this.prepare_for_new_result(true);
                                    this.get_data_for_columns(this.batch);
                                    this.doExecuteWithTimeout();
                                    if (this.valid_rows > 0) {
                                        this.valid_rows += this.premature_batch_count;
                                        this.premature_batch_count = 0;
                                    }
                                    n3 = this.valid_rows;
                                    Object var7_6 = null;
                                    break block14;
                                }
                                if (this.m_scrollRsetTypeSolved) {
                                    this.prepare_for_new_result(true);
                                    this.get_data_for_columns(this.batch);
                                    this.doExecuteWithTimeout();
                                    this.current_result_set = new OracleResultSetImpl(this.connection, this);
                                    this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
                                    if (this.connection.m_accumulateBatchResult && this.valid_rows > 0) {
                                        this.valid_rows += this.premature_batch_count;
                                        this.premature_batch_count = 0;
                                    }
                                    n2 = this.valid_rows;
                                    break block15;
                                }
                                n = n4 = this.doScrollPstmtExecuteUpdate() + this.premature_batch_count;
                                break block16;
                            }
                            catch (Throwable throwable) {
                                Object var7_9 = null;
                                this.executionType = (byte)-1;
                                throw throwable;
                            }
                        }
                        this.executionType = (byte)-1;
                        return n3;
                    }
                    Object var7_7 = null;
                    this.executionType = (byte)-1;
                    return n2;
                }
                Object var7_8 = null;
                this.executionType = (byte)-1;
                return n;
            }
        }
    }

    public DBDataSet getBinds() {
        return this.m_binds;
    }

    public final int getExecuteBatch() {
        return this.batch;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    private void get_data_for_columns(int n) throws SQLException {
        this.binds_in.rowCompleted(this.m_currentRank);
        if (this.binds_out != null) {
            this.binds_out.rowCompleted(this.m_currentRank);
        }
    }

    private boolean isJdbcBatchStyle() {
        return this.m_batchStyle == 2;
    }

    private void printByteArray(byte[] byArray) {
        if (byArray == null) {
            System.out.println("<Null byte array!>");
        } else {
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = byArray[n2] & 0xFF;
                if (n3 < 16) {
                    System.out.print("0" + Integer.toHexString(n3) + " ");
                } else {
                    System.out.print(String.valueOf(Integer.toHexString(n3)) + " ");
                }
                ++n2;
            }
            System.out.println();
        }
    }

    private void privateClose(String string) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.doesJdbcBatchExist()) {
            this.clearBatch();
        } else {
            this.sendBatch();
        }
        if (this.dbstmt != null && this.connection.isStmtCacheEnabled() && this.m_cacheState != OracleStatement.CLOSED && this.m_cacheState != OracleStatement.NON_CACHED) {
            this.connection.cacheStatement(this);
            if (string != null) {
                this.m_key = string;
                this.m_createState = 2;
                return;
            }
            this.m_createState = 1;
        } else {
            super.close();
        }
        if (string == null) {
            this.cleanup();
        }
    }

    void resetFirstRows() {
        if (this.binds_in != null) {
            this.binds_in.setFirstRow(true);
        }
        if (this.binds_out != null) {
            this.binds_out.setFirstRow(true);
        }
    }

    void scrollStmt_cleanup(boolean bl) throws SQLException {
        this.m_binds = null;
        super.scrollStmt_cleanup(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sendBatch() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                if (this.isJdbcBatchStyle()) {
                    return 0;
                }
                this.ensureOpen();
                if (this.m_currentRank <= 0) {
                    if (this.connection.m_accumulateBatchResult) {
                        return 0;
                    }
                    int n = this.valid_rows;
                    return n;
                }
                int n = this.batch;
                try {
                    --this.m_currentRank;
                    if (this.batch != this.m_currentRank) {
                        this.batch = this.m_currentRank;
                        this.need_to_parse = true;
                    }
                    this.doExecuteWithTimeout();
                    return this.valid_rows + (this.connection.m_accumulateBatchResult ? this.premature_batch_count : 0);
                }
                finally {
                    Object var8_13 = null;
                    if (this.batch != n) {
                        this.batch = n;
                        this.need_to_parse = true;
                    }
                }
            }
        }
    }

    public synchronized void setARRAY(int n, ARRAY aRRAY) throws SQLException {
        if (aRRAY == null) {
            DBError.throwSqlException(68);
        }
        if (aRRAY.getDescriptor() == null) {
            DBError.throwSqlException(61);
        }
        int n2 = n - 1;
        this.checkBindTypes(true, n2, 109);
        byte[] byArray = aRRAY.toBytes();
        this.binds_in.setADTBindItem(n2, this.m_currentRank, 109, byArray, aRRAY.getDescriptor().getOracleTypeCOLLECTION());
    }

    public synchronized void setArray(int n, Array array) throws SQLException {
        this.setARRAY(n, (ARRAY)array);
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n3 = n - 1;
            int n4 = 0;
            n4 = this.connection.conversion.isUcs2CharSet() ? this.min_ascii_stream_size / 2 : this.min_ascii_stream_size;
            DBAccess cfr_ignored_0 = this.connection.db_access;
            if (this.sql_kind == 1 || n2 <= n4 || !this.isRegularResultSet()) {
                try {
                    byte[] byArray = new byte[n2];
                    inputStream.read(byArray, 0, n2);
                    byte[] byArray2 = this.connection.conversion.asciiBytesToCHARBytes(byArray);
                    this.setItem(n3, 1, byArray2);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                InputStream inputStream2 = this.connection.conversion.ConvertStream(inputStream, 5, n2);
                this.setStreamItem(n3, 8, inputStream2, n2);
            }
        } else {
            this.setString(n, null);
        }
    }

    public synchronized void setBFILE(int n, BFILE bFILE) throws SQLException {
        this.setDatum(n - 1, 114, bFILE);
    }

    public synchronized void setBLOB(int n, BLOB bLOB) throws SQLException {
        this.setDatum(n - 1, 113, bLOB);
    }

    public synchronized void setBfile(int n, BFILE bFILE) throws SQLException {
        this.setBFILE(n, bFILE);
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.BigDecimalToNumberBytes(bigDecimal);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n3 = n - 1;
            DBAccess cfr_ignored_0 = this.connection.db_access;
            if (this.sql_kind == 1 || n2 <= this.min_binary_stream_size || !this.isRegularResultSet()) {
                try {
                    byte[] byArray = new byte[n2];
                    inputStream.read(byArray, 0, n2);
                    this.setItem(n3, 23, byArray);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                this.setStreamItem(n3, 24, inputStream, n2);
            }
        } else {
            this.setBytes(n, null);
        }
    }

    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        this.setBLOB(n, (BLOB)blob);
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.BooleanToNumberBytes(bl);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.ByteToNumberBytes(by);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        int n2 = n - 1;
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.setItem(n2, 23, byArray2);
        } else {
            this.setItem(n2, 23, (byte[])null);
        }
    }

    public synchronized void setCHAR(int n, CHAR cHAR) throws SQLException {
        int n2 = 1;
        CHAR cHAR2 = cHAR;
        if (cHAR2 != null) {
            short s = (short)cHAR2.getCharacterSet().getOracleId();
            CharacterSet characterSet = this.binds_in != null && this.binds_in.getFormOfUse(n - 1) == 2 ? this.connection.conversion.getAccessNCharSetObj() : this.connection.conversion.getAccessCharSetObj();
            if (characterSet != null && s != characterSet.getOracleId()) {
                byte[] byArray = cHAR2.getBytes();
                cHAR2 = new CHAR(characterSet.convert(cHAR.getCharacterSet(), byArray, 0, byArray.length), characterSet);
            }
        }
        this.setDatum(n - 1, n2, cHAR2);
    }

    public synchronized void setCLOB(int n, CLOB cLOB) throws SQLException {
        this.setDatum(n - 1, 112, cLOB);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.set_execute_batch(1);
        if (reader != null) {
            int n3 = n - 1;
            short s = 2;
            if (this.binds_in != null) {
                s = this.binds_in.getFormOfUse(n3);
            }
            InputStream inputStream = this.connection.conversion.ConvertStream(reader, 7, n2, s);
            int n4 = this.min_ascii_stream_size / this.connection.db_access.getC2SNlsRatio() / this.connection.conversion.getMaxCharbyteSize();
            DBAccess cfr_ignored_0 = this.connection.db_access;
            if (this.sql_kind == 1 || n2 <= n4 || !this.isRegularResultSet()) {
                try {
                    int n5;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    byte[] byArray = new byte[1024];
                    while ((n5 = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n5);
                    }
                    this.setItem(n3, 1, byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                this.setStreamItem(n3, 8, inputStream, n2 * this.connection.conversion.getMaxCharbyteSize());
            }
        } else {
            this.setString(n, null);
        }
    }

    public void setCheckBindTypes(boolean bl) {
        this.check_bind_types = bl;
    }

    public synchronized void setClob(int n, Clob clob) throws SQLException {
        this.setCLOB(n, (CLOB)clob);
    }

    public synchronized void setCursor(int n, ResultSet resultSet) throws SQLException {
        int n2 = n - 1;
        DBAccess dBAccess = this.connection.db_access;
        byte[] byArray = null;
        try {
            byArray = dBAccess.DBStatementToRefCursorBytes(((OracleResultSetImpl)resultSet).statement.dbstmt);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.setItem(n2, 102, byArray);
    }

    public synchronized void setCustomDatum(int n, CustomDatum customDatum) throws SQLException {
        Datum datum = customDatum.toDatum(this.connection);
        this.setOracleObject(n, datum);
    }

    public synchronized void setDATE(int n, DATE dATE) throws SQLException {
        this.setDatum(n - 1, 12, dATE);
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.DateToDateBytes(date);
        this.setItem(n2, 12, byArray);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDATE(n, date == null ? null : new DATE(date, calendar));
    }

    private void setDatum(int n, int n2, Datum datum) throws SQLException {
        if (datum == null) {
            this.setItem(n, n2, (byte[])null);
        } else {
            this.setItem(n, n2, datum.getBytes());
        }
    }

    public synchronized void setDisableStmtCaching(boolean bl) {
        if (bl) {
            this.m_cacheState = OracleStatement.NON_CACHED;
        }
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.DoubleToNumberBytes(d);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setExecuteBatch(int n) throws SQLException {
        this.setOracleBatchStyle();
        this.set_execute_batch(n);
    }

    public synchronized void setFixedCHAR(int n, String string) throws SQLException {
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.StringToCharBytes(string);
        this.setItem(n2, 999, byArray);
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.FloatToNumberBytes(f);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setFormOfUse(int n, short s) {
        this.binds_in.setFormOfUse(n, s);
    }

    public synchronized void setINTERVALYM(int n, INTERVALYM iNTERVALYM) throws SQLException {
        this.setDatum(n - 1, 182, iNTERVALYM);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        int n3 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.IntToNumberBytes(n2);
        this.setItem(n3, 6, byArray);
    }

    public synchronized void setInternalBytes(int n, byte[] byArray, int n2) throws SQLException {
        int n3 = n - 1;
        this.setItem(n3, n2, byArray);
    }

    protected void setItem(int n, int n2, String string) throws SQLException {
        this.checkBindTypes(true, n, n2);
        if (this.binds_in.setBytesBindItem(n, this.m_currentRank, n2, string)) {
            this.need_to_parse = true;
        }
    }

    protected void setItem(int n, int n2, byte[] byArray) throws SQLException {
        this.checkBindTypes(true, n, n2);
        if (this.binds_in.setBytesBindItem(n, this.m_currentRank, n2, byArray)) {
            this.need_to_parse = true;
        }
    }

    protected final void setJdbcBatchStyle() throws SQLException {
        if (this.m_batchStyle == 1) {
            DBError.throwSqlException(90, "operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.LongToNumberBytes(l);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setNUMBER(int n, NUMBER nUMBER) throws SQLException {
        this.setDatum(n - 1, 6, nUMBER);
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        if (n2 == 2002 || n2 == 2008 || n2 == 2003 || n2 == 2007 || n2 == 2006) {
            DBError.throwSqlException(4, "sqlType=" + n2);
        }
        int n3 = n - 1;
        int n4 = this.get_internal_type(n2);
        this.columnSetNull = true;
        this.checkBindTypes(true, n3, n4);
        switch (n4) {
            case 8: {
                n4 = 1;
                break;
            }
            case 24: {
                n4 = 23;
                break;
            }
        }
        this.binds_in.setNullBindItem(n3, this.m_currentRank, n4);
        this.columnSetNull = false;
    }

    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        if (n2 == 2002 || n2 == 2008 || n2 == 2003 || n2 == 2007 || n2 == 2006) {
            int n3 = this.get_internal_type(n2);
            OracleNamedType oracleNamedType = null;
            int n4 = n - 1;
            this.columnSetNull = true;
            this.checkBindTypes(true, n4, n3);
            switch (n2) {
                case 2002: 
                case 2006: 
                case 2008: {
                    StructDescriptor structDescriptor = StructDescriptor.createDescriptor(string, this.connection);
                    oracleNamedType = structDescriptor.getOracleTypeADT();
                    break;
                }
                case 2003: {
                    ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(string, this.connection);
                    oracleNamedType = arrayDescriptor.getOracleTypeCOLLECTION();
                    break;
                }
                case 2007: {
                    OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(string, this.connection);
                    oracleNamedType = opaqueDescriptor.getPickler();
                    break;
                }
                default: {
                    DBError.throwSqlException(1);
                }
            }
            this.binds_in.setNullADTBindItem(n4, this.m_currentRank, n3, oracleNamedType);
        } else {
            this.setNull(n, n2);
        }
        this.columnSetNull = false;
    }

    public synchronized void setOPAQUE(int n, OPAQUE oPAQUE) throws SQLException {
        int n2 = n - 1;
        if (oPAQUE == null) {
            DBError.throwSqlException(68);
        }
        if (oPAQUE.getDescriptor() == null) {
            DBError.throwSqlException(61);
        }
        this.checkBindTypes(true, n2, 109);
        byte[] byArray = oPAQUE.toBytes();
        this.binds_in.setADTBindItem(n2, this.m_currentRank, 109, byArray, (OracleTypeOPAQUE)oPAQUE.getDescriptor().getPickler());
    }

    public synchronized void setORAData(int n, ORAData oRAData) throws SQLException {
        Datum datum = oRAData.toDatum(this.connection);
        this.setOracleObject(n, datum);
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        if (object instanceof ORAData) {
            this.setORAData(n, (ORAData)object);
        } else if (object instanceof CustomDatum) {
            this.setCustomDatum(n, (CustomDatum)object);
        } else {
            int n2 = this.sqlTypeForObject(object);
            this.setObject(n, object, n2, 0);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null && n2 != 2002 && n2 != 2008 && n2 != 2003 && n2 != 2007 && n2 != 2006) {
            this.setNull(n, n2);
        } else {
            switch (n2) {
                case 1: {
                    if (object instanceof CHAR) {
                        this.setCHAR(n, (CHAR)object);
                        break;
                    }
                    if (object instanceof String) {
                        this.setString(n, (String)object);
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setString(n, String.valueOf((Boolean)object != false ? 1 : 0));
                        break;
                    }
                    if (object instanceof Integer) {
                        this.setString(n, String.valueOf((Integer)object));
                        break;
                    }
                    if (object instanceof Long) {
                        this.setString(n, String.valueOf((Long)object));
                        break;
                    }
                    if (object instanceof Float) {
                        this.setString(n, String.valueOf(((Float)object).floatValue()));
                        break;
                    }
                    if (object instanceof Double) {
                        this.setString(n, String.valueOf((Double)object));
                        break;
                    }
                    if (object instanceof BigDecimal) {
                        this.setString(n, ((BigDecimal)object).toString());
                        break;
                    }
                    if (object instanceof Date) {
                        this.setString(n, String.valueOf(((Date)object).toString()));
                        break;
                    }
                    if (object instanceof Time) {
                        this.setString(n, String.valueOf(((Time)object).toString()));
                        break;
                    }
                    if (object instanceof Timestamp) {
                        this.setString(n, String.valueOf(((Timestamp)object).toString()));
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case 12: {
                    if (object instanceof String) {
                        this.setString(n, (String)object);
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setString(n, String.valueOf((Boolean)object != false ? 1 : 0));
                        break;
                    }
                    if (object instanceof Integer) {
                        this.setString(n, String.valueOf((Integer)object));
                        break;
                    }
                    if (object instanceof Long) {
                        this.setString(n, String.valueOf((Long)object));
                        break;
                    }
                    if (object instanceof Float) {
                        this.setString(n, String.valueOf(((Float)object).floatValue()));
                        break;
                    }
                    if (object instanceof Double) {
                        this.setString(n, String.valueOf((Double)object));
                        break;
                    }
                    if (object instanceof BigDecimal) {
                        this.setString(n, ((BigDecimal)object).toString());
                        break;
                    }
                    if (object instanceof Date) {
                        this.setString(n, String.valueOf(((Date)object).toString()));
                        break;
                    }
                    if (object instanceof Time) {
                        this.setString(n, String.valueOf(((Time)object).toString()));
                        break;
                    }
                    if (object instanceof Timestamp) {
                        this.setString(n, String.valueOf(((Timestamp)object).toString()));
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case 999: {
                    this.setFixedCHAR(n, (String)object);
                    break;
                }
                case -1: {
                    if (object instanceof String) {
                        this.setString(n, (String)object);
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setString(n, String.valueOf((Boolean)object != false ? 1 : 0));
                        break;
                    }
                    if (object instanceof Integer) {
                        this.setString(n, String.valueOf((Integer)object));
                        break;
                    }
                    if (object instanceof Long) {
                        this.setString(n, String.valueOf((Long)object));
                        break;
                    }
                    if (object instanceof Float) {
                        this.setString(n, String.valueOf(((Float)object).floatValue()));
                        break;
                    }
                    if (object instanceof Double) {
                        this.setString(n, String.valueOf((Double)object));
                        break;
                    }
                    if (object instanceof BigDecimal) {
                        this.setString(n, ((BigDecimal)object).toString());
                        break;
                    }
                    if (object instanceof Date) {
                        this.setString(n, String.valueOf(((Date)object).toString()));
                        break;
                    }
                    if (object instanceof Time) {
                        this.setString(n, String.valueOf(((Time)object).toString()));
                        break;
                    }
                    if (object instanceof Timestamp) {
                        this.setString(n, String.valueOf(((Timestamp)object).toString()));
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case 2: {
                    if (object instanceof NUMBER) {
                        this.setNUMBER(n, (NUMBER)object);
                        break;
                    }
                    if (object instanceof Integer) {
                        this.setInt(n, (Integer)object);
                        break;
                    }
                    if (object instanceof Long) {
                        this.setLong(n, (Long)object);
                        break;
                    }
                    if (object instanceof Float) {
                        this.setFloat(n, ((Float)object).floatValue());
                        break;
                    }
                    if (object instanceof Double) {
                        this.setDouble(n, (Double)object);
                        break;
                    }
                    if (object instanceof BigDecimal) {
                        this.setBigDecimal(n, (BigDecimal)object);
                        break;
                    }
                    if (object instanceof String) {
                        this.setNUMBER(n, new NUMBER((String)object, 0));
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setInt(n, (Boolean)object != false ? 1 : 0);
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case 3: {
                    if (object instanceof BigDecimal) {
                        this.setBigDecimal(n, (BigDecimal)object);
                        break;
                    }
                    if (object instanceof Number) {
                        this.setBigDecimal(n, new BigDecimal(((Number)object).doubleValue()));
                        break;
                    }
                    if (object instanceof NUMBER) {
                        this.setBigDecimal(n, ((NUMBER)object).bigDecimalValue());
                        break;
                    }
                    if (object instanceof String) {
                        this.setBigDecimal(n, new BigDecimal((String)object));
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setBigDecimal(n, new BigDecimal((Boolean)object != false ? 1.0 : 0.0));
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case -7: {
                    if (object instanceof Boolean) {
                        this.setByte(n, (byte)((Boolean)object != false ? 1 : 0));
                        break;
                    }
                    if (object instanceof String) {
                        this.setByte(n, (byte)(new Boolean((String)object) != false ? 1 : 0));
                        break;
                    }
                    if (object instanceof Number) {
                        this.setInt(n, ((Number)object).byteValue() != 0 ? 1 : 0);
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case -6: {
                    if (object instanceof Number) {
                        this.setByte(n, ((Number)object).byteValue());
                        break;
                    }
                    if (object instanceof String) {
                        this.setByte(n, Byte.parseByte((String)object));
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setByte(n, (byte)((Boolean)object != false ? 1 : 0));
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case 5: {
                    if (object instanceof Number) {
                        this.setShort(n, ((Number)object).shortValue());
                        break;
                    }
                    if (object instanceof String) {
                        this.setShort(n, Short.parseShort((String)object));
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setShort(n, (short)((Boolean)object != false ? 1 : 0));
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case 4: {
                    if (object instanceof Number) {
                        this.setInt(n, ((Number)object).intValue());
                        break;
                    }
                    if (object instanceof String) {
                        this.setInt(n, Integer.parseInt((String)object));
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setInt(n, (Boolean)object != false ? 1 : 0);
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case -5: {
                    if (object instanceof Number) {
                        this.setLong(n, ((Number)object).longValue());
                        break;
                    }
                    if (object instanceof String) {
                        this.setLong(n, Long.parseLong((String)object));
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setLong(n, (Boolean)object != false ? 1L : 0L);
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case 7: {
                    if (object instanceof Number) {
                        this.setFloat(n, ((Number)object).floatValue());
                        break;
                    }
                    if (object instanceof String) {
                        this.setFloat(n, Float.valueOf((String)object).floatValue());
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setFloat(n, (Boolean)object != false ? 1.0f : 0.0f);
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case 6: 
                case 8: {
                    if (object instanceof Number) {
                        this.setDouble(n, ((Number)object).doubleValue());
                        break;
                    }
                    if (object instanceof String) {
                        this.setDouble(n, Double.valueOf((String)object));
                        break;
                    }
                    if (object instanceof Boolean) {
                        this.setDouble(n, (Boolean)object != false ? 1.0 : 0.0);
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case -2: {
                    if (object instanceof RAW) {
                        this.setRAW(n, (RAW)object);
                        break;
                    }
                    this.setBytes(n, (byte[])object);
                    break;
                }
                case -3: {
                    this.setBytes(n, (byte[])object);
                    break;
                }
                case -4: {
                    this.setBytes(n, (byte[])object);
                    break;
                }
                case 91: {
                    if (object instanceof DATE) {
                        this.setDATE(n, (DATE)object);
                        break;
                    }
                    if (object instanceof Date) {
                        this.setDate(n, (Date)object);
                        break;
                    }
                    if (object instanceof Timestamp) {
                        this.setTimestamp(n, (Timestamp)object);
                        break;
                    }
                    if (object instanceof String) {
                        this.setDate(n, Date.valueOf((String)object));
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case 92: {
                    if (object instanceof Time) {
                        this.setTime(n, (Time)object);
                        break;
                    }
                    if (object instanceof Timestamp) {
                        this.setTime(n, new Time(((java.util.Date)((Timestamp)object)).getTime()));
                        break;
                    }
                    if (object instanceof Date) {
                        this.setTime(n, new Time(((Date)object).getTime()));
                        break;
                    }
                    if (object instanceof String) {
                        this.setTime(n, Time.valueOf((String)object));
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case 93: {
                    if (object instanceof TIMESTAMP) {
                        this.setTIMESTAMP(n, (TIMESTAMP)object);
                        break;
                    }
                    if (object instanceof Timestamp) {
                        this.setTimestamp(n, (Timestamp)object);
                        break;
                    }
                    if (object instanceof Date) {
                        this.setDate(n, (Date)object);
                        break;
                    }
                    if (object instanceof DATE) {
                        this.setDATE(n, (DATE)object);
                        break;
                    }
                    if (object instanceof String) {
                        this.setTimestamp(n, Timestamp.valueOf((String)object));
                        break;
                    }
                    DBError.throwSqlException(132);
                    break;
                }
                case -100: {
                    this.setTIMESTAMP(n, (TIMESTAMP)object);
                    break;
                }
                case -101: {
                    this.setTIMESTAMPTZ(n, (TIMESTAMPTZ)object);
                    break;
                }
                case -102: {
                    this.setTIMESTAMPLTZ(n, (TIMESTAMPLTZ)object);
                    break;
                }
                case -103: {
                    this.setINTERVALYM(n, (INTERVALYM)object);
                    break;
                }
                case -8: {
                    this.setROWID(n, (ROWID)object);
                    break;
                }
                case 2004: {
                    this.setBLOB(n, (BLOB)object);
                    break;
                }
                case 2005: {
                    this.setCLOB(n, (CLOB)object);
                    break;
                }
                case -13: {
                    this.setBFILE(n, (BFILE)object);
                    break;
                }
                case -10: {
                    this.setCursor(n, (OracleResultSet)object);
                    break;
                }
                case 2002: 
                case 2008: {
                    this.setSTRUCT(n, STRUCT.toSTRUCT(object, this.connection));
                    break;
                }
                case 2003: {
                    this.setARRAY(n, (ARRAY)object);
                    break;
                }
                case 2007: {
                    this.setOPAQUE(n, (OPAQUE)object);
                    break;
                }
                case 2006: {
                    this.setREF(n, (REF)object);
                    break;
                }
                default: {
                    DBError.throwSqlException(4);
                }
            }
        }
    }

    protected final void setOracleBatchStyle() throws SQLException {
        if (this.m_batchStyle == 2) {
            DBError.throwSqlException(90, "operation cannot be mixed with JDBC-2.0-style batching");
        }
        this.m_batchStyle = 1;
    }

    public synchronized void setOracleObject(int n, Datum datum) throws SQLException {
        this.setObject(n, datum);
    }

    public synchronized void setPlsqlIndexTable(int n, Object object, int n2, int n3, int n4, int n5) throws SQLException {
        if (n2 < 0 || n3 < 0 || n2 < n3) {
            DBError.throwSqlException(68, "maxLen < 0, curLen < 0 or maxLen < curLen ");
        }
        int n6 = this.get_internal_type(n4);
        this.checkPlsqlIndexTableBindTypes(true, n - 1, n2, n6, n5);
        Datum[] datumArray = null;
        switch (n6) {
            case 1: 
            case 96: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.connection);
                datumArray = oracleTypeCHAR.toDatumArray(object, this.connection, 1L, n3);
                break;
            }
            case 2: 
            case 6: {
                datumArray = OracleTypeNUMBER.toNUMBERArray(object, this.connection, 1L, n3);
                break;
            }
            default: {
                DBError.throwSqlException(97);
                return;
            }
        }
        this.need_to_parse = this.binds_in.setPlsqlIndexTableItem(n - 1, this.m_currentRank, datumArray, n2, n3, n6, n5);
    }

    public synchronized void setPreBindsCompelete() throws SQLException {
        this.binds_in.setFirstRow(false);
    }

    public synchronized void setRAW(int n, RAW rAW) throws SQLException {
        this.setDatum(n - 1, 23, rAW);
    }

    public synchronized void setREF(int n, REF rEF) throws SQLException {
        if (rEF == null) {
            DBError.throwSqlException(68);
        }
        if (rEF.getDescriptor() == null) {
            DBError.throwSqlException(52);
        }
        int n2 = n - 1;
        this.checkBindTypes(true, n2, 111);
        byte[] byArray = rEF.getBytes();
        this.binds_in.setADTBindItem(n2, this.m_currentRank, 111, byArray, rEF.getDescriptor().getOracleTypeADT());
    }

    public synchronized void setROWID(int n, ROWID rOWID) throws SQLException {
        this.setDatum(n - 1, 104, rOWID);
    }

    public synchronized void setRef(int n, Ref ref) throws SQLException {
        this.setREF(n, (REF)ref);
    }

    public void setRefType(int n, REF rEF) throws SQLException {
        this.setREF(n, rEF);
    }

    public synchronized void setSTRUCT(int n, STRUCT sTRUCT) throws SQLException {
        StructDescriptor structDescriptor;
        int n2 = n - 1;
        if (sTRUCT == null) {
            DBError.throwSqlException(68);
        }
        if ((structDescriptor = sTRUCT.getDescriptor()) == null) {
            DBError.throwSqlException(61);
        }
        this.checkBindObjectTypes(true, n2, 109, structDescriptor);
        byte[] byArray = sTRUCT.toBytes();
        this.binds_in.setADTBindItem(n2, this.m_currentRank, 109, byArray, structDescriptor.getOracleTypeADT());
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.ShortToNumberBytes(s);
        this.setItem(n2, 6, byArray);
    }

    protected void setStreamItem(int n, int n2, InputStream inputStream, int n3) throws SQLException {
        if (n3 < 0) {
            DBError.throwSqlException(43);
        }
        this.checkBindTypes(true, n, n2);
        this.binds_in.setStreamBindItem(n, this.m_currentRank, n2, inputStream, n3);
    }

    public synchronized void setString(int n, String string) throws SQLException {
        int n2 = n - 1;
        boolean bl = this.connection.getProtocolType().equals("thin");
        boolean bl2 = false;
        if (this.binds_in != null) {
            boolean bl3 = bl2 = this.binds_in.getFormOfUse(n - 1) == 2;
        }
        if (bl) {
            this.setItem(n2, 1, string);
        } else {
            byte[] byArray = null;
            byArray = bl2 ? this.connection.conversion.StringToNCharBytes(string) : this.connection.conversion.StringToCharBytes(string);
            this.setItem(n2, 1, byArray);
        }
    }

    public synchronized void setStructDescriptor(int n, StructDescriptor structDescriptor) throws SQLException {
        int n2 = n - 1;
        if (structDescriptor == null) {
            DBError.throwSqlException(68);
        }
        this.checkBindTypes(true, n2, 109);
        this.binds_in.setADTBindType(n2, this.m_currentRank, 109, structDescriptor.getOracleTypeADT());
    }

    public synchronized void setTIMESTAMP(int n, TIMESTAMP tIMESTAMP) throws SQLException {
        this.setDatum(n - 1, 180, tIMESTAMP);
    }

    public synchronized void setTIMESTAMPLTZ(int n, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        if (this.connection.getSessionTimeZone() == null) {
            DBError.throwSqlException(105);
        }
        this.setDatum(n - 1, 231, tIMESTAMPLTZ);
    }

    public synchronized void setTIMESTAMPTZ(int n, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.setDatum(n - 1, 181, tIMESTAMPTZ);
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.TimeToDateBytes(time);
        this.setItem(n2, 12, byArray);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setDATE(n, time == null ? null : new DATE(time, calendar));
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.TimestampToDateBytes(timestamp);
        this.setItem(n2, 12, byArray);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setDATE(n, timestamp == null ? null : new DATE(timestamp, calendar));
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n3 = n - 1;
            InputStream inputStream2 = this.connection.conversion.ConvertStream(inputStream, 4, n2);
            int n4 = 2 * (this.min_ascii_stream_size / this.connection.db_access.getC2SNlsRatio()) / this.connection.conversion.getMaxCharbyteSize();
            DBAccess cfr_ignored_0 = this.connection.db_access;
            if (this.sql_kind == 1 || n2 <= n4 || !this.isRegularResultSet()) {
                try {
                    int n5;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    byte[] byArray = new byte[1024];
                    while ((n5 = inputStream2.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n5);
                    }
                    this.setItem(n3, 1, byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                this.setStreamItem(n3, 8, inputStream2, n2 * this.connection.conversion.getMaxCharbyteSize());
            }
        } else {
            this.setString(n, null);
        }
    }

    private synchronized void set_execute_batch(int n) throws SQLException {
        if (n <= 0) {
            DBError.throwSqlException(42);
        }
        if (n == this.batch) {
            return;
        }
        this.batch = n;
        if (this.m_currentRank > 0) {
            this.sendBatch();
        }
        this.binds_in.setBatchSize(n);
        this.need_to_parse = true;
    }

    int sqlTypeForObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Datum)) {
            if (object instanceof String) {
                return this.fixedString ? 999 : 12;
            }
            if (object instanceof BigDecimal) {
                return 2;
            }
            if (object instanceof Boolean) {
                return -7;
            }
            if (object instanceof Integer) {
                return 4;
            }
            if (object instanceof Long) {
                return -5;
            }
            if (object instanceof Float) {
                return 6;
            }
            if (object instanceof Double) {
                return 8;
            }
            if (object instanceof byte[]) {
                return -3;
            }
            if (object instanceof Date) {
                return 91;
            }
            if (object instanceof Time) {
                return 92;
            }
            if (object instanceof Timestamp) {
                return 93;
            }
            if (object instanceof SQLData) {
                return 2002;
            }
            if (object instanceof ObjectData) {
                return 2002;
            }
        } else {
            if (object instanceof BLOB) {
                return 2004;
            }
            if (object instanceof CLOB) {
                return 2005;
            }
            if (object instanceof BFILE) {
                return -13;
            }
            if (object instanceof ROWID) {
                return -8;
            }
            if (object instanceof NUMBER) {
                return 2;
            }
            if (object instanceof DATE) {
                return 91;
            }
            if (object instanceof TIMESTAMP) {
                return -100;
            }
            if (object instanceof TIMESTAMPTZ) {
                return -101;
            }
            if (object instanceof TIMESTAMPLTZ) {
                return -102;
            }
            if (object instanceof REF) {
                return 2006;
            }
            if (object instanceof CHAR) {
                return 1;
            }
            if (object instanceof RAW) {
                return -2;
            }
            if (object instanceof ARRAY) {
                return 2003;
            }
            if (object instanceof STRUCT) {
                return 2002;
            }
            if (object instanceof OPAQUE) {
                return 2007;
            }
            if (object instanceof INTERVALYM) {
                return -103;
            }
        }
        return 1111;
    }
}

