/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oci8;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBDataSetImpl;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oci.OracleOCIConnection;
import oracle.jdbc.oci8.OCIDBDataSet;
import oracle.jdbc.oci8.OCIDBError;
import oracle.jdbc.oci8.OCIDBItem;
import oracle.jdbc.oci8.OCIDBStatement;
import oracle.jdbc.oci8.OCIDBType;
import oracle.jdbc.oci8.OCIEnv;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.SQLName;

public class OCIDBAccess
extends DBAccess {
    boolean new_connection;
    Properties dbinfo = new Properties();
    DBConversion conversion;
    DBData[] curr_out_values;
    DBType[] curr_out_types;
    int start_index;
    int end_index;
    short char_set;
    short db_char_set;
    short db_nchar_set;
    short version_num;
    short m_pointerSize = 0;
    int m_c2s_nls_ratio;
    int m_s2c_nls_ratio;
    int logon_mode;
    long OCIEnvHandle;
    long c_state = 0L;
    OracleOCIFailover m_appCbk = null;
    Object m_cbkObj = null;
    Connection m_conn = null;
    private static boolean loaded_library = false;
    static final int EOJ_LOGON_MODE_DEFAULT = 0;
    static final int EOJ_LOGON_MODE_SYSDBA = 2;
    static final int EOJ_LOGON_MODE_SYSOPER = 4;
    public static final int EOJ_LOGON_MODE_CONNECTION_POOL = 5;
    public static final int EOJ_LOGON_MODE_CONNPOOL_CONNECTION = 6;
    public static final int EOJ_LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
    public static final int EOJ_LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
    static final int EOJ_SUCCESS = 0;
    static final int EOJ_ERROR = -1;
    static final int EOJ_CLOSED_CONNECTION = -8;
    static final int EOJ_CLOSED_STATEMENT = -9;
    static final int WARN_SUCCESS_WITH_INFO = -93;

    public synchronized byte[] DBStatementToRefCursorBytes(DBStatement dBStatement) throws SQLException {
        return this.get_cursor_bytes((OCIDBStatement)dBStatement);
    }

    public synchronized DBStatement RefCursorBytesToDBStatement(byte[] byArray) throws SQLException {
        OCIDBStatement oCIDBStatement = new OCIDBStatement(this);
        this.make_statement(oCIDBStatement, byArray);
        int n = this.get_column_count(oCIDBStatement);
        try {
            this.check_error(n, oCIDBStatement);
        }
        catch (SQLException sQLException) {
            this.close(oCIDBStatement);
            throw sQLException;
        }
        return oCIDBStatement;
    }

    public synchronized void archive(int n, int n2, String string) throws SQLException {
        int n3 = string.length();
        byte[] byArray = new byte[n3];
        string.getBytes(0, n3, byArray, 0);
        this.check_error(this.archive_db(n, n2, byArray, n3), null);
    }

    native int archive_db(int var1, int var2, byte[] var3, int var4);

    native int bfile_close(byte[] var1, int var2, byte[] var3, int var4);

    native int bfile_exists(byte[] var1, int var2);

    native String bfile_getDirAlias(byte[] var1, int var2);

    native String bfile_getName(byte[] var1, int var2);

    native int bfile_isOpen(byte[] var1, int var2);

    native int bfile_open(byte[] var1, int var2, byte[] var3, int var4);

    private long blobRead(byte[] byArray, long l, long l2, byte[] byArray2) throws SQLException {
        int n = 0;
        n = this.blob_read(byArray, byArray.length, (int)l, (int)l2, byArray2, byArray2.length);
        this.check_error(n, null);
        return n;
    }

    private long blobWrite(byte[] byArray, long l, byte[] byArray2, byte[] byArray3) throws SQLException {
        int n = 0;
        int n2 = byArray2.length;
        n = this.blob_write(byArray, byArray.length, (int)l, n2, byArray2, byArray3, byArray3.length);
        this.check_error(n, null);
        return n;
    }

    native int blob_read(byte[] var1, int var2, int var3, int var4, byte[] var5, int var6);

    native int blob_write(byte[] var1, int var2, int var3, int var4, byte[] var5, byte[] var6, int var7);

    public synchronized int callTAFCallbackMethod(int n, int n2) {
        int n3 = 0;
        if (this.m_appCbk != null) {
            n3 = this.m_appCbk.callbackFn(this.m_conn, this.m_cbkObj, n, n2);
        }
        return n3;
    }

    public void cancel() throws SQLException {
        this.check_error(this.conn_cancel(), null);
    }

    int check_error(int n, OCIDBStatement oCIDBStatement) throws SQLException {
        if (n >= 0) {
            return n;
        }
        this.free_temp_alloc();
        switch (n) {
            case -93: 
            case -1: {
                Object object;
                String string;
                OCIDBError oCIDBError = new OCIDBError();
                this.describe_error(oCIDBStatement, oCIDBError);
                byte[] byArray = oCIDBError.reason;
                String string2 = this.conversion.CharBytesToString(byArray, byArray.length);
                if (oCIDBError.SQLState == null || oCIDBError.SQLState.length == 0) {
                    string = DBError.ErrorToSQLState(oCIDBError.vendorCode);
                } else {
                    object = oCIDBError.SQLState;
                    string = this.conversion.CharBytesToString((byte[])object, ((byte[])object).length);
                }
                if (n == -1) {
                    DBError.throwSqlException(string2, string, oCIDBError.vendorCode);
                    break;
                }
                object = DBError.newSqlWarning(string2, string, oCIDBError.vendorCode);
                throw object;
            }
            default: {
                DBError.throwSqlException(-1 * n, oCIDBStatement);
            }
        }
        return 0;
    }

    private long clobRead(byte[] byArray, long l, long l2, char[] cArray, boolean bl) throws SQLException {
        int n = 0;
        n = this.clob_read(byArray, byArray.length, (int)l, (int)l2, cArray, cArray.length, bl, bl ? this.db_nchar_set : (short)0);
        this.check_error(n, null);
        return n;
    }

    private int clobWrite(byte[] byArray, long l, char[] cArray, byte[] byArray2, boolean bl) throws SQLException {
        int n = 0;
        int n2 = cArray.length;
        n = this.clob_write(byArray, byArray.length, (int)l, n2, cArray, byArray2, byArray2.length, bl, bl ? this.db_nchar_set : (short)0);
        this.check_error(n, null);
        return n;
    }

    native int clob_read(byte[] var1, int var2, int var3, int var4, char[] var5, int var6, boolean var7, int var8);

    native int clob_write(byte[] var1, int var2, int var3, int var4, char[] var5, byte[] var6, int var7, boolean var8, int var9);

    public synchronized void close(DBStatement dBStatement) throws SQLException {
        this.trace("DBAccess.close");
        ((OCIDBStatement)dBStatement).binds_initialized = false;
        ((OCIDBStatement)dBStatement).defines_initialized = false;
        this.check_error(this.close_stmt((OCIDBStatement)dBStatement), (OCIDBStatement)dBStatement);
    }

    public synchronized void closeLob(Connection connection, Datum datum, int n) throws SQLException {
        byte[] byArray = null;
        if (datum == null || (byArray = datum.shareBytes()) == null) {
            DBError.throwSqlException(54);
        }
        DBType dBType = null;
        switch (n) {
            case 2004: {
                dBType = this.createDBType(113, false);
                break;
            }
            case 2005: {
                dBType = this.createDBType(112, false);
                break;
            }
            case -13: {
                dBType = this.createDBType(114, false);
                break;
            }
            default: {
                return;
            }
        }
        byte[] byArray2 = new byte[dBType.max_length];
        this.check_error(this.lob_close(n, byArray, byArray.length, byArray2, byArray2.length), null);
        datum.setShareBytes(byArray2);
    }

    public synchronized void closeQuery(DBStatement dBStatement) throws SQLException, IOException {
        this.trace("DBAccess.closeQuery");
        this.check_error(this.close_query((OCIDBStatement)dBStatement), (OCIDBStatement)dBStatement);
    }

    native int close_query(OCIDBStatement var1);

    native int close_stmt(OCIDBStatement var1);

    public synchronized void commit() throws SQLException, IOException {
        this.trace("DBAccess.commit");
        this.check_error(this.do_commit(), null);
    }

    native int conn_cancel();

    void copy_back_to_next_stream(OCIDBStatement oCIDBStatement, int n) throws SQLException {
        if (this.curr_out_types != null) {
            this.end_index = this.start_index;
            while (this.end_index < this.curr_out_types.length) {
                if (this.curr_out_types[this.end_index] != null) {
                    int n2;
                    DBItem dBItem;
                    if (n > 0) {
                        int n3 = 0;
                        while (n3 < n) {
                            dBItem = this.curr_out_values[this.end_index].getItem(n3);
                            n2 = 0;
                            if (dBItem.byte_value != null) {
                                n2 = dBItem.byte_value.length;
                            }
                            this.copy_value_from_defines(oCIDBStatement, this.end_index, n3, dBItem, n2);
                            ++n3;
                        }
                    } else {
                        dBItem = this.curr_out_values[this.end_index].getItem(0);
                        n2 = 0;
                        if (dBItem.byte_value != null) {
                            n2 = dBItem.byte_value.length;
                        }
                        this.copy_value_from_defines(oCIDBStatement, this.end_index, 0, dBItem, n2);
                        if (this.curr_out_types[this.end_index].is_stream) {
                            return;
                        }
                    }
                }
                ++this.end_index;
            }
        }
    }

    void copy_back_to_next_stream_from_binds(OCIDBStatement oCIDBStatement) throws SQLException {
        if (this.curr_out_types != null) {
            this.end_index = this.start_index;
            while (this.end_index < this.curr_out_types.length) {
                if (this.curr_out_types[this.end_index] != null) {
                    DBItem dBItem = this.curr_out_values[this.end_index].getItem(0);
                    int n = 0;
                    if (dBItem.byte_value != null) {
                        n = dBItem.byte_value.length;
                    }
                    this.copy_value_from_binds(oCIDBStatement, this.end_index, 0, dBItem, n, this.end_index == this.curr_out_types.length - 1);
                    if (this.curr_out_types[this.end_index].is_stream) {
                        return;
                    }
                }
                ++this.end_index;
            }
        }
    }

    native void copy_value_from_binds(OCIDBStatement var1, int var2, int var3, DBItem var4, int var5, boolean var6);

    native void copy_value_from_defines(OCIDBStatement var1, int var2, int var3, DBItem var4, int var5);

    public DBDataSet createDBDataSet(OracleConnection oracleConnection, OracleStatement oracleStatement, int n, int n2) {
        return new OCIDBDataSet(oracleConnection, oracleStatement, n, n2, this.version_num);
    }

    public DBItem createDBItem(DBType dBType) {
        if (dBType.type == 998) {
            return new OCIDBItem();
        }
        return new DBItem(dBType.max_length);
    }

    public DBType createDBType(int n, boolean bl) {
        if (n == 102) {
            return new OCIDBType(this, n, this.get_cursor_size(), this.version_num, bl);
        }
        switch (n) {
            case 104: {
                return new OCIDBType(this, 104, 4096, this.version_num, bl);
            }
            case 112: 
            case 113: 
            case 114: {
                return new OCIDBType(this, n, 1024, this.version_num, bl);
            }
        }
        return new OCIDBType(this, n, this.version_num, bl);
    }

    public synchronized DBType createDBType(int n, boolean bl, boolean bl2) throws SQLException {
        DBType dBType = this.createDBType(n, true);
        if (bl2 && !bl) {
            dBType.setPlsqlMaxLength();
        }
        return dBType;
    }

    public synchronized Datum createTemporaryLob(Connection connection, boolean bl, int n, int n2) throws SQLException {
        Datum datum = null;
        DBType dBType = null;
        switch (n2) {
            case 2004: {
                dBType = this.createDBType(113, false);
                datum = new BLOB((OracleConnection)connection);
                break;
            }
            case 2005: {
                dBType = this.createDBType(112, false);
                datum = new CLOB((OracleConnection)connection);
                break;
            }
            case -13: {
                dBType = this.createDBType(114, false);
                datum = new BFILE((OracleConnection)connection);
                break;
            }
            default: {
                return null;
            }
        }
        byte[] byArray = new byte[dBType.max_length];
        this.check_error(this.lob_createTemporary(n2, bl, n, byArray, byArray.length), null);
        datum.setShareBytes(byArray);
        return datum;
    }

    native int create_stmt_c_copy(OCIDBStatement var1, byte[] var2);

    public static Connection defaultConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:oracle:oci8:@", "scott", "tiger");
    }

    public synchronized DBColumn[] describe(DBStatement dBStatement) throws SQLException, IOException {
        int n = this.get_column_count((OCIDBStatement)dBStatement);
        this.check_error(n, (OCIDBStatement)dBStatement);
        DBColumn[] dBColumnArray = new DBColumn[n];
        this.trace("describe");
        ((OCIDBStatement)dBStatement).defines_initialized = false;
        int n2 = 0;
        while (n2 < dBColumnArray.length) {
            dBColumnArray[n2] = new DBColumn();
            byte[] byArray = this.get_describe((OCIDBStatement)dBStatement, dBColumnArray[n2], n2 + 1);
            if (byArray != null) {
                this.enterColumnName(byArray, dBColumnArray[n2]);
            } else {
                this.check_error(-1, (OCIDBStatement)dBStatement);
            }
            ++n2;
        }
        return dBColumnArray;
    }

    native void describe_error(OCIDBStatement var1, OCIDBError var2);

    native int do_commit();

    native int do_execute(OCIDBStatement var1, int var2);

    native int do_fetch(OCIDBStatement var1, int var2, int var3);

    native int do_open(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, int var11, Object var12);

    native int do_parse(OCIDBStatement var1, byte[] var2);

    native int do_read(OCIDBStatement var1, byte[] var2, int var3, int var4);

    native int do_rollback();

    void enterColumnName(byte[] byArray, DBColumn dBColumn) throws SQLException {
        dBColumn.name = this.conversion.CharBytesToString(byArray, byArray.length);
    }

    public synchronized int executeFetch(DBStatement dBStatement, byte by, DBDataSet dBDataSet, int n, DBDataSet dBDataSet2, int n2) throws SQLException, IOException {
        Object object;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        this.trace("executeFetch");
        DBType[] dBTypeArray = null;
        DBData[] dBDataArray = null;
        DBType[] dBTypeArray2 = null;
        DBData[] dBDataArray2 = null;
        if (dBDataSet != null) {
            dBTypeArray = ((DBDataSetImpl)dBDataSet).getDBTypes();
            dBDataArray = ((DBDataSetImpl)dBDataSet).getDBData();
        }
        if (dBDataSet2 != null) {
            dBTypeArray2 = ((DBDataSetImpl)dBDataSet2).getDBTypes();
            dBDataArray2 = ((DBDataSetImpl)dBDataSet2).getDBData();
        }
        int n9 = dBTypeArray != null ? dBTypeArray.length : 0;
        if (dBTypeArray2 != null) {
            this.curr_out_values = dBDataArray2;
            this.curr_out_types = dBTypeArray2;
            this.start_index = 0;
            this.end_index = 0;
            n5 = dBTypeArray2.length;
        } else {
            n5 = 0;
        }
        n7 = n9 < n5 ? n5 : n9;
        if (by == 1) {
            if (!((OCIDBStatement)dBStatement).binds_initialized) {
                this.check_error(this.initialize_bind_columns((OCIDBStatement)dBStatement, n7, n), null);
            }
            n4 = 0;
            while (n4 < n7) {
                if (n4 < n9 && n4 < n5) {
                    if (dBDataArray[n4] != null) {
                        if (dBDataArray2[n4] == null) {
                            if (!((OCIDBStatement)dBStatement).binds_initialized) {
                                this.check_error(this.set_up_bind_column((OCIDBStatement)dBStatement, n4, dBTypeArray[n4], n, (byte)1, by, this.getTDOPtr(dBTypeArray[n4])), (OCIDBStatement)dBStatement);
                            }
                            n3 = 0;
                            while (n3 < n) {
                                object = dBDataArray[n4].getItem(n3);
                                int n10 = 0;
                                if (object != null) {
                                    n10 = ((DBItem)object).getBytesLength();
                                }
                                this.check_error(this.set_up_bind_rows((OCIDBStatement)dBStatement, n4, n3, (DBItem)object, n10), (OCIDBStatement)dBStatement);
                                ++n3;
                            }
                        } else {
                            object = dBTypeArray[n4];
                            if (dBTypeArray[n4].type == dBTypeArray2[n4].type && dBTypeArray[n4].max_length < dBTypeArray2[n4].max_length) {
                                object = dBTypeArray2[n4];
                            }
                            if (!((OCIDBStatement)dBStatement).binds_initialized) {
                                this.check_error(this.set_up_bind_column((OCIDBStatement)dBStatement, n4, (DBType)object, n, (byte)17, by, this.getTDOPtr((DBType)object)), (OCIDBStatement)dBStatement);
                            }
                            n3 = 0;
                            while (n3 < n) {
                                DBItem dBItem = dBDataArray[n4].getItem(n3);
                                int n11 = 0;
                                if (dBItem != null) {
                                    n11 = dBItem.getBytesLength();
                                }
                                if (dBTypeArray[n4].type == 998) {
                                    ((OCIDBItem)dBDataArray2[n4].getItem(n3)).setPlsqlIndexTableItemFields(null, 0, (OCIDBType)dBTypeArray2[n4]);
                                }
                                this.check_error(this.set_up_bind_rows((OCIDBStatement)dBStatement, n4, n3, dBItem, n11), (OCIDBStatement)dBStatement);
                                ++n3;
                            }
                        }
                    } else {
                        if (dBDataArray2[n4] == null) {
                            return 0;
                        }
                        if (!((OCIDBStatement)dBStatement).binds_initialized) {
                            this.check_error(this.set_up_bind_column((OCIDBStatement)dBStatement, n4, dBTypeArray2[n4], n, (byte)16, by, this.getTDOPtr(dBTypeArray2[n4])), (OCIDBStatement)dBStatement);
                        }
                        n3 = 0;
                        while (n3 < n) {
                            object = dBDataArray2[n4].getItem(n3);
                            int n12 = 0;
                            if (object != null) {
                                n12 = ((DBItem)object).getBytesLength();
                            }
                            if (dBTypeArray2[n4].type == 998) {
                                ((OCIDBItem)object).setPlsqlIndexTableItemFields(null, 0, (OCIDBType)dBTypeArray2[n4]);
                            }
                            this.check_error(this.set_up_bind_rows((OCIDBStatement)dBStatement, n4, n3, (DBItem)object, n12), (OCIDBStatement)dBStatement);
                            ++n3;
                        }
                    }
                } else if (n4 >= n9 && n4 < n5) {
                    if (!((OCIDBStatement)dBStatement).binds_initialized) {
                        this.check_error(this.set_up_bind_column((OCIDBStatement)dBStatement, n4, dBTypeArray2[n4], n, (byte)16, by, this.getTDOPtr(dBTypeArray2[n4])), (OCIDBStatement)dBStatement);
                    }
                    n3 = 0;
                    while (n3 < n) {
                        int n13 = 0;
                        object = dBDataArray2[n4].getItem(n3);
                        if (object != null) {
                            n13 = ((DBItem)object).getBytesLength();
                        }
                        if (dBTypeArray2[n4].type == 998) {
                            ((OCIDBItem)object).setPlsqlIndexTableItemFields(null, 0, (OCIDBType)dBTypeArray2[n4]);
                        }
                        this.check_error(this.set_up_bind_rows((OCIDBStatement)dBStatement, n4, n3, (DBItem)object, n13), (OCIDBStatement)dBStatement);
                        ++n3;
                    }
                } else if (n4 >= n5 && n4 < n9) {
                    if (!((OCIDBStatement)dBStatement).binds_initialized) {
                        this.check_error(this.set_up_bind_column((OCIDBStatement)dBStatement, n4, dBTypeArray[n4], n, (byte)1, by, this.getTDOPtr(dBTypeArray[n4])), (OCIDBStatement)dBStatement);
                    }
                    n3 = 0;
                    while (n3 < n) {
                        object = dBDataArray[n4].getItem(n3);
                        int n14 = 0;
                        if (object != null) {
                            n14 = ((DBItem)object).getBytesLength();
                        }
                        this.check_error(this.set_up_bind_rows((OCIDBStatement)dBStatement, n4, n3, (DBItem)object, n14), (OCIDBStatement)dBStatement);
                        ++n3;
                    }
                }
                ++n4;
            }
        } else if (n9 != 0) {
            if (!((OCIDBStatement)dBStatement).binds_initialized) {
                this.check_error(this.initialize_bind_columns((OCIDBStatement)dBStatement, dBTypeArray.length, n), null);
            }
            n4 = 0;
            while (n4 < dBTypeArray.length) {
                if (dBTypeArray[n4] != null) {
                    if (!((OCIDBStatement)dBStatement).binds_initialized) {
                        this.check_error(this.set_up_bind_column((OCIDBStatement)dBStatement, n4, dBTypeArray[n4], n, (byte)1, by, this.getTDOPtr(dBTypeArray[n4])), (OCIDBStatement)dBStatement);
                    }
                    n3 = 0;
                    while (n3 < n) {
                        object = dBDataArray[n4].getItem(n3);
                        int n15 = 0;
                        if (object != null) {
                            n15 = ((DBItem)object).getBytesLength();
                        }
                        this.check_error(this.set_up_bind_rows((OCIDBStatement)dBStatement, n4, n3, (DBItem)object, n15), (OCIDBStatement)dBStatement);
                        ++n3;
                    }
                }
                ++n4;
            }
        }
        ((OCIDBStatement)dBStatement).binds_initialized = true;
        if (by != 1 && dBDataArray2 != null && (n9 = dBDataArray2 != null ? dBDataArray2.length : 0) != 0 && !((OCIDBStatement)dBStatement).defines_initialized) {
            this.check_error(this.initialize_define_columns((OCIDBStatement)dBStatement, dBTypeArray2.length, n2), null);
            n4 = 0;
            while (n4 < dBTypeArray2.length) {
                if (dBTypeArray2[n4] != null) {
                    this.check_error(this.set_up_define_column((OCIDBStatement)dBStatement, n4, dBTypeArray2[n4], n2, this.getTDOPtr(dBTypeArray2[n4])), (OCIDBStatement)dBStatement);
                }
                ++n4;
            }
            ((OCIDBStatement)dBStatement).defines_initialized = true;
        }
        n8 = this.do_execute((OCIDBStatement)dBStatement, n2);
        int n16 = this.get_number_of_rows_processed((OCIDBStatement)dBStatement);
        dBStatement.rows_processed = n16 < 0 ? 0 : n16;
        this.check_error(n8, (OCIDBStatement)dBStatement);
        if (by != 1 && n5 > 0) {
            this.trace("Done with Initialization");
            ((OCIDBStatement)dBStatement).row_prefetch = n2;
            n8 = this.do_fetch((OCIDBStatement)dBStatement, n2, n6);
            this.trace("After do fetch");
            if (n8 != -2 && n8 < 0) {
                this.check_error(n8, (OCIDBStatement)dBStatement);
            }
        }
        if (dBDataArray2 != null) {
            this.trace("before copy_back_to_next_stream");
            if (by == 0) {
                this.copy_back_to_next_stream((OCIDBStatement)dBStatement, n8);
            } else if (by == 1) {
                this.copy_back_to_next_stream_from_binds((OCIDBStatement)dBStatement);
            }
        }
        if (n8 != -2 && by != 1) {
            this.free_temp_alloc();
        }
        return n8;
    }

    public synchronized int fetch(DBStatement dBStatement, DBDataSet dBDataSet, int n) throws SQLException, IOException {
        int n2;
        this.trace("fetch");
        int n3 = 0;
        int n4 = 0;
        DBType[] dBTypeArray = null;
        DBData[] dBDataArray = null;
        if (dBDataSet != null) {
            dBTypeArray = ((DBDataSetImpl)dBDataSet).getDBTypes();
            dBDataArray = ((DBDataSetImpl)dBDataSet).getDBData();
        }
        if ((n2 = dBTypeArray != null ? dBTypeArray.length : 0) != 0) {
            this.curr_out_values = dBDataArray;
            this.curr_out_types = dBTypeArray;
            this.start_index = 0;
            this.end_index = 0;
            if (!((OCIDBStatement)dBStatement).defines_initialized || ((OCIDBStatement)dBStatement).row_prefetch != n) {
                this.check_error(this.initialize_define_columns((OCIDBStatement)dBStatement, dBTypeArray.length, n), null);
                int n5 = 0;
                while (n5 < dBTypeArray.length) {
                    if (dBTypeArray[n5] != null) {
                        this.check_error(this.set_up_define_column((OCIDBStatement)dBStatement, n5, dBTypeArray[n5], n, this.getTDOPtr(dBTypeArray[n5])), (OCIDBStatement)dBStatement);
                    }
                    ++n5;
                }
                ((OCIDBStatement)dBStatement).defines_initialized = true;
            }
            ((OCIDBStatement)dBStatement).row_prefetch = n;
            n4 = this.do_fetch((OCIDBStatement)dBStatement, n, n3);
            if (n4 != -2 && n4 < 0) {
                this.check_error(n4, (OCIDBStatement)dBStatement);
            } else {
                this.copy_back_to_next_stream((OCIDBStatement)dBStatement, n4);
            }
        }
        if (n4 != -2 || n4 < n) {
            this.free_temp_alloc();
        }
        return n4;
    }

    public int fetch(DBStatement dBStatement, DBDataSet dBDataSet, int n, int n2) throws SQLException, IOException {
        return 0;
    }

    public synchronized void fileClose(BFILE bFILE) throws SQLException {
        this.trace("DBAccess.fileClose");
        byte[] byArray = null;
        if (bFILE == null || (byArray = bFILE.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        DBType dBType = this.createDBType(114, false);
        byte[] byArray2 = new byte[dBType.max_length];
        this.check_error(this.bfile_close(byArray, byArray.length, byArray2, byArray2.length), null);
        bFILE.setLocator(byArray2);
    }

    public synchronized boolean fileExists(BFILE bFILE) throws SQLException {
        int n = 0;
        byte[] byArray = null;
        if (bFILE == null || (byArray = bFILE.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        n = this.bfile_exists(byArray, byArray.length);
        this.check_error(n, null);
        return n == 1;
    }

    public synchronized String fileGetDirAlias(BFILE bFILE) throws SQLException {
        this.trace("DBAccess.fileGetDirAlias");
        byte[] byArray = null;
        String string = null;
        if (bFILE == null || (byArray = bFILE.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        string = this.bfile_getDirAlias(byArray, byArray.length);
        this.check_error(string.length(), null);
        return string;
    }

    public synchronized String fileGetName(BFILE bFILE) throws SQLException {
        this.trace("DBAccess.fileGetName");
        byte[] byArray = null;
        String string = null;
        if (bFILE == null || (byArray = bFILE.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        string = this.bfile_getName(byArray, byArray.length);
        this.check_error(string.length(), null);
        return string;
    }

    public synchronized boolean fileIsOpen(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        int n = 0;
        if (bFILE == null || (byArray = bFILE.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        n = this.bfile_isOpen(byArray, byArray.length);
        this.check_error(n, null);
        return n == 1;
    }

    public synchronized void fileOpen(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        if (bFILE == null || (byArray = bFILE.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        DBType dBType = this.createDBType(114, false);
        byte[] byArray2 = new byte[dBType.max_length];
        this.check_error(this.bfile_open(byArray, byArray.length, byArray2, byArray2.length), null);
        bFILE.setLocator(byArray2);
    }

    public synchronized void freeTemporaryLob(Connection connection, Datum datum, int n) throws SQLException {
        byte[] byArray = null;
        if (datum == null || (byArray = datum.shareBytes()) == null) {
            DBError.throwSqlException(54);
        }
        DBType dBType = null;
        switch (n) {
            case 2004: {
                dBType = this.createDBType(113, false);
                break;
            }
            case 2005: {
                dBType = this.createDBType(112, false);
                break;
            }
            case -13: {
                dBType = this.createDBType(114, false);
                break;
            }
            default: {
                return;
            }
        }
        byte[] byArray2 = new byte[dBType.max_length];
        this.check_error(this.lob_freeTemporary(n, byArray, byArray.length, byArray2, byArray2.length), null);
        datum.setShareBytes(byArray2);
    }

    native int free_c_state(boolean var1);

    native void free_temp_alloc();

    int getByteArrayLength(byte[] byArray) {
        return byArray.length;
    }

    public synchronized int getC2SNlsRatio() {
        if (this.m_c2s_nls_ratio == 0) {
            this.m_c2s_nls_ratio = this.get_client_server_nls_ratio(this.char_set);
        }
        return this.m_c2s_nls_ratio;
    }

    public synchronized byte[] getConnectionId() {
        byte[] byArray = this.get_connection_id();
        return byArray;
    }

    public synchronized Properties getConnectionPoolInfo() throws SQLException {
        Properties properties = new Properties();
        this.check_error(this.get_conn_pool_info(properties), null);
        return properties;
    }

    public synchronized Properties getDBAccessProperties() throws SQLException {
        long[] lArray = new long[3];
        this.check_error(this.getHandles(lArray), null);
        ((Hashtable)this.dbinfo).put("OCIEnvHandle", String.valueOf(lArray[0]));
        ((Hashtable)this.dbinfo).put("OCISvcCtxHandle", String.valueOf(lArray[1]));
        ((Hashtable)this.dbinfo).put("OCIErrHandle", String.valueOf(lArray[2]));
        ((Hashtable)this.dbinfo).put("ClientCharSet", String.valueOf(this.char_set));
        return this.dbinfo;
    }

    public int getDefaultPrefetch() {
        return 10;
    }

    public int getDefaultStreamChunkSize() {
        return 2000;
    }

    native int getHandles(long[] var1);

    public long getLobChunkSize(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        if (bLOB == null || (byArray = bLOB.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        return this.lobGetChunkSize(byArray);
    }

    public long getLobChunkSize(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        if (cLOB == null || (byArray = cLOB.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        return this.lobGetChunkSize(byArray);
    }

    public synchronized void getObjectValueFromRef(DBItem dBItem, DBType dBType, DBItem dBItem2, DBType dBType2) throws SQLException {
    }

    public synchronized void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
        if (oracleTypeADT != null) {
            SQLName sQLName = new SQLName(oracleTypeADT.getFullName(), oracleTypeADT.getConnection());
            String string = "\"" + sQLName.getSchema() + "\".\"" + sQLName.getSimpleName() + "\"";
            byte[] byArray = this.conversion.StringToCharBytes(string);
            this.check_error(this.get_tdo_ptr(oracleTypeADT, byArray, byArray.length), null);
        } else {
            System.out.println("otype passed to getOracleTypeADT is null");
        }
    }

    private short getPointerSize() {
        if (this.m_pointerSize == 0) {
            this.m_pointerSize = this.get_pointer_size();
        }
        return this.m_pointerSize;
    }

    public synchronized int getS2CNlsRatio() {
        if (this.m_s2c_nls_ratio == 0) {
            this.m_s2c_nls_ratio = this.get_server_client_nls_ratio(this.char_set);
        }
        return this.m_s2c_nls_ratio;
    }

    long getTDOPtr(DBType dBType) {
        if (dBType != null && dBType.otype != null) {
            return ((OracleTypeADT)dBType.otype).getTDO_C_STATE();
        }
        return 0L;
    }

    public synchronized byte[] getVersion() throws SQLException, IOException {
        return this.get_database_version();
    }

    public synchronized short getVersionNumber() throws SQLException {
        if (this.version_num == 0) {
            try {
                byte[] byArray = this.getVersion();
                String string = this.conversion.CharBytesToString(byArray, byArray.length);
                StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " .", false);
                String string2 = null;
                int n = 0;
                short s = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    try {
                        s = Integer.decode(string2).shortValue();
                        this.version_num = (short)(this.version_num * 10 + s);
                        if (++n != 4) continue;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.version_num == -1 || this.version_num == -8) {
            this.version_num = 0;
        }
        return this.version_num;
    }

    native int get_char_set(boolean var1);

    native int get_client_server_nls_ratio(int var1);

    native int get_column_count(OCIDBStatement var1);

    native int get_conn_pool_info(Properties var1);

    native byte[] get_connection_id();

    native byte[] get_cursor_bytes(OCIDBStatement var1);

    native int get_cursor_size();

    native byte[] get_database_version();

    native int get_db_char_set();

    native int get_db_nchar_set();

    native byte[] get_describe(OCIDBStatement var1, DBColumn var2, int var3);

    native int get_number_of_rows_processed(OCIDBStatement var1);

    native short get_pointer_size();

    native int get_server_client_nls_ratio(int var1);

    native int get_tdo_ptr(OracleTypeADT var1, byte[] var2, int var3);

    public synchronized void initNls(OracleConnection oracleConnection) throws SQLException {
        this.setNlsParamsClient(oracleConnection);
    }

    void initObjectFields(DBColumn dBColumn, byte[] byArray) throws SQLException {
        String string = this.conversion.CharBytesToString(byArray, byArray.length);
        dBColumn.otype = new OracleTypeADT(string);
    }

    void initRefFields(DBColumn dBColumn, byte[] byArray) throws SQLException {
        String string = this.conversion.CharBytesToString(byArray, byArray.length);
        dBColumn.otype = new OracleTypeADT(string);
    }

    native int initialize_bind_columns(OCIDBStatement var1, int var2, int var3);

    native int initialize_define_columns(OCIDBStatement var1, int var2, int var3);

    public synchronized boolean isLobOpen(Connection connection, Datum datum, int n) throws SQLException {
        byte[] byArray = null;
        int n2 = 0;
        if (datum == null || (byArray = datum.shareBytes()) == null) {
            DBError.throwSqlException(54);
        }
        n2 = this.lob_isOpen(n, byArray, byArray.length);
        this.check_error(n2, null);
        return n2 == 1;
    }

    public synchronized boolean isTemporaryLob(Connection connection, Datum datum, int n) throws SQLException {
        byte[] byArray = null;
        int n2 = 0;
        if (datum == null || (byArray = datum.shareBytes()) == null) {
            DBError.throwSqlException(54);
        }
        n2 = this.lob_isTemporary(n, byArray, byArray.length);
        this.check_error(n2, null);
        return n2 == 1;
    }

    private synchronized long lobGetChunkSize(byte[] byArray) throws SQLException {
        int n = 0;
        n = this.lob_getChunkSize(byArray, byArray.length);
        this.check_error(n, null);
        return n;
    }

    public synchronized long lobLength(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        if (bFILE == null || (byArray = bFILE.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        return this.lobLength(byArray);
    }

    public synchronized long lobLength(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        if (bLOB == null || (byArray = bLOB.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        return this.lobLength(byArray);
    }

    public synchronized long lobLength(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        if (cLOB == null || (byArray = cLOB.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        return this.lobLength(byArray);
    }

    private long lobLength(byte[] byArray) throws SQLException {
        int n = 0;
        n = this.lob_getlength(byArray, byArray.length);
        this.check_error(n, null);
        return n;
    }

    public synchronized long lobRead(BFILE bFILE, long l, long l2, byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        if (bFILE == null || (byArray2 = bFILE.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        if (l2 <= 0L || byArray == null) {
            return 0L;
        }
        if (l2 > (long)byArray.length) {
            l2 = byArray.length;
        }
        return this.blobRead(byArray2, l, l2, byArray);
    }

    public synchronized long lobRead(BLOB bLOB, long l, long l2, byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        if (bLOB == null || (byArray2 = bLOB.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        if (l2 <= 0L || byArray == null) {
            return 0L;
        }
        if (l2 > (long)byArray.length) {
            l2 = byArray.length;
        }
        return this.blobRead(byArray2, l, l2, byArray);
    }

    public synchronized long lobRead(CLOB cLOB, long l, long l2, char[] cArray) throws SQLException {
        byte[] byArray = null;
        if (cLOB == null || (byArray = cLOB.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        if (l2 <= 0L || cArray == null) {
            return 0L;
        }
        if (l2 > (long)cArray.length) {
            l2 = cArray.length;
        }
        return this.clobRead(byArray, l, l2, cArray, cLOB.isNCLOB());
    }

    public synchronized long lobWrite(BLOB bLOB, long l, byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        if (bLOB == null || (byArray2 = bLOB.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        if (byArray == null) {
            return 0L;
        }
        DBType dBType = this.createDBType(113, false);
        byte[] byArray3 = new byte[dBType.max_length];
        long l2 = this.blobWrite(byArray2, l, byArray, byArray3);
        bLOB.setLocator(byArray3);
        return l2;
    }

    public synchronized long lobWrite(CLOB cLOB, long l, char[] cArray) throws SQLException {
        byte[] byArray = null;
        if (cLOB == null || (byArray = cLOB.getLocator()) == null) {
            DBError.throwSqlException(54);
        }
        if (cArray == null) {
            return 0L;
        }
        DBType dBType = this.createDBType(112, false);
        byte[] byArray2 = new byte[dBType.max_length];
        long l2 = this.clobWrite(byArray, l, cArray, byArray2, cLOB.isNCLOB());
        cLOB.setLocator(byArray2);
        return l2;
    }

    native int lob_close(int var1, byte[] var2, int var3, byte[] var4, int var5);

    native int lob_createTemporary(int var1, boolean var2, int var3, byte[] var4, int var5);

    native int lob_freeTemporary(int var1, byte[] var2, int var3, byte[] var4, int var5);

    native int lob_getChunkSize(byte[] var1, int var2);

    native int lob_getlength(byte[] var1, int var2);

    native int lob_isOpen(int var1, byte[] var2, int var3);

    native int lob_isTemporary(int var1, byte[] var2, int var3);

    native int lob_open(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    native int lob_trim(int var1, long var2, byte[] var4, int var5, byte[] var6, int var7);

    public synchronized void logoff() throws SQLException, IOException {
        this.trace("DBAccess.logoff");
        if (this.new_connection) {
            this.check_error(this.free_c_state(true), null);
            OCIEnv.getEnv(this).freeEnvHandle();
        } else {
            this.check_error(this.free_c_state(false), null);
        }
    }

    public synchronized DBConversion logon(String string, String string2, String string3, Properties properties) throws SQLException, IOException {
        String string4;
        String string5;
        block33: {
            if (string3 == null) {
                DBError.throwSqlException(64);
            }
            this.trace("DBAccess.logon");
            try {
                if (System.getProperty("oracle.jserver.version") == null && !loaded_library) {
                    string5 = properties.getProperty("dll");
                    System.loadLibrary(string5);
                    loaded_library = true;
                }
            }
            catch (SecurityException securityException) {
                if (loaded_library) break block33;
                string5 = properties.getProperty("dll");
                System.loadLibrary(string5);
                loaded_library = true;
            }
        }
        long l = 0L;
        long l2 = 0L;
        string5 = properties.getProperty("OCISvcCtxHandle");
        if (string5 != null && (string4 = properties.getProperty("OCIEnvHandle")) != null) {
            this.new_connection = false;
            l = Long.parseLong(string5);
            this.OCIEnvHandle = Long.parseLong(string4);
        } else {
            this.new_connection = true;
        }
        if (this.new_connection) {
            this.char_set = (short)this.get_char_set(true);
        } else {
            String string6 = properties.getProperty("OCIErrHandle");
            l2 = string6 != null ? Long.parseLong(string6) : 0L;
            String string7 = properties.getProperty("ClientCharSet");
            short s = string7 != null ? (short)Integer.parseInt(string7) : (short)0;
            if (s == 0) {
                short s2 = (short)this.get_char_set(false);
                if (s2 == -1) {
                    this.check_error(-1, null);
                } else {
                    this.char_set = s2;
                }
            } else if (s == 1 || s == 31 || s == 870 || s == 871) {
                this.char_set = s;
            } else {
                this.check_error(-1, null);
            }
        }
        this.OCIEnvHandle = OCIEnv.getEnv(this).getEnvHandle();
        if (this.c_state == 0L) {
            this.make_c_state();
        }
        this.conversion = new DBConversion(31, this.char_set, 871);
        if (this.new_connection) {
            byte[] byArray = DBConversion.stringToAccessCharBytes(string, this.char_set);
            byte[] byArray2 = DBConversion.stringToAccessCharBytes(string2, (short)31);
            byte[] byArray3 = DBConversion.stringToAccessCharBytes(string3, (short)31);
            byte[] byArray4 = null;
            String string8 = properties.getProperty("OCINewPassword");
            if (string8 != null) {
                byArray4 = DBConversion.stringToAccessCharBytes(string8, (short)31);
            }
            String string9 = properties.getProperty("internal_logon");
            this.logon_mode = 0;
            if (string9 != null) {
                this.logon_mode = string9.equalsIgnoreCase("sysoper") ? 4 : 2;
            }
            if (properties.getProperty("is_connection_pooling") == "true") {
                String string10 = properties.getProperty("connection_pool");
                OCIDBAccess oCIDBAccess = (OCIDBAccess)((Hashtable)properties).get("connpool_object");
                if (string10 == "connection_pool") {
                    this.logon_mode = 5;
                } else if (string10 == "connpool_connection") {
                    this.logon_mode = 6;
                } else if (string10 == "connpool_proxy_connection") {
                    this.logon_mode = 7;
                } else if (string10 == "connpool_alias_connection") {
                    this.logon_mode = 6;
                } else {
                    DBError.throwSqlException(23, "connection-pool-logon");
                }
            }
            try {
                this.check_error(this.do_open(this.OCIEnvHandle, byArray, byArray == null ? 0 : byArray.length, byArray2, byArray2 == null ? 0 : byArray2.length, byArray4, byArray4 == null ? 0 : byArray4.length, byArray3, byArray3.length, this.logon_mode, properties), null);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarnings(sQLWarning);
            }
        } else {
            this.check_error(this.use_connection(this.OCIEnvHandle, l, l2), null);
        }
        this.m_c2s_nls_ratio = this.getC2SNlsRatio();
        this.m_s2c_nls_ratio = this.getS2CNlsRatio();
        if (properties != null && properties.getProperty("connection_pool") != "connection_pool") {
            this.db_char_set = (short)this.get_db_char_set();
            this.db_nchar_set = (short)this.get_db_nchar_set();
            this.conversion = new DBConversion(this.db_char_set, this.char_set, this.db_nchar_set);
            this.version_num = this.getVersionNumber();
            if (this.version_num == -1 || this.version_num == -8) {
                this.version_num = 0;
            }
        } else {
            this.version_num = 0;
            this.db_char_set = (short)31;
            this.db_nchar_set = (short)871;
        }
        return this.conversion;
    }

    byte[] makeByteArray(int n) {
        if (n == 0) {
            return null;
        }
        return new byte[n];
    }

    native int make_c_state();

    native int make_statement(OCIDBStatement var1, byte[] var2);

    native int make_statement_c_state(OCIDBStatement var1);

    public synchronized DBStatement open() throws SQLException, IOException {
        OCIDBStatement oCIDBStatement = new OCIDBStatement(this);
        this.trace("DBAccess.open");
        this.check_error(this.make_statement_c_state(oCIDBStatement), oCIDBStatement);
        this.check_error(this.open_statement(oCIDBStatement), oCIDBStatement);
        return oCIDBStatement;
    }

    public synchronized void openLob(Connection connection, Datum datum, int n, int n2) throws SQLException {
        byte[] byArray = null;
        if (datum == null || (byArray = datum.shareBytes()) == null) {
            DBError.throwSqlException(54);
        }
        DBType dBType = null;
        switch (n2) {
            case 2004: {
                dBType = this.createDBType(113, false);
                break;
            }
            case 2005: {
                dBType = this.createDBType(112, false);
                break;
            }
            case -13: {
                dBType = this.createDBType(114, false);
                break;
            }
            default: {
                return;
            }
        }
        byte[] byArray2 = new byte[dBType.max_length];
        this.check_error(this.lob_open(n2, byArray, byArray.length, n, byArray2, byArray2.length), null);
        datum.setShareBytes(byArray2);
    }

    native int open_statement(OCIDBStatement var1);

    public synchronized DBColumn[] parseExecuteDescribe(DBStatement dBStatement, byte[] byArray, DBDataSet dBDataSet) throws SQLException, IOException {
        this.trace("OCIDBAccess.parseExecuteDescribe");
        DBType[] dBTypeArray = null;
        DBData[] dBDataArray = null;
        if (dBDataSet != null) {
            dBTypeArray = ((DBDataSetImpl)dBDataSet).getDBTypes();
            dBDataArray = ((DBDataSetImpl)dBDataSet).getDBData();
        }
        try {
            int n;
            int n2;
            int n3 = 1;
            this.start_index = 0;
            this.end_index = 0;
            ((OCIDBStatement)dBStatement).defines_initialized = false;
            ((OCIDBStatement)dBStatement).binds_initialized = false;
            this.check_error(this.create_stmt_c_copy((OCIDBStatement)dBStatement, byArray), (OCIDBStatement)dBStatement);
            this.check_error(this.do_parse((OCIDBStatement)dBStatement, byArray), (OCIDBStatement)dBStatement);
            int n4 = dBTypeArray != null ? dBTypeArray.length : 0;
            if (n4 != 0 && !((OCIDBStatement)dBStatement).binds_initialized) {
                this.check_error(this.initialize_bind_columns((OCIDBStatement)dBStatement, n4, n3), null);
                n2 = 0;
                while (n2 < dBTypeArray.length) {
                    this.check_error(this.set_up_bind_column((OCIDBStatement)dBStatement, n2, dBTypeArray[n2], n3, (byte)1, (byte)0, this.getTDOPtr(dBTypeArray[n2])), (OCIDBStatement)dBStatement);
                    int n5 = 0;
                    while (n5 < n3) {
                        DBItem dBItem = dBDataArray[n2].getItem(n5);
                        n = 0;
                        if (dBItem != null) {
                            n = dBItem.getBytesLength();
                        }
                        this.check_error(this.set_up_bind_rows((OCIDBStatement)dBStatement, n2, n5, dBItem, n), (OCIDBStatement)dBStatement);
                        ++n5;
                    }
                    ++n2;
                }
                ((OCIDBStatement)dBStatement).binds_initialized = true;
            }
            int n6 = this.do_execute((OCIDBStatement)dBStatement, 0);
            n = this.get_number_of_rows_processed((OCIDBStatement)dBStatement);
            dBStatement.rows_processed = n < 0 ? 0 : n;
            this.check_error(n6, (OCIDBStatement)dBStatement);
            int n7 = this.check_error(this.get_column_count((OCIDBStatement)dBStatement), (OCIDBStatement)dBStatement);
            DBColumn[] dBColumnArray = new DBColumn[n7];
            n2 = 0;
            while (n2 < dBColumnArray.length) {
                dBColumnArray[n2] = new DBColumn();
                byte[] byArray2 = this.get_describe((OCIDBStatement)dBStatement, dBColumnArray[n2], n2 + 1);
                if (byArray2 != null) {
                    this.enterColumnName(byArray2, dBColumnArray[n2]);
                } else {
                    this.check_error(-1, (OCIDBStatement)dBStatement);
                }
                ++n2;
            }
            DBColumn[] dBColumnArray2 = dBColumnArray;
            Object var8_17 = null;
            this.free_temp_alloc();
            return dBColumnArray2;
        }
        catch (Throwable throwable) {
            Object var8_18 = null;
            this.free_temp_alloc();
            throw throwable;
        }
    }

    public synchronized int parseExecuteFetch(DBStatement dBStatement, byte by, byte[] byArray, DBDataSet dBDataSet, int n, DBDataSet dBDataSet2, int n2) throws SQLException, IOException {
        this.trace("OCIDBAccess.parseExecuteFetch");
        this.check_error(this.create_stmt_c_copy((OCIDBStatement)dBStatement, byArray), (OCIDBStatement)dBStatement);
        this.check_error(this.do_parse((OCIDBStatement)dBStatement, byArray), (OCIDBStatement)dBStatement);
        ((OCIDBStatement)dBStatement).defines_initialized = false;
        ((OCIDBStatement)dBStatement).binds_initialized = false;
        int n3 = this.executeFetch(dBStatement, by, dBDataSet, n, dBDataSet2, n2);
        return n3;
    }

    public synchronized int read(DBStatement dBStatement, byte[] byArray, int n) throws SQLException, IOException {
        int n2;
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        if (this.curr_out_values != null) {
            n5 = this.curr_out_values[this.end_index].getItem((int)0).max_out_size;
            n4 = n5 < n ? n5 : n;
        }
        if ((n2 = this.do_read((OCIDBStatement)dBStatement, byArray, n4, n3)) == -1) {
            this.check_error(n2, (OCIDBStatement)dBStatement);
        }
        if (n2 == 0) {
            this.start_index = this.end_index + 1;
            this.copy_back_to_next_stream((OCIDBStatement)dBStatement, n2);
            if (this.curr_out_values != null && this.end_index >= this.curr_out_values.length) {
                this.free_temp_alloc();
                this.start_index = 0;
                this.end_index = 0;
                this.curr_out_values = null;
                this.curr_out_types = null;
            }
            return -1;
        }
        return n2;
    }

    public void registerTAFCallback(Connection connection, OracleOCIFailover oracleOCIFailover, Object object) throws SQLException {
        this.m_conn = connection;
        this.m_appCbk = oracleOCIFailover;
        this.m_cbkObj = object;
        this.check_error(this.register_TAF(), null);
    }

    native int register_TAF();

    public synchronized void rollback() throws SQLException, IOException {
        this.trace("DBAccess.rollback");
        this.check_error(this.do_rollback(), null);
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException, IOException {
        this.trace("DBAccess.setAutoCommit");
        this.check_error(this.set_auto_commit(bl), null);
    }

    public void setConnectionPoolInfo(Properties properties, OracleOCIConnection oracleOCIConnection) throws SQLException {
        this.check_error(this.set_conn_pool_info(properties, (OCIDBAccess)oracleOCIConnection.db_access), null);
    }

    void setObjectFields(DBType dBType, byte[] byArray, long l) throws SQLException {
        String string = this.conversion.CharBytesToString(byArray, byArray.length);
        dBType.otype = new OracleTypeADT(string);
        ((OracleTypeADT)dBType.otype).setTDO_C_STATE(l);
    }

    public void setObjectValueFromRef(DBItem dBItem, DBType dBType, DBItem dBItem2, DBType dBType2) throws SQLException {
    }

    native int set_auto_commit(boolean var1);

    native int set_conn_pool_info(Properties var1, OCIDBAccess var2);

    native int set_up_bind_column(OCIDBStatement var1, int var2, DBType var3, int var4, byte var5, byte var6, long var7);

    native int set_up_bind_rows(OCIDBStatement var1, int var2, int var3, DBItem var4, int var5);

    native int set_up_define_column(OCIDBStatement var1, int var2, DBType var3, int var4, long var5);

    public synchronized void shutdown(int n) throws SQLException {
        this.check_error(this.shutdown_db(n), null);
    }

    native int shutdown_db(int var1);

    public synchronized void startup(String string, int n) throws SQLException {
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        string.getBytes(0, n2, byArray, 0);
        this.check_error(this.startup_db(byArray, n2, n), null);
    }

    native int startup_db(byte[] var1, int var2, int var3);

    public void trace(String string) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream != null) {
            printStream.println(string);
        }
    }

    public synchronized void trimLob(Connection connection, Datum datum, int n, long l) throws SQLException {
        byte[] byArray = null;
        if (datum == null || (byArray = datum.shareBytes()) == null) {
            DBError.throwSqlException(54);
        }
        DBType dBType = null;
        switch (n) {
            case 2004: {
                dBType = this.createDBType(113, false);
                break;
            }
            case 2005: {
                dBType = this.createDBType(112, false);
                break;
            }
            case -13: {
                dBType = this.createDBType(114, false);
                break;
            }
            default: {
                return;
            }
        }
        byte[] byArray2 = new byte[dBType.max_length];
        this.check_error(this.lob_trim(n, l, byArray, byArray.length, byArray2, byArray2.length), null);
        datum.setShareBytes(byArray2);
    }

    native int use_connection(long var1, long var3, long var5);
}

