/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.BfileDBAccess;
import oracle.sql.Datum;

public class BFILE
extends Datum {
    static final int MAX_CHUNK_SIZE = 32512;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    oracle.jdbc.internal.OracleConnection m_conn;
    BfileDBAccess m_dbaccess;

    protected BFILE() {
    }

    public BFILE(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BFILE(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (oracleConnection != null) {
            this.m_conn = (oracle.jdbc.internal.OracleConnection)oracleConnection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_dbaccess = this.m_conn.createBfileDBAccess();
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getDBAccess().newConversionInputStream(this, 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Reader characterStreamValue() throws SQLException {
        return this.getDBAccess().newConversionReader(this, 8);
    }

    public void close() throws SQLException {
        this.getDBAccess().close(this);
    }

    public void closeFile() throws SQLException {
        this.getDBAccess().closeFile(this);
    }

    public boolean fileExists() throws SQLException {
        return this.getDBAccess().fileExists(this);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getDBAccess().newInputStream(this, 32512, 0L);
    }

    public InputStream getBinaryStream(long l) throws SQLException {
        return this.getDBAccess().newInputStream(this, 32512, l);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DBError.check_error(68, null);
        }
        if (n == 0) {
            return new byte[0];
        }
        long l2 = 0L;
        byte[] byArray = new byte[n];
        l2 = this.getBytes(l, n, byArray);
        if (l2 > 0L) {
            if (l2 == (long)n) {
                return byArray;
            }
            byte[] byArray2 = new byte[(int)l2];
            System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
            return byArray2;
        }
        return new byte[0];
    }

    public int getBytes(long l, int n, byte[] byArray) throws SQLException {
        return this.getDBAccess().getBytes(this, l, n, byArray);
    }

    public OracleConnection getConnection() throws SQLException {
        try {
            return (OracleConnection)this.getJavaSqlConnection();
        }
        catch (ClassCastException classCastException) {
            DBError.throwSqlException(103);
            return null;
        }
    }

    public BfileDBAccess getDBAccess() throws SQLException {
        if (this.m_dbaccess == null) {
            this.m_dbaccess = this.getConnection().createBfileDBAccess();
        }
        return this.m_dbaccess;
    }

    public String getDirAlias() throws SQLException {
        return this.getDBAccess().getDirAlias(this);
    }

    public Connection getJavaSqlConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
        }
        return this.m_conn;
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public String getName() throws SQLException {
        return this.getDBAccess().getName(this);
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public boolean isFileOpen() throws SQLException {
        return this.getDBAccess().isFileOpen(this);
    }

    public boolean isOpen() throws SQLException {
        return this.getDBAccess().isOpen(this);
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public Object makeJdbcArray(int n) {
        return new BFILE[n];
    }

    public void open() throws SQLException {
        this.getDBAccess().open(this, 0);
    }

    public void open(int n) throws SQLException {
        if (n != 0) {
            DBError.throwSqlException(102);
        }
        this.getDBAccess().open(this, n);
    }

    public void openFile() throws SQLException {
        this.getDBAccess().openFile(this);
    }

    public long position(BFILE bFILE, long l) throws SQLException {
        return this.getDBAccess().position(this, bFILE, l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        return this.getDBAccess().position(this, byArray, l);
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }
}

