/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMXPathQuery {
    private String URIfile = "";
    private String attributeName = "";
    private String elementPath = "";
    private Vector matchedValues;
    private Vector parsedElements;
    private StringTokenizer ep;
    private int elementIndex = 0;
    private int elementCount = 0;
    private boolean lastElementReached;
    private boolean optionalParameterSet;

    private String getURIFromFile(String string) {
        return new String("file:" + string);
    }

    public Vector getQueryResults() {
        return (Vector)this.matchedValues.clone();
    }

    public DOMXPathQuery(String string, String string2, String string3, boolean bl) {
        this.optionalParameterSet = bl;
        this.lastElementReached = false;
        this.URIfile = this.getURIFromFile(string);
        this.attributeName = string3;
        this.elementPath = string2;
        this.matchedValues = new Vector();
        this.parsedElements = new Vector();
        this.ep = new StringTokenizer(this.elementPath, "/");
        this.elementCount = this.ep.countTokens();
        while (this.ep.hasMoreTokens()) {
            this.parsedElements.addElement(this.ep.nextToken());
        }
    }

    public void queryNode(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                Document document = (Document)node;
                if (!document.getDocumentElement().getNodeName().equals(this.parsedElements.elementAt(this.elementIndex))) break;
                this.queryNode(document.getDocumentElement());
                break;
            }
            case 1: {
                NodeList nodeList;
                String string = node.getNodeName();
                if (this.parsedElements.lastElement().equals(string) && this.elementIndex == this.elementCount - 1) {
                    this.lastElementReached = true;
                    if (this.optionalParameterSet) {
                        NamedNodeMap namedNodeMap = node.getAttributes();
                        int n = 0;
                        while (n < namedNodeMap.getLength()) {
                            Node node2 = namedNodeMap.item(n);
                            if (node2.getNodeName().equals(this.attributeName)) {
                                this.matchedValues.addElement(node2.getNodeValue().trim());
                            }
                            ++n;
                        }
                    } else {
                        NodeList nodeList2 = node.getChildNodes();
                        if (nodeList2 != null) {
                            int n = 0;
                            while (n < nodeList2.getLength()) {
                                Node node3 = nodeList2.item(n);
                                if (node3.getNodeName().equalsIgnoreCase("#cdata-section") || node3.getNodeName().equalsIgnoreCase("#text")) {
                                    this.queryNode(nodeList2.item(n));
                                }
                                ++n;
                            }
                        }
                    }
                } else if (string.equals(this.parsedElements.elementAt(this.elementIndex)) && !this.lastElementReached && (nodeList = node.getChildNodes()) != null) {
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        if (nodeList.item(n).getNodeName().equals(this.parsedElements.elementAt(this.elementIndex + 1))) {
                            ++this.elementIndex;
                            this.queryNode(nodeList.item(n));
                        }
                        ++n;
                    }
                }
                if (this.elementIndex <= 0) break;
                --this.elementIndex;
                this.lastElementReached = false;
                break;
            }
            case 3: 
            case 4: {
                if (!this.lastElementReached) break;
                this.matchedValues.addElement(node.getNodeValue().trim());
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public void performXPathQuery() {
        DOMParser dOMParser = new DOMParser();
        try {
            dOMParser.parse(this.URIfile);
            XMLDocument xMLDocument = dOMParser.getDocument();
            this.queryNode((Node)xMLDocument);
        }
        catch (Exception exception) {
            System.out.println("Error in parsing: " + exception.getMessage());
        }
    }
}

