/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilDescQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class RemoveClusterPreinstService
implements OiilDescQuery {
    private static final String TEMP_SERVICE_DIR = "\\clusterpreinst";
    private static final String TEMP_SERVICE_EXECUTABLE = "clusterpreinstsrv.exe";
    private static final String TEMP_SERVICE_NAME = "OracleClusterPreinstService";

    public String getDescription(Vector vector) {
        String string = "";
        return string;
    }

    public Object performQuery(Vector vector) throws OiilQueryException {
        int n;
        String[] stringArray = (String[])this.retItem(vector, "nodeList");
        String string = (String)this.retItem(vector, "dest");
        File file = new File(string);
        if (stringArray.length < 1) {
            return null;
        }
        if (!file.isDirectory()) {
            String string2 = "DirNotFoundException";
            String string3 = OiQueryFileRes.getString("DirNotFoundException_desc");
            Object[] objectArray = new String[]{string};
            string3 = MessageFormat.format(string3, objectArray);
            throw new OiilQueryException(string2, string3);
        }
        ClusterPreinstClassW32 clusterPreinstClassW32 = new ClusterPreinstClassW32();
        ClusterWindows clusterWindows = null;
        try {
            clusterWindows = new ClusterWindows(4);
        }
        catch (ClusterException clusterException) {
            Trace.out((Exception)((Object)clusterException));
            String string4 = "HardwareVerificationException";
            String string5 = OiQueryFileRes.getString("HardwareVerificationException_desc");
            throw new OiilQueryException(string4, string5);
        }
        Trace.out((String)"Stopping and deleting temporary clusterpreinstall service");
        try {
            n = 0;
            while (n < stringArray.length) {
                clusterWindows.stopServiceOnNode(TEMP_SERVICE_NAME, stringArray[n]);
                n += 1;
            }
        }
        catch (Exception exception) {
            Trace.out((Exception)exception);
            String string6 = "HardwareVerificationException";
            String string7 = OiQueryFileRes.getString("HardwareVerificationException_desc");
            throw new OiilQueryException(string6, string7);
        }
        try {
            n = 0;
            while (n < stringArray.length) {
                clusterWindows.deleteServiceOnNode(TEMP_SERVICE_NAME, stringArray[n]);
                n += 1;
            }
            Trace.out((String)"\n Removed Temporary Services");
        }
        catch (Exception exception) {
            Trace.out((Exception)exception);
            String string8 = "HardwareVerificationException";
            String string9 = OiQueryFileRes.getString("HardwareVerificationException_desc");
            throw new OiilQueryException(string8, string9);
        }
        n = 1;
        Trace.out((String)"Removing temporary drive letter service file");
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string10 = "\\\\" + stringArray[n2] + "\\" + string.replace(':', '$');
            n = clusterPreinstClassW32.removeDirectory(string10);
            if (n) {
                Trace.out((String)"Successfully cleanup the temporary directory");
            } else {
                Trace.out((String)"Unable to fully cleanup the temporary directory");
            }
            ++n2;
        }
        return new Boolean(n != 0);
    }

    public Object retItem(Vector vector, String string) {
        int n = OiixVectorOps.vectIndexOf((Vector)vector, (Object)string);
        if (n == -1) {
            return null;
        }
        OiilActionInputElement oiilActionInputElement = (OiilActionInputElement)vector.elementAt(n);
        return oiilActionInputElement.getObject();
    }

    public static void main(String[] stringArray) {
        RemoveClusterPreinstService removeClusterPreinstService = new RemoveClusterPreinstService();
        Vector<OiilActionInputElement> vector = new Vector<OiilActionInputElement>();
        System.out.println("Length of args = " + stringArray.length);
        if (stringArray.length != 2) {
            System.out.println("Usage: java RemoveClusterPreinstService \"node1,node2,\"  Exe_dest_directory");
            return;
        }
        System.out.println("Arg[0] = " + stringArray[0]);
        System.out.println("Arg[1] = " + stringArray[1]);
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], ",");
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        System.out.println("Number of nodes = " + stringArray2.length);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n] = new String(stringTokenizer.nextToken());
            System.out.println("Node " + n + " = " + stringArray2[n]);
            ++n;
        }
        vector.addElement(new OiilActionInputElement("nodeList", (Object)stringArray2));
        String string = stringArray[1];
        vector.addElement(new OiilActionInputElement("dest", (Object)string));
        try {
            Boolean bl = (Boolean)removeClusterPreinstService.performQuery(vector);
            System.out.println("retVal = " + bl);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }
}

