/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.net.ns.NSProtocol;

public class RepositoryQueries
implements IASConstantsInterface {
    private byte[] key = null;
    private char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void main(String[] args) {
        RepositoryQueries qry = new RepositoryQueries();
        System.out.println("output of getOIDRunning()");
        System.out.println(qry.getOIDRunning("taoias-pc7.us.oracle.com", "389", "cn=orcladmin", "90201infra"));
        System.out.println("output of getInfrastructureDatabases()");
        String[] ret = qry.getInfrastructureDatabases("taoias-pc7.us.oracle.com", "389", "cn=orcladmin", "90201infra");
        if (ret != null && ret.length > 0) {
            for (int i = 0; i < ret.length; ++i) {
                System.out.println(ret[i]);
            }
        }
        System.out.println("output of getIASInstances()");
        String[] ret1 = qry.getIASInstances("honolulu.us.oracle.com", "4032", "cn=orcladmin", "welcome");
        if (ret1 != null && ret1.length > 0) {
            for (int i = 0; i < ret1.length; ++i) {
                System.out.println(ret1[i]);
            }
        }
        try {
            boolean bl = qry.getDBRunning("taoias-pc7.us.oracle.com", "1521", "iasdb.taoias_pc7.us.oracle.com");
            System.out.println("output of getDBRunning");
            System.out.println(String.valueOf("DBRunning return value ").concat(String.valueOf(bl)));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public String getSSORunning(String ssoHost, String ssoPort) {
        String ssoStatus = null;
        try {
            URL ssoUrl = new URL(String.valueOf(String.valueOf(String.valueOf(String.valueOf("http://").concat(String.valueOf(ssoHost))).concat(String.valueOf(":"))).concat(String.valueOf(ssoPort))).concat(String.valueOf("/pls/orasso/orasso.wwsso_app_admin.ssoping")));
            BufferedReader in = new BufferedReader(new InputStreamReader(ssoUrl.openStream()));
            ssoStatus = in.readLine();
            in.close();
        }
        catch (Exception e) {
            String in = null;
            return in;
        }
        String ldapHostPort = null;
        String ldapHostName = "LDAP_HOST";
        String ldapPortName = "LDAP_PORT";
        String ssoInfraDBName = "SSO_INFRASTRUCTURE_DB";
        String ldapHost = null;
        String ldapPort = null;
        String ssoInfraDB = null;
        if (ssoStatus != null) {
            try {
                if (ssoStatus.startsWith("SSO server running")) {
                    int startHost = ssoStatus.indexOf(ldapHostName);
                    int startPort = ssoStatus.indexOf(ldapPortName);
                    int startSSOInfraDB = ssoStatus.indexOf(ssoInfraDBName);
                    if (startHost == -1 || startPort == -1 || startSSOInfraDB == -1) {
                        String string = ldapHostPort;
                        return string;
                    }
                    ldapHost = ssoStatus.substring(startHost + ldapHostName.length() + 1, startPort);
                    if (ldapHost != null) {
                        ldapHost = ldapHost.trim();
                    }
                    if ((ldapPort = ssoStatus.substring(startPort + ldapPortName.length() + 1, startSSOInfraDB)) != null) {
                        ldapPort = ldapPort.trim();
                    }
                    if ((ssoInfraDB = ssoStatus.substring(startSSOInfraDB + ssoInfraDBName.length() + 1)) != null) {
                        ssoInfraDB = ssoInfraDB.trim();
                    }
                    ldapHostPort = String.valueOf(String.valueOf(String.valueOf(String.valueOf(ldapHost).concat(String.valueOf(":"))).concat(String.valueOf(ldapPort))).concat(String.valueOf(":"))).concat(String.valueOf(ssoInfraDB));
                }
            }
            catch (Exception e) {
                String string = null;
                return string;
            }
        }
        return ldapHostPort;
    }

    public boolean isEmpty(String p_string) {
        if (p_string == null) {
            return true;
        }
        String string = p_string;
        return (string = string.trim()).length() == 0;
    }

    public boolean getOIDRunning(String oidHost, String oidPort, String oidUser, String oidPassword) {
        String url = String.valueOf(String.valueOf(String.valueOf("ldap://").concat(String.valueOf(oidHost))).concat(String.valueOf(":"))).concat(String.valueOf(oidPort));
        String principal = oidUser;
        String credentials = oidPassword;
        String dn = "cn=iASAdmins, cn=Groups, cn=OracleContext";
        String resoidUser = "";
        Hashtable<String, String> ldapEnv = new Hashtable<String, String>();
        ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapEnv.put("java.naming.provider.url", url);
        ldapEnv.put("java.naming.security.authentication", "simple");
        ldapEnv.put("java.naming.security.principal", oidUser);
        ldapEnv.put("java.naming.security.credentials", oidPassword);
        if (this.isEmpty(oidHost) || this.isEmpty(oidPort) || this.isEmpty(oidUser) || this.isEmpty(oidPassword)) {
            return false;
        }
        InitialDirContext ctx = null;
        try {
            resoidUser = this.trimSpaces(oidUser);
            ctx = new InitialDirContext(ldapEnv);
            String attrname = "uniquemember";
            String valueWithoutSpaces = null;
            String[] attrValues = this.getAttribute(dn, attrname, ctx);
            for (int i = 0; i < attrValues.length; ++i) {
                valueWithoutSpaces = this.trimSpaces(attrValues[i]);
                if (!valueWithoutSpaces.equalsIgnoreCase(resoidUser)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                IOException ie = (IOException)e.getRootCause();
                if (ie instanceof UnknownHostException) {
                    boolean bl = false;
                    return bl;
                }
                if (ie instanceof ConnectException) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private String[] getAttribute(String dn, String attribute, DirContext ctx) {
        Hashtable tbl = this.getAttributes(dn, new String[]{attribute}, ctx);
        return (String[])tbl.get(attribute.toLowerCase());
    }

    private Hashtable getAttributes(String dn, String[] attributes, DirContext ldapContext) {
        Hashtable<String, String[]> tbl = new Hashtable<String, String[]>(attributes.length);
        try {
            Attributes attrs = ldapContext.getAttributes(dn, attributes);
            NamingEnumeration<String> namingEnumeration = attrs.getIDs();
            if (namingEnumeration != null) {
                while (namingEnumeration.hasMoreElements()) {
                    String id = namingEnumeration.next();
                    Attribute att = attrs.get(id);
                    int noOfValues = att.size();
                    NamingEnumeration<?> enum1 = att.getAll();
                    String[] attr1 = new String[noOfValues];
                    int i = 0;
                    if (noOfValues == 1) {
                        attr1[0] = (String)att.get();
                    } else if (enum1 != null) {
                        while (enum1.hasMoreElements()) {
                            attr1[i] = enum1.next().toString();
                            ++i;
                        }
                    }
                    tbl.put(id.toLowerCase(), attr1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tbl;
    }

    private String trimSpaces(String strWithSpaces) {
        String res = "";
        StringTokenizer strToken = new StringTokenizer(strWithSpaces, ",");
        while (strToken.hasMoreTokens()) {
            res = String.valueOf(res).concat(String.valueOf(strToken.nextToken().trim()));
            res = String.valueOf(res).concat(String.valueOf(","));
        }
        if (res.endsWith(",")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public String createMidTier(String oidHost, String oidPort, String oidUser, String oidPassword, String midTierCommonName, String midTierPassword) {
        String url = String.valueOf(String.valueOf(String.valueOf("ldap://").concat(String.valueOf(oidHost))).concat(String.valueOf(":"))).concat(String.valueOf(oidPort));
        Hashtable<String, String> ldapEnv = new Hashtable<String, String>();
        ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapEnv.put("java.naming.provider.url", url);
        ldapEnv.put("java.naming.security.authentication", "simple");
        ldapEnv.put("java.naming.security.principal", oidUser);
        ldapEnv.put("java.naming.security.credentials", oidPassword);
        InitialDirContext ctx = null;
        DirContext result = null;
        try {
            ctx = new InitialDirContext(ldapEnv);
            String dn = String.valueOf(String.valueOf(String.valueOf("orclApplicationCommonName=").concat(String.valueOf(midTierCommonName))).concat(String.valueOf(","))).concat(String.valueOf("cn=IAS Instances, cn=IAS, cn=Products, cn=OracleContext"));
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute objclass = new BasicAttribute("objectclass");
            objclass.add("top");
            objclass.add("orclApplicationEntity");
            attrs.put(objclass);
            BasicAttribute attr = new BasicAttribute("userpassword");
            attr.add(midTierPassword);
            attrs.put(attr);
            result = ctx.createSubcontext(dn, (Attributes)attrs);
        }
        catch (NamingException e) {
            String string = null;
            return string;
        }
        if (result != null) {
            return midTierCommonName;
        }
        return null;
    }

    public String[] getIASInstances(String oidHost, String oidPort, String oidUser, String oidPassword) {
        String url = String.valueOf(String.valueOf(String.valueOf("ldap://").concat(String.valueOf(oidHost))).concat(String.valueOf(":"))).concat(String.valueOf(oidPort));
        Hashtable<String, String> ldapEnv = new Hashtable<String, String>();
        ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapEnv.put("java.naming.provider.url", url);
        ldapEnv.put("java.naming.security.authentication", "simple");
        ldapEnv.put("java.naming.security.principal", oidUser);
        ldapEnv.put("java.naming.security.credentials", oidPassword);
        InitialDirContext ctx = null;
        Object result = null;
        Object[] retValue = null;
        try {
            ctx = new InitialDirContext(ldapEnv);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(new String[]{"orclApplicationCommonName"});
            NamingEnumeration<SearchResult> namingEnumeration = ctx.search("cn=IAS Instances, cn=IAS, cn=Products, cn=OracleContext", "objectclass=orclApplicationEntity", ctls);
            Vector<String> iasInstances = new Vector<String>();
            while (namingEnumeration.hasMore()) {
                SearchResult res = namingEnumeration.next();
                Attributes attrs = res.getAttributes();
                Attribute att = attrs.get("orclApplicationCommonName");
                iasInstances.add(att.get().toString());
            }
            retValue = new String[iasInstances.size()];
            iasInstances.copyInto(retValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retValue;
    }

    public String[] getInfrastructureDatabases(String oidHost, String oidPort, String oidUser, String oidPassword) {
        String url = String.valueOf(String.valueOf(String.valueOf("ldap://").concat(String.valueOf(oidHost))).concat(String.valueOf(":"))).concat(String.valueOf(oidPort));
        Hashtable<String, String> ldapEnv = new Hashtable<String, String>();
        ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapEnv.put("java.naming.provider.url", url);
        ldapEnv.put("java.naming.security.authentication", "simple");
        ldapEnv.put("java.naming.security.principal", oidUser);
        ldapEnv.put("java.naming.security.credentials", oidPassword);
        InitialDirContext ctx = null;
        Object result = null;
        Vector<String> dbcn = new Vector<String>();
        Vector<String> globalDBName = new Vector<String>();
        String[] retValue = null;
        try {
            ctx = new InitialDirContext(ldapEnv);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(new String[]{"orclReferenceName", "seealso"});
            NamingEnumeration<SearchResult> namingEnumeration = ctx.search("cn=IAS Infrastructure Databases, cn=IAS, cn=Products, cn=OracleContext", "objectclass=orclReferenceObject", ctls);
            while (namingEnumeration.hasMore()) {
                SearchResult res = namingEnumeration.next();
                Attributes attrs = res.getAttributes();
                NamingEnumeration<String> enum1 = attrs.getIDs();
                Attribute att = attrs.get("seealso");
                dbcn.add(att.get().toString());
                Attribute att1 = attrs.get("orclReferenceName");
                globalDBName.add(att1.get().toString());
            }
            String[] attIds = new String[]{"orclnetdescstring", "orclsid"};
            retValue = new String[dbcn.size()];
            for (int i = 0; i < dbcn.size(); ++i) {
                Attributes attrs = ctx.getAttributes((String)dbcn.elementAt(i), attIds);
                NamingEnumeration<String> enum1 = attrs.getIDs();
                Attribute att = attrs.get("orclnetdescstring");
                Attribute sidAttrib = attrs.get("orclsid");
                retValue[i] = String.valueOf(String.valueOf(RepositoryQueries.formatGlobalDBName(att.get().toString(), sidAttrib.get().toString())).concat(String.valueOf(":"))).concat(String.valueOf(globalDBName.elementAt(i).toString()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retValue;
    }

    public static String formatGlobalDBName(String descStr, String sid) {
        Object ret = null;
        String HOST = "HOST";
        String PORT = "PORT";
        String SERVICE_NAME = "SERVICE_NAME";
        int loc = descStr.indexOf(HOST);
        String host = RepositoryQueries.getValue(descStr.substring(loc + HOST.length()));
        loc = descStr.indexOf(PORT);
        String port = RepositoryQueries.getValue(descStr.substring(loc + PORT.length()));
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(host).concat(String.valueOf(":"))).concat(String.valueOf(port))).concat(String.valueOf(":"))).concat(String.valueOf(sid));
    }

    public static String getValue(String str) {
        int i = 1;
        StringBuffer buf = new StringBuffer();
        while (str.charAt(i) != ')') {
            if (str.charAt(i) != '=') {
                buf.append(str.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    private String byteToHex(byte[] data) {
        if (data == null) {
            return null;
        }
        int len = data.length;
        StringBuffer buf = new StringBuffer(len * 2);
        for (int pos = 0; pos < len; ++pos) {
            buf.append(this.HEX_DIGIT[data[pos] >>> 4 & 0xF]).append(this.HEX_DIGIT[data[pos] & 0xF]);
        }
        return buf.toString();
    }

    public boolean getDBRunning(String host, String port, String serviceName) throws IOException {
        String connection = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("//").concat(String.valueOf(host))).concat(String.valueOf(":"))).concat(String.valueOf(port))).concat(String.valueOf("/"))).concat(String.valueOf(serviceName));
        Properties up = new Properties();
        try {
            NSProtocol ns = new NSProtocol();
            ns.connect(connection, up);
            ns.disconnect();
            boolean bl = true;
            return bl;
        }
        catch (Exception ie) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean isSSOConfigured(String oidHost, String oidPort, String oidUser, String oidPassword) {
        String url = String.valueOf(String.valueOf(String.valueOf("ldap://").concat(String.valueOf(oidHost))).concat(String.valueOf(":"))).concat(String.valueOf(oidPort));
        String dn = "orclApplicationCommonName=ORASSO_SSOSERVER,cn=SSO,cn=Products, cn=OracleContext";
        Hashtable<String, String> ldapEnv = new Hashtable<String, String>();
        InitialDirContext ldapContext = null;
        ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapEnv.put("java.naming.security.authentication", "simple");
        ldapEnv.put("java.naming.provider.url", url);
        ldapEnv.put("java.naming.security.principal", oidUser);
        ldapEnv.put("java.naming.security.credentials", oidPassword);
        try {
            ldapContext = new InitialDirContext(ldapEnv);
            ldapContext.lookup(dn);
        }
        catch (NamingException e) {
            boolean bl = false;
            return bl;
        }
        return true;
    }
}

