/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;

public class OiMultiItemPanel
extends OiifpWizPanel {
    public static final String POPDOWN = "POPDOWN";
    public static final String SECURE = "SECURE";
    public static final String TEXTFIELD = "TEXTFIELD";
    private static final int INSETS = 5;
    private static final String DEFAULT_TITLE = OiStdDialogRes.getString("MultiItem_DefaultTitle");
    private static final String DEFAULT_PROMPT = OiStdDialogRes.getString("MultiItem_DefaultPrompt");
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private MultiLineLabel _prompt = new MultiLineLabel(WordWrapper.getTextWrapper(), DEFAULT_PROMPT);
    private LWLabel[] _labels;
    private LWComponent[] _items;
    private String[] _choices;
    private Color _promptColor;
    private Color _itemColor;

    public OiMultiItemPanel() {
        super(DEFAULT_TITLE);
        this.mainPanel.add((Component)this._prompt, "North");
        this.gridbag = new GridBagLayout();
        this.dlgPanel.setLayout(this.gridbag);
        this.c = new GridBagConstraints();
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.anchor = 18;
        this.c.fill = 2;
        this._labels = new LWLabel[0];
        this._items = new LWComponent[0];
        this._choices = new String[0];
        this._promptColor = this._prompt.getBackground();
        this._itemColor = this.getBackground();
        ((Container)((Object)this)).validate();
    }

    public String getPrompt() {
        return this._prompt.getText();
    }

    public String[] getLabels() {
        int n = this._labels.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._labels[n2].getText();
            ++n2;
        }
        return stringArray;
    }

    public String[] getSelections() {
        int n = this._items.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            LWComponent lWComponent = this._items[n2];
            if (lWComponent instanceof LWChoice) {
                stringArray[n2] = ((LWChoice)lWComponent).getSelectedItem();
            } else if (lWComponent instanceof LWPasswordField) {
                stringArray[n2] = ((LWPasswordField)lWComponent).getText();
            } else if (lWComponent instanceof LWTextField) {
                stringArray[n2] = ((LWTextField)lWComponent).getText();
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getTypes() {
        int n = this._items.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            LWComponent lWComponent = this._items[n2];
            if (lWComponent instanceof LWChoice) {
                stringArray[n2] = POPDOWN;
            } else if (lWComponent instanceof LWPasswordField) {
                stringArray[n2] = SECURE;
            } else if (lWComponent instanceof LWTextField) {
                stringArray[n2] = TEXTFIELD;
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getChoices() {
        return this._choices;
    }

    public void setPrompt(String string) {
        this.invalidate();
        this._prompt.setText(string);
        ((Container)((Object)this)).validate();
    }

    public void setLabels(String[] stringArray) {
        this.removeLabels();
        if (stringArray != null) {
            this._labels = new LWLabel[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                boolean bl = n == stringArray.length - 1;
                this._labels[n] = new LWLabel(stringArray[n]);
                this.addLabel(this._labels[n], n, bl);
                ++n;
            }
            this.updateLabelsAssociation();
        }
    }

    private void removeLabels() {
        this.invalidate();
        if (this._labels != null) {
            int n = 0;
            while (n < this._labels.length) {
                this.dlgPanel.remove((Component)this._labels[n]);
                ++n;
            }
            this._labels = new LWLabel[0];
        }
        ((Container)((Object)this)).validate();
    }

    private void addLabel(LWLabel lWLabel, int n, boolean bl) {
        this.invalidate();
        this.c.weighty = bl ? 1.0 : 0.0;
        this.c.gridx = 0;
        this.c.gridy = n;
        this.c.weightx = 0.01;
        this.c.gridwidth = 1;
        this.gridbag.setConstraints((Component)lWLabel, this.c);
        this.dlgPanel.add((Component)lWLabel);
        ((Container)((Object)this)).validate();
    }

    public void setTypes(String[] stringArray) {
        this.removeItems();
        if (stringArray != null) {
            this._items = new LWComponent[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                boolean bl = n == stringArray.length - 1;
                this._items[n] = this.createComponent(stringArray[n]);
                this.addItem(this._items[n], n, bl);
                ++n;
            }
            this.refreshChoices();
            this.updateLabelsAssociation();
        }
    }

    private void removeItems() {
        this.invalidate();
        if (this._items != null) {
            int n = 0;
            while (n < this._items.length) {
                this.dlgPanel.remove((Component)this._items[n]);
                ++n;
            }
            this._items = new LWComponent[0];
        }
        ((Container)((Object)this)).validate();
    }

    private LWComponent createComponent(String string) {
        Object object = null;
        object = string.equalsIgnoreCase(POPDOWN) ? new LWChoice() : (string.equalsIgnoreCase(SECURE) ? new LWPasswordField() : new LWTextField());
        return object;
    }

    public boolean isProtected(String string) {
        if (string.equalsIgnoreCase("Selections")) {
            int n = this._items.length;
            int n2 = 0;
            while (n2 < n) {
                LWComponent lWComponent = this._items[n2];
                if (lWComponent instanceof LWPasswordField) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void addItem(LWComponent lWComponent, int n, boolean bl) {
        this.invalidate();
        this.c.weighty = bl ? 1.0 : 0.0;
        this.c.gridx = 1;
        this.c.gridy = n;
        this.c.weightx = 0.99;
        this.c.gridwidth = 0;
        this.gridbag.setConstraints((Component)lWComponent, this.c);
        this.dlgPanel.add((Component)lWComponent);
        ((Container)((Object)this)).validate();
    }

    public void setSelections(String[] stringArray) {
        int n = this._items.length;
        if (stringArray.length < this._items.length) {
            n = stringArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            LWComponent lWComponent = this._items[n2];
            if (lWComponent instanceof LWChoice) {
                ((LWChoice)lWComponent).select(stringArray[n2]);
            } else if (lWComponent instanceof LWPasswordField) {
                ((LWPasswordField)lWComponent).setText(stringArray[n2]);
            } else if (lWComponent instanceof LWTextField) {
                ((LWTextField)lWComponent).setText(stringArray[n2]);
            }
            ++n2;
        }
    }

    public void setChoices(String[] stringArray) {
        this._choices = stringArray;
        this.refreshChoices();
    }

    private void refreshChoices() {
        LWChoice lWChoice = null;
        int n = 0;
        while (n < this._items.length) {
            if (this._items[n] instanceof LWChoice) {
                lWChoice = (LWChoice)this._items[n];
                break;
            }
            ++n;
        }
        if (lWChoice != null && this._choices != null) {
            this.invalidate();
            lWChoice.removeAll();
            int n2 = 0;
            while (n2 < this._choices.length) {
                lWChoice.addItem(this._choices[n2]);
                ++n2;
            }
            ((Container)((Object)this)).validate();
        }
    }

    public void markPrompt() {
        this._prompt.setBackground(this._markColor);
    }

    public void markLabels() {
        int n = 0;
        while (n < this._labels.length) {
            this._labels[n].setBackground(this._markColor);
            ++n;
        }
    }

    public void markTypes() {
        int n = 0;
        while (n < this._items.length) {
            this._items[n].setBackground(this._markColor);
            ++n;
        }
    }

    public void markSelections() {
        this.markTypes();
    }

    public void markChoices() {
        int n = 0;
        while (n < this._items.length) {
            if (this._items[n] instanceof LWChoice) {
                this._items[n].setBackground(this._markColor);
                break;
            }
            ++n;
        }
    }

    public void unmarkPrompt() {
        this._prompt.setBackground(this._promptColor);
    }

    public void unmarkLabels() {
        int n = 0;
        while (n < this._labels.length) {
            this._labels[n].setBackground(this._itemColor);
            ++n;
        }
    }

    public void unmarkTypes() {
        int n = 0;
        while (n < this._items.length) {
            this._items[n].setBackground(this._itemColor);
            ++n;
        }
    }

    public void unmarkSelections() {
        this.unmarkTypes();
    }

    public void unmarkChoices() {
        int n = 0;
        while (n < this._items.length) {
            if (this._items[n] instanceof LWChoice) {
                this._items[n].setBackground(this._itemColor);
                break;
            }
            ++n;
        }
    }

    private void updateLabelsAssociation() {
        if (this._labels != null && this._items != null) {
            int n = this._labels.length;
            if (this._items.length < this._labels.length) {
                n = this._items.length;
            }
            int n2 = 0;
            while (n2 < n) {
                this._labels[n2].setLabelFor((Component)this._items[n2]);
                ++n2;
            }
        }
    }
}

