/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;

public class OiPasswordPanel
extends OiifpWizPanel {
    private static final int INSETS = 5;
    private static final String DEFAULT_TITLE = OiStdDialogRes.getString("Password_DefaultTitle");
    private static final String DEFAULT_PROMPT = OiStdDialogRes.getString("Password_DefaultPrompt");
    private static final String PASSWORD_STR = OiStdDialogRes.getString("Password_PasswordStr");
    private static final String CONFIRM_STR = OiStdDialogRes.getString("Password_PasswordConfirmStr");
    private static final String PASSWORD_MISMATCH_STR = OiStdDialogRes.getString("Password_PasswordMismatchStr");
    private MultiLineLabel _prompt = new MultiLineLabel(WordWrapper.getTextWrapper(), DEFAULT_PROMPT);
    private LWLabel _passwordLabel = null;
    private LWLabel _confirmLabel = null;
    private LWPasswordField _password = null;
    private LWPasswordField _confirm = null;
    private Color _promptColor = null;
    private Color _passwordColor = null;
    private Color _passwordLabelColor = null;
    private Color _confirmLabelColor = null;
    private String m_strOriginalPassword = null;

    public OiPasswordPanel() {
        super(DEFAULT_TITLE);
        this._prompt.setPreferredAspectRatio(0.0f);
        this.mainPanel.add((Component)this._prompt, "North");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.dlgPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        this._passwordLabel = new LWLabel(PASSWORD_STR);
        gridBagLayout.setConstraints((Component)this._passwordLabel, gridBagConstraints);
        this.dlgPanel.add((Component)this._passwordLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this._password = new LWPasswordField();
        this._passwordLabel.setLabelFor((Component)this._password);
        gridBagLayout.setConstraints((Component)this._password, gridBagConstraints);
        this.dlgPanel.add((Component)this._password);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        this._confirmLabel = new LWLabel(CONFIRM_STR);
        gridBagLayout.setConstraints((Component)this._confirmLabel, gridBagConstraints);
        this.dlgPanel.add((Component)this._confirmLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this._confirm = new LWPasswordField();
        this._confirmLabel.setLabelFor((Component)this._confirm);
        gridBagLayout.setConstraints((Component)this._confirm, gridBagConstraints);
        this.dlgPanel.add((Component)this._confirm);
        this._promptColor = this._prompt.getBackground();
        this._passwordLabelColor = this._passwordLabel.getBackground();
        this._confirmLabelColor = this._confirmLabel.getBackground();
        this._passwordColor = this._password.getBackground();
    }

    public boolean isProtected(String string) {
        return string.equals("Password");
    }

    public String getPrompt() {
        return this._prompt.getText();
    }

    public String getPasswordLabel() {
        return this._passwordLabel.getText();
    }

    public String getConfirmLabel() {
        return this._confirmLabel.getText();
    }

    public String getPassword() {
        String string = this._password.getText();
        if (!string.equals(this._confirm.getText())) {
            string = this.m_strOriginalPassword;
            this._password.setText(string);
            this._confirm.setText(string);
        }
        return string;
    }

    public boolean validateInput() {
        boolean bl = true;
        if (!this._password.getText().equals(this._confirm.getText())) {
            OiifmCursorUtil.setCursor((Cursor)Cursor.getDefaultCursor(), (Component)((Object)this));
            OiifmAlert.displayError((String)PASSWORD_MISMATCH_STR);
            bl = false;
        }
        return bl;
    }

    public void setPrompt(String string) {
        this.invalidate();
        this._prompt.setText(string);
        ((Container)((Object)this)).validate();
    }

    public void setPasswordLabel(String string) {
        this.invalidate();
        this._passwordLabel.setText(string);
        ((Container)((Object)this)).validate();
    }

    public void setConfirmLabel(String string) {
        this.invalidate();
        this._confirmLabel.setText(string);
        ((Container)((Object)this)).validate();
    }

    public void setPassword(String string) {
        this.m_strOriginalPassword = string;
        if (string != null) {
            this.invalidate();
            this._password.setText(string);
            this._confirm.setText(string);
            ((Container)((Object)this)).validate();
        }
    }

    public void markPrompt() {
        this._prompt.setBackground(this._markColor);
    }

    public void markPasswordLabel() {
        this._passwordLabel.setBackground(this._markColor);
    }

    public void markConfirmLabel() {
        this._confirmLabel.setBackground(this._markColor);
    }

    public void markPassword() {
        this._password.setBackground(this._markColor);
        this._confirm.setBackground(this._markColor);
    }

    public void unmarkPrompt() {
        this._prompt.setBackground(this._promptColor);
    }

    public void unmarkPasswordLabel() {
        this._passwordLabel.setBackground(this._passwordLabelColor);
    }

    public void unmarkConfirmLabel() {
        this._confirmLabel.setBackground(this._confirmLabelColor);
    }

    public void unmarkPassword() {
        this._password.setBackground(this._passwordColor);
        this._confirm.setBackground(this._passwordColor);
    }
}

