/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiip.oiipg.OiipgReadRGS;

class ReadRGS {
    private boolean m_bDebug = false;
    String m_sFileName;
    BufferedInputStream m_bis;
    Vector m_vRgsTable = new Vector();

    ReadRGS() {
    }

    void init(String string) throws IOException {
        this.m_sFileName = this.getRgsFileLocation(string);
        this.debug("****Rgs file " + this.m_sFileName);
        FileInputStream fileInputStream = new FileInputStream(this.m_sFileName);
        this.m_bis = new BufferedInputStream(fileInputStream, 1024);
    }

    public String getRgsFileLocation(String string) {
        return new OiipgReadRGS().getRgsFileName(string);
    }

    public Vector getRgsTable() {
        return this.m_vRgsTable;
    }

    private void addRgsEntry(Vector vector) {
        RgsEntry rgsEntry = new RgsEntry();
        String string = (String)vector.elementAt(0);
        rgsEntry.setID(new Integer(string));
        rgsEntry.setName((String)vector.elementAt(1));
        rgsEntry.setParentRegistry((String)vector.elementAt(2));
        rgsEntry.setFileName((String)vector.elementAt(3));
        rgsEntry.setVersion((String)vector.elementAt(4));
        rgsEntry.setInterfaceLabel((String)vector.elementAt(5));
        rgsEntry.setSize(new Long((String)vector.elementAt(6)));
        rgsEntry.setRegDate((String)vector.elementAt(7));
        rgsEntry.setReferences((String)vector.elementAt(8));
        this.m_vRgsTable.addElement(rgsEntry);
    }

    public void doReadRgs() throws IOException {
        String string;
        while ((string = this.readNextLine()) != null) {
            this.debug(string);
            Vector vector = this.splitRgsLine(string);
            this.addRgsEntry(vector);
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                this.debug("\nEntry #" + n2 + " : " + (String)vector.elementAt(n2));
                ++n2;
            }
            this.debug("\nNextLine================");
        }
        this.m_bis.close();
    }

    String readNextLine() throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (!bl) {
            int n = this.m_bis.read();
            if (n == -1) break;
            if (n == 10) {
                bl = true;
                continue;
            }
            stringBuffer.append((char)n);
        }
        if ((string = stringBuffer.toString().trim()).length() == 0) {
            return null;
        }
        return string;
    }

    Vector splitRgsLine(String string) {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = null;
        string = string.trim();
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case ' ': {
                    if (!bl) break;
                    if (bl2) {
                        stringBuffer.append(c);
                        break;
                    }
                    bl = false;
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = null;
                    break;
                }
                case '\"': {
                    if (!bl) {
                        bl2 = true;
                        bl = true;
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append(c);
                    bl2 = false;
                    bl = false;
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = null;
                    break;
                }
                default: {
                    if (!bl) {
                        bl = true;
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        if (stringBuffer != null) {
            vector.addElement(stringBuffer.toString());
        }
        return vector;
    }

    private void debug(String string) {
        if (this.m_bDebug) {
            System.err.println("ReadRgs : " + string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            ReadRGS readRGS = new ReadRGS();
            readRGS.init("c:\\orant\\orainst\\nt.rgs");
            readRGS.doReadRgs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

