/*
 * Decompiled with CFR 0.152.
 */
package oracle.ntpg.nlslang;

import java.util.Locale;
import oracle.gss.util.NLSLocale;
import oracle.ntpg.nlslang.Lang2Charset;
import oracle.ntpg.nlslang.Lang2Territory;
import oracle.ntpg.nlslang.Language;
import oracle.ntpg.nlslang.ObjFactory;

public class NlsLang {
    private Language m_language;
    private String m_territory;
    private String m_charset;
    private static ObjFactory m_objFactory;

    public NlsLang(String string) {
        this.m_language = new Language(string);
        this.m_territory = null;
        this.m_charset = null;
    }

    public NlsLang(String string, String string2) {
        this.m_language = new Language(string);
        this.m_territory = string2;
        this.m_charset = null;
    }

    public NlsLang(String string, String string2, String string3) {
        this.m_language = new Language(string);
        this.m_territory = string2;
        this.m_charset = string3;
    }

    public static NlsLang getDefault() {
        NLSLocale nLSLocale = NLSLocale.getInstance();
        String string = nLSLocale.getNlsLanguage(Locale.getDefault());
        if (string == null) {
            return null;
        }
        return new NlsLang(string);
    }

    public static NlsLang getFallback() {
        return new NlsLang("AMERICAN", "AMERICA", "US7ASCII");
    }

    public String getLanguage() {
        return this.m_language.getName();
    }

    public String getTerritory() {
        if (this.m_territory == null) {
            return this.m_language.getTerritory();
        }
        return this.m_territory;
    }

    public String getCharacterSet() {
        if (this.m_charset == null) {
            return this.m_language.getCharacterSet();
        }
        return this.m_charset;
    }

    public boolean setLanguage(String string) {
        this.m_language.setName(string);
        return true;
    }

    public boolean setTerritory(String string) {
        this.m_territory = string;
        return true;
    }

    public boolean setCharacterSet(String string) {
        this.m_charset = string;
        return true;
    }

    public String toString() {
        String string = String.valueOf(this.m_language.getName()) + "_";
        string = this.m_territory != null ? String.valueOf(string) + this.m_territory : String.valueOf(string) + this.m_language.getTerritory();
        string = this.m_charset != null ? String.valueOf(string) + "." + this.m_charset : String.valueOf(string) + "." + this.m_language.getCharacterSet();
        return string;
    }

    public static String[] getAvailableLanguages() {
        if (m_objFactory == null) {
            m_objFactory = ObjFactory.getInstance();
        }
        Lang2Territory lang2Territory = m_objFactory.getLang2Territory();
        return lang2Territory.getAvailableLanguages();
    }

    public static String[] getAvailableTerritories() {
        if (m_objFactory == null) {
            m_objFactory = ObjFactory.getInstance();
        }
        Lang2Territory lang2Territory = m_objFactory.getLang2Territory();
        return lang2Territory.getAvailableTerritories();
    }

    public static String[] getAvailableCharacterSets() {
        if (m_objFactory == null) {
            m_objFactory = ObjFactory.getInstance();
        }
        Lang2Charset lang2Charset = m_objFactory.getLang2Charset();
        return lang2Charset.getAvailableCharsets();
    }
}

