/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.Vector;
import oracle.net.TNSAddress.AddressList;
import oracle.net.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;

public class NavAddressList
extends AddressList
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int sBuflength;

    public NavAddressList(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        super(schemaObjectFactoryInterface);
    }

    public void navigate(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        this.sBuflength = stringBuffer.length();
        stringBuffer.append("(ADDRESS_LIST=");
        if (this.sourceRoute) {
            this.activeChildren = this.children;
            ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(connStrategy, stringBuffer);
            int n = 1;
            while (n < this.activeChildren.size()) {
                ((NavSchemaObject)this.activeChildren.elementAt(n)).addToString(connStrategy);
                ++n;
            }
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            int n = 0;
            while (n < this.activeChildren.size()) {
                ((NavSchemaObject)this.activeChildren.elementAt(n)).navigate(connStrategy, stringBuffer);
                ++n;
            }
        }
        this.closeNVPair(connStrategy);
        stringBuffer.setLength(this.sBuflength);
    }

    public void addToString(ConnStrategy connStrategy) {
        String string = this.toString();
        int n = connStrategy.cOpts.size() - 1;
        while (n >= 0 && !((ConnOption)connStrategy.cOpts.elementAt((int)n)).done) {
            ((ConnOption)connStrategy.cOpts.elementAt((int)n)).conn_data.append(string);
            --n;
        }
    }

    public String toString() {
        String string = new String("");
        string = String.valueOf(string) + "(ADDRESS_LIST=";
        int n = 0;
        while (n < this.children.size()) {
            string = String.valueOf(string) + ((NavSchemaObject)this.children.elementAt(n)).toString();
            ++n;
        }
        if (this.sourceRoute) {
            string = String.valueOf(string) + "(SOURCE_ROUTE=yes)(HOP_COUNT=0)";
        }
        if (this.loadBalance) {
            string = String.valueOf(string) + "(LOAD_BALANCE=yes)";
        }
        if (!this.failover) {
            string = String.valueOf(string) + "(FAILOVER=false)";
        }
        string = String.valueOf(string) + ")";
        return string;
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public int getChildrenType(int n) {
        return ((NavSchemaObject)this.children.elementAt(n)).isA();
    }

    public NavAddress getChild(int n) {
        return (NavAddress)this.children.elementAt(n);
    }

    private void closeNVPair(ConnStrategy connStrategy) {
        int n = connStrategy.cOpts.size() - 1;
        while (n >= 0 && !((ConnOption)connStrategy.cOpts.elementAt((int)n)).done) {
            if (this.sourceRoute) {
                ((ConnOption)connStrategy.cOpts.elementAt((int)n)).conn_data.append("(SOURCE_ROUTE=yes)");
                ((ConnOption)connStrategy.cOpts.elementAt((int)n)).conn_data.append("(HOP_COUNT=0)");
            }
            ((ConnOption)connStrategy.cOpts.elementAt((int)n)).conn_data.append(")");
            --n;
        }
    }
}

