/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ultrasearch.crawler.CookiePolicy;
import oracle.ultrasearch.crawler.CrawlerErrorMessage;
import oracle.ultrasearch.crawler.WebCrawler;
import oracle.ultrasearch.crawler.WebCrawlerException;
import oracle.ultrasearch.util.LazyOutputStream;
import oracle.ultrasearch.util.io.CustomPrintWriter;

public class ImtCrawler
implements Runnable {
    public static final int CRAWLER_LAUNCH_SUCCESS_TOKEN_LENGTH = 100;
    public static final int CACHE_QUEUE_DEFAULT_HIGH_WATERMARK = 10;
    public static final int CACHE_QUEUE_DEFAULT_LOW_WATERMARK = 1;
    public static final String PRODUCT_VERSION = "9.2.0.7 Production";
    public static final String LOCAL_ORACLE = "LOCAL";
    protected boolean DEBUG_TIMING = false;
    protected String m_portal_contentarea_urlbase = null;
    protected String m_portal_contentarea_siteid = null;
    protected String m_portal_contentarea_deflang = null;
    protected String m_portal_contentarea_name = null;
    private String[] m_argv;
    private WebCrawler m_crawler;
    private int m_telnet_port = -1;
    private String m_database = "LOCAL";
    private Vector m_seedList = null;
    private Vector m_blackList = null;
    private String[] m_mimeInclude = null;
    private String[] m_fileInclude = null;
    private String[] m_fileExclude = null;
    private String[] m_pathInclude = null;
    private String[] m_pathExclude = null;
    private String m_urlColName = "url";
    private String m_depthColName = "depth";
    private String m_checksumColName = "checksum";
    private String m_lastmodColName = "last_modified";
    private String m_statusColName = "status";
    private String m_urlidColName = "url_id";
    private String m_accessurlColName = "access_url";
    private String m_enqueueStatusColName = "enqueue_status";
    private String m_filterPath = null;
    private int m_threadNum = 5;
    private int m_filterNum = 1;
    private boolean m_cachingOn = false;
    private int m_cacheQueHighMark = 10;
    private int m_cacheQueLowMark = 1;
    private int m_cacheSize = -1;
    private String m_cacheDir = null;
    private String m_serverCacheDir = null;
    private String m_archiveDir = null;
    private String m_cacheFullAction = "stop";
    private String m_cacheCharSet = "8859_1";
    private String m_defaultCharSet = "8859_1";
    private String m_defaultLanguage = "en";
    private String m_user = null;
    private PrintWriter m_log = null;
    private PrintWriter m_err = null;
    private LazyOutputStream m_lazyout = null;
    private boolean isTestMode = false;
    private boolean m_fileProtocol = true;
    private int m_readTimeout = 0;
    private String m_sqlCallbackStmt = null;
    private boolean m_autoLanguageDetection = false;
    private String m_trainingDocDir = null;
    private Vector m_trainSet = null;
    private String[] m_proxyExclusion = null;
    private int m_ds_id = -1;
    private boolean m_ds_set = false;
    private String m_agent = null;
    private String m_dsName = null;
    private String m_schedName = null;
    private boolean m_crawlOnly = false;
    private boolean m_indexOnly = false;
    private boolean m_forceRecrawl = false;
    private boolean m_ignoreRobotsExclusion = false;
    private boolean m_supportCookie = false;
    private boolean m_traceCookie = false;
    private int m_totalCookies = 0;
    private int m_totalDomainCookies = 0;
    private int m_maxCookieSize = 0;
    private static final int S_CORE_ATTR_COUNT = 8;
    private String m_titleColName = null;
    private String m_bodyColName = null;
    private String m_authorColName = null;
    private String m_crawltimeColName = null;
    private String m_cntlengthColName = null;
    private String m_cnttypeColName = null;
    private String m_insoFormatColName = null;
    private String m_languageColName = null;
    private String m_cacheFilePathColName = null;
    private String m_datasourceColName = null;
    private int m_dataSourceType = -1;
    private static final int S_OPTION_ATTR_COUNT = 10;
    private boolean[] m_collectionSet = new boolean[]{false, false, false, false, false, false, false, false, false, false};
    private String[] m_urlTableColumnNames = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final String PROG_NAME = "ImtCrawler";
    private CrawlerErrorMessage m_crwerr = new CrawlerErrorMessage();
    private Locale m_locale = null;
    private int m_tokenCount = 0;

    public static void main(String[] stringArray) {
        ImtCrawler imtCrawler = new ImtCrawler(stringArray);
        imtCrawler.run();
    }

    public void sendLaunchSuccessToken() {
        if (this.DEBUG_TIMING) {
            this.m_err.println("Time(seconds)=" + System.currentTimeMillis() / 1000L + " -- ImtCrawler: crawler begins transmitting launch-success token");
        }
        int n = 100;
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)n2;
            ++n2;
        }
        String string = new String(cArray);
        this.m_err.print(string);
        this.m_err.flush();
        if (this.DEBUG_TIMING) {
            this.m_err.println("Time(seconds)=" + System.currentTimeMillis() / 1000L + " -- ImtCrawler: crawler completes transmitting launch-success token");
        }
    }

    public ImtCrawler(String[] stringArray) {
        this.m_argv = stringArray;
        this.m_seedList = new Vector();
        this.m_blackList = new Vector();
    }

    public String fixPathSlashes(String string) {
        if (string == null) {
            return null;
        }
        return string;
    }

    public void run() {
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = this.m_argv.length - 1;
        String string = "crawl";
        String string2 = null;
        String string3 = "imtcrawler.cfg";
        String string4 = null;
        int n2 = this.m_threadNum;
        int n3 = 0;
        int n4 = -1;
        long l = 0L;
        long l2 = 0L;
        String string5 = null;
        int n5 = 0;
        int n6 = 0;
        boolean bl4 = false;
        StringTokenizer stringTokenizer = null;
        String string6 = "beginning of run()";
        try {
            this.m_log = new CustomPrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF8"), true);
            this.m_err = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, "UTF8"), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_log = new CustomPrintWriter((OutputStream)System.out, true);
            this.m_err = new PrintWriter((Writer)new OutputStreamWriter(System.err), true);
            this.m_err.println(unsupportedEncodingException.toString());
        }
        if (n < 0) {
            this.m_log.println(this.m_crwerr.getMsg(30401));
            this.m_err.println(this.m_crwerr.getMsg(30401));
            this.usage();
            System.exit(1);
        }
        String string7 = null;
        if (n == 0 && (string7 = this.m_argv[0].toLowerCase()).indexOf("-oracle") != -1) {
            stringTokenizer = new StringTokenizer(this.m_argv[0], " \t\r\n");
            bl4 = true;
        }
        string6 = "setLocale()";
        this.setLocale(string7, n);
        string4 = this.OpenLogFile(bl4, string7, n);
        try {
            Object[] objectArray;
            Object object;
            Enumeration enumeration;
            int n7;
            String[] stringArray;
            string6 = "get WebCrawler and set log writer and jdbc driver";
            this.m_crawler = WebCrawler.getInstance();
            this.m_crawler.setLogWriter(this.m_log, string4);
            this.m_crawler.setJdbcDriver("oracle.jdbc.driver.OracleDriver");
            String string8 = null;
            boolean bl5 = false;
            string6 = "scan command line";
            while ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) != null) {
                bl5 = false;
                if (string8.equals("-verbose")) {
                    bl = true;
                    this.m_crawler.setVerbose(true);
                    continue;
                }
                if (string8.equals("-print_time")) {
                    bl2 = true;
                    this.m_crawler.setPrintTime(true);
                    if (!bl2) continue;
                    ((CustomPrintWriter)this.m_log).setMode(700);
                    continue;
                }
                if (string8.equals("-depth")) {
                    if ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) == null) {
                        this.m_log.println(this.m_crwerr.getMsg(30402));
                        this.m_err.println(this.m_crwerr.getMsg(30402));
                        this.usage();
                        System.exit(1);
                    }
                    try {
                        n4 = Integer.parseInt(string8);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_log.println(this.m_crwerr.getMsg(30403, string8));
                        this.m_err.println(this.m_crwerr.getMsg(30403, string8));
                        this.usage();
                        System.exit(1);
                    }
                    if (n4 >= 0) continue;
                    this.m_log.println(this.m_crwerr.getMsg(30404, Integer.toString(n4)));
                    this.m_err.println(this.m_crwerr.getMsg(30404, Integer.toString(n4)));
                    this.usage();
                    System.exit(1);
                    continue;
                }
                if (string8.equals("-urltable")) {
                    if ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) == null || string8.startsWith("-")) {
                        this.m_log.println(this.m_crwerr.getMsg(30405));
                        this.m_err.println(this.m_crwerr.getMsg(30405));
                        this.usage();
                        System.exit(1);
                    }
                    string = string8;
                    continue;
                }
                if (string8.equals("-telnet_port")) {
                    if ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) == null || string8.startsWith("-")) {
                        this.usage();
                        System.exit(1);
                    }
                    try {
                        this.m_telnet_port = Integer.parseInt(string8);
                    }
                    catch (Exception exception) {
                        this.usage();
                        System.exit(1);
                    }
                    continue;
                }
                if (string8.equals("-config")) {
                    String string9;
                    if ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) == null || string8.startsWith("-")) {
                        this.m_log.println(this.m_crwerr.getMsg(30406));
                        this.m_err.println(this.m_crwerr.getMsg(30406));
                        this.usage();
                        System.exit(1);
                    }
                    string3 = string9 = this.fixPathSlashes(string8);
                    continue;
                }
                if (string8.equals("-seed")) {
                    if ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) == null || string8.startsWith("-")) {
                        this.m_log.println(this.m_crwerr.getMsg(30407));
                        this.m_err.println(this.m_crwerr.getMsg(30407));
                        this.usage();
                        System.exit(1);
                    }
                    do {
                        this.m_seedList.addElement(string8);
                    } while ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) != null && !string8.startsWith("-"));
                    bl5 = true;
                    continue;
                }
                if (string8.equals("-queue")) {
                    if ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) == null || string8.startsWith("-")) {
                        this.m_log.println(this.m_crwerr.getMsg(30425));
                        this.m_err.println(this.m_crwerr.getMsg(30425));
                        this.usage();
                        System.exit(1);
                    }
                    string2 = string8;
                    continue;
                }
                if (string8.equals("-sync")) {
                    if (!bl3) {
                        this.m_log.println(this.m_crwerr.getMsg(30408));
                        this.m_err.println(this.m_crwerr.getMsg(30408));
                        this.usage();
                        System.exit(1);
                    }
                    if ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) == null) {
                        this.m_log.println(this.m_crwerr.getMsg(30409));
                        this.m_err.println(this.m_crwerr.getMsg(30409));
                        this.usage();
                        System.exit(1);
                    }
                    if ((string5 = string8).equals("all")) {
                        n5 = 3;
                    } else {
                        try {
                            int n8 = Integer.parseInt(string5);
                            if (n8 > 0) {
                                n5 = n8;
                            } else {
                                this.m_log.println(this.m_crwerr.getMsg(30410, string5));
                                this.m_err.println(this.m_crwerr.getMsg(30410, string5));
                                this.usage();
                                System.exit(1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.m_log.println(this.m_crwerr.getMsg(30411, string8));
                            this.m_err.println(this.m_crwerr.getMsg(30411, string8));
                            this.usage();
                            System.exit(1);
                        }
                    }
                    string8 = this.getNexttoken(stringTokenizer, n, bl5, string8);
                    if (string8 != null && string8.toLowerCase().equals("purge")) {
                        n6 = n5 + 10000;
                        continue;
                    }
                    n6 = n5;
                    bl5 = true;
                    continue;
                }
                if (string8.equals("-thread")) {
                    if ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) == null) {
                        this.m_log.println(this.m_crwerr.getMsg(30412));
                        this.m_err.println(this.m_crwerr.getMsg(30412));
                        this.usage();
                        System.exit(1);
                    }
                    try {
                        n2 = Integer.parseInt(string8);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_log.println(this.m_crwerr.getMsg(30413, string8));
                        this.m_err.println(this.m_crwerr.getMsg(30413, string8));
                        this.usage();
                        System.exit(1);
                    }
                    if (n2 <= 0) {
                        this.m_log.println(this.m_crwerr.getMsg(30414, Integer.toString(n2)));
                        this.m_err.println(this.m_crwerr.getMsg(30414, Integer.toString(n2)));
                        this.usage();
                        System.exit(1);
                    }
                    this.m_threadNum = n2;
                    continue;
                }
                if (string8.equals("-page")) {
                    if ((string8 = this.getNexttoken(stringTokenizer, n, bl5, string8)) == null) {
                        this.m_log.println(this.m_crwerr.getMsg(30416));
                        this.m_err.println(this.m_crwerr.getMsg(30416));
                        this.usage();
                        System.exit(1);
                    }
                    try {
                        n3 = Integer.parseInt(string8);
                        if (n3 > 0) continue;
                        this.m_log.println(this.m_crwerr.getMsg(30417, Integer.toString(n3)));
                        this.m_err.println(this.m_crwerr.getMsg(30417, Integer.toString(n3)));
                        System.exit(1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_log.println(this.m_crwerr.getMsg(30418, string8));
                        this.m_err.println(this.m_crwerr.getMsg(30418, string8));
                        System.exit(1);
                    }
                    continue;
                }
                if (string8.equals("-restart")) {
                    if (n5 > 0) {
                        this.m_log.println(this.m_crwerr.getMsg(30408));
                        this.m_err.println(this.m_crwerr.getMsg(30408));
                        this.usage();
                        System.exit(1);
                    }
                    bl3 = false;
                    continue;
                }
                if (string8.equals("-log")) {
                    string8 = this.getNexttoken(stringTokenizer, n, bl5, string8);
                    continue;
                }
                if (string8.equals("-locale")) {
                    string8 = this.getNexttoken(stringTokenizer, n, bl5, string8);
                    continue;
                }
                if (string8.equals("-oracle")) continue;
                if (string8.equals("-test")) {
                    this.isTestMode = true;
                    this.m_crawler.setTestMode(this.isTestMode);
                    continue;
                }
                if (string8.equals("-help")) {
                    this.usage();
                    System.exit(0);
                    continue;
                }
                if (string8.equals("-version")) {
                    this.m_log.println(this.m_crwerr.getMsg("Product"));
                    this.m_log.println(this.m_crwerr.getMsg("Copyright"));
                    System.exit(0);
                    continue;
                }
                if (string8.equals("-nocache")) {
                    this.m_crawlOnly = true;
                    continue;
                }
                if (string8.equals("-index")) {
                    this.m_indexOnly = true;
                    continue;
                }
                if (string8.equals("-recrawl")) {
                    this.m_forceRecrawl = true;
                    continue;
                }
                if (!string8.startsWith("-")) continue;
                this.m_log.println(this.m_crwerr.getMsg(30419, string8));
                this.m_err.println(this.m_crwerr.getMsg(30419, string8));
                this.usage();
                System.exit(1);
            }
            this.m_log.println();
            String string10 = this.m_crwerr.getMsg("Product");
            string10 = string10.substring(0, string10.lastIndexOf("9")) + PRODUCT_VERSION;
            this.m_log.println(string10);
            this.m_log.println(this.m_crwerr.getMsg("Copyright"));
            this.m_log.println();
            this.m_log.println("================== " + this.m_crwerr.getMsg(30302) + "==================");
            if (this.m_crawlOnly && !this.m_indexOnly) {
                this.m_crawler.setCrawlOnly(this.m_crawlOnly);
                this.m_log.println(this.m_crwerr.getMsg(30379));
            } else if (this.m_indexOnly && !this.m_crawlOnly) {
                this.m_crawler.setIndexOnly(this.m_indexOnly);
                this.m_log.println(this.m_crwerr.getMsg(30380));
            }
            if (this.m_forceRecrawl) {
                this.m_crawler.setForceRecrawl(this.m_forceRecrawl);
                this.m_log.println(this.m_crwerr.getMsg(30381));
            }
            this.m_log.println(this.m_crwerr.getMsg(30516, string3));
            string6 = "read config file";
            this.readConfigFile(string3);
            string6 = "test number of threads allowed";
            if (!this.withinMaxFileDescriptor(string3, n2)) {
                this.m_log.println(this.m_crwerr.getMsg(30415, Integer.toString(n2)));
                this.m_err.println(this.m_crwerr.getMsg(30415, Integer.toString(n2)));
                this.usage();
                System.exit(1);
            }
            if (this.m_user == null) {
                this.m_log.println(this.m_crwerr.getMsg(30420));
                this.m_err.println(this.m_crwerr.getMsg(30420));
                this.usage();
                System.exit(1);
            }
            this.m_log.println(this.m_crwerr.getMsg(30501, this.m_user));
            if (this.m_database != null) {
                if (bl4) {
                    this.m_crawler.setJdbcDataSource("jdbc:oracle:kprb:@" + this.m_database);
                    this.m_log.println(this.m_crwerr.getMsg(30502, "jdbc:oracle:kprb:@", this.m_database));
                } else if (this.m_database.compareTo(LOCAL_ORACLE) == 0) {
                    this.m_crawler.setJdbcDataSource("jdbc:oracle:oci8:@");
                    this.m_log.println(this.m_crwerr.getMsg(30502, "jdbc:oracle:oci8:@", ""));
                } else {
                    this.m_crawler.setJdbcDataSource("jdbc:oracle:thin:@" + this.m_database);
                    this.m_log.println(this.m_crwerr.getMsg(30502, "jdbc:oracle:thin:@", this.m_database));
                }
            } else {
                this.m_log.println(this.m_crwerr.getMsg(30421));
                this.m_err.println(this.m_crwerr.getMsg(30421));
                System.exit(1);
            }
            if (this.m_blackList.size() > 0) {
                string6 = "blacklist URL setup";
                stringArray = new String[this.m_blackList.size()];
                n7 = 0;
                enumeration = this.m_blackList.elements();
                while (enumeration.hasMoreElements()) {
                    stringArray[n7++] = (String)enumeration.nextElement();
                }
                this.m_crawler.setBlacklistURLs(stringArray);
                this.m_blackList.removeAllElements();
            }
            string6 = "display data source type";
            switch (this.m_dataSourceType) {
                case 1: {
                    this.m_log.println(this.m_crwerr.getMsg(30540));
                    break;
                }
                case 2: {
                    this.m_log.println(this.m_crwerr.getMsg(30541));
                    break;
                }
                case 3: {
                    this.m_log.println(this.m_crwerr.getMsg(30542));
                    break;
                }
                case 4: {
                    this.m_log.println(this.m_crwerr.getMsg(30543));
                    break;
                }
                case 5: {
                    this.m_log.println(this.m_crwerr.getMsg(30544));
                    break;
                }
                default: {
                    if (this.m_dataSourceType > 100) {
                        this.m_log.println(this.m_crwerr.getMsg(30545));
                        break;
                    }
                    if (this.m_dataSourceType == -1) break;
                    this.m_log.println(this.m_crwerr.getMsg(30100, "Invalid data source type id: " + this.m_dataSourceType, "ImtCrawler.run, " + string6));
                }
            }
            string6 = "display data source name";
            if (this.m_dsName != null) {
                this.m_log.println(this.m_crwerr.getMsg(30539, this.m_dsName));
            }
            string6 = "seed URL setup";
            stringArray = new String[this.m_seedList.size()];
            n7 = 0;
            enumeration = this.m_seedList.elements();
            while (enumeration.hasMoreElements()) {
                if (n5 > 0) {
                    enumeration.nextElement();
                    continue;
                }
                stringArray[n7++] = (String)enumeration.nextElement();
            }
            if (n7 > 0) {
                this.m_log.print(this.m_crwerr.getMsg(30503));
                int n9 = 0;
                while (n9 < n7) {
                    this.m_log.print(" " + stringArray[n9]);
                    ++n9;
                }
                this.m_log.println();
            }
            this.m_seedList.removeAllElements();
            if (n5 > 0) {
                this.m_crawler.setSeedURLs(null);
            } else {
                this.m_crawler.setSeedURLs(stringArray);
            }
            this.m_crawler.setMinThreads(1);
            this.m_crawler.setMaxThreads(n2);
            this.m_log.println(this.m_crwerr.getMsg(30504, Integer.toString(n2)));
            if (string2 != null) {
                this.m_crawler.setQueueTableName(string2);
                this.m_log.println(this.m_crwerr.getMsg(30518, string2));
            } else {
                string2 = string;
                this.m_crawler.setQueueTableName(string2);
            }
            string6 = "finish setting queueTableName = " + string2;
            this.m_crawler.setBaseTableName(string);
            this.m_log.println(this.m_crwerr.getMsg(30505, string));
            this.m_crawler.setDataSourceType(this.m_dataSourceType);
            if (this.m_dataSourceType == 5) {
                this.m_crawler.setIsPortalCrawl(true);
            } else {
                this.m_crawler.setIsPortalCrawl(false);
            }
            this.m_crawler.setPortalContentAreaName(this.m_portal_contentarea_name);
            this.m_crawler.setPortalContentAreaDefaultLanguage(this.m_portal_contentarea_deflang);
            this.m_crawler.setPortalContentAreaSiteid(this.m_portal_contentarea_siteid);
            this.m_crawler.setPortalContentAreaUrlbase(this.m_portal_contentarea_urlbase);
            this.m_crawler.setUserAgentName(this.m_agent);
            this.m_crawler.setMaxPagesToCrawl(n3);
            if (n3 > 0) {
                this.m_log.println(this.m_crwerr.getMsg(30506, Integer.toString(n3)));
            } else {
                this.m_log.println(this.m_crwerr.getMsg(30507));
            }
            if (n4 > -1) {
                this.m_crawler.setLevelToFollowLinks(n4);
                this.m_log.println(this.m_crwerr.getMsg(30508, Integer.toString(n4)));
            } else {
                this.m_log.println(this.m_crwerr.getMsg(30509));
            }
            if (this.m_locale != null) {
                this.m_log.println(this.m_crwerr.getMsg(30525, this.m_locale.toString()));
            }
            string6 = "set file protocol settings";
            this.m_crawler.setFileProtocolSupport(this.m_fileProtocol);
            if (!this.m_fileProtocol) {
                this.m_log.println(this.m_crwerr.getMsg(30522));
            } else {
                if (this.m_fileInclude != null) {
                    this.m_crawler.addLocalhostInclusions(this.m_fileInclude);
                    this.m_log.print(this.m_crwerr.getMsg(30523));
                    n7 = 0;
                    while (n7 < this.m_fileInclude.length) {
                        this.m_log.print(" " + this.m_fileInclude[n7]);
                        ++n7;
                    }
                    this.m_log.println();
                }
                if (this.m_fileExclude != null) {
                    this.m_crawler.addLocalhostExclusions(this.m_fileExclude);
                    this.m_log.print(this.m_crwerr.getMsg(30524));
                    n7 = 0;
                    while (n7 < this.m_fileExclude.length) {
                        this.m_log.print(" " + this.m_fileExclude[n7]);
                        ++n7;
                    }
                    this.m_log.println();
                }
            }
            if (this.m_pathInclude != null) {
                this.m_crawler.addPathInclusions(this.m_pathInclude);
                this.m_log.println(this.m_crwerr.getMsg(30531));
                n7 = 0;
                while (n7 < this.m_pathInclude.length) {
                    this.m_log.println("   " + this.m_pathInclude[n7]);
                    ++n7;
                }
            }
            if (this.m_pathExclude != null) {
                this.m_crawler.addPathExclusions(this.m_pathExclude);
                this.m_log.println(this.m_crwerr.getMsg(30532));
                n7 = 0;
                while (n7 < this.m_pathExclude.length) {
                    this.m_log.println("   " + this.m_pathExclude[n7]);
                    ++n7;
                }
            }
            if (this.m_readTimeout > 0) {
                this.m_crawler.setReadTimeout(this.m_readTimeout * 1000);
            } else {
                this.m_readTimeout = this.m_crawler.getReadTimeout() / 1000;
            }
            Object object2 = new MessageFormat(this.m_crwerr.getMsg(30517));
            Object object3 = new Object[]{String.valueOf(this.m_readTimeout)};
            this.m_log.println(((Format)object2).format(object3));
            object3 = null;
            this.m_crawler.setDefaultCharSet(this.m_defaultCharSet);
            this.m_log.println(this.m_crwerr.getMsg(30538, this.m_defaultCharSet));
            this.m_crawler.setDefaultLanguage(this.m_defaultLanguage);
            this.m_log.println(this.m_crwerr.getMsg(30537, this.m_defaultLanguage));
            this.m_crawler.setAutoLanguageDetection(this.m_autoLanguageDetection);
            if (this.m_ignoreRobotsExclusion) {
                this.m_log.println("Robots exclusion is ignored");
            }
            if (this.m_trainingDocDir != null) {
                this.m_crawler.setTrainingDocDir(this.m_trainingDocDir);
            }
            if (this.m_trainSet != null) {
                object2 = new String[this.m_trainSet.size()];
                n7 = 0;
                object3 = this.m_trainSet.elements();
                while (object3.hasMoreElements()) {
                    object2[n7++] = (String)object3.nextElement();
                }
                this.m_trainSet.removeAllElements();
                this.m_trainSet = null;
                this.m_crawler.setTrainingDocList((String[])object2);
            }
            if (this.m_autoLanguageDetection) {
                this.m_log.println(this.m_crwerr.getMsg(30520));
            } else {
                this.m_log.println(this.m_crwerr.getMsg(30521));
            }
            if (bl) {
                this.m_log.println(this.m_crwerr.getMsg(30529));
            } else {
                this.m_log.println(this.m_crwerr.getMsg(30530));
            }
            if (this.m_cachingOn) {
                string6 = "set caching on settings";
                object2 = System.getProperty("file.separator");
                object3 = this.m_cacheDir;
                object = null;
                object3 = !((String)object3).endsWith((String)object2) ? ((String)object3).concat((String)object2).concat(string2) : ((String)object3).concat(string2);
                if (this.m_serverCacheDir != null) {
                    object = !this.m_serverCacheDir.endsWith((String)object2) ? this.m_serverCacheDir.concat((String)object2).concat(string2) : this.m_serverCacheDir.concat(string2);
                }
                if ((objectArray = new File(this.m_cacheDir)).exists()) {
                    if (!objectArray.canWrite()) {
                        this.m_err.println(this.m_crwerr.getMsg(30725, this.m_cacheDir));
                        this.m_log.println(this.m_crwerr.getMsg(30725, this.m_cacheDir));
                        System.exit(1);
                    }
                } else if (!objectArray.mkdirs()) {
                    this.m_err.println(this.m_crwerr.getMsg(30726, this.m_cacheDir));
                    this.m_log.println(this.m_crwerr.getMsg(30726, this.m_cacheDir));
                    System.exit(1);
                }
                this.m_crawler.setCacheOn(this.m_cacheSize, (String)object3, (String)object, this.m_cacheFullAction, this.m_cacheCharSet);
                if (this.m_cacheSize == -1) {
                    this.m_log.println(this.m_crwerr.getMsg(30526, (String)object3, this.m_cacheFullAction));
                } else {
                    this.m_log.println(this.m_crwerr.getMsg(30510, (String)object3, String.valueOf(this.m_cacheSize), this.m_cacheFullAction));
                }
                if (this.m_cacheQueHighMark != 10 || this.m_cacheQueLowMark != 1) {
                    if (this.m_cacheQueLowMark >= this.m_cacheQueHighMark) {
                        this.m_err.println(this.m_crwerr.getMsg(30744, Integer.toString(this.m_cacheQueLowMark), Integer.toString(this.m_cacheQueHighMark)));
                        this.m_log.println(this.m_crwerr.getMsg(30744, Integer.toString(this.m_cacheQueLowMark), Integer.toString(this.m_cacheQueHighMark)));
                        System.exit(1);
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30527, Integer.toString(this.m_cacheQueHighMark)));
                    this.m_log.println(this.m_crwerr.getMsg(30528, Integer.toString(this.m_cacheQueLowMark)));
                    this.m_crawler.setCacheQueHighMark(this.m_cacheQueHighMark);
                    this.m_crawler.setCacheQueLowMark(this.m_cacheQueLowMark);
                }
            }
            if (this.m_filterPath != null) {
                string6 = "set m_filterPath = " + this.m_filterPath;
                this.m_crawler.setFilterOn(this.m_filterPath, this.m_filterNum);
                object2 = new MessageFormat(this.m_crwerr.getMsg(30511));
                object3 = new Object[]{this.m_filterPath, String.valueOf(this.m_filterNum)};
                this.m_log.println(((Format)object2).format(object3));
                object3 = null;
                object2 = null;
            }
            if (this.m_proxyExclusion != null) {
                this.m_crawler.setProxyAddressExclusions(this.m_proxyExclusion);
            }
            if (this.m_mimeInclude != null) {
                if (this.m_cachingOn && this.m_filterPath == null) {
                    n7 = 0;
                    while (n7 < this.m_mimeInclude.length) {
                        if (!this.m_mimeInclude[n7].toLowerCase().equals("text/plain") && !this.m_mimeInclude[n7].toLowerCase().equals("text/html")) {
                            this.m_log.println(this.m_crwerr.getMsg(30716));
                            this.m_err.println(this.m_crwerr.getMsg(30716));
                            System.exit(1);
                        }
                        ++n7;
                    }
                }
                this.m_crawler.setMimeTypesToRetrieve(this.m_mimeInclude);
                this.m_log.print(this.m_crwerr.getMsg(30512));
                n7 = 0;
                while (n7 < this.m_mimeInclude.length) {
                    this.m_log.print(" " + this.m_mimeInclude[n7]);
                    ++n7;
                }
                this.m_log.println();
            }
            string6 = "set page collection set and url column names";
            boolean bl6 = false;
            boolean bl7 = false;
            this.m_log.print(this.m_crwerr.getMsg(30513));
            n7 = 0;
            while (n7 < 8) {
                if (this.m_urlTableColumnNames[n7] != null) {
                    if (n7 == 7) {
                        this.m_log.print(" " + this.m_urlTableColumnNames[n7]);
                    } else {
                        this.m_log.print(" " + this.m_urlTableColumnNames[n7] + ",");
                    }
                    bl7 = true;
                } else {
                    switch (n7) {
                        case 0: {
                            this.m_log.print(" " + this.m_urlColName + ",");
                            break;
                        }
                        case 1: {
                            this.m_log.print(" " + this.m_depthColName + ",");
                            break;
                        }
                        case 2: {
                            this.m_log.print(" " + this.m_checksumColName + ",");
                            break;
                        }
                        case 3: {
                            this.m_log.print(" " + this.m_lastmodColName + ",");
                            break;
                        }
                        case 4: {
                            this.m_log.print(" " + this.m_statusColName + ",");
                            break;
                        }
                        case 5: {
                            this.m_log.print(" " + this.m_urlidColName + ",");
                            break;
                        }
                        case 6: {
                            this.m_log.print(" " + this.m_accessurlColName + ",");
                            break;
                        }
                        case 7: {
                            this.m_log.print(" " + this.m_enqueueStatusColName);
                            break;
                        }
                    }
                }
                ++n7;
            }
            n7 = 0;
            while (n7 < 10) {
                if (this.m_collectionSet[n7]) {
                    this.m_log.print(", ");
                    bl6 = true;
                    if (this.m_urlTableColumnNames[n7 + 8] != null) {
                        bl7 = true;
                        this.m_log.print(this.m_urlTableColumnNames[n7 + 8]);
                    } else {
                        switch (n7) {
                            case 0: {
                                this.m_log.print(this.m_titleColName);
                                break;
                            }
                            case 1: {
                                this.m_log.print(this.m_bodyColName);
                                break;
                            }
                            case 2: {
                                this.m_log.print(this.m_authorColName);
                                break;
                            }
                            case 3: {
                                this.m_log.print(this.m_crawltimeColName);
                                break;
                            }
                            case 4: {
                                this.m_log.print(this.m_cntlengthColName);
                                break;
                            }
                            case 5: {
                                this.m_log.print(this.m_cnttypeColName);
                                break;
                            }
                            case 6: {
                                this.m_log.print(this.m_insoFormatColName);
                                break;
                            }
                            case 7: {
                                this.m_log.print(this.m_languageColName);
                                break;
                            }
                            case 8: {
                                this.m_log.print(this.m_cacheFilePathColName);
                                break;
                            }
                            case 9: {
                                this.m_log.print(this.m_datasourceColName);
                                break;
                            }
                        }
                    }
                }
                ++n7;
            }
            this.m_log.println();
            if (bl6) {
                this.m_crawler.setUrlCollectSet(this.m_collectionSet);
            }
            if (bl7) {
                this.m_crawler.setUrlTableColumnNames(this.m_urlTableColumnNames);
            }
            switch (n5) {
                case 0: {
                    break;
                }
                case 3: {
                    this.m_log.println(this.m_crwerr.getMsg(30515));
                    break;
                }
                case 200: 
                case 301: 
                case 302: 
                case 400: 
                case 401: 
                case 402: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 500: 
                case 501: 
                case 502: 
                case 503: 
                case 504: 
                case 505: 
                case 999: {
                    this.m_log.println(this.m_crwerr.getMsg(30514, Integer.toString(n5)));
                    break;
                }
            }
            if (this.m_sqlCallbackStmt != null) {
                object = new MessageFormat(this.m_crwerr.getMsg(30519));
                objectArray = new Object[]{this.m_sqlCallbackStmt};
                this.m_log.println(((Format)object).format(objectArray));
                objectArray = null;
            }
            if (this.m_supportCookie) {
                this.m_log.println(this.m_crwerr.getMsg(30556));
            }
            if (this.m_traceCookie) {
                this.m_log.println(this.m_crwerr.getMsg(30552));
            }
            if (this.m_supportCookie && this.m_totalCookies > 0) {
                this.m_crawler.setCookiePolicy(new CookiePolicy(this.m_maxCookieSize, this.m_totalDomainCookies, this.m_totalCookies, this.m_traceCookie));
                this.m_log.println(this.m_crwerr.getMsg(30549, Integer.toString(this.m_totalCookies)));
                this.m_log.println(this.m_crwerr.getMsg(30551, Integer.toString(this.m_totalDomainCookies)));
                this.m_log.println(this.m_crwerr.getMsg(30550, Integer.toString(this.m_maxCookieSize)));
            } else {
                this.m_crawler.setCookiePolicy(new CookiePolicy(this.m_supportCookie, this.m_traceCookie));
            }
            if (this.m_crawler.getAgentName() != null) {
                this.m_log.println(this.m_crwerr.getMsg(30536, this.m_crawler.getAgentName()));
            }
            if (this.m_crawler.getHookID() != null) {
                this.m_log.println(this.m_crwerr.getMsg(30535, this.m_crawler.getHookID()));
            }
            if (this.m_crawler.getCmdHookStmt() != null) {
                this.m_log.println(this.m_crwerr.getMsg(30533, this.m_crawler.getCmdHookStmt()));
            }
            if (this.m_crawler.getResHookStmt() != null) {
                this.m_log.println(this.m_crwerr.getMsg(30534, this.m_crawler.getResHookStmt()));
            }
            if (this.m_schedName != null) {
                this.m_log.println(this.m_crwerr.getMsg(30546, this.m_schedName));
            }
            this.m_log.println();
            this.m_log.println("=================== " + this.m_crwerr.getMsg(30301) + "===================");
            l = System.currentTimeMillis();
            this.m_log.println(this.m_crwerr.getDateMsg(30304, l));
            string6 = "initializing the crawler, m_telnet_port= " + this.m_telnet_port;
            this.m_crawler.init(bl3, n6, this.m_telnet_port);
            this.m_crawler.setStartTime(l);
            string6 = "open log file";
            if (this.m_lazyout != null && !this.isTestMode) {
                try {
                    this.m_lazyout.switchToFile();
                }
                catch (IOException iOException) {
                    this.m_err.println("log file cannot be opened");
                    System.exit(1);
                }
            }
            if (this.m_sqlCallbackStmt != null) {
                string6 = "send launch success token";
                this.sendLaunchSuccessToken();
                this.m_crawler.setCallbackStmt(this.m_sqlCallbackStmt);
            }
            string6 = "start m_crawler.begin()";
            int n10 = this.m_crawler.begin();
            l2 = System.currentTimeMillis();
            this.m_log.println();
            this.m_log.println("=================== " + this.m_crwerr.getMsg(30303) + "===================");
            this.m_log.println(this.m_crwerr.getDateMsg(30304, l));
            this.m_log.println(this.m_crwerr.getDateMsg(30334, l2));
            this.m_crawler.setCrawlingTime(l2 - l);
            this.m_crawler.reportCrawlingStatistics();
        }
        catch (Exception exception) {
            if (!(exception instanceof WebCrawlerException)) {
                this.m_log.println(this.m_crwerr.getMsg(30100, exception.toString(), "ImtCrawler.run, " + string6));
                this.m_err.println(this.m_crwerr.getMsg(30100, exception.toString(), "ImtCrawler.run, " + string6));
                exception.printStackTrace(this.m_err);
                exception.printStackTrace(this.m_log);
            }
            if (string4 != null) {
                this.m_log.close();
            }
            System.exit(1);
        }
        if (string4 != null) {
            this.m_log.close();
        }
        System.exit(0);
    }

    private void usage() {
        this.m_log.println(this.m_crwerr.getMsg(30616, PROG_NAME));
        this.m_log.println();
        this.m_log.println(this.m_crwerr.getMsg(30617));
        this.m_log.println("-help                     " + this.m_crwerr.getMsg(30601));
        this.m_log.println("-version                  " + this.m_crwerr.getMsg(30602));
        this.m_log.println("-config <filename>        " + this.m_crwerr.getMsg(30603));
        this.m_log.println("-queue <name>             " + this.m_crwerr.getMsg(30613));
        this.m_log.println("-urltable <tableName>     " + this.m_crwerr.getMsg(30604));
        this.m_log.println("-thread <number>          " + this.m_crwerr.getMsg(30605));
        this.m_log.println("-seed <URL>+              " + this.m_crwerr.getMsg(30606));
        this.m_log.println("-log <filename>           " + this.m_crwerr.getMsg(30607));
        this.m_log.println("-depth <max_depth>        " + this.m_crwerr.getMsg(30608));
        this.m_log.println("-page <max_page>          " + this.m_crwerr.getMsg(30609));
        this.m_log.println("-restart                  " + this.m_crwerr.getMsg(30610));
        this.m_log.println("-locale                   " + this.m_crwerr.getMsg(30614));
        this.m_log.println("-sync [all|<code>] purge  " + this.m_crwerr.getMsg(30611));
        this.m_log.println("-oracle                   " + this.m_crwerr.getMsg(30612));
        this.m_log.println("-verbose                  " + this.m_crwerr.getMsg(30615));
        this.m_log.println();
    }

    private void readConfigFile(String string) {
        try {
            boolean bl;
            int n;
            String string2;
            BufferedReader bufferedReader;
            if (string.compareTo("-") == 0) {
                bufferedReader = new BufferedReader(new InputStreamReader(System.in, "UTF8"), 1);
            } else {
                File file = new File(string);
                if (!file.exists() || !file.canRead()) {
                    this.m_log.println(this.m_crwerr.getMsg(30424, string));
                    this.m_err.println(this.m_crwerr.getMsg(30424, string));
                    this.usage();
                    System.exit(1);
                }
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            }
            int n2 = 50;
            String[] stringArray = new String[n2];
            while ((string2 = bufferedReader.readLine()) != null) {
                int n3;
                int n4;
                int n5;
                int n6;
                String[] stringArray2;
                String[] stringArray3;
                String[] stringArray4;
                int n7;
                if (string2.startsWith("#")) continue;
                if (string2.startsWith("@END")) break;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n8 = 0;
                while (stringTokenizer.hasMoreTokens() && n8 < n2) {
                    stringArray[n8] = stringTokenizer.nextToken();
                    ++n8;
                }
                if (n8 == 0) continue;
                n = n8;
                while (n < n2) {
                    stringArray[n] = null;
                    ++n;
                }
                stringArray[0] = stringArray[0].toUpperCase();
                if (stringArray[0].compareTo("IMPORT") == 0) {
                    if (stringArray[1] == null) continue;
                    int n9 = 1;
                    while (n9 < n8) {
                        String string3 = this.fixPathSlashes(stringArray[n9]);
                        this.readConfigFile(string3);
                        ++n9;
                    }
                    continue;
                }
                if (stringArray[0].compareTo("PROXY") == 0) {
                    if (stringArray[1] != null) {
                        if (stringArray[1].compareTo("http") == 0 || stringArray[1].compareTo("HTTP") == 0) {
                            if (stringArray[2] != null) {
                                try {
                                    InetAddress.getByName(stringArray[2]);
                                }
                                catch (UnknownHostException unknownHostException) {
                                    this.m_log.println(this.m_crwerr.getMsg(30701, stringArray[2]));
                                    this.m_err.println(this.m_crwerr.getMsg(30701, stringArray[2]));
                                    this.m_log.println(this.m_crwerr.getMsg(30901));
                                    System.exit(1);
                                }
                                this.m_log.println(this.m_crwerr.getMsg(30951, stringArray[2]));
                                this.m_crawler.setProxyAddress(stringArray[2]);
                            } else {
                                this.m_log.println(this.m_crwerr.getMsg(30702));
                                this.m_err.println(this.m_crwerr.getMsg(30702));
                                this.m_log.println(this.m_crwerr.getMsg(30901));
                                System.exit(1);
                            }
                            if (stringArray[3] != null) {
                                try {
                                    int n10 = Integer.parseInt(stringArray[3]);
                                    this.m_crawler.setProxyPort(n10);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.m_log.println(this.m_crwerr.getMsg(30703, stringArray[3]));
                                    this.m_err.println(this.m_crwerr.getMsg(30703, stringArray[3]));
                                    this.m_log.println(this.m_crwerr.getMsg(30901));
                                    System.exit(1);
                                }
                                continue;
                            }
                            this.m_crawler.setProxyPort(80);
                            continue;
                        }
                        this.m_log.println(this.m_crwerr.getMsg(30704, stringArray[1]));
                        this.m_err.println(this.m_crwerr.getMsg(30704, stringArray[1]));
                        this.m_log.println(this.m_crwerr.getMsg(30901));
                        System.exit(1);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30705));
                    this.m_err.println(this.m_crwerr.getMsg(30705));
                    this.m_log.println(this.m_crwerr.getMsg(30901));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("NOPROXY") == 0) {
                    if (stringArray[1] == null) {
                        this.m_log.println(this.m_crwerr.getMsg(30706));
                        this.m_err.println(this.m_crwerr.getMsg(30706));
                        this.m_log.println(this.m_crwerr.getMsg(30902));
                        System.exit(1);
                    }
                    String string4 = stringArray[1];
                    if (stringArray[0].charAt(0) != '.') {
                        string4 = "." + string4;
                    }
                    if (this.m_proxyExclusion == null) {
                        this.m_proxyExclusion = new String[1];
                    } else {
                        String[] stringArray5 = new String[1 + this.m_proxyExclusion.length];
                        int n11 = 0;
                        while (n11 < this.m_proxyExclusion.length) {
                            stringArray5[n11] = this.m_proxyExclusion[n11];
                            ++n11;
                        }
                        this.m_proxyExclusion = stringArray5;
                    }
                    this.m_proxyExclusion[this.m_proxyExclusion.length - 1] = string4;
                    continue;
                }
                if (stringArray[0].compareTo("DATABASE") == 0) {
                    if (stringArray[1] != null) {
                        this.m_database = stringArray[1];
                        int n12 = 0;
                        if (stringArray[1].toUpperCase().startsWith("(DESCRIPTION")) continue;
                        int n13 = this.m_database.indexOf(":", n12);
                        if (n13 != -1) {
                            if (n13 == n12) {
                                this.m_log.println(this.m_crwerr.getMsg(30707, this.m_database));
                                this.m_err.println(this.m_crwerr.getMsg(30707, this.m_database));
                                this.m_log.println(this.m_crwerr.getMsg(30903));
                                System.exit(1);
                            }
                            String string5 = this.m_database.substring(n12, n13 - 1);
                            n12 = n13 + 1;
                        } else {
                            this.m_log.println(this.m_crwerr.getMsg(30709, this.m_database));
                            this.m_err.println(this.m_crwerr.getMsg(30709, this.m_database));
                            this.m_log.println(this.m_crwerr.getMsg(30903));
                            System.exit(1);
                        }
                        if (n12 >= this.m_database.length()) {
                            this.m_log.println(this.m_crwerr.getMsg(30709, this.m_database));
                            this.m_err.println(this.m_crwerr.getMsg(30709, this.m_database));
                            this.m_log.println(this.m_crwerr.getMsg(30903));
                            System.exit(1);
                        }
                        if ((n13 = this.m_database.indexOf(":", n12)) != -1) {
                            if (n13 == n12) {
                                this.m_log.println(this.m_crwerr.getMsg(30709, this.m_database));
                                this.m_err.println(this.m_crwerr.getMsg(30709, this.m_database));
                                this.m_log.println(this.m_crwerr.getMsg(30710, this.m_database));
                                this.m_err.println(this.m_crwerr.getMsg(30710, this.m_database));
                                this.m_log.println(this.m_crwerr.getMsg(30903));
                                System.exit(1);
                            }
                            try {
                                Integer.parseInt(this.m_database.substring(n12, n13 - 1));
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.m_log.println(this.m_crwerr.getMsg(30708, this.m_database));
                                this.m_err.println(this.m_crwerr.getMsg(30708, this.m_database));
                                this.m_log.println(this.m_crwerr.getMsg(30903));
                                System.exit(1);
                            }
                            n12 = n13 + 1;
                        } else {
                            this.m_log.println(this.m_crwerr.getMsg(30710, this.m_database));
                            this.m_err.println(this.m_crwerr.getMsg(30710, this.m_database));
                            this.m_log.println(this.m_crwerr.getMsg(30903));
                            System.exit(1);
                        }
                        if (n12 < this.m_database.length()) continue;
                        this.m_log.println(this.m_crwerr.getMsg(30710, this.m_database));
                        this.m_err.println(this.m_crwerr.getMsg(30710, this.m_database));
                        this.m_log.println(this.m_crwerr.getMsg(30903));
                        System.exit(1);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30711));
                    this.m_err.println(this.m_crwerr.getMsg(30711));
                    this.m_log.println(this.m_crwerr.getMsg(30903));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].equals("INCLUDE")) {
                    int n14 = 0;
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = 0;
                    n7 = 0;
                    stringArray4 = null;
                    stringArray3 = null;
                    stringArray2 = null;
                    n6 = 1;
                    while (n6 < n8) {
                        if (stringArray[n6].startsWith("^")) {
                            ++n14;
                        } else if (stringArray[n6].endsWith("$")) {
                            ++n16;
                        } else {
                            ++n15;
                        }
                        ++n6;
                    }
                    n17 = n14 + n16 + n15;
                    if (n14 > 0) {
                        stringArray4 = new String[n14];
                    }
                    if (n16 > 0) {
                        stringArray3 = new String[n16];
                    }
                    if (n15 > 0) {
                        stringArray2 = new String[n15];
                    }
                    n5 = 0;
                    n4 = 0;
                    n7 = 0;
                    n3 = 1;
                    while (n3 <= n17) {
                        if (stringArray[n3].startsWith("^")) {
                            stringArray4[n5++] = stringArray[n3].substring(1);
                        } else if (stringArray[n3].endsWith("$")) {
                            stringArray3[n4++] = stringArray[n3].substring(0, stringArray[n3].length() - 1);
                        } else {
                            stringArray2[n7++] = stringArray[n3];
                        }
                        ++n3;
                    }
                    if (n14 > 0) {
                        this.m_crawler.addHostPrefixInclusions(stringArray4);
                    }
                    if (n16 > 0) {
                        this.m_crawler.addHostSuffixInclusions(stringArray3);
                    }
                    if (n15 <= 0) continue;
                    this.m_crawler.addHostInclusions(stringArray2);
                    continue;
                }
                if (stringArray[0].equals("EXCLUDE")) {
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    n7 = 0;
                    stringArray4 = null;
                    stringArray3 = null;
                    stringArray2 = null;
                    n6 = 1;
                    while (n6 < n8) {
                        if (stringArray[n6].startsWith("^")) {
                            ++n18;
                        } else if (stringArray[n6].endsWith("$")) {
                            ++n20;
                        } else {
                            ++n19;
                        }
                        ++n6;
                    }
                    n21 = n18 + n20 + n19;
                    if (n18 > 0) {
                        stringArray4 = new String[n18];
                    }
                    if (n20 > 0) {
                        stringArray3 = new String[n20];
                    }
                    if (n19 > 0) {
                        stringArray2 = new String[n19];
                    }
                    n5 = 0;
                    n4 = 0;
                    n7 = 0;
                    n3 = 1;
                    while (n3 <= n21) {
                        if (stringArray[n3].startsWith("^")) {
                            stringArray4[n5++] = stringArray[n3].substring(1);
                        } else if (stringArray[n3].endsWith("$")) {
                            stringArray3[n4++] = stringArray[n3].substring(0, stringArray[n3].length() - 1);
                        } else {
                            stringArray2[n7++] = stringArray[n3];
                        }
                        ++n3;
                    }
                    if (n18 > 0) {
                        this.m_crawler.addHostPrefixExclusions(stringArray4);
                    }
                    if (n20 > 0) {
                        this.m_crawler.addHostSuffixExclusions(stringArray3);
                    }
                    if (n19 <= 0) continue;
                    this.m_crawler.addHostExclusions(stringArray2);
                    continue;
                }
                if (stringArray[0].equals("NO_FILE_PROTOCOL")) {
                    this.m_fileProtocol = false;
                    continue;
                }
                if (stringArray[0].compareTo("PT_SITEID") == 0) {
                    if (stringArray[1] != null) {
                        this.m_portal_contentarea_siteid = stringArray[1];
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30760));
                    this.m_err.println(this.m_crwerr.getMsg(30760));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("PT_URLBASE") == 0) {
                    if (stringArray[1] != null) {
                        this.m_portal_contentarea_urlbase = stringArray[1];
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30761));
                    this.m_err.println(this.m_crwerr.getMsg(30761));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("PT_DEFLANG") == 0) {
                    if (stringArray[1] != null) {
                        this.m_portal_contentarea_deflang = stringArray[1];
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30762));
                    this.m_err.println(this.m_crwerr.getMsg(30762));
                    continue;
                }
                if (stringArray[0].compareTo("PT_NAME") == 0) {
                    if (stringArray[1] != null) {
                        this.m_portal_contentarea_name = stringArray[1];
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30763));
                    this.m_err.println(this.m_crwerr.getMsg(30763));
                    continue;
                }
                if (stringArray[0].compareTo("DATASOURCETYPE") == 0) {
                    if (stringArray[1] != null) {
                        this.m_dataSourceType = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30759));
                    this.m_err.println(this.m_crwerr.getMsg(30759));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("DS_NAME") == 0) {
                    if (stringArray[1] == null) continue;
                    StringBuffer stringBuffer = new StringBuffer(stringArray[1]);
                    int n22 = 2;
                    while (n22 < n8) {
                        stringBuffer.append(" " + stringArray[n22]);
                        ++n22;
                    }
                    this.m_dsName = stringBuffer.toString();
                    continue;
                }
                if (stringArray[0].compareTo("SCHEDULE") == 0) {
                    if (stringArray[1] == null) continue;
                    StringBuffer stringBuffer = new StringBuffer(stringArray[1]);
                    int n23 = 2;
                    while (n23 < n8) {
                        stringBuffer.append(" " + stringArray[n23]);
                        ++n23;
                    }
                    this.m_schedName = stringBuffer.toString();
                    continue;
                }
                if (stringArray[0].compareTo("LOCAL_FILE_INCLUDE") == 0) {
                    if (n8 <= 1) continue;
                    int n24 = 0;
                    if (this.m_fileInclude == null) {
                        this.m_fileInclude = new String[n8 - 1];
                    } else {
                        String[] stringArray6 = new String[n8 - 1 + this.m_fileInclude.length];
                        while (n24 < this.m_fileInclude.length) {
                            stringArray6[n24] = this.m_fileInclude[n24];
                            ++n24;
                        }
                        this.m_fileInclude = stringArray6;
                    }
                    int n25 = 0;
                    while (n25 < n8 - 1) {
                        URL uRL = new URL("file:///" + stringArray[n25 + 1]);
                        this.m_fileInclude[n24] = uRL.getFile().startsWith("//") ? uRL.getFile().substring(1) : uRL.getFile();
                        ++n25;
                        ++n24;
                    }
                    continue;
                }
                if (stringArray[0].compareTo("LOCAL_FILE_EXCLUDE") == 0) {
                    if (n8 <= 1) continue;
                    int n26 = 0;
                    if (this.m_fileExclude == null) {
                        this.m_fileExclude = new String[n8 - 1];
                    } else {
                        String[] stringArray7 = new String[n8 - 1 + this.m_fileExclude.length];
                        while (n26 < this.m_fileExclude.length) {
                            stringArray7[n26] = this.m_fileExclude[n26];
                            ++n26;
                        }
                        this.m_fileExclude = stringArray7;
                    }
                    int n27 = 0;
                    while (n27 < n8 - 1) {
                        URL uRL = new URL("file:///" + stringArray[n27 + 1]);
                        this.m_fileExclude[n26] = uRL.getFile().startsWith("//") ? uRL.getFile().substring(1) : uRL.getFile();
                        ++n27;
                        ++n26;
                    }
                    continue;
                }
                if (stringArray[0].compareTo("PATH_INCLUDE") == 0) {
                    if (n8 <= 1) continue;
                    int n28 = 0;
                    if (this.m_pathInclude == null) {
                        this.m_pathInclude = new String[n8 - 1];
                    } else {
                        String[] stringArray8 = new String[n8 - 1 + this.m_pathInclude.length];
                        while (n28 < this.m_pathInclude.length) {
                            stringArray8[n28] = this.m_pathInclude[n28];
                            ++n28;
                        }
                        this.m_pathInclude = stringArray8;
                    }
                    int n29 = 0;
                    while (n29 < n8 - 1) {
                        this.m_pathInclude[n28] = stringArray[n29 + 1];
                        ++n29;
                        ++n28;
                    }
                    continue;
                }
                if (stringArray[0].compareTo("PATH_EXCLUDE") == 0) {
                    if (n8 <= 1) continue;
                    int n30 = 0;
                    if (this.m_pathExclude == null) {
                        this.m_pathExclude = new String[n8 - 1];
                    } else {
                        String[] stringArray9 = new String[n8 - 1 + this.m_pathExclude.length];
                        while (n30 < this.m_pathExclude.length) {
                            stringArray9[n30] = this.m_pathExclude[n30];
                            ++n30;
                        }
                        this.m_pathExclude = stringArray9;
                    }
                    int n31 = 0;
                    while (n31 < n8 - 1) {
                        this.m_pathExclude[n30] = stringArray[n31 + 1];
                        ++n31;
                        ++n30;
                    }
                    continue;
                }
                if (stringArray[0].compareTo("READ_TIMEOUT") == 0) {
                    if (stringArray[1] == null) continue;
                    try {
                        this.m_readTimeout = Integer.parseInt(stringArray[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_log.println(this.m_crwerr.getMsg(30727, stringArray[1]));
                        this.m_err.println(this.m_crwerr.getMsg(30727, stringArray[1]));
                        this.m_log.println(this.m_crwerr.getMsg(30914));
                        System.exit(1);
                    }
                    if (this.m_readTimeout <= 0) {
                        this.m_log.println(this.m_crwerr.getMsg(30728));
                        this.m_err.println(this.m_crwerr.getMsg(30728));
                        this.m_log.println(this.m_crwerr.getMsg(30915));
                        System.exit(1);
                        continue;
                    }
                    if (this.m_readTimeout <= 86400) continue;
                    this.m_log.println(this.m_crwerr.getMsg(30729));
                    this.m_err.println(this.m_crwerr.getMsg(30729));
                    this.m_log.println(this.m_crwerr.getMsg(30916));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("SEED") == 0) {
                    if (stringArray[1] != null) {
                        this.m_seedList.addElement(stringArray[1]);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30407));
                    this.m_err.println(this.m_crwerr.getMsg(30407));
                    continue;
                }
                if (stringArray[0].compareTo("BLACKLIST") == 0) {
                    if (stringArray[1] == null) continue;
                    this.m_blackList.addElement(stringArray[1]);
                    continue;
                }
                if (stringArray[0].compareTo("AGENT") == 0) {
                    if (stringArray[1] != null) {
                        StringBuffer stringBuffer = new StringBuffer(stringArray[1]);
                        int n32 = 2;
                        while (n32 < n8 - 1) {
                            stringBuffer.append(" " + stringArray[n32]);
                            ++n32;
                        }
                        this.m_agent = stringBuffer.toString();
                        this.m_log.println(this.m_crwerr.getMsg(30952, this.m_agent));
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30712));
                    this.m_err.println(this.m_crwerr.getMsg(30712));
                    this.m_log.println(this.m_crwerr.getMsg(30904));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("USER") == 0) {
                    if (stringArray[1] != null) {
                        int n33 = stringArray[1].indexOf(47);
                        if (n33 != -1) {
                            this.m_user = stringArray[1].substring(0, n33);
                            this.m_crawler.setJdbcUserName(this.m_user);
                            String string6 = stringArray[1].substring(n33 + 1);
                            this.m_crawler.setJdbcPassword(string6);
                            continue;
                        }
                        this.m_user = stringArray[1];
                        this.m_crawler.setJdbcUserName(stringArray[1]);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30713));
                    this.m_err.println(this.m_crwerr.getMsg(30713));
                    this.m_log.println(this.m_crwerr.getMsg(30905));
                    continue;
                }
                if (stringArray[0].compareTo("PASSWORD") == 0) {
                    if (stringArray[1] != null) {
                        this.m_crawler.setJdbcPassword(stringArray[1]);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30714));
                    this.m_err.println(this.m_crwerr.getMsg(30714));
                    this.m_log.println(this.m_crwerr.getMsg(30906));
                    continue;
                }
                if (stringArray[0].compareTo("DATASOURCEID") == 0) {
                    if (stringArray[1] != null) {
                        this.m_ds_set = true;
                        this.m_ds_id = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30723));
                    this.m_err.println(this.m_crwerr.getMsg(30723));
                    this.m_log.println(this.m_crwerr.getMsg(30911));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("FILTERPATH") == 0) {
                    String string7 = this.fixPathSlashes(stringArray[1]);
                    if (string7 != null) {
                        File file = new File(string7);
                        if (!file.exists()) {
                            this.m_log.println(this.m_crwerr.getMsg(30715, string7));
                            this.m_err.println(this.m_crwerr.getMsg(30715, string7));
                            this.m_log.println(this.m_crwerr.getMsg(30907));
                            System.exit(1);
                        }
                        file = null;
                        this.m_filterPath = string7;
                    } else {
                        this.m_log.println(this.m_crwerr.getMsg(30716));
                        this.m_err.println(this.m_crwerr.getMsg(30716));
                        this.m_log.println(this.m_crwerr.getMsg(30908));
                        System.exit(1);
                    }
                    if (stringArray[2] == null) continue;
                    try {
                        this.m_filterNum = Integer.parseInt(stringArray[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_log.println(this.m_crwerr.getMsg(30717, stringArray[2]));
                        this.m_err.println(this.m_crwerr.getMsg(30717, stringArray[2]));
                        this.m_log.println(this.m_crwerr.getMsg(30908));
                        System.exit(1);
                    }
                    if (this.m_filterNum < 1) {
                        this.m_err.println(this.m_crwerr.getMsg(30733, Integer.toString(this.m_filterNum)));
                        this.m_log.println(this.m_crwerr.getMsg(30908));
                        System.exit(1);
                    }
                    if (this.m_threadNum >= this.m_filterNum) continue;
                    this.m_err.println(this.m_crwerr.getMsg(30732, Integer.toString(this.m_filterNum)));
                    this.m_err.println(this.m_crwerr.getMsg(30919));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("SQL_CALLBACK") == 0) {
                    if (stringArray[1] == null) continue;
                    StringBuffer stringBuffer = new StringBuffer(stringArray[1]);
                    int n34 = 2;
                    while (n34 < n8) {
                        stringBuffer.append(" " + stringArray[n34]);
                        ++n34;
                    }
                    this.m_sqlCallbackStmt = stringBuffer.toString();
                    stringBuffer = null;
                    continue;
                }
                if (stringArray[0].compareTo("CACHE") == 0) {
                    this.m_cachingOn = true;
                    if (stringArray[1] != null) {
                        String string8;
                        this.m_cacheDir = string8 = this.fixPathSlashes(stringArray[1]);
                    } else {
                        this.m_log.println(this.m_crwerr.getMsg(30718));
                        this.m_err.println(this.m_crwerr.getMsg(30718));
                        this.m_log.println(this.m_crwerr.getMsg(30909));
                        System.exit(1);
                    }
                    if (stringArray[2] == null) continue;
                    try {
                        this.m_cacheSize = Integer.parseInt(stringArray[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_log.println(this.m_crwerr.getMsg(30719, stringArray[2]));
                        this.m_err.println(this.m_crwerr.getMsg(30719, stringArray[2]));
                        this.m_log.println(this.m_crwerr.getMsg(30909));
                        System.exit(1);
                    }
                    if (this.m_cacheSize >= 1) continue;
                    this.m_log.println(this.m_crwerr.getMsg(30720));
                    this.m_cacheSize = 1;
                    continue;
                }
                if (stringArray[0].compareTo("SRVCACHE") == 0) {
                    if (stringArray[1] != null) {
                        String string9;
                        this.m_serverCacheDir = string9 = this.fixPathSlashes(stringArray[1]);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30718));
                    this.m_err.println(this.m_crwerr.getMsg(30718));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("CACHE_QUEUE_HIGHWATER_MARK") == 0) {
                    if (stringArray[1] != null) {
                        try {
                            this.m_cacheQueHighMark = Integer.parseInt(stringArray[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.m_log.println(this.m_crwerr.getMsg(30742, stringArray[1]));
                            this.m_err.println(this.m_crwerr.getMsg(30742, stringArray[1]));
                            System.exit(1);
                        }
                        if (this.m_cacheQueHighMark < 1) {
                            this.m_log.println(this.m_crwerr.getMsg(30742, Integer.toString(this.m_cacheQueHighMark)));
                            this.m_err.println(this.m_crwerr.getMsg(30742, Integer.toString(this.m_cacheQueHighMark)));
                            System.exit(1);
                        }
                        if (this.m_cacheQueHighMark <= 100) continue;
                        this.m_log.println(this.m_crwerr.getMsg(30745, Integer.toString(this.m_cacheQueHighMark)));
                        this.m_err.println(this.m_crwerr.getMsg(30745, Integer.toString(this.m_cacheQueHighMark)));
                        System.exit(1);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30739));
                    this.m_err.println(this.m_crwerr.getMsg(30739));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("CACHE_QUEUE_LOWWATER_MARK") == 0) {
                    if (stringArray[1] != null) {
                        try {
                            this.m_cacheQueLowMark = Integer.parseInt(stringArray[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.m_log.println(this.m_crwerr.getMsg(30743, stringArray[1]));
                            this.m_err.println(this.m_crwerr.getMsg(30743, stringArray[1]));
                            System.exit(1);
                        }
                        if (this.m_cacheQueLowMark >= 0) continue;
                        this.m_log.println(this.m_crwerr.getMsg(30743, Integer.toString(this.m_cacheQueLowMark)));
                        this.m_err.println(this.m_crwerr.getMsg(30743, Integer.toString(this.m_cacheQueLowMark)));
                        System.exit(1);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30741));
                    this.m_err.println(this.m_crwerr.getMsg(30741));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("CACHEFULLACTION") == 0) {
                    if (stringArray[1] == null) continue;
                    StringBuffer stringBuffer = new StringBuffer(stringArray[1]);
                    int n35 = 2;
                    while (n35 < n8) {
                        stringBuffer.append(" " + stringArray[n35]);
                        ++n35;
                    }
                    this.m_cacheFullAction = stringBuffer.toString();
                    stringBuffer = null;
                    continue;
                }
                if (stringArray[0].compareTo("INSTANCE") == 0) {
                    if (stringArray[1] == null) continue;
                    this.m_crawler.setInstanceName(stringArray[1]);
                    continue;
                }
                if (stringArray[0].compareTo("MAILUSER") == 0) {
                    if (stringArray[1] == null) continue;
                    int n36 = stringArray[1].indexOf(47);
                    String string10 = stringArray[1].substring(0, n36);
                    String string11 = stringArray[1].substring(n36 + 1);
                    this.m_crawler.setMailUser(string10);
                    this.m_crawler.setMailPassword(string11);
                    continue;
                }
                if (stringArray[0].compareTo("MAILSERVER") == 0) {
                    if (stringArray[1] == null) continue;
                    this.m_crawler.setMailServer(stringArray[1]);
                    continue;
                }
                if (stringArray[0].compareTo("MAILARCHIVE") == 0) {
                    if (stringArray[1] == null) continue;
                    String string12 = this.fixPathSlashes(stringArray[1]);
                    this.m_crawler.setMailArchiveDir(string12);
                    this.m_archiveDir = string12;
                    continue;
                }
                if (stringArray[0].compareTo("MAILTABLE") == 0) {
                    if (stringArray[1] == null) continue;
                    this.m_crawler.setMailingListTableName(stringArray[1]);
                    continue;
                }
                if (stringArray[0].compareTo("MAILLIST") == 0) {
                    this.m_crawler.addNewMailingList(string2.substring("MAILLIST".length()).trim());
                    continue;
                }
                if (stringArray[0].compareTo("CACHECHARSET") == 0) {
                    if (stringArray[1] == null) continue;
                    this.m_cacheCharSet = stringArray[1];
                    continue;
                }
                if (stringArray[0].compareTo("DEFAULTCHARSET") == 0) {
                    if (stringArray[1] != null) {
                        this.m_defaultCharSet = stringArray[1];
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30730));
                    this.m_err.println(this.m_crwerr.getMsg(30730));
                    this.m_log.println(this.m_crwerr.getMsg(30917));
                    continue;
                }
                if (stringArray[0].compareTo("DEFAULTLANGUAGE") == 0) {
                    if (stringArray[1] != null) {
                        this.m_defaultLanguage = stringArray[1];
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30731));
                    this.m_err.println(this.m_crwerr.getMsg(30731));
                    this.m_log.println(this.m_crwerr.getMsg(30918));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("AUTO_LANGUAGE_DETECTION") == 0) {
                    this.m_autoLanguageDetection = true;
                    continue;
                }
                if (stringArray[0].compareTo("TRAININGDOCDIR") == 0) {
                    if (stringArray[1] != null) {
                        String string13;
                        this.m_trainingDocDir = string13 = this.fixPathSlashes(stringArray[1]);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30740));
                    this.m_err.println(this.m_crwerr.getMsg(30740));
                    this.m_log.println(this.m_crwerr.getMsg(30909));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("TRAINING_DOC") == 0) {
                    if (this.m_trainSet == null) {
                        this.m_trainSet = new Vector(10);
                    }
                    if (stringArray[1] != null) {
                        this.m_trainSet.addElement(stringArray[1]);
                    } else {
                        this.m_log.println(this.m_crwerr.getMsg(30734));
                        this.m_err.println(this.m_crwerr.getMsg(30734));
                        this.m_log.println(this.m_crwerr.getMsg(30920));
                        System.exit(1);
                    }
                    if (stringArray[2] != null) {
                        this.m_trainSet.addElement(stringArray[2]);
                    } else {
                        this.m_log.println(this.m_crwerr.getMsg(30735));
                        this.m_err.println(this.m_crwerr.getMsg(30735));
                        this.m_log.println(this.m_crwerr.getMsg(30920));
                        System.exit(1);
                    }
                    if (stringArray[3] == null) continue;
                    this.m_log.println(this.m_crwerr.getMsg(30736));
                    this.m_err.println(this.m_crwerr.getMsg(30736));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("MIMEINCLUDE") == 0) {
                    if (n8 <= 1) continue;
                    int n37 = 0;
                    if (this.m_mimeInclude == null) {
                        this.m_mimeInclude = new String[n8 - 1];
                    } else {
                        String[] stringArray10 = new String[n8 - 1 + this.m_mimeInclude.length];
                        while (n37 < this.m_mimeInclude.length) {
                            stringArray10[n37] = this.m_mimeInclude[n37];
                            ++n37;
                        }
                        this.m_mimeInclude = stringArray10;
                    }
                    int n38 = 0;
                    while (n38 < n8 - 1) {
                        this.m_mimeInclude[n37] = stringArray[n38 + 1].toLowerCase();
                        ++n38;
                        ++n37;
                    }
                    continue;
                }
                if (stringArray[0].compareTo("MAPPING") == 0) {
                    if (stringArray[1] == null) continue;
                    int n39 = 1;
                    while (n39 < n8) {
                        int n40;
                        if (stringArray[n39].toUpperCase().startsWith("URL") && (n40 = stringArray[n39].indexOf(47)) != -1) {
                            this.m_urlTableColumnNames[0] = this.m_urlColName = stringArray[n39].substring(n40 + 1);
                        } else if (stringArray[n39].toUpperCase().startsWith("DEPTH") && (n40 = stringArray[n39].indexOf(47)) != -1) {
                            this.m_urlTableColumnNames[1] = this.m_depthColName = stringArray[n39].substring(n40 + 1);
                        } else if (stringArray[n39].toUpperCase().startsWith("CHECKSUM") && (n40 = stringArray[n39].indexOf(47)) != -1) {
                            this.m_urlTableColumnNames[2] = this.m_checksumColName = stringArray[n39].substring(n40 + 1);
                        } else if (stringArray[n39].toUpperCase().startsWith("LAST_MODIFIED") && (n40 = stringArray[n39].indexOf(47)) != -1) {
                            this.m_urlTableColumnNames[3] = this.m_lastmodColName = stringArray[n39].substring(n40 + 1);
                        } else if (stringArray[n39].toUpperCase().startsWith("STATUS") && (n40 = stringArray[n39].indexOf(47)) != -1) {
                            this.m_urlTableColumnNames[4] = this.m_statusColName = stringArray[n39].substring(n40 + 1);
                        } else if (stringArray[n39].toUpperCase().startsWith("URL_ID") && (n40 = stringArray[n39].indexOf(47)) != -1) {
                            this.m_urlTableColumnNames[5] = this.m_urlidColName = stringArray[n39].substring(n40 + 1);
                        } else if (stringArray[n39].toUpperCase().startsWith("ACCESS_URL") && (n40 = stringArray[n39].indexOf(47)) != -1) {
                            this.m_urlTableColumnNames[6] = this.m_accessurlColName = stringArray[n39].substring(n40 + 1);
                        } else if (stringArray[n39].toUpperCase().startsWith("ENQUEUE_STATUS") && (n40 = stringArray[n39].indexOf(47)) != -1) {
                            this.m_urlTableColumnNames[7] = this.m_enqueueStatusColName = stringArray[n39].substring(n40 + 1);
                        }
                        ++n39;
                    }
                    continue;
                }
                if (stringArray[0].compareTo("SQL_HOOK_ID") == 0) {
                    if (stringArray[1] == null) {
                        this.m_log.println(this.m_crwerr.getMsg(30752, "SQL_HOOK_ID"));
                        this.m_err.println(this.m_crwerr.getMsg(30752, "SQL_HOOK_ID"));
                        System.exit(1);
                    }
                    if (stringArray[2] != null) {
                        this.m_log.println(this.m_crwerr.getMsg(30753, "SQL_HOOK_ID"));
                        this.m_err.println(this.m_crwerr.getMsg(30753, "SQL_HOOK_ID"));
                        System.exit(1);
                    }
                    this.m_crawler.setHookID(stringArray[1]);
                    continue;
                }
                if (stringArray[0].compareTo("SQL_COMMAND_HOOK") == 0) {
                    String string14 = stringArray[1];
                    if (string14 != null) {
                        int n41 = 2;
                        while (n41 < n2 && stringArray[n41] != null) {
                            string14 = string14 + " " + stringArray[n41];
                            ++n41;
                        }
                    }
                    this.m_crawler.setCmdHookStmt(string14);
                    continue;
                }
                if (stringArray[0].compareTo("SQL_RESPONSE_HOOK") == 0) {
                    String string15 = stringArray[1];
                    if (string15 != null) {
                        int n42 = 2;
                        while (n42 < n2 && stringArray[n42] != null) {
                            string15 = string15 + " " + stringArray[n42];
                            ++n42;
                        }
                    }
                    this.m_crawler.setResHookStmt(string15);
                    continue;
                }
                if (stringArray[0].compareTo("DS_AGENT") == 0) {
                    if (stringArray[1] != null) {
                        this.m_crawler.setAgentName(stringArray[1]);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30755));
                    this.m_err.println(this.m_crwerr.getMsg(30755));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("DS_PARAM") == 0) {
                    if (stringArray[1] != null) {
                        String string16 = null;
                        String string17 = null;
                        int n43 = string2.indexOf(stringArray[1]);
                        int n44 = 0;
                        n6 = string2.indexOf(" : ") + 3;
                        n3 = 1;
                        while (n3 < n8) {
                            if (stringArray[n3].compareTo(":") == 0) {
                                n44 = n3;
                                break;
                            }
                            ++n3;
                        }
                        if (n44 == 0 || stringArray[n44 + 1] == null) {
                            string16 = string2.substring(n43);
                            this.m_log.println(this.m_crwerr.getMsg(30758, string16));
                            this.m_err.println(this.m_crwerr.getMsg(30758, string16));
                            System.exit(1);
                        }
                        n5 = string2.indexOf(stringArray[n44 + 1], n6);
                        n4 = string2.substring(0, n5).lastIndexOf(stringArray[n44 - 1]) + stringArray[n44 - 1].length();
                        string16 = string2.substring(n43, n4).trim();
                        string17 = string2.substring(n5).trim();
                        n7 = 0;
                        while (n7 >= 0 && (n7 = string16.indexOf("\\:", n7 + 1)) > 0) {
                            string16 = string16.substring(0, n7) + string16.substring(n7 + 1);
                        }
                        n7 = 0;
                        while (n7 >= 0 && (n7 = string16.indexOf("\\\\", n7 + 1)) > 0) {
                            string16 = string16.substring(0, n7) + string16.substring(n7 + 1);
                        }
                        this.m_crawler.addDataSourceParam(string16, string17);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30757, string2));
                    this.m_err.println(this.m_crwerr.getMsg(30757, string2));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("COLLECT") == 0) {
                    if (stringArray[1] == null) continue;
                    int n45 = 1;
                    while (n45 < n8) {
                        int n46;
                        String string18 = stringArray[n45].toUpperCase();
                        if (string18.startsWith("TITLE/") || string18.equals("TITLE")) {
                            n46 = string18.indexOf(47);
                            if (n46 != -1) {
                                this.m_urlTableColumnNames[8] = this.m_titleColName = string18.substring(n46 + 1);
                            } else {
                                this.m_titleColName = string18;
                            }
                            this.m_collectionSet[0] = true;
                        } else if (string18.startsWith("BODY/") || string18.equals("BODY")) {
                            n46 = string18.indexOf(47);
                            if (n46 != -1) {
                                this.m_urlTableColumnNames[9] = this.m_bodyColName = string18.substring(n46 + 1);
                            } else {
                                this.m_bodyColName = string18;
                            }
                            this.m_collectionSet[1] = true;
                        } else if (string18.startsWith("AUTHOR/") || string18.equals("AUTHOR")) {
                            n46 = string18.indexOf(47);
                            if (n46 != -1) {
                                this.m_urlTableColumnNames[10] = this.m_authorColName = string18.substring(n46 + 1);
                            } else {
                                this.m_authorColName = string18;
                            }
                            this.m_collectionSet[2] = true;
                        } else if (string18.startsWith("CRAWL_TIME/") || string18.equals("CRAWL_TIME")) {
                            n46 = string18.indexOf(47);
                            if (n46 != -1) {
                                this.m_urlTableColumnNames[11] = this.m_crawltimeColName = string18.substring(n46 + 1);
                            } else {
                                this.m_crawltimeColName = string18;
                            }
                            this.m_collectionSet[3] = true;
                        } else if (string18.startsWith("CONTENT_LENGTH/") || string18.equals("CONTENT_LENGTH")) {
                            n46 = string18.indexOf(47);
                            if (n46 != -1) {
                                this.m_urlTableColumnNames[12] = this.m_cntlengthColName = string18.substring(n46 + 1);
                            } else {
                                this.m_cntlengthColName = string18;
                            }
                            this.m_collectionSet[4] = true;
                        } else if (string18.startsWith("CONTENT_TYPE/") || string18.equals("CONTENT_TYPE")) {
                            n46 = string18.indexOf(47);
                            if (n46 != -1) {
                                this.m_urlTableColumnNames[13] = this.m_cnttypeColName = string18.substring(n46 + 1);
                            } else {
                                this.m_cnttypeColName = string18;
                            }
                            this.m_collectionSet[5] = true;
                        } else if (string18.startsWith("FORMAT_TYPE/") || string18.equals("FORMAT_TYPE")) {
                            n46 = string18.indexOf(47);
                            if (n46 != -1) {
                                this.m_urlTableColumnNames[14] = this.m_insoFormatColName = string18.substring(n46 + 1);
                            } else {
                                this.m_insoFormatColName = string18;
                            }
                            this.m_collectionSet[6] = true;
                        } else if (string18.startsWith("LANGUAGE/") || string18.equals("LANGUAGE")) {
                            n46 = string18.indexOf(47);
                            if (n46 != -1) {
                                this.m_urlTableColumnNames[15] = this.m_languageColName = string18.substring(n46 + 1);
                            } else {
                                this.m_languageColName = string18;
                            }
                            this.m_collectionSet[7] = true;
                        } else if (string18.startsWith("CACHE_FILE_PATH/") || string18.equals("CACHE_FILE_PATH")) {
                            n46 = string18.indexOf(47);
                            if (n46 != -1) {
                                this.m_urlTableColumnNames[16] = this.m_cacheFilePathColName = string18.substring(n46 + 1);
                            } else {
                                this.m_cacheFilePathColName = string18;
                            }
                            this.m_collectionSet[8] = true;
                        } else if (string18.startsWith("DS_ID/") || string18.equals("DS_ID")) {
                            n46 = string18.indexOf(47);
                            if (n46 != -1) {
                                this.m_urlTableColumnNames[17] = this.m_datasourceColName = string18.substring(n46 + 1);
                            } else {
                                this.m_datasourceColName = string18;
                            }
                            this.m_collectionSet[9] = true;
                        }
                        ++n45;
                    }
                    continue;
                }
                if (stringArray[0].compareTo("FDS_URL_PREFIX") == 0) {
                    if (stringArray[1] != null) {
                        this.m_crawler.setFileUrlPrefix(stringArray[1]);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30758, stringArray[0]));
                    this.m_err.println(this.m_crwerr.getMsg(30758, stringArray[0]));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("FDS_DISP_PREFIX") == 0) {
                    if (stringArray[1] != null) {
                        this.m_crawler.setDispUrlPrefix(stringArray[1]);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30758, stringArray[0]));
                    this.m_err.println(this.m_crwerr.getMsg(30758, stringArray[0]));
                    System.exit(1);
                    continue;
                }
                if (stringArray[0].compareTo("ROBOT_EXCLUSION") == 0) {
                    if (stringArray[1] != null) {
                        if (stringArray[1].toUpperCase().equals("IGNORE") || stringArray[1].toUpperCase().equals("DISABLED")) {
                            this.m_ignoreRobotsExclusion = true;
                            this.m_crawler.setIgnoreRobotsExclusion(true);
                            continue;
                        }
                        this.m_crawler.setIgnoreRobotsExclusion(false);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30758, stringArray[0]));
                    this.m_err.println(this.m_crwerr.getMsg(30758, stringArray[0]));
                    continue;
                }
                if (stringArray[0].compareTo("COOKIE_ENABLED") == 0) {
                    this.m_supportCookie = true;
                    continue;
                }
                if (stringArray[0].compareTo("TRACE_COOKIE") == 0) {
                    this.m_traceCookie = true;
                    continue;
                }
                if (stringArray[0].compareTo("COOKIE_SIZE") == 0) {
                    if (stringArray[1] != null && stringArray[2] != null && stringArray[3] != null) {
                        try {
                            this.m_totalCookies = Integer.parseInt(stringArray[1]);
                            this.m_totalDomainCookies = Integer.parseInt(stringArray[2]);
                            this.m_maxCookieSize = Integer.parseInt(stringArray[3]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.m_log.println(this.m_crwerr.getMsg(30096, "Invalid cookie size configuration value: " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3]));
                            this.m_err.println(this.m_crwerr.getMsg(30096, "Invalid cookie size configuration value: " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3]));
                            System.exit(1);
                        }
                        if (this.m_totalCookies >= 1 && this.m_totalDomainCookies >= 1 && this.m_maxCookieSize >= 1) continue;
                        this.m_log.println(this.m_crwerr.getMsg(30096, "Invalid cookie size configuration value: " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3]));
                        this.m_err.println(this.m_crwerr.getMsg(30096, "Invalid cookie size configuration value: " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3]));
                        System.exit(1);
                        continue;
                    }
                    this.m_log.println(this.m_crwerr.getMsg(30096, "Missing cookie configuration value from COOKIE_SIZE"));
                    this.m_err.println(this.m_crwerr.getMsg(30096, "Missing cookie configuration value from COOKIE_SIZE"));
                    System.exit(1);
                    continue;
                }
                this.m_log.println(this.m_crwerr.getMsg(30721, string2));
                this.m_err.println(this.m_crwerr.getMsg(30721, string2));
                System.exit(1);
            }
            boolean bl2 = this.m_crawler.getHookID() == null;
            n = this.m_crawler.getCmdHookStmt() == null ? 1 : 0;
            boolean bl3 = bl = this.m_crawler.getResHookStmt() == null;
            if (!(!bl2 && n == 0 && !bl || bl2 && n != 0 && bl)) {
                String string19 = "";
                if (bl2) {
                    string19 = "SQL_HOOK_ID ";
                }
                if (n != 0) {
                    string19 = string19 + "SQL_COMMAND_HOOK ";
                }
                if (bl) {
                    string19 = string19 + "SQL_RESPONSE_HOOK ";
                }
                this.m_log.println(this.m_crwerr.getMsg(30751, string19));
                this.m_err.println(this.m_crwerr.getMsg(30751, string19));
            }
            if (!(this.m_crawler.getMailArchiveDir() == null && this.m_crawler.getMailingListTableName() == null && this.m_crawler.getMailUser() == null && this.m_crawler.getMailPassword() == null && this.m_crawler.getMailServer() == null && this.m_crawler.getNewMailingLists().length <= 0 || this.m_crawler.getMailUser() != null && this.m_crawler.getMailPassword() != null && this.m_crawler.getMailServer() != null && this.m_crawler.getMailArchiveDir() != null && this.m_crawler.getMailingListTableName() != null)) {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.m_crawler.getMailUser() == null) {
                    stringBuffer.append("MAILUSER ");
                }
                if (this.m_crawler.getMailPassword() == null) {
                    stringBuffer.append("MAILUSER (password) ");
                }
                if (this.m_crawler.getMailServer() == null) {
                    stringBuffer.append("MAILSERVER ");
                }
                if (this.m_crawler.getMailArchiveDir() == null) {
                    stringBuffer.append("MAILARCHIVE ");
                }
                if (this.m_crawler.getMailingListTableName() == null) {
                    stringBuffer.append("MAILTABLE ");
                }
                this.m_err.println(this.m_crwerr.getMsg(30748, stringBuffer.toString()));
                this.m_log.println(this.m_crwerr.getMsg(30748, stringBuffer.toString()));
                System.exit(1);
            }
            if (this.m_archiveDir != null) {
                File file = new File(this.m_archiveDir);
                if (file.exists()) {
                    if (!file.canWrite()) {
                        this.m_err.println(this.m_crwerr.getMsg(30746, this.m_archiveDir));
                        this.m_log.println(this.m_crwerr.getMsg(30746, this.m_archiveDir));
                        System.exit(1);
                    }
                } else if (!file.mkdirs()) {
                    this.m_err.println(this.m_crwerr.getMsg(30747, this.m_archiveDir));
                    this.m_log.println(this.m_crwerr.getMsg(30747, this.m_archiveDir));
                    System.exit(1);
                }
            }
            if (this.m_collectionSet[9]) {
                if (!this.m_ds_set) {
                    this.m_log.println(this.m_crwerr.getMsg(30749));
                    this.m_err.println(this.m_crwerr.getMsg(30749));
                    System.exit(1);
                } else {
                    this.m_crawler.setDataSourceID(this.m_ds_id);
                }
            } else if (this.m_ds_set) {
                this.m_log.println(this.m_crwerr.getMsg(30750));
                this.m_err.println(this.m_crwerr.getMsg(30750));
                System.exit(1);
            }
        }
        catch (IOException iOException) {
            this.m_log.println(this.m_crwerr.getMsg(30424, iOException.toString()));
            this.m_err.println(this.m_crwerr.getMsg(30424, iOException.toString()));
            this.usage();
            System.exit(1);
        }
    }

    private String getNexttoken(StringTokenizer stringTokenizer, int n, boolean bl, String string) {
        if (bl) {
            return string;
        }
        if (stringTokenizer != null) {
            if (stringTokenizer.hasMoreTokens()) {
                return stringTokenizer.nextToken();
            }
            return null;
        }
        if (this.m_tokenCount <= n) {
            return this.m_argv[this.m_tokenCount++];
        }
        return null;
    }

    private Locale setLocale(String string, int n) {
        String string2;
        Object var3_3 = null;
        String string3 = null;
        Locale locale = null;
        while ((string2 = this.getNexttoken(null, n, false, null)) != null) {
            if (!string2.equals("-locale")) continue;
            string2 = this.getNexttoken(null, n, false, null);
            if (string2 == null || string2.startsWith("-")) {
                this.m_log.println(this.m_crwerr.getMsg(30426));
                this.m_err.println(this.m_crwerr.getMsg(30426));
                this.usage();
                System.exit(1);
            }
            string3 = string2;
        }
        this.m_tokenCount = 0;
        if (string3 != null) {
            int n2 = string3.indexOf("-");
            locale = n2 == -1 ? new Locale(string3, "") : new Locale(string3.substring(0, n2), string3.substring(n2 + 1));
            this.m_locale = locale;
            this.m_crwerr = new CrawlerErrorMessage(this.m_locale);
        }
        return locale;
    }

    private String OpenLogFile(boolean bl, String string, int n) {
        Comparable<StringBuffer> comparable;
        int n2;
        String string2 = null;
        if (bl) {
            int n3 = string.indexOf("-log");
            n2 = string.length();
            if (n3 != -1) {
                char c;
                n3 += 5;
                while (n3 < n2 && string.charAt(n3) == ' ') {
                    ++n3;
                }
                if (n3 == n2 || string.charAt(n3) == '-') {
                    this.m_log.println(this.m_crwerr.getMsg(30422));
                    this.m_err.println(this.m_crwerr.getMsg(30422));
                    this.usage();
                    System.exit(1);
                }
                comparable = new StringBuffer();
                boolean bl2 = false;
                while (n3 < n2 && (c = string.charAt(n3)) != ' ') {
                    ((StringBuffer)comparable).append(c);
                    ++n3;
                }
                string2 = ((StringBuffer)comparable).toString();
            }
        } else {
            String string3;
            while ((string3 = this.getNexttoken(null, n, false, null)) != null) {
                String string4;
                if (!string3.equals("-log")) continue;
                string3 = this.getNexttoken(null, n, false, null);
                if (string3 == null || string3.startsWith("-")) {
                    this.m_log.println(this.m_crwerr.getMsg(30422));
                    this.m_err.println(this.m_crwerr.getMsg(30422));
                    this.usage();
                    System.exit(1);
                }
                string2 = string4 = this.fixPathSlashes(string3);
            }
            this.m_tokenCount = 0;
        }
        if (string2 != null) {
            String string5 = System.getProperty("file.separator");
            n2 = string2.lastIndexOf(string5);
            if (n2 != -1) {
                String string6 = string2.substring(0, string2.lastIndexOf(string5) + 1);
                comparable = new File(string6);
                if (((File)comparable).exists()) {
                    if (!((File)comparable).canWrite()) {
                        MessageFormat messageFormat = new MessageFormat(this.m_crwerr.getMsg(30738));
                        Object[] objectArray = new Object[]{string6};
                        this.m_err.println(messageFormat.format(objectArray));
                        System.exit(1);
                    }
                } else if (!((File)comparable).mkdirs()) {
                    MessageFormat messageFormat = new MessageFormat(this.m_crwerr.getMsg(30737));
                    Object[] objectArray = new Object[]{string6};
                    this.m_err.println(messageFormat.format(objectArray));
                    System.exit(1);
                }
            }
            this.m_lazyout = new LazyOutputStream(string2);
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)this.m_lazyout, "UTF8");
                this.m_log = new CustomPrintWriter((Writer)outputStreamWriter, true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.m_log = new CustomPrintWriter((OutputStream)this.m_lazyout, true);
                this.m_err.println(unsupportedEncodingException.toString());
            }
        }
        return string2;
    }

    private boolean withinMaxFileDescriptor(String string, int n) {
        int n2 = n;
        if (this.m_cachingOn) {
            n2 = n <= 15 ? ++n2 : (n2 += n / 15 + 1);
        }
        if (this.m_filterPath != null) {
            n2 += (this.m_filterNum + 1) * 2;
        }
        FileInputStream[] fileInputStreamArray = new FileInputStream[n2 += 10];
        int n3 = 0;
        while (n3 < n2) {
            try {
                fileInputStreamArray[n3] = new FileInputStream(string);
            }
            catch (IOException iOException) {
                break;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n3) {
            try {
                fileInputStreamArray[n4].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n4;
        }
        fileInputStreamArray = null;
        return n3 == n2;
    }
}

