/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;

public class DisplayNodes
extends OiifpWizPanel
implements ItemListener,
ActionListener {
    private static final String NODELABEL = "Select the nodes which will be a part of this Oracle Parallel Server Database:";
    private static final String ADDLABEL = "Enter additional nodes: ";
    private static final String NODELISTLABEL = "Nodes: ";
    private static final int LEFT_PADDING = 10;
    private static final int RIGHT_PADDING = 10;
    private static final int CONTROL_SPACE = 7;
    private LWList nodeList;
    private MultiLineLabel nodeLabel;
    private MultiLineLabel addLabel;
    private LWTextField addEdit;
    private Button addButton;
    private Button remButton;
    private MultiLineLabel nodeListLabel;
    private Color nodeLabelColor;

    public DisplayNodes() {
        this("");
        String[] stringArray;
        String string = "";
        try {
            stringArray = InetAddress.getLocalHost();
            string = stringArray.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        stringArray = new String[]{string};
        this.setNodeList(stringArray);
    }

    public DisplayNodes(String string) {
        super("Title");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mainPanel.setLayout(gridBagLayout);
        this.nodeLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), NODELABEL);
        this.AddComponent((Component)this.nodeLabel, (Container)this.mainPanel, gridBagLayout, gridBagConstraints, 1, 16, -1, -1, 0, 1, 1.0, 0.0, new Insets(0, 10, 7, 10));
        this.addLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), ADDLABEL);
        this.AddComponent((Component)this.addLabel, (Container)this.mainPanel, gridBagLayout, gridBagConstraints, 3, 18, -1, -1, 1, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        this.addEdit = new LWTextField();
        this.AddComponent((Component)this.addEdit, (Container)this.mainPanel, gridBagLayout, gridBagConstraints, 2, 18, -1, -1, 1, 1, 1.0, 0.0, new Insets(0, 10, 7, 10));
        this.addButton = new Button("Add");
        this.addButton.addActionListener(this);
        this.AddComponent(this.addButton, (Container)this.mainPanel, gridBagLayout, gridBagConstraints, 0, 18, -1, -1, 0, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        this.nodeListLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), NODELISTLABEL);
        this.AddComponent((Component)this.nodeListLabel, (Container)this.mainPanel, gridBagLayout, gridBagConstraints, 3, 18, -1, -1, 1, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        this.nodeList = new LWList();
        this.nodeList.setMultipleMode(true);
        this.AddComponent((Component)this.nodeList, (Container)this.mainPanel, gridBagLayout, gridBagConstraints, 1, 18, -1, -1, 1, 1, 1.0, 0.0, new Insets(0, 10, 7, 10));
        this.nodeList.addItemListener((ItemListener)this);
        LWLabel lWLabel = new LWLabel("");
        this.AddComponent((Component)lWLabel, (Container)this.mainPanel, gridBagLayout, gridBagConstraints, 0, 18, -1, -1, 0, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        LWLabel lWLabel2 = new LWLabel("");
        this.AddComponent((Component)lWLabel2, (Container)this.mainPanel, gridBagLayout, gridBagConstraints, 0, 18, -1, -1, 1, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        this.remButton = new Button("Remove");
        this.remButton.addActionListener(this);
        this.AddComponent(this.remButton, (Container)this.mainPanel, gridBagLayout, gridBagConstraints, 0, 17, -1, -1, 1, 1, 1.0, 0.0, new Insets(0, 10, 7, 10));
        LWLabel lWLabel3 = new LWLabel("");
        this.AddComponent((Component)lWLabel3, (Container)this.mainPanel, gridBagLayout, gridBagConstraints, 0, 18, -1, -1, 0, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        this.nodeLabelColor = this.nodeLabel.getBackground();
    }

    private void AddComponent(Component component, Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, Insets insets) {
        gridBagConstraints.fill = n;
        gridBagConstraints.anchor = n2;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.gridwidth = n5;
        gridBagConstraints.gridheight = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.insets = insets;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void EnableControls(boolean bl) {
        this.nodeListLabel.setEnabled(bl);
        this.nodeList.setEnabled(bl);
    }

    private void UpdatenodeListBox() {
        if (this.nodeList.getItemCount() == 0) {
            this.EnableControls(false);
        } else {
            this.EnableControls(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            String string = this.addEdit.getText();
            if (string.trim().compareTo("") != 0) {
                this.nodeList.add(string);
                this.addEdit.setText("");
            }
        } else if (object == this.remButton) {
            try {
                String[] stringArray = this.nodeList.getSelectedItems();
                int n = 0;
                while (n < stringArray.length) {
                    this.nodeList.remove(stringArray[n]);
                    ++n;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.UpdatenodeListBox();
    }

    public String[] getNodeList() {
        return this.nodeList.getItems();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2 && !this.nodeList.isIndexSelected(0)) {
            this.UpdatenodeListBox();
        }
    }

    public void markAddPrompt() {
        this.addLabel.setBackground(this._markColor);
    }

    public void markNodeList() {
        this.nodeList.setBackground(this._markColor);
    }

    public void markNodePrompt() {
        this.nodeListLabel.setBackground(this._markColor);
    }

    public void markPrompt() {
        this.nodeLabel.setBackground(this._markColor);
    }

    public void setAddPrompt(String string) {
        if (string != null) {
            this.addLabel.setText(string);
        }
    }

    public void setNodeList(String[] stringArray) {
        this.invalidate();
        this.nodeList.removeAll();
        int n = 0;
        while (n < stringArray.length) {
            this.nodeList.add(stringArray[n]);
            ++n;
        }
        ((Container)((Object)this)).validate();
    }

    public void setNodePrompt(String string) {
        if (string != null) {
            this.nodeListLabel.setText(string);
        }
    }

    public void setPrompt(String string) {
        if (string != null) {
            this.nodeLabel.setText(string);
        }
    }

    public void unmarkAddPrompt() {
        this.addLabel.setBackground(this.nodeLabelColor);
    }

    public void unmarkNodeList() {
        this.nodeList.setBackground(this.nodeLabelColor);
    }

    public void unmarkNodePrompt() {
        this.nodeListLabel.setBackground(this.nodeLabelColor);
    }

    public void unmarkPrompt() {
        this.nodeLabel.setBackground(this.nodeLabelColor);
    }
}

