/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifm.OiifmDirectoryDlg;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiix.OiixPlatform;

public class SID2Migrate
extends OiifpWizPanel
implements TableRowSelectListener,
ActionListener,
ItemListener {
    private static final int DEF_PATH_SIZE = 350;
    private static final int DEF_SID_SIZE = 100;
    private static final String DEFAULT_TITLE = "Title";
    private static final String DEFAULT_PROMPT = "Prompt";
    private static final String[] HEADERS = new String[]{"SID", "Oracle Home Path"};
    private static final String[] DEF_LIST = new String[]{"scott", "/home/scott/oracle/scott/", "...", "..."};
    private static final String NT = "Windows NT";
    private static final String SOLARIS = "Solaris";
    private static final String SUNOS = "SunOS";
    private static final String HPUNIX = "HP-UX";
    private SpreadTable myTable;
    private ArrayTwoDDataSource myData;
    private ArrayOneDDataSource myHeader;
    private SingleRowSelection mySingleRowSelector;
    private MultiLineLabel myPrompt;
    private LWCheckbox myCheckbox;
    private String defcbLabel;
    private Color promptLabelColor;
    private boolean isUnix;
    private ScrollBox tableScroll;
    private LWTextField myTextSID;
    private LWTextField myTextOH;
    private LWButton browseButton;
    private Container frame;

    public SID2Migrate() {
        this("");
        this.setTitleLabel(DEFAULT_TITLE);
        this.setPrompt(DEFAULT_PROMPT);
        this.setTable(DEF_LIST);
        this.isUnix = OiixPlatform.isPlatInGroup((int)-1, (int)OiixPlatform.getCurrentPlatform());
        if (this.isUnix) {
            this.setSIDText((String)this.myData.getData(0, 0));
            this.setOHText((String)this.myData.getData(1, 0));
        }
    }

    public SID2Migrate(String string) {
        super(DEFAULT_TITLE);
        this.myPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), string);
        this.myPrompt.setPreferredAspectRatio(0.0f);
        this.mainPanel.add((Component)this.myPrompt, "North");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.dlgPanel.setLayout(gridBagLayout);
        this.defcbLabel = "Default Text Should Not Appear";
        this.myCheckbox = new LWCheckbox(this.defcbLabel, false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagLayout.setConstraints((Component)this.myCheckbox, gridBagConstraints);
        this.myCheckbox.addItemListener((ItemListener)this);
        this.dlgPanel.add((Component)this.myCheckbox);
        this.myHeader = new ArrayOneDDataSource((Object[])HEADERS);
        this.myTable = new SpreadTable((TwoDDataSource)this.myData, (OneDDataSource)this.myHeader, null);
        this.mySingleRowSelector = new SingleRowSelection();
        this.myTable.setVerticalSeparatorsVisible(false);
        this.myTable.setHorizontalSeparatorsVisible(false);
        Grid grid = this.myTable.getGrid();
        grid.setGridSelection((GridSelection)this.mySingleRowSelector);
        this.mySingleRowSelector.setParent(grid);
        this.myTable.addRowSelectListener((TableRowSelectListener)this);
        this.tableScroll = new ScrollBox((Component)this.myTable, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        gridBagConstraints.fill = 1;
        if (this.isUnix) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.2;
        } else {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.4;
        }
        gridBagLayout.setConstraints((Component)this.tableScroll, gridBagConstraints);
        this.dlgPanel.add((Component)this.tableScroll);
        this.myTextSID = new LWTextField();
        this.myTextOH = new LWTextField();
        this.browseButton = new LWButton("Browse");
        if (this.isUnix) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.4;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagLayout.setConstraints((Component)this.myTextSID, gridBagConstraints);
            this.dlgPanel.add((Component)this.myTextSID);
            gridBagConstraints.weightx = 4.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.gridx = -1;
            gridBagLayout.setConstraints((Component)this.myTextOH, gridBagConstraints);
            this.dlgPanel.add((Component)this.myTextOH);
            this.frame = this;
            this.browseButton.addActionListener((ActionListener)this);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = -1;
            gridBagLayout.setConstraints((Component)this.browseButton, gridBagConstraints);
            this.dlgPanel.add((Component)this.browseButton);
        }
        if (!this.myCheckbox.getState()) {
            this.myTable.setEnabled(false);
            this.tableScroll.setEnabled(false);
            this.myTextSID.setEnabled(false);
            this.myTextOH.setEnabled(false);
            this.browseButton.setEnabled(false);
        }
        this.promptLabelColor = this.myPrompt.getBackground();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        while (!(this.frame instanceof Frame)) {
            this.frame = this.frame.getParent();
        }
        String string = "Directory Dialog";
        OiifmDirectoryDlg oiifmDirectoryDlg = new OiifmDirectoryDlg((Frame)this.frame, string);
        File file = new File(System.getProperty("user.dir"));
        File file2 = oiifmDirectoryDlg.runDialog(file);
        if (file2 != null) {
            this.setOHText(file2.getPath());
        }
    }

    public String[] getAnswer() {
        String[] stringArray = new String[]{this.sidAns(), this.ohAns()};
        return stringArray;
    }

    public String getCheckBoxValue() {
        return this.myCheckbox.getState() ? "Y" : "N";
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.myTable.setEnabled(true);
            this.tableScroll.setEnabled(true);
            this.myTextSID.setEnabled(true);
            this.myTextOH.setEnabled(true);
            this.browseButton.setEnabled(true);
        } else {
            this.myTable.setEnabled(false);
            this.tableScroll.setEnabled(false);
            this.myTextSID.setEnabled(false);
            this.myTextOH.setEnabled(false);
            this.browseButton.setEnabled(false);
        }
    }

    public void markPrompt() {
        this.myPrompt.setBackground(this._markColor);
    }

    private String ohAns() {
        if (!this.myCheckbox.getState()) {
            return new String("<None>");
        }
        if (this.isUnix) {
            return this.myTextOH.getText();
        }
        int[] nArray = this.mySingleRowSelector.getSelectedRows();
        return (String)this.myData.getData(1, nArray[0]);
    }

    public void rowDeselected(TableEvent tableEvent) {
    }

    public void rowDeselecting(TableEvent tableEvent) {
    }

    public void rowSelected(TableEvent tableEvent) {
        int n = tableEvent.getRow();
        this.setSIDText((String)this.myData.getData(0, n));
        this.setOHText((String)this.myData.getData(1, n));
    }

    public void rowSelecting(TableEvent tableEvent) {
    }

    public void setAnswer(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length != 0) {
            int n = 0;
            while (n < this.myData.getRowCount()) {
                if (stringArray[0].equalsIgnoreCase((String)this.myData.getData(0, n))) {
                    this.mySingleRowSelector.setRowSelected(n, true);
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (!bl) {
            this.mySingleRowSelector.setRowSelected(0, true);
        }
    }

    public void setCheckBoxLabel(String string) {
        if (string != null) {
            this.myCheckbox.setLabel(string);
        }
    }

    public void setCheckBoxValue(String string) {
        this.setCheckBoxValue(string.equals("Y"));
    }

    public void setCheckBoxValue(boolean bl) {
        this.myCheckbox.setState(bl);
        this.myTable.setEnabled(bl);
        this.tableScroll.setEnabled(bl);
        this.myTextSID.setEnabled(bl);
        this.myTextOH.setEnabled(bl);
        this.browseButton.setEnabled(bl);
    }

    private void setOHText(String string) {
        if (string != null && this.isUnix) {
            this.myTextOH.setText(string);
        }
    }

    public void setPrompt(String string) {
        if (string != null) {
            this.myPrompt.setText(string);
        }
    }

    private void setSIDText(String string) {
        if (string != null && this.isUnix) {
            this.myTextSID.setText(string);
        }
    }

    public void setTable(String[] stringArray) {
        int n = stringArray.length / 2;
        this.myData = new ArrayTwoDDataSource(2, n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.myData.getRowCount()) {
            int n4 = 0;
            while (n4 < this.myData.getColumnCount()) {
                this.myData.setData(n4, n3, (Object)stringArray[n2]);
                ++n2;
                ++n4;
            }
            ++n3;
        }
        this.myTable.setDataSources((TwoDDataSource)this.myData, (OneDDataSource)this.myHeader, null);
        this.myTable.setColumnWidth(0, 100);
        this.myTable.setColumnWidth(1, 350);
        if (this.isUnix) {
            this.setSIDText((String)this.myData.getData(0, 0));
            this.setOHText((String)this.myData.getData(1, 0));
        }
    }

    private String sidAns() {
        if (!this.myCheckbox.getState()) {
            return new String("<None>");
        }
        if (this.isUnix) {
            return this.myTextSID.getText();
        }
        int[] nArray = this.mySingleRowSelector.getSelectedRows();
        return (String)this.myData.getData(0, nArray[0]);
    }

    public void unmarkPrompt() {
        this.myPrompt.setBackground(this.promptLabelColor);
    }
}

