#
# Copyright (c) 1998, 2003, Oracle Corporation.  All rights reserved.  
#
# NAME:
#
#  frminit.tcl -- platform specific init file
#
# ARGUMENTS:
#
#  none
#
# RETURNS:
#
#  none
#
# MODIFIED     (MM/DD/YY)
#  mkiran       07/26/03 - added function frm_getportnumber
#  sdulepet     03/16/01 - removed _f60path and _f45path, for multiple oracle home support
#  vtummala     03/22/00 -
#  ayu          02/29/00 -  added frmSet/RestoreOracleEnvironment wrapper
#  ayu          03/04/98 -  Creation
#

#
# debug flag (0 or 1)
#
set frm_debug_flag 0

#
# set Forms60_home
#
source [AGENT_ORACLE_HOME]/[NETWORK]/agent/tcl/frmhome.tcl

#
# set some platform-specific variables
#
set _lnrexename "ifsrv60"
set _frmexename "ifweb60"
set _msexename "d2ls60"
set _mcexename "d2lc60"
set _lnr45exename "f45srv32"
set _f45exename "f45web32"
set _ms45exename "d2ls1032"
set _mc45exename "d2lc1032"
set _src ""
set _setenv_format "set %s=%s"
set _start "start"
set _listen "-listen"
set _killcommand "ifctrl60 -k"
set _logcommand "ifctrl60 -s"
set _rti_ps_command "ifctrl60 -c"
set _getmemusage "ifctrl60 -p"
set _getcpuusage "ifctrl60 -c"
set bin "bin"
set _pathsep "\\"

#
# returns the port number of the forms listener running at OS PID --> pid
# exename depends on forms version - f45srvm or f60srvm
#
proc frm_getportnumber { exename pid } {
    # The 'args' option of 'ps' command gives the complete OS representation
    # of the process, which includes executable file name along with it's 
    # options and arguments.
    # Example of forms listener process: f60srvm port=9090 pool=1 mode=socket
    set ps_command "ifctrl60 -p"

    # Store output of "ps" command in a temporary file
    set tmpf [tempfile tmp]
    eval exec $ps_command > $tmpf

    # Open temporary file and read one line at a time from it.
    set fid [open $tmpf r]
    set port_number -1

    # Examples of match_pattern.....
    # 1. f60srvm port=9090
    # 2. f45srvm port=9090
    set match_pattern [format "%s port\=\(\[0\-9\]\+\)" $exename]

    # Fetch a line from temporary file until EOF. 
    # Each line is of the form: "<OS pid> <process name with all args>"
    while {[gets $fid line] >= 0} {

      # Process current line only if it's OS pid is what we are looking for.
      if {![string compare [lindex $line 0] $pid]} {

        # The current line represents a forms listener process
        # Get port number of this forms listener process
        # Example: If process is "f60srvm port=9090 pool=1 mode=socket"
        #             port_number becomes '9090'
        regexp -nocase $match_pattern $line trash port_number
      }
    }
    close $fid
    rmfile $tmpf

    # return the fetched port number to caller.
    return $port_number
}

#
# returns a list of running processes whose name matches the argument
#
proc frm_getpidlist { pat } {
    set ps_command "ifctrl60 -p"
    set pidlist {}
    set tmpf [tempfile tmp]
    # run pulist command to get a list of runtime instances
    eval exec $ps_command > $tmpf
    set fid [open $tmpf r]
    while {[gets $fid line] >= 0} {
      if [regexp -nocase $pat $line] {
          lappend pidlist [lindex $line 1]
      }
    }
    close $fid
    rmfile $tmpf

    return $pidlist
}

#
# log an entry to a pre-defined log file
#
proc frmdebug { entry } {
    global frm_debug_flag

    if { $frm_debug_flag } {
        set frm_logfile "c:\\temp\\tcl.log"
        set logfid [open $frm_logfile a]
        puts $logfid $entry
        close $logfid
    }
}

proc frmSetOracleEnvironment {} {
}

proc frmRestoreOracleEnvironment {} {
}

