--
-- THE FUNCTIONS, PACKAGES AND TYPES SUPPLIED BY THIS PACKAGE AND ITS EXTERNAL
-- INTERFACE ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE
-- RELEASES.  THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
-- COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE DBMS.
--
-- Copyright (c) 1997, 2003 by Oracle Corporation
--
-- NAME
-- ordaspec.sql - ORDAudio specification
--
-- DESCRIPTION
-- MODIFIED (MM/DD/YY)
-- smavris   01/30/03 - Change to create type
-- virao     08/06/01 - Remove SpeechMining methods
-- virao     06/25/01 - Changing audiomining to speechmining
-- virao     03/20/01 - Adding analyze method for AudioMining
-- smavris   03/02/01 - Remove / after alter
-- alandeck  01/31/01 - Removing openSource/closeSource due to overloading prob
-- alandeck  01/09/01 - Re-adding the openSource closeSource functions
-- alandeck  06/27/00 - Adding static methods for relational interface
-- smavris   04/28/00 - Fix upgrade bug
-- dmullen   11/02/99 - Add static funtions to act as constructors
-- smavris   09/30/99 - Make it work with sqlplus
-- rchatter  08/07/99 - adding getBFILE interface
-- dmullen   07/23/99 - Fix temp lob leaks
-- wklee     06/28/99 - fix alter types priviliges
-- wklee     06/24/99 - annotator implementation
-- rchatter  11/16/98 - making ctx changes
-- alsrivas  10/14/98 - dropping getSourceObject interface
-- alsrivas  09/01/98 - addin NOCOPY
-- alsrivas  08/26/98 - fixing code and comments
-- rchatter  08/11/98 - making changes for new attributes
-- alsrivas  07/29/98 - adding new attributes
-- rchatter  07/09/98 - fixing importFrom interface
-- alsrivas  06/11/98 - removing date attribute from audio
-- alsrivas  06/08/98 - updating
-- alsrivas  05/25/98 - adding review comments
-- alsrivas  05/11/98 - updating
-- alsrivas  05/11/98 - updating object interfaces
-- alsrivas  04/17/98 - updating
-- alsrivas  01/14/98 - removing left out code
-- alsrivas  01/05/98 - adding ORDAudio types
-- alsrivas  12/10/97 - Creation

CREATE TYPE ORDAudio
TIMESTAMP '1998-05-18:10:00:00'
OID '2E8F6D4B0D790990E03400400B4066F3'
authid current_user
AS OBJECT
(
---------------------------
-- ATTRIBUTES
---------------------------
  description VARCHAR2(4000),
  source      ORDSource,
  format      VARCHAR2(31),
  mimeType    VARCHAR2(4000),
  comments    CLOB,

---------------------------
-- Audio Related Attributes
---------------------------

  encoding         VARCHAR2(256),
  numberOfChannels INTEGER,
  samplingRate     INTEGER,
  sampleSize       INTEGER,
  compressionType  VARCHAR2(4000),
  audioDuration    INTEGER, 

---------------------------
-- METHODS
---------------------------
  -- DATE RELATED METHODS
  MEMBER FUNCTION  getUpdateTime RETURN DATE,
  PRAGMA RESTRICT_REFERENCES(getUpdateTime, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setUpdateTime(SELF IN OUT NOCOPY ORDAudio,
                                 current_time DATE),

  -- DESCRIPTION RELATED METHODS
  MEMBER PROCEDURE setDescription(SELF IN OUT NOCOPY ORDAudio,
                                  user_description IN VARCHAR2), 
  MEMBER FUNCTION  getDescription RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getDescription, WNDS, WNPS, RNDS, RNPS),

  -- MIMETYPE RELATED METHODS
  MEMBER FUNCTION  getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS),

  MEMBER PROCEDURE setMimeType(SELF IN OUT NOCOPY ORDAudio,
                               mime IN VARCHAR2),


  -- SOURCE RELATED METHODS
  MEMBER FUNCTION  processSourceCommand(
                            SELF      IN OUT NOCOPY ORDAudio,
                            ctx       IN OUT RAW,
                            cmd       IN VARCHAR2,
                            arguments IN VARCHAR2,
                            result    OUT RAW)
                   RETURN RAW,

  MEMBER FUNCTION  isLocal RETURN BOOLEAN,
  PRAGMA RESTRICT_REFERENCES(isLocal, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setLocal(SELF IN OUT NOCOPY ORDAudio),
  MEMBER PROCEDURE clearLocal(SELF IN OUT NOCOPY ORDAudio),
  MEMBER PROCEDURE setSource(SELF IN OUT NOCOPY ORDAudio,
                             source_type     IN VARCHAR2, 
                             source_location IN VARCHAR2, 
                             source_name     IN VARCHAR2),
  MEMBER FUNCTION  getSource RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSource, WNDS, WNPS, RNDS, RNPS),

  MEMBER FUNCTION  getSourceType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceType, WNDS, WNPS, RNDS, RNPS),

  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceLocation, WNDS, WNPS, RNDS, RNPS),

  MEMBER FUNCTION  getSourceName RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceName, WNDS, WNPS, RNDS, RNPS),

  MEMBER PROCEDURE import(SELF IN OUT NOCOPY ORDAudio,
                          ctx IN OUT RAW),
  MEMBER PROCEDURE importFrom(SELF IN OUT NOCOPY ORDAudio,
                          ctx IN OUT RAW,
                          source_type IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name IN VARCHAR2),
  MEMBER PROCEDURE export(SELF IN OUT NOCOPY ORDAudio,
                          ctx      IN OUT RAW,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  MEMBER FUNCTION  getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getContentLength(ctx IN OUT RAW) RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),

  -- This method will copy data in the LOB provided, if the data is not 
  -- stored in internal LOB it will be imported and returned in the LOB 
  -- provided
  MEMBER PROCEDURE getContentInLob(SELF IN OUT NOCOPY ORDAudio,
                                   ctx IN OUT RAW,
                                   dest_lob IN OUT NOCOPY BLOB,
                                   mimeType OUT VARCHAR2,
                                   format OUT VARCHAR2),

  MEMBER FUNCTION  getContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS),

  MEMBER PROCEDURE deleteContent(SELF IN OUT NOCOPY ORDAudio),

  -- FILE OPERATIONS on the source
  MEMBER FUNCTION openSource(SELF IN OUT NOCOPY ORDAudio, 
                             userArg IN RAW,
                             ctx  OUT RAW) RETURN INTEGER,

  MEMBER FUNCTION closeSource(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW) 
  RETURN INTEGER,

  MEMBER FUNCTION trimSource(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW, 
                             newlen IN INTEGER) RETURN INTEGER,

  MEMBER PROCEDURE readFromSource(SELF IN OUT NOCOPY ORDAudio,
                                  ctx IN OUT RAW,
                                  startPos IN INTEGER,
                                  numBytes IN OUT INTEGER,
                                  buffer OUT RAW),

  MEMBER PROCEDURE writeToSource(SELF IN OUT NOCOPY ORDAudio,
                                 ctx IN OUT RAW,
                                 startPos IN INTEGER,
                                 numBytes IN OUT INTEGER,
                                 buffer IN RAW),

  -- COMMENT RELATED METHODS
  MEMBER PROCEDURE appendToComments(SELF IN OUT NOCOPY ORDAudio,
                                    amount IN BINARY_INTEGER, 
                                    buffer IN VARCHAR2),

  MEMBER PROCEDURE writeToComments(SELF IN OUT NOCOPY ORDAudio,
                                   offset IN INTEGER, 
                                   amount IN BINARY_INTEGER, 
                                   buffer IN VARCHAR2),

  MEMBER FUNCTION readFromComments(offset IN INTEGER,
                                   amount IN BINARY_INTEGER := 32767)
         RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(readFromComments, WNDS, WNPS, RNDS, RNPS),

  MEMBER FUNCTION locateInComments(pattern IN VARCHAR2,
                                   offset IN INTEGER := 1,
                                   occurrence IN INTEGER := 1)
         RETURN INTEGER,

  MEMBER PROCEDURE trimComments(SELF IN OUT NOCOPY ORDAudio,
                                newlen IN INTEGER),

  MEMBER PROCEDURE eraseFromComments(SELF IN OUT NOCOPY ORDAudio,
                                     amount IN OUT NOCOPY INTEGER,
                                     offset IN            INTEGER := 1),
  MEMBER PROCEDURE deleteComments(SELF IN OUT NOCOPY ORDAudio),

  MEMBER PROCEDURE loadCommentsFromFile(SELF IN OUT NOCOPY ORDAudio,
                                        fileobj IN BFILE,
                                        amount IN INTEGER,
                                        from_loc IN INTEGER := 1,
                                        to_loc IN INTEGER := 1),

  MEMBER PROCEDURE copyCommentsOut( SELF IN OUT NOCOPY ORDAudio,
                                    dest IN OUT NOCOPY CLOB,
                                    amount IN INTEGER,
                                    from_loc IN INTEGER := 1,
                                    to_loc IN INTEGER := 1),

  MEMBER FUNCTION compareComments(compare_with_lob IN CLOB,
                                  amount IN INTEGER:= 4294967295,
                                  starting_pos_in_comment IN INTEGER := 1,
                                  starting_pos_in_compare IN INTEGER := 1) 
         RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(compareComments, WNDS, WNPS, RNDS, RNPS),

  MEMBER FUNCTION getCommentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getCommentLength, WNDS, WNPS, RNDS, RNPS),

  -- AUDIO ATTRIBUTES RELATED METHOD
  MEMBER PROCEDURE setFormat(SELF IN OUT NOCOPY ORDAudio,
                             knownFormat IN VARCHAR2),
  MEMBER FUNCTION  getFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION getFormat(ctx IN OUT RAW) RETURN VARCHAR2,

  MEMBER PROCEDURE setEncoding(SELF IN OUT NOCOPY ORDAudio,
                               knownEncoding IN VARCHAR2),
  MEMBER FUNCTION  getEncoding RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getEncoding, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION getEncoding(ctx IN OUT RAW) RETURN VARCHAR2,

  MEMBER PROCEDURE setNumberOfChannels(SELF IN OUT NOCOPY ORDAudio,
                                       knownNumberOfChannels IN INTEGER),
  MEMBER FUNCTION  getNumberOfChannels RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getNumberOfChannels, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getNumberOfChannels(ctx IN OUT RAW) RETURN INTEGER,

  MEMBER PROCEDURE setSamplingRate(SELF IN OUT NOCOPY ORDAudio,
                                   knownSamplingRate IN INTEGER),
  MEMBER FUNCTION  getSamplingRate RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getSamplingRate, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getSamplingRate(ctx IN OUT RAW) RETURN INTEGER,

  MEMBER PROCEDURE setSampleSize(SELF IN OUT NOCOPY ORDAudio,
                                 knownSampleSize IN INTEGER),
  MEMBER FUNCTION  getSampleSize RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getSampleSize, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getSampleSize(ctx IN OUT RAW) RETURN INTEGER,

  MEMBER PROCEDURE setCompressionType(SELF IN OUT NOCOPY ORDAudio,
                                      knownCompressionType IN VARCHAR2),
  MEMBER FUNCTION  getCompressionType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getCompressionType(ctx IN OUT RAW) RETURN VARCHAR2,

  MEMBER PROCEDURE setAudioDuration(SELF IN OUT NOCOPY ORDAudio,
                                    knownAudioDuration IN INTEGER),
  MEMBER FUNCTION  getAudioDuration RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getAudioDuration, WNDS, WNPS, RNDS, RNPS),

  MEMBER FUNCTION  getAudioDuration(ctx IN OUT RAW) RETURN INTEGER,

  MEMBER FUNCTION getBFILE RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getBFILE, WNDS, WNPS, RNDS, RNPS),

  MEMBER PROCEDURE setKnownAttributes( SELF IN OUT NOCOPY ORDAudio,
                                       knownFormat IN VARCHAR2,
                                       knownEncoding IN VARCHAR2,
                                       knownNumberOfChannels IN INTEGER,
                                       knownSamplingRate IN INTEGER,
                                       knownSampleSize IN INTEGER,
                                       knownCompressionType IN VARCHAR2,
                                       knownAudioDuration IN INTEGER), 

  -- Format processor must set all the properties
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW),

  -- Format processor will get a copy of the SELF, they should
  -- check the validity of the properties and return TRUE if the
  -- properties are Ok, FALSE otherwise
  MEMBER FUNCTION checkProperties(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW) 
  RETURN BOOLEAN,

  MEMBER FUNCTION  getAttribute(ctx IN OUT RAW,
                                name IN VARCHAR2) RETURN VARCHAR2,
 
  MEMBER PROCEDURE getAllAttributes(SELF IN OUT NOCOPY ORDAudio,
                                    ctx IN OUT RAW, 
                                    attributes IN OUT NOCOPY CLOB),


  -- AUDIO PROCESSING METHODS
  MEMBER FUNCTION  processAudioCommand(
                                 SELF      IN OUT NOCOPY ORDAudio,
                                 ctx       IN OUT RAW,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result    OUT RAW)
                   RETURN RAW

);
/
show errors;

--
-- Recompile ORDAudio in case this is an upgrade and an upgrade of
-- ORDSource has invalidated ORDAudio.
--
ALTER TYPE ORDAudio COMPILE;

ALTER TYPE ORDAudio
REPLACE 
authid current_user
AS OBJECT
(
---------------------------
-- ATTRIBUTES
---------------------------
  description VARCHAR2(4000),
  source      ORDSource,
  format      VARCHAR2(31),
  mimeType    VARCHAR2(4000),
  comments    CLOB,
--
---------------------------
-- Audio Related Attributes
---------------------------
--
  encoding         VARCHAR2(256),
  numberOfChannels INTEGER,
  samplingRate     INTEGER,
  sampleSize       INTEGER,
  compressionType  VARCHAR2(4000),
  audioDuration    INTEGER, 
---------------------------
-- METHODS
---------------------------
  -- CONSTRUCTORS
  STATIC FUNCTION init RETURN ORDAudio,
  STATIC FUNCTION init( srcType IN VARCHAR2,
            srcLocation IN VARCHAR2,
            srcName IN VARCHAR2 ) RETURN ORDAudio,
--
  -- DATE RELATED METHODS
  MEMBER FUNCTION  getUpdateTime RETURN DATE,
  PRAGMA RESTRICT_REFERENCES(getUpdateTime, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setUpdateTime(SELF IN OUT NOCOPY ORDAudio,
                                 current_time DATE),
  --
  -- DESCRIPTION RELATED METHODS
  MEMBER PROCEDURE setDescription(SELF IN OUT NOCOPY ORDAudio,
                                  user_description IN VARCHAR2), 
  MEMBER FUNCTION  getDescription RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getDescription, WNDS, WNPS, RNDS, RNPS),
  --
  -- MIMETYPE RELATED METHODS
  MEMBER FUNCTION  getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setMimeType(SELF IN OUT NOCOPY ORDAudio,
                               mime IN VARCHAR2),
  --
  --
  -- SOURCE RELATED METHODS
  MEMBER FUNCTION  processSourceCommand(
                            SELF      IN OUT NOCOPY ORDAudio,
                            ctx       IN OUT RAW,
                            cmd       IN VARCHAR2,
                            arguments IN VARCHAR2,
                            result    OUT RAW)
                   RETURN RAW,
  --
  MEMBER FUNCTION  isLocal RETURN BOOLEAN,
  PRAGMA RESTRICT_REFERENCES(isLocal, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setLocal(SELF IN OUT NOCOPY ORDAudio),
  MEMBER PROCEDURE clearLocal(SELF IN OUT NOCOPY ORDAudio),
  MEMBER PROCEDURE setSource(SELF IN OUT NOCOPY ORDAudio,
                             source_type     IN VARCHAR2, 
                             source_location IN VARCHAR2, 
                             source_name     IN VARCHAR2),
  MEMBER FUNCTION  getSource RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSource, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceType, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceLocation, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceName RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceName, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE import(SELF IN OUT NOCOPY ORDAudio,
                          ctx IN OUT RAW),
  MEMBER PROCEDURE importFrom(SELF IN OUT NOCOPY ORDAudio,
                          ctx IN OUT RAW,
                          source_type IN VARCHAR2,
                          source_location IN VARCHAR2,
              source_name IN VARCHAR2),
  MEMBER PROCEDURE export(SELF IN OUT NOCOPY ORDAudio,
                          ctx      IN OUT RAW,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  MEMBER FUNCTION  getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getContentLength(ctx IN OUT RAW) RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
  --
  -- This method will copy data in the LOB provided, if the data is not 
  -- stored in internal LOB it will be imported and returned in the LOB 
  -- provided
  MEMBER PROCEDURE getContentInLob(SELF IN OUT NOCOPY ORDAudio,
                                   ctx IN OUT RAW,
                                   dest_lob IN OUT NOCOPY BLOB,
                                   mimeType OUT VARCHAR2,
                                   format OUT VARCHAR2),
  --
  MEMBER FUNCTION  getContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE deleteContent(SELF IN OUT NOCOPY ORDAudio),
  --
  -- FILE OPERATIONS on the source
  MEMBER FUNCTION openSource(SELF IN OUT NOCOPY ORDAudio, 
                             userArg IN RAW,
                             ctx  OUT RAW) RETURN INTEGER,
  --
  MEMBER FUNCTION closeSource(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW) 
  RETURN INTEGER,
  --
  MEMBER FUNCTION trimSource(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW, 
                             newlen IN INTEGER) RETURN INTEGER,
  --
  MEMBER PROCEDURE readFromSource(SELF IN OUT NOCOPY ORDAudio,
                                  ctx IN OUT RAW,
                                  startPos IN INTEGER,
                                  numBytes IN OUT INTEGER,
                                  buffer OUT RAW),
  --
  MEMBER PROCEDURE writeToSource(SELF IN OUT NOCOPY ORDAudio,
                                 ctx IN OUT RAW,
                                 startPos IN INTEGER,
                                 numBytes IN OUT INTEGER,
                                 buffer IN RAW),
  --
  -- COMMENT RELATED METHODS
  MEMBER PROCEDURE appendToComments(SELF IN OUT NOCOPY ORDAudio,
                                    amount IN BINARY_INTEGER, 
                                    buffer IN VARCHAR2),
  --
  MEMBER PROCEDURE writeToComments(SELF IN OUT NOCOPY ORDAudio,
                                   offset IN INTEGER, 
                                   amount IN BINARY_INTEGER, 
                                   buffer IN VARCHAR2),
  --
  MEMBER FUNCTION readFromComments(offset IN INTEGER,
                                   amount IN BINARY_INTEGER := 32767)
         RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(readFromComments, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION locateInComments(pattern IN VARCHAR2,
                                   offset IN INTEGER := 1,
                                   occurrence IN INTEGER := 1)
         RETURN INTEGER,
  --
  MEMBER PROCEDURE trimComments(SELF IN OUT NOCOPY ORDAudio,
                                newlen IN INTEGER),
  --
  MEMBER PROCEDURE eraseFromComments(SELF IN OUT NOCOPY ORDAudio,
                                     amount IN OUT NOCOPY INTEGER,
                                     offset IN            INTEGER := 1),
  MEMBER PROCEDURE deleteComments(SELF IN OUT NOCOPY ORDAudio),
  --
  MEMBER PROCEDURE loadCommentsFromFile(SELF IN OUT NOCOPY ORDAudio,
                                        fileobj IN BFILE,
                                        amount IN INTEGER,
                                        from_loc IN INTEGER := 1,
                                        to_loc IN INTEGER := 1),
  --
  MEMBER PROCEDURE copyCommentsOut( SELF IN OUT NOCOPY ORDAudio,
                                    dest IN OUT NOCOPY CLOB,
                                    amount IN INTEGER,
                                    from_loc IN INTEGER := 1,
                                    to_loc IN INTEGER := 1),
  --
  MEMBER FUNCTION compareComments(compare_with_lob IN CLOB,
                                  amount IN INTEGER:= 4294967295,
                                  starting_pos_in_comment IN INTEGER := 1,
                                  starting_pos_in_compare IN INTEGER := 1) 
         RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(compareComments, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION getCommentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getCommentLength, WNDS, WNPS, RNDS, RNPS),
  --
  -- AUDIO ATTRIBUTES RELATED METHOD
  MEMBER PROCEDURE setFormat(SELF IN OUT NOCOPY ORDAudio,
                             knownFormat IN VARCHAR2),
  MEMBER FUNCTION  getFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION getFormat(ctx IN OUT RAW) RETURN VARCHAR2,
  --
  MEMBER PROCEDURE setEncoding(SELF IN OUT NOCOPY ORDAudio,
                               knownEncoding IN VARCHAR2),
  MEMBER FUNCTION  getEncoding RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getEncoding, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION getEncoding(ctx IN OUT RAW) RETURN VARCHAR2,
  --
  MEMBER PROCEDURE setNumberOfChannels(SELF IN OUT NOCOPY ORDAudio,
                                       knownNumberOfChannels IN INTEGER),
  MEMBER FUNCTION  getNumberOfChannels RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getNumberOfChannels, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getNumberOfChannels(ctx IN OUT RAW) RETURN INTEGER,
  --
  MEMBER PROCEDURE setSamplingRate(SELF IN OUT NOCOPY ORDAudio,
                                   knownSamplingRate IN INTEGER),
  MEMBER FUNCTION  getSamplingRate RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getSamplingRate, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getSamplingRate(ctx IN OUT RAW) RETURN INTEGER,
  --
  MEMBER PROCEDURE setSampleSize(SELF IN OUT NOCOPY ORDAudio,
                                 knownSampleSize IN INTEGER),
  MEMBER FUNCTION  getSampleSize RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getSampleSize, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getSampleSize(ctx IN OUT RAW) RETURN INTEGER,
  --
  MEMBER PROCEDURE setCompressionType(SELF IN OUT NOCOPY ORDAudio,
                                      knownCompressionType IN VARCHAR2),
  MEMBER FUNCTION  getCompressionType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getCompressionType(ctx IN OUT RAW) RETURN VARCHAR2,
  --
  MEMBER PROCEDURE setAudioDuration(SELF IN OUT NOCOPY ORDAudio,
                                    knownAudioDuration IN INTEGER),
  MEMBER FUNCTION  getAudioDuration RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getAudioDuration, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getAudioDuration(ctx IN OUT RAW) RETURN INTEGER,
  --
  MEMBER FUNCTION getBFILE RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getBFILE, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setKnownAttributes( SELF IN OUT NOCOPY ORDAudio,
                                       knownFormat IN VARCHAR2,
                                       knownEncoding IN VARCHAR2,
                                       knownNumberOfChannels IN INTEGER,
                                       knownSamplingRate IN INTEGER,
                                       knownSampleSize IN INTEGER,
                                       knownCompressionType IN VARCHAR2,
                                       knownAudioDuration IN INTEGER), 
  --
  -- Format processor must set all the properties
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW),
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDAudio, 
                                 ctx IN OUT RAW,
                                 setComments IN BOOLEAN),
  --
  -- Format processor will get a copy of the SELF, they should
  -- check the validity of the properties and return TRUE if the
  -- properties are Ok, FALSE otherwise
  MEMBER FUNCTION checkProperties(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW) 
  RETURN BOOLEAN,
  --
  MEMBER FUNCTION  getAttribute(ctx IN OUT RAW,
                                name IN VARCHAR2) RETURN VARCHAR2,
  --
  MEMBER PROCEDURE getAllAttributes(SELF IN OUT NOCOPY ORDAudio,
                                    ctx IN OUT RAW, 
                                    attributes IN OUT NOCOPY CLOB),
  --
  --
  -- AUDIO PROCESSING METHODS
  MEMBER FUNCTION  processAudioCommand(
                                 SELF      IN OUT NOCOPY ORDAudio,
                                 ctx       IN OUT RAW,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result    OUT RAW)
                   RETURN RAW,
  --
  --
  -- Static Methods for the relational functional interface
  STATIC PROCEDURE export(ctx             IN OUT RAW,
                          local_data      IN BLOB,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2,
                              format          OUT VARCHAR2,
                              mime_type       OUT VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx            IN OUT RAW,
                                 audioBlob      IN BLOB,
                                 attributes     IN OUT NOCOPY CLOB,
                                 format            IN VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx              IN OUT RAW,
                                 audioBlob        IN BLOB,
                                 attributes       IN OUT NOCOPY CLOB,
                                 mimeType         OUT VARCHAR2,
                                  format           IN OUT VARCHAR2,
                                 encoding         OUT VARCHAR2,
                                 numberOfChannels OUT INTEGER,
                                 samplingRate     OUT INTEGER,
                                 sampleSize       OUT INTEGER,
                                 compressionType  OUT VARCHAR2,
                                 audioDuration    OUT INTEGER),
 --
  STATIC PROCEDURE getProperties(ctx            IN OUT RAW,
                                 audioBfile     IN OUT NOCOPY BFILE,
                                 attributes     IN OUT NOCOPY CLOB,
                                 format            IN VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx                IN OUT RAW,
                                 audioBfile         IN OUT NOCOPY BFILE,
                                 attributes         IN OUT NOCOPY CLOB,
                                 mimeType         OUT VARCHAR2,
                                 format           IN OUT VARCHAR2,
                                 encoding         OUT VARCHAR2,
                                 numberOfChannels OUT INTEGER,
                                 samplingRate     OUT INTEGER,
                                 sampleSize       OUT INTEGER,
                                 compressionType  OUT VARCHAR2,
                                 audioDuration    OUT INTEGER)
);
show errors;
